package ehl_test

import (
	"testing"

	"review.coreboot.org/coreboot.git/util/intelp2m/config/p2m"
	"review.coreboot.org/coreboot.git/util/intelp2m/platforms/common"
	"review.coreboot.org/coreboot.git/util/intelp2m/platforms/test"
)

func TestGenMacro(t *testing.T) {
	p2m.Config.Platform = p2m.Elkhart
	test.Suite{
		{
			Pad: test.Pad{ID: "GPIO_1", DW0: 0x11111111, DW1: 0x11111111, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_1, DN_20K, PWROK, NF4, Tx1RxDCRx1, DISPUPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_1, PAD_FUNC(NF4) | PAD_IRQ_ROUTE(IOAPIC) | PAD_BUF(TX_DISABLE) | (1 << 28) | 1, PAD_PULL(DN_20K) | PAD_IOSSTATE(Tx1RxDCRx1) | PAD_IOSTERM(DISPUPD) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_2", DW0: 0x22222222, DW1: 0x22222222, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_2, 0, PWROK, UP_1K_5K_20K, HIZCRx1, ENPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_2, PAD_FUNC(GPIO) | PAD_TRIG(EDGE_SINGLE) | PAD_IRQ_ROUTE(NMI) | PAD_BUF(RX_DISABLE) | (1 << 29) | (1 << 1), PAD_CFG1_TOL_1V8PAD_PULL(UP_1K_5K_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPD)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_3", DW0: 0x44444444, DW1: 0x44444444, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE(GPIO_3, DN_1K, DEEP, NF1, Tx0RxDCRx0),",
				Long:  "_PAD_CFG_STRUCT(GPIO_3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_IRQ_ROUTE(SMI), PAD_PULL(DN_1K) | PAD_IOSSTATE(Tx0RxDCRx0) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_4", DW0: 0x88888888, DW1: 0x88888888, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE(GPIO_4, DN_5K, PLTRST, NF2, Tx0RxDCRx1),",
				Long:  "_PAD_CFG_STRUCT(GPIO_4, PAD_FUNC(NF2) | PAD_RESET(PLTRST) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT), PAD_PULL(DN_5K) | PAD_IOSSTATE(Tx0RxDCRx1)),",
			},
		},
	}.Run(t, "INTEL-ELKHART-LAKE-PCH/SLIDING-ONE-IN-NIBBLE-TEST")
	test.Suite{
		{
			Pad: test.Pad{ID: "GPIO_5", DW0: 0xEEEEEEEE, DW1: 0xEEEEEEEE, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_5, UP_1K_5K, RSMRST, NF3, ERROR, ENPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_5, PAD_FUNC(NF3) | PAD_RESET(RSMRST) | PAD_TRIG(EDGE_BOTH) | PAD_IRQ_ROUTE(SCI) | PAD_IRQ_ROUTE(SMI) | PAD_IRQ_ROUTE(NMI) | PAD_RX_POL(INVERT) | PAD_BUF(RX_DISABLE) | (1 << 29) | (1 << 1), PAD_CFG1_TOL_1V8PAD_PULL(UP_1K_5K) | PAD_IOSSTATE(ERROR) | PAD_IOSTERM(ENPD) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_6", DW0: 0xDDDDDDDD, DW1: 0xDDDDDDDD, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_6, ERROR, RSMRST, NF7, HIZCRx0, DISPUPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_6, PAD_FUNC(NF7) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_IRQ_ROUTE(IOAPIC) | PAD_IRQ_ROUTE(SCI) | PAD_IRQ_ROUTE(SMI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 28) | 1, PAD_PULL(ERROR) | PAD_IOSSTATE(HIZCRx0) | PAD_IOSTERM(DISPUPD)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_7", DW0: 0xBBBBBBBB, DW1: 0xBBBBBBBB, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_7, UP_5K_20K, PLTRST, NF6, ERROR, ENPU),",
				Long:  "_PAD_CFG_STRUCT(GPIO_7, PAD_FUNC(NF6) | PAD_RESET(PLTRST) | PAD_TRIG(EDGE_SINGLE) | PAD_IRQ_ROUTE(IOAPIC) | PAD_IRQ_ROUTE(SCI) | PAD_IRQ_ROUTE(NMI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_RX_DISABLE) | (1 << 29) | (1 << 28) | (1 << 1) | 1, PAD_CFG1_TOL_1V8PAD_PULL(UP_5K_20K) | PAD_IOSSTATE(ERROR) | PAD_IOSTERM(ENPU) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_8", DW0: 0x77777777, DW1: 0x77777777, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_8, UP_1K_20K, DEEP, NF5, ERROR, ENPU),",
				Long:  "_PAD_CFG_STRUCT(GPIO_8, PAD_FUNC(NF5) | PAD_RESET(DEEP) | PAD_TRIG(EDGE_BOTH) | PAD_IRQ_ROUTE(IOAPIC) | PAD_IRQ_ROUTE(SMI) | PAD_IRQ_ROUTE(NMI) | PAD_BUF(TX_RX_DISABLE) | (1 << 29) | (1 << 28) | (1 << 1) | 1, PAD_CFG1_TOL_1V8PAD_PULL(UP_1K_20K) | PAD_IOSSTATE(ERROR) | PAD_IOSTERM(ENPU)),",
			},
		},
	}.Run(t, "INTEL-ELKHART-LAKE-PCH/SLIDING-ZERO-IN-NIBBLE-TEST")
	test.Suite{
		{
			Pad: test.Pad{ID: "GPIO_9", DW0: 0x33333333, DW1: 0x33333333, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_9, UP_20K, PWROK, NF4, ERROR, ENPU),",
				Long:  "_PAD_CFG_STRUCT(GPIO_9, PAD_FUNC(NF4) | PAD_TRIG(EDGE_SINGLE) | PAD_IRQ_ROUTE(IOAPIC) | PAD_IRQ_ROUTE(NMI) | PAD_BUF(TX_RX_DISABLE) | (1 << 29) | (1 << 28) | (1 << 1) | 1, PAD_CFG1_TOL_1V8PAD_PULL(UP_20K) | PAD_IOSSTATE(ERROR) | PAD_IOSTERM(ENPU) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_10", DW0: 0x66666666, DW1: 0x66666666, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_10, UP_1K, DEEP, NF1, TxDRxE, ENPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(EDGE_BOTH) | PAD_IRQ_ROUTE(SMI) | PAD_IRQ_ROUTE(NMI) | PAD_BUF(RX_DISABLE) | (1 << 29) | (1 << 1), PAD_CFG1_TOL_1V8PAD_PULL(UP_1K) | PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(ENPD)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_11", DW0: 0xCCCCCCCC, DW1: 0xCCCCCCCC, Ownership: common.Driver},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE(GPIO_11, ERROR, RSMRST, NF3, Tx1RxDCRx0),",
				Long:  "_PAD_CFG_STRUCT(GPIO_11, PAD_FUNC(NF3) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_IRQ_ROUTE(SCI) | PAD_IRQ_ROUTE(SMI) | PAD_RX_POL(INVERT), PAD_PULL(ERROR) | PAD_IOSSTATE(Tx1RxDCRx0) | PAD_CFG_OWN_GPIO(DRIVER)),",
			},
		},
		{
			Pad: test.Pad{ID: "GPIO_12", DW0: 0x99999999, DW1: 0x99999999, Ownership: common.Acpi},
			Macro: test.Macro{
				Short: "PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_12, ERROR, PLTRST, NF6, Tx1RxE, DISPUPD),",
				Long:  "_PAD_CFG_STRUCT(GPIO_12, PAD_FUNC(NF6) | PAD_RESET(PLTRST) | PAD_IRQ_ROUTE(IOAPIC) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 28) | 1, PAD_PULL(ERROR) | PAD_IOSSTATE(Tx1RxE) | PAD_IOSTERM(DISPUPD)),",
			},
		},
	}.Run(t, "INTEL-ELKHART-LAKE-PCH/SLIDING-ONE-ONE-IN-NIBBLE-TEST")
}
