<!--
SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
SPDX-License-Identifier: BSD-2-Clause
-->

# Changelog

All notable changes to the hexer project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.0.7] - 2025-08-17

### Fixes

- fix the build with e.g. GCC 15 by telling the compiler we use C99 features

### Additions

- start some `MkDocs` documentation
- start a Python-based suite of unit tests, currently testing almost nothing:
  a trivial `hexer` startup and a single editing command

### Other changes

- switch to SPDX copyright and license tags

## [1.0.6] - 2020-04-24

### Fixes

- add a missing "extern" for a variable in a header file
- fix some C compiler warnings

## [1.0.5] - 2018-09-22

### Fixes

- correct some typographical and grammatical errors
- exit with status 0 if -h/--help is specified
- output the usage message to the standard error stream if
  an invalid command-line option is specified
- move the terminal initialization a bit later in the processing
  of the command-line options to avoid spurious output when
  usage, version, or features information is requested

### Additions

- add the -V/--version command-line option
- add the -F/--features command-line option

### Other changes

- drop the commented-out code for testing and implementing
  functions expected in a POSIX environment as warned in
  version 1.0.0, namely strcmp(), strcasecmp(), memmove(),
  strerror(), and the float.h header file

## [1.0.4] - 2018-03-24

### Fixes

- allow hexer to be cross-built: if CC_FOR_BUILD is defined in
  the build environment, use it as the command to build bin2c as
  submitted by [Helmut Grohne][contrib-helmut].
- fix undefined behavior by shifting an unsigned, not a signed,
  value the maximum number of bits to the left.

## [1.0.3] - 2016-10-16

### Fixes

- correct a couple of grammatical nits in the README file.

## [1.0.2] - 2016-10-13

### Fixes

- correct some more typographical errors reported by
  [Jakub Wilk][contrib-jwilk]

## [1.0.1] - 2016-10-12

### Fixes

- update the date in the manual page for the typographical
  errors fixed in 1.0.0.
- add the year 2016 to the copyright notices of the changed files

## [1.0.0] - 2016-10-12

### Fixes

- most of the following portability fixes were prompted by
  build failure reports on FreeBSD by
  [Anastasios Mageirias][contrib-anastasios]
- drop support for ancient compilers that do not support
  the "const" keyword or do not provide the alloca() function
- fix the build on systems that do not need or have alloca.h and
  rename the NEED_ALLOCA_H configuration setting to HAVE_ALLOCA_H
- fix an overzealous double const
- add a Makefile rule for the compilation of C files for
  make(1) implementations that do not pass CPPFLAGS.
- clarify a README comment about the unpacked subdirectory
- drop the HAVE_NCURSES configuration setting, the support for
  changing the foreground and background color is autodetected
- drop the bundled termlib implementation, require termcap support
- drop the stubs for old-style termio support, the hexer code only
  works with termios anyway
- drop the config.* files and autogenerate config.h
- fix the build of the myc command-line calculator
- assume a POSIX environment and declare some of the configuration
  settings as deprecated; no tests are done for them, and
  the deactivated tests will be removed in a future Hexer release
- correct some typographical and hyphenation errors

## [0.2.3] - 2015-12-10

### Fixes

- build with large file support on Linux
- clear the line after the cursor position on exit and suspend
- fix some more typographical errors
  (reported by [Jakub Wilk][contrib-jwilk])

## [0.2.2] - 2015-12-10

### Fixes

- reset the terminal color attributes on exit
  (reported by [Jakub Wilk][contrib-jwilk])
- also reset the attributes on suspend (Ctrl-Z) and restore
  them on resume

## [0.2.1] - 2015-12-10

### Fixes

- fix some more typographical errors
- abort on memory allocation failures (malloc(), realloc(),
  strdup())

## [0.2.0] - 2015-12-09

### Fixes

- fix a lot of C compiler warnings
- provide a better vasprintf() simulation to fix a display bug
- use sigemptyset() instead of a direct assignment to sigset_t
  (reported by [Daniel Schepler][contrib-dschepler])
- handle short reads/writes and read/write errors
- fix a signed/unsigned char bug when reading the swapfile
- merge early when marking screen lines for refreshing
  (reported by [Jonathan Neuschäfer][contrib-j-neuschaefer])
- let the editor use the `HE_DEFAULT_PAGER` value from defs.h as
  a last-resort fallback (nothing in the environment, etc)
  (reported by [Jakub Wilk][contrib-jwilk])
- allow the default pager value to be overridden at build time
  (reported by [Jakub Wilk][contrib-jwilk])

### Other changes

- remove some unused functions
- simplify exh_save_buffer(): it's only used on the whole file
- declare some functions as printf-like
- bump the year on my copyright notice

## [0.1.8] - 2014-09-11

### Fixes

- fix a crash when inserting or replacing a half-byte
  Thanks, [Thibaut Girka][contrib-thib]
- use CPPFLAGS and LDFLAGS as appropriate during the build
- create the destination directories during the installation
- bump the year of my copyright notice on files changed in 2014

## [0.1.7] - 2011-07-13

### Fixes

- fix searching for characters with a code point above 127
  Reported by: [Michael Gold][contrib-mgold] in Debian bug #633508
- bump the year of my copyright notice on files changed in 2011

## [0.1.6] - 2010-12-29

### Fixes

- fix some errors and warnings detected by cppcheck:
    - bin2c.c, buffer.c, commands.c, hexer.c - file descriptor leaks
    - calc.c - a buffer overflow with an overlong command line
    - main.c - suppress a false positive about a global pointer
    - regex.c - note that I've been aware of the negative array index
      problem ever since I first looked at the hexer source code and
      tried to build it with a raised compiler warning level :)
- bump the year of my copyright notice on files changed in 2010
- fix a "calcualtor" typo in comments in calc.c and exh.c

### Additions

- add a TODO list inspired by the cppcheck results

## [0.1.5] - 2009-09-04

### Fixes

- remove the "bdir" and "ef" settings from the Vim modelines to
  make them actually acceptable to today's Vim
- bring config.linux up to date
- clean up the header files:
    - remove "extern" before the function prototypes
    - declare all the hexer functions and variables used by
      other modules
    - add several header files so that all hexer functions and
      variables are declared
    - use ANSI prototypes for all functions
    - let the prototypes for some functions catch up with reality
- clean up the source files:
    - remove the "extern" definitions for the standard C library
      functions - just include the header files instead
    - replace the "extern" definitions for hexer functions and
      variables with the appropriate includes
    - fix various C compiler warnings
    - fix some function definitions and calls to match the prototypes
    - convert all functions to ANSI C prototypes
    - remove a couple of redundant declarations of functions and vars
    - rename several variables to avoid collisions
    - check the result status of various I/O functions
- clean up the Makefile:
    - allow the user to override most of the variables
    - no need to ignore the result of "rm -f" :)
    - use CFLAGS when building bin2c
    - do not try to follow dependencies for termlib.c
    - simplify the "install" target and honor DESTDIR if set
- rename the `KEY_*` constants to `HXKEY_*` to avoid conflicts with
  the curses header files
- add an `hx_` prefix to the `lines`, `columns`, and
  `insert_character` variables for the same reason
- garbage-collect some unused functions
- fix the manual page syntax:
    - fix the comment markers
    - mark the hyphens as such where needed
- remove some hyphenation in the help text
- link with the math library for pow(3) used in the calculator
- rename the TERMCAP and TERMLIB Makefile variables to LTERMCAP
  and LTERMLIB; the TERMCAP environment variable is actually
  defined in some environments, and it is definitely not
  a linker library specification!
- fix a case of undefined behavior in tio.c: the v*printf()
  routines may NOT be called a second time with the same
  varargs list!  Add a HAVE_VASPRINTF definition and enable it
  on Linux systems; it is also available on modern BSD's, but
  the config.bsd file needs a lot of updating anyway.
  Reported by: Michael Gold <mgold@ncf.ca> in Debian bug #540571
- add a HAVE_MEMMOVE definition to the config files; buffer.c and
  regex.c already test for it

### Additions

- add a config.posix file to reflect a modern POSIX-like system
- add a HAVE_STRERROR definition to the config files and roll out
  our own strerror() function if needed

### Other changes

- taken over by Peter Pentchev <roam@ringlet.net>
- remove most of the settings from the Vim modelines
- switch the Makefile to use curses by default

## [0.1.4c]

### Released

- the last version released by Sascha Demetrio <demetrio@cs.uni-sb.de>

[Unreleased]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.7...main
[1.0.7]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.6...release%2F1.0.7
[1.0.6]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.5...release%2F1.0.6
[1.0.5]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.4...release%2F1.0.5
[1.0.4]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.3...release%2F1.0.4
[1.0.3]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.2...release%2F1.0.3
[1.0.2]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.1...release%2F1.0.2
[1.0.1]: https://gitlab.com/hexer/hexer/-/compare/release%2F1.0.0...release%2F1.0.1
[1.0.0]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.2.3...release%2F1.0.0
[0.2.3]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.2.2...release%2F0.2.3
[0.2.2]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.2.1...release%2F0.2.2
[0.2.1]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.2.0...release%2F0.2.1
[0.2.0]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.1.8...release%2F0.2.0
[0.1.8]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.1.7...release%2F0.1.8
[0.1.7]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.1.6...release%2F0.1.7
[0.1.6]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.1.5...release%2F0.1.6
[0.1.5]: https://gitlab.com/hexer/hexer/-/compare/release%2F0.1.4c...release%2F0.1.5
[0.1.4c]: https://gitlab.com/hexer/hexer/-/tags/release%2F0.1.4c

[contrib-helmut]: mailto:helmut@subdivi.de "Helmut Grohne"
[contrib-jwilk]: mailto:jwilk@debian.org "Jakub Wilk"
[contrib-anastasios]: mailto:anastasios@mageirias.com "Anastasios Mageirias"
[contrib-dschepler]: mailto:dschepler@gmail.com "Daniel Schepler"
[contrib-j-neuschaefer]: mailto:j.neuschaefer@gmx.net "Jonathan Neuschäfer"
[contrib-thib]: mailto:thib@sitedethib.com "Thibaut Girka"
[contrib-mgold]: mailto:mgold@ncf.ca "Michael Gold"
