import socket
from k5test import *

realm = K5Realm()

# CVE-2021-36222 KDC null dereference on encrypted challenge preauth
# without FAST

s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
a = (hostname, realm.portbase)

m = ('6A81A0' '30819D'          # [APPLICATION 10] SEQUENCE
     'A103' '0201' '05'         #  [1] pvno = 5
     'A203' '0201' '0A'         #  [2] msg-type = 10
     'A30E' '300C'              #  [3] padata = SEQUENCE OF
     '300A'                     #   SEQUENCE
     'A104' '0202' '008A'       #    [1] padata-type = PA-ENCRYPTED-CHALLENGE
     'A202' '0400'              #    [2] padata-value = ""
     'A48180' '307E'            #  [4] req-body = SEQUENCE
     'A007' '0305' '0000000000' #   [0] kdc-options = 0
     'A120' '301E'              #   [1] cname = SEQUENCE
     'A003' '0201' '01'         #    [0] name-type = NT-PRINCIPAL
     'A117' '3015'              #    [1] name-string = SEQUENCE-OF
     '1B06' '6B7262746774'      #     krbtgt
     '1B0B' '4B5242544553542E434F4D'
                                #     KRBTEST.COM
     'A20D' '1B0B' '4B5242544553542E434F4D'
                                #   [2] realm = KRBTEST.COM
     'A320' '301E'              #   [3] sname = SEQUENCE
     'A003' '0201' '01'         #    [0] name-type = NT-PRINCIPAL
     'A117' '3015'              #    [1] name-string = SEQUENCE-OF
     '1B06' '6B7262746774'      #     krbtgt
     '1B0B' '4B5242544553542E434F4D'
                                #     KRBTEST.COM
     'A511' '180F' '31393934303631303036303331375A'
                                #   [5] till = 19940610060317Z
     'A703' '0201' '00'         #   [7] nonce = 0
     'A808' '3006'              #   [8] etype = SEQUENCE OF
     '020112' '020111')         #    aes256-cts aes128-cts

s.sendto(bytes.fromhex(m), a)

# Make sure kinit still works.
realm.kinit(realm.user_princ, password('user'))

success('CVE-2021-36222 regression test')
