/* $Id: PssmWithParameters.hpp 108737 2007-08-13 15:08:28Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PssmWithParameters.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: PssmWithParameters_.hpp


#ifndef OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_HPP
#define OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_HPP


// generated includes
#include <objects/scoremat/PssmWithParameters_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CSeq_entry;

/////////////////////////////////////////////////////////////////////////////
class NCBI_SCOREMAT_EXPORT CPssmWithParameters : public CPssmWithParameters_Base
{
    typedef CPssmWithParameters_Base Tparent;
public:
    // constructor
    CPssmWithParameters(void);
    // destructor
    ~CPssmWithParameters(void);

    /// Has this PSSM a query in it?
    bool HasQuery() const;
    /// Retrieve the query sequence
    const CSeq_entry& GetQuery() const;
    /// Retrieve the query sequence
    CSeq_entry& SetQuery();

private:
    // Prohibit copy constructor and assignment operator
    CPssmWithParameters(const CPssmWithParameters& value);
    CPssmWithParameters& operator=(const CPssmWithParameters& value);

};

/////////////////// CPssmWithParameters inline methods

// constructor
inline
CPssmWithParameters::CPssmWithParameters(void)
{
}

/////////////////// end of CPssmWithParameters inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_HPP
/* Original file checksum: lines: 86, chars: 2593, CRC32: 767e2e1 */
