/* $Id: SeqTable_multi_data.hpp 457991 2015-01-29 19:26:03Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_multi_data.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: SeqTable_multi_data_.hpp


#ifndef OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_HPP


// generated includes
#include <objects/seqtable/SeqTable_multi_data_.hpp>

#include <serial/objhook.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


class CIntDeltaSumCache;


/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_multi_data : public CSeqTable_multi_data_Base
{
    typedef CSeqTable_multi_data_Base Tparent;
public:
    // constructor
    CSeqTable_multi_data(void);
    // destructor
    ~CSeqTable_multi_data(void);

    size_t GetSize(void) const;

    // return true if there is a value at the row
    bool IsSet(size_t row_index) const {
        return row_index < GetSize();
    }

    // return equivalent simpler variant:
    // e_Bit      - bool
    // e_Int      - any integer that fits in Int4
    // e_Int8     - integer that fits in Int8
    // e_Real     - floating point value
    // e_String   - string
    // e_Bytes    - char/byte vector
    // e_Loc      - CSeq_loc
    // e_Id       - CSeq_id
    // e_Interval - CSeq_interval
    // e_notset   - no data
    E_Choice GetValueType(void) const;

    // return true if the value is convertible to integer value (any size).
    // Bool, Int, Int1, Int2, Int8 are all integer types.
    // This includes special representations:
    // bvector for 1-bit values, scaled integers, delta encoding.
    bool CanGetInt(void) const;

    // return true if the value is convertible to double value.
    // This includes special representation: scaled values.
    bool CanGetReal(void) const;

    // return size (sizeof) of integer value to store data from any row,
    // or zero if the data is not convertible to integer value.
    // Bool, Int, Int1, Int2, Int8 are all integer types.
    // This includes special representations:
    // bvector for 1-bit values, scaled integers, delta encoding.
    size_t GetIntSize(void) const;

    // get bool value for the row, return false if there is no a value
    bool TryGetBool(size_t row, bool& v) const;

    // get double value for the row, return false if there is no a value
    bool TryGetReal(size_t row, double& v) const;

    // get Int1 value for the row, return false if there is no a value
    bool TryGetInt1(size_t row, Int1& v) const;
    bool TryGetInt1WithRounding(size_t row, Int1& v) const;
    // get Int2 value for the row, return false if there is no a value
    bool TryGetInt2(size_t row, Int2& v) const;
    bool TryGetInt2WithRounding(size_t row, Int2& v) const;
    // get Int4 value for the row, return false if there is no a value
    bool TryGetInt4(size_t row, Int4& v) const;
    bool TryGetInt4WithRounding(size_t row, Int4& v) const;
    // get Int8 value for the row, return false if there is no a value
    bool TryGetInt8(size_t row, Int8& v) const;
    bool TryGetInt8WithRounding(size_t row, Int8& v) const;

    // for plain int (=Int4)
    bool TryGetInt(size_t row, int& v) const {
        return TryGetInt4(row, v);
    }
    bool TryGetIntWithRounding(size_t row, int& v) const {
        return TryGetInt4WithRounding(row, v);
    }

    // get pointer to a string value for the row, or null if there is none
    const string* GetStringPtr(size_t row) const;
    // get pointer to a byte vector value for the row, or null if there is none
    typedef vector<char> TBytesValue;
    const TBytesValue* GetBytesPtr(size_t row) const;

    // overloaded methods for use in templates
    bool TryGetValue(size_t row, Int1& v) const {
        return TryGetInt1(row, v);
    }
    bool TryGetValue(size_t row, Int2& v) const {
        return TryGetInt2(row, v);
    }
    bool TryGetValue(size_t row, Int4& v) const {
        return TryGetInt4(row, v);
    }
    bool TryGetValue(size_t row, Int8& v) const {
        return TryGetInt8(row, v);
    }
    bool TryGetValue(size_t row, bool& v) const {
        return TryGetBool(row, v);
    }
    bool TryGetValue(size_t row, double& v) const {
        return TryGetReal(row, v);
    }
    bool TryGetValue(size_t row, string& v) const {
        if ( const string* ptr = GetStringPtr(row) ) {
            v = *ptr;
            return true;
        }
        return false;
    }
    bool TryGetValue(size_t row, TBytesValue& v) const {
        if ( const TBytesValue* ptr = GetBytesPtr(row) ) {
            v = *ptr;
            return true;
        }
        return false;
    }

    // reserve memory for multi-row data vectors
    class NCBI_SEQ_EXPORT CReserveHook : public CPreReadChoiceVariantHook
    {
        virtual void PreReadChoiceVariant(CObjectIStream& in,
                                          const CObjectInfoCV& variant);
    };
    
    // change the representation of data
    void ChangeTo(E_Choice type);
    void ChangeToBit(void); // convert int data with values 0/1 to bits
    void ChangeToBit_bvector(void);
    void ChangeToInt1(void);
    void ChangeToInt2(void);
    void ChangeToInt4(void);
    void ChangeToInt8(void);
    void ChangeToInt(void) {
        ChangeToInt4();
    }
    void ChangeToInt_delta(void);
    void ChangeToInt_scaled(int mul, int add);
    void ChangeToReal(void);
    void ChangeToReal_scaled(double mul, double add);
    void ChangeToString(const string* omitted_value = 0);
    void ChangeToCommon_string(const string* omit_value = 0);
    void ChangeToBytes(const TBytesValue* omitted_value = 0);
    void ChangeToCommon_bytes(const TBytesValue* omit_value = 0);

    // Overload base ResetSelection() to reset extra data fields
    void ResetSelection(void) {
        x_ResetCache();
        Tparent::ResetSelection();
    }

    void PostRead(void) {
        x_ResetCache();
    }

protected:

    bool x_TryGetInt8(size_t row, Int8& v, const char* type_name) const;

    void x_ResetCache(void);

    CIntDeltaSumCache& x_GetIntDeltaCache(void) const;

    mutable CRef<CIntDeltaSumCache> m_Cache;

private:
    // Prohibit copy constructor and assignment operator
    CSeqTable_multi_data(const CSeqTable_multi_data& value);
    CSeqTable_multi_data& operator=(const CSeqTable_multi_data& value);

};

/////////////////// CSeqTable_multi_data inline methods

/////////////////// end of CSeqTable_multi_data inline methods


NCBISER_HAVE_GLOBAL_READ_VARIANT_HOOK(CSeqTable_multi_data, "*",
                                      new CSeqTable_multi_data::CReserveHook)

NCBISER_HAVE_POST_READ(CSeqTable_multi_data)


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_HPP
