#
# Provision an SSL keypair using what's already generated in:
# /etc/ssl/private/ssl-cert-snakeoil.key (private key) and
# /etc/ssl/certs/ssl-cert-snakeoil.pem (public cert).
#
# The result will be /etc/<service_name>/ssl/<private|public>/<FQDN>.<key|pem>
# 
define oci::sslkeypair(
  $notify_service_name = 'httpd',
  $require_anchor      = undef,
){
    if $facts['networking']['fqdn'] {
      $fqdn = $facts['networking']['fqdn']
    }else{
      $fqdn = $::fqdn
    }

    if $require_anchor {
      $require_anchor_real = $require_anchor
    }else{
      $require_anchor_real = Anchor["${name}::install::end"]
    }

    File['/etc/ssl/private/ssl-cert-snakeoil.key'] -> File["/etc/${name}/ssl/private/${fqdn}.pem"]
    File['/etc/ssl/certs/ssl-cert-snakeoil.pem']   -> File["/etc/${name}/ssl/public/${fqdn}.crt"]

    file { "/etc/${name}/ssl":
      ensure                  => directory,
      owner                   => 'root',
      mode                    => '0755',
      selinux_ignore_defaults => true,
      require                 => $require_anchor_real,
    }->
    file { "/etc/${name}/ssl/private":
      ensure                  => directory,
      owner                   => 'root',
      mode                    => '0755',
      selinux_ignore_defaults => true,
    }->
    file { "/etc/${name}/ssl/public":
      ensure                  => directory,
      owner                   => 'root',
      mode                    => '0755',
      selinux_ignore_defaults => true,
    }->
    file { "/etc/${name}/ssl/private/${fqdn}.pem":
      ensure                  => present,
      owner                   => "${name}",
      source                  => "/etc/ssl/private/ssl-cert-snakeoil.key",
      selinux_ignore_defaults => true,
      mode                    => '0600',
    }->
    file { "/etc/${name}/ssl/public/${fqdn}.crt":
      ensure                  => present,
      owner                   => "${name}",
      source                  => '/etc/ssl/certs/ssl-cert-snakeoil.pem',
      selinux_ignore_defaults => true,
      mode                    => '0644',
      notify                  => Service[$notify_service_name],
    }
}
