# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AlternativeRouteType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AlternativeRouteType."""

    ANY_ROUTE = "anyRoute"
    """Allow any alternative route to be returned irrespective of how it compares to the reference
    route in terms of optimality."""
    BETTER_ROUTE = "betterRoute"
    """Return an alternative route only if it is better than the reference route according to the
    given planning criteria."""


class ComputeTravelTime(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ComputeTravelTime."""

    NONE = "none"
    """Does not compute additional travel times."""
    ALL = "all"
    """Computes travel times for all types of traffic information and specifies all results in the
    fields noTrafficTravelTimeInSeconds, historicTrafficTravelTimeInSeconds and
    liveTrafficIncidentsTravelTimeInSeconds being included in the summaries in the route response."""


class DelayMagnitude(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The magnitude of delay caused by the incident. These values correspond to the values of the
    response field ty of the `Get Traffic Incident Detail API
    <https://learn.microsoft.com/rest/api/maps/traffic/gettrafficincidentdetail>`_.
    """

    UNKNOWN = "0"
    """Unknown."""
    MINOR = "1"
    """Minor."""
    MODERATE = "2"
    """Moderate."""
    MAJOR = "3"
    """Major."""
    UNDEFINED = "4"
    """Undefined, used for road closures and other indefinite delays."""


class DrivingSide(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates left-hand vs. right-hand side driving at the point of the maneuver."""

    LEFT = "LEFT"
    """Left side."""
    RIGHT = "RIGHT"
    """Right side."""


class GeoJsonObjectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types - Point,
    MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection, Feature and
    FeatureCollection.
    """

    GEO_JSON_POINT = "Point"
    """``GeoJSON Point`` geometry."""
    GEO_JSON_MULTI_POINT = "MultiPoint"
    """``GeoJSON MultiPoint`` geometry."""
    GEO_JSON_LINE_STRING = "LineString"
    """``GeoJSON LineString`` geometry."""
    GEO_JSON_MULTI_LINE_STRING = "MultiLineString"
    """``GeoJSON MultiLineString`` geometry."""
    GEO_JSON_POLYGON = "Polygon"
    """``GeoJSON Polygon`` geometry."""
    GEO_JSON_MULTI_POLYGON = "MultiPolygon"
    """``GeoJSON MultiPolygon`` geometry."""
    GEO_JSON_GEOMETRY_COLLECTION = "GeometryCollection"
    """``GeoJSON GeometryCollection`` geometry."""
    GEO_JSON_FEATURE = "Feature"
    """``GeoJSON Feature`` object."""
    GEO_JSON_FEATURE_COLLECTION = "FeatureCollection"
    """``GeoJSON FeatureCollection`` object."""


class GuidanceInstructionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the instruction, e.g., turn or change of road form."""

    TURN = "TURN"
    """Turn."""
    ROAD_CHANGE = "ROAD_CHANGE"
    """Road Change."""
    LOCATION_DEPARTURE = "LOCATION_DEPARTURE"
    """Departure location."""
    LOCATION_ARRIVAL = "LOCATION_ARRIVAL"
    """Arrival location."""
    DIRECTION_INFO = "DIRECTION_INFO"
    """Direction information."""
    LOCATION_WAYPOINT = "LOCATION_WAYPOINT"
    """Way point location."""


class GuidanceManeuver(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A code identifying the maneuver."""

    ARRIVE = "ARRIVE"
    """You have arrived."""
    ARRIVE_LEFT = "ARRIVE_LEFT"
    """You have arrived. Your destination is on the left."""
    ARRIVE_RIGHT = "ARRIVE_RIGHT"
    """You have arrived. Your destination is on the right."""
    DEPART = "DEPART"
    """Leave."""
    STRAIGHT = "STRAIGHT"
    """Keep straight on."""
    KEEP_RIGHT = "KEEP_RIGHT"
    """Keep right."""
    BEAR_RIGHT = "BEAR_RIGHT"
    """Bear right."""
    TURN_RIGHT = "TURN_RIGHT"
    """Turn right."""
    SHARP_RIGHT = "SHARP_RIGHT"
    """Turn sharp right."""
    KEEP_LEFT = "KEEP_LEFT"
    """Keep left."""
    BEAR_LEFT = "BEAR_LEFT"
    """Bear left."""
    TURN_LEFT = "TURN_LEFT"
    """Turn left."""
    SHARP_LEFT = "SHARP_LEFT"
    """Turn sharp left."""
    MAKE_U_TURN = "MAKE_UTURN"
    """Make a U-turn."""
    ENTER_MOTORWAY = "ENTER_MOTORWAY"
    """Take the motorway."""
    ENTER_FREEWAY = "ENTER_FREEWAY"
    """Take the freeway."""
    ENTER_HIGHWAY = "ENTER_HIGHWAY"
    """Take the highway."""
    TAKE_EXIT = "TAKE_EXIT"
    """Take the exit."""
    MOTORWAY_EXIT_LEFT = "MOTORWAY_EXIT_LEFT"
    """Take the left exit."""
    MOTORWAY_EXIT_RIGHT = "MOTORWAY_EXIT_RIGHT"
    """Take the right exit."""
    TAKE_FERRY = "TAKE_FERRY"
    """Take the ferry."""
    ROUNDABOUT_CROSS = "ROUNDABOUT_CROSS"
    """Cross the roundabout."""
    ROUNDABOUT_RIGHT = "ROUNDABOUT_RIGHT"
    """At the roundabout take the exit on the right."""
    ROUNDABOUT_LEFT = "ROUNDABOUT_LEFT"
    """At the roundabout take the exit on the left."""
    ROUNDABOUT_BACK = "ROUNDABOUT_BACK"
    """Go around the roundabout."""
    TRY_MAKE_U_TURN = "TRY_MAKE_UTURN"
    """Try to make a U-turn."""
    FOLLOW = "FOLLOW"
    """Follow."""
    SWITCH_PARALLEL_ROAD = "SWITCH_PARALLEL_ROAD"
    """Switch to the parallel road."""
    SWITCH_MAIN_ROAD = "SWITCH_MAIN_ROAD"
    """Switch to the main road."""
    ENTRANCE_RAMP = "ENTRANCE_RAMP"
    """Take the ramp."""
    WAYPOINT_LEFT = "WAYPOINT_LEFT"
    """You have reached the waypoint. It is on the left."""
    WAYPOINT_RIGHT = "WAYPOINT_RIGHT"
    """You have reached the waypoint. It is on the right."""
    WAYPOINT_REACHED = "WAYPOINT_REACHED"
    """You have reached the waypoint."""


class InclineLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """InclineLevel."""

    LOW = "low"
    """low"""
    NORMAL = "normal"
    """normal"""
    HIGH = "high"
    """high"""


class JsonFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """JsonFormat."""

    JSON = "json"
    """`The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_"""


class JunctionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the junction where the maneuver takes place. For larger roundabouts, two separate
    instructions are generated for entering and leaving the roundabout.
    """

    REGULAR = "REGULAR"
    """regular"""
    ROUNDABOUT = "ROUNDABOUT"
    """roundabout"""
    BIFURCATION = "BIFURCATION"
    """bifurcation"""


class Report(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Report."""

    EFFECTIVE_SETTINGS = "effectiveSettings"
    """Reports the effective parameters or data used when calling the API."""


class ResponseFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ResponseFormat."""

    JSON = "json"
    """`The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_"""
    XML = "xml"
    """`The Extensible Markup Language <https://www.w3.org/TR/xml/>`_"""


class ResponseSectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Section types of the reported route response."""

    CAR_OR_TRAIN = "CAR_TRAIN"
    """Sections of the route that are cars or trains."""
    COUNTRY = "COUNTRY"
    """Sections indicating which countries the route is in."""
    FERRY = "FERRY"
    """Sections of the route that are ferries."""
    MOTORWAY = "MOTORWAY"
    """Sections of the route that are motorways."""
    PEDESTRIAN = "PEDESTRIAN"
    """Sections of the route that are only suited for pedestrians."""
    TOLL_ROAD = "TOLL_ROAD"
    """Sections of the route that require a toll to be payed."""
    TOLL_VIGNETTE = "TOLL_VIGNETTE"
    """Sections of the route that require a toll vignette to be present."""
    TRAFFIC = "TRAFFIC"
    """Sections of the route that contain traffic information."""
    TRAVEL_MODE = "TRAVEL_MODE"
    """Sections in relation to the request parameter ``travelMode``."""
    TUNNEL = "TUNNEL"
    """Sections of the route that are tunnels."""
    CARPOOL = "CARPOOL"
    """Sections of the route that require use of carpool (HOV/High Occupancy Vehicle) lanes."""
    URBAN = "URBAN"
    """Sections of the route that are located within urban areas."""


class ResponseTravelMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Travel mode for the calculated route. The value will be set to ``other`` if the requested mode
    of transport is not possible in this section.
    """

    CAR = "car"
    """The returned routes are optimized for cars."""
    TRUCK = "truck"
    """The returned routes are optimized for commercial vehicles, like for trucks."""
    TAXI = "taxi"
    """The returned routes are optimized for taxis. BETA functionality."""
    BUS = "bus"
    """The returned routes are optimized for buses, including the use of bus only lanes. BETA
    functionality."""
    VAN = "van"
    """The returned routes are optimized for vans. BETA functionality."""
    MOTORCYCLE = "motorcycle"
    """The returned routes are optimized for motorcycles. BETA functionality."""
    BICYCLE = "bicycle"
    """The returned routes are optimized for bicycles, including use of bicycle lanes."""
    PEDESTRIAN = "pedestrian"
    """The returned routes are optimized for pedestrians, including the use of sidewalks."""
    OTHER = "other"
    """The given mode of transport is not possible in this section"""


class RouteAvoidType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RouteAvoidType."""

    TOLL_ROADS = "tollRoads"
    """Avoids toll roads."""
    MOTORWAYS = "motorways"
    """Avoids motorways"""
    FERRIES = "ferries"
    """Avoids ferries"""
    UNPAVED_ROADS = "unpavedRoads"
    """Avoids unpaved roads"""
    CARPOOLS = "carpools"
    """Avoids routes that require the use of carpool (HOV/High Occupancy Vehicle) lanes."""
    ALREADY_USED_ROADS = "alreadyUsedRoads"
    """Avoids using the same road multiple times. Most useful in conjunction with ``routeType``\\
    =thrilling."""
    BORDER_CROSSINGS = "borderCrossings"
    """Avoids border crossings in route calculation."""


class RouteInstructionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RouteInstructionsType."""

    CODED = "coded"
    """Returns raw instruction data without human-readable messages."""
    TEXT = "text"
    """Returns raw instructions data with human-readable messages in plain text."""
    TAGGED = "tagged"
    """Returns raw instruction data with tagged human-readable messages to permit formatting. A
    human-readable message is built up from repeatable identified elements. These are tagged to
    allow client applications to format them correctly. The following message components are tagged
    when instructionsType=tagged: street, roadNumber, signpostText, exitNumber,
    roundaboutExitNumber.
    
    Example of tagged 'Turn left' message:
    
    .. code-block::
    
       Turn left onto <roadNumber>A4</roadNumber>/<roadNumber>E19</roadNumber>
       towards <signpostText>Den Haag</signpostText>"""


class RouteRepresentationForBestOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RouteRepresentationForBestOrder."""

    POLYLINE = "polyline"
    """Includes route geometry in the response."""
    SUMMARY_ONLY = "summaryOnly"
    """Summary as per polyline but excluding the point geometry elements for the routes in the
    response."""
    NONE = "none"
    """Includes only the optimized waypoint indices but does not include the route geometry in the
    response."""


class RouteType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RouteType."""

    FASTEST = "fastest"
    """The fastest route."""
    SHORTEST = "shortest"
    """The shortest route by distance."""
    ECONOMY = "eco"
    """A route balanced by economy and speed."""
    THRILLING = "thrilling"
    """Includes interesting or challenging roads and uses as few motorways as possible. You can choose
    the level of turns included and also the degree of hilliness. See the hilliness and windingness
    parameters for how to set this. There is a limit of 900 km on routes planned with
    ``routeType``\\ =thrilling"""


class SectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SectionType."""

    CAR_OR_TRAIN = "carTrain"
    """Sections of the route that are cars or trains."""
    COUNTRY = "country"
    """Sections indicating which countries the route is in."""
    FERRY = "ferry"
    """Sections of the route that are ferries."""
    MOTORWAY = "motorway"
    """Sections of the route that are motorways."""
    PEDESTRIAN = "pedestrian"
    """Sections of the route that are only suited for pedestrians."""
    TOLL_ROAD = "tollRoad"
    """Sections of the route that require a toll to be payed."""
    TOLL_VIGNETTE = "tollVignette"
    """Sections of the route that require a toll vignette to be present."""
    TRAFFIC = "traffic"
    """Sections of the route that contain traffic information."""
    TRAVEL_MODE = "travelMode"
    """Sections in relation to the request parameter ``travelMode``."""
    TUNNEL = "tunnel"
    """Sections of the route that are tunnels."""
    CARPOOL = "carpool"
    """Sections of the route that require use of carpool (HOV/High Occupancy Vehicle) lanes."""
    URBAN = "urban"
    """Sections of the route that are located within urban areas."""


class SimpleCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the incident. Can currently be JAM, ROAD_WORK, ROAD_CLOSURE, or OTHER. See "tec" for
    detailed information.
    """

    JAM = "JAM"
    """Traffic jam."""
    ROAD_WORK = "ROAD_WORK"
    """Road work."""
    ROAD_CLOSURE = "ROAD_CLOSURE"
    """Road closure."""
    OTHER = "OTHER"
    """Other."""


class TravelMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TravelMode."""

    CAR = "car"
    """The returned routes are optimized for cars."""
    TRUCK = "truck"
    """The returned routes are optimized for commercial vehicles, like for trucks."""
    TAXI = "taxi"
    """The returned routes are optimized for taxis. BETA functionality."""
    BUS = "bus"
    """The returned routes are optimized for buses, including the use of bus only lanes. BETA
    functionality."""
    VAN = "van"
    """The returned routes are optimized for vans. BETA functionality."""
    MOTORCYCLE = "motorcycle"
    """The returned routes are optimized for motorcycles. BETA functionality."""
    BICYCLE = "bicycle"
    """The returned routes are optimized for bicycles, including use of bicycle lanes."""
    PEDESTRIAN = "pedestrian"
    """The returned routes are optimized for pedestrians, including the use of sidewalks."""


class VehicleEngineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VehicleEngineType."""

    COMBUSTION = "combustion"
    """Internal combustion engine."""
    ELECTRIC = "electric"
    """Electric engine."""


class VehicleLoadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VehicleLoadType."""

    US_HAZMAT_CLASS1 = "USHazmatClass1"
    """Explosives"""
    US_HAZMAT_CLASS2 = "USHazmatClass2"
    """Compressed gas"""
    US_HAZMAT_CLASS3 = "USHazmatClass3"
    """Flammable liquids"""
    US_HAZMAT_CLASS4 = "USHazmatClass4"
    """Flammable solids"""
    US_HAZMAT_CLASS5 = "USHazmatClass5"
    """Oxidizers"""
    US_HAZMAT_CLASS6 = "USHazmatClass6"
    """Poisons"""
    US_HAZMAT_CLASS7 = "USHazmatClass7"
    """Radioactive"""
    US_HAZMAT_CLASS8 = "USHazmatClass8"
    """Corrosives"""
    US_HAZMAT_CLASS9 = "USHazmatClass9"
    """Miscellaneous"""
    OTHER_HAZMAT_EXPLOSIVE = "otherHazmatExplosive"
    """Explosives"""
    OTHER_HAZMAT_GENERAL = "otherHazmatGeneral"
    """Miscellaneous"""
    OTHER_HAZMAT_HARMFUL_TO_WATER = "otherHazmatHarmfulToWater"
    """Harmful to water"""


class WindingnessLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WindingnessLevel."""

    LOW = "low"
    """low"""
    NORMAL = "normal"
    """normal"""
    HIGH = "high"
    """high"""
