(provide 'snd-peak-phases.scm)
(unless (defined? 'primes)
  (load "primes.scm"))

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)
;;; to translate these peaks into the more standard crest-factor, (/ (* peak (sqrt 2)) (sqrt N))
;;;   in the all harmonics case, these go from 1.356 (20) to 1.406 (106) leaving aside N<8
;;;   the square root => sqrt(2), so 1.414 is not good. 


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

(vector 1  1.0    #r(0))
(vector 2  1.76   #r(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots #r(-2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the first min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
(vector 3  2.1949383250709 #r(0 0 1)

     1.9798054823226 #r(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 #r(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 #r(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 #r(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall #r(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #r(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #r(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #r(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #r(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #r(0.0 1.4102202429311 1.6832728267862)

     ;; polynomial is surprisingly good:
     ;;  :all 3 #r(1.9797767193773 0.066455282926612 1.7863254855475)

     ;; big fft
     1.979806 #r(0.000000 0.410275 1.683332)
     )


;;; 4 all --------------------------------------------------------------------------------
(vector 4  2.2962718935302 #r(0 1 1 1)

     2.040  #r(0 33/35 67/50 10/9)               ;(vector 0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #r(0.000 0.072 0.674 1.912)
     2.04012799263 #r(0.000 0.928 1.326 1.088)
     2.04012799263 #r(0.000 1.072 0.674 0.912)
     2.04012799263 #r(0.000 1.928 1.326 0.088)

     2.0392323180235 #r(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #r(0.000000 0.944585 1.341508 1.115059)
     2.038954 #r(0.000000 1.055406 0.658486 0.884929)
     2.038954 #r(0.000000 0.055405 0.658485 1.884926)
     2.038954 #r(0.000000 1.944593 1.341515 0.115071)
 
     ;; :all 4 #r(2.060278672942 -0.70579973196553 0.90455920034382)
     ;; big fft
     2.039104 #r(0.000000 0.055486 0.658542 1.885004)
     2.039103 #r(0.000000 0.055488 0.658545 1.885009)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
(vector 5  2.5405211753511 #r(0 1 0 0 0)

     2.3434929847717 #r(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #r(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #r(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #r(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #r(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #r(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #r(0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 #r(0.000000 1.845332 1.664532 0.420369 1.593338)

     ;; pp:
     2.343485 #r(0.000000 1.154683 0.335509 0.579687 0.406716)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
(vector 6  2.8200183503167 #r(0 0 0 0 1 0) 

     2.5509102344513 #r(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #r(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #r(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #r(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #r(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #r(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 #r(0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     
     2.549302 #r(0.000000 0.886538 0.264356 1.300390 1.330858 1.157418)

     ;; random runs:
     2.549303 #r(0.000000 -0.113461 0.264357 0.300392 -0.669139 0.157420)
     2.549303 #r(0.000000 0.113461 -0.264357 -0.300391 0.669139 -0.157420)
     ;; 2.549304 #r(0.000000 0.113458 -0.264363 1.699605 0.669131 1.842572)
     2.549303 #r(0.000000 0.113461 1.735641 -0.300392 0.669137 -0.157422)
     2.549303 #r(0.000000 0.886537 0.264354 1.300389 1.330856 1.157416)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
(vector 7  3.072141248417 #r(0 0 0 1 1 0 1)

     2.639426 #r(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #r(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #r(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #r(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
(vector 8  3.4905790371793 #r(0 1 0 0 1 1 1 0)

     2.795099 #r(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794748 #r(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #r(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #r(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     2.794585 #r(0.000000 0.666699 0.807707 1.605285 0.837106 0.044540 0.144374 1.873180)

     ;; big fft
     2.794684 #r(0.000000 0.333223 1.192169 1.394521 1.162690 0.955202 1.855341 1.126445)
     )

;;; 9 all --------------------------------------------------------------------------------
(vector 9  3.5954569026984 #r(0 1 1 0 1 0 1 1 1)

     2.962087 #r(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #r(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #r(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #r(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #r(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     2.961652 #r(0.000000 1.872337 1.500914 1.463820 1.942618 0.062504 1.251193 0.435609 1.253539)

     ;; pp:
     2.961653 #r(0.000000 0.872337 1.500915 0.463821 1.942617 1.062504 1.251196 1.435614 1.253542)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
(vector 10 3.7587492407668 #r(0 1 1 0 1 1 1 0 0 0)

     3.102964 #r(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #r(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #r(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #r(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102303 #r(0.000000 -0.071891 1.603086 1.494633 -0.053985 1.786024 0.941426 0.170569 0.896122 1.496522)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.8018732822274 #r(0 1 0 0 1 0 0 0 1 1 1)

     3.218745  #r(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 #r(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #r(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 #r(0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     3.217965 #r(0.000000 0.482287 0.091029 0.383292 0.459507 1.340271 0.057231 1.329368 0.835616 0.788459 -0.198129)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
(vector 12 3.7616552322386 #r(0 1 1 0 0 1 0 1 0 0 0 0)

     3.389586 #r(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #r(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 #r(0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 #r(0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     3.388654 #r(0.000000 1.076620 0.347797 1.614462 0.764164 1.188107 0.116910 0.147164 1.461571 1.590619 1.496557 1.866148)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
(vector 13 4.1211657406183 #r(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 #r(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #r(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #r(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #r(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 #r(0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 #r(0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     3.524127 #r(0.000000 0.948325 1.829839 0.364837 1.544231 0.489035 0.147691 0.944940 1.000036 1.902764 -0.004752 1.840449 1.384160)

     ;; others:
     3.52549096213107 #r(0.0 1.948154 1.82948 1.364841 1.544093 1.488616 0.147127 1.944553 0.999452 0.902129 1.99412 0.839328 1.383104)
     3.52549096875855 #r(0.0 0.948154 1.82948 0.364841 1.544093 0.488616 0.147127 0.944553 0.999452 1.902129 1.99412 1.839328 1.383104)
     3.52549096484103 #r(0.0 0.051846 0.17052 0.63516 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.00588 1.160672 0.616896)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
(vector 14 4.1603193984251 #r(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.613280 #r(0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 #r(0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     3.612244 #r(0.000000 0.028654 0.530107 0.495786 -0.476137 -0.581023 0.103729 -0.513152 1.433095 1.840437 0.739729 -0.059420 0.251093 -0.296875)

     ;; others:
     3.612481978033266 #r(0.0 0.971346 1.469893 0.504214 0.476137 1.581023 1.896271 1.513152 0.566905 1.159563 1.260271 1.05942 1.748907 1.296875)
     3.612481989948184 #r(0.0 1.971346 1.469893 1.504214 0.476137 0.581023 1.896271 0.513152 0.566905 0.159563 1.260271 0.05942 1.748907 0.296875)
     3.612481914145143 #r(0.0 1.028654 0.530107 1.495786 -0.476137 0.418977 0.103729 0.486848 1.433095 0.840437 0.739729 0.94058 0.251093 0.703125)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
(vector 15 4.4060654286219 #r(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.768033 #r(0.000000 0.863152 1.069135 1.651353 0.271851 0.287255 1.735115 1.049678 0.996877 -0.020587 1.091869 1.657562 1.187769 1.641176 1.391193)
     )

;;; 16 all --------------------------------------------------------------------------------
(vector 16 4.5445760745314 #r(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.873760 #r(0.000000 0.727564 0.672436 1.188603 1.622426 1.266314 -0.018679 1.451325 0.507181 0.185750 -0.189066 -0.140317 1.293402 1.595942 0.216437 1.382779)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
(vector 17 4.7654988506492 #r(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)

     3.980210 #r(0.000000 0.519908 1.429364 0.506455 -0.889349 0.115888 0.147799 0.418944 0.941982 0.901488 0.510707 0.653289 -0.078010 -0.603698 0.217190 -0.091931 -0.646982)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
(vector 18 4.795  #r(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.139675 #r(0.000000 0.843694 1.471411 0.063968 0.889446 0.622071 1.732660 0.775711 1.815657 1.135238 1.453657 0.151363 0.100548 0.088867 0.654716 0.119261 -0.025900 1.692198)
     4.139663 #r(0.000000 0.843712 1.471294 0.063927 0.889407 0.621853 1.732502 0.775514 1.815486 1.135008 1.453343 0.151108 0.100015 0.088501 0.654328 0.118764 -0.026400 1.691683)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
(vector 19 4.957  #r(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.218225 #r(0.000000 0.975837 0.737298 1.163191 1.372213 0.708367 0.893430 1.205301 1.114000 -0.155007 0.595375 1.754296 0.630178 0.457584 1.398341 -0.439927 1.059040 1.087418 0.391362)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
(vector 20 5.202707605727 #r(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.287958 #r(0.000000 1.307843 1.492560 -0.136998 -0.104073 0.320652 0.273544 0.026577 0.942663 1.293828 0.101160 0.467007 -0.161748 1.610386 1.399614 0.127790 1.342419 0.775594 1.372823 0.570440)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
(vector 21 5.3164971341632 #r(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     ;;20+1
     4.442505 #r(0.000000 0.229264 0.300308 1.095021 -0.794869 -0.465067 0.642830 0.761336 0.766200 0.262204 0.844388 0.785992 1.557676 -0.940794 0.628826 -0.139027 -0.056712 1.215181 0.022101 0.740212 -0.084960)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
(vector 22 5.292244006282 #r(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     ;; 20+2
     4.539850 #r(0.000000 1.877088 1.220531 0.766350 0.912511 -0.049264 -0.015453 1.476348 0.128719 1.226510 1.377381 1.241269 1.228768 0.089299 1.482606 0.589500 -0.172007 0.157776 0.679537 0.684018 -0.353829 0.532234)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
(vector 23 5.3592889520338 #r(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.603716 #r(0.000000 0.728519 -0.170578 0.343467 1.289714 1.021005 0.302988 1.638069 1.530207 1.013139 0.545865 0.789599 0.817820 0.223908 1.348504 -0.016545 -0.131209 0.351331 0.607617 -0.321862 0.423879 0.291671 0.585222)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
(vector 24 5.6358969066981 #r(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.728042 #r(0.000000 1.858980 1.366314 1.303093 0.303565 0.363906 -0.013052 0.288365 1.150614 1.733252 0.305478 1.054343 0.956930 0.688496 0.150610 0.766590 0.723928 0.358579 1.444965 0.475911 1.678841 0.331630 0.146133 0.753447)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
(vector 25 5.6488965032573 #r(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.852860 #r(0.000000 0.230967 1.727317 0.450764 0.017370 0.018890 0.465256 0.875082 0.612377 0.658132 0.067557 0.830777 0.581695 -0.075473 -0.106051 1.748399 0.582315 0.898509 1.395989 0.676438 1.853985 1.350704 1.785330 0.662329 1.015229)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.7865648269653 #r(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     4.981911 #r(0.000000 0.114804 0.305276 0.394495 0.122048 -1.227102 -0.469461 0.152164 -0.415952 -0.596715 -0.349375 -1.548844 -0.778154 0.402539 -1.542539 -1.840236 -0.152677 -0.992660 -1.641041 -1.138828 -1.199533 -0.219776 -0.823305 -1.512557 -1.273176 -0.520822)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
(vector 27 5.8753981590271 #r(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.063979 #r(0.000000 1.181312 1.011523 -0.037795 0.952214 0.743188 0.046346 -0.011550 1.593930 1.829003 1.926981 0.836368 0.497093 0.820784 0.581154 1.308971 0.813642 0.203348 0.448693 0.869589 1.163120 0.319576 0.498929 -0.074366 0.820574 1.666665 0.421783)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
(vector 28 6.0962085723877 #r(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.156726 #r(0.000000 0.621583 -0.025615 0.185073 1.770611 0.035230 1.190822 1.343738 0.783921 1.481359 0.438924 1.421434 -0.401379 1.746999 0.501100 1.159948 0.364927 0.179358 0.879866 -1.146659 0.808429 -0.150109 1.458018 0.864191 0.450456 0.959743 0.840089 -0.445751)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
(vector 29 6.168496131897 #r(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.241325 #r(0.000000 1.424549 1.434579 0.952506 0.877300 1.948583 1.592791 0.964559 0.950012 1.429458 0.788068 0.556113 0.404906 0.813692 1.604109 0.138120 0.925420 1.345282 1.048370 1.281239 1.347177 1.752489 1.781053 0.782127 0.063659 1.163981 0.330203 1.128951 1.871926)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
(vector 30 6.257221698761 #r(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.361273 #r(0.000000 1.372797 0.670580 1.057136 -0.495516 0.360919 0.095174 0.542106 0.748047 0.327246 -0.458569 -0.196062 0.499790 0.195141 -0.041091 1.640040 0.876134 1.017379 1.243023 0.157336 0.532420 -0.270945 0.222972 -0.454366 0.519190 0.206280 0.985739 0.329627 0.782987 0.753526)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.3243918418884 #r(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

	5.453054 #r(0.000000 0.330034 1.062392 -0.018048 0.701747 1.293007 0.182311 1.269874 1.478913 1.017407 0.501409 0.269712 1.315062 1.138628 0.142159 0.526931 -0.345056 1.613950 -0.162150 -0.111306 0.991533 0.609140 1.408136 0.828750 1.658057 -0.598529 -0.552356 -0.936876 -0.551564 -0.796775 0.156224)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
(vector 32 6.4451498985291 #r(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.525650 #r(0.000000 -0.351133 1.293972 -0.243467 0.375774 0.341597 0.388720 0.121948 0.157486 1.353778 0.236182 0.278745 0.140738 1.315014 1.717753 1.193420 1.734782 1.635830 0.448546 0.657631 0.934238 0.325644 1.910640 1.330301 0.498135 1.394503 1.747576 0.388629 0.706077 0.075100 0.832948 -0.013902)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.5579299926758 #r(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.608483 #r(0.000000 0.127672 0.575757 0.971725 0.693309 0.950898 0.070948 0.160557 0.341181 0.560186 1.645087 0.281844 1.260852 1.598287 0.730804 1.014936 0.316122 0.275621 0.725241 0.597914 1.221833 0.996203 0.324966 1.372541 1.062261 1.875167 0.130133 1.748519 0.894847 1.849289 0.335743 1.776799 1.261232)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
(vector 34 6.6782836914062 #r(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.715061 #r(0.000000 1.557376 0.316186 0.303275 1.175381 0.206598 0.863890 1.615342 1.613470 0.958427 1.750728 0.111536 1.351364 0.386942 1.439281 0.903963 1.075401 -0.020759 1.279610 1.643520 1.269919 0.800947 0.050818 1.687932 -0.298939 1.577236 -0.205754 -0.244682 0.852707 0.888744 1.194917 0.175251 0.202437 0.844132)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7637429237366 #r(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.761550 #r(0.000000 0.109331 1.415904 0.863973 1.504657 0.200254 1.669142 1.598436 1.595369 0.964840 1.410141 1.378302 1.505772 0.261951 1.178950 0.757734 1.524984 1.223665 0.264922 0.531725 0.000853 1.660270 0.971853 -0.071328 1.201271 1.414050 0.409445 0.053601 0.377052 0.191601 0.609357 0.945758 -0.105595 0.829816 1.179558)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
(vector 36 6.8008880615234 #r(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.871695 #r(0.000000 0.976078 1.428851 0.077798 0.772784 1.602082 0.472100 1.111861 0.058266 -0.754466 0.191131 -1.049850 0.189192 -0.311703 1.251680 0.977617 0.232753 1.137715 0.806190 1.201023 0.616244 0.157943 -0.415443 -0.020130 -0.548605 -0.551223 -0.509170 0.040073 -0.121612 -0.560043 -0.007571 -0.025396 0.766768 -0.951503 -0.743309 -0.341165)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0251078605652 #r(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.918139 #r(0.000000 1.268085 1.769551 0.285066 1.784410 1.812873 1.034440 1.342674 0.256292 0.366678 1.679577 1.477236 0.317949 0.294007 -0.148484 0.067735 0.925643 1.526359 1.349946 0.624511 0.326721 1.258438 0.049695 1.798322 0.189031 0.360477 1.435009 0.581192 -0.024865 0.191624 1.638560 0.341145 1.503234 0.980493 1.208657 1.269237 1.688696)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.0688242912292 #r(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.055823 #r(0.000000 1.140317 1.804958 0.269386 1.581973 1.647143 0.908514 1.357676 0.255360 0.413319 1.759464 1.403831 0.462290 0.275768 -0.260643 0.081477 0.945988 1.674168 1.558839 0.619719 0.448569 1.181188 0.261467 0.173066 0.317765 0.523175 1.483135 0.623965 0.065573 0.279749 1.647027 0.558187 1.546480 1.177439 1.567967 1.574734 1.849511 0.049835)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.1506487936623 #r(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.123617 #r(0.000000 0.022194 0.139382 1.578109 1.109939 0.686598 -0.209261 0.437705 0.449420 -0.232701 -0.273875 0.070822 0.433690 0.853619 1.527629 -0.258054 1.050086 -0.235174 1.275677 0.950078 0.647199 1.303772 1.358361 1.189190 0.591278 -0.165906 0.244128 1.187114 -0.273717 1.031390 0.371517 -0.540240 0.858520 1.177992 1.114387 -0.172733 1.027118 -0.340480 -0.076231)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.3913831710815 #r(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.223875 #r(0.000000 0.017488 0.395122 1.676489 1.264189 0.771372 -0.011418 0.532062 0.348765 -0.291944 -0.034478 0.399358 0.691637 1.117218 1.716574 0.114046 1.298557 0.074462 1.617194 1.080550 1.108787 1.427161 1.645893 1.492515 0.908836 0.183198 0.586816 1.733289 0.192174 1.419647 0.686684 -0.174875 1.274049 1.555620 1.606137 0.123322 1.462205 0.157438 0.491542 -0.249961)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.4106826782227 #r(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

	6.278483 #r(0.000000 1.038469 1.689102 -0.246889 1.070891 1.081477 0.456681 0.352855 1.380232 1.717208 0.185595 0.242413 -0.037760 -0.028341 1.684169 1.135689 0.606635 1.756147 0.422850 0.765104 1.090059 0.552553 -0.368817 0.733599 0.247441 0.131196 0.725118 0.703272 0.972734 -0.170957 0.673987 1.704514 0.578697 -0.183550 -0.096757 0.046184 0.705164 0.130867 1.217191 0.056397 0.199710)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.6252284049988 #r(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.374134 #r(0.000000 1.160594 -0.035009 -0.337995 1.287896 1.152937 0.370349 0.599654 1.434075 0.331903 0.337639 0.227520 0.031784 0.056373 1.754183 1.233325 0.766762 -0.105337 0.381752 0.608417 1.177813 0.853286 -0.000702 0.980553 0.580193 0.503346 0.721433 1.102554 1.338903 -0.104016 1.021288 -0.193635 0.638903 0.186655 0.282480 0.311801 1.029234 0.514030 1.400087 0.298091 0.559980 -0.413468)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.6619415283203 #r(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

	6.474636 #r(0.000000 1.150199 1.694193 1.156056 0.712558 0.642330 1.062359 0.333465 0.208319 1.376434 0.672147 0.421707 0.175691 0.110131 0.012554 0.457050 1.790874 1.449901 0.302494 0.007271 0.824529 0.122259 0.582806 0.097251 0.623774 0.359297 1.299289 0.938333 1.768060 0.180654 1.104716 1.340371 1.395970 0.480619 1.800871 0.228016 0.933560 0.262964 0.673103 1.298731 1.471774 -0.223423 0.770589)
	)


;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9767818450928 #r(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

	6.544063 #r(0.000000 0.521564 0.221232 0.526957 -0.268317 1.919404 -0.035203 -0.157289 0.069290 1.705251 1.788014 0.459816 0.274398 0.505529 1.163758 0.357930 -1.720040 0.469129 0.146265 1.215606 1.405712 0.742844 1.668145 1.402279 0.067840 0.255308 0.567789 0.756058 -0.027555 1.587315 0.915687 1.314433 0.227656 0.688969 1.566702 0.434208 -0.041884 1.283408 0.878206 0.471503 1.018383 0.062893 1.376612 0.157588)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1777801513672 #r(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

	6.612690 #r(0.000000 0.809914 0.760766 -0.199070 0.584393 1.010129 -0.444768 -0.272636 0.950655 0.770420 -0.288810 0.049214 -1.454088 0.191424 -1.076560 -0.306479 -0.326951 -1.245176 0.685415 0.506132 0.101749 0.628099 0.641810 0.560186 1.064779 -0.804404 -0.612448 0.708592 1.898500 0.642577 0.682702 -0.598959 -1.216733 -1.420060 0.084743 0.265460 1.286043 0.185429 1.160604 0.022683 -0.437513 0.122344 -0.218434 -0.653674 -1.002688)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.22203540802 #r(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.691037 #r(0.000000 1.445996 1.082935 1.926602 0.599270 0.110590 0.061353 0.197460 1.126524 0.801213 0.136799 1.544533 0.424316 0.988423 1.042912 0.904549 0.394264 1.877367 1.781398 0.106378 0.814176 1.462479 1.299353 0.505357 0.691608 0.079788 0.741755 1.296349 0.923407 1.954315 1.519832 1.193777 1.868646 1.501978 -0.016089 0.928107 1.377054 1.114171 1.348483 1.466927 0.885968 1.244812 -0.112245 0.649026 0.159882 0.999017)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.3221893310547 #r(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.756605 #r(0.000000 0.765562 1.030062 1.788209 0.493707 1.020553 1.799942 0.685170 1.481088 0.566613 1.302518 0.066670 1.157386 0.282906 1.328526 0.161298 1.388649 0.879050 1.843229 1.039366 0.409576 -0.055025 1.222366 0.535280 0.169247 1.679128 1.342099 0.894436 0.643082 0.345708 0.301808 -0.401334 0.022950 1.550170 1.565812 1.633017 1.764984 1.880338 1.607034 1.569498 0.111731 0.416082 0.781558 0.894597 1.438223 1.659212 0.166997)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.4671268463135 #r(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

	6.804078 #r(0.000000 0.874821 0.948620 -0.030050 0.326575 1.258972 -0.088513 0.113859 0.340515 -0.014269 1.691477 0.675893 0.119114 -0.035346 1.426532 1.152480 0.791174 0.976063 0.731143 1.014136 1.203667 0.311022 -0.203371 1.591275 1.628122 -0.181766 0.450459 0.902610 0.339563 -0.440014 -0.112189 0.959920 1.425584 0.089561 1.717366 0.518887 0.024084 1.133195 1.349821 0.385099 1.797184 0.189610 0.147986 1.156584 -0.006309 1.527354 0.195815 0.002013)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
(vector 49 8.5157623291016 #r(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

	6.871628 #r(0.000000 1.197339 0.943600 -0.418761 0.049685 1.002197 -0.323377 0.763534 1.062841 -0.005796 1.425933 0.322430 0.084053 -0.585670 1.449690 1.603999 0.946354 1.356731 0.301596 1.002372 0.650650 0.119315 1.243049 -0.407370 -0.367523 0.258301 -0.505816 1.032723 -0.832489 -0.467654 -0.467807 0.598599 -0.548874 -1.027291 -0.206361 0.534378 -0.811327 1.081884 0.922436 0.108022 -0.303016 -0.150120 -0.199521 0.546600 0.438688 0.415808 -0.008696 0.110784 0.758574)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
(vector 50 8.7809114456177 #r(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

	6.966047 #r(0.000000 0.962905 1.097330 1.888512 0.176170 1.249181 -0.168544 0.509171 0.717525 0.069686 1.526076 0.503308 0.181151 1.831084 1.142478 1.254775 0.935821 1.099009 0.324329 0.750637 0.817716 0.473950 1.405312 1.489970 1.715244 -0.138333 0.191055 0.986798 -0.177541 -0.183900 -0.081646 0.626605 1.530354 -0.052123 1.504605 0.533551 -0.327117 1.309658 1.385783 0.305850 1.613358 0.056196 -0.069816 0.982784 0.217704 0.915410 0.315681 -0.214270 1.383464 1.628385)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.8213935921978 #r(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     6.971782 #r(0.000000 1.381134 1.053573 -0.642284 1.106927 1.065731 0.156795 0.531640 0.658480 0.423307 0.458153 0.332929 0.258309 -0.378345 0.690163 1.115051 0.213852 0.690863 0.353610 0.459744 1.132735 0.758828 0.447315 -0.071617 1.577100 -0.919334 0.495653 1.111932 -0.086022 0.770249 0.516654 1.486418 0.018200 1.218929 1.677748 0.244186 0.465632 0.411266 1.326302 1.201131 -0.010901 1.028025 0.862583 1.846154 0.922121 1.887046 1.218211 -0.479984 1.767657 -0.113149 0.573554)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.9920463562012 #r(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

	7.101828 #r(0.000000 0.646351 1.348437 1.394446 0.228508 1.370485 0.660337 0.579558 -0.056026 0.283749 1.791709 0.481733 1.428712 1.245523 1.307690 1.074069 0.851835 1.612005 0.472059 0.051512 0.355641 1.080975 -0.158863 0.150463 0.435366 1.019121 1.758753 0.965820 1.596435 -0.205826 0.026983 0.989221 0.450040 1.062201 0.025319 -0.395664 1.085851 0.689762 0.740855 0.484733 0.501691 1.010487 1.006025 0.857003 1.147326 0.289999 1.266663 0.490356 0.319639 1.268445 1.014342 0.448435)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.0914754867554 #r(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

	7.168422 #r(0.000000 0.734800 0.755002 1.678637 1.148472 1.726884 0.506566 0.162329 0.304752 0.290731 1.237477 1.522988 1.097235 -0.074667 1.611785 0.203012 1.069009 -0.398864 0.892774 1.815871 0.743283 1.031741 1.066124 0.407989 0.358481 0.762020 1.519272 1.133826 0.019027 0.362472 0.267333 1.835621 0.594226 0.045578 1.461712 1.370620 0.794797 0.554188 1.488530 -0.030031 0.948673 1.753818 0.146713 1.671920 1.781890 0.035858 1.658572 1.054561 0.107770 0.028848 0.546289 0.017191 0.104880)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.1825122833252 #r(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

	7.245591 #r(0.000000 1.686555 -0.134051 1.339159 -0.139744 1.249317 0.052837 0.496203 1.186868 -0.190398 0.085087 -0.014578 0.148546 1.002089 -0.222856 0.596406 1.341405 0.448014 0.534314 1.092500 0.986488 0.256202 0.422281 0.225300 1.439830 -0.098135 1.589744 0.958350 0.982778 -0.091329 1.504731 1.087277 -0.000312 1.417081 0.729922 0.495573 1.045881 0.653448 1.408480 0.315198 0.535103 0.741972 1.142084 0.667364 0.951873 1.748001 1.479988 0.783357 0.087811 0.364817 0.035646 1.164454 0.433389 0.712104)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.0889595835043 #r(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

	7.299987 #r(0.000000 1.020969 0.293796 1.798197 1.119668 1.147020 -0.132959 1.003677 0.949931 1.796829 0.459947 0.880914 1.582469 0.875424 1.100277 0.952769 1.490876 1.407382 -0.298616 1.479769 1.580356 1.028332 0.802614 1.364991 0.250327 0.211041 1.412324 -0.072992 1.428778 0.047292 0.916259 0.964910 1.114739 0.871338 1.452857 0.648648 1.592866 0.307820 0.554266 -0.122522 1.103511 0.320958 0.250360 0.032244 1.623283 0.802510 0.366699 1.421281 1.732770 -0.264247 -0.262690 0.728471 1.186845 0.469835 1.716425)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.1394176483154 #r(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

	7.349437 #r(0.000000 1.546087 1.523699 -0.222814 1.563242 0.073887 1.226569 1.346857 0.292837 1.634387 -0.251778 0.060895 -0.022143 1.595396 1.558207 0.543894 0.524391 1.131307 0.107395 0.049540 1.190567 0.105407 1.309188 1.049686 1.847136 1.739252 0.730834 0.631473 0.965848 1.428286 1.258515 1.585209 1.811352 1.268900 -0.020138 0.642231 1.575017 1.141819 0.549674 0.685664 0.941820 0.311404 0.683359 0.230880 0.725054 -0.246162 1.525527 0.596605 1.235099 0.021275 1.782957 1.875900 1.027532 0.553643 1.151157 -1.905652)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
(vector 57 9.370246887207 #r(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

	7.441467 #r(0.000000 0.622317 1.086709 0.781210 1.543555 0.503242 0.435992 0.435167 1.805588 0.922076 0.997063 1.053812 0.182167 0.657560 1.514895 1.560202 1.875822 -0.073404 1.631644 1.494624 -0.115787 0.198249 -0.137542 1.260390 0.759500 0.603371 1.553048 1.137852 1.078723 1.442159 1.707807 0.723280 0.931846 1.367412 0.727839 0.407781 1.645303 0.447632 1.455182 1.393340 0.945452 1.895842 1.343341 0.216348 1.083126 0.643542 1.095796 1.407207 0.340817 1.425984 0.271019 0.890314 0.056560 1.699782 1.246486 1.440900 1.252017)
	)

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.4419231414795 #r(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.471443 #r(0.000000 0.426257 0.958229 1.101908 1.838005 0.610307 0.610431 0.402294 1.784945 0.821317 1.119801 0.451192 0.541444 0.688311 1.334853 1.336110 1.825022 -0.121597 1.624253 1.303585 -0.201276 -0.206522 -0.234612 1.368607 0.780881 0.700656 1.644105 0.970363 1.079078 1.564363 1.736314 0.925048 1.037757 1.476082 0.706932 0.300800 1.747548 0.507618 1.347506 1.440798 0.870823 -0.047835 1.238022 0.066382 1.125573 0.437220 0.934851 1.197820 0.289481 1.232537 -0.191118 0.529022 0.086441 -0.284966 0.840338 1.327489 1.118018 -0.608987)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
(vector 59 9.4819116592407 #r(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

	7.469439 #r(0.000000 0.786053 1.040825 1.050267 0.305344 0.429180 0.717962 0.088837 1.725419 1.152362 1.020784 1.048370 0.486073 0.781280 1.724120 1.577030 -0.178365 -0.185633 1.691507 1.934596 0.047136 -0.005417 0.368219 1.700165 1.124068 0.296017 -0.054066 1.191543 1.153852 -0.148804 -0.090665 1.539214 0.964764 1.914412 1.137764 0.431014 0.776666 0.626264 1.462361 1.865260 0.168893 0.419387 0.159040 0.463215 1.623762 1.046651 1.759104 0.229882 1.170489 0.041888 0.885618 1.026993 0.314162 0.256790 1.158778 1.872242 1.012776 0.087727 0.001263)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.575254043103 #r(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

	7.588747 #r(0.000000 0.303100 0.261228 0.917131 0.691793 -0.677124 0.027342 -0.014801 1.166154 0.416979 0.851167 1.410955 0.139409 -0.306122 1.416862 1.054300 0.792442 0.062922 1.507148 0.118287 1.375215 1.459904 1.620963 0.828106 -0.237368 0.987982 0.753194 0.096604 1.712227 1.239483 0.673351 0.871862 0.125962 0.260000 0.626286 0.147473 0.131774 0.201212 -0.194457 0.538798 0.418147 1.292448 0.871870 0.794549 0.988888 1.131816 -0.166311 0.052304 0.543793 -0.229410 0.113585 0.733683 0.271039 1.008427 1.788452 0.654055 0.106430 0.828086 0.097436 0.376461)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.9175914844707 #r(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.718493 #r(0.000000 0.490794 0.242481 0.957898 0.662750 -0.742881 -0.016296 0.184736 1.253821 0.192761 0.810471 1.424644 0.139002 -0.552618 1.410815 1.159145 0.578377 0.235962 1.481912 0.147798 1.356870 1.551452 1.671348 1.124242 -0.535143 1.068113 0.692544 0.422646 1.876765 1.326092 0.722719 0.142011 -0.034790 0.381612 0.462371 -0.053314 0.063624 0.488941 -0.311525 0.596438 0.293354 1.627834 0.719558 0.563559 0.991769 1.160122 -0.358559 0.031628 0.400641 -0.444384 -0.013306 0.380359 0.226825 0.830723 -0.092522 1.028901 0.262077 1.004376 -0.055799 0.311561 -0.101231)
     )


;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.9292116165161 #r(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

	7.791756 #r(0.000000 0.794255 1.776105 0.184372 1.667961 1.440185 1.817320 1.053449 0.082409 0.687457 0.048164 1.444125 1.423252 0.061081 1.727243 0.162932 0.953680 0.005222 0.917056 1.225176 0.682682 0.672057 0.108792 1.597133 0.224159 1.125545 0.417480 0.240811 0.741742 0.625708 0.356451 1.543976 1.537969 1.658348 0.209650 1.492266 1.130024 0.756184 1.143465 1.484763 0.002845 1.030762 1.291665 1.164813 0.385858 1.615844 1.466799 1.796934 1.874708 0.677123 1.684900 1.485354 0.688305 0.708676 0.948779 1.173098 0.106201 1.209490 0.787951 0.696086 1.257404 1.488223)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.9555234909058 #r(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.792658 #r(0.000000 0.604958 1.810993 0.479572 1.832501 1.568102 -0.008375 1.139554 0.500438 1.068891 0.129208 1.082690 1.606602 0.021403 1.588850 -0.152836 0.676059 0.009863 0.698550 1.351044 0.912935 0.821309 0.678462 1.195880 0.335962 0.980439 0.167296 -0.166103 0.584580 0.895326 0.165904 1.888061 1.403790 1.358315 0.000771 1.273834 0.958915 0.625533 1.434996 1.581517 -0.027021 1.322879 1.634409 1.284726 0.325288 1.829740 1.346606 -0.071117 -0.074172 0.523456 1.755231 1.609173 1.147725 0.784584 0.915037 1.284527 -0.069280 1.582487 1.006637 0.377855 1.009315 1.289847 -0.296346)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
(vector 64 9.957244923706 #r(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

     7.850378 #r(0.000000 0.818256 1.893797 0.447574 0.004615 1.627422 0.174323 1.354149 0.505328 1.291333 0.192178 1.130810 1.484813 -0.020048 1.628923 0.116957 0.662375 0.012432 0.429672 1.291396 0.784440 1.176860 0.720821 1.253711 0.466453 0.835831 0.299457 -0.100473 0.586092 0.852720 -0.020740 1.729307 1.309937 1.257236 0.131855 1.336452 1.066797 0.322890 1.283543 1.689513 -0.371492 1.214117 1.466426 1.111681 0.289267 1.807002 1.269572 -0.053895 -0.092329 0.477788 1.677216 1.588667 1.094746 0.622096 0.954171 1.266653 -0.249077 1.541492 0.994736 0.424957 0.957923 1.192779 -0.269608 -0.039051)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.157649040222 #r(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     7.935374 #r(0.000000 1.516508 0.110662 0.175958 0.836131 0.527757 1.411364 1.402933 -0.304009 0.233367 0.236759 -0.044789 0.175612 -0.486791 -0.877026 0.147806 1.067130 -0.071661 -0.249068 -0.143232 0.548582 1.308817 0.625581 1.605825 0.476254 0.402177 0.399931 -0.689265 1.463205 1.551126 0.770705 0.932593 0.459681 0.842986 0.780890 1.170908 -1.038140 0.797070 -0.861980 0.600440 -1.006688 1.655334 0.145026 -0.290652 0.442934 0.083346 -0.055655 -0.658549 1.077569 0.388346 0.715047 1.209914 0.883597 0.287116 1.384240 0.580259 -0.768209 -0.114151 0.598252 1.027948 1.705250 0.896332 0.480110 -1.183952 0.051204)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.208241079264 #r(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

	8.011520 #r(0.000000 0.479799 1.169638 0.004612 0.402406 1.230765 1.595897 0.593685 1.374878 1.499275 0.489410 1.425320 0.373395 1.315599 0.138105 0.920155 -0.108520 0.991482 -0.149108 0.410130 1.436361 0.601706 0.046153 1.052899 0.424418 1.134897 0.348693 -0.098617 1.547368 1.151172 0.294748 -0.290030 1.189252 0.345030 -0.465760 1.441002 1.060075 0.832617 0.418488 0.293880 -0.106037 -0.059478 0.956595 0.497960 0.117059 0.767911 0.318840 0.717594 0.220912 -0.113412 0.081739 -0.211641 -0.217173 0.315598 0.272673 0.484197 0.526183 0.827437 0.728223 1.566384 -0.150430 0.337045 0.831304 1.069362 1.566148 -0.280307)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.422191619873 #r(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.043962 #r(0.000000 0.723361 1.098199 -0.104317 0.796240 1.226712 1.796964 0.767870 1.189764 1.772492 0.590978 1.631570 0.568976 1.570933 0.191811 0.911209 -0.021351 0.900745 0.009021 0.667781 1.566923 0.719770 0.205199 1.286787 0.231357 1.429685 0.816164 0.009201 1.644886 1.192474 0.623028 -0.047424 1.588652 0.551514 -0.304566 1.681018 1.259199 0.930654 0.444058 0.347527 1.926688 0.132038 1.165961 0.703045 0.587795 0.751154 0.472421 0.933684 0.438476 0.165192 0.320128 0.049852 0.054657 0.597137 0.289172 1.017612 0.945610 1.220099 1.001383 1.565341 0.058830 0.420956 0.733110 1.012036 1.857676 1.850677 0.317955)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
(vector 68 10.460547747753 #r(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

	8.131379 #r(0.000000 0.777086 1.225294 0.459335 1.120518 1.101510 0.718447 1.262945 1.346941 0.144684 0.695095 1.701131 0.123010 0.559466 0.867624 1.525977 0.858162 0.137330 0.853375 -0.428338 0.368918 0.875336 1.605285 1.009970 -0.095199 -0.219955 0.449222 0.000464 0.090789 0.090543 -0.094428 1.635821 -0.065302 1.739981 0.500960 1.791399 0.927017 -0.130394 1.444057 0.172796 0.901920 -0.118461 0.861131 0.631330 0.620706 -0.801290 0.162692 0.158567 -0.135443 1.344771 1.192462 -0.162338 -0.266366 0.328646 0.783136 0.650960 0.026458 1.672924 1.221292 0.618317 0.191901 -0.429128 -0.026945 -0.415707 0.709906 0.791929 0.708422 0.702801)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.495518383865 #r(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

	8.140284 #r(0.000000 0.574274 1.353235 0.374880 1.030900 1.241934 0.744056 1.258652 1.336888 0.191881 0.691290 1.721325 0.311221 0.667796 0.914975 1.702712 0.832796 0.057800 0.926778 -0.151752 0.409056 1.010584 1.740825 1.032269 0.081080 -0.217110 0.415261 -0.071717 0.155276 -0.088899 -0.060899 1.591545 -0.172297 1.695170 0.543998 1.693375 1.206363 -0.050497 1.924309 0.173097 0.976699 0.086114 0.708934 0.776887 0.648438 -0.409990 0.317299 0.431348 -0.080917 1.418905 1.274203 0.066144 -0.289260 0.572513 1.102504 0.974167 -0.045152 1.746839 1.335333 0.699271 0.200129 -0.170859 0.156721 -0.222333 0.876801 0.959324 0.814751 0.645600 0.000208)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.532930374146 #r(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

	8.176963 #r(0.000000 0.587989 1.431825 0.221285 0.960638 1.245837 0.795275 1.178692 1.324313 0.151685 0.789663 1.805305 0.407280 0.848410 1.089893 1.582619 0.871354 1.940142 1.022672 -0.098747 0.444755 1.081717 1.884930 1.020069 0.094475 0.162127 0.516048 0.043396 0.218952 -0.075886 0.177709 1.517609 -0.008561 1.566136 0.502844 1.768539 1.199988 0.053518 1.941460 0.082194 1.231659 0.182374 0.578473 0.843872 0.777996 -0.220205 0.467426 0.426401 0.154145 1.445497 1.004198 0.090981 -0.148632 0.673583 1.270739 1.002492 -0.085118 1.727335 1.374618 0.568333 0.205667 -0.017872 0.120962 -0.075966 0.957264 1.025234 0.841047 0.662525 -0.011036 1.297608)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.610488331633 #r(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

	8.291337 #r(0.000000 0.876359 1.340283 0.367845 0.833375 1.105664 0.584271 1.188768 0.943451 0.250250 0.630656 -0.068635 0.279930 0.860317 0.732184 1.695932 0.897961 0.078310 1.045223 -0.333231 0.322957 1.637262 0.164086 1.142535 -0.007984 0.252507 0.780797 0.003458 -0.048747 0.073861 0.171483 1.284136 -0.089705 1.440806 -0.081590 1.527122 0.082721 -0.151244 0.255684 0.094848 1.149118 0.413274 0.691318 1.014955 0.789606 -0.102756 0.792501 0.144964 0.117187 1.222333 1.251710 -0.402265 -0.063046 0.826524 0.883969 0.465066 -0.032718 -0.408605 1.616554 0.441389 0.502001 0.126714 -0.391606 0.529285 1.070446 1.229824 1.052451 0.538215 0.119274 0.991866 0.323308)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.800657366855 #r(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.367751 #r(0.000000 0.645558 1.020824 1.674879 0.297321 1.478215 1.159425 0.013301 1.239885 0.350033 0.888999 1.831881 0.311808 0.919253 1.727115 0.871519 1.738071 0.513558 1.443664 0.420753 1.667825 0.484271 1.279276 0.823868 0.381782 0.911943 -0.096163 1.562504 0.828536 -0.144974 1.874517 0.768201 -0.125865 0.027788 0.992868 0.715728 -0.253408 1.108264 1.073157 0.786938 -0.002734 -0.154497 1.429041 1.081506 0.490310 0.770013 0.521515 0.288890 -0.695918 0.082180 -0.343666 1.544801 1.719927 1.637916 1.693329 1.678105 1.069958 -0.338832 -0.083132 -0.171885 -0.331886 -0.261796 0.380058 0.414290 0.757097 1.213104 1.511562 -0.172398 -0.158558 0.833537 0.819748 1.537843)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.773231506348 #r(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

	8.371506 #r(0.000000 -1.867938 0.232496 1.586661 0.641992 0.928863 0.649348 -0.044198 1.085010 0.079229 0.862927 -0.237800 1.012094 0.965795 1.257653 -0.154609 1.363426 -0.126060 0.258325 1.241200 1.562391 1.221551 -0.017796 -0.046230 0.396012 1.553068 0.824411 1.145699 1.128785 -0.049237 0.673355 0.304031 -0.042615 1.642256 0.320764 0.567488 0.582997 1.177975 0.715492 0.736721 1.338915 0.369645 0.312354 0.097607 -0.086716 0.014634 0.001469 1.805330 0.848100 1.689101 -0.032587 0.024783 0.624333 1.292453 0.091180 0.653940 1.534562 0.693020 0.501144 0.009915 1.675154 0.697198 0.435218 1.219144 0.148845 0.005218 1.413815 0.712782 1.528783 0.213630 0.113661 1.648322 0.824916)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
(vector 74 10.684138298035 #r(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

	8.468489 #r(0.000000 1.397351 0.199115 1.454114 1.031715 -0.176142 1.092851 0.462165 -0.016726 0.853430 -0.146725 0.811539 1.707371 -0.117500 1.407819 0.198961 1.078765 1.327293 0.331176 0.524536 1.478718 -0.063221 -0.112592 0.975553 1.167568 -0.244228 0.941673 1.029112 0.072643 1.555004 0.515688 -0.520416 1.848291 1.770668 -0.056909 0.037394 1.125814 -0.215204 1.309496 0.093237 -0.026125 1.523106 1.564912 1.107622 0.871096 1.093068 1.436174 -0.591776 -0.083622 0.913864 1.332465 0.538923 -0.091814 0.025942 0.246267 0.665145 0.061016 0.018831 1.154856 0.928981 0.707435 0.975317 -0.203276 0.390356 -0.015578 0.659407 0.326913 0.774677 1.281753 0.892058 0.125387 -0.275161 1.292193 1.029723)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.935811368418 #r(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

	8.512424 #r(0.000000 1.411165 0.066815 1.545993 0.946095 -0.013826 1.044201 0.645921 0.167534 0.936997 0.015362 0.752008 1.506866 -0.158860 1.516968 0.188211 1.320449 1.416434 0.301211 0.249914 1.630679 -0.182057 -0.250234 1.010984 0.856089 -0.194871 1.267794 0.818904 0.026503 1.685044 0.447764 -0.570160 1.818021 1.556283 0.065474 -0.160812 1.254420 0.015713 1.097954 0.076322 -0.329350 1.595682 1.328596 0.970473 0.523251 1.172474 1.547586 -0.576799 0.315720 1.005997 1.384889 0.446334 0.034057 -0.043520 0.102641 0.907794 -0.217100 0.330956 0.799047 0.751974 0.718734 0.830887 -0.040874 0.108169 -0.077398 0.706941 0.367992 0.821591 1.448143 1.030496 -0.359435 -0.609102 1.208112 1.153589 0.207741)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
(vector 76 10.689208030701 #r(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

	8.566643 #r(0.000000 0.381106 -0.266391 1.483482 1.132005 0.371120 0.752013 1.832292 0.729074 1.486332 1.011195 -0.165598 1.221917 1.641575 0.360666 0.433077 1.404878 0.604388 1.104926 0.729165 1.669029 0.450931 1.499767 -0.080683 1.221002 0.625260 0.828962 0.972153 0.755738 1.545260 -0.154840 0.581108 1.513378 0.013021 0.891683 0.702677 0.747453 0.397193 0.417760 0.289893 0.885881 -0.366958 0.566657 0.149934 1.332346 0.845232 1.552276 -0.056636 0.409890 0.036503 -0.043099 1.055520 0.429840 -0.126953 0.004032 0.241993 1.122772 0.921410 1.349658 1.081742 0.615932 1.026733 0.322881 0.803706 0.857043 0.333651 1.097387 0.873399 -0.168242 1.662747 0.934611 0.695385 1.391924 1.697835 1.605684 0.993676)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.114716461811 #r(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

	8.655850 #r(0.000000 0.144015 0.521787 0.519011 1.193985 1.813929 -0.020721 0.363063 0.853642 0.859887 0.580896 0.078449 1.009266 0.221508 0.182992 0.759898 1.544517 -0.010376 0.635651 0.285693 -0.330723 0.371939 0.149327 -0.307594 0.733085 -0.192814 -0.013453 0.625868 0.850147 1.811263 0.605103 1.230124 0.065834 1.468308 0.622956 -0.230654 -0.019787 1.531322 1.297364 0.769617 -0.081404 1.071828 0.928156 0.511154 0.237021 0.316908 -0.004413 0.571845 0.646678 1.228590 0.492699 1.369241 0.672452 -0.233665 0.332431 0.388115 0.821896 1.176234 1.091315 0.738910 1.432114 1.421319 1.054889 -0.269641 0.700596 1.402150 0.397349 -0.245474 -0.116062 0.640946 0.961580 0.375676 0.318553 -0.237609 1.548434 -0.512459 1.445327)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.471938943963 #r(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

	8.713157 #r(0.000000 1.185175 1.397998 0.029507 -0.003150 1.681558 0.352287 -0.142980 1.503432 -0.031653 1.606742 1.761627 1.241378 0.692257 0.198504 1.080125 0.928512 1.682058 0.474050 0.647248 0.825797 1.866311 0.823439 1.412665 0.855734 0.627072 1.762849 0.273347 1.224795 1.527402 0.799841 1.826401 1.613076 1.464329 1.459644 0.659045 1.125726 1.685514 1.459290 0.692583 0.629938 1.416569 -0.101579 0.653448 0.364955 1.272692 1.662367 1.045389 1.620168 0.458585 0.835933 1.249466 0.947077 -0.133359 1.014573 0.250790 0.421139 -0.005825 -0.027874 1.307059 0.066093 1.637593 0.497687 0.345017 0.115925 -0.006858 0.311739 1.192497 0.790849 1.021741 1.387921 1.598464 0.189632 -0.083007 1.800753 0.182932 -0.105722 0.993536)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.334476470947 #r(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.767436 #r(0.000000 0.718403 1.251314 1.486434 0.417739 1.537028 1.781280 0.371804 0.856023 1.697105 0.410324 1.015131 -0.119095 1.081250 -0.157946 0.436892 1.552209 0.310681 1.199628 0.374846 0.988915 0.054273 1.300951 0.365816 1.604177 0.398188 1.427075 0.723659 0.021475 1.135277 0.715183 -0.075549 1.555657 0.584681 1.776086 0.831855 0.296030 1.723871 1.434840 0.893843 0.399844 1.754534 1.625700 0.603594 0.563673 0.311786 1.758993 0.014755 1.458293 1.648023 0.983651 0.560806 0.171502 0.278061 0.103727 -0.090556 -0.256311 1.589447 0.057298 1.706317 1.625686 1.735520 1.218723 1.651189 1.784299 0.256509 0.287738 0.688962 0.644695 0.791051 0.753121 1.204382 -0.074638 0.485008 0.749887 1.461595 1.411150 1.659818 0.509864)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.30185508728 #r(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

	8.831605 #r(0.000000 0.718457 0.752874 0.707265 1.105140 1.556866 1.675971 1.743288 1.737050 1.402684 0.726424 0.001544 0.787560 0.610707 0.221912 0.548490 1.255462 0.532840 1.735795 1.159475 0.139393 0.566082 0.477708 1.186070 0.213588 1.697938 1.877210 -0.027617 0.446036 -0.097653 1.420626 0.288659 1.413894 1.358919 0.713009 -0.285435 0.875204 0.375292 0.708148 0.907015 0.596415 1.676708 -0.002236 0.617188 -0.254880 0.679354 1.396570 0.024604 0.491384 1.191175 0.583286 0.255907 0.583959 0.646881 1.743044 0.166682 0.513542 1.079013 0.694687 0.379588 0.528146 0.707196 1.408903 1.510794 1.151055 0.672700 0.297721 -0.154036 1.059849 1.480109 0.687072 0.133333 1.264870 -0.326181 0.342810 1.875130 1.918140 1.634313 0.782341 -0.170226)
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
(vector 81 11.22668050284 #r(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.797329 #r(0.000000 0.593378 0.769030 0.482050 0.894789 1.469434 0.017291 1.548640 1.399875 1.547111 0.960600 0.029476 0.347173 0.479328 0.324764 0.535557 1.181648 0.603853 1.724567 1.184427 0.201520 0.621022 0.466053 1.172410 0.257155 1.744523 1.537620 0.413349 0.571480 -0.275441 1.147662 0.078171 1.318337 0.797128 0.465604 -0.167976 0.389127 0.046196 0.644876 0.600407 0.146824 1.140648 -0.196543 0.766952 -0.405128 0.495879 1.671836 -0.221864 0.393766 0.946119 0.917743 -0.256291 0.111525 0.645632 1.265055 0.181069 0.525294 0.880675 0.348447 0.049079 0.495123 0.135981 0.911089 1.141680 0.914015 0.556460 0.266976 -0.250402 0.919302 -0.007489 0.586097 -0.221631 1.012419 -0.545708 -0.213348 1.601484 1.279462 1.306339 0.757689 -0.274675 -0.570934)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.601468306037 #r(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     8.850182 #r(0.000000 0.518773 1.039139 0.586918 0.904434 1.417193 0.042683 1.631265 1.694438 1.514894 1.006690 0.003709 0.408784 0.798813 0.249575 0.591222 1.196003 0.490671 -0.162585 1.056459 0.214130 1.070048 0.595570 1.158267 0.152005 1.596646 1.763293 0.137802 1.031270 -0.729765 0.896998 0.017768 0.865646 1.014949 0.251509 -0.314516 0.635325 0.026002 0.490859 0.633543 0.639061 0.944000 -0.171048 0.686904 -0.554012 0.426662 1.660372 -0.276772 0.454353 0.868574 1.080144 0.004571 0.280163 0.786197 1.030805 0.611760 0.535564 0.235350 0.034299 0.186337 0.685227 0.115463 0.933270 1.148318 1.130052 0.634287 0.165289 -0.005574 1.017789 -0.425130 0.702068 -0.051211 1.238786 -0.554979 -0.075667 1.531212 1.295287 1.210341 0.841758 -0.323173 -0.539445 0.363396)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.429935034332 #r(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

	8.934963 #r(0.000000 0.388833 0.119269 1.159396 0.084041 0.831926 0.332635 1.176250 -0.176695 1.764815 1.577336 1.167712 1.277058 0.180565 1.483279 0.244455 1.639842 0.231019 1.628465 -0.143232 1.536821 0.704938 0.552153 1.530466 -0.224513 0.010496 0.034106 0.576377 0.939875 0.785468 0.829993 0.715502 0.968124 0.640032 0.396582 0.150458 0.935168 0.123648 0.408167 0.864017 0.545634 1.640474 1.473610 0.636166 0.133436 -0.003429 1.440429 0.982288 0.212836 0.743361 0.639874 1.101557 0.617385 0.271411 0.703361 1.525115 1.857795 0.954785 -0.022712 1.232732 0.327660 1.853705 1.028391 -0.134471 0.306948 0.357972 0.408006 0.063155 0.593195 1.406229 1.598252 0.790489 1.494874 0.055118 0.707198 1.527620 0.974145 0.561751 0.009624 0.051221 0.195975 0.865753 1.371065)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.774056434631 #r(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

	9.023210 #r(0.000000 0.159304 -0.208530 0.193874 1.193993 0.513874 0.193906 1.420202 1.601162 0.069662 0.596870 0.499106 1.879705 1.298791 1.380896 1.011752 1.567079 1.088823 0.586749 1.189212 0.187019 0.623891 0.443258 1.756821 0.221910 -0.166048 1.505325 1.956699 0.145006 0.858253 1.259810 1.292214 -0.292005 0.449812 -0.218977 -0.354252 1.219999 0.997645 1.646540 1.482430 0.239288 -0.155628 0.755326 1.705293 0.967714 0.360450 0.143064 1.152089 0.481087 0.972815 0.614833 1.330922 0.788019 0.726428 0.572863 1.454284 1.031818 0.764416 0.692179 1.019395 0.005944 0.083543 1.745841 0.713648 0.857380 1.260681 1.338561 0.608841 1.025699 1.518383 0.107569 1.492751 -0.040716 0.923284 0.288212 0.772164 -0.210851 0.728511 0.794985 1.593926 1.082153 1.208449 1.606070 0.581831)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.927130699158 #r(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

	9.049902 #r(0.000000 0.563123 1.178518 1.758860 0.262272 0.883025 1.653154 -0.112442 0.544375 1.449563 0.003632 0.735232 1.565378 0.629399 1.249832 -0.245154 0.975371 0.104021 1.230308 0.204936 0.728896 1.200090 0.453859 1.254730 0.634907 1.785857 0.910526 0.028528 0.512985 0.118173 1.563688 0.727580 -0.060681 0.935698 0.002572 -0.009819 1.543537 0.502740 1.889883 1.378460 0.440088 1.520721 1.385983 0.911951 0.319540 1.661394 1.403090 1.043647 0.698513 -0.258428 1.361759 1.190670 0.827100 0.772203 0.674858 0.223364 0.526333 -0.284078 1.542639 1.309275 1.167224 1.067830 0.912739 1.795861 0.867588 1.204585 0.683869 0.992895 0.650909 1.108031 1.113927 1.766016 1.326795 1.627701 -0.242386 -0.176337 0.105000 0.657052 1.065424 1.542526 0.021830 0.089779 0.582222 1.031000 1.120243)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.27362
(vector 86 11.780031204224 #r(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

	9.144898 #r(0.000000 0.553220 1.114143 1.907542 0.232990 0.842372 1.638290 0.002415 0.600151 1.441766 0.072607 0.770701 1.630141 0.524050 1.166300 -0.060704 0.988063 -0.011935 1.056235 0.044313 0.796954 1.351344 0.491264 1.317927 0.594365 1.770310 0.908994 -0.083046 0.803658 0.111996 1.532402 0.759402 0.036170 0.943179 0.079272 1.830583 1.382504 0.397346 1.856130 1.407405 0.379257 1.552501 1.336822 0.894256 0.259512 1.640642 1.404950 1.043723 0.498578 -0.255562 1.439871 1.113214 0.957074 0.794912 0.690668 0.138597 0.312164 -0.286212 1.710429 1.181779 1.119942 0.882351 0.853742 1.507047 0.801407 1.064423 0.722928 0.946894 0.773817 1.034859 1.074112 1.587958 1.477366 1.754829 -0.141780 -0.019862 0.118652 0.596035 1.023862 1.396961 0.052731 -0.006814 0.649298 1.055665 1.431062 1.786776)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
(vector 87 11.76194265333 #r(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.187891 #r(0.000000 0.562265 1.215132 1.639989 0.268408 0.803228 1.556396 0.052662 0.673897 1.370427 -0.013341 0.755625 1.613682 0.464097 1.303388 -0.037077 1.034992 -0.022117 1.014610 1.893157 0.718728 1.483506 0.494314 1.442488 0.545375 1.834445 1.096157 0.044881 1.127012 0.215102 1.425993 0.718653 0.082596 0.974151 0.052799 1.587090 1.187190 0.360476 1.852622 1.250947 0.372936 1.523300 1.264181 0.805702 0.081155 1.558372 1.276806 0.921107 0.347174 -0.241287 1.479655 1.180393 1.125004 0.659710 0.822627 -0.001295 0.310451 -0.262271 1.777140 1.247104 1.177750 1.114372 0.920013 1.374146 0.894221 0.877518 0.741864 1.020196 0.885904 1.001071 1.161793 1.551252 1.536508 1.802169 0.022015 -0.071435 0.050557 0.417817 0.866824 1.426867 1.751719 0.013618 0.498761 0.731015 1.470154 1.720066 -0.074032)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
(vector 88 11.638312339783 #r(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

	9.243448 #r(0.000000 0.697851 1.166665 1.665599 0.098169 0.813468 1.475112 0.101377 0.652595 1.273039 -0.081569 0.745524 1.591625 0.353099 1.188181 0.067828 1.161595 0.152496 1.082314 1.900802 0.588773 1.446857 0.379192 1.369274 0.475586 1.801340 1.037627 -0.178925 0.939324 0.188566 1.443075 0.665312 0.046982 1.052243 0.101080 1.498797 1.207289 0.409569 1.784327 1.271339 0.376759 1.422106 1.059422 0.802437 0.209481 1.613077 1.299497 0.983704 0.306573 -0.235197 1.532651 1.198072 1.226923 0.712611 0.934064 0.028480 0.165446 -0.347088 1.856068 1.322916 1.165417 0.930692 0.903535 1.267764 0.795402 1.061438 0.706954 1.032722 0.865689 0.907087 0.916387 1.610361 1.471937 1.742343 -0.052496 -0.040631 0.057803 0.155675 0.765103 1.291462 1.566099 1.820302 0.538939 0.627227 1.392483 1.674330 -0.144452 0.267627)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.148494905477 #r(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

	9.315509 #r(0.000000 0.124567 0.583351 0.597843 0.508932 0.236340 1.629251 1.260618 0.886324 0.407100 0.532057 0.464552 -0.228622 1.874560 1.586831 1.454279 1.336216 1.166281 1.089863 0.976652 1.146549 1.384070 1.107271 1.259583 1.540352 1.231987 1.112399 1.654619 1.894205 0.035892 0.522606 0.318613 0.597511 0.620237 1.103293 1.435193 1.365285 1.347328 0.516939 0.607227 1.150990 1.407334 1.775681 0.771851 0.945166 0.989030 1.801909 0.000987 0.826555 1.547883 0.480169 0.802373 1.360513 -0.158813 0.514706 1.271439 0.393074 0.883929 -0.039924 0.249141 1.389995 0.169046 1.414692 0.200776 0.896962 1.236745 0.582426 1.647885 1.121990 0.246958 0.721303 0.009183 0.987717 0.027886 0.854020 -0.153681 1.227081 0.324522 1.691772 1.126527 -0.020392 1.310045 0.754076 0.386463 1.500700 1.504277 0.417697 0.239864 1.723507)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.059710502625 #r(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

	9.369284 #r(0.000000 0.030596 0.512977 0.726782 0.477829 0.081885 1.589694 1.322061 1.083902 0.559521 0.448753 0.385931 -0.189736 1.722513 1.513355 1.392162 1.333913 1.122941 1.145305 1.071310 1.267721 1.283537 1.282341 1.395603 1.460843 1.220013 1.214982 1.532704 1.680386 -0.041828 0.369697 0.425933 0.371638 0.589333 1.041407 1.225589 1.172832 1.376354 0.162279 0.498805 1.164883 1.416170 1.867958 0.505897 0.978762 1.054842 1.522372 -0.063766 0.952495 1.463756 0.521257 0.824505 1.179094 1.811681 0.447390 1.180931 0.235815 0.652944 -0.161883 -0.021774 1.283901 -0.087905 1.281512 -0.144202 0.579788 1.336977 0.409226 1.333107 0.963576 0.011530 0.529499 1.655761 0.578200 1.742908 0.613593 -0.239938 1.074047 0.302129 1.602392 0.926017 -0.218685 1.216630 0.428055 0.183727 1.506714 1.185120 0.296902 -0.071562 1.483831 0.585762)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.130150794983 #r(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

	9.406571 #r(0.000000 0.070183 0.558945 0.616954 0.488264 0.097581 1.643944 1.396224 1.158953 0.725014 0.517196 0.327654 -0.169876 1.614114 1.687774 1.412838 1.174539 1.259505 1.130798 1.052361 1.015956 1.267208 1.254231 1.379495 1.394559 1.223329 1.348807 1.448672 1.402107 -0.114780 0.204211 0.407141 0.213819 0.557195 0.878563 1.293773 1.227658 1.440547 0.218508 0.668102 0.992197 1.450344 1.592835 0.514105 0.745631 1.232389 1.450929 -0.020833 0.958476 1.514641 0.316511 0.755172 1.221264 1.755846 0.507669 1.139584 0.110724 0.749907 0.055238 0.050342 1.322976 0.038212 1.303755 -0.169105 0.463456 1.427795 0.697605 1.381025 0.968559 0.022635 0.695622 1.792840 0.529902 1.903317 0.747931 -0.193306 0.982955 0.298689 1.702098 1.077145 -0.265151 1.140052 0.371003 -0.055705 1.235675 1.006638 0.294853 1.755510 1.459678 0.647624 -0.081756)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
(vector 92 12.009957507951 #r(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

	9.419885 #r(0.000000 0.069529 0.633901 0.633608 0.570434 0.157518 1.715794 1.321616 1.084449 0.794466 0.425008 0.283514 -0.131990 1.646881 1.533838 1.442714 1.177599 1.239726 1.207883 1.015321 0.976921 1.262383 1.278818 1.276322 1.338824 1.226865 1.318320 1.361295 1.375488 -0.072989 0.149612 0.367026 0.181636 0.504697 0.851522 1.286853 1.425655 1.395838 0.306909 0.627046 0.973004 1.385102 1.455309 0.477354 0.684776 1.138509 1.548279 -0.072451 0.798558 1.262715 0.056514 0.791921 1.056616 1.695546 0.434938 1.116470 0.025573 0.789168 -0.006184 0.138467 1.335319 0.002519 1.259750 -0.081984 0.549375 1.443475 0.683161 1.338585 0.966058 1.876977 0.624731 1.787187 0.503447 1.917935 0.840074 -0.187662 1.042424 0.183738 1.737882 1.038721 -0.194530 1.214452 0.488651 0.014114 1.273532 1.004556 0.303820 1.746128 1.409399 0.765865 0.191028 1.596552)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.125471062226 #r(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.412639 #r(0.000000 0.102641 0.679230 0.798388 0.598526 0.445036 1.682481 1.416478 1.010866 0.838753 0.518866 0.185140 -0.260801 1.643327 1.645133 1.587871 1.510095 1.367190 1.252764 1.075109 0.997402 1.226792 1.097666 1.109286 1.266675 1.142806 1.396415 1.366757 1.323435 -0.151657 0.110933 0.254314 0.125232 0.426419 0.874355 1.227943 1.386454 1.437438 0.183960 0.673205 0.896736 1.317085 1.421345 0.557215 0.650544 0.979705 1.599286 -0.027664 0.967924 1.389243 -0.027060 0.800953 1.098758 1.686133 0.493843 1.257456 0.105617 0.800125 0.006765 0.139250 1.353019 -0.059007 1.198209 0.066444 0.431719 1.470864 0.547882 1.294688 0.757592 1.690943 0.714913 1.735237 0.542409 1.804533 0.779629 -0.296056 1.090213 0.178123 1.832019 1.000948 -0.131923 1.161644 0.360890 0.065736 1.232224 0.792139 0.176636 1.688866 1.432871 0.734257 0.042563 1.592538 0.764029)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.510846178591 #r(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

	9.543681 #r(0.000000 0.070784 0.635867 0.742637 0.475019 0.302813 1.825409 1.378229 1.077426 0.877718 0.610301 0.202771 -0.182277 1.673466 1.553357 1.494058 1.368050 1.336285 1.249015 1.094284 1.026782 1.245912 1.085605 1.018283 1.167850 1.013374 1.392524 1.418879 1.281568 -0.274841 -0.022454 0.129657 0.125509 0.504384 0.935744 1.276977 1.483975 1.477426 0.196761 0.675603 0.862408 1.192185 1.459380 0.549610 0.569998 1.001464 1.695499 0.066362 0.898853 1.281654 0.050116 0.806388 1.047653 1.730201 0.520253 1.351614 0.000078 1.010541 -0.167505 0.168460 1.307105 0.008313 1.198293 0.190292 0.394166 1.604739 0.575546 1.381303 0.832277 1.821709 0.813449 1.752392 0.618919 0.026374 0.880532 -0.283635 1.155422 0.216026 1.884068 1.144874 -0.171918 1.125849 0.302834 -0.082892 1.104687 0.762677 0.111766 1.593198 1.158618 0.738387 -0.017688 1.548369 0.670450 -0.209765)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.431831359863 #r(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

	9.594917 #r(0.000000 1.389542 1.176101 1.128189 0.857825 0.606938 0.053944 1.193702 0.869053 0.060247 1.681618 -0.018030 0.093189 1.777775 1.314304 1.617940 0.848617 -0.108633 0.918764 1.157666 0.455570 1.631612 1.168101 0.785976 0.402697 1.470789 1.252874 0.702336 1.782377 1.673658 1.631189 1.349352 1.050241 0.712255 1.786745 0.232201 0.625268 1.043139 1.455512 1.195110 0.998337 0.283110 0.709026 0.841439 0.900171 1.560899 0.398341 0.605576 1.226269 0.101415 0.662630 -0.080073 0.123777 0.243381 0.746050 1.688701 0.805710 -0.417799 1.076341 1.138430 0.020724 1.738280 0.026371 0.359523 1.207908 0.092412 0.589896 1.141872 0.833369 1.211938 0.834700 0.366724 0.985159 0.093930 1.781990 0.844009 1.324575 1.222996 -0.119995 1.044915 0.191275 1.202233 0.891410 1.663012 1.114750 1.562345 -0.205599 1.605273 0.019367 1.356810 0.858474 1.006151 -0.416772 0.195895 1.774084)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.586637130548 #r(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

	9.698754 #r(0.000000 1.686945 0.467972 0.353719 0.039839 1.529803 1.113587 1.518769 0.069518 0.641616 0.744046 1.828910 0.013471 -0.229934 0.181085 -0.011815 0.130449 1.033538 1.435542 1.445735 1.524439 1.088117 0.632800 0.518998 -0.093855 1.447748 -0.258898 0.540666 0.708408 1.141240 0.388952 0.533151 0.107615 0.843908 1.797589 1.037747 1.105446 0.651000 0.775586 -0.512743 0.563193 0.707947 1.740714 1.753866 0.373300 1.459832 0.879332 1.133261 0.035182 1.481640 1.284446 0.744828 1.229402 -0.449568 1.081113 -0.235470 0.939023 1.698241 1.413068 -0.279150 0.681300 1.084041 -0.075079 0.087600 0.709157 -0.062761 0.870661 0.903931 0.019006 1.008038 -0.009901 1.442216 1.097881 0.558710 1.835109 1.151033 1.232982 1.137424 0.991349 -0.312466 0.156001 0.908045 0.922926 1.582365 1.057816 0.119723 1.368068 0.167350 -0.363438 0.279779 0.391520 0.751632 -0.048111 1.271729 1.046123 1.547668)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.585 #r(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
     9.733625 #r(0.000000 -0.316389 0.763514 1.085136 -0.007054 1.613164 0.368355 0.497362 0.266819 0.792626 1.605095 0.379462 0.795808 0.617439 0.340832 1.408797 0.884588 0.777692 -0.061819 1.329857 1.611199 0.024913 1.778069 1.061965 1.317076 1.286538 -0.063928 0.439816 1.190286 1.720423 -0.281159 0.284236 1.261293 1.715607 1.258044 1.027201 0.992940 1.404704 0.918469 0.571955 0.670954 -0.578424 1.681045 1.759567 -0.365702 0.685884 0.480691 0.685380 0.103522 0.029224 1.512644 0.122325 0.600548 0.070986 0.493468 0.652824 -0.059890 1.290005 1.370566 0.135509 0.143591 -0.197126 0.478025 0.315521 0.839450 0.083388 0.553358 1.161959 0.770340 1.132488 0.641596 1.702281 0.277494 1.930557 0.772636 0.175945 1.352904 0.123527 1.448091 0.194310 0.330488 1.631688 1.302741 0.566332 1.521760 0.740046 0.257004 1.532435 0.681554 0.238673 0.612205 0.128510 1.851063 0.280067 1.237302 -0.034034 0.240185)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.724907890996 #r(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

	9.767029 #r(0.000000 -0.188323 0.675144 1.162326 -0.152620 1.669640 0.370125 0.494628 0.190555 0.715197 1.719005 0.377693 1.013961 0.545798 0.345914 1.535759 0.968261 0.937780 -0.119329 1.630311 1.635898 0.029531 1.850111 1.208612 1.298337 1.226547 0.020306 0.388794 1.210462 1.649716 -0.158605 0.268380 1.285081 1.672163 1.145021 0.908520 1.140268 1.468740 0.844848 0.440912 0.760836 -0.415872 1.889804 1.724959 -0.229249 0.766901 0.564605 0.613211 0.221081 -0.012880 1.521722 -0.044019 0.593078 0.034669 0.491432 0.559669 -0.045684 1.255880 1.344088 0.070215 0.282883 -0.229690 0.625053 0.504422 0.811212 -0.012186 0.589513 1.241057 0.831526 1.215774 0.684110 1.651422 0.305036 1.891476 0.747710 0.040696 1.539490 0.154881 1.456564 0.357589 0.123799 1.523900 1.179657 0.504889 1.418226 0.850462 0.009923 1.481216 0.600938 0.216302 0.543002 0.255145 1.787452 0.279328 1.172852 -0.085076 0.199219 1.196556)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.002375571256 #r(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

	9.827383 #r(0.000000 0.489851 0.987809 -0.394189 1.760605 0.036969 0.958351 1.266375 1.844806 0.928905 0.347370 0.708814 -0.213250 0.135838 0.840288 1.524164 -0.453078 -0.222429 1.664862 1.650792 0.843217 0.096982 0.106278 -0.254905 0.311964 1.356301 0.208474 1.484260 1.533307 0.693746 1.221284 1.494648 1.192154 0.704448 1.399404 0.773577 0.730819 0.230112 1.305343 0.384931 0.092126 -0.177018 0.678108 0.424573 1.876518 -0.110628 1.580149 0.105746 0.460598 0.667046 -0.301428 1.430147 1.462027 1.200592 0.294468 0.132684 -0.034510 -0.232945 -0.131872 0.235724 -0.003826 0.390220 0.478949 0.708773 0.158613 1.284193 -0.406418 0.372748 0.269091 -0.683069 0.298317 0.742905 1.467502 0.490499 1.200844 0.658586 1.777690 1.768714 0.250192 0.808599 1.653844 -0.705600 1.331238 1.087732 0.038158 0.351212 1.574369 1.702783 0.145504 1.240857 0.779939 1.689313 1.071204 0.299434 1.500921 0.518280 1.343637 1.492826 1.331082)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
(vector 100 12.998435541498 #r(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

	9.828147 #r(0.000000 0.606381 0.917097 -0.052963 1.840850 0.076195 1.000382 1.379573 1.713959 1.056049 0.567183 0.755185 -0.243029 0.240141 0.901208 1.696896 -0.401067 -0.172213 1.702278 1.572589 0.995369 0.092107 0.339155 -0.047255 0.209942 1.548195 0.250627 1.493833 1.397582 0.850788 1.234138 1.694866 1.205737 0.609514 1.413541 0.774375 0.843373 0.256747 1.182652 0.287452 0.151651 -0.040175 0.718613 0.370108 1.797287 0.037564 1.483372 0.063366 0.673221 0.647681 -0.130882 1.410330 1.289134 1.259368 0.378589 0.179096 -0.077706 -0.126123 -0.197835 0.087734 0.222460 0.660561 0.798643 0.833272 0.064575 1.260850 -0.205610 0.363184 0.404543 -0.579680 0.559469 0.652793 1.526709 0.333879 1.432283 0.642498 1.543163 1.637538 0.499172 0.795803 1.495177 -0.493071 1.544279 1.224387 0.125780 0.527014 1.451448 1.716932 0.232752 1.503302 0.799684 1.669661 1.257116 0.363202 1.442143 0.833946 1.525977 1.616490 1.388269 0.088027)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.219774246216 #r(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

	9.921866 #r(0.000000 0.609806 0.853415 -0.178376 1.715639 0.125045 0.929898 1.476379 1.662595 0.957740 0.451135 0.781655 -0.427268 0.272758 0.818830 1.769523 -0.423916 -0.099803 1.673197 1.666031 0.957481 0.001110 0.369464 0.033970 0.216228 1.474165 0.268320 1.512523 1.483804 0.905565 1.174848 1.613266 1.125148 0.735425 1.428468 0.800602 0.802242 0.149205 1.137841 0.417883 0.150486 -0.027202 0.838573 0.398456 1.843236 -0.009638 1.452756 0.256842 0.733285 0.629225 -0.121467 1.285077 1.401085 1.159273 0.424114 0.225501 -0.029926 -0.145884 -0.166779 -0.070962 0.279800 0.763832 0.738411 0.899842 0.214924 1.297806 -0.216209 0.533724 0.471481 -0.437480 0.570518 0.814214 1.466310 0.243161 1.457087 0.616447 1.631480 1.653547 0.454623 0.836976 1.700774 -0.681521 1.358712 1.514908 0.139939 0.422637 1.532737 1.719310 0.035224 1.562793 0.575545 1.665604 1.357164 0.300428 1.567753 0.710501 1.494752 1.484684 1.466794 0.007458 0.066101)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.194128990173 #r(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      9.999728 #r(0.000000 0.816321 0.637377 0.345148 0.370938 -0.276054 0.911607 1.500056 0.306062 0.790557 0.435222 0.904894 -0.191779 0.048392 0.194431 0.115956 1.667616 0.992921 1.656976 -0.052697 -0.117059 1.375805 0.940264 1.270518 1.293832 0.011597 0.625970 1.355481 1.224093 1.039601 0.449887 0.805739 0.950859 0.738520 0.174875 0.191457 -0.433487 1.473827 1.049203 1.269233 0.624622 -0.685355 0.429236 0.942447 1.442405 0.657046 -0.121011 1.211024 0.340089 1.400597 1.568255 1.012470 1.153465 1.450019 0.074731 1.166228 1.006182 0.717416 1.410198 0.328986 1.433746 0.699736 1.482788 1.837097 1.328917 0.778439 0.165472 0.752659 0.035502 1.456631 0.791084 1.409037 -0.237446 1.429494 0.422722 0.146817 -0.260727 0.839136 0.358089 1.270740 1.006772 -0.235207 0.256828 0.253288 0.716702 0.519351 0.455918 0.685843 1.184617 1.591454 0.861383 1.138751 0.863117 1.629288 0.841736 1.491610 -0.065444 0.127160 0.950055 0.171078 0.161369 0.979305)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.435972213745 #r(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

	9.936450 #r(0.000000 0.693644 0.706899 0.533961 0.430990 -0.357687 1.008502 1.374702 0.412678 0.741797 0.480081 1.019998 -0.130973 0.053049 0.311034 0.176361 1.575930 1.070088 1.721818 -0.094212 -0.064284 1.475356 0.919353 1.359786 1.249341 0.013083 0.514667 1.199770 1.229977 1.008921 0.437274 0.710316 0.870077 0.789348 0.187900 0.290913 -0.370061 1.358992 0.912977 1.233039 0.528258 -0.736479 0.451532 0.908453 1.426336 0.514161 0.001487 1.299314 0.308671 1.371317 1.605556 0.910902 1.236094 1.469478 -0.163740 1.081131 1.027298 0.436227 1.399959 0.293762 1.463416 0.759976 1.365407 1.783410 1.210381 0.856808 0.150643 0.958655 -0.052444 1.555663 0.803912 1.301037 -0.234888 1.489758 0.433564 0.214734 -0.174858 0.935477 0.468519 1.406960 1.062581 -0.199662 0.290782 0.285152 0.771353 0.684526 0.389441 0.762788 1.291542 1.444611 0.892838 1.229118 0.775000 1.690738 0.620913 1.533937 -0.049548 0.336829 0.889832 0.374353 0.184623 1.007735 1.061825)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.330215043333 #r(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

	10.017453 #r(0.000000 0.745577 0.754726 0.591226 0.316735 -0.304732 0.899502 1.291541 0.545628 0.772480 0.260199 0.994494 0.010830 -0.025236 0.470134 -0.206891 1.625282 1.051660 1.804596 -0.290274 0.044351 1.520736 1.169238 1.579583 1.507532 -0.098601 0.554891 1.115436 1.434077 1.033226 0.173646 0.501686 0.832596 0.961466 0.155369 0.671140 -0.251224 1.186790 0.870343 0.942036 0.540730 -0.482603 0.541428 1.032737 1.176541 0.575710 0.196818 1.248017 -0.309128 1.373931 1.309926 0.661951 1.095129 1.475952 -0.067947 1.122542 1.395225 0.407986 1.356975 0.251359 1.416747 0.875553 1.007359 1.720145 0.906470 0.746959 0.314821 1.255928 0.123650 1.421810 0.602637 1.336189 -0.398002 1.545393 0.941942 -0.105497 0.032645 0.903719 0.429973 1.262454 1.203968 -0.177843 0.186621 0.130389 0.458896 0.322543 0.256192 0.884272 1.238132 1.393568 1.126227 1.031989 0.626539 1.697275 0.820678 1.808099 -0.040685 0.161330 1.012238 0.476235 0.102962 0.907998 1.239960 0.369514)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.595993876506 #r(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

	10.063561 #r(0.000000 0.681917 0.800545 0.422200 0.553031 -0.358791 0.792275 1.464678 -0.019974 0.698355 0.554660 0.858955 0.164181 -0.019183 0.163011 0.345816 1.622067 0.956173 1.657341 -0.303259 -0.187543 1.270627 0.778435 1.434875 1.149544 -0.073515 0.340352 1.321088 1.319472 0.949179 0.543646 0.516189 0.877323 1.039058 0.094178 0.386382 -0.389059 1.561917 1.166614 1.288418 0.753780 -1.134975 0.286121 0.840573 1.554402 0.666717 -0.096764 0.924388 0.213118 1.501876 1.581562 0.980168 1.340301 1.650719 -0.197635 1.506340 1.243795 0.380830 1.653721 0.258877 1.593702 0.606867 1.330583 1.752876 1.189965 0.751133 0.302075 0.827786 -0.217646 1.553498 0.803802 1.267631 -0.133418 1.463956 0.053990 -0.008952 -0.356111 0.855322 0.196092 1.378596 1.181998 -0.269211 0.103217 0.082299 0.566694 0.929139 0.150334 0.640354 1.229212 1.430106 0.787460 1.158173 0.885012 1.662401 0.755054 1.382697 -0.076381 0.402460 1.158400 0.558679 0.000097 1.098492 0.924207 -0.557968 -0.463825)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.200031373463 #r(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

	10.179541 #r(0.000000 0.771216 0.798169 0.574042 0.509021 -0.454539 0.722595 1.382180 0.188162 0.639751 0.416025 0.934627 0.075422 0.041033 0.257004 0.360076 1.637659 1.021990 1.620175 -0.251486 -0.173697 1.345557 0.774305 1.358151 1.178428 0.048243 0.190927 1.354610 1.390083 0.925624 0.585662 0.586630 0.925417 0.930772 0.084986 0.308253 -0.510266 1.508313 1.202180 1.312826 0.712764 -1.217280 0.291519 1.029037 1.475318 0.702806 -0.072479 0.840059 0.187882 1.417657 1.468702 1.001289 1.223142 1.644299 -0.182528 1.499144 1.198899 0.364912 1.508768 0.234745 1.494112 0.521884 1.439753 1.612428 1.042749 0.871259 0.313122 0.872774 -0.384718 1.449386 0.726766 1.126118 -0.147831 1.347158 0.064750 0.128074 -0.342700 0.813748 0.226859 1.421859 1.020298 -0.363011 0.016155 0.192420 0.585619 0.784178 0.021472 0.652147 0.963182 1.437033 0.624162 1.231941 1.005289 1.412507 0.736078 1.181129 -0.186935 0.322466 1.015056 0.519117 0.114263 1.113370 0.730072 -0.587500 -0.573316 0.170672)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.224366750161 #r(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.250733 #r(0.000000 0.483912 0.644703 0.485457 0.358095 -0.305666 0.780949 1.722379 -0.020746 0.621961 0.474887 0.971799 -0.081593 -0.221790 0.024110 0.159431 1.699382 0.876421 1.571715 -0.219801 0.072621 1.464672 0.630752 1.380382 1.117163 -0.134137 0.232594 1.352288 1.269630 0.968806 0.240910 0.258155 1.001406 1.216432 0.053369 0.232245 -0.359904 1.509850 1.180087 1.054981 0.826371 -1.018830 0.149841 0.846847 1.251712 0.455512 0.004303 0.938417 0.112890 1.231211 1.569892 0.646448 1.305537 1.558830 -0.235146 1.425032 1.086297 0.226783 1.288076 0.237137 1.561589 0.408735 1.240009 1.521331 0.873481 0.444503 0.123500 0.794180 -0.670582 1.202161 0.762118 1.019326 -0.305420 0.938305 0.222385 0.150427 -0.405430 0.790658 0.185984 1.703676 1.080860 -0.394708 -0.083973 0.462509 0.451296 0.730919 -0.196866 0.882952 1.029031 1.285788 0.753984 1.256801 0.794497 1.368238 0.490612 1.208438 -0.307623 0.448339 0.892856 0.519789 -0.067328 1.081789 0.866642 -0.521116 -0.524606 -0.471314 -0.243671)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
(vector 108  13.534 #r(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

	10.312988 #r(0.000000 1.293654 0.754043 1.806542 1.109001 0.766775 1.436021 1.627340 0.528605 1.806494 1.181378 0.013554 0.353388 0.092480 0.431618 0.200495 0.904126 0.741464 0.675051 -0.110957 1.146773 1.810641 0.552983 0.275055 0.835876 1.123930 -0.182193 -0.339155 0.645146 0.163632 0.868047 1.269556 0.830686 1.219557 1.665806 1.060039 1.944315 -0.011848 0.365415 0.718256 0.624511 1.571990 0.113371 0.572031 1.797961 0.876379 0.068642 0.072119 0.553161 0.329387 0.545574 0.337595 1.647194 1.034042 0.468339 1.774314 0.240404 1.846502 1.142528 1.223731 0.832499 0.428931 0.643890 1.257704 1.085969 0.643637 0.429070 0.971966 0.109095 0.689833 0.417898 1.804672 1.346983 0.150026 0.404292 0.575881 1.441149 0.533070 -0.177095 0.298641 0.921545 1.086883 0.410704 0.849120 1.518187 1.874571 0.517824 1.242109 -0.053714 0.834159 0.276990 1.956354 1.765190 1.537622 1.530954 -0.106766 1.325278 -0.071959 1.045056 0.533410 0.699958 0.068418 0.070057 1.204618 1.620552 1.072110 1.372120 0.848823)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.440306508911
(vector 109 13.496821304096 #r(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      10.316139 #r(0.000000 0.467860 1.225582 -0.051091 0.323359 1.199983 1.366975 0.187719 0.660883 1.253225 0.082708 0.616737 1.474208 0.120695 0.946148 1.740641 0.509628 1.149625 -0.031684 0.627981 1.494201 0.523906 1.719545 0.517678 1.423044 0.134403 1.080799 0.058887 1.146126 0.223450 1.240782 0.320888 1.420488 0.499238 -0.036895 1.166877 0.079242 0.965835 -0.026305 1.082043 0.407016 -0.078901 0.951307 0.084236 1.509812 0.984128 0.155672 1.326788 0.624829 0.033701 1.214113 0.999905 0.359963 0.181048 1.698251 1.226178 0.741043 -0.169162 1.197122 0.969420 0.565193 0.157309 1.679759 1.648950 1.194633 1.269799 0.462660 -0.066040 -0.191739 1.394509 1.412861 1.398929 0.890176 1.092218 0.605306 1.201780 0.531418 0.616650 -0.032708 -0.104746 -0.085490 -0.136596 0.060249 0.261684 0.098136 -0.024191 0.030064 0.203361 0.438227 0.265314 0.225969 0.675420 0.938390 1.248614 1.479216 1.714123 -0.073635 -0.128780 0.326731 0.554524 1.126561 1.604426 1.604094 0.214665 0.842457 1.393251 1.611608 0.158085 0.161986)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.592092514038 #r(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.384532 #r(0.000000 0.497058 1.308854 -0.040087 0.317842 1.212991 1.348869 0.169218 0.937322 1.141868 -0.161541 0.702285 1.374915 0.105577 0.895118 1.715852 0.486357 1.126045 0.027516 0.506764 1.422714 0.578087 1.785847 0.360577 1.340809 0.040639 0.924986 -0.064845 1.218475 0.441481 1.282493 0.367747 1.417112 0.662713 0.020057 1.075916 -0.019298 0.721943 -0.067674 0.989188 0.221610 -0.166666 1.205634 0.245282 1.512389 1.116780 0.133433 1.209361 0.683941 0.136270 1.207963 0.840404 0.407464 0.237523 1.553628 1.290834 0.738111 -0.201487 1.118700 0.992136 0.530099 0.232821 1.709001 1.753916 1.400184 1.373110 0.591245 -0.001719 -0.097997 1.485341 1.510549 1.267389 0.699366 1.037211 0.446472 1.249648 0.436481 0.541104 -0.183563 -0.029851 -0.044651 0.058473 -0.046411 0.519596 0.324425 0.295881 0.020130 0.121258 0.421385 0.343422 0.175010 0.744278 0.928241 1.278265 1.460120 -0.158640 -0.046458 -0.164552 0.259068 0.355794 1.089478 1.431301 1.606926 0.103582 0.653958 1.133151 1.513113 0.087404 0.126034 0.426687)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.80813938144 #r(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

	10.443480 #r(0.000000 -0.037648 1.480547 0.898464 0.849030 0.715984 0.623417 1.093452 1.045921 0.246543 -0.344784 0.997605 0.429765 1.643868 1.074256 0.709084 1.236163 1.022832 0.593800 1.797589 1.639095 0.499474 0.451589 0.525734 0.819269 1.059245 1.215835 0.300337 0.312343 0.508727 1.809376 1.802285 0.733765 0.697253 0.213017 0.226942 0.966882 -0.054080 1.879864 1.400510 1.357810 0.290115 0.291026 1.461469 1.516948 0.034933 0.486567 0.403300 0.540306 0.175821 0.605359 0.053443 -0.120390 0.105172 0.600333 0.664197 1.296750 -0.152576 0.244035 0.980125 0.718707 -0.396109 0.441995 0.857389 0.411314 0.615877 0.959296 0.472542 0.178066 1.504140 1.379940 1.172606 -0.073019 1.778815 0.168644 0.842220 -0.533009 0.218109 1.118845 -0.068508 0.820652 0.991755 -0.019081 1.121993 1.252324 1.508966 1.128293 0.270315 0.609971 -0.037115 1.065942 0.157780 1.138199 0.066912 1.242092 -0.087703 0.391351 0.761091 0.405427 0.623899 1.599600 0.333353 -0.321760 0.806575 1.571941 1.193797 1.308207 1.479299 1.022704 -0.056211 1.366886)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.719 #r(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

	10.459590 #r(0.000000 -0.062913 1.592216 0.942127 0.779122 0.819196 0.718354 1.051311 1.122277 0.289276 -0.312849 0.932738 0.364926 1.651917 1.193754 0.735359 1.259741 0.983056 0.504666 1.898067 1.619072 0.449638 0.460210 0.529471 0.685535 0.885439 1.297728 0.246636 0.353836 0.474674 1.786116 1.844574 0.794031 0.522576 0.168364 0.225941 0.884728 0.029172 1.770209 1.576812 1.352123 0.112130 0.389134 1.458224 1.532633 -0.027079 0.404717 0.274263 0.478667 0.228414 0.618491 0.032636 -0.068031 -0.092335 0.583363 0.722295 1.283590 -0.207344 0.372473 0.858879 0.815320 -0.324439 0.478159 0.803167 0.466456 0.633813 0.914568 0.438946 0.113725 1.518872 1.409010 1.227714 -0.134104 1.718626 0.277412 0.813327 -0.439158 0.260660 1.183284 -0.118611 0.754421 1.157336 0.232930 1.195932 1.264381 1.427453 1.112389 0.316426 0.581550 -0.107354 0.998672 0.153435 1.101697 1.916684 1.183525 -0.016743 0.301725 0.815282 0.398182 0.676231 1.536900 0.451259 -0.254624 0.791021 1.692791 1.255094 1.233704 1.361151 1.046040 0.024905 1.319507 0.390306)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
(vector 113 14.027848738379 #r(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.533209 #r(0.000000 0.701701 1.023037 1.805117 0.325103 0.864669 1.301988 0.041817 0.605545 1.212149 1.794798 0.682259 1.361354 0.200642 1.040014 1.570001 0.413916 1.135956 1.836914 0.609510 1.482300 0.433561 1.396354 0.242061 1.189941 0.064290 0.924650 1.865499 0.844070 1.972890 1.045011 0.019512 1.010788 0.256118 1.454283 0.372006 1.414933 0.757156 1.833026 0.854510 0.058898 1.301933 0.794807 0.059810 1.092848 0.343912 1.857250 1.216439 0.367607 1.585969 1.093436 0.524265 1.847968 1.349059 0.839561 0.495981 1.801236 1.298227 0.638863 0.266374 1.658935 1.480658 0.907119 0.639357 0.037985 1.986216 1.525743 1.288722 0.717261 0.704091 0.182223 0.044649 1.629714 1.819647 1.366848 1.330078 1.172022 1.015716 0.897536 0.806098 0.193895 0.422839 0.374579 0.235069 0.423986 0.463374 0.446056 0.493571 0.177728 0.437229 0.621846 0.665477 0.619012 0.807147 1.289974 1.297164 1.517281 1.924928 0.144210 0.370826 0.244142 0.591610 0.749322 1.350513 1.818547 -0.017393 0.517731 1.113988 1.244052 1.823099 0.067707 0.517248 0.930474)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.847382931726 #r(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.517948 #r(0.000000 0.513150 0.874296 0.883964 0.730138 0.492200 1.910349 0.914831 -0.079055 1.078332 -0.626669 0.137543 -0.184379 1.218055 -0.394114 -0.038192 1.661163 0.020764 -0.078690 -0.096176 0.170832 0.906574 0.889519 0.505117 0.670269 1.228477 0.365822 0.917034 1.728829 0.934323 0.199610 0.715554 0.056223 1.583731 0.085811 0.136885 0.354627 0.123817 -0.315376 1.492556 0.991663 -0.233639 1.201411 1.218512 1.753756 1.719460 0.679044 -0.197393 1.570682 1.193787 1.873756 0.557014 1.432466 0.588568 0.309382 1.651394 1.357542 1.190693 0.264093 1.733513 1.676510 1.179474 0.616239 0.734925 1.107757 1.048586 0.066290 1.132123 1.205852 -0.090603 0.754355 0.838256 -0.013038 0.421890 0.968163 1.389079 1.284090 1.323690 0.432981 1.323326 0.730210 1.395732 0.109710 0.246664 1.169930 -0.449126 1.545991 0.365384 0.076032 -0.458822 1.876049 1.124853 -0.255218 1.423147 1.451143 0.955505 0.281503 0.928421 1.983790 -0.130994 1.684131 0.142847 1.010533 0.452692 -0.386536 1.218551 -0.132981 1.371320 0.120371 0.410528 1.083879 0.496636 1.350228 -0.127680)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.359978160099 #r(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

      10.621744 #r(0.000000 0.519128 0.786784 0.918158 0.650178 0.457293 1.964414 0.915637 -0.037992 1.187864 -0.612331 0.073197 0.008576 1.197804 -0.364310 0.047620 1.612311 0.098163 -0.054077 -0.087970 0.039413 0.986129 0.969342 0.451170 0.648283 1.253012 0.349815 0.949459 1.680558 0.960988 0.220312 0.666892 -0.069695 1.584459 0.070346 0.154295 0.414900 0.222762 -0.268103 1.413909 0.961497 -0.210113 1.203087 1.172411 1.792543 1.742069 0.706989 -0.208070 1.562128 1.211841 0.011662 0.482644 1.455971 0.642656 0.264522 1.637721 1.461442 1.154901 0.149110 1.871307 1.810194 1.307963 0.530941 0.678563 1.057540 1.204932 0.204765 1.173394 1.102820 -0.082769 0.639150 0.715081 -0.172130 0.444439 1.033638 1.431627 1.223005 1.352911 0.473564 1.345853 0.701386 1.441324 0.065510 0.263153 1.148218 -0.395379 1.422829 0.339640 0.186555 -0.374702 1.783978 1.192276 -0.175028 1.327174 1.534754 1.031453 0.306400 0.980338 0.017668 -0.122396 1.685264 0.121507 0.952038 0.457874 -0.310268 1.350976 -0.129566 1.387678 0.182170 0.404390 1.132228 0.552993 1.477216 -0.117535 0.087972)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
(vector 116 14.175787507646 #r(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

	10.666895 #r(0.000000 0.794041 0.130396 1.155449 0.575356 1.670182 1.438030 0.802411 -0.073881 0.612189 1.011030 0.243247 1.424701 1.360754 0.519915 1.303274 0.114440 0.486440 1.248641 -0.062831 1.818237 1.003329 1.774020 0.995383 0.217514 0.236196 0.918414 0.251978 0.240543 1.203872 1.193015 1.546847 0.668684 0.276657 0.720261 0.041331 0.124685 1.052830 -0.470877 1.036338 0.454033 1.208580 1.059685 0.252464 0.910634 -0.469687 1.282886 1.260566 1.714177 0.148852 1.558794 0.117249 1.208112 1.206944 1.379709 1.280227 -0.397300 1.912745 1.609055 0.469506 1.102260 0.207876 1.456855 1.808614 1.436770 0.080959 1.197513 1.183739 1.574767 0.068412 1.162064 0.609158 0.566278 1.029997 1.123257 -0.210554 1.006729 1.012851 0.184672 1.531574 1.788773 1.233395 0.609493 0.767948 1.753741 1.423961 0.953617 0.300031 0.940377 0.324215 0.472402 0.042965 0.104811 0.217444 1.091263 1.136923 1.660947 0.519559 1.199475 -0.360436 1.523678 1.224456 -0.014998 1.278905 -0.475457 -0.462757 0.028990 0.974163 1.009397 0.422500 0.343570 0.466660 0.909671 0.746952 -0.297506 0.078048)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.136 #r(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

	10.740323 #r(0.000000 1.376267 1.204802 1.617264 0.013985 1.562933 1.297010 -0.381289 0.175690 0.812406 0.271907 -0.572032 0.505210 1.569967 0.483045 1.266493 1.587294 0.516881 0.600232 0.990644 0.302416 1.037870 1.417076 1.853643 -0.147420 0.890223 1.567662 0.981809 0.815941 1.608390 -0.281550 0.201337 1.556451 1.125175 -0.236163 1.445336 0.258466 0.600771 0.570165 0.048623 0.131732 0.130088 0.167451 1.924952 -0.030799 0.148010 1.615329 0.361965 0.025922 1.817684 1.449080 1.328054 1.692177 0.082231 0.922069 0.868297 0.602630 -0.302067 1.498947 0.796296 -0.211597 1.912831 0.263824 1.087462 0.264795 1.339326 0.746964 1.555264 0.991573 0.792728 0.572734 0.831900 1.561482 0.487864 1.625032 1.584684 1.155708 1.141107 1.673417 0.421621 -0.187613 1.264593 1.627549 0.823098 0.254093 0.097500 0.358549 1.789940 1.103526 1.081236 0.794597 1.136333 1.473853 1.388624 -0.112319 0.798455 -0.090384 -0.176678 0.782426 -0.241572 0.802635 1.296656 0.310053 1.464029 0.628323 1.034158 1.019782 -0.078897 0.005414 1.234988 0.557243 0.357637 -0.491315 0.727622 1.220297 0.073271 0.925087)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.207115029287 #r(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

	10.789998 #r(0.000000 -0.175913 -0.143823 0.018273 0.027771 0.767311 -0.171214 1.636246 0.351281 1.388337 0.882351 1.707573 0.469183 0.078893 1.085758 0.618150 0.277129 0.703491 1.759709 -0.452169 1.251866 0.357896 0.724274 0.269975 1.838904 1.530293 1.426834 1.312699 0.647676 1.426356 1.595332 0.060341 0.690735 0.318521 0.226388 0.557313 0.682546 0.405400 0.629229 1.956450 1.295086 1.263226 1.531833 -0.446064 1.088083 -0.430622 1.100111 0.930366 1.309892 0.353356 1.791502 1.255481 1.229378 1.253262 1.406532 0.024314 1.063085 1.088221 0.123383 1.238746 1.005923 0.642418 1.110925 0.453476 -0.290616 1.496832 1.287503 0.244996 1.530267 0.834163 0.976178 0.556214 0.154839 1.049337 1.096181 0.549254 -0.047077 0.951697 1.030491 0.147772 0.888048 0.978379 -0.017946 1.704759 1.894288 0.751630 1.629711 1.581497 1.015790 1.546094 0.769995 1.519488 -0.226811 0.116498 -0.232287 0.274508 1.259352 1.098443 1.128583 0.216589 1.343006 0.117206 0.662844 -0.110291 1.010752 0.251673 1.029907 -0.274450 1.835049 0.199877 0.646328 1.080725 0.210236 1.055491 1.898124 0.072310 0.796446 1.191135)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.502624011553 #r(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      10.835933 #r(0.000000 0.654099 1.035661 1.681354 0.271205 0.793039 1.296335 0.060400 0.653112 1.232942 1.881379 0.620355 1.199841 0.014260 0.823834 1.413032 0.189484 0.947478 1.588848 0.403300 1.280378 0.215388 1.137801 1.956237 0.732861 1.657436 0.792204 1.789188 0.703767 1.598762 0.539735 1.541253 0.421443 1.469357 0.779053 -0.021286 1.026341 0.083226 1.233425 0.357509 1.441485 0.752264 1.858411 1.012419 0.073105 1.341491 0.748507 0.322726 1.533912 0.715880 0.027861 1.454725 0.694006 -0.082536 1.358750 0.823835 0.158492 1.802363 1.289166 0.871603 0.288280 1.653699 1.258131 0.754564 0.197129 -0.135159 1.406727 1.305489 0.902560 0.505625 0.165621 1.980298 1.711088 1.181402 1.035732 0.515951 0.573196 0.077979 0.369360 -0.029664 0.027976 1.710591 1.639472 1.419449 1.489927 1.072898 1.080212 0.909135 0.903629 1.096948 0.947039 1.126463 1.358955 0.953854 1.137457 1.170488 1.431020 1.393091 1.493097 1.708464 0.028863 0.359918 0.447603 0.693507 1.013920 0.980939 1.193095 1.522944 -0.124582 0.421795 0.849849 1.081289 1.559178 0.036966 0.454552 0.747770 1.437228 1.496079 0.068555)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.534638752286 #r(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

	10.877907 #r(0.000000 1.760966 1.432317 0.661698 0.093764 0.677833 1.324379 0.560678 0.084000 1.893101 0.982568 0.231983 0.030976 1.869849 0.114160 0.803943 1.697252 0.187259 0.348967 1.325837 0.129934 0.628168 -0.292961 -0.172670 0.424548 1.491809 -0.230282 0.327899 -0.371234 1.709483 0.949653 0.922124 1.730156 1.323261 1.332457 0.313981 1.342414 0.100580 0.697678 0.026744 -0.054235 1.341652 -0.009876 1.698348 0.248931 -0.183551 1.470018 1.710913 1.251473 0.727247 1.872729 0.011341 0.025061 0.694946 1.531659 0.478715 1.097259 0.657341 1.219034 0.633776 0.382770 0.377028 0.092620 0.800796 0.434789 0.301288 0.942251 -0.118601 -0.116547 1.180657 1.270834 0.986907 0.237837 0.780073 1.628870 -0.280374 -0.194405 0.622013 0.090032 1.411166 0.490814 -0.298299 1.291149 1.730249 1.587675 1.193266 0.285035 0.236562 1.437795 0.582458 1.521211 0.605547 0.877830 1.441130 1.061898 0.936396 1.257893 0.016398 -0.126771 0.102714 1.392810 1.183106 1.832099 1.740994 0.232560 0.367779 0.656921 -0.130561 0.093991 0.079826 0.694300 1.076720 1.076648 -0.154506 1.074489 -0.219932 0.141670 -0.212932 0.458505 1.362796)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
(vector 121 14.184466362 #r(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

	10.924906 #r(0.000000 1.021993 1.334449 0.689448 0.491891 0.317117 0.185100 1.316740 0.942417 -0.055518 1.467945 1.216575 0.460144 1.613483 1.346938 0.351666 1.534737 1.166463 0.663385 1.751743 0.887304 0.686057 0.353407 0.640903 0.247744 0.051185 1.683771 0.607042 -0.642997 1.586265 1.428130 1.293714 0.376348 1.687396 1.342115 1.114987 0.421788 0.173805 0.664896 0.744172 1.338635 0.611663 0.948619 1.727026 0.108093 1.757613 1.759583 0.684030 0.701845 0.897975 1.291554 1.678993 -0.010218 1.672340 1.419180 0.531998 1.055064 0.071044 -0.158722 1.660752 -0.273616 1.601063 0.212433 0.488138 0.674057 0.101023 0.258204 0.323292 0.370652 0.521650 1.206457 1.206236 0.768851 0.204856 0.771378 0.971274 -0.207666 0.711434 0.295654 1.831769 0.464965 1.896472 0.968538 0.024673 1.250922 1.351355 0.486851 0.833273 1.147617 1.669210 0.770997 -0.072413 0.463363 1.323688 1.050580 1.732192 0.819244 0.777660 1.040697 0.078135 0.787038 1.358361 0.700196 0.074501 0.587042 0.515371 1.216302 0.852496 0.581485 0.849691 1.814480 1.077357 0.162962 0.766524 -0.151640 0.240975 0.296067 0.314628 1.286198 0.210485 0.583580)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.536 #r(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

	10.949841 #r(0.000000 1.704153 0.121290 0.688837 1.244030 1.262068 -0.197896 0.413249 1.197451 1.272156 0.642587 1.292432 1.783982 0.043702 1.158291 1.164647 1.692639 1.493672 1.007369 1.436042 1.725774 0.880017 0.375925 1.616969 0.128447 1.149978 1.084930 0.463608 1.105848 1.530070 1.424718 0.719589 0.763768 0.288678 1.156946 0.691396 0.064365 0.469636 1.091974 0.426323 1.090313 0.491849 0.938048 1.656418 0.459182 0.976494 0.376276 1.451323 1.601769 -0.407170 0.538990 1.732338 0.050678 1.192103 0.536699 0.739148 1.592439 -0.026377 0.032581 0.995911 0.348311 -0.030558 1.293098 0.192261 0.610689 1.016189 0.912642 1.102218 1.291663 0.930392 1.417016 1.312774 1.826696 0.250091 0.993926 0.681381 0.628174 0.441959 1.489842 0.532045 1.179384 0.517873 0.125155 1.064841 1.980073 0.744857 1.235778 1.280286 1.634199 -0.058763 1.206383 1.265460 1.054717 0.853628 1.196638 0.872935 -0.314369 0.468836 0.081998 0.420778 1.325508 1.934649 1.587718 1.251054 -0.176641 -0.893762 0.381112 0.198904 0.283702 1.674181 1.521739 0.754893 1.659031 0.756575 0.235790 -0.129516 1.697508 -0.350053 0.868125 -0.095111 1.099831 0.951722)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.67458183944 #r(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.016135 #r(0.000000 0.647630 1.074276 1.756268 0.251422 0.804135 1.421127 0.040524 0.665959 1.111755 1.848209 0.635476 1.226811 0.078653 0.744267 1.473903 0.238865 0.830996 1.602610 0.483888 1.291535 0.032720 0.918740 1.769630 0.682055 1.658606 0.644590 1.383351 0.360438 1.331009 0.396705 1.499558 0.394585 1.332297 0.284286 1.367163 0.697156 1.873754 1.072911 0.259822 1.429562 0.401628 1.434105 0.713387 0.052744 1.073687 0.172805 1.418890 0.502359 0.008598 1.451186 0.715950 -0.032063 1.332938 0.645483 -0.170523 1.375389 0.799087 0.277881 1.623936 1.051516 0.728226 0.326139 1.759949 1.287776 0.814001 0.247394 -0.079677 1.277221 1.247278 0.815434 0.548501 0.120625 1.806890 1.668828 1.491775 0.975860 0.670802 0.343501 0.107101 -0.116370 1.739084 1.782173 1.584916 1.517015 1.084964 1.270093 0.937194 1.142225 0.603049 0.902612 0.582213 0.697513 0.723238 0.854795 0.946568 1.173389 0.894182 1.104017 0.982296 1.332899 1.077929 1.505566 1.771677 1.766832 0.125556 0.284805 0.740017 0.785432 0.946551 1.254134 1.343675 1.825955 0.281285 0.688963 0.928919 1.510642 0.002528 0.243797 0.692027 1.356775 1.422418 -0.003671)
      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.607 #r(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

	11.060270 #r(0.000000 0.155441 1.710148 0.675606 0.991885 0.930398 0.521431 0.244313 1.630742 0.168790 0.137270 0.000305 -0.043062 0.897696 0.964832 0.045064 0.425268 0.964217 1.290413 0.929170 0.235812 1.335949 0.057667 0.001006 1.068524 0.446791 1.393120 0.549817 1.466180 -0.642251 1.637204 0.595543 0.457077 0.355722 0.196249 1.437718 -0.302241 1.024336 1.392207 1.340742 0.398137 0.737820 0.315317 0.261053 0.730496 0.895111 0.489074 0.360451 1.441085 0.496392 1.486058 1.322042 1.007323 -0.126599 0.931744 1.784266 0.161232 0.306266 0.415406 0.681040 1.790701 0.980642 -0.005904 1.343074 0.136975 0.027551 -0.124807 1.525812 0.151673 1.852354 0.924568 1.280951 0.029602 0.736180 1.201925 0.667470 1.226105 0.326690 0.609507 -0.393588 1.467285 1.671123 1.358186 0.541731 1.122604 1.867616 -0.473631 -0.417534 0.660754 1.837680 1.546497 0.596764 1.110785 0.215660 0.434300 0.180279 1.110604 0.505631 1.274765 1.668673 0.193680 0.673308 0.543007 1.365849 -0.310522 0.237117 0.174423 1.731063 0.766964 0.281277 -0.402143 0.989963 0.637238 0.526844 0.787012 1.257855 0.717061 0.758671 0.882050 1.342356 0.626910 1.083549 0.608055 0.472324)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.985 #r(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      11.105486 #r(0.000000 0.668250 1.004851 1.665604 0.270207 0.823031 1.317389 1.895775 0.442735 1.092420 1.706335 0.316469 1.053513 1.851731 0.426377 1.214568 0.111950 0.768130 1.567897 0.318224 1.096474 0.028789 0.851033 1.730934 0.518266 1.394840 0.485490 1.534760 0.346603 1.302654 0.195595 1.075240 0.149474 1.131730 0.186045 1.296000 0.352391 1.439364 0.663850 1.837274 0.958873 0.121068 1.316333 0.242865 1.517748 0.747235 1.882566 1.040766 0.534079 1.729417 0.993163 0.496721 1.811700 1.002981 0.317419 1.678987 0.959753 0.256596 1.817235 1.299690 0.756280 0.292629 1.822282 1.254136 0.905795 0.232927 1.675869 1.252625 0.924210 0.377830 0.081344 1.650592 1.565111 1.210398 0.823930 0.495597 0.170992 -0.097351 1.629713 1.238397 1.141529 0.804262 0.860680 0.603481 0.666502 0.428034 0.395443 0.132689 1.849680 0.035737 1.395931 1.824957 1.358060 1.651982 1.606952 1.718179 1.670215 1.887548 1.688422 1.844666 -0.292284 0.050366 -0.101906 0.075572 0.305815 0.606639 0.913420 1.030088 1.512470 1.549064 1.827384 0.007726 0.106419 0.461039 0.753337 1.221334 1.792974 0.097112 0.617097 1.170484 1.176316 1.664541 0.165974 0.635539 1.022624)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.224972
(vector 126 14.67419786533 #r(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.145483 #r(0.000000 0.899293 0.378495 1.289186 0.777288 0.858338 1.619831 1.737202 1.951674 0.835017 -0.087625 1.707725 0.328507 0.828194 -0.110415 0.084984 1.000160 0.933659 1.329981 0.403112 1.465299 0.867776 0.736209 0.286670 0.614444 0.936369 0.873213 0.123325 0.103437 0.033532 0.337773 1.704277 1.195946 1.204920 1.015411 0.867778 0.772767 0.521662 1.281071 0.987342 0.207100 0.684428 0.579999 1.230109 0.833339 0.874869 1.325709 1.214223 -0.039340 1.273384 0.554903 0.324879 0.897065 0.122734 0.357179 1.405113 1.382262 1.052698 1.093027 0.696151 1.256101 1.113094 1.329670 0.549960 1.774690 1.419208 1.188823 1.415491 0.266597 0.476692 0.360990 0.613975 1.834829 -0.016278 0.893804 0.177235 -0.162182 0.465943 0.846924 0.105182 0.478317 0.762411 0.169998 0.509253 1.306498 1.829812 0.517679 0.137251 1.279904 1.030500 -0.049960 1.650399 1.720514 0.164442 0.994973 1.525343 0.937775 1.609285 1.534911 -0.677300 0.133781 0.129445 0.518965 -0.144758 1.037002 1.052666 0.841376 0.157786 1.034141 0.219735 1.379782 0.222272 1.298276 0.072801 0.604052 1.220954 0.022881 1.817683 0.809301 0.789103 1.114921 0.656136 -0.111384 0.132814 1.271527 0.712891)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.269427
(vector 127 14.851 #r(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

	11.176112 #r(0.000000 1.071888 1.248428 0.289874 1.246619 0.289572 1.760445 0.245569 1.154033 1.309416 0.081159 1.849794 1.710269 1.368867 1.052576 -0.398246 -0.001522 1.370275 0.292491 1.626710 1.166078 1.755696 1.227481 0.377631 0.354241 0.127104 0.305667 -0.167076 0.018149 1.234977 0.220914 0.373111 0.199191 1.136953 0.209502 1.631334 0.736118 -0.280026 0.637855 0.997502 0.069226 0.738973 1.836372 1.422035 0.641751 0.717645 0.227787 1.627490 0.896625 1.164185 1.181473 0.283052 0.793654 1.893617 0.958053 1.877395 0.211241 0.448741 0.465207 1.415492 1.261864 1.182640 0.217781 0.211053 1.936678 0.848219 1.690040 -0.183682 -0.275325 0.916325 0.426519 1.353568 0.171309 0.590049 0.503441 0.438773 0.014163 -0.062159 0.869887 -0.128424 0.144319 1.756020 1.717018 -0.046012 0.125572 0.279523 0.175456 1.083651 1.091291 1.212635 1.168385 1.392580 -0.189037 0.240170 0.866374 1.580620 1.749254 1.502399 1.243019 0.251600 -0.018231 1.414780 0.773115 0.067214 1.323483 0.617886 1.663914 0.351482 0.571589 1.123483 1.679985 0.501109 1.035832 1.346170 1.289512 1.663306 0.584848 0.500505 -0.031006 0.055228 0.131713 1.510949 0.309811 1.293736 1.414224 0.248635 1.517857)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.313708498985
(vector 128 15.138 #r(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.210356 #r(0.000000 0.529477 1.092204 1.655320 0.240176 0.840083 1.290316 0.036113 0.414482 1.184815 1.733487 0.475904 1.226699 -0.054687 0.544000 1.373024 0.096261 0.605273 1.510542 0.229851 0.972933 -0.008717 0.768966 1.800241 0.536684 1.336088 0.309226 1.164728 0.254148 1.069819 0.021808 0.945032 -0.039508 0.972460 -0.067607 1.002895 0.197048 1.366967 0.351763 1.540663 0.648980 1.698360 0.730857 0.118485 1.274417 0.283223 1.327398 0.691807 0.012365 1.128647 0.533746 1.871605 1.252479 0.321809 1.476722 1.286815 0.557929 1.863054 1.365020 0.715719 -0.012609 1.699347 1.092581 0.354365 -0.098429 1.602411 1.106114 0.622866 0.186170 1.647857 1.109362 0.904818 0.566992 0.283406 1.734276 1.302248 1.135583 0.996099 0.637141 0.319233 -0.334659 -0.051454 1.363705 1.553533 1.027907 1.065457 0.795998 0.486251 0.704843 0.431262 0.496789 0.160271 0.268391 -0.277422 -0.064873 -0.149375 -0.202682 0.078495 -0.086833 -0.064332 0.234996 -0.109719 0.180200 0.196396 0.559877 0.436602 0.563596 0.942230 1.157161 1.450532 1.353287 1.969232 0.307428 0.330752 0.455679 0.656549 1.076389 1.439415 1.817226 0.185723 0.623808 1.021760 1.554273 1.872894 0.258818 0.595831 0.908779 1.816125)
      )

;;; 256 all -------------------------------------------------------------------------------- (16)
(vector 256 23.353 #r(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

	15.997488 #r(0.000000 0.925209 0.360087 -0.109255 -0.863041 -0.029912 -0.483289 0.303463 0.008649 0.031617 0.487041 0.145598 0.992492 -0.713096 0.834493 0.846857 -0.131376 0.542717 0.203811 -0.433766 -0.763755 0.238727 -0.473870 0.868120 -0.040586 -0.462669 0.740771 -0.227132 -0.000692 0.548464 -0.055270 -0.035150 0.172840 -0.630429 -0.054024 -0.934698 -1.031001 0.790052 -0.042240 -0.412997 -0.220043 -0.508562 -0.002888 -0.453454 0.339759 0.518676 0.788804 -0.251741 -0.227551 -0.779613 0.734751 0.789576 0.367904 -0.617440 0.581096 0.338718 0.846175 -1.028326 0.259730 0.848625 0.330154 -0.124923 -0.130656 -0.899763 -0.617228 0.785884 -0.310990 0.157588 0.054106 0.868737 -0.143871 -0.227180 -0.267827 -0.544386 0.833457 -0.192646 0.531361 0.900376 0.172583 0.028556 -0.603550 0.718142 -0.997946 0.928971 -0.598759 -0.564692 0.183693 -0.203720 0.320101 0.732178 0.707159 -0.345178 -0.790224 -0.362108 0.317265 0.458201 0.831535 -0.431642 0.893792 -0.522325 -0.951966 -0.916656 0.233541 -0.532295 -0.365198 -0.656087 -0.172799 -0.786128 -0.707188 0.943130 -0.849431 -0.253384 -0.006071 0.913388 -0.612860 0.748864 -0.097659 0.450043 -0.692859 -0.884034 0.489241 0.243506 0.522701 0.974734 -0.768569 0.798343 0.726708 0.380364 0.170048 0.841302 -0.054785 0.610401 -0.858315 1.073514 -0.296883 -0.115618 0.015515 -0.916509 0.161588 0.652650 -0.008712 -0.505409 -0.067911 0.429313 0.399063 -0.573262 0.915841 -0.103864 0.624139 -0.134372 0.295426 0.204203 -0.479147 -0.159602 0.734669 0.642734 0.736135 -0.448600 -0.458950 0.777967 0.430117 0.669953 -0.339677 -0.689474 0.053281 -0.192783 0.913617 -0.878687 -0.069834 -0.145159 -0.823861 0.329716 -0.294470 0.392295 0.367988 0.287467 -0.889937 0.108498 0.753099 -0.487972 0.879263 -0.711295 0.729063 -0.025027 -0.771617 0.605944 0.271222 0.007411 -0.020393 -0.014302 0.113553 0.177385 -0.916189 -0.023264 0.032699 -0.714380 -0.890488 0.792318 -0.352445 -0.636838 0.505157 -0.746916 0.517505 0.224781 0.219031 -0.868947 0.454389 0.941008 -0.592372 -0.021442 -0.833651 -0.129261 0.460929 0.851936 -0.513944 0.084364 0.670315 -0.849612 0.625818 -0.181003 0.557575 -0.773073 -0.289191 -0.114786 -0.181584 0.600972 0.053488 0.794901 0.364604 0.191088 0.638262 -0.049402 0.312362 -0.070807 0.780925 0.495453 0.069458 0.847189 -0.191235 0.133528 -0.011930 0.216808 -0.015570 -0.171022 0.292597 0.777578 -0.642052 -0.866010 0.781770 0.651970 0.854285 0.022232 0.692772 0.892370 -0.002656 0.427419)
      )

;;; 512 all -------------------------------------------------------------------------------- (22.627)
(vector 512 34.212551772691 #r(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      ;; from (try-all :all 512 513 1.0491155462743 0.38189660798029) = 28.3830
	23.189977 #r(0.000000 0.400352 1.646881 1.352186 1.820224 1.171903 0.728255 1.254465 0.513930 0.096435 0.678623 1.896068 1.524404 0.077988 1.266111 0.901656 1.474695 0.666750 0.325140 0.889746 0.031461 1.747664 0.303290 1.442380 1.216839 1.723604 0.863224 0.680958 1.129826 0.311736 0.193407 0.555492 1.792947 1.679721 0.091008 1.307830 1.126811 1.731589 0.839052 0.599635 1.288118 0.346704 0.103683 0.799885 1.881324 1.639831 0.226281 1.396817 1.216183 1.693142 0.967883 0.798890 1.196889 0.545432 0.385266 0.841816 0.102474 0.016917 0.520077 1.660266 1.604546 0.103698 1.155177 1.119005 1.624239 0.720929 0.645369 1.145461 0.313857 0.220582 0.803756 0.005538 1.884424 0.543330 1.749018 1.567115 0.212368 1.351814 1.243356 1.774620 0.949983 0.847788 1.321749 0.601544 0.485568 0.979653 0.389619 0.170830 0.739552 0.138980 1.873820 0.429358 1.719747 1.627475 0.184132 1.333930 1.412582 1.892114 1.004822 1.104992 1.573901 0.791666 0.796319 1.329697 0.584451 0.489684 1.067620 0.319034 0.308954 0.814556 0.064524 0.097555 0.602841 1.796672 1.819509 0.357311 1.595792 1.577166 0.168239 1.467336 1.372675 1.976200 1.316975 1.164980 1.808221 1.103146 1.000071 1.680356 0.955071 0.853384 1.471465 0.758000 0.711840 1.292063 0.556515 0.598835 1.096988 0.432299 0.457329 0.922975 0.270776 0.326833 0.899988 0.173435 0.210469 0.791993 0.096131 0.099798 0.652148 0.011154 0.057498 0.632715 1.963592 1.969306 0.571446 1.788300 1.877826 0.397115 1.703193 1.835777 0.354597 1.832646 1.722115 0.367332 1.790010 1.591869 0.325888 1.505285 1.613369 0.344337 1.509568 1.699657 0.385875 1.732934 1.702796 0.328799 1.873371 1.628395 0.319601 1.789235 1.606650 0.373878 1.634819 1.631971 0.329272 1.648137 1.652983 0.277243 1.779926 1.731646 0.462778 1.802049 1.856738 0.643556 1.755237 1.953948 0.623887 1.895649 0.008180 0.585292 0.085329 0.141670 0.786571 0.276875 0.274159 0.892368 0.266677 0.356930 0.990211 0.295308 0.382754 1.125680 0.482871 0.541134 1.332496 0.748978 0.751245 1.512333 0.900567 1.008919 1.698997 1.037217 1.078478 1.845510 1.288083 1.140338 -0.024055 1.423721 1.286401 0.043424 1.502268 1.602623 0.320818 1.614025 1.907483 0.546839 0.057012 0.227450 0.948947 0.328025 0.263136 1.027035 0.610548 0.618089 1.374903 0.690188 0.736049 1.527127 0.945207 1.420607 1.982363 1.245889 1.377039 0.093875 1.721575 1.764294 0.483397 1.884106 -0.179785 0.671224 0.265139 0.438107 1.153897 0.398895 0.535728 1.442242 0.926749 1.040019 1.779771 1.170515 1.241494 0.076467 1.688139 1.746475 0.572739 -0.029431 -0.055089 0.779847 0.306485 0.377043 1.310308 0.619637 0.647514 1.389888 1.029884 1.245820 0.116360 1.541548 1.636228 0.425375 1.867903 0.178686 0.845985 0.502335 0.550717 1.478630 0.746147 0.921637 1.664176 1.208336 1.491564 0.311150 1.795511 1.840905 0.651661 -0.002247 0.367671 1.062457 0.897875 0.879786 1.809541 1.199453 1.213170 0.106645 1.547957 1.863482 0.787131 0.375345 0.335825 1.390579 0.570732 0.899469 1.714005 1.283109 1.498107 0.367353 1.983111 -0.071391 0.796589 0.289495 0.571127 1.380175 1.116842 1.278494 0.105341 1.566200 1.693664 0.701618 0.302878 0.547404 1.298484 0.629335 1.094248 1.890010 1.553218 1.483661 0.423303 -0.131538 0.292332 0.971091 0.669305 0.742213 1.619653 1.399065 1.498559 0.392971 1.901463 0.163133 1.105913 0.701183 0.984001 1.809506 1.394342 1.548131 0.475595 -0.027570 0.241912 1.194913 0.767151 0.949453 1.839642 1.416626 1.580606 0.593900 0.179496 0.442049 1.382700 0.831032 1.153276 0.111040 1.827359 0.002662 0.919835 0.413504 0.673098 1.623798 1.277197 1.538837 0.446946 -0.055882 0.359099 1.249334 0.804644 1.022680 -0.129161 1.565232 1.837270 0.679347 0.419151 0.596525 1.582037 1.100195 1.497789 0.653803 0.152446 0.411852 1.181340 0.926546 1.327298 0.200287 0.007024 -0.032787 0.989974 0.601147 0.861227 0.041469 1.596668 1.968072 0.976330 0.410383 0.889204 1.756894 1.551268 1.741952 0.529816 0.184054 0.479217 1.492550 1.214306 1.388728 0.476110 0.043478 0.455596 1.480248 1.192473 1.479537 0.361922 0.023585 0.326125 1.336431 0.979467 1.357912 0.317617 -0.203490 0.230525 1.292657 0.950056 1.260511 0.288494 0.091443 0.285153 1.308557 0.989824 1.461195 0.427484 0.074661 0.571384 1.356006 1.100865 1.376996 0.360567 0.294443 0.369162 1.433456 1.083241 1.396734 0.541539 0.190049 0.582731 1.678547 1.102239 1.655238 0.664049 0.424506 0.691131 1.777910 1.655084 1.948811 0.861845 0.601112 0.937689 -0.013567 1.745767 0.153961 1.148324 0.829747 1.260999 0.328687 0.015723 0.375737 1.473206 1.156097 1.534391 0.554594 0.314366 0.866495 1.865078 1.616164 0.010791 1.061746 0.859540 1.149512 0.327388 0.127562 0.466362 1.557328 1.317358 1.818227 0.824304 0.532379 1.027109 0.090332)
	)

;;; 1024 all -------------------------------------------------------------------------------- (32)
(vector 1024 54.490282136658 #r(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       ;; from (try-all :all 1024 1025 0.0030465754082342 1.0966230312279) = 39.6408 -- starting point for next
	33.029821 #r(0.000000 0.217944 0.609929 0.966538 1.354466 1.690402 0.069295 0.463126 0.814401 1.196400 1.587877 1.919637 0.299030 0.724808 1.031299 1.433724 1.817103 0.241494 0.529467 0.953913 1.312038 1.724394 0.083640 0.510832 0.881442 1.294790 1.666828 0.116069 0.473037 0.873150 1.255459 1.735264 0.231025 0.607108 1.026645 1.387601 1.867390 0.246399 0.647371 1.117895 1.523135 1.949578 0.367422 0.819265 1.260489 1.747241 0.114639 0.576953 1.044546 1.450005 1.895359 0.337673 0.760942 1.252665 1.715355 0.138176 0.573778 1.044736 1.454339 1.933805 0.419681 0.897725 1.332490 1.846973 0.341692 0.853530 1.294337 1.764850 0.257004 0.692932 1.243397 1.739885 0.171868 0.652576 1.167240 1.631641 0.130202 0.627593 1.075726 1.600388 0.096166 0.576857 1.134368 1.648800 0.163148 0.685032 1.181053 1.700720 0.253013 0.777113 1.309397 1.817078 0.293402 0.853519 1.368244 1.898017 0.433163 0.974760 1.514173 0.042173 0.597676 1.165987 1.715383 0.264332 0.804952 1.359143 1.877666 0.430708 1.001895 1.560881 0.114994 0.620250 1.229491 1.804490 0.389237 0.962946 1.536544 0.139150 0.730565 1.284249 1.841276 0.417017 1.053568 1.586605 0.179291 0.790530 1.386440 -0.009879 0.569235 1.193034 1.803551 0.428573 0.976995 1.620108 0.211446 0.773716 1.394295 -0.017677 0.588834 1.242761 1.852375 0.532122 1.149688 1.771121 0.422936 1.015951 1.611750 0.256269 0.880464 1.539720 0.170996 0.850370 1.471973 0.111868 0.751131 1.403839 0.025163 0.665501 1.359157 -0.032755 0.678974 1.327344 0.024721 0.741238 1.379682 0.030650 0.676686 1.334190 -0.028684 0.656962 1.337956 0.006882 0.676207 1.399794 0.075000 0.781895 1.482704 0.154625 0.852153 1.534645 0.217402 0.954926 1.663425 0.323355 1.041197 1.734732 0.466361 1.244601 1.978399 0.647632 1.345902 0.011463 0.747333 1.489039 0.226282 0.990350 1.691379 0.448200 1.141928 1.861476 0.554357 1.286100 0.069614 0.855805 1.601651 0.320013 1.023987 1.822894 0.578209 1.344501 0.080052 0.785333 1.566582 0.361677 1.104898 1.885030 0.639545 1.407357 0.153434 0.938179 1.720652 0.474847 1.318256 0.044914 0.855683 1.629465 0.437944 1.252831 0.024990 0.795373 1.590340 0.357127 1.165443 -0.000747 0.788315 1.590652 0.386431 1.197624 -0.013584 0.835954 1.651685 0.463586 1.276162 0.057864 0.897668 1.742027 0.559116 1.374859 0.193273 1.056175 1.889157 0.710586 1.580348 0.407362 1.242569 0.042766 0.907657 1.764531 0.620635 1.493091 0.310002 1.184483 0.034271 0.889272 1.782427 0.653101 1.478420 0.338338 1.201923 0.065161 0.951196 1.800033 0.675255 1.545870 0.451165 1.315646 0.209836 1.097200 -0.012463 0.845013 1.764065 0.652174 1.577225 0.431672 1.358363 0.265803 1.142508 0.041729 0.938441 1.849007 0.741618 1.700757 0.625276 1.512291 0.416998 1.342445 0.314840 1.211910 0.132298 1.072581 -0.004048 0.932218 1.855905 0.812140 1.708124 0.683628 1.624946 0.551196 1.484020 0.446857 1.419168 0.352124 1.315231 0.255127 1.241233 0.191011 1.149002 0.126798 1.077614 0.031447 0.999403 0.019804 0.945636 1.909373 0.940686 1.908817 0.830112 1.834192 0.887932 1.814672 0.756834 1.792523 0.822544 1.804408 0.766593 1.770853 0.794464 1.800727 0.751526 1.758821 0.788987 1.786880 0.814558 1.818971 0.822418 1.859652 0.846380 1.876657 0.931090 -0.031368 0.954000 0.041345 1.055496 0.046192 1.112290 0.125703 1.142215 0.189586 1.275822 0.279344 1.352864 0.399390 1.417195 0.474770 1.586423 0.571385 1.637371 0.762404 1.797359 0.793754 1.905084 0.990127 0.050764 1.120181 0.189950 1.278536 0.314289 1.416606 0.522323 1.605728 0.657609 1.736064 0.864528 1.945709 1.038919 0.172460 1.264344 0.327940 1.441495 0.489339 1.620990 0.742758 1.864010 0.978890 0.054901 1.213647 0.315622 1.367925 0.527446 1.686445 0.801940 1.894535 1.021703 0.150671 1.280517 0.415930 1.597966 0.690690 1.814216 1.015101 0.169339 1.244108 0.393753 1.565800 0.764048 1.867638 1.028999 0.210614 1.366819 0.507337 1.671181 0.838237 0.022188 1.174302 0.313854 1.504329 0.645781 1.845795 1.051255 0.239848 1.417986 0.574481 1.756897 0.951386 0.110073 1.293098 0.540906 1.736282 0.920748 0.119036 1.329341 0.550833 1.736478 0.927385 0.119774 1.392258 0.621372 1.775469 1.007774 0.217206 1.460136 0.708826 1.918555 1.133993 0.362808 1.631767 0.871741 0.066315 1.264788 0.549186 1.761046 1.012312 0.268274 1.523528 0.761486 0.024402 1.246090 0.502848 1.736382 1.030358 0.263498 1.504814 0.797584 0.038284 1.315985 0.615561 1.881866 1.132509 0.426240 1.688331 1.012746 0.276268 1.537983 0.817470 0.149300 1.425804 0.681759 -0.012530 1.283946 0.622295 1.877985 1.199987 0.515375 1.781866 1.081579 0.391646 1.721452 1.040703 0.317360 1.612416 0.970865 0.266856 1.601655 0.937590 0.290327 1.585370 0.921429 0.283284 1.598243 0.931518 0.260021 1.590875 0.958649 0.292061 1.637844 0.988134 0.312289 1.650253 1.031600 0.427015 1.767001 1.074681 0.426252 1.799364 1.185929 0.579219 1.932358 1.282992 0.645875 0.040156 1.418257 0.764669 0.173371 1.562041 0.945336 0.309563 1.680886 1.084452 0.477887 1.844079 1.284871 0.669433 0.089860 1.477088 0.903242 0.268087 1.703640 1.090186 0.536661 1.918966 1.327942 0.735035 0.166520 1.569816 1.004591 0.446853 1.854072 1.312899 0.702518 0.113425 1.613090 1.014710 0.475798 1.865885 1.351105 0.758249 0.262321 1.668284 1.136785 0.559653 0.028507 1.481806 0.915644 0.406371 1.878232 1.360671 0.811030 0.262274 1.718434 1.199699 0.680517 0.179919 1.610435 1.118901 0.627334 0.077819 1.553370 1.057095 0.585546 0.022795 1.538180 0.980766 0.484377 0.023856 1.494108 1.030226 0.491007 0.017274 1.535238 1.068544 0.590261 0.061618 1.587742 1.116980 0.644547 0.170823 1.648240 1.194503 0.741219 0.251235 1.791697 1.315747 0.851811 0.415621 1.900929 1.500285 0.993383 0.541195 0.093249 1.622554 1.249256 0.767888 0.344856 1.876331 1.448744 0.996767 0.573661 0.124676 1.643703 1.257500 0.780607 0.401957 1.972876 1.520976 1.187097 0.694507 0.306886 1.854893 1.401885 1.044022 0.597029 0.195790 1.807551 1.396496 1.006835 0.634520 0.181981 1.843667 1.378220 1.020785 0.627456 0.279505 1.861075 1.453605 1.114444 0.672015 0.375475 1.954714 1.557659 1.185029 0.809641 0.447297 0.106477 1.740616 1.348460 1.027725 0.582687 0.277990 1.910092 1.509602 1.193462 0.824779 0.510119 0.177000 1.827763 1.505398 1.153832 0.832423 0.437455 0.171220 1.814712 1.447020 1.128584 0.777519 0.473598 0.119850 1.886048 1.515369 1.218555 0.893278 0.537987 0.255812 1.909383 1.650827 1.359901 1.061282 0.716316 0.414321 0.125468 1.813275 1.571022 1.212518 0.956851 0.623980 0.408756 0.045675 1.826176 1.471750 1.215304 0.948001 0.683262 0.437623 0.176361 1.854173 1.610937 1.358115 1.068061 0.884621 0.553738 0.356388 0.049199 1.777936 1.512665 1.302866 1.024701 0.792763 0.572863 0.249058 0.119282 1.756813 1.582996 1.361044 1.086282 0.895852 0.676476 0.419545 0.165813 0.012477 1.735267 1.547257 1.359180 1.117816 0.926904 0.704130 0.498447 0.318523 0.057994 1.860723 1.723027 1.477003 1.277427 1.104572 0.893719 0.692617 0.494508 0.303114 0.144052 -0.011112 1.748550 1.579708 1.413473 1.279652 1.001473 0.934202 0.731463 0.532457 0.417666 0.233427 0.059069 1.967681 1.749714 1.609407 1.407439 1.310368 1.067641 0.979830 0.813878 0.690538 0.533904 0.425045 0.244967 0.169973 -0.011723 1.876781 1.727039 1.634464 1.452145 1.448180 1.205364 1.101400 1.013989 0.909619 0.719822 0.668385 0.510761 0.398037 0.300021 0.139310 0.033986 1.956609 1.852122 1.767483 1.663402 1.617220 1.510602 1.438139 1.412647 1.252997 1.181729 1.077732 1.039370 0.871450 0.817399 0.738218 0.775239 0.639974 0.550221 0.521202 0.428119 0.413547 0.217176 0.261744 0.171301 0.134991 0.023232 -0.017163 0.000436 1.951388 1.878190 1.804637 1.774184 1.775406 1.714919 1.645915 1.606995 1.620251 1.590934 1.519629 1.545077 1.464398 1.458268 1.421491 1.464767 1.458836 1.399241 1.400676 1.427477 1.403319 1.354776 1.404944 1.362031 1.313869 1.351539 1.366777 1.370372 1.389353 1.409150 1.360528 1.453599 1.459887 1.429592 1.439773 1.469815 1.424027 1.471130 1.498228 1.543683 1.583469 1.561051 1.660230 1.693126 1.741718 1.801903 1.808387 1.947118 1.871120 1.958034 -1.809188 0.048359 0.132079 0.154730 0.221928 0.329331 0.333421 0.439877 0.452440 0.496765 0.600557 0.660796 0.708086 0.791333 0.878621 0.937596 1.011597 1.035359 1.177245 1.285175 1.409637 1.420773 1.613717 1.634027 1.767500 1.843514 1.983888 0.042196 0.174460 0.251794 0.355433 0.462324 0.575296 0.755077 0.798506 0.934460 1.050726 1.201317 1.304605 1.443907 1.604050 1.683710 1.835109 1.976954 0.094378 0.210911 0.323699 0.433581 0.607326 0.750660 0.884279 1.061010 1.153927 1.341967 1.491178 1.604466 1.790604 -0.034786 0.169692 0.385328 0.513812 0.654879 0.869159 1.035588 1.237414 1.441537 1.574175 1.787644 1.941947 0.058771 0.290678 0.483033 0.637107 0.831997 1.050475 1.246917 1.361026 1.597033 1.738388 -0.038016 0.188808 0.359916 0.569117 0.814455 1.022910 1.248641 1.467152 1.662229 1.861796 0.115242 0.372486 0.579884 0.821252 1.100099 1.314837 1.543761 1.810564 -1.761012 0.186243 0.495461 0.706908 0.960351 1.160813 1.369258 1.704917 1.908953 0.173525 0.454292 0.707228 0.978617 1.195660 1.489816 1.733484 0.041779 0.289482 0.547436 0.800560 1.069460 1.362007 1.589743 1.899198 0.210724 0.451204 0.798331 1.116037 1.402551 1.699288 -0.015822 0.291274 0.622911 0.932610 1.199757 1.538548 1.866245 0.126351 0.485775 0.740845 1.070466 1.417858 1.686157 0.001282 0.344073 0.693525 1.049489 1.374121 1.693405 0.122694)
       )

;;; 2048 all -------------------------------------------------------------------------------- (45.254)
(vector 2048 89.570060996356 #r(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       ;; from (try-all :all 2048 2049 1.0476749041086 0.34832901677121) = 55.7655 start for next
	48.891989 #r(0.000000 0.404265 1.574549 1.323354 1.767739 0.978493 0.643485 1.074227 0.309481 -0.007439 0.432173 1.628830 1.321474 1.790146 0.948109 0.659243 1.187003 0.274946 0.042067 0.536491 1.608427 1.328242 1.863457 0.992931 0.751925 1.207631 0.304562 0.059289 0.583384 1.667473 1.454270 1.913709 1.065782 0.848049 1.272585 0.392067 0.213015 0.659649 1.786179 1.544300 0.010564 1.144318 0.894714 1.411161 0.519949 0.298924 0.797815 1.857180 1.670928 0.127492 1.237048 1.039620 1.493446 0.610978 0.417293 0.857089 0.024757 1.793275 0.242623 1.392004 1.181201 1.620272 0.814355 0.575073 1.044343 0.180079 -0.011354 0.397828 1.592020 1.375565 1.772916 0.994864 0.735628 1.217271 0.376032 0.093329 0.658758 1.797911 1.545296 0.034533 1.160033 0.950407 1.456372 0.583515 0.396371 0.837798 1.971685 1.763054 0.260762 1.402444 1.235470 1.664715 0.803990 0.613689 1.080404 0.243105 0.032706 0.523302 1.634173 1.470710 1.935992 1.081134 0.894559 1.393091 0.491138 0.298325 0.847614 1.939666 1.697301 0.256222 1.364181 1.186510 1.673809 0.754378 0.584990 1.124308 0.219819 0.061164 0.502382 1.718502 1.522566 -0.010824 1.115811 0.954331 1.438470 0.591628 0.370960 0.867526 0.042021 1.856321 0.327906 1.487712 1.299632 1.766029 0.923117 0.766476 1.237634 0.345007 0.149867 0.734508 1.848233 1.667400 0.167862 1.305980 1.130753 1.581565 0.771318 0.604065 1.033886 0.206700 0.028021 0.524682 1.698233 1.490760 0.005456 1.157172 0.975888 1.432394 0.633466 0.463694 0.913915 0.138696 1.935881 0.447508 1.610927 1.399381 1.902842 1.105071 0.913695 1.425076 0.560336 0.420910 0.905881 0.045443 1.885021 0.352416 1.527398 1.401561 1.860502 1.057145 0.880571 1.359609 0.549267 0.356361 0.843885 0.053244 1.918164 0.419700 1.572740 1.377355 1.904145 1.041080 0.912536 1.386177 0.528561 0.386123 0.913577 0.073491 1.960379 0.437034 1.534237 1.406642 1.940629 1.079596 0.957729 1.434525 0.604347 0.459790 0.957200 0.072329 0.020305 0.505335 1.644064 1.510970 0.028692 1.164093 1.065357 1.574877 0.750941 0.543465 1.107084 0.268450 0.112295 0.662975 1.830339 1.624872 0.186923 1.329115 1.148042 1.735686 0.865859 0.724490 1.244204 0.417026 0.265328 0.753295 1.966927 1.807431 0.354504 1.520227 1.344012 1.874142 1.046013 0.926574 1.415595 0.604726 0.503282 0.987470 0.154932 0.062043 0.519080 1.735763 1.630501 0.111360 1.327539 1.134366 1.682317 0.901434 0.685793 1.274212 0.484764 0.264202 0.824426 -0.013449 1.893385 0.412118 1.579078 1.447362 1.973431 1.108245 1.034445 1.569527 0.730063 0.580050 1.087478 0.304646 0.166846 0.668142 1.866193 1.723735 0.257103 1.485447 1.318903 1.887961 1.051396 0.939000 1.485238 0.660047 0.511465 1.016848 0.272336 0.110588 0.700169 1.883467 1.697806 0.285858 1.442952 1.316653 1.890031 1.045178 0.926636 1.455536 0.663062 0.572994 1.084200 0.283282 0.182866 0.679233 1.907424 1.777440 0.317230 1.520559 1.389883 1.909078 1.071512 1.011961 1.559870 0.711767 0.638176 1.164197 0.359208 0.261195 0.793450 -0.002601 1.914975 0.450508 1.650109 1.455694 0.098496 1.337194 1.104180 1.689072 0.905073 0.761555 1.291682 0.564386 0.373852 0.959893 0.149714 0.066147 0.584946 1.789306 1.699203 0.267439 1.439811 1.313545 1.890379 1.116939 1.015932 1.537384 0.780885 0.658823 1.221242 0.419558 0.290649 0.841185 0.114483 1.952714 0.474371 1.755166 1.587864 0.142588 1.384467 1.255720 1.832721 1.030275 0.975299 1.480692 0.705884 0.665303 1.150564 0.397656 0.312138 0.816763 0.078463 1.973511 0.461149 1.773409 1.632842 0.172511 1.407168 1.309492 1.906758 1.116608 1.001528 1.571080 0.800665 0.672872 1.259096 0.474170 0.352530 0.894484 0.170562 0.039556 0.588770 1.831973 1.715557 0.308752 1.549911 1.424130 -0.045765 1.248597 1.121973 1.688019 0.955149 0.834663 1.440307 0.685009 0.501682 1.137292 0.350416 0.242675 0.814201 0.040168 1.952644 0.491933 1.774983 1.670075 0.251486 1.479564 1.355504 1.969153 1.185557 1.089260 1.650465 0.896277 0.784760 1.354119 0.628232 0.524120 1.095480 0.369048 0.266946 0.832597 0.079088 0.006974 0.543597 1.794979 1.698710 0.243425 1.503655 1.482974 0.032175 1.255976 1.203497 1.788493 0.998879 0.969905 1.496837 0.782664 0.637226 1.258958 0.547365 0.375432 1.010929 0.272081 0.152511 0.749955 0.015707 1.944971 0.488880 1.718363 1.659585 0.250871 1.441977 1.431642 0.016272 1.246516 1.229650 1.770909 1.042584 0.957270 1.505869 0.788938 0.733905 1.286017 0.562146 0.456725 1.063687 0.336949 0.226423 0.872907 0.094940 0.023635 0.579593 1.854619 1.777199 0.334990 1.620348 1.561261 0.135328 1.404508 1.350157 1.956023 1.189681 1.103722 1.711200 0.953937 0.920695 1.459452 0.806494 0.682238 1.312613 0.565028 0.456412 1.072721 0.366398 0.238860 0.873900 0.124051 0.008426 0.651583 1.943477 1.839044 0.469679 1.681308 1.672539 0.291936 1.517378 1.453446 0.053135 1.331415 1.274004 1.868821 1.147831 1.078420 1.699702 0.957455 0.911154 1.507975 0.817434 0.745118 1.300411 0.659430 0.517763 1.149817 0.479968 0.394535 0.993162 0.205170 0.149399 0.804840 0.036720 -0.013174 0.623861 1.893899 1.830896 0.466502 1.774831 1.684546 0.343413 1.547767 1.520868 0.122488 1.366583 1.344558 1.929363 1.205372 1.218501 1.772088 1.016811 1.025303 1.674722 0.904206 0.917606 1.482467 0.770206 0.744875 1.314480 0.588280 0.547729 1.180814 0.411378 0.431909 1.059961 0.323791 0.300772 0.915453 0.191230 0.128411 0.772673 0.040922 -0.012464 0.639166 1.919657 1.877202 0.476132 1.800598 1.712412 0.359388 1.618075 1.588003 0.234000 1.510141 1.461223 0.078851 1.369301 1.313055 1.991266 1.252061 1.230314 1.897899 1.126799 1.155944 1.744366 1.010648 0.992884 1.662367 0.918028 0.897280 1.518571 0.813376 0.803147 1.378706 0.657270 0.692820 1.297122 0.557470 0.554387 1.164043 0.525977 0.443772 1.067758 0.387287 0.379305 0.971454 0.278913 0.272369 0.914289 0.183791 0.171360 0.821472 0.119923 0.044540 0.737836 -0.025212 0.017724 0.627300 1.940847 1.878646 0.533431 1.819165 1.818311 0.404042 1.734295 1.748280 0.364194 1.665777 1.663258 0.276639 1.636305 1.588002 0.223422 1.523573 1.484909 0.144241 1.452394 1.399573 0.090722 1.397767 1.358594 -0.034063 1.338863 1.274679 1.932240 1.241911 1.254328 1.906373 1.182382 1.216568 1.806026 1.160291 1.114701 1.765593 1.066802 1.010557 1.775197 1.065330 1.040488 1.641047 1.040833 0.960709 1.628132 0.973090 0.901894 1.579089 0.890777 0.903659 1.570423 0.901268 0.866647 1.481129 0.900536 0.779883 1.462661 0.804656 0.806734 1.409506 0.757382 0.750264 1.411570 0.722678 0.708055 1.400874 0.700958 0.675209 1.402533 0.653662 0.663533 1.349513 0.698312 0.652336 1.280643 0.655368 0.617941 1.281174 0.601083 0.615289 1.258765 0.604141 0.644306 1.222580 0.584091 0.614307 1.269374 0.596779 0.583317 1.248320 0.572748 0.568621 1.255727 0.576085 0.599220 1.254268 0.548709 0.576192 1.246128 0.571320 0.573237 1.270172 0.614725 0.576832 1.273016 0.584757 0.616961 1.265682 0.569299 0.616768 1.273254 0.618780 0.644312 1.295546 0.643348 0.709765 1.327092 0.667807 0.643171 1.318488 0.679919 0.647699 1.311230 0.724574 0.721007 1.379147 0.771315 0.738471 1.399079 0.757719 0.772784 1.409226 0.784462 0.799173 1.466966 0.857681 0.843233 1.533626 0.912537 0.873824 1.538067 0.907439 0.901380 1.651764 0.947506 0.965742 1.696729 1.010228 1.034414 1.664402 1.014664 1.064893 1.764087 1.100415 1.076845 1.790902 1.158365 1.165151 1.831480 1.238205 1.217124 1.928664 1.301008 1.256854 -0.020764 1.334742 1.331435 0.032978 1.440536 1.416135 0.136726 1.482094 1.520850 0.202504 1.539109 1.568093 0.295555 1.588601 1.662928 0.313081 1.702807 1.689792 0.424120 1.755397 1.802775 0.478362 1.821014 1.880587 0.528854 1.943889 -0.102840 0.687024 0.025769 0.039052 0.716297 0.126263 0.187077 0.844261 0.223911 0.231591 0.985954 0.298380 0.396011 0.996158 0.434371 0.443459 1.136895 0.515205 0.529047 1.266240 0.614907 0.646936 1.387396 0.758368 0.765389 1.477500 0.823521 0.867323 1.594254 0.964365 0.986611 1.669468 1.078731 1.156367 1.838832 1.212809 1.245847 1.946657 1.303631 1.309002 0.096550 1.448690 1.482818 0.177486 1.560706 1.643988 0.345296 1.664716 1.741852 0.428319 1.820079 1.870929 0.562642 1.949950 -0.011144 0.776636 0.078636 0.155981 0.841492 0.196213 0.282157 0.956327 0.339874 0.402407 1.111262 0.544769 0.539561 1.289696 0.680098 0.708546 1.456351 0.779993 0.890032 1.548224 0.962765 1.003175 1.737257 1.089987 1.228496 1.895226 1.300631 1.356916 0.023357 1.421943 1.458778 0.225375 1.620536 1.666534 0.342838 1.767736 1.823654 0.569855 1.938093 0.021614 0.687940 0.136243 0.167771 0.888573 0.251765 0.331156 1.116023 0.491689 0.504622 1.251104 0.673333 0.709033 1.424457 0.821431 0.917600 1.655206 1.027274 1.100121 1.807235 1.188186 1.250748 -0.004046 1.417895 1.466454 0.212467 1.607244 1.635928 0.406487 1.773860 1.865319 0.624997 -0.014135 0.061867 0.787678 0.202539 0.276660 0.994679 0.438053 0.480903 1.226903 0.625829 0.717373 1.455751 0.809442 0.925213 1.647078 1.023495 1.126562 1.853474 1.289077 1.296162 0.068573 1.474894 1.535388 0.257065 1.707120 1.788299 0.465507 1.930596 -0.002339 0.723888 0.140141 0.214635 1.003036 0.397619 0.468144 1.172017 0.601376 0.693718 1.448725 0.799414 0.880728 1.659068 1.074371 1.173940 1.923380 1.352172 1.432690 0.148249 1.657034 1.683827 0.393349 1.815992 1.878984 0.633772 0.080959 0.207004 0.939926 0.266103 0.400474 1.115930 0.596054 0.657260 1.404123 0.836049 0.928446 1.677288 1.133144 1.173517 1.991475 1.379842 1.421505 0.171548 1.638949 1.726434 0.475929 1.883509 0.003828 0.712873 0.208031 0.204941 1.020101 0.427950 0.531586 1.325147 0.741050 0.807033 1.550594 0.993696 1.080583 1.870636 1.303584 1.380274 0.146127 1.550891 1.638534 0.424311 1.826490 1.951393 0.683635 0.127880 0.249484 1.015411 0.472443 0.498734 1.267047 0.738700 0.793810 1.582735 1.013915 1.126176 1.904037 1.353059 1.419730 0.242518 1.651604 1.745652 0.503034 1.939612 0.041176 0.804535 0.216017 0.394737 1.107819 0.554038 0.668782 1.480573 0.828494 0.957627 1.761486 1.223232 1.335666 0.075548 1.506720 1.598322 0.428725 1.836693 1.928320 0.754337 0.168879 0.270866 1.044918 0.532691 0.608825 1.343428 0.795986 0.971466 1.744885 1.167508 1.223094 0.017057 1.515353 1.597964 0.422675 1.843911 1.948119 0.702147 0.201476 0.309669 1.096668 0.528964 0.634673 1.423707 0.848584 1.000001 1.808786 1.207604 1.372883 0.144156 1.540700 1.678365 0.478068 1.931151 0.043281 0.821937 0.300206 0.436013 1.186904 0.631379 0.750776 1.539368 0.937845 1.125108 1.967963 1.387396 1.501784 0.226440 1.771386 1.899409 0.676648 0.118161 0.238784 1.038534 0.523068 0.600869 1.407102 0.858446 0.987211 1.792866 1.290545 1.368825 0.159787 1.617482 1.795508 0.518924 0.001722 0.103498 0.952968 0.418065 0.563145 1.353363 0.775440 0.910908 1.688856 1.228851 1.327923 0.121616 1.559343 1.738484 0.487364 0.063645 0.119239 0.912560 0.360623 0.570869 1.361487 0.806860 0.974600 1.753633 1.223620 1.329311 0.158179 1.569883 1.748007 0.556569 0.059706 0.167975 0.984762 0.438045 0.622679 1.375505 0.898524 1.024980 1.825875 1.291378 1.427847 0.259130 1.726167 1.841194 0.656323 0.186559 0.249562 1.101575 0.570363 0.726454 1.552860 0.999226 1.150969 1.949587 1.458560 1.573175 0.422154 1.868647 0.045766 0.826583 0.319809 0.441092 1.256403 0.776169 0.896419 1.703549 1.200150 1.339516 0.162880 1.634533 1.784112 0.604233 0.096562 0.289526 1.119500 0.545311 0.674523 1.531601 0.967225 1.206179 1.956117 1.488699 1.660393 0.431004 1.940844 0.128321 0.883214 0.455993 0.559725 1.405709 0.826157 1.016039 1.891755 1.343206 1.495729 0.331885 1.812315 -0.015383 0.795417 0.291550 0.483627 1.328527 0.759904 0.968072 1.768732 1.279469 1.385654 0.245143 1.721788 1.932228 0.695761 0.291876 0.387723 1.228934 0.692836 0.880847 1.741388 1.220680 1.401232 0.246526 1.765079 1.874116 0.724355 0.196606 0.368501 1.200734 0.706066 0.810199 1.676568 1.190306 1.372061 0.209494 1.724913 1.907724 0.740614 0.243968 0.432841 1.234821 0.721324 0.927455 1.798175 1.252111 1.411570 0.270304 1.784565 1.944772 0.792479 0.278839 0.426974 1.308083 0.810142 0.971195 1.844705 1.327413 1.571158 0.358615 1.866194 0.045401 0.854146 0.426509 0.597411 1.392149 0.948284 1.061928 1.957566 1.461166 1.651079 0.513344 0.038906 0.168806 1.067445 0.564903 0.714715 1.615799 1.098515 1.247331 0.140887 1.647270 1.851443 0.618801 0.174506 0.367308 1.251796 0.703998 0.996745 1.782996 1.356021 1.480107 0.387212 1.845498 0.062332 0.874372 0.458358 0.629707 1.476252 0.991806 1.157394 0.041849 1.550949 1.733984 0.583256 0.116129 0.304284 1.204300 0.674023 0.913522 1.749902 1.291446 1.473976 0.316574 1.813126 0.067379 0.943114 0.436184 0.651203 1.459193 1.041375 1.213533 0.108902 1.570998 1.815036 0.637030 0.203093 0.391220 1.255053 0.787852 0.988497 1.872987 1.334556 1.561977 0.445071 1.928656 0.161536 1.015218 0.562919 0.761017 1.646695 1.170802 1.386130 0.189026 1.753740 -0.023752 0.844079 0.381282 0.570746 1.458237 1.025248 1.181150 0.061275 1.583200 1.803335 0.711079 0.248012 0.398071 1.293164 0.842366 1.022810 1.887360 1.496017 1.647590 0.540560 0.087744 0.279795 1.143450 0.709395 0.932782 1.809938 1.344658 1.538819 0.457775 1.925845 0.185590 1.022314 0.571041 0.831467 1.706920 1.253136 1.450041 0.330196 1.860810 0.159373 0.965357 0.520132 0.775089 1.577381 1.199877 1.391422 0.234888 1.831804 0.075733 0.907217 0.470573 0.681752 1.554379 1.122233 1.353448 0.227411 1.753937 0.001642 0.896563 0.454763 0.671066 1.575222 1.063049 1.298751 0.193022 1.756668 -0.007007 0.885113 0.447484 0.664402 1.527278 1.142087 1.351247 0.210369 1.740106 0.003573 0.910960 0.464468 0.712381 1.553916 1.103215 1.342669 0.257057 1.776290 0.035202 0.910143 0.511433 0.732209 1.624320 1.206368 1.398367 0.312907 1.871471 0.120594 0.987950 0.564338 0.751505 1.680009 1.303773 1.490079 0.428253 1.929695 0.231579 1.074664 0.657141 0.869817 1.809849 1.309893 1.603632 0.492700 0.111271 0.293995 1.246058 0.737761 0.960187 1.914508 1.555668 1.768827 0.640218 0.177024 0.411141 1.350813 0.926370 1.159777 0.063372 1.689848 1.910469 0.776269 0.323641 0.577073 1.481464 1.098573 1.320393 0.227178 1.789793 0.050208 0.952878 0.560750 0.828591 1.711132 1.212945 1.533950 0.432206 -0.000432 0.230342 1.215073 0.755910 1.057527 1.894601 1.503352 1.750825 0.666979 0.159424 0.482107 1.414154 0.999605 1.265714 0.136418 1.707343 1.977075 0.885228 0.455175 0.729307 1.636414 1.234734 1.460971 0.400143 -0.006536 0.278618 1.194292 0.737724 1.030285 1.959902 1.534365 1.745565 0.701036 0.289881 0.568527 1.433309 1.067908 1.390901 0.249339 1.854723 0.059458 0.998459 0.592462 0.892467 1.739204 1.366869 1.651348 0.551889 0.151521 0.421769 1.351808 0.940414 1.170001 0.138629 1.752417 0.012043 0.938355 0.553583 0.783987 1.760073 1.292493 1.579562 0.543093 0.181550 0.381101 1.265631 0.880467 1.183661 0.110975 1.743783 1.979006 0.934214 0.506256 0.756714 1.684275 1.292373 1.559459 0.497345 0.104955 0.354961 1.330928 0.950006 1.220038 0.170588 1.733483 -0.018741 0.975513 0.563368 0.819218 1.780064 1.413411 1.641103 0.650254 0.173488 0.473217 1.368645 1.024463 1.264586 0.228691 1.871091 0.114354 1.057069 0.638989 0.972016 1.863185 1.480056 1.804526 0.704980 0.307177 0.585147 1.593343 1.173513 1.437093 0.385990 -0.017039 0.312510 1.254546 0.861478 1.138027 0.105881 1.708560 0.001248 0.941312 0.586720 0.870690 1.787329 1.376876 1.678500 0.666095 0.281578 0.522525 1.485804 1.099243 1.464730 0.395258 0.015483 0.318967 1.232355 0.887912 1.139678 0.056468 1.712148 0.022999 0.974431 0.556327 0.833548 1.821998 1.439211 1.765587 0.640348 0.314390 0.622165 1.529576 1.186578 1.486857 0.464460 0.110802 0.355085 1.354827 0.974930 1.279490 0.216157 1.793988 0.097441 1.090271 0.679979 1.043029 0.009039 1.637591 1.921196 0.836360 0.521844 0.738741 1.771527 1.346696 1.667188 0.612313 0.274240 0.561364 1.569050 1.164227 1.429752 0.444828 0.121585 0.396608 1.352088 0.956423 1.267993 0.255351 1.907451 0.211605 1.230886 0.819291 1.132283 0.160188 1.739033 0.089896 1.030231 0.689801 0.959444 1.910778 1.616944 1.887411 0.860348 0.531332 0.834047 1.803425 1.397746 1.712066 0.670586 0.347827 0.678349 1.647957 1.244912 1.564053 0.587564 0.181500 0.492313 1.540675 1.139262 1.448255 0.422437 0.089925 0.367069 1.306478 0.991986 1.361562 0.309409 1.936023 0.283775 1.273109 0.974636 1.256598 0.208307 1.868841 0.201377 1.202211 0.794952 1.148532 0.165265 1.804991 0.134184 1.098370 0.747997 1.059261 0.017958 1.708074 0.068796 0.926733 0.705460 0.963753 1.940138 1.659003 1.946282 0.934992 0.588180 0.911716 1.954170 1.525168 1.822565 0.894576 0.528161 0.867444 1.864500 1.462311 1.803274 0.812282 0.494311 0.784817 1.849667 1.478786 1.824472 0.811293 0.451917 0.773781 1.759120 1.437534 1.752526 0.697495 0.407448 0.724062 1.736783 1.411811 1.730517 0.736511 0.422498 0.733790 1.810964 1.429060 1.780367 0.739474 0.429175 0.777200 1.771449 1.465981 1.784467 0.802369 0.496550 0.802882 1.823459 1.482781 1.858496 0.808513 0.522167 0.830785 1.848464 1.521594 1.847962 0.857878 0.525593 0.877943 1.919023 1.492307 1.839384 0.877414 0.608694 0.930728 1.838241 1.595340 1.892103 0.910661 0.580246 0.898820 1.942711 1.622611 0.004215 0.987954 0.686799 0.997999 -0.044877 1.689936 0.028109 1.066135 0.659994 1.054193 0.103982 1.759857 0.092505 1.149904 0.788451 1.161517 0.169041 1.809898 0.212612 1.220090 0.971380 1.298488 0.314114 1.938997 0.334994 1.318778 1.035857 1.357422 0.384508 0.042514 0.422343 1.500607 1.151031 1.494135 0.536705 0.270066 0.562549 1.615867 1.345514 1.682138 0.641944 0.337434 0.729557 1.728540 1.440655 1.791605 0.806185 0.585090 0.860671 1.893652 1.538825 1.968206 1.026252 0.663603 0.992031 0.056291 1.774303 0.077021 1.151545 0.886854 1.234880 0.203764 1.870700 0.323608 1.303808 0.974785 1.320051 0.431506 0.149903 0.451406 1.519379 1.238960 1.539852 0.555021 0.330655 0.649375 1.653565 1.403102 1.818885 0.820032 0.499131 0.863534 1.885191 1.633712 1.975794 0.982270 0.690005 1.048606 0.135805 1.811120 0.238001 1.242591 0.946616 1.287961 0.324930 -0.006140 0.455126 1.463835 1.187455 1.495394 0.592179 0.272325 0.658153 1.717484 1.406375 1.876105 0.871060 0.588290 0.947870 -0.011079 1.689798 0.066529 1.168621 0.843739 1.220459 0.271050 1.915845 0.302526 1.443878 1.118154 1.441808 0.542518 0.233448 0.609058 1.716180 1.431394 1.799957 0.860178 0.536289 0.975256 -0.840142 1.680544 0.071397 1.069148 0.838814 1.216434 0.242704 0.067700 0.358040 1.424847 1.138148 1.557657 0.637387 0.358573 0.701760 1.772908 1.517884 1.870765 0.927996 0.670271 1.021508 0.088473 1.838064 0.222310 1.255891 1.044018 1.445347 0.429469 0.174089 0.608501 1.685264 1.368702 1.794956 0.872773 0.592794 1.015918 0.022016 1.825930 0.177459 1.234445 0.981769 1.375220 0.427468 0.169649 0.572634 1.651430 1.417276 1.768244 0.889168 0.636412 1.017852 0.027987)
       )


))

;; :all 65536 (320.768635104 1.6604741485419 0.83776099628482) 0.52033682944489
;; :all 65536 (309.91637906494 0.64007539845073 4.5547029008803e-05) 0.5172334495671 (0)
;; :all 65536 (303.64661814299 1.3570805366568 -4.6971909684279e-05) 0.5153905931919 (200)

;; :all 131072 (438.77509431894 1.4462367399126 2.0944027696821) 0.51631398987158  (sqrt: 362)



;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

(vector 1  1.0   #r(0)
     )

(vector 2  1.539 #r(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
(vector 3  1.7548747062683 #r(0 1 1)

     1.7393749801561 #r(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #r(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #r(0.0 0.79018270969391 0.69699490070343)

     1.738745 #r(0.000000 1.209826 1.303017)
     1.738744 #r(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
(vector 4  2.19460272789 #r(0 1 0 0)

     2.050 #r(0 39/25 26/29 27/22)
     2.048743724823 #r(0 111/256 281/256 195/256)
     2.0466175079346 #r(0 223/512 563/512 49/64)

     2.045218 #r(0.000000 1.563819 0.899661 1.233860)
     2.045217 #r(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
(vector 5  2.7317879199982 #r(0 1 1 0 0)

     2.3731805734023 #r(0 7/16 7/4 5/8 7/16)

     2.307252 #r(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #r(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
(vector 6  2.8638670444489 #r(0 0 0 0 1 0)

     2.522759 #r(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #r(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
(vector 7  2.9204399585724 #r(0 0 0 1 1 0 1)

     2.618497 #r(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #r(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     2.618302 #r(0.000000 0.474154 1.477730 1.824846 1.552894 0.429720 0.035636)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
(vector 8  3.2507002353668 #r(0 1 1 0 1 1 1 0)

     2.8071956634521 #r(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.790858 #r(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #r(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     2.790663 #r(0.000000 1.196617 0.325818 1.109894 1.316877 0.229200 -0.008217 -0.130363)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
(vector 9  3.4140722751617 #r(0 0 1 1 1 1 0 1 0)

     2.886575 #r(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #r(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     2.886241 #r(0.000000 1.605727 1.374318 0.351747 1.930232 0.197770 0.092557 1.097753 1.623786)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
(vector 10 3.5391488075256 #r(0 0 1 1 0 1 0 0 0 0)

     3.054055 #r(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #r(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #r(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #r(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #r(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     3.053435 #r(0.000000 0.525383 0.155614 0.727601 -0.282536 -0.043650 0.155330 1.412909 0.659050 0.474369)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.6182308197021 #r(0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 #r(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #r(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #r(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #r(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #r(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     3.176608 #r(0.000000 1.744464 0.362417 -0.030039 1.129933 0.735652 0.691339 0.545454 1.302582 0.237082 0.742494)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
(vector 12 4.0 #r(0 0 1 1 0 0 0 0 0 1 0 1)

     3.363698 #r(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 #r(0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     3.361884 #r(0.000000 -0.077168 1.405944 1.028559 1.007566 1.871331 0.482574 0.792122 0.203932 1.027727 0.649507 1.365630)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
(vector 13 3.8778836727142 #r(0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.476053 #r(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 #r(0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 #r(0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     3.474532 #r(0.000000 1.621213 1.042646 1.653413 1.561849 1.044891 1.473168 -0.158623 0.083544 1.042513 0.507800 0.949479 0.059341)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
(vector 14 4.2842662512094 #r(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.600425 #r(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 #r(0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     3.598494 #r(0.000000 0.850577 1.637081 0.089423 1.006545 0.749551 1.681409 0.420517 -0.044040 1.351533 1.177890 1.148728 1.524043 1.447267)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
(vector 15 4.4701427567987 #r(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)

     3.738430 #r(0.000000 1.190239 0.174514 1.589466 1.706591 1.305812 1.416225 0.779885 1.746839 1.699566 1.113488 1.734421 0.117674 0.652032 0.763074)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
(vector 16 4.5778832343715 #r(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)

     3.857020 #r(0.000000 0.144607 0.675956 0.016527 0.269112 1.012147 1.772535 1.584482 1.808783 0.289484 1.400085 0.669674 0.174650 0.295492 -0.017769 1.108482)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
(vector 17 4.5790815353394 #r(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)

     3.926355 #r(0.000000 0.619515 0.864447 1.181990 1.677700 1.930862 0.582927 1.823955 0.470265 1.290931 0.488790 0.031736 1.163146 0.861017 0.648828 0.818286 0.301049)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
(vector 18 4.801501750946 #r(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)

     4.069528 #r(0.000000 0.956814 1.082990 0.493213 0.796608 0.137780 0.611831 0.387091 -0.011186 0.965014 0.614046 1.752338 0.348807 1.169857 1.216059 1.508238 0.182073 1.770765)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
(vector 19 4.8924918279945 #r(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.171858 #r(0.000000 0.330499 1.406874 1.250304 0.450026 0.551790 1.342413 1.858827 1.359366 0.223792 0.553485 1.256415 0.641759 -0.208630 1.490602 1.646088 1.388713 1.758053 1.297635)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
(vector 20 5.043 #r(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.300411 #r(0.000000 1.455414 0.307661 1.246638 0.208834 -0.246349 0.167594 0.620918 -0.100474 0.159208 -0.133203 0.480470 0.395357 -0.304743 1.170590 1.114440 -0.446663 0.344322 0.430311 -0.130164)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
(vector 21 5.1372244578347 #r(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.398753 #r(0.000000 1.496452 0.530521 1.466840 1.037430 0.768041 1.062178 0.568630 0.521390 0.318401 0.839156 1.187950 1.614960 0.975948 -0.029541 0.335933 1.354945 0.841788 0.263047 0.509077 1.300143)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
(vector 22 5.1805551751198 #r(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.519002 #r(0.000000 -0.221397 1.057824 1.492981 -0.263486 0.870091 -0.528249 -0.376750 0.756810 0.176851 -0.090091 1.600251 -0.084632 0.635148 0.821442 1.002126 0.978361 0.034872 -0.759728 0.321190 0.972421 0.245173)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
(vector 23 5.4125407453101 #r(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.634407 #r(0.000000 0.337913 0.805462 -0.065533 0.702753 1.354327 1.334664 1.709523 1.331667 0.152462 1.257186 0.263947 0.769802 0.707842 0.485157 -0.009174 0.212207 1.154954 0.942106 0.386101 0.011788 0.687978 0.407297)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
(vector 24 5.6193280144865 #r(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.782962 #r(0.000000 0.726238 0.856679 1.665577 0.271280 1.375871 -0.206382 0.592175 -0.087179 0.530852 -0.360257 0.901705 1.189234 1.262764 0.081277 0.072171 0.340463 -0.285522 -0.360411 0.039578 0.016656 -0.483158 0.696443 0.115110)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
(vector 25 5.7220960914079 #r(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.833585 #r(0.000000 0.684418 0.231543 1.068448 1.131681 0.716084 -0.543413 0.960963 0.108056 -0.510271 1.064008 -0.527153 -0.574236 0.032340 0.486849 0.263393 -0.542768 -0.456188 1.134973 -0.877871 -0.236595 -0.839653 -0.635589 0.413586 0.738028)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.8537594936002 #r(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     4.996683 #r(0.000000 1.740815 1.471360 1.504333 0.793966 0.944959 1.469851 -0.050031 1.395444 0.990928 0.238054 1.493878 0.769155 0.680547 1.256014 1.792102 0.136976 0.478247 0.085153 0.474291 1.616841 0.617611 1.491514 0.741599 1.059794 1.082318)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
(vector 27 5.8637111082051 #r(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.085376 #r(0.000000 0.134436 1.259874 1.228201 1.060157 0.078706 0.158097 0.004323 0.734629 1.196644 1.588020 0.348173 1.210355 0.008907 0.409496 0.060743 1.186070 0.848591 0.158658 1.296780 0.556238 1.631048 0.049386 1.686839 1.701113 1.829904 1.814076)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
(vector 28 6.0276107788086 #r(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.088899 #r(0.000000 1.695594 -0.042323 0.221585 0.121059 0.906440 0.747864 0.144725 -0.170880 0.198031 0.623261 -0.016920 1.187997 1.805776 0.526952 0.257290 0.181436 1.671568 1.634262 0.482276 1.385748 1.687591 0.368532 1.304502 0.925524 0.205838 0.775793 0.352193)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
(vector 29 6.0348020511367 #r(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.257294 #r(0.000000 0.173417 0.594854 0.796262 1.448087 0.088760 1.776024 0.565819 1.873894 1.383720 1.178388 1.220868 0.937816 1.832318 0.979592 0.662513 0.591751 1.726716 0.993575 1.320249 1.240786 1.241192 0.451577 1.543498 1.557502 0.291356 1.099404 0.030228 0.632911)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
(vector 30 6.2357559204102 #r(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.352588 #r(0.000000 -0.273931 0.766389 0.417785 1.759969 0.852970 1.831793 0.250419 0.820927 0.459290 0.634623 1.258292 -0.010367 0.819856 0.603568 1.142686 0.772733 1.853850 1.422248 1.684383 1.092051 0.281817 0.215433 0.103401 0.692837 1.549368 1.938793 1.739493 1.350311 1.578167)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.1342258453369 #r(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.418933 #r(0.000000 1.386056 -0.055103 1.470738 1.133338 0.301486 1.278842 0.118113 0.785586 0.164711 0.277129 1.264947 0.805303 0.592921 0.251470 0.348783 0.666372 0.600263 0.392807 1.237206 -0.185182 1.790868 1.684032 0.764715 0.385641 1.091814 0.146242 0.339596 0.884327 1.106807 0.158763)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
(vector 32 6.3532226957365 #r(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.554282 #r(0.000000 0.816259 1.135795 0.419505 0.912392 1.329202 -0.011674 1.699095 0.214307 0.958468 0.757524 0.614160 1.049094 0.938482 -0.150346 1.472378 0.880973 1.239494 1.186161 -0.560917 0.537372 -0.630416 1.261165 0.779340 0.375126 0.275636 0.093262 0.807297 -0.527117 0.344669 -0.098528 0.951269)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.4944429397583 #r(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.596725 #r(0.000000 1.566022 1.098312 1.164250 1.358443 0.666170 0.123772 1.539713 1.080327 0.949887 1.000744 0.558327 0.425174 0.601125 1.113026 -0.252224 -0.088541 0.265061 1.258875 0.446564 0.313471 0.950131 1.109618 0.844385 0.897432 -0.212241 0.780013 -1.109704 -0.115786 -1.020678 -0.360032 -1.011400 -0.261343)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
(vector 34 6.5771403312683 #r(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.725987 #r(0.000000 0.519367 0.839823 -0.270825 0.109454 0.590467 0.913562 0.338240 0.071129 -0.105723 1.750935 0.267748 -0.404466 1.149320 1.216044 1.315944 0.273465 0.224953 0.819588 0.266322 1.090176 0.636294 0.946461 0.941057 1.379249 -0.063333 1.242866 1.083182 0.490025 1.577337 -0.166600 0.867461 -0.258069 0.984239)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7392678260803 #r(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.800689 #r(0.000000 0.926939 1.434899 1.770213 -0.032113 1.166817 1.853226 0.033896 0.174661 1.059390 0.075778 0.414951 0.221172 0.607934 1.085944 1.232679 0.199374 1.572200 -0.354520 0.604613 0.181334 -0.101308 1.619435 1.744803 -0.721948 -0.722569 1.107370 0.041999 0.835091 -0.057731 1.047643 0.849970 -0.264010 1.176630 0.079939)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
(vector 36 6.8277182579041 #r(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     5.955517 #r(0.000000 0.055570 1.549922 0.853737 0.624076 1.334199 0.184749 -0.259730 1.683917 0.658119 0.518031 1.114143 1.834748 0.240135 0.686226 1.594355 0.818362 0.911264 0.125798 1.176687 1.122947 1.481670 1.730422 1.606173 0.555515 1.695824 0.234706 -0.125347 1.452732 1.327862 1.547467 1.305954 1.401386 0.797969 -0.255922 0.677864)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0 #r(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     5.958733 #r(0.000000 0.917663 1.844637 0.917064 -0.023000 0.522084 -0.140968 0.590202 1.162918 0.977399 0.746122 1.380937 0.072636 1.554351 0.021676 0.452021 0.866436 -0.137694 0.850594 0.868352 1.449562 0.284332 0.323347 1.249529 1.414413 1.248087 0.371239 0.070568 1.173801 0.662841 -0.037509 -0.074833 0.387956 0.180917 0.212366 0.047055 -0.176085)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.027690410614 #r(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.070762 #r(0.000000 0.941112 1.606275 0.795569 1.716377 0.414621 -0.069599 0.261380 1.139598 0.918794 0.811587 1.190473 -0.001751 -0.235083 -0.407937 0.429904 1.210405 0.197484 0.283645 0.965951 1.603201 0.617843 0.387138 1.148979 1.545047 1.341130 0.328130 -0.176365 1.121055 0.874462 0.091608 -0.104011 0.218759 -0.142526 -0.118310 -0.176000 -0.278677 -0.106141)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.2362656593323 #r(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.167830 #r(0.000000 0.381682 1.454889 1.813827 0.398778 0.697480 0.558162 1.483181 1.237051 1.265786 1.074761 0.610761 1.386966 1.563268 0.753925 0.849282 0.970201 0.241940 1.250845 0.715139 1.559620 -0.163681 1.839963 0.617302 1.618908 0.275318 1.613093 1.347193 0.955958 0.023995 0.940280 0.483611 0.627383 1.598354 1.353819 1.269307 1.755190 1.092076 0.973923)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.5038495063782 #r(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.265198 #r(0.000000 1.305916 1.193211 1.131633 0.400580 0.759598 0.164070 1.799072 1.091771 1.559662 0.436556 1.108470 0.518624 0.349203 1.311455 0.208409 0.728546 -0.009336 0.551231 -0.062893 1.432448 1.592165 0.332763 1.326264 1.383816 1.474947 0.298106 1.148715 1.434554 -0.546890 0.369301 1.865917 0.945786 0.522218 1.444025 1.269985 1.507602 1.425880 1.940882 1.667877)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.7093445316966 #r(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.321636 #r(0.000000 0.581881 1.284007 1.435590 0.968036 0.414485 0.203921 -0.085398 1.011694 1.215509 0.697775 0.907045 0.006237 0.289299 0.751565 0.182523 1.917428 0.830815 0.908047 0.267572 -0.061197 0.319855 0.591342 1.699511 1.912692 1.683447 0.192711 0.461781 0.828435 1.122559 0.524721 1.057548 0.753199 0.901168 -0.077807 0.957092 -0.092721 1.453709 0.349112 1.539336 1.035529)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.77445936203 #r(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.403222 #r(0.000000 0.615457 1.471291 0.696790 0.198813 1.064683 0.257669 1.499443 1.009189 1.331704 -0.126692 0.668087 -0.151536 1.235993 1.351147 1.834812 1.622001 1.575606 0.387431 1.123625 1.738720 0.186291 -0.093048 -0.362694 1.268339 0.808624 0.147243 0.174237 0.939940 0.098301 1.557405 1.899768 1.063327 1.398074 1.503515 -0.309876 1.592871 1.047295 0.347548 0.500256 0.502585 1.050388)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.7573688953539 #r(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.474181 #r(0.000000 0.163031 0.868018 0.644438 0.499955 0.314476 0.501651 0.136276 0.115801 1.311189 1.257885 1.003167 1.668510 0.653556 0.900535 0.185303 1.792109 1.097281 0.880040 0.351492 0.533331 1.402396 1.722630 -0.341451 0.699659 1.677594 1.684893 1.301554 -0.032447 0.458521 1.242927 0.587312 1.726991 0.987710 0.168427 1.112409 0.233710 0.476465 1.063291 1.023410 1.387257 1.104431 1.814614)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9338580613871 #r(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.599250 #r(0.000000 0.351178 1.306835 1.466283 1.319851 0.565360 0.401323 -0.237018 1.055625 0.418518 0.685726 1.681541 1.845435 1.019294 1.472175 1.617323 0.599443 0.202024 1.548869 0.896807 1.498980 -0.449736 0.958935 0.672395 0.465421 0.363298 0.745996 0.800573 1.320237 0.704768 1.103042 1.233693 0.653096 1.449790 0.411870 1.110453 0.556583 1.736823 0.345497 0.024788 0.937504 1.224464 1.559019 1.346766)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1351366043091 #r(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.624897 #r(0.000000 1.004365 0.475962 1.144412 0.404466 0.708852 0.590380 0.024072 1.172296 1.113281 1.630362 1.256665 1.314082 0.342438 0.579726 1.460036 0.838934 0.298273 1.354989 1.643563 1.558056 1.967600 0.749164 1.349815 0.523705 0.276619 1.145711 1.733713 1.155806 1.020242 0.468578 1.677226 1.799379 1.623813 1.799356 0.670303 1.547676 1.429802 1.095547 0.114545 0.743241 1.141259 0.963105 1.247487 0.978965)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.1455316543579 #r(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.709237 #r(0.000000 0.588728 0.764172 0.948247 0.778447 1.268756 0.080491 -0.381973 0.448541 1.688302 0.583900 0.609230 0.913000 1.244782 0.098190 0.458033 0.787717 0.012905 0.854674 1.035325 1.255759 0.507374 1.208176 0.514489 0.741105 1.441899 0.585374 1.583344 0.643511 1.525932 1.201616 0.846916 0.319659 0.030560 0.895113 0.341984 -0.007305 1.588064 0.007988 0.334683 0.349739 -0.215667 -0.068989 1.488454 0.988215 0.867211)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.336971282959  #r(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.785244 #r(0.000000 0.898263 0.698671 0.821497 0.370262 0.536725 0.016930 1.555315 1.553643 1.249848 -0.203480 1.765177 0.026588 0.111231 -0.039332 0.662791 0.096267 1.286138 1.353013 0.226230 0.057438 1.648120 -0.088502 0.524016 1.306955 -0.084552 0.350695 1.753518 1.303444 0.678968 0.693452 0.498589 1.005882 1.660165 0.430707 0.068634 0.587061 1.130543 1.939600 0.152146 1.459634 0.723147 1.428638 0.763075 1.800028 1.481715 0.488673)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.35563071219336 #r(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.828028 #r(0.000000 0.998004 1.077433 0.148071 1.527370 -0.144913 1.645316 1.723923 0.412024 1.174877 0.494923 1.411660 0.605628 1.628272 1.064698 1.228914 0.098971 0.692407 0.395792 1.297327 -0.001580 1.140646 1.342219 1.577941 0.241000 1.510351 1.184692 1.697190 1.378912 1.591005 -0.082196 0.468455 0.883072 0.625939 0.755107 0.095773 0.293743 0.637279 1.770381 1.345208 0.924216 0.393583 0.137327 1.278382 0.157871 0.442417 0.371701 -0.029442)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
(vector 49 8.57458718352971 #r(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

	6.985814 #r(0.000000 1.352748 1.065088 0.376466 1.263775 1.869507 0.064753 1.165618 0.141890 0.638515 0.828094 1.038958 1.583826 1.734755 1.477486 1.795519 0.004163 0.751410 1.671716 1.124011 0.269271 1.493917 0.669031 1.045125 0.496799 1.530976 1.616053 1.745132 0.120791 1.586151 1.862818 1.592630 1.615032 1.872559 1.107306 1.049698 0.182616 1.894893 0.054689 0.854276 1.308061 1.075982 0.240671 0.749058 1.273625 0.766343 0.677203 0.139645 1.215492)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
(vector 50 8.711 #r(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.947137 #r(0.000000 1.361221 1.058873 0.255818 1.371652 1.848584 -0.002271 1.052656 0.139885 0.680884 0.885258 1.006144 1.663943 1.665052 1.470510 1.693036 0.091983 0.825894 1.755289 1.033123 0.055566 1.508725 0.691199 1.233170 0.641006 1.442066 1.557992 1.909688 0.175284 1.577225 1.678517 1.358807 1.558359 1.883371 1.133931 1.053187 0.137949 1.901321 0.058023 0.971798 1.378739 0.843519 0.357409 0.498187 1.235125 0.734586 0.653589 0.242791 1.085625 -0.043484)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.5829010009766 #r(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.087726 #r(0.000000 0.875029 0.865937 0.367918 1.900818 0.762934 0.081270 0.353365 0.070375 -0.037477 1.275772 -0.100171 1.088567 1.481918 0.798713 1.260047 0.731048 1.035501 1.384103 0.728234 0.608922 1.769831 1.228331 0.727930 1.038826 -0.062865 0.731133 1.490525 1.564219 0.530975 0.845759 -0.127106 1.209031 0.537607 1.042200 0.906452 -0.105250 0.353212 0.368083 1.395843 1.206034 1.694293 0.348968 0.222228 0.523051 0.375570 0.283017 1.406111 0.934909 0.587260 0.940073)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.8599758148193 #r(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.080087 #r(0.000000 0.216994 0.815073 0.651401 0.471967 0.035007 -0.067747 0.660856 0.580235 0.052345 1.785696 0.529423 0.205578 -0.247148 1.238971 0.096672 0.952857 0.166426 0.759284 1.719458 0.161518 1.592928 0.883009 0.245604 1.208605 0.995562 0.029395 0.487673 1.152615 0.362903 0.721410 0.862934 0.090743 0.014994 0.082182 0.993529 1.056537 1.708353 0.746025 -0.333233 1.155949 0.740213 0.619117 1.020646 1.502770 1.347142 1.371490 1.480724 0.363059 1.828476 0.147552 0.424061)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.037 #r(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.252601 #r(0.000000 1.316368 0.101159 0.287376 -0.120486 -0.146148 -0.293575 0.279566 1.566833 0.692861 -0.116203 1.111486 1.592177 1.082742 0.010661 0.754630 0.400780 0.795713 1.670109 1.185717 1.226796 -0.120012 0.262637 0.206364 0.738299 0.157263 0.604374 0.683095 1.946305 -0.043066 0.580881 1.320138 -0.043078 1.307240 1.171743 0.356072 0.398418 -0.096678 0.059824 1.235855 0.057573 -0.031810 1.322088 0.600804 1.405030 -0.237620 -0.007423 -0.083489 1.021491 1.628805 -0.222749 0.516076 0.301362)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.025 #r(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.328138 #r(0.000000 0.352535 1.363504 0.096670 1.597330 -0.030072 1.222144 1.243528 0.696875 0.968663 0.162138 1.056566 0.539804 0.008667 0.316670 -0.098837 1.225380 -0.112322 0.244903 0.436331 1.746403 0.122260 0.091220 1.558109 1.217585 1.412994 0.339182 0.690620 1.846588 1.658518 0.529876 1.420789 0.398352 0.612668 1.926173 0.676632 0.529358 1.076039 0.628593 -0.021834 1.281928 0.607717 0.819453 1.795488 1.260788 0.439390 0.834961 1.345636 1.190831 1.783406 -0.135996 0.097131 0.579836 0.358027)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.2039985656738 #r(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.364233 #r(0.000000 0.395190 -0.153867 1.307052 0.778840 1.201427 1.584425 -0.091689 1.563398 0.221226 1.485388 0.595790 -0.041635 0.380534 0.103234 0.445988 1.706774 1.178799 1.315522 1.096083 0.260274 -0.072891 0.228062 0.239593 1.575799 0.203611 0.427975 1.251992 1.620128 0.666682 0.636489 0.025180 0.388251 0.546392 1.107252 0.996609 1.708598 0.607806 -0.354744 1.114522 1.187212 0.060556 1.020751 1.136440 0.719385 1.579705 0.166783 0.736570 0.421572 0.534881 0.141987 1.649951 0.500500 0.386302 -0.074892)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.3816785812378 #r(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.419120 #r(0.000000 0.417128 1.082491 1.276854 0.765982 1.295111 1.835030 1.786443 0.675192 1.020185 0.394420 0.359608 0.697463 1.166247 0.564899 1.087103 0.889865 0.844186 1.419287 1.562675 0.248998 1.869468 1.111986 1.294693 1.863255 0.052934 0.338636 1.626312 1.601681 -0.021561 1.462490 1.791020 0.409025 1.675990 1.011444 1.359048 1.605820 1.247285 1.024241 0.457113 0.153603 0.242127 1.175155 0.206257 1.412766 1.496703 -0.140135 1.270904 0.393803 1.315634 0.897708 1.585792 0.563930 1.722379 1.612675 1.047507)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
(vector 57 9.3903837203979 #r(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.488896 #r(0.000000 -0.127939 1.380652 0.701541 0.779535 0.090662 1.662797 0.879717 1.570316 1.307786 1.211090 0.971455 0.738042 1.474139 1.501173 1.322773 -0.333947 0.651999 1.407414 0.559437 0.970911 0.613447 1.441437 0.387240 1.769723 0.695953 -0.175580 0.102181 0.180022 1.529463 0.468743 0.084931 0.062956 0.298511 0.524008 0.924744 1.286647 1.428978 0.334028 1.302926 0.807711 0.283976 0.097723 1.284073 0.038191 0.329167 1.275797 0.351298 1.518403 1.571791 0.227818 0.842734 0.707030 0.435243 0.618490 0.867851 1.852691)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.5893135070801 #r(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.585947 #r(0.000000 0.517595 -0.138781 1.328351 0.394157 0.908218 0.526218 1.063012 1.239066 1.277916 1.783309 1.590363 0.539572 1.425376 1.601385 0.376842 0.888852 1.358950 1.916790 1.468314 0.490842 0.036065 1.359391 1.047397 0.699655 1.225098 0.065253 0.350008 0.483077 1.188989 1.002860 0.893562 0.202836 0.208109 1.801392 1.050084 -0.102454 1.813439 1.482474 -0.166271 1.426695 0.563055 -0.225427 0.436837 1.102639 0.467507 0.283291 1.511898 0.400494 1.606371 -0.049354 1.495330 -0.267319 0.336083 0.925094 0.220186 1.902233 -0.035784)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
(vector 59 9.5173864364624 #r(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.617785 #r(0.000000 1.762340 0.513621 1.350480 0.395272 0.369068 0.305583 0.831518 1.232517 0.676844 0.014044 1.888953 1.633364 1.298874 0.424500 1.402106 0.715815 1.275937 1.488547 1.873193 1.738228 0.570388 0.057875 1.975863 0.297300 1.563912 0.772704 0.090655 0.241787 1.145030 0.785784 1.432008 1.006607 1.408581 0.812224 0.224382 0.926131 0.944185 -0.064326 0.205583 1.060366 0.673429 1.237483 1.421583 0.464247 1.651757 1.984268 1.030220 1.489122 1.350599 0.646010 1.371095 0.262034 0.720620 1.557135 1.181053 0.745491 0.926931 1.443337)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.6560277938843 #r(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.699628 #r(0.000000 -0.021305 0.599580 1.675097 0.724803 0.358532 0.890770 0.765518 0.237166 0.821603 0.185949 0.996346 -0.076908 1.733595 1.718331 -0.080896 1.631867 0.229557 1.219113 -0.444442 1.509828 0.286787 0.741904 1.151478 1.816287 -0.008152 -0.169986 1.514652 0.248473 1.296089 1.211441 0.399013 0.342384 1.801962 0.377537 0.181714 1.809056 1.599925 0.494049 0.298590 0.110648 0.855221 1.804868 0.666943 1.224265 1.636192 1.425598 0.559152 0.087897 0.972335 -0.105600 1.103327 1.345409 0.428767 -0.084957 1.609410 0.060258 0.846549 0.678506 0.580784)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.6689287776524 #r(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.775467 #r(0.000000 -0.343145 0.781525 1.809127 0.251480 0.512435 0.079273 1.157280 0.819596 0.391398 -0.518556 1.678636 0.560600 0.125318 0.035700 1.744672 1.824327 1.087291 1.692006 0.706036 0.269610 1.403225 1.233897 0.487088 1.476172 -0.284871 0.794501 1.368364 0.656660 0.974817 1.000338 0.175726 1.024682 0.865508 0.404847 0.718158 0.071740 1.457732 -0.480756 0.735357 1.217441 0.811494 1.022056 0.829877 1.509011 1.174960 1.639594 0.781475 -0.011943 1.221853 -0.208689 0.133149 0.650142 1.217107 -0.446658 0.092120 -0.062880 0.676055 0.910707 0.946198 0.780527)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.7982149124146 #r(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.816985 #r(0.000000 0.185485 -0.254761 0.263400 0.632430 0.127767 1.483161 1.282005 1.556675 0.709224 0.293439 0.049467 -0.087443 1.425471 0.595679 0.678957 0.447779 0.382124 0.717681 0.082649 -1.563917 -0.140691 0.229960 0.339346 0.083428 0.640485 0.923623 -0.076532 1.385224 0.166806 1.518517 1.222370 1.575074 0.899045 0.324075 1.508603 -0.064272 0.115115 0.407781 0.298344 1.252368 1.084082 0.264721 0.922346 1.331199 0.689780 0.795795 1.526817 0.163429 0.888100 0.510259 1.478381 0.318687 1.341508 1.785614 0.798865 0.525568 1.053899 1.308203 0.410567 -0.026960 1.103176)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.8550319671631 #r(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.904133 #r(0.000000 1.545501 0.155683 0.898914 0.625696 0.564119 0.345790 0.703891 0.981672 1.014462 1.740323 0.008567 -0.039871 0.470077 1.202746 0.366398 0.367999 1.293490 0.310624 1.016687 1.843528 0.474437 1.864085 0.859066 0.880435 1.525047 0.949229 0.065485 0.658928 0.625456 0.890422 0.157110 0.668174 1.537633 -0.133525 1.887056 1.094821 1.580831 1.506736 1.621226 1.791740 1.492769 0.830911 0.166732 1.797834 0.044991 1.834240 1.000450 1.479368 0.610232 0.816463 1.240492 0.107919 -0.111385 1.348751 1.167090 0.907202 0.154866 1.422414 0.720983 0.430601 -0.041659 0.656229)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
(vector 64 10.0 #r(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     7.957414 #r(0.000000 0.941670 0.218463 1.054436 0.821282 0.779097 1.084317 0.220811 0.530574 -0.001214 1.277468 1.056444 1.434429 0.244804 0.635637 0.374642 1.294283 0.051882 1.563945 0.856817 0.659797 0.848723 0.789207 0.004337 0.642492 -0.752744 0.794434 0.546992 1.340010 0.716341 1.722360 1.081100 1.009399 0.345867 1.393328 1.377443 1.264631 0.487017 1.142544 0.031648 0.469271 -0.098334 -0.019627 0.567023 1.791954 0.511740 0.421519 0.992945 1.133377 1.668348 -0.054246 0.158608 -0.042808 1.772093 0.331126 0.762153 1.499580 1.813299 1.079657 1.088576 0.368377 1.519001 0.864479 0.914946)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.169842720032 #r(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.040855 #r(0.000000 1.507786 1.415372 1.703926 1.500233 1.179747 -0.086038 1.271067 0.241330 1.453321 1.112825 0.408932 0.079619 0.501656 0.792814 1.679514 -0.023064 0.144220 0.265584 0.573417 1.899192 0.051511 1.631616 1.086663 1.410383 1.613900 0.536011 1.591177 0.698399 1.181483 1.728211 0.256554 -0.283132 0.355776 1.802436 1.248796 1.634590 1.262544 1.397780 0.053710 1.072831 0.031772 0.078446 0.128037 0.853258 1.218686 1.277789 0.847077 0.934403 1.722304 0.163187 0.957497 1.531555 1.320004 0.466076 -0.023032 1.791699 1.045097 0.495828 1.812354 0.196561 1.248643 0.569902 0.907793 0.854507)
     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.212840820553 #r(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.095195 #r(0.000000 0.946051 -0.069946 0.931149 1.114323 1.098389 -0.039332 0.877524 1.318916 1.775911 0.245290 1.539842 0.131201 -0.108794 0.748602 -0.153383 1.475925 0.851225 0.482687 0.831474 -0.195116 0.598903 -0.150418 1.241002 0.075671 1.415619 1.425349 0.401276 1.645496 1.378829 0.717955 0.820749 0.280776 0.102463 1.505118 1.466659 1.804612 0.370381 0.198640 0.039917 0.927835 0.130993 1.362388 0.264055 0.657827 1.168088 0.670275 0.998910 -0.080695 -0.000494 1.446059 0.092607 0.764024 1.120077 1.135001 1.626300 -0.038234 1.325677 1.373468 1.689492 1.591066 1.008988 0.840459 1.246657 1.459948 0.945345)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.209677696228 #r(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.127999 #r(0.000000 0.156189 0.759312 0.316632 1.612933 0.605013 0.952530 0.423099 -0.112233 1.447269 0.863131 0.200670 1.538179 0.172873 0.737196 0.916694 1.524894 1.423218 1.337268 0.799228 0.023760 0.359774 1.033535 1.252717 0.399347 1.736421 0.199827 0.358145 1.847858 -0.157369 -0.118965 -0.296280 1.764663 0.918422 0.547247 0.781682 -0.101912 1.939111 1.078792 1.928250 0.777073 0.358591 1.566766 0.658960 0.895914 1.285541 1.636763 -0.098157 1.684110 0.891684 1.386081 0.068089 0.497477 0.528377 0.140207 0.953073 0.655659 0.018618 0.774991 0.503967 1.384065 0.100041 0.959741 0.153740 0.654728 0.200720 0.384936)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
(vector 68 10.359804316765 #r(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.204414 #r(0.000000 0.279095 1.647677 0.913913 0.663406 0.323080 0.240930 0.148599 0.780719 0.015227 1.335435 0.919514 1.070941 0.877126 0.293550 1.686752 0.481693 0.755701 0.785320 0.815615 1.595420 1.293383 0.426688 0.494705 1.026142 0.549725 1.259770 -0.007824 0.278489 0.224750 0.082547 0.719555 0.355973 0.908801 0.541094 0.432336 1.241602 1.708744 0.772870 1.505613 -0.137480 0.654507 1.657469 0.849573 0.009380 1.611286 1.676352 1.046709 1.432096 0.979028 1.747525 0.522938 0.318568 1.148496 -0.245690 0.703484 0.171945 1.485079 1.659272 -0.006233 0.283657 1.852744 1.398727 0.371514 0.974831 1.325922 0.719933 0.483798)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.452348709106 #r(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.274908 #r(0.000000 1.788801 1.283513 -0.242756 0.145250 0.146755 0.584479 1.353542 0.821070 0.189803 1.413669 0.749926 1.058442 1.185407 1.095039 1.015258 0.161858 0.034929 0.498704 0.198138 1.711445 0.157768 0.616185 1.421248 1.168404 0.254474 1.519482 -0.175837 0.581687 0.194579 0.931780 -0.336100 0.287461 1.495068 0.039168 1.507647 0.993152 1.382317 1.231363 0.721890 1.622206 1.080570 0.186638 0.155662 0.909604 1.203958 1.050254 1.890059 0.428940 0.701250 -0.160137 0.279994 1.502298 0.567568 0.585424 0.686015 -0.246566 0.662061 0.986133 1.103373 0.572438 0.607162 -0.159332 0.926622 1.112278 0.937694 0.624990 1.345312 0.670451)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.431521047498 #r(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.328488 #r(0.000000 1.209391 0.655351 -0.224668 0.270551 0.912782 1.006468 0.115362 1.639506 1.394128 1.775544 -0.158964 -0.191285 0.916307 -0.148807 -0.343643 0.171981 0.447415 0.684977 -0.187759 0.122627 0.642332 0.846737 0.920787 0.824105 -0.455822 1.004331 0.650453 0.327784 -0.378239 0.335174 0.883411 0.475111 1.924029 1.429019 1.351303 -0.183533 1.395982 0.599233 0.896200 1.135652 0.575692 1.213789 1.853140 0.377792 1.790714 0.835251 1.493542 0.305236 1.538414 0.647163 0.263422 1.348466 1.037276 0.893701 1.108073 -0.492190 -0.249170 1.081128 0.973414 0.593299 0.786885 0.003725 0.855855 1.605169 1.050037 0.831705 1.193285 0.128148 0.709803)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.642364501953 #r(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

	8.383514 #r(0.000000 1.185298 0.116042 1.091638 0.092095 0.944947 0.102271 0.915149 1.750053 0.485778 1.383200 0.211530 0.862686 1.607558 0.338543 1.220252 1.822776 0.384578 0.842174 1.479065 0.101864 0.525001 0.798322 0.852215 1.596297 0.205674 0.038735 0.440702 1.266574 1.519994 1.627453 -0.116698 0.274743 -0.092846 0.414048 0.680894 0.850034 0.611891 0.773865 0.799723 0.948168 0.795050 0.386289 0.687156 0.139254 0.239355 0.431827 1.449182 1.225677 1.018884 0.815038 0.231330 0.044514 0.056652 1.511296 0.700931 0.111889 -0.266780 1.539396 0.924047 0.245892 -0.239038 1.134806 0.447706 -0.314739 1.073421 0.342294 1.686009 0.291079 -0.242099 1.241743)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.880306243896 #r(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.366430 #r(0.000000 1.529157 0.709835 0.191619 0.777505 1.673931 1.052039 1.157229 0.197845 1.188203 0.205209 0.808312 1.907251 0.734102 1.471024 1.752009 0.976735 0.215092 1.669497 0.039070 0.308185 0.805661 0.414650 0.685942 0.933087 1.104471 0.869537 0.010581 1.431457 1.039490 0.654718 0.051163 1.637896 0.041328 0.434461 1.596916 0.630066 0.513683 1.126090 1.472280 0.029687 0.729904 0.900726 0.364456 0.829387 0.775767 0.087943 1.122617 0.054278 0.980310 0.814649 1.331669 0.404897 1.438813 0.751132 1.069103 1.033498 0.950755 0.588560 0.206118 0.697556 1.364322 0.007771 0.225318 -0.029948 1.266843 1.008881 -0.515131 0.251545 0.235634 0.009431 1.881826)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.907942771912 #r(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.514653 #r(0.000000 1.403201 0.376583 -0.053235 1.209136 1.524715 0.146380 -0.261365 0.834173 1.272975 1.772227 0.023615 0.314599 1.515420 0.115615 0.532763 0.813612 1.148749 0.624829 1.610666 0.428301 0.533410 1.364035 0.688805 -0.345103 -0.033075 0.031988 1.294508 1.610808 0.200563 1.512417 1.458407 0.018985 0.336604 -0.051222 0.346655 1.033154 0.703796 1.103730 1.139661 0.592095 0.478459 0.370549 0.620498 -0.386452 0.468708 0.040902 1.488975 0.539537 0.999795 0.347372 0.354446 0.387241 1.176009 1.306213 0.778993 0.280166 0.010910 0.034863 0.320352 1.620759 0.391262 0.863014 -0.075789 1.338588 1.092040 0.260638 1.463660 0.169121 0.826134 0.241084 1.728130 -0.116721)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
(vector 74 11.262331896     #r(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.487915 #r(0.000000 0.229202 0.328610 0.886519 0.913243 -0.092303 1.469261 1.392280 0.102684 0.875868 1.119399 -0.375546 1.138609 1.792722 0.270873 0.158504 1.300583 0.337402 0.457798 0.994721 0.720190 1.266403 1.157785 0.204200 0.832717 1.368187 -0.207911 0.551921 0.143469 0.767289 -0.041673 0.248888 0.686134 1.808117 1.719833 1.634354 -0.372228 1.923379 1.132948 1.667043 0.857041 1.387145 0.637791 -0.326159 0.280564 1.478231 0.572776 0.063470 1.115045 1.234238 1.093760 0.166042 1.189669 0.933614 0.159392 1.594960 1.079073 1.251388 1.747471 1.137640 1.343339 1.096317 0.655141 0.037576 1.286106 -0.396608 1.310863 1.072774 0.013655 0.220749 -0.215382 0.087335 1.489739 0.952386)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.942812919617 #r(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.620700 #r(0.000000 0.323248 0.317594 0.968808 0.994561 -0.104573 1.389992 1.355213 0.030411 0.985652 1.052974 -0.337840 1.125354 1.829155 0.220921 0.163351 1.380268 0.348537 0.468289 0.962643 0.656934 1.260196 1.184202 0.082746 0.792199 1.382268 -0.060133 0.610903 0.048226 0.758166 0.111389 0.445353 0.626919 1.823766 1.919332 1.584236 -0.359706 1.902296 1.227860 1.813879 0.850492 1.501670 0.807199 -0.423864 0.375418 1.410233 0.564183 -0.023510 1.218078 1.230705 1.078769 0.189372 1.076681 0.977493 0.096444 1.695019 1.093760 1.247664 1.799255 1.288227 1.524084 1.110414 0.566556 -0.036346 1.348516 -0.372587 1.315425 1.037394 0.060664 0.095602 -0.073853 0.261074 1.444286 1.030300 -0.139619)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
(vector 76 11.21743106842 #r(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.651279 #r(0.000000 0.173353 0.839453 0.789458 1.213196 0.485342 1.020793 1.079117 1.510944 0.872759 1.658963 0.469539 1.282086 0.224500 1.187595 1.001928 0.601189 0.457802 1.523606 0.013310 0.486526 1.038767 0.887428 0.818932 0.429987 0.518887 0.949464 1.376735 0.275451 0.805159 0.132159 1.431344 0.575428 0.009721 1.711880 1.360202 0.416637 0.859810 0.491831 0.882963 0.253397 0.012929 1.530000 0.177927 1.883242 1.959160 0.357646 1.604277 0.939839 1.031583 0.502599 0.924357 -0.060587 1.148550 0.762073 0.585290 1.515308 1.022656 0.505967 0.958132 1.937796 0.289650 0.388753 1.349929 0.430727 1.688517 1.350532 0.156971 0.890960 0.708951 1.606885 1.582622 1.628222 1.565608 0.127771 0.825769)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.192246437073 #r(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.707019 #r(0.000000 1.733898 1.602888 1.700625 0.951967 1.205480 0.494785 0.079322 1.861432 1.411332 0.615577 0.456043 0.176616 0.522662 0.530871 0.948923 1.312747 1.035434 -0.217439 1.260792 0.366350 -0.233439 0.849314 1.174459 -0.193276 1.451248 0.290403 1.453670 0.668542 0.644436 1.306523 1.198202 0.657361 0.888118 1.964614 0.824349 -1.765380 0.784141 0.143386 -0.053030 0.033585 0.726269 -0.055055 0.121221 1.064245 1.578078 0.715470 -0.211778 1.194974 -0.095151 0.313319 0.914111 -0.007802 0.154723 0.086177 1.895682 1.191957 -0.344176 -0.285803 0.072705 0.944928 0.649978 0.107843 0.251480 -0.267013 1.016287 0.107966 1.055797 1.067984 1.857635 0.230948 0.492625 0.104053 0.572353 1.732176 0.353482 0.821975)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.455265310659 #r(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.715270 #r(0.000000 1.669247 0.757594 0.165819 0.288294 0.684770 0.557521 0.680526 1.097350 0.470057 1.849497 1.090608 0.922922 1.129049 0.104794 -0.129005 0.326960 -0.051784 1.142568 0.483331 0.896117 0.813482 0.302867 0.073158 -0.168821 0.656167 0.700004 1.004810 -0.007423 -0.189996 0.560929 0.412734 0.830296 1.110767 -0.043008 0.613326 0.576197 0.610404 1.233787 0.583712 0.887457 1.853983 1.162911 1.497407 0.204463 1.117898 1.731543 1.711291 0.816677 1.207698 1.691953 0.214296 -0.046452 0.692536 0.108168 0.208702 0.459557 1.630550 -0.229002 1.446147 1.208030 -0.028606 1.708585 1.336818 1.004606 0.393864 1.182948 -0.208442 1.255124 0.056920 1.572769 0.643674 1.170025 0.291140 1.025254 0.562266 0.633856 0.124004)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.54291004024 #r(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     8.864559 #r(0.000000 0.357256 0.036759 1.292339 -1.618603 1.176406 0.544736 0.398074 0.109043 0.617241 0.697903 1.118083 1.422870 1.215951 0.004362 1.621202 0.264308 0.010496 1.213090 1.597753 -0.054911 1.223572 0.202448 0.615339 0.757193 0.130847 1.245098 1.256256 1.117774 0.701640 1.170787 1.057213 -0.087146 1.024522 1.105914 1.493238 0.672326 0.950638 -0.158430 0.266150 1.329043 0.773121 1.527296 -0.078973 1.669452 1.490229 0.141063 1.057903 0.727028 1.146281 0.010335 0.602841 1.428986 1.325796 1.320411 -0.094534 0.491229 0.443206 1.223761 0.317919 0.333487 -0.004296 1.074159 1.511918 1.245758 0.213171 1.140531 1.245789 0.552067 1.083032 0.600490 0.777304 0.106919 1.336123 1.060329 1.059212 0.289692 1.668881 1.086200)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.122416496277 #r(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.870144 #r(0.000000 0.655710 0.591720 1.625031 0.418269 1.346736 0.349691 1.735905 1.181438 1.185938 0.537355 1.048431 0.310338 0.725392 0.138830 -0.162626 -0.012235 1.033480 1.181949 0.616925 1.912794 0.918753 0.626238 0.223870 0.664522 -0.078088 0.256973 1.394811 0.721353 1.350998 0.870615 0.111718 1.175636 1.041732 -0.087582 0.658928 1.024480 -0.106481 0.957206 0.153547 0.343423 1.369668 0.634606 0.765343 -0.148776 0.328436 0.827668 1.133483 1.461950 0.929478 0.348570 1.212214 0.446866 0.848436 0.219387 1.773456 1.168998 0.793903 0.614230 1.089360 1.446367 1.640320 0.120507 0.926616 0.816912 0.468029 0.525200 0.868913 1.510302 1.541893 -0.030330 0.055242 0.070867 0.042035 1.687456 0.144651 -0.241563 0.096801 -0.095086 0.917714)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
(vector 81 11.372210502625 #r(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.926326 #r(0.000000 0.164735 -0.380225 0.081555 1.097918 1.524480 0.077656 0.977304 0.407700 0.831319 0.533822 0.615403 1.642513 -0.058036 0.444751 1.446330 0.995710 0.841112 0.528746 0.832226 0.248085 0.502898 1.190162 0.745146 -0.208212 0.492995 1.110378 0.980131 0.817203 1.338834 1.000001 1.336192 1.804389 0.900670 0.555661 1.748659 0.603816 0.728857 -0.167279 1.058563 1.176033 1.277029 1.122180 1.127499 -0.224172 0.316000 1.080199 0.508511 0.252234 0.338999 0.400496 1.857653 0.607017 0.245631 0.807136 -0.037588 -0.063570 1.552479 1.126540 0.180335 0.976685 0.410774 1.244176 1.541645 1.450598 0.050542 0.208414 1.102430 0.959489 0.189328 0.354550 1.724776 1.384943 0.545643 1.965929 0.479461 0.756949 1.038515 -0.004640 1.477899 0.906680)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.662058134504 #r(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     8.895498 #r(0.000000 1.650756 0.929235 0.669074 0.458613 1.575883 1.406092 1.106790 0.596730 0.021347 1.134970 0.616933 1.701827 0.504785 1.614982 1.519418 0.470952 1.289129 0.059550 0.427695 0.231422 1.559220 0.383709 0.161407 0.068209 -0.031038 1.865998 -0.109083 1.124535 0.249567 0.520329 0.463755 1.759816 0.122747 -0.063135 1.879507 0.089457 0.845717 1.061947 -0.248630 -0.240924 0.207853 1.548893 0.621489 0.599673 1.031885 -0.104736 1.726398 0.898686 0.128558 0.928155 1.723232 0.730130 1.329452 0.779285 1.207734 0.370523 1.269134 1.812531 0.562255 0.696469 1.440871 0.214062 1.838981 0.082605 1.605017 1.504365 0.122097 0.273097 0.895327 0.555120 -0.358045 0.959494 0.864915 1.049696 1.458692 1.063317 -0.105762 0.240946 0.516137 0.295184 -0.035654)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.732900669843 #r(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.060733 #r(0.000000 0.847614 1.074595 0.345210 0.202371 1.511917 1.112425 0.572830 1.582187 0.218687 0.979697 0.829284 0.504832 0.409321 1.581223 1.031036 0.666780 1.347208 1.680503 1.486577 0.618089 -0.256946 0.905019 0.230952 0.059969 -0.145434 0.545921 0.384376 1.384380 0.665205 1.583895 0.055621 1.669433 1.386960 1.917214 0.552314 1.477586 0.229404 -0.049820 0.210015 -0.192839 1.819422 0.656731 1.258726 0.062676 0.649682 -0.033937 1.076469 0.763030 0.654748 1.032680 0.850557 0.101236 1.303860 1.683735 0.917766 1.133625 0.788918 0.091033 0.752267 0.650807 0.661591 0.956487 -0.151184 1.699725 0.067039 0.562858 0.669739 1.945082 0.507537 0.168655 1.291963 1.367257 0.073343 1.018407 0.584241 1.284655 0.733315 0.794277 0.838058 0.819351 1.776021 0.236189)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.626023292542 #r(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.133456 #r(0.000000 1.059401 0.031287 0.939386 -0.017860 0.901644 0.001799 1.027990 0.230681 1.311963 0.341928 1.644077 0.966811 0.236475 1.300649 0.692497 -0.027953 1.347389 0.723063 -0.003313 1.322772 0.582050 0.159545 1.703814 1.026586 0.555590 -0.158337 1.444034 1.321735 1.003900 0.274358 -0.325622 1.927342 1.457207 1.230507 0.919830 0.720469 0.244803 0.085297 0.173845 -0.048361 0.080359 1.671325 0.039907 1.736091 1.631912 1.486133 1.471880 1.784848 1.922823 0.107240 -0.103436 0.280519 -0.025774 0.700275 0.720167 1.157653 1.036798 1.295565 1.717341 0.156191 0.724169 1.042098 1.172208 1.529978 -0.089227 0.426393 0.952547 1.692201 0.117254 0.809203 1.354853 1.694705 0.278490 0.926144 0.035100 0.434956 1.402186 0.356337 0.912787 0.017302 1.021860 1.401595 0.333844)
     
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.829360154975 #r(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.172932 #r(0.000000 1.198268 -0.046093 0.496651 0.155499 0.438914 1.717129 -0.153996 0.255959 0.942459 -0.112043 1.664994 1.597976 1.071752 0.293731 1.489898 -0.088206 1.402767 1.814932 1.099748 -0.400724 1.351064 1.265640 1.075629 0.060651 -0.371046 0.814537 0.326687 0.633977 1.654428 1.582553 0.618025 1.054016 1.391986 1.098803 0.284271 1.476963 1.042434 1.922088 0.305413 -0.626240 1.791879 1.777727 0.678099 1.505684 1.182071 0.629820 1.357783 0.665420 0.341784 0.926591 0.193623 1.006880 1.192651 -0.116178 0.080172 1.591790 1.522361 0.438822 1.766471 0.395503 1.446548 -0.046614 0.961931 0.316539 0.616763 1.087859 0.290761 0.142685 0.155135 0.508154 0.686168 1.471184 1.165229 0.372220 0.294409 0.404832 -1.767095 1.243980 0.993281 1.007462 0.784244 1.104711 1.671816 0.086342)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
(vector 86 12.140432277993 #r(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.213343 #r(0.000000 0.676268 0.369198 1.486263 -0.026625 0.678855 0.928889 1.200870 0.763422 0.131815 -0.064018 0.334478 0.754549 0.549209 0.781916 -0.164085 1.831169 -0.359871 0.452632 0.395640 1.217523 1.666783 1.263104 0.462675 0.487261 1.713262 0.419400 0.982422 0.818648 0.009279 0.749148 0.986045 1.410580 0.251205 1.543152 0.685375 0.249458 0.699138 0.175620 0.312944 1.884362 1.099441 1.640835 1.728596 -0.397229 1.509431 0.364317 1.073248 1.571193 0.690550 1.201949 -0.104903 0.984182 0.850373 -0.106842 1.582861 -0.052279 0.837387 1.423896 1.118738 -0.077783 0.539913 1.394923 -0.009295 1.541216 0.438460 0.217352 0.527395 0.855264 0.357004 0.424674 0.870332 0.435096 0.770273 0.096843 1.702425 0.991351 1.315154 1.133850 0.440564 0.044541 0.788769 0.138246 -0.080948 1.096067 0.575869)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.32737905
(vector 87 11.937030388359 #r(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

	9.317037 #r(0.000000 1.269780 0.764198 1.382169 0.560101 1.397366 0.619615 1.110127 1.074742 0.786154 0.097129 0.187903 1.280480 1.001234 0.625991 -0.253578 0.524611 0.642531 0.754319 1.395067 1.865340 0.173765 1.213561 0.413784 0.704706 0.640451 1.483492 1.299442 0.783307 0.912207 0.977809 1.588075 -0.173310 1.063721 0.534821 0.450809 0.251070 0.792950 1.489833 1.745329 1.098607 0.960633 0.682333 0.343541 0.677820 0.343804 -0.007548 0.114569 1.083276 0.044826 0.931689 1.109596 -0.582840 1.287598 0.295851 -0.261696 1.183896 0.581304 -0.088958 1.623439 0.434479 0.025514 0.230711 1.672013 0.717129 1.395826 0.682208 -0.299168 -0.096350 -0.604219 1.679467 0.411395 0.711815 1.234251 0.324421 0.995113 0.167630 0.383406 0.968742 0.310771 0.425004 0.820195 0.922682 1.343873 0.606017 -0.248788 1.112139)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
(vector 88 12.128922775356 #r(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.324023 #r(0.000000 0.720070 1.146170 1.623229 0.919914 1.475051 1.669418 0.417706 1.222880 1.077800 0.636671 0.109954 0.709268 0.401961 1.342317 0.470950 1.038199 -0.014165 -0.223115 1.401527 0.255061 -0.053613 1.038430 1.524899 0.900064 0.540757 0.958685 1.268571 0.665381 1.798791 1.658869 0.625852 0.519615 0.589311 -0.003435 1.345809 -0.056260 0.616788 0.290786 1.478184 0.854964 0.750706 1.853143 1.837616 0.068009 0.196260 1.496079 0.820255 1.744388 0.146057 0.230788 1.434358 -0.205448 1.616936 0.981163 0.921532 1.591565 1.188825 -0.476209 1.518808 0.443241 0.115647 0.334751 1.367563 0.160132 1.179927 1.012776 0.498582 1.276116 0.704338 1.396987 -0.001804 0.959954 1.167324 1.287070 1.914346 1.400505 1.413492 1.484414 -0.463663 0.122173 0.488918 -0.038072 1.041389 -0.101511 -0.067115 1.661217 1.643428)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.362 #r(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.331615 #r(0.000000 0.049094 0.763150 0.136548 0.483778 0.759076 0.333224 1.220929 0.134557 0.764345 0.615745 -0.054859 0.470862 1.549452 1.042755 0.304443 0.281140 1.178803 1.496311 1.304814 1.254180 1.214938 -0.188361 1.642263 1.456263 1.200682 1.159330 0.518402 1.259168 1.450349 0.156876 1.423052 0.526144 0.557187 0.211944 1.876505 0.927439 -0.029530 0.421763 1.206664 0.690297 1.789526 1.067082 0.003086 0.897179 1.065326 1.434687 0.576391 -0.150316 1.287422 1.126966 1.259277 1.431443 0.305104 0.343134 0.824875 1.068860 1.722713 1.668311 0.909968 1.314221 0.346498 0.614998 0.306500 1.059400 1.495807 -0.733779 1.277563 0.627585 1.184462 -0.276841 0.360604 0.535684 -0.101891 0.124422 1.197248 0.778353 1.945787 1.307086 0.922575 0.921600 0.870062 1.105219 1.606237 0.868032 -0.120196 0.316193 -0.191814 0.432808)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.309 #r(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.421684 #r(0.000000 0.773463 -0.034237 0.815187 0.818292 -0.048506 -0.025177 1.145716 1.124687 -0.087471 0.982715 1.911529 0.885016 -0.169554 0.478422 0.410159 1.012688 0.169228 0.764485 0.758910 1.289872 0.618276 -0.229660 1.549110 0.758331 0.279930 1.553579 0.672439 0.162166 0.690601 0.847281 1.562839 1.023152 1.146052 1.063766 0.943600 -0.316637 0.816595 1.430319 0.223152 0.862408 0.935019 0.764642 0.942440 1.888157 1.614273 1.641359 1.139335 1.700104 1.516977 1.001915 0.698936 0.890613 1.412580 1.482707 0.374132 0.486389 0.409585 0.664613 0.728056 0.135717 1.017586 1.427256 0.114262 0.459920 0.985474 0.828118 0.029864 1.115880 0.182529 0.074455 0.121011 1.384155 1.498024 1.812648 0.488592 0.254186 1.880026 1.059948 0.152702 0.760476 0.236696 1.396118 1.492214 0.743805 1.035917 1.060796 0.484826 0.509085 -0.305704)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.351367950439 #r(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.456608 #r(0.000000 0.103422 0.965610 0.946880 1.775735 -0.122619 1.034051 0.168472 0.730448 0.272671 0.778481 0.021689 0.033093 0.984786 1.059637 0.145824 1.327186 1.317989 0.064861 1.738590 0.743092 0.115729 -0.009073 0.235258 1.253963 0.597261 1.473274 1.451939 1.654969 1.556762 -0.031925 0.584248 1.188923 1.752060 0.699420 0.272619 1.021928 1.546707 1.001394 0.687724 1.015815 0.834084 -0.085438 1.600278 0.991105 1.336531 1.547902 0.640465 0.462581 1.062100 1.213310 0.321259 0.291622 0.063730 0.566090 0.852786 0.847201 -0.174185 1.395263 1.222072 0.870150 0.708746 0.513822 0.978903 0.739358 1.760219 0.991895 1.423353 0.493188 0.952658 -0.084183 1.857020 1.060335 -0.192588 0.702407 1.144217 1.162221 1.656319 1.357097 0.810997 -0.196628 1.185541 1.692605 1.048778 1.191279 0.597890 1.575870 0.403387 0.283378 0.378021 0.172627)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5916630
(vector 92 12.280749613899 #r(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.552661 #r(0.000000 1.217977 1.385618 0.939614 0.500483 1.851006 0.319542 1.708679 0.556310 0.891376 0.674923 0.365733 -0.175465 0.892985 1.540146 0.973262 0.317469 1.925159 0.685389 1.371188 0.200154 1.709968 0.177693 -0.300538 0.695154 0.829261 0.826887 0.518213 1.033752 1.220316 0.472703 1.153927 1.069740 0.054639 0.285291 1.692400 0.723359 -0.010143 1.422901 0.759732 0.421539 1.178988 0.292771 1.282542 0.969261 0.723210 1.587532 1.451565 0.985309 0.576854 0.032105 1.279589 0.637040 0.836814 1.053214 1.607968 0.083343 0.618958 1.664826 -0.072056 0.366474 1.110340 1.463534 0.789016 1.455017 1.061490 0.999534 0.659448 0.541265 1.191626 1.594463 0.899514 1.279707 0.844186 0.855539 -0.116804 0.909316 1.750334 1.598414 1.853269 0.368452 0.535158 0.818452 1.438032 0.503813 0.301666 0.154109 0.506999 0.079492 -0.057406 1.894913 0.600742)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.403578299298 #r(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.628761 #r(0.000000 1.192712 1.317592 0.793671 0.099933 -0.070495 0.916675 1.443504 0.876536 1.333886 0.502339 0.879490 0.963974 1.813405 1.616449 1.406560 0.249623 1.099165 1.684130 0.971324 1.504790 0.210004 -0.334645 1.442259 0.574758 1.021850 0.284510 0.399479 0.184247 1.487488 1.612401 -0.235561 -0.129797 0.178650 -0.371978 0.920412 -0.107159 0.561074 0.178586 0.184745 -0.019738 0.790773 0.250122 1.738768 1.375989 -0.216295 -0.331946 0.885688 1.988915 0.048056 0.095104 0.757409 -0.209034 0.574534 0.777126 1.337323 -0.015675 1.471677 1.723082 0.373584 0.844517 1.228790 1.358490 1.817661 1.097143 1.261125 0.949204 1.719884 0.720744 1.257519 0.078221 -0.091904 0.999562 0.486340 0.282135 0.639284 -0.163690 1.618168 0.349231 0.088441 0.985965 0.932832 1.613134 0.712978 1.300533 1.211114 1.605834 1.719815 0.768198 -0.076989 1.468170 1.231822 0.852206)
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.789479876738 #r(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.653914 #r(0.000000 1.588712 0.970594 0.765681 0.768893 0.708013 1.088997 0.348116 1.304828 0.302466 0.484457 0.598101 1.195823 1.750495 0.723696 -0.394564 1.399290 0.440079 0.957225 0.110914 1.178680 -1.746723 0.306178 1.424281 0.083938 -0.026412 0.531864 1.282735 0.186630 0.411663 1.537740 0.224065 -0.422374 0.338118 1.366092 0.348038 0.469097 0.358167 1.178154 1.072296 0.953715 0.778556 0.718707 0.831159 0.966980 0.639988 0.294231 -0.156503 1.325326 0.192979 0.424804 0.332961 0.198719 0.405180 1.172779 0.251315 0.565156 0.903572 0.754645 0.195819 1.584153 1.274227 0.370217 1.346701 0.041617 1.218979 0.515044 1.085194 0.964032 1.907141 0.492814 1.684100 -0.290159 1.467461 0.104316 0.280575 0.761449 1.432721 1.137691 0.132533 1.823280 1.230711 -0.052109 1.493267 1.265211 0.071008 1.206644 0.630379 0.639830 0.932228 -0.085525 1.738146 1.623323 0.751204)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.575266058635 #r(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.716924 #r(0.000000 1.295576 0.051583 -0.370221 1.659103 1.560139 0.883258 1.136184 1.446082 0.336165 0.984827 1.426922 1.840974 1.223315 0.635432 0.990680 0.332450 0.247993 0.361771 1.193162 0.200656 1.699397 1.071493 0.299430 0.743325 0.167398 0.140913 0.844624 1.382714 1.375685 0.647006 0.229451 0.386840 1.780080 0.889230 1.061105 0.116922 0.567648 1.435830 1.255231 0.833620 1.820993 1.158323 0.868650 0.833531 0.419654 1.734245 1.273400 1.062531 1.460253 0.175543 0.639252 0.712611 1.085237 0.872288 1.639660 -0.093743 0.087045 -0.323684 1.687923 1.002234 -0.168363 1.044853 -0.114093 1.195353 -0.026012 0.883764 1.512322 0.102179 0.114077 1.256119 1.084835 0.251990 0.992344 0.663746 0.903707 0.809231 1.141845 1.353235 1.559958 0.119755 1.444404 1.912417 1.220976 -0.164602 -0.295612 1.393445 0.425402 1.426929 1.201811 0.614353 -0.027563 1.025805 1.054465 0.134046)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.803173065186 #r(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.759447 #r(0.000000 0.435576 1.538976 0.230825 0.102821 0.263319 0.997316 0.091618 0.472323 -0.103132 0.585027 1.906149 0.670612 1.002137 1.281685 0.083578 0.271396 0.433634 0.733402 0.099534 0.807149 -0.070119 0.575530 -0.103613 0.335070 1.262648 1.473382 0.330894 0.589593 0.216256 0.350636 1.350446 1.836442 1.560161 1.205882 0.649393 0.812682 0.141066 1.111869 -0.141497 1.693969 1.777393 0.080165 0.375196 0.449681 -0.067423 0.754077 0.868345 1.797143 0.793576 0.568117 0.646818 1.350309 1.187659 1.791215 0.862642 1.742949 1.213798 0.583814 0.650546 0.965237 1.015772 0.605956 0.144297 0.285298 -0.351085 1.282066 0.474001 0.642725 0.511289 1.457452 0.929763 1.241810 0.227521 0.228779 1.199150 1.811444 -0.006366 0.744946 0.179491 1.361847 -0.378016 1.423650 1.452225 1.393417 1.335482 0.037183 1.548694 0.890495 0.461455 1.744132 0.896894 0.307836 1.812808 0.221251 0.928513)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.837450993031 #r(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.832277 #r(0.000000 0.379259 1.470054 0.135241 -0.137798 1.476571 0.223942 1.269139 1.617761 0.578479 1.659896 0.192321 0.628723 1.030748 0.068332 0.935772 0.702035 -0.308246 0.093619 0.687832 0.312122 0.952725 0.646784 0.815901 0.600402 0.700649 0.257079 0.728929 1.512814 0.133748 -0.161439 1.667289 1.756964 0.419090 1.460039 1.221568 0.216587 0.357346 0.560096 0.621329 1.423958 -0.140419 -0.285305 1.752977 0.296245 1.796763 0.502171 1.837539 -0.068388 -0.176521 1.655407 0.652714 1.571976 1.231728 0.781936 1.899698 1.696905 1.070324 0.093931 0.071079 0.376824 0.772939 1.099059 0.004831 0.221806 1.727680 0.800189 0.011067 0.690398 0.512420 0.475317 0.941280 1.720146 1.587206 0.923080 0.792083 0.180477 -0.133205 1.214230 1.814657 0.679279 0.282075 1.334889 1.751170 1.536951 0.882536 0.418450 0.834681 -0.026902 0.654794 0.680161 1.077779 1.525535 0.824205 1.102618 0.673911 -0.106249)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.972 #r(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     9.918320 #r(0.000000 1.126272 0.810135 -0.157043 -0.284411 1.014546 1.656515 0.886620 0.589412 -0.165849 0.041656 1.689870 -0.133502 1.386309 0.753684 1.607028 0.455527 0.729530 1.603812 -0.176801 0.980471 1.557823 1.120428 0.608500 -0.040856 1.654422 1.694414 1.546900 1.545046 0.721205 0.133219 1.189224 1.204719 1.195353 1.299299 -0.156627 0.826681 -0.088693 0.692437 1.036020 0.358333 1.488711 1.027717 0.069063 1.141577 0.328360 0.719016 0.851669 0.356065 0.712122 1.039551 1.236061 1.577925 0.317909 -0.158255 0.050224 -0.509790 1.519264 0.203085 -0.063235 0.037529 0.962155 1.059331 0.698574 0.810336 0.743673 1.683751 0.457113 0.419520 0.759860 1.462788 1.502247 0.636526 0.416346 0.963144 1.154048 0.694553 0.104918 -0.349860 1.108892 1.631062 0.589884 1.392769 1.258082 0.568391 0.753256 1.211016 0.009043 0.817095 0.265385 1.455548 1.585953 1.547698 1.855964 1.737942 0.229735 1.055700 1.696455)

     ;; pp:
     9.852643 #r(0.000000 0.515219 1.262972 1.697020 0.335436 0.889905 1.519089 0.044736 0.650497 1.270750 -0.178917 0.674989 1.450432 0.254900 1.097572 -0.107043 0.651195 1.335130 0.272796 1.297874 0.224159 0.962708 0.053062 1.193382 0.101327 0.836439 -0.105754 1.215012 0.128574 1.109391 0.442046 1.523411 0.553345 1.725474 0.541762 -0.127793 1.417975 0.631717 1.576620 0.767281 0.059112 1.609436 1.033347 0.556109 1.727081 1.010442 0.702568 -0.141336 1.349027 0.669399 0.583528 0.147350 1.497924 0.934945 0.610721 0.101044 -0.019997 1.772284 1.165297 0.883648 0.540756 0.695909 0.051843 0.036770 1.823953 1.940217 1.253231 1.381574 1.135330 0.962885 1.084109 1.188033 1.135270 0.827723 0.748628 1.126276 1.272339 0.770370 1.246808 1.223016 1.570254 1.399310 1.628085 1.829166 -0.154940 0.353005 0.721669 0.726808 0.892330 1.197955 1.533013 0.212675 0.669097 1.140181 1.156217 1.790457 0.422623 0.510791)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.000000000002 #r(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     9.927757 #r(0.000000 0.612324 0.079141 1.434202 1.000660 0.891242 1.012263 -0.017562 0.996629 0.611063 1.321217 1.621637 1.504948 1.624898 0.001412 0.412734 0.326019 1.366721 1.072960 0.116515 0.715979 -0.740444 1.161301 1.297736 1.041757 0.027020 1.458453 1.107119 0.363908 1.415543 1.763457 0.255777 0.686434 -0.085735 0.651473 1.217063 -0.047283 1.151992 0.790695 -0.152103 1.647917 0.508714 0.628648 1.408143 1.292464 0.474000 1.003650 0.520847 0.629804 0.218082 0.785490 -0.232867 0.391411 1.172299 0.273141 1.313231 0.427739 0.013232 0.516032 0.610598 1.282766 1.029342 0.967918 1.073490 0.454858 0.915907 0.522595 0.274119 0.827376 0.861574 -0.158909 -0.432703 1.871750 1.122982 0.647824 -0.195710 0.262542 1.053968 0.565099 0.024117 0.401586 0.264805 1.587960 -0.370184 1.152346 1.774247 0.242656 0.316777 1.195086 1.067518 1.112347 0.688842 1.446613 0.608318 1.321142 -0.167020 0.907334 1.022140 1.062351)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
(vector 100 13.117680368039 #r(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      9.967820 #r(0.000000 1.016486 1.075466 0.675161 0.574401 1.527303 0.369311 1.093743 1.758162 0.649535 1.329616 0.683289 -0.464743 0.488528 0.846167 1.093202 0.188464 -0.009742 1.328398 -0.092736 0.866724 1.306141 0.236206 -0.048398 0.065984 1.250377 0.880265 0.529903 1.908284 0.909975 0.870318 1.170730 0.401807 0.051428 1.546047 -0.084383 1.553645 1.723234 -0.192262 -0.005451 0.846559 1.396413 0.793410 1.734419 0.268618 0.782362 0.300041 0.085963 0.406528 -0.058412 0.759019 0.311738 0.688186 1.163736 0.207596 0.957152 0.518038 -0.238894 1.966069 0.254028 0.497859 0.406362 0.948142 0.108565 0.809242 0.618274 0.008503 1.224166 0.619792 -0.063172 1.170177 1.631095 0.360399 0.496092 1.173684 1.571576 1.461266 0.250954 0.485376 0.293914 0.241987 0.266855 1.299097 1.747740 -0.157940 1.025403 0.055859 0.443647 -0.030039 1.366811 0.369467 1.523632 1.262832 1.148761 0.265795 -0.397124 0.678718 0.978216 1.111928 1.121642)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.28250751675 #r(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      9.964634 #r(0.000000 -0.073111 1.535769 -0.102555 0.949824 0.661791 1.376397 0.389320 1.429271 1.382915 0.702074 0.190023 0.165010 0.880936 1.053717 0.381858 1.515003 1.204543 0.504035 0.920455 0.391206 0.949414 1.113429 0.554900 1.897469 1.768789 1.766679 1.550589 0.402518 0.254763 0.394916 1.625563 0.833640 0.744524 0.452145 -0.082936 0.892795 1.873582 1.781184 -0.418454 1.636196 -0.022737 0.903335 -0.412208 1.924024 0.194797 -0.087158 0.651748 1.188278 0.341571 0.583987 1.814760 1.207941 1.789448 0.551284 0.991618 0.259118 0.282624 1.011184 1.611901 1.372798 1.012968 0.839711 1.331909 1.264042 0.325794 0.343316 -0.075857 -0.460634 0.488689 1.512646 1.806638 1.012723 -0.303497 1.575625 0.027198 0.002241 1.290806 1.657896 1.438044 0.654010 1.150362 0.652919 1.476118 -0.053999 -0.024155 0.726437 0.454484 1.497660 0.765182 0.287065 1.425963 0.079052 0.750136 1.836142 1.337567 -0.185862 1.924720 -0.153672 0.400041 1.450120)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.159336831147 #r(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.045766 #r(0.000000 -0.279070 0.173878 0.081403 1.768938 1.607495 0.603256 0.555897 0.375867 1.098499 0.557935 1.658062 0.679353 0.435605 1.704584 0.882188 0.675710 1.226519 -0.017413 0.221732 -0.211376 1.307302 0.689909 0.655783 0.993058 0.615004 1.764502 1.131327 0.119482 0.185094 1.035751 1.439320 1.373211 1.418236 0.503946 0.310742 0.195150 1.345393 1.645648 0.392993 0.050135 0.685592 0.243679 0.754096 0.965418 1.162001 1.767714 0.912263 1.540226 0.989163 0.153496 1.180193 0.495181 0.826820 -0.194339 1.268780 1.482827 -0.154668 1.003093 0.057371 1.563631 1.606126 0.908893 1.017810 0.439667 -0.174146 0.280275 0.399111 1.342959 -0.098826 1.087834 1.050762 0.557805 0.752893 -0.400427 0.095731 0.689016 0.552247 0.778927 0.058727 0.428406 0.269116 0.480708 0.192361 0.563638 0.686642 0.128600 1.864221 -0.045520 1.018032 1.780635 -0.005046 0.881801 1.021244 0.513775 1.482476 0.956890 0.518235 1.186738 -0.018819 1.609204 0.515712)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.142812158651 #r(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.102476 #r(0.000000 1.369258 0.406430 1.487363 1.300312 1.174178 0.725871 1.118946 0.567934 1.507074 1.421940 0.060397 1.553534 0.366960 0.264364 -0.027869 1.681923 0.350717 1.364154 0.204515 -0.180262 0.842363 0.287472 1.198426 1.756374 1.259211 0.898266 0.187309 0.401610 0.535873 0.048012 0.851696 1.323060 0.925186 0.678890 0.097118 1.570744 0.545725 0.858166 1.853728 0.291531 1.096726 1.166849 -0.045402 1.179837 -0.111020 0.643454 0.486562 1.084325 0.673411 1.808268 0.331853 0.761303 0.506929 0.948787 0.125433 1.093138 1.172704 1.300823 -0.087765 1.061422 -0.231489 1.345595 1.007175 0.463207 0.567128 0.417701 0.867458 1.827132 1.618306 -0.235698 1.268358 1.413906 0.291274 -0.510359 1.287040 0.555326 0.694591 1.555786 1.225983 1.844314 0.908000 0.867329 0.232081 1.454227 0.972019 1.069240 0.133107 0.915878 0.821231 0.471133 1.434428 0.215881 0.667043 0.772841 0.944850 1.153588 0.551253 0.882554 1.134378 0.032596 -0.042233 1.758816)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.176067352295 #r(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.168550 #r(0.000000 0.863337 -0.113966 0.952335 1.179324 1.344589 0.086001 1.784568 0.040939 -0.278342 0.492392 1.373041 1.589416 0.305140 1.040154 0.306852 0.639739 1.605433 -0.082316 1.171614 0.018705 0.877480 0.742834 1.013469 -0.394587 0.679538 1.685340 1.015860 0.451982 1.273683 0.656961 1.380347 0.930414 0.629931 0.875751 1.106458 0.854029 1.097615 0.942886 1.634232 -0.087153 1.214976 0.912099 1.026106 0.377766 0.938615 0.980356 0.179306 0.223817 1.145177 1.622990 0.100820 0.989970 1.826246 0.934306 0.310115 -0.012658 0.179983 -0.026220 0.755024 0.027968 0.662514 0.819461 1.633236 1.403644 1.156857 1.356308 1.542286 1.253871 1.012715 0.852908 0.924116 0.022097 0.368327 -0.090612 1.052696 -0.034185 0.655336 -0.097080 -0.157717 1.261805 0.337757 0.457703 1.158886 1.296591 0.128958 1.630443 0.809473 0.920747 1.393423 0.696288 0.328360 1.336354 1.510499 1.486152 1.947494 0.779240 0.349685 0.612445 1.433252 1.461547 0.826387 0.679858 -0.337976)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.491228801467 #r(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.115828 #r(0.000000 0.049019 1.344835 1.091641 0.665700 0.968893 0.648602 0.707898 1.514354 1.538919 0.526334 1.493761 1.624995 0.707437 0.593803 0.874212 1.543010 1.853745 0.426397 0.026573 1.615940 1.506593 0.465693 1.159200 -0.404908 1.664358 0.782410 1.352302 -0.234654 1.360029 1.390064 0.562127 0.900595 -0.305834 1.198378 1.369945 1.005775 0.397773 0.628843 1.626964 0.837449 1.061154 1.446306 1.380391 1.599960 0.270806 1.328543 -0.187842 -0.215850 0.275407 1.674813 1.481684 0.685411 -0.076514 1.172112 0.021028 -0.282040 0.805083 0.169438 0.519532 1.238467 0.912197 -0.108203 0.770912 1.223603 1.260598 0.243317 1.416653 -0.085803 1.793597 1.018898 0.209596 0.637018 0.680644 1.218601 -0.251927 1.342315 0.794662 0.530948 1.151958 0.965018 0.768542 0.003792 0.487969 1.528116 0.185132 1.582165 0.376426 0.269883 0.979543 1.678175 1.757906 1.492507 0.386900 1.219606 0.328787 1.292795 -0.100060 0.401454 0.164930 0.339091 0.226350 0.418706 -0.115549 1.296351)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.091135978699 #r(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.198335 #r(0.000000 0.831679 1.059524 0.595983 0.203261 1.202829 1.655547 1.163399 0.731912 1.050991 -0.085268 1.049064 0.669107 0.707558 1.587356 0.103456 0.095032 1.177165 1.677580 0.458849 0.488238 1.294418 -0.328225 1.742764 0.960376 0.232688 1.221102 1.139466 1.165521 0.274312 -0.217213 1.769983 -0.106435 0.980799 0.424668 1.120797 1.738923 1.408831 0.326124 1.349134 0.307375 0.275240 0.392410 1.221176 0.352509 0.866366 0.344959 0.656333 0.909394 0.940268 0.976614 0.141881 0.684412 0.786921 -0.062121 -0.010568 1.690036 -0.088688 1.427313 -0.052874 1.785355 0.109989 0.958795 1.179624 0.324837 1.229886 1.616903 1.768092 1.318950 1.675999 1.563712 0.225381 0.575251 0.774252 -0.022742 1.783220 1.405786 0.332796 1.613495 1.352845 1.308309 0.373980 1.918112 1.162561 0.910064 1.737277 1.152808 -0.033675 0.058425 1.406045 -0.253836 0.991335 1.479963 0.005130 1.832773 0.614974 0.073456 1.352269 1.161897 0.192184 0.857686 0.091488 0.263380 1.392944 0.202339 1.603064)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.537808159641 #r(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.295953 #r(0.000000 1.453513 1.655211 0.102988 0.785431 1.249929 -0.025066 1.750838 0.347673 1.604380 1.551092 0.115495 1.639861 1.667898 0.228709 1.701673 0.201321 1.045139 -0.312647 0.175688 0.855996 0.160415 1.472612 0.763114 0.800624 0.361142 1.295288 0.490786 -0.039842 -0.032740 0.339591 1.592008 0.669279 0.117545 -0.109117 1.018536 0.901071 0.716433 0.346971 1.020475 -0.173945 0.889314 0.077058 1.765220 1.318363 1.591641 1.626283 0.012132 1.508938 0.471426 0.670071 1.171727 0.339306 0.138717 0.336161 0.439088 1.260263 -0.187548 0.396198 0.258209 0.100455 1.039650 0.818140 1.958400 1.117502 0.697124 1.567939 -0.332396 0.783424 1.205431 0.709006 -0.344647 0.483889 0.499549 -0.063258 0.695169 0.972581 0.387305 1.779513 -0.022586 1.856190 0.369348 0.297097 0.538965 0.115827 0.894957 1.816307 1.006210 1.611567 -0.212466 -0.136556 0.733243 0.881259 0.131239 1.843996 -0.064517 1.632049 0.217595 1.203085 0.867259 0.064249 0.691138 1.782204 1.811114 1.580857 1.070340 1.558270)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
(vector 108 13.472808406168 #r(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.325467 #r(0.000000 1.823999 0.121670 1.358801 0.589768 1.029967 -0.433790 1.041582 -1.274122 0.780646 -0.169734 1.604597 1.010159 1.810789 0.632723 -0.206688 0.463178 1.073646 1.521165 -0.178712 1.523791 0.423100 0.144424 0.899019 -0.452142 0.547962 0.895764 1.662227 0.346193 1.471302 -0.164671 -1.901696 0.406602 0.262326 0.474119 -0.030228 1.801622 1.325384 1.588387 0.343116 0.445611 0.273212 0.831258 1.871029 -0.312461 1.896993 1.025139 0.721577 0.726171 0.338346 0.861017 1.378901 0.847116 0.469202 -0.383235 0.452023 -0.496006 1.102062 1.102044 1.646809 0.311243 -0.456688 0.949926 0.520943 0.921326 0.643117 0.781598 1.182150 0.966506 0.456713 0.498859 1.075971 1.927079 0.160322 0.159648 0.419881 0.925743 0.446322 0.326978 1.459788 0.903977 -0.021458 1.063237 1.175806 1.223175 0.258595 0.623246 1.572004 0.621332 1.978290 1.546402 1.672410 0.423727 1.205710 1.436589 0.182917 0.251425 0.718333 -1.375705 0.497395 0.186440 0.550196 0.272118 1.380692 1.012574 0.305814 1.433937 0.098087)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
(vector 109 13.798 #r(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.413972 #r(0.000000 -0.329332 1.852441 0.301192 0.479205 1.938689 1.086891 1.271023 0.729396 1.367900 1.483662 1.203078 1.940935 0.158023 0.999249 1.513297 0.973974 0.871966 0.600005 0.917499 0.064963 1.625056 1.204390 0.450307 0.459827 1.379619 0.277893 0.390957 1.292297 1.095127 0.941246 0.509853 0.476400 1.479425 1.214972 0.999425 1.144172 0.402758 1.277806 -1.541834 1.224224 0.408937 -0.140267 1.012505 1.167342 0.593542 1.500901 0.801861 0.428256 0.363108 1.278773 0.897271 1.754344 0.238279 0.787476 1.405582 1.439989 1.293816 1.237720 0.491493 1.514000 1.092355 0.055457 1.477338 0.699004 0.040279 0.957508 1.786210 0.481649 0.726028 0.215740 0.216870 1.343437 -0.395385 1.669265 -0.047054 1.724398 0.984510 0.441756 -0.012720 0.257871 1.485641 -0.121426 0.687863 0.835502 1.004805 1.663485 0.780698 1.042433 1.097029 1.089236 1.689246 1.096756 0.293532 0.899560 -0.005695 0.471699 1.241990 1.396400 -0.542444 0.294633 1.091314 0.356171 0.908370 0.648337 1.936350 -0.128643 0.053871 0.188853)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.576010454591 #r(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.408073 #r(0.000000 1.583299 1.129147 0.924363 0.405386 0.106463 0.654471 1.235816 1.676675 1.424024 -0.320821 -0.106137 1.651584 1.223458 1.376470 0.070578 0.035561 0.618393 1.591071 1.247092 1.420738 1.407145 1.068993 1.180774 1.368120 -0.309458 -0.227815 -0.257077 0.341569 0.189699 1.898096 1.209271 -0.362341 0.480813 1.176223 1.497789 1.567432 0.970389 -0.047452 0.764481 1.364232 1.546603 0.838685 0.519999 0.785088 1.840526 0.201375 0.694162 0.995107 0.138310 0.417265 -0.004223 1.430441 0.548174 0.456155 0.879102 0.021026 0.612402 1.448544 1.143273 1.475463 0.804075 0.821149 0.175404 1.164546 0.079156 1.149637 1.448505 1.656091 1.757415 0.521205 0.257194 1.707629 0.482292 1.377093 0.507438 0.991226 -0.612661 0.868064 0.306724 0.414844 0.138628 0.061298 1.129023 1.487975 0.706799 -0.099480 1.383589 0.290834 1.123787 -0.072238 0.982011 0.038233 1.760058 0.405531 0.016972 -0.604791 1.005236 1.670267 -0.215358 1.779967 0.879139 0.413047 1.290874 0.860692 0.804540 1.190191 0.135277 0.110128 0.732322)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.709900383304 #r(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.588903 #r(0.000000 0.083293 0.444830 -0.213766 0.524915 -0.005956 1.175907 0.783294 -0.343790 -0.015069 1.676924 0.021997 -0.012805 1.023472 0.864450 1.922773 1.431731 1.374839 1.561767 1.633583 0.198147 0.245727 1.910466 0.995751 0.091514 1.666123 0.750477 1.953152 1.512135 0.025831 0.969938 0.804619 0.507564 0.688555 -0.027332 1.433090 0.812479 0.893934 1.245019 0.835304 0.404414 0.839838 0.338429 -0.112731 0.636982 0.099621 1.080987 1.292673 0.177317 1.292327 1.284755 0.253860 0.748555 1.591323 1.605479 0.445460 1.332537 -0.181589 1.668331 0.627699 0.074537 0.208177 0.135644 0.846946 0.614940 0.479986 0.443281 0.299879 1.767930 1.411021 -0.391645 0.057816 1.376551 1.471560 -0.203049 0.453124 0.061036 0.704839 1.379390 1.848624 0.771131 -0.036797 0.007834 1.611881 1.733830 0.412751 1.415257 0.544650 1.539165 0.414455 1.242586 0.195280 0.522916 0.859907 1.238816 -0.090313 -0.027707 -0.025034 0.375248 1.748950 1.440534 1.222909 0.018270 -0.118073 0.275708 1.112569 0.089742 1.167857 1.617530 0.755934 0.450427)

      ;; pp:
      10.417134 #r(0.000000 0.334233 1.073081 1.649039 0.219597 0.888802 1.379829 0.088335 0.555458 1.328032 1.801862 0.615319 1.429043 0.326004 0.993452 1.804613 0.545160 1.317910 1.885616 0.678140 1.509274 0.323491 1.236504 0.282786 1.199970 0.195704 1.232493 0.160017 0.897560 -0.082586 1.086392 0.182366 1.277299 0.339072 1.485948 0.630905 1.802953 0.832621 -0.132126 1.110982 0.486291 1.681037 0.774846 -0.032051 1.638442 0.870514 -0.093334 1.333411 0.747525 0.167590 1.347374 0.845491 0.233833 1.720211 1.112373 0.655737 0.273424 1.815808 1.225426 0.609827 0.164644 -0.241753 1.556306 1.087036 0.843899 0.560878 -0.058558 1.838311 1.465620 1.239758 1.091378 0.528065 0.791149 0.332440 0.584210 0.055836 0.449981 1.753070 0.093654 1.657239 1.503059 1.399887 1.433488 1.544146 1.513188 1.637379 1.822882 1.796041 1.687813 1.720729 1.754274 -0.098151 -0.072877 0.197474 0.504171 0.827563 1.033490 1.323144 1.356797 1.748728 -0.150347 0.352269 0.632744 0.932570 1.684081 0.187586 0.495859 1.035344 1.327590 1.648341 0.358056)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.92684841156 #r(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      ;; 10.58293147
	10.582025 #r(0.000000 0.311823 0.137469 0.765085 0.247252 0.880370 1.452735 0.240993 1.506478 0.780197 1.183194 1.086565 0.032933 1.780577 0.281098 0.764676 0.712557 1.579682 1.277796 1.238223 1.014207 -0.140323 1.716730 1.644672 1.253593 0.578221 0.527661 0.367318 1.131386 1.012757 0.285059 0.010509 0.097401 1.699590 0.802620 1.600737 0.550167 1.026747 0.562219 0.378187 0.150437 0.522055 0.022316 1.717789 0.186746 1.186644 0.914782 0.563095 1.653911 0.869696 0.117700 1.053735 0.935756 -0.055221 0.653101 1.059195 -0.397205 1.469022 0.238158 0.393902 0.410251 0.955768 1.001018 1.337003 0.602349 0.798689 0.307413 -0.479763 0.463243 1.296128 0.608105 0.417995 0.073111 0.291455 0.483686 0.231728 0.630836 1.131231 -0.228753 0.669521 1.185569 -0.089761 1.130815 0.778132 1.502582 1.555252 1.149912 0.577946 0.284522 1.467470 0.172271 0.275044 1.633737 1.228854 0.152388 0.342365 1.574177 0.099351 0.042391 1.025180 1.146998 1.437785 0.647927 1.566576 1.091754 1.532311 1.602420 0.887895 1.387294 0.660060 1.356768 -0.056782)
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
(vector 113 13.825498858186 #r(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.586426 #r(0.000000 0.880973 0.176609 1.175777 0.325354 1.332354 0.320489 -0.071032 0.810398 1.764286 1.047524 1.891121 1.274870 -0.462450 -0.016593 1.802245 -0.046896 0.623724 0.697636 1.104725 0.928560 1.531658 1.767776 1.410783 1.560300 0.841358 1.754992 0.695860 1.109332 0.811865 0.787805 0.897767 0.126996 1.290009 1.439543 1.231735 0.428818 0.217484 1.274411 0.676699 0.491905 0.907831 0.251383 0.502017 0.436195 1.271188 0.390987 0.252204 1.423164 1.333446 1.284283 0.685749 0.387192 1.752967 0.379905 1.873082 0.147356 1.600693 0.620101 0.533661 0.873916 1.687058 0.856213 0.905702 0.279125 1.651302 0.425155 1.158445 0.384556 1.685623 1.738609 0.620191 0.166765 0.760816 0.887704 1.876641 1.612703 0.207434 0.310898 1.383166 0.834523 0.489910 -0.069256 0.030910 0.047326 1.374933 1.678060 0.495762 1.058376 0.337747 0.859288 0.994496 0.384200 0.735993 0.843904 0.381801 0.488130 0.839325 0.731059 1.159772 1.973051 0.569688 1.423018 1.561321 1.485614 0.834971 1.215611 1.015531 -0.080496 -0.203441 0.704520 0.652007 1.385821)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.920305720092 #r(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.620769 #r(0.000000 -0.265733 0.572658 0.316585 0.923883 1.614948 0.728669 0.692865 0.985653 1.596503 0.291068 0.153708 1.761462 0.140269 1.183433 -0.379854 1.503387 1.143776 0.747711 1.619251 0.404594 1.157009 0.378840 0.537946 0.751007 0.739900 0.914353 1.624008 0.450778 0.962869 0.588872 1.869278 0.721483 1.557011 0.902276 0.776013 1.285044 0.345048 1.685952 1.091106 0.263288 1.107778 -0.009439 0.420734 1.806464 1.410193 1.769595 1.251788 0.691963 1.604897 1.666646 1.531003 0.963757 -0.680527 1.705352 1.126307 -0.203837 0.277321 0.178995 1.809866 0.763029 0.031476 0.539819 0.755127 0.685061 1.837935 0.717076 1.848829 1.364997 0.950055 -0.061791 1.853324 0.123916 -0.136693 1.146568 0.362176 0.781284 1.598429 1.120688 1.139170 0.560329 -0.015310 0.331374 1.472918 0.199430 0.303861 1.321918 1.569172 1.548780 -0.090459 1.912266 0.810039 -0.152547 1.372081 1.425080 0.264711 1.614349 0.175290 0.789472 1.260114 1.370945 1.918464 1.489942 1.397616 0.963993 0.516634 0.516943 1.244942 0.283787 1.709141 1.616073 0.810759 1.316742 1.696489)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.20306968689 #r(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.674304 #r(0.000000 0.789887 -0.303859 -0.033056 0.759195 0.636525 0.248364 0.847489 1.259597 0.571635 0.950311 0.503307 0.311625 1.283873 0.845368 0.051963 1.567172 1.288876 0.243542 0.283164 1.566596 0.754789 1.490536 0.039434 0.168217 0.197813 0.961175 1.000724 0.173724 1.453836 -0.299975 0.087165 1.672267 1.098120 1.146505 0.379755 1.328375 0.651767 1.173825 0.650295 0.441141 0.865349 1.257754 -0.111945 0.068441 1.538745 0.068967 1.734610 1.208209 0.079563 -0.236732 0.216584 0.140036 0.340430 0.008574 0.036605 0.315028 0.890542 0.307266 0.065201 -0.267238 -0.016662 1.283003 0.528002 -0.402562 1.186323 0.829551 0.025932 0.882753 0.264357 1.091661 1.076730 -0.001406 0.040934 0.042083 1.567774 0.906679 0.687134 0.720339 0.063372 0.406664 1.457338 1.400253 1.359707 1.217492 0.090043 -0.918052 0.816288 1.443080 -0.046946 0.555663 0.622694 1.800570 0.513267 0.655836 0.746318 1.849833 1.129389 1.637640 0.403829 -0.005965 0.883415 0.100025 0.540813 0.541888 0.996530 1.501665 1.855318 1.257420 0.578586 0.925447 0.264080 0.596871 0.828008 0.353618)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
(vector 116 13.887789451571 #r(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.733274 #r(0.000000 0.476000 1.878001 1.180059 0.831300 1.453614 0.786219 1.052031 1.218138 0.179523 0.743868 1.265853 0.031570 1.636184 -0.152324 0.778296 0.271634 1.469546 0.565495 1.807809 0.217280 0.159382 1.049221 0.170285 0.221763 0.774648 0.398259 0.637279 -0.107284 0.312805 1.776901 0.160502 1.717634 1.119938 1.391025 0.105351 1.023277 1.530674 1.548380 -0.251006 0.488559 1.544222 0.177807 0.661206 0.257716 1.053732 0.893027 1.445098 1.722088 0.002770 1.151812 1.061439 0.110999 0.865286 0.781438 1.277991 0.502793 0.943734 0.798521 1.333645 1.654972 1.679619 0.259243 0.886975 0.069664 1.517348 1.237826 1.551946 0.514540 1.258563 1.258071 1.027685 1.355844 1.909459 1.281504 1.171068 0.250655 1.622642 0.211675 1.522349 -0.092396 0.705855 1.861520 0.183629 0.746566 0.759808 0.250024 -0.159043 1.664858 0.237853 -0.217693 1.217376 1.459590 1.517349 1.206266 0.478670 -0.380779 0.210779 0.338305 1.433407 1.043804 0.854323 0.392836 1.702198 1.439694 -0.141576 1.283279 0.715495 0.734335 1.585749 1.775978 1.654290 -0.315773 0.174327 1.442380 0.993240)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.427604264985 #r(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      10.783290 #r(0.000000 0.108967 0.680440 -0.039849 1.073915 0.982905 0.909467 1.470260 1.730853 0.840580 1.309090 0.612716 1.548112 -0.231227 1.489945 0.841297 1.245447 0.244987 0.849971 -0.022279 0.452974 0.810744 1.489407 1.567278 1.188237 0.772892 0.113419 0.906478 1.169175 -0.156676 0.507744 1.684543 1.686412 1.219650 1.843836 0.541605 0.346082 0.043904 -0.079283 1.469849 1.567795 0.179241 -0.068928 0.912255 0.602511 1.574715 0.695060 1.133392 -0.425958 0.610886 1.496396 0.865636 0.895412 1.362633 1.653811 1.404165 0.041681 1.692317 1.094403 0.739550 1.239428 0.479228 1.439160 0.986149 0.801910 1.514113 0.963332 0.281851 0.106127 1.599308 -0.004925 1.893302 1.411671 1.244923 0.383170 0.517813 0.421067 1.058052 0.153400 0.778671 0.754438 1.880309 0.023746 1.476647 0.081600 1.798573 0.432245 0.735923 0.440628 -0.064421 1.249491 0.136405 1.735439 1.868665 1.565831 0.435031 0.537457 0.904590 1.634892 1.124196 0.408216 0.769901 0.281419 1.398400 0.260352 0.021213 0.275268 0.681889 -0.074136 0.502025 0.237163 1.241676 1.638668 0.242962 0.026823 1.133262 1.452416)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.399567650824 #r(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      10.812235 #r(0.000000 1.507972 1.809575 1.323971 0.671235 0.977919 0.397118 0.294709 0.400614 1.800046 0.492728 1.565979 -0.363038 1.100463 1.075231 0.502016 0.457037 0.406728 0.228418 0.756367 1.513939 0.347068 1.450936 0.868009 1.501709 0.352220 -0.413052 -0.148923 0.240400 1.115439 0.653043 -0.505473 -0.021974 1.853042 0.586305 0.428092 0.050201 0.752546 1.451411 1.228490 1.754283 1.881544 0.485306 1.754300 0.007006 0.163634 0.582385 0.998129 -0.090614 0.952205 1.425714 1.513296 1.570494 -0.259048 0.529336 1.498547 1.326491 -0.594238 1.538496 0.728657 0.444244 1.055319 1.385207 0.874327 0.074427 1.100816 1.734905 0.605814 1.533043 1.017063 0.482871 0.438583 1.108829 1.808956 0.029357 0.297016 -0.063569 0.780909 1.283400 0.359665 -0.032425 1.363808 0.687851 1.190450 1.438414 1.141910 1.126025 1.239471 0.136191 1.489911 1.026641 0.526687 0.890040 -0.022700 0.140687 -0.353757 1.164330 1.005641 0.099661 1.220163 1.081145 1.773078 1.376716 1.458019 0.703593 0.987305 1.493840 1.628605 0.957392 -0.054994 1.652856 0.431213 1.736293 -0.162073 0.279632 -0.110283 1.166212 1.877544)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.464 #r(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

	10.815476 #r(0.000000 1.511627 1.860509 1.251771 0.680390 0.954029 0.497464 0.422082 0.549359 1.789096 0.627036 1.559684 -0.285316 1.102920 1.110972 0.497639 0.358913 0.339963 0.170351 0.820368 1.613321 0.311453 1.667587 0.845824 1.477518 0.323382 -0.462336 -0.121701 0.278431 1.251253 0.730313 -0.512813 0.050332 1.905719 0.581701 0.491221 0.037053 0.850077 1.454447 1.218666 1.827857 1.931466 0.444700 1.716033 0.031317 0.208955 0.719947 1.025308 -0.162952 0.941579 1.416409 1.490055 1.661028 -0.177347 0.601149 1.427738 1.318738 -0.598055 1.513344 0.818145 0.331744 0.938565 1.416971 0.755203 0.134509 1.154206 1.729909 0.622158 1.596632 1.050190 0.348364 0.402844 1.083937 1.814009 0.098380 0.333506 -0.078532 0.814360 1.186888 0.456002 0.118529 1.475204 0.706833 1.153688 1.398936 1.202344 1.140027 1.452557 0.124581 1.538313 1.096684 0.449897 0.816791 -0.073645 0.157032 -0.377184 1.176926 0.948380 0.061745 1.231800 0.991632 1.829471 1.268286 1.394920 0.669763 0.966107 1.360959 1.524586 1.033990 0.094975 1.707832 0.468762 1.695289 -0.249729 0.213611 -0.109788 1.260368 1.791243 -0.325923)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.530112637252 #r(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      10.908578 #r(0.000000 1.631022 1.381443 1.212465 0.280876 1.393291 0.111686 0.270527 0.978937 1.227425 0.890939 1.651369 1.764648 0.695615 1.236913 0.727116 0.698874 1.130809 0.997193 1.306023 0.313921 0.604505 1.499034 1.434773 -0.031959 0.721966 0.805711 1.401787 1.847562 -0.006201 0.484669 -0.092885 0.221199 -0.183123 0.140129 0.993753 0.357992 0.281932 0.966898 0.230227 1.509169 0.180321 0.405315 1.445457 0.491155 0.993111 -0.061813 1.514617 0.638001 0.451798 1.136956 1.109239 0.762301 -0.132886 1.231861 1.405253 0.200172 0.005626 1.367415 0.727395 0.860721 1.277905 0.564602 1.311600 0.590071 0.237783 1.173320 1.731939 0.366179 -0.147635 0.520386 1.741652 0.218116 1.635795 0.602629 0.928717 0.628620 0.437182 1.782199 0.939080 1.479011 0.992710 1.705346 0.225711 0.000961 0.770434 1.683323 1.555459 0.976408 0.318440 0.438208 0.262452 1.689840 0.975712 0.209291 0.727490 0.382719 1.065032 0.672130 0.702874 0.107185 1.755713 1.841965 0.283698 0.562788 -0.058140 0.525625 0.471391 -0.086606 1.741760 0.455380 1.248256 1.359448 0.404279 1.132787 1.054875 0.443335 0.808907 0.713857 0.102341)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
(vector 121 14.355115628334 #r(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

	10.964853 #r(0.000000 0.398403 0.789366 1.639224 0.095384 0.603386 1.413253 -0.024715 0.418890 1.292082 1.611148 0.340631 1.108765 1.695063 0.580930 1.343797 0.280670 0.901558 1.616611 0.471137 1.087682 0.133909 0.906863 1.859279 0.568482 1.631317 0.654611 1.507476 0.361682 1.510922 0.499281 1.470975 0.300411 1.347262 0.617157 1.704177 0.828780 1.880799 1.043180 0.289911 1.416774 0.542005 1.546439 0.900363 0.167177 1.249035 0.407571 1.759267 1.085148 0.584948 1.716513 0.882082 0.508912 1.827501 0.986992 0.387974 1.888925 1.337010 0.836823 0.307293 1.641585 1.441301 0.767423 0.352201 1.694822 1.489433 0.858014 0.699679 0.213088 1.881335 1.746103 0.996170 1.013175 0.481879 0.378821 0.145113 1.583267 1.647206 1.099338 0.993610 1.018212 0.718965 0.851336 0.334482 0.624100 0.047757 0.264635 -0.323610 -0.302771 0.007865 1.748671 1.715799 0.102814 0.097582 0.089500 0.089824 -0.047495 0.097783 0.230671 0.371131 0.395035 0.485871 1.031900 1.248794 1.442726 1.594017 1.850116 0.167236 0.339312 0.429488 0.766566 1.120859 1.686086 0.133797 0.674257 1.033037 1.205258 1.718874 0.166520 0.534447 1.081831)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.266534958875 #r(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

	11.010771 #r(0.000000 1.285362 1.109765 1.769522 1.118511 0.025809 1.380894 -0.023810 -0.040154 0.477589 1.538986 0.261754 1.175104 0.132069 1.284014 1.937597 1.377797 1.405930 1.758393 1.282889 1.486625 -0.056321 1.528467 0.214498 1.235960 0.342086 0.501436 1.266150 1.154766 0.072612 1.295064 1.657622 1.389498 0.272462 0.259989 -0.421623 0.539671 -0.109400 1.457518 0.782406 0.238503 1.568707 0.742855 0.582523 1.544996 0.568221 1.469856 -0.013151 1.702120 1.738232 0.495569 1.623452 0.280213 1.398587 0.655444 -0.357815 -0.175614 -0.641353 0.853648 0.913786 0.039735 0.805399 0.987536 1.353101 0.200447 1.531233 0.925738 1.853509 -0.339223 0.575217 0.991404 0.868567 0.980697 0.661437 0.825668 0.642114 1.923343 0.222086 1.058889 0.329972 0.424129 1.343097 -0.325621 0.616372 0.777895 1.290746 0.563995 1.114886 -0.032692 0.303925 0.022515 1.568213 1.005956 0.993523 0.945016 1.316628 1.600265 0.004312 0.404044 0.508968 1.509703 1.266589 -0.292614 0.449335 0.327309 -0.027947 0.095691 -0.305771 -0.038174 1.851423 0.567671 0.373102 0.032065 1.664572 1.263320 0.558380 0.899406 0.824927 1.437277 1.639347 0.806318 0.739271)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.795100232697 #r(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

	11.087851 #r(0.000000 0.624121 0.261315 1.181018 0.329816 0.723473 -0.058557 1.121126 0.418750 -0.560184 0.201221 -0.009188 0.964547 0.675383 0.540517 1.692402 0.238659 0.271713 0.649234 1.358679 -0.523949 0.096515 1.070752 0.415974 1.194076 0.398537 0.119705 1.390687 1.865110 0.657711 0.628353 0.094042 -0.039698 0.818092 0.264925 1.627819 0.564214 1.707948 1.323380 0.532853 1.528599 0.040464 0.169356 1.020624 1.633435 0.566927 0.135046 0.139973 1.154314 0.011466 -0.490861 0.640253 0.477507 1.036610 0.601286 0.864853 1.673244 0.103614 0.490773 0.239735 1.004984 0.751604 0.598287 0.049449 -0.383209 0.952738 0.587827 1.358167 1.134886 0.996730 1.062079 1.715631 0.870675 -0.669782 1.719322 1.286177 0.181430 1.375280 1.727572 0.723568 0.180864 0.793875 1.229108 1.479462 0.352987 0.476172 0.647844 0.506675 0.826807 0.037970 0.147029 -0.376170 -0.079080 -0.448861 -0.361893 0.784673 0.253239 1.081508 0.018537 1.194702 1.598635 -0.278698 1.403864 0.071060 0.431595 1.221066 1.608714 0.689332 0.715718 0.497216 1.832187 1.548074 1.325487 -0.697479 1.412701 -0.064789 1.545460 1.865863 0.574246 1.018052 0.826593 0.850894 0.538141)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.82254124518 #r(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

      11.120334 #r(0.000000 0.836933 0.196277 0.584882 0.301240 1.853484 1.324094 0.689541 0.969365 0.207127 0.815576 1.493174 1.646002 1.091372 1.338767 0.007260 0.223249 1.375996 0.396818 0.809290 0.595471 0.291935 0.828280 1.079040 -0.045835 0.055676 0.687157 1.387372 0.387604 1.113048 0.635795 -0.184152 0.086995 0.683755 -0.523880 0.957683 0.004250 0.887892 -0.247566 0.473338 0.863028 1.537875 1.279363 1.883742 -0.079415 1.606587 1.410357 1.815201 1.258365 -0.140836 0.062288 -0.117723 0.136197 0.025366 0.240444 0.337975 0.245314 1.565210 1.190385 0.061707 1.059358 1.066927 -0.243845 -0.140470 0.080704 -0.220916 0.436644 1.755266 1.123977 1.300903 1.292668 0.127266 0.478120 0.197515 0.674823 1.740766 0.286316 1.346417 -0.000673 0.759878 1.360448 0.328373 -0.116210 1.391350 1.022226 1.179474 0.838754 0.041237 0.614743 0.475843 0.203018 1.724933 1.421322 0.133569 1.485945 -0.070709 -0.071535 1.023240 0.511154 0.013014 1.379753 0.972914 1.226974 1.882336 0.135006 1.035934 -0.225880 1.034246 0.410768 0.390305 1.143196 1.223233 0.144114 1.611032 0.509896 1.218446 0.494123 -0.071045 0.511805 0.489583 0.116710 1.542243 0.745207 0.200411)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.82163143158 #r(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.122080 #r(0.000000 0.847003 0.165605 0.564848 0.227076 1.866949 1.345525 0.694388 0.959809 0.220564 0.772501 1.602410 1.604719 1.034958 1.311625 0.093909 0.283228 1.337145 0.377730 0.845137 0.466461 0.350583 0.723543 1.140286 -0.106738 0.112805 0.654453 1.405583 0.488341 1.115481 0.791692 -0.180702 0.024701 0.675117 -0.401907 0.966930 1.823188 0.970009 -0.163692 0.487827 0.774136 1.664048 1.147399 1.934923 -0.055579 1.590906 1.404741 1.937024 1.297324 -0.074406 0.012276 -0.101828 0.157087 0.049344 0.227099 0.402796 0.390545 1.452083 1.063131 0.134397 1.038993 1.058234 -0.172834 -0.157850 -0.051398 -0.166122 0.368524 1.765197 1.164117 1.233067 1.255917 0.100656 0.389203 0.162934 0.701475 1.871318 0.234658 1.379710 -0.022077 0.663615 1.352469 0.392445 -0.083922 1.307168 0.973714 1.219169 0.823481 0.152576 0.585169 0.393119 0.296805 1.754607 1.427512 0.110549 1.353534 -0.062637 0.005406 0.988733 0.551978 -0.032302 1.396422 1.051496 1.232496 1.873765 0.104448 1.090614 -0.186610 1.107217 0.405013 0.371843 1.166939 1.223105 0.199359 1.547104 0.541567 1.118832 0.462118 -0.111041 0.497800 0.551619 0.175381 1.513543 0.771791 0.282381 0.491699)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
(vector 126 14.961482935205 #r(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

	11.217157 #r(0.000000 1.333463 1.865492 -0.356718 0.933752 -0.563391 0.868454 1.227379 1.262853 1.734302 0.789925 0.887286 1.032388 0.794621 1.230657 -0.133505 -0.396357 0.347068 1.645124 0.776662 -0.030992 0.148253 0.191160 1.597265 0.105283 0.900423 1.230893 1.571345 0.370052 -0.251197 0.174670 0.404122 -0.082381 0.889967 -0.215160 -0.008260 -0.099660 1.159763 0.889422 1.423884 0.871705 1.850409 0.087109 1.706676 0.622672 0.936165 1.688780 1.528677 0.346829 0.012071 -0.088550 -0.030577 -0.043782 -0.058951 0.933603 1.070465 1.475594 1.531127 0.991234 0.010808 0.356054 0.157103 0.451907 -0.030459 -0.024818 0.523063 -0.129422 0.815521 1.075724 0.055269 0.750932 1.244054 1.306512 0.899391 -0.257291 1.664054 0.588171 1.065503 1.219153 1.371075 1.522174 0.737588 1.228742 1.773501 0.629941 0.387629 0.029457 1.398967 0.393091 1.680074 1.275817 0.905734 0.977246 -0.221887 1.339886 1.268897 1.260526 0.645165 1.510347 1.465708 0.394415 0.283387 1.630537 1.623821 0.888008 0.433073 0.790823 0.410278 1.398034 -0.237262 0.505122 -0.149516 0.721213 -0.202493 0.454561 1.014466 0.552452 1.112325 -1.848818 1.758603 1.154778 1.507049 0.724439 0.691362 -0.014103 1.227764)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
(vector 127 14.695912364919 #r(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

	11.267676 #r(0.000000 0.469645 0.796786 0.361018 -0.201613 1.310280 0.989111 0.525386 1.353693 0.378912 -0.241786 1.383164 1.533963 0.433890 0.325960 -0.352400 0.296358 0.481541 1.224829 0.787501 0.393768 1.211089 1.363561 0.247670 0.870376 1.154368 0.308126 1.041640 0.835212 1.804302 0.606799 0.022246 1.619342 1.154695 0.087857 0.758989 -0.028398 1.810844 1.763099 -0.171773 1.163226 0.592499 1.004685 0.695738 1.351120 0.977805 1.234286 1.609466 1.168845 1.598062 -0.321012 0.375057 0.817093 1.176853 0.878725 0.404937 0.672879 0.953648 1.504900 1.779440 0.534644 1.065489 -0.364994 1.703967 1.257601 -0.285618 0.908588 1.590737 1.087624 0.949190 1.204116 1.100315 0.879186 1.728483 1.796612 1.248626 1.298091 0.553842 1.379947 1.414383 0.591234 -0.228889 0.158060 -0.027394 0.157851 1.486700 0.372769 1.034786 0.707926 1.165159 0.328389 0.640197 0.421469 0.024384 1.129354 0.412245 0.531741 0.551732 0.008170 1.397227 1.653335 0.820170 0.216962 1.538735 0.975199 1.704359 0.157705 -0.426269 0.813101 0.999429 0.880927 1.743457 1.627725 0.094175 0.211869 0.002839 0.900464 1.204980 1.320644 1.281147 0.386967 0.783858 1.096686 0.213553 1.120859 -0.145308 0.996884)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
(vector 128 14.876242756695 #r(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.261196 #r(0.000000 0.166552 0.658187 0.892812 0.275075 0.681304 0.935134 0.976324 1.751013 1.223679 0.531374 0.670158 0.738172 0.131342 0.784571 -0.001918 0.261947 -0.271711 1.074675 0.180917 0.495904 1.378525 0.720362 0.537440 1.116473 -0.311806 0.462073 0.021129 0.764859 1.361657 1.645691 -0.164691 0.135735 1.576068 0.824450 0.335134 1.099359 0.719625 0.791638 0.999013 0.348593 0.103014 1.062792 0.739933 1.675943 0.488371 0.860700 0.759566 1.276788 -0.135237 0.780818 -0.165115 1.024663 -0.327864 0.608127 1.454969 0.958609 0.555060 1.331156 0.762777 0.625297 1.411237 1.470303 1.190821 0.207444 0.108639 1.023133 1.165243 1.464221 1.564262 0.616076 0.019451 0.729986 0.402652 0.078552 0.454134 0.152695 0.263463 0.361958 1.475980 0.276689 1.365673 0.254488 -0.143709 1.946127 0.309551 1.760348 1.294342 0.981564 0.863637 1.477654 -0.019128 0.751338 0.878849 0.050601 0.063334 1.353561 1.669390 1.451518 0.535767 0.012898 0.428045 -0.011136 0.975409 -0.201088 0.677802 0.866124 0.188482 0.625213 1.342113 1.315837 0.879874 0.445664 1.081775 0.978490 1.662778 0.529736 1.946523 1.542905 0.571344 1.054205 0.430980 0.402697 -0.095096 1.487261 1.198691 1.754313 1.700742)
      )

;;; 256 odd --------------------------------------------------------------------------------
(vector 256 22.546259712247 #r(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
	16.241887 #r(0.000000 0.457219 1.688101 -0.135724 1.554266 -0.611806 1.706899 -0.197397 1.655126 0.532021 0.168553 0.134322 1.658709 1.698544 0.767995 1.300386 0.073269 0.475934 0.595275 -0.159913 0.941546 0.141273 1.436037 1.643970 0.711350 1.661907 0.291119 0.495601 0.570023 -0.057863 0.007497 0.822527 1.955243 1.409512 1.633743 1.331312 1.269211 1.838078 -0.015311 0.034998 1.407787 1.077588 0.770725 0.926391 0.963487 0.879252 1.198148 -0.016124 1.070856 0.984500 0.082453 1.234638 1.834160 0.078431 0.150972 0.057949 -0.028809 1.642879 0.117122 0.510541 0.034690 1.251227 1.664897 0.635870 0.070261 0.252065 0.252447 1.243132 1.718301 0.230524 1.055591 0.623808 0.595028 -0.061739 0.470933 0.539801 0.748257 -0.039695 -0.016919 0.905862 1.782941 -0.270379 0.445737 1.471729 -0.121549 1.506821 0.579023 0.191001 0.032149 0.975023 0.330489 0.131953 1.717060 0.284091 1.732860 0.118520 0.190527 0.489012 1.627624 -0.023309 1.166056 1.293683 1.460156 1.612969 0.194937 0.253102 1.346608 -0.079335 0.129752 0.912709 0.964827 0.883993 1.258487 1.387671 1.647606 0.234856 1.661996 1.842178 1.318183 1.712866 0.621203 1.394390 1.013386 1.476668 0.620387 1.078600 0.543320 0.889221 0.042114 1.358612 1.559872 1.622178 0.592549 0.750458 0.236653 0.814104 1.916106 1.676974 0.730010 1.806593 0.444422 0.264083 0.233265 1.381973 1.334263 1.785958 1.277285 1.184921 0.148608 0.418518 1.473180 1.408973 1.201304 1.868991 1.020965 -0.044821 1.106526 1.674918 0.209372 0.159106 1.598521 0.573512 1.356702 1.081909 0.555382 1.714122 1.238061 0.073588 0.929367 0.307124 1.159278 0.654772 0.302911 0.270314 1.371298 0.573786 1.872452 -0.136149 -0.424576 1.529496 0.873949 0.638125 0.623156 1.895723 0.953475 -0.038340 -0.106234 0.731443 0.356868 -0.380663 0.758234 -0.047360 1.158482 0.023731 0.669253 0.142832 0.538104 0.716402 1.182689 -0.502058 0.201669 0.444026 1.264715 1.460630 1.185463 0.464574 0.067429 0.428940 1.842620 1.203090 1.175884 1.834725 0.345260 1.007660 0.147199 0.944308 1.468959 0.825334 1.577504 1.393002 0.742406 0.956214 0.748483 -0.502843 0.745588 1.595379 0.625211 0.030533 -0.140368 -0.043613 1.501549 0.452579 0.784497 1.767678 1.022420 1.014426 0.068396 0.706827 1.141140 1.199908 0.437007 1.570287 1.588931 -0.149100 0.464974 1.258616 1.170102 1.709945 1.838256 1.903011 1.603603 0.690235 0.208979 -0.173392 0.732931 0.636225)
      )

;;; 512 odd --------------------------------------------------------------------------------
(vector 512 35.541 #r(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      ;; from (try-all :odd 512 513 0.0057812032540294  1.0142361702487) = 28.7291 start for next
	23.515902 #r(0.000000 1.400623 0.707698 -0.021146 1.302024 0.608149 -0.057471 1.272153 0.672536 0.041805 1.435569 0.832639 0.177350 1.557740 0.888978 0.266497 1.602407 0.995258 0.361513 1.769278 1.196560 0.583616 0.012645 1.382538 0.761557 0.181770 1.606836 1.039411 0.478759 1.924023 1.369389 0.792884 0.177820 1.630239 1.034678 0.477725 -0.081057 1.417516 0.885954 0.383344 1.898602 1.356891 0.854090 0.315084 1.804468 1.269353 0.710724 0.227408 1.715852 1.221461 0.726563 0.232455 1.743921 1.234011 0.736198 0.276156 1.814011 1.361455 0.933226 0.499533 0.035227 1.601270 1.146366 0.713235 0.242327 1.746883 1.282446 0.811249 0.404760 -0.002718 1.637731 1.231010 0.776517 0.376340 1.954245 1.571918 1.178235 0.773150 0.324821 1.916864 1.548382 1.221923 0.852241 0.479624 0.082593 1.706562 1.374596 1.023279 0.640453 0.266696 -0.019762 1.657409 1.298084 0.935749 0.560508 0.228111 1.913453 1.628711 1.359161 1.043838 0.693794 0.369375 0.092274 1.780684 1.475052 1.145333 0.888094 0.655368 0.411675 0.097128 1.827235 1.545512 1.257577 0.982331 0.720585 0.482829 0.225408 1.959502 1.715865 1.465889 1.222797 0.974775 0.750542 0.570029 0.355748 0.111540 1.879052 1.697744 1.523608 1.305162 1.053531 0.874130 0.721068 0.490522 0.291180 0.169764 -0.007756 1.715295 1.554259 1.481444 1.311705 1.111089 0.985497 0.842324 0.630078 0.516856 0.428781 0.279772 0.117097 -0.064259 1.761418 1.624959 1.529391 1.468189 1.396110 1.303962 1.118879 1.013736 0.975519 0.904314 0.751193 0.669547 0.594851 0.513293 0.429501 0.352413 0.315301 0.237006 0.161937 0.079370 0.028488 -0.026402 1.908077 1.946827 1.965296 1.852570 1.823823 1.817486 1.767239 1.741997 1.747290 1.740397 1.689745 1.676800 1.698396 1.684007 1.694857 1.708195 1.715055 1.701013 1.734063 1.774632 1.788203 1.871615 1.912445 1.909843 -0.052119 0.030795 0.096067 0.117399 0.179387 0.206048 0.260433 0.359250 0.438147 0.511399 0.598449 0.719193 0.777281 0.813651 0.905364 1.044066 1.184791 1.270196 1.335591 1.425261 1.553039 1.687589 1.802744 1.951710 0.085725 0.233622 0.419731 0.516530 0.609152 0.814932 0.975070 1.151827 1.267821 1.411973 1.594155 1.787518 1.941932 0.107944 0.265291 0.475642 0.665690 0.867495 1.050632 1.261964 1.452546 1.718477 1.916955 0.139709 0.313681 0.580142 0.773418 1.044975 1.198158 1.544237 1.715890 0.013619 0.195393 0.521626 0.674111 0.987265 1.190299 1.508602 1.763719 0.096223 0.340338 0.625154 0.947993 1.201063 1.476077 1.717036 0.074486 0.318596 0.724314 0.993467 1.376868 1.627805 0.002199 0.251179 0.634062 0.947739 1.298407 1.633451 1.931299 0.364882 0.637074 1.074404 1.334698 1.711393 0.080678 0.432903 0.848119 1.207340 1.599186 0.086614 0.382265 0.874288 1.089655 1.614150 1.958345 0.422657 0.807576 1.175403 1.623831 -0.036342 0.508327 0.864305 1.388756 1.719892 0.229676 0.618537 1.093681 1.517028 0.016132 0.445756 0.956961 1.395188 1.808915 0.309902 0.729179 1.350999 1.755305 0.317618 0.680173 1.239998 1.717339 0.276743 0.772522 1.317416 1.716264 0.281530 0.804351 1.302294 1.940180 0.395824 0.939511 1.470068 -0.017572 0.542294 1.165684 1.595652 0.341471 0.701666 1.381363 1.955847 0.496325 1.083553 1.760771 0.170952 0.815156 1.474090 -0.013089 0.586503 1.246915 1.765144 0.350293 1.010255 1.662523 0.229166 0.942183 1.596173 0.140756 0.833416 1.416234 0.088121 0.711419 1.380950 0.020045 0.671267 1.333461 -0.044485 0.663882 1.411199 -0.003441 0.665306 1.416535 -0.002821 0.771454 1.444827 0.150263 0.919221 1.590599 0.225087 0.991474 1.644544 0.370727 1.110610 1.832866 0.675392 1.325751 0.126754 0.818563 1.616669 0.319684 1.046989 1.789082 0.551634 1.421227 0.050204 0.902961 1.688738 0.376489 1.237501 1.953673 0.752120 1.584805 0.368717 1.195566 0.000646 0.867087 1.547644 0.474969 1.239119 0.121706 0.813115 1.784454 0.540626 1.436268 0.191584 1.126010 1.878883 0.785009 1.563303 0.460511 1.345419 0.195054 1.042185 -0.001701 0.851435 1.728041 0.620144 1.518945 0.444967 1.234276 0.154684 1.069844 0.047560 0.842754 1.776825 0.729397 1.724377 0.564394 1.538615 0.465807 1.422925 0.275988 1.294515 0.255706 1.096656 0.101089 1.051261 0.042441 0.979389 1.899934 0.978766 1.946682 0.997829 1.873810 0.865544 1.885628 0.918026 1.901413 0.946877 1.869761 0.922699 1.871083 0.889115 1.914947 0.925807 -0.030945 1.003700 0.040869 1.034406 0.137621 1.211490 0.265573 1.315492 0.417647 1.411183 0.445158 1.532648 0.593102 1.712825 0.789474 1.900397 0.946468 0.009195 1.130494 0.248166 1.323336 0.382063 1.519789 0.588138 1.759211 0.891685 0.041566 1.143030 0.278602 1.405902 0.519170 1.664071 0.803596 0.009782 1.138808 0.330096 1.446674 0.659714 1.772235 1.036113 0.209242 1.325978 0.545375 1.776344 0.996276 0.277701 1.474973 0.746274)
      )

;;; 1024 odd --------------------------------------------------------------------------------
(vector 1024 52.508 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       ;; pp:
	33.724753 #r(0.000000 1.370354 0.672387 1.979704 1.258450 0.548570 1.839269 1.188269 0.488303 1.797859 1.173673 0.467366 1.823740 1.129216 0.466142 1.760671 1.094772 0.462318 1.784602 1.091526 0.430029 1.789446 1.141171 0.479249 1.851555 1.176525 0.575513 1.898711 1.263092 0.625233 1.945213 1.339834 0.721388 0.084134 1.460588 0.787817 0.154990 1.505772 0.909135 0.274017 1.674454 1.076988 0.410243 1.832855 1.233041 0.563639 1.933340 1.342009 0.756672 0.157110 1.565033 0.993181 0.388114 1.759491 1.192631 0.591761 1.969247 1.407015 0.799820 0.211894 1.646599 1.023775 0.448187 1.876510 1.293775 0.711807 0.125044 1.607580 1.042818 0.436703 1.873056 1.277560 0.709049 0.179647 1.600754 1.061355 0.517755 1.945715 1.354617 0.848174 0.277641 1.751212 1.204040 0.650197 0.110384 1.590503 1.084178 0.539948 1.985897 1.478673 0.897285 0.369622 1.803650 1.284631 0.786017 0.260824 1.768180 1.215383 0.740872 0.254057 1.713666 1.237785 0.717093 0.183791 1.681917 1.141915 0.653312 0.167625 1.711811 1.195428 0.676642 0.182189 1.672838 1.198692 0.722404 0.266287 1.794423 1.318252 0.812719 0.285365 1.826981 1.390852 0.900484 0.436172 1.957452 1.485425 1.030268 0.592659 0.146818 1.705890 1.236175 0.730288 0.307385 1.848950 1.422528 0.987043 0.510236 0.069732 1.632765 1.185336 0.778477 0.347094 1.894559 1.473905 1.039744 0.576730 0.149918 1.722008 1.303821 0.881612 0.464951 0.038326 1.637863 1.197814 0.791118 0.378827 1.988385 1.560304 1.162102 0.781423 0.408348 1.968662 1.557460 1.169999 0.771550 0.371166 0.019011 1.597566 1.240348 0.856325 0.460796 0.085976 1.706466 1.299784 0.928413 0.558063 0.241150 1.872490 1.464404 1.047744 0.703873 0.380807 0.030578 1.664440 1.251219 0.883438 0.562060 0.226839 1.851633 1.451781 1.133639 0.877433 0.528738 0.180344 1.835781 1.457573 1.119785 0.807365 0.491519 0.162847 1.828449 1.463765 1.156410 0.823819 0.521017 0.229115 1.887003 1.569882 1.259842 0.969161 0.645348 0.339451 0.027019 1.710370 1.429907 1.130215 0.831779 0.549474 0.261906 1.963518 1.648178 1.335518 1.069183 0.811137 0.495001 0.206515 1.906338 1.630953 1.352593 1.104305 0.826288 0.579915 0.297384 0.027979 1.771381 1.509897 1.249328 0.964633 0.714528 0.452050 0.215647 1.944151 1.679977 1.456377 1.244497 0.966159 0.699538 0.465484 0.217261 1.945097 1.738354 1.545696 1.306621 1.027941 0.796951 0.610178 0.391678 0.168945 1.932972 1.696987 1.494155 1.291924 1.067849 0.838609 0.634005 0.427381 0.230306 0.030032 1.796538 1.602668 1.441129 1.245038 1.020384 0.869687 0.648386 0.450018 0.294202 0.131282 1.918309 1.714491 1.552430 1.362819 1.173695 1.008674 0.832863 0.653763 0.468548 0.326658 0.145738 1.973013 1.808692 1.667606 1.539763 1.343220 1.204879 1.064886 0.898398 0.720339 0.584880 0.446216 0.294048 0.129321 0.022135 1.909141 1.756538 1.592143 1.508942 1.330035 1.179263 1.081432 0.959519 0.843072 0.707751 0.582324 0.485796 0.369497 0.203143 0.116713 0.016885 1.893006 1.797851 1.712050 1.592552 1.512360 1.408560 1.272657 1.222759 1.102842 1.016575 0.922253 0.792014 0.747304 0.678811 0.580058 0.514771 0.423539 0.347635 0.272515 0.152671 0.088329 0.041188 1.951228 1.925615 1.867853 1.802703 1.711739 1.634976 1.611846 1.560669 1.490758 1.447377 1.398313 1.346920 1.306946 1.264372 1.189815 1.142934 1.120019 1.086053 1.024822 1.029005 1.006465 0.940230 0.905684 0.895666 0.861317 0.854936 0.832572 0.807378 0.790575 0.762209 0.797941 0.801625 0.743213 0.713558 0.781928 0.771771 0.716618 0.733290 0.744668 0.724176 0.754147 0.739053 0.700920 0.739010 0.796873 0.799418 0.775990 0.811404 0.816932 0.842340 0.860477 0.894516 0.982786 0.961550 0.963283 1.012981 1.086673 1.114092 1.106218 1.188889 1.247842 1.260346 1.274622 1.353648 1.433345 1.466208 1.480752 1.545120 1.642050 1.700242 1.687703 1.768362 1.862278 1.943517 0.000818 0.076201 0.150125 0.180281 0.222129 0.365966 0.482954 0.514620 0.549492 0.673408 0.788399 0.835470 0.904474 1.031990 1.163022 1.209393 1.299593 1.406374 1.513152 1.591814 1.686543 1.834055 1.931800 0.055240 0.197480 0.267037 0.398137 0.485328 0.614628 0.758046 0.861226 1.029376 1.097523 1.188524 1.397300 1.516945 1.630313 1.760969 1.907545 0.084526 0.202151 0.324059 0.466825 0.621913 0.761153 0.892226 1.082124 1.202318 1.366000 1.524038 1.720050 1.897822 0.035542 0.169680 0.349973 0.531005 0.708841 0.862656 1.047090 1.227327 1.410216 1.573064 1.772267 1.948333 0.101484 0.297230 0.468765 0.677561 0.891018 1.107059 1.296457 1.456779 1.673662 1.852640 0.073769 0.294579 0.486932 0.683160 0.954619 1.126503 1.329741 1.549481 1.757198 -0.001592 0.190569 0.400730 0.667429 0.902451 1.116832 1.349314 1.597348 1.838120 0.080536 0.301272 0.529233 0.764821 1.060177 1.307163 1.498891 1.749939 -0.003986 0.291524 0.513049 0.792073 1.025973 1.270133 1.542757 1.840429 0.110437 0.340196 0.621470 0.877216 1.163592 1.432753 1.710929 0.014433 0.283277 0.559902 0.845134 1.123372 1.397822 1.735610 0.012367 0.341003 0.567488 0.878403 1.200176 1.497892 1.807626 0.081073 0.435875 0.702420 1.022595 1.288684 1.648317 1.962090 0.299026 0.609227 0.931300 1.267436 1.577627 1.905887 0.217591 0.578494 0.854374 1.220655 1.541951 1.946388 0.199152 0.562303 0.874974 1.240988 1.573196 1.953358 0.288411 0.646782 1.039263 1.374371 1.755536 0.115297 0.426585 0.769383 1.205034 1.561964 1.930960 0.275565 0.657082 1.015229 1.441545 1.805741 0.164207 0.520108 0.905695 1.301379 1.712808 0.092443 0.483794 0.856181 1.295509 1.679195 0.063239 0.421886 0.872115 1.231469 1.701667 0.094623 0.503036 0.903447 1.315649 1.780269 0.154284 0.573040 0.990278 1.456424 1.860362 0.250402 0.713664 1.075391 1.539088 1.979189 0.471534 0.846161 1.308422 1.730398 0.184799 0.643276 1.075559 1.557012 -0.016348 0.425266 0.864453 1.359841 1.785896 0.241235 0.715374 1.161941 1.653142 0.126152 0.567641 1.087519 1.490680 0.021464 0.489567 0.916044 1.490269 1.873826 0.419819 0.896209 1.318475 1.834542 0.363747 0.804913 1.360192 1.816331 0.352712 0.792433 1.375418 1.812472 0.358577 0.848789 1.362421 1.855594 0.354939 0.876538 1.413992 1.886562 0.440790 0.925370 1.467944 1.985634 0.513318 1.076130 1.596487 0.123792 0.663646 1.187966 1.759677 0.305516 0.817737 1.367163 1.871675 0.471326 0.997501 1.537854 0.122559 0.641630 1.213841 1.771201 0.275390 0.897742 1.423894 0.036880 0.579893 1.154827 1.697759 0.335641 0.864111 1.388255 0.077185 0.585649 1.212871 1.775560 0.378547 0.909430 1.523201 0.129670 0.712567 1.306598 1.948090 0.514139 1.118934 1.700983 0.321913 0.866107 1.527442 0.140413 0.732554 1.341411 1.958902 0.591237 1.212028 1.864471 0.458211 1.085207 1.702257 0.340152 0.978748 1.591927 0.246875 0.843890 1.521505 0.105796 0.767621 1.400780 0.040591 0.695675 1.346994 0.025246 0.675010 1.344337 1.914193 0.668936 1.254719 1.963169 0.647838 1.259110 1.968903 0.614438 1.277065 -0.026940 0.630204 1.302914 1.978524 0.681640 1.353709 0.047334 0.717723 1.433952 0.089774 0.781063 1.511875 0.208365 0.825437 1.585633 0.234678 0.963879 1.643382 0.370233 1.106822 1.767308 0.534130 1.204588 1.934879 0.671335 1.389923 0.114861 0.841472 1.566795 0.261388 0.978706 1.694866 0.443570 1.216188 1.874010 0.712363 1.417451 0.152946 0.932702 1.601086 0.364738 1.112468 1.862645 0.606964 1.340912 0.147409 0.859991 1.646115 0.381817 1.158104 1.919506 0.711487 1.453388 0.214626 0.968045 1.777840 0.595100 1.340734 0.074035 0.865398 1.695543 0.402790 1.229069 -0.008259 0.845517 1.589275 0.452388 1.216845 1.957084 0.803593 1.586535 0.393750 1.198693 -0.008367 0.831493 1.599736 0.455144 1.247274 0.049453 0.876270 1.702297 0.494480 1.346022 0.124855 1.026482 1.803271 0.666980 1.472355 0.302656 1.148854 -1.860257 0.782505 1.661051 0.509895 1.379925 0.271314 1.054521 1.919785 0.794792 1.643723 0.487765 1.325114 0.217055 1.059582 1.916577 0.772422 1.614133 0.569692 1.404714 0.272130 1.134942 0.031755 0.865987 1.787480 0.649721 1.541209 0.350941 1.297927 0.179176 1.068052 1.973954 0.877487 1.801402 0.719830 1.639779 0.491779 1.425260 0.293296 1.229266 0.161521 1.025624 1.929686 0.839339 1.745043 0.697836 1.609044 0.536039 1.446491 0.392348 1.320484 0.232838 1.157791 0.096533 1.036205 1.966236 0.894729 1.803732 0.762391 1.702543 0.650907 1.627052 0.563072 1.562061 0.513875 1.451078 0.415045 1.382717 0.342439 1.309768 0.232953 1.233411 0.163832 1.140232 0.140792 1.075771 0.061698 1.028868 -0.002765 1.038839 -0.006066 0.976550 -0.014923 0.935199 1.940993 0.958512 1.894346 0.938666 1.923885 0.870856 1.888933 0.849612 1.914325 0.884800 1.916622 0.943273 1.959116 0.996694 -0.038479 1.007424 0.036427 1.089975 0.075319 1.125322 0.162713 1.160666 0.226875 1.268089 0.309259 1.344403 0.368237 1.442689 0.477031 1.548703 0.482736 1.521654 0.618853 1.629307 0.708913 1.774265 0.836769 1.879456 0.911437 -0.041813 1.036620 0.118602 1.170836 0.265704 1.349098 0.438837 1.483150 0.581265 1.691150 0.765011 1.825587 0.941955 -1.650145 1.031408 0.155593 1.237480 0.403658 1.482565 0.515294 1.671932 0.793905 1.875149 0.918742 0.065731 1.167809 0.262111 1.345397 0.522167 1.523458 0.713151 1.792194 0.937344 0.046180 1.228050 0.355753 1.373695 0.555504 1.666810 0.825991 -0.021540 1.108899 0.245103 1.362577 0.538543 1.746825 0.844294 -0.020361 1.135792 0.257587 1.484868 0.579441 1.753239 0.888556 0.068331 1.223834 0.407535 1.520693 0.749529 1.921172 1.101754 0.288283 1.483529 0.684000 1.825145 1.022020 0.291691 1.526086)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
(vector 2048 83.108 #r(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       ;; pp:
	48.149255 #r(0.000000 1.170692 0.308241 1.390854 0.541228 1.668215 0.819532 1.930127 1.078849 0.215587 1.357026 0.502792 1.626588 0.742784 1.920985 1.072869 0.168347 1.320324 0.477790 1.603749 0.768355 1.922214 1.071877 0.208916 1.344163 0.525171 1.658252 0.811662 1.966172 1.131422 0.304367 1.467760 0.609626 1.765169 0.904973 0.086798 1.273711 0.386978 1.569934 0.758404 1.908860 1.115874 0.285910 1.429521 0.572115 1.746697 0.944727 0.077790 1.277623 0.425060 1.613660 0.803885 1.936164 1.150212 0.314223 1.534271 0.695367 1.879392 1.082047 0.233573 1.425349 0.594615 1.782767 0.946008 0.173047 1.360727 0.554591 1.735004 0.955483 0.146172 1.292379 0.513417 1.721824 0.940465 0.142328 1.306230 0.533703 1.713231 0.951635 0.123693 1.323721 0.525381 1.749133 0.941392 0.139136 1.361653 0.550750 1.789411 0.996297 0.176270 1.428540 0.637735 1.853716 1.054202 0.300288 1.467793 0.724447 1.902948 1.154922 0.367388 1.585521 0.822979 0.019512 1.264225 0.493671 1.703020 0.937791 0.161875 1.437459 0.625290 1.862212 1.098731 0.308350 1.543013 0.802556 0.006024 1.280885 0.496430 1.755511 0.969518 0.237912 1.460822 0.705396 1.990545 1.179440 0.440831 1.699802 0.942304 0.196681 1.450509 0.666856 1.942080 1.190676 0.451924 1.710157 0.944060 0.209774 1.444500 0.731425 1.973650 1.221884 0.508440 1.761193 1.014734 0.295618 1.532214 0.832136 0.077755 1.367371 0.605708 1.903102 1.151336 0.407600 1.655961 0.939712 0.266819 1.504940 0.792571 0.046618 1.343532 0.644878 1.876666 1.182120 0.443025 1.719021 1.015595 0.333981 1.595884 0.895805 0.188237 1.466593 0.749784 0.045679 1.347046 0.637590 1.902851 1.188236 0.497673 1.749913 1.027421 0.384161 1.681457 0.992937 0.275614 1.597965 0.889753 0.195485 1.491730 0.823141 0.081456 1.409559 0.696494 0.033963 1.295148 0.642214 1.929674 1.244368 0.584724 1.886842 1.226565 0.509313 1.825883 1.172235 0.473344 1.768061 1.106537 0.438695 1.732747 1.084666 0.377124 1.719833 1.064115 0.365452 1.691265 1.064911 0.404796 1.680761 0.995938 0.342507 1.664015 1.025519 0.355889 1.694915 1.041223 0.379619 1.692621 1.038255 0.375929 1.747822 1.084822 0.431641 1.756374 1.063810 0.432231 1.779188 1.146481 0.503809 1.856543 1.180582 0.557189 1.888340 1.227632 0.588306 -0.026904 1.300234 0.648609 0.043178 1.388236 0.764888 0.112835 1.470513 0.836486 0.195531 1.560585 0.947951 0.307597 1.668625 1.056353 0.418131 1.768025 1.158761 0.537175 1.898384 1.273651 0.646143 0.012280 1.412590 0.787117 0.163697 1.546426 0.926082 0.307948 1.705011 1.060037 0.465147 1.851175 1.221909 0.604415 1.986733 1.373802 0.804025 0.183128 1.577819 0.945667 0.353256 1.759089 1.153867 0.566013 1.966016 1.336119 0.736596 0.123101 1.530623 0.943526 0.322979 1.755714 1.120923 0.566301 1.968164 1.359557 0.792281 0.184289 1.602467 1.023066 0.436720 1.853493 1.254797 0.651661 0.084962 1.511428 0.934138 0.324785 1.747178 1.138708 0.575532 0.032076 1.446461 0.855466 0.285796 1.737023 1.147595 0.571594 -0.006008 1.433456 0.869281 0.311815 1.731951 1.176583 0.600651 0.027712 1.473010 0.949244 0.346711 1.802448 1.232908 0.686783 0.121361 1.560235 0.989183 0.436356 1.907691 1.336891 0.779609 0.253248 1.694117 1.144131 0.612453 0.033276 1.495258 0.956158 0.382539 1.843338 1.332424 0.800184 0.263469 1.691394 1.133065 0.613994 0.089378 1.564585 0.995537 0.466248 1.934495 1.396455 0.856984 0.356415 1.805556 1.299549 0.743523 0.242775 1.748620 1.210165 0.673281 0.139415 1.600269 1.084904 0.587272 0.085343 1.544211 1.009998 0.521313 -0.001177 1.438526 0.940200 0.438241 1.980662 1.425819 0.930013 0.425644 1.914665 1.417734 0.881070 0.381171 1.879043 1.379807 0.869175 0.370012 1.892024 1.385930 0.878593 0.364824 1.842216 1.375667 0.881118 0.376189 1.885357 1.395553 0.940184 0.442770 1.959829 1.470475 0.950137 0.499630 -0.010510 1.527475 1.018789 0.536607 0.051756 1.597926 1.095294 0.602832 0.142189 1.653821 1.206578 0.716403 0.236752 1.741975 1.293291 0.843373 0.342663 1.886200 1.405385 0.932332 0.475725 0.025525 1.557427 1.105714 0.603190 0.150969 1.664055 1.229998 0.762822 0.339844 1.850549 1.407287 0.929182 0.481965 0.030847 1.592474 1.145611 0.657185 0.219129 1.779392 1.304177 0.878738 0.421215 1.974254 1.555506 1.079684 0.641847 0.213249 1.785052 1.349103 0.896333 0.443787 0.028897 1.574251 1.121351 0.712637 0.290878 1.864350 1.428799 0.990595 0.538511 0.113824 1.672152 1.256060 0.862091 0.417912 1.988284 1.530018 1.138030 0.753268 0.331924 1.868317 1.470319 1.047541 0.665869 0.210016 1.801484 1.395508 0.986041 0.571277 0.158466 1.758817 1.321461 0.903588 0.525112 0.111834 1.714355 1.298558 0.937594 0.513658 0.100545 1.702514 1.296577 0.893299 0.505313 0.117713 1.715593 1.308123 0.910713 0.506039 0.141042 1.763973 1.343854 0.947574 0.551294 0.205031 1.803013 1.387490 1.025127 0.631898 0.232903 1.862491 1.490112 1.111562 0.742825 0.359671 1.970223 1.597295 1.226211 0.876596 0.491888 0.111425 1.736040 1.335035 0.986140 0.619050 0.257511 1.879176 1.504959 1.149928 0.776016 0.415984 0.062236 1.702993 1.380390 0.993873 0.616154 0.274561 1.892164 1.561366 1.204581 0.868486 0.516450 0.125047 1.820744 1.432402 1.080201 0.724556 0.394683 0.043523 1.710881 1.381810 1.003820 0.648116 0.331332 1.976997 1.636048 1.301920 0.932976 0.625714 0.300920 1.960841 1.634686 1.299662 0.970299 0.626878 0.301493 1.966748 1.647652 1.348062 1.023021 0.671859 0.320594 0.020884 1.678529 1.361362 1.021102 0.734712 0.401316 0.062227 1.768254 1.431209 1.113831 0.831880 0.503853 0.188942 1.874039 1.567785 1.259986 0.973262 0.635446 0.337678 0.036193 1.746791 1.420205 1.107327 0.788562 0.521781 0.208084 1.923246 1.605224 1.321186 1.014488 0.718959 0.437932 0.127193 1.807060 1.533585 1.261696 0.954038 0.679102 0.387113 0.075012 1.802972 1.522318 1.250803 0.970970 0.649713 0.340883 0.096775 1.841955 1.566279 1.291679 0.990853 0.699813 0.452113 0.144826 1.871038 1.602001 1.365354 1.073677 0.817165 0.559212 0.267497 0.000150 1.736216 1.478209 1.198483 0.952374 0.678088 0.405634 0.187210 1.889916 1.611550 1.388769 1.146324 0.877599 0.605490 0.346786 0.082248 1.865542 1.629296 1.329758 1.112339 0.881540 0.607783 0.350132 0.090546 1.858472 1.624258 1.416386 1.133519 0.912542 0.680041 0.455398 0.178653 1.937027 1.717750 1.463786 1.219588 1.017342 0.783848 0.543368 0.281857 0.053523 1.876390 1.610913 1.397358 1.173326 0.955559 0.732660 0.499558 0.267886 0.070985 1.822851 1.564014 1.371260 1.167567 0.967966 0.749212 0.528503 0.322623 0.106576 1.868014 1.694037 1.465164 1.247973 1.046152 0.831676 0.629468 0.460814 0.227153 0.011244 1.808027 1.620380 1.445267 1.185168 0.997025 0.822433 0.608195 0.448882 0.228849 0.009050 1.830670 1.655542 1.447189 1.268983 1.074650 0.887035 0.709903 0.496003 0.328566 0.159623 1.949798 1.799488 1.584912 1.404562 1.253583 1.023377 0.871905 0.701132 0.503056 0.336332 0.148528 -0.002016 1.825093 1.633309 1.480009 1.314568 1.139780 0.975113 0.818847 0.607638 0.483049 0.322420 0.154634 1.981606 1.815213 1.661500 1.499725 1.338908 1.168340 1.032058 0.877039 0.721160 0.588133 0.415324 0.276252 0.117926 1.954659 1.790087 1.669129 1.488339 1.343387 1.211507 1.073743 0.923835 0.776714 0.635988 0.493150 0.367183 0.252927 0.069606 1.920446 1.790867 1.668519 1.526059 1.394947 1.291443 1.117907 0.999278 0.893252 0.744164 0.621059 0.497086 0.390171 0.218487 0.094330 0.001176 1.846608 1.731119 1.625923 1.498291 1.375130 1.291545 1.178946 1.027021 0.949584 0.832553 0.704354 0.607200 0.483166 0.374900 0.259484 0.154320 0.035848 1.933567 1.816766 1.714514 1.624733 1.507896 1.387072 1.312078 1.195014 1.119208 0.999309 0.889170 0.823605 0.731843 0.603462 0.530567 0.426256 0.327061 0.272310 0.169343 0.068445 1.977751 1.892019 1.819014 1.743827 1.664429 1.579279 1.474150 1.406299 1.321121 1.279727 1.162876 1.052692 1.008429 0.941088 0.871647 0.781155 0.719448 0.635660 0.570342 0.488695 0.406041 0.362157 0.296718 0.225580 0.143754 0.110194 0.064065 1.968105 1.915690 1.846054 1.797082 1.755829 1.652919 1.596749 1.568725 1.478236 1.422875 1.404646 1.326695 1.278978 1.242206 1.180807 1.125265 1.073293 1.041678 1.015763 0.952063 0.921253 0.863725 0.827305 0.797836 0.756233 0.705415 0.670943 0.615427 0.599562 0.540327 0.515799 0.473420 0.435217 0.419307 0.394473 0.339202 0.293024 0.305713 0.251395 0.217443 0.224352 0.212083 0.173144 0.116187 0.132026 0.132029 0.068897 0.080221 0.039281 0.001610 0.010698 0.045694 1.976101 1.940891 1.943619 1.937866 1.955329 1.944938 1.935503 1.907908 1.907124 1.918553 1.923032 1.888422 1.884967 1.882418 1.886063 1.870122 1.875810 1.898628 1.918110 1.924507 1.937596 1.888763 1.895107 1.918196 1.922566 1.938402 1.964110 1.953103 1.956793 1.992300 0.016097 0.034313 0.033734 0.048481 0.084434 0.091963 0.104638 0.132092 0.125566 0.177694 0.189408 0.204014 0.260079 0.273777 0.284513 0.295636 0.325771 0.360193 0.388060 0.446633 0.477847 0.505543 0.529977 0.564016 0.624189 0.624185 0.684339 0.709170 0.771783 0.828253 0.860537 0.881277 0.918075 0.974706 1.015365 1.065645 1.109557 1.175366 1.215405 1.272600 1.304598 1.371188 1.448909 1.474524 1.514436 1.579151 1.652528 1.731221 1.775525 1.803012 1.885952 1.940234 0.018568 0.073118 0.143103 0.185179 0.210516 0.327954 0.380243 0.423257 0.536760 0.615309 0.675282 0.748270 0.798965 0.864305 0.966813 1.050901 1.111384 1.196603 1.285622 1.337335 1.434737 1.527994 1.618486 1.694260 1.750105 1.827968 1.922567 0.049301 0.127544 0.209346 0.309399 0.417489 0.501338 0.552718 0.651631 0.775755 0.866935 0.948044 1.044203 1.171487 1.267821 1.347377 1.433539 1.550715 1.673644 1.759500 1.858082 1.985378 0.095325 0.196995 0.304456 0.419221 0.529333 0.648644 0.751576 0.825041 0.980021 1.101705 1.194931 1.301816 1.433979 1.561786 1.675483 1.789903 1.900235 0.046047 0.161492 0.294810 0.402094 0.533337 0.655933 0.804684 0.928168 1.051065 1.206516 1.347228 1.447663 1.573094 1.759454 1.894113 0.002782 0.130839 0.270547 0.442558 0.576101 0.699315 0.855283 0.989272 1.130985 1.283075 1.438510 1.568549 1.744782 1.853826 0.032382 0.153463 0.340019 0.485687 0.642703 0.793291 0.934811 1.084083 1.258191 1.441643 1.585244 1.742146 1.886535 0.072311 0.194340 0.390227 0.579089 0.706694 0.873297 1.058929 1.238233 1.397489 1.571233 1.728909 1.911682 0.064763 0.242424 0.439565 0.583536 0.782937 0.971247 1.128889 1.277236 1.481638 1.658612 1.872942 0.060763 0.226717 0.396695 0.619301 0.791305 0.988992 1.150019 1.362035 1.547343 1.762750 1.946555 0.131335 0.348126 0.507941 0.720424 0.932986 1.092551 1.309966 1.527683 1.725145 1.915403 0.115544 0.315991 0.486385 0.723694 0.931952 1.164664 1.378060 1.561919 1.803181 1.979756 0.216565 0.410286 0.624205 0.833961 1.086281 1.271039 1.507656 1.717187 1.915868 0.150840 0.360953 0.579974 0.834762 1.068542 1.290452 1.490243 1.744183 1.961496 0.193884 0.425585 0.643098 0.908131 1.074322 1.345579 1.593368 1.802983 0.051047 0.304389 0.525694 0.795755 0.993034 1.280169 1.482776 1.735067 1.953964 0.218140 0.472045 0.701078 0.963442 1.232018 1.434450 1.728673 1.984614 0.235461 0.512219 0.717355 1.004405 1.266754 1.477310 1.744641 0.012209 0.288512 0.543147 0.780953 1.051467 1.339104 1.604068 1.883609 0.114597 0.405035 0.653569 0.938458 1.197604 1.464091 1.735516 0.013934 0.300963 0.576278 0.851429 1.131360 1.371183 1.691176 1.946803 0.226107 0.529922 0.798388 1.097752 1.357811 1.658942 1.965442 0.222335 0.526326 0.804438 1.098871 1.428788 1.686564 1.986218 0.268527 0.561936 0.862994 1.143957 1.474117 1.741222 0.057705 0.348416 0.688815 1.001042 1.252716 1.578074 1.833287 0.143989 0.509439 0.785699 1.095321 1.415329 1.705123 0.031103 0.334783 0.678873 0.915842 1.295443 1.584575 1.950608 0.232694 0.567052 0.893329 1.177542 1.529003 1.817887 0.168858 0.520574 0.789739 1.158191 1.454022 1.815975 0.130842 0.458956 0.804654 1.102584 1.435028 1.809511 0.098344 0.455343 0.788126 1.148120 1.497753 1.821562 0.157014 0.502554 0.810987 1.189354 1.536327 1.871074 0.214208 0.535850 0.902414 1.252742 1.625466 1.986360 0.305114 0.676415 1.030718 1.365229 1.716337 0.088200 0.453246 0.758250 1.145498 1.519793 1.902932 0.239162 0.620264 0.955018 1.349613 1.713870 0.068248 0.443904 0.773567 1.168590 1.521318 1.911367 0.233546 0.648955 1.031312 1.404793 1.757002 0.145049 0.550841 0.919010 1.285822 1.674689 0.039661 0.430672 0.829621 1.221848 1.594728 1.983222 0.362592 0.768592 1.160700 1.533414 1.950456 0.323220 0.719327 1.062894 1.512139 1.876518 0.275260 0.686407 1.071963 1.485550 1.901384 0.276696 0.676427 1.123360 1.478860 1.850091 0.316084 0.699759 1.130656 1.523136 1.928015 0.348922 0.724432 1.163903 1.575589 -0.006846 0.382308 0.823765 1.211661 1.663815 0.084283 0.514262 0.924858 1.329788 1.763020 0.174609 0.622373 1.058259 1.480355 1.901980 0.344561 0.753011 1.186062 1.635751 0.042252 0.485194 0.911805 1.346698 1.751157 0.234136 0.638664 1.138681 1.534696 1.966887 0.419243 0.853944 1.304679 1.768113 0.194343 0.621877 1.077205 1.509461 1.974577 0.441968 0.898925 1.332299 1.799243 0.230147 0.676701 1.146754 1.606475 0.057142 0.541309 1.003077 1.450722 1.930183 0.360917 0.841443 1.287136 1.777559 0.230325 0.689397 1.159775 1.620356 0.088102 0.571480 1.065207 1.512650 1.990232 0.428277 0.952182 1.397796 1.896667 0.356746 0.845830 1.310858 1.771868 0.263265 0.772534 1.253351 1.769352 0.244946 0.711097 1.176076 1.660336 0.171394 0.655330 1.144087 1.631667 0.129014 0.618146 1.110614 1.620612 0.122051 0.629742 1.089791 1.604769 0.078456 0.610494 1.087064 1.587748 0.102930 0.625780 1.124534 1.607388 0.141803 0.625332 1.148304 1.676337 0.169572 0.678921 1.204394 1.709202 0.227525 0.783490 1.258156 1.802551 0.305747 0.816394 1.347022 1.872653 0.376617 0.898253 1.397840 1.960745 0.480697 0.988214 1.552551 0.049542 0.603017 1.132468 1.626493 0.200962 0.737801 1.261357 1.777156 0.351168 0.857538 1.415123 1.948162 0.473612 1.032567 1.566433 0.104519 0.657297 1.240790 1.761699 0.294298 0.837177 1.384173 1.986601 0.504646 1.039950 1.611874 0.097545 0.691700 1.278736 1.821821 0.394769 0.940428 1.493933 0.019729 0.629089 1.175963 1.745183 0.311868 0.869838 1.439008 0.004666 0.548607 1.141779 1.689007 0.257229 0.847096 1.405444 0.000704 0.564277 1.102924 1.706179 0.301848 0.870697 1.471077 0.014036 0.599522 1.182577 1.775360 0.359626 0.935574 1.539169 0.066956 0.711684 1.263421 1.871658 0.462938 1.059536 1.638226 0.183745 0.824184 1.413682 0.010682 0.634184 1.224499 1.812811 0.411838 1.010765 1.612211 0.209824 0.808014 1.414116 0.035816 0.596220 1.226465 1.839830 0.423148 1.068180 1.678467 0.294171 0.889152 1.531352 0.114352 0.722645 1.341629 1.960837 0.584818 1.219116 1.805769 0.442114 1.066770 1.688278 0.321252 0.941374 1.580739 0.180962 0.810454 1.441120 0.082203 0.674001 1.328659 1.967796 0.600669 1.238854 1.854638 0.532805 1.156122 1.760103 0.424153 1.026911 1.686565 0.333981 0.980640 1.618363 0.259494 0.906517 1.542448 0.221261 0.841765 1.472233 0.144916 0.798272 1.478044 0.114233 0.741774 1.399106 0.055974 0.726627 1.340623 0.013905 0.700773 1.360448 0.003071 0.693767 1.341013 1.982808 0.677531 1.332554 0.008222 0.682851 1.353076 -0.004177 0.675017 1.358229 0.031554 0.685527 1.343066 0.035167 0.738936 1.396828 0.054910 0.744435 1.423184 0.136398 0.771445 1.447517 0.124824 0.834168 1.523144 0.190072 0.908676 1.601848 0.256066 0.979271 1.643980 0.327077 0.999301 1.675989 0.431300 1.111238 1.840464 0.521639 1.212132 1.916129 0.622292 1.318981 -0.021749 0.686683 1.411183 0.126229 0.826834 1.513942 0.255440 0.954631 1.649046 0.362470 1.101828 1.780367 0.517789 1.247707 1.906975 0.629918 1.363129 0.069301 0.822233 1.501965 0.247870 0.955203 1.682873 0.431064 1.162164 1.852556 0.570103 1.274503 0.022611 0.791757 1.528964 0.201974 0.941971 1.720002 0.448118 1.197148 1.858043 0.629842 1.325850 0.088884 0.845174 1.550568 0.316503 1.026333 1.814374 0.565620 1.323980 0.035056 0.813142 1.533384 0.284575 1.028117 1.776023 0.541481 1.261088 0.024028 0.810168 1.508486 0.276379 1.094466 1.856190 0.568828 1.372806 0.098076 0.853025 1.630075 0.395484 1.165660 1.895922 0.685860 1.388033 0.190152 0.996281 1.759639 0.544912 1.316893 0.066439 0.836269 1.641256 0.395738 1.160121 1.988069 0.707525 1.492181 0.270702 1.056625 1.880763 0.652086 1.400672 0.217960 1.043264 1.765743 0.569777 1.382208 0.144876 0.913991 1.722037 0.508995 1.289690 0.103895 0.887645 1.683969 0.487337 1.300715 0.075564 0.873417 1.692059 0.523468 1.323021 0.055824 0.918104 1.728832 0.547317 1.312756 0.100934 0.932010 1.783166 0.535104 1.356210 0.164038 0.990773 1.802078 0.651073 1.433007 0.269627 1.098813 1.900301 0.748477 1.557552 0.359601 1.161244 0.030280 0.805530 1.639179 0.483611 1.316115 0.138250 0.975004 1.801486 0.646901 1.466647 0.312074 1.143839 1.991425 0.809514 1.656277 0.494890 1.335690 0.172599 1.000889 1.855849 0.705929 1.545863 0.370342 1.213827 0.030312 0.911197 1.723173 0.626127 1.479485 0.300716 1.158439 0.027646 0.866564 1.722245 0.591356 1.460205 0.290651 1.155261 0.013223 0.885221 1.741682 0.581208 1.427935 0.284725 1.164787 0.053075 0.879054 1.791785 0.633292 1.524863 0.381156 1.276013 0.137327 1.012443 1.918016 0.791083 1.682727 0.545067 1.420945 0.265831 1.172550 0.068675 0.944786 1.774509 0.699611 1.595080 0.456048 1.337144 0.237567 1.147792 0.014285 0.902463 1.757444 0.691855 1.580356 0.451754 1.373188 0.249518 1.165251 0.050640 0.992504 1.876589 0.770854 1.659717 0.587876 1.501307 0.366186 1.266821 0.213114 1.098596 -0.004612 0.887272 1.795975 0.744970 1.633939 0.554276 1.446870 0.361041 1.275793 0.187904 1.091764 0.057136 0.996576 1.874979 0.810171 1.738696 0.634435 1.571893 0.524098 1.425473 0.368250 1.311505 0.235901 1.181832 0.070565 1.006213 1.962129 0.926270 1.859383 0.750601 1.728461 0.618699 1.573937 0.509637 1.423625 0.373200 1.302906 0.267177 1.200435 0.111648 1.045951 0.037017 0.931648 1.909647 0.860694 1.791655 0.759701 1.743907 0.668229 1.620499 0.588162 1.536163 0.503791 1.482285 0.455308 1.403323 0.359007 1.340343 0.299059 1.235268 0.197343 1.182337 0.155416 1.113536 0.081955 1.072152 0.019967 0.976704 1.943381 0.927325 1.898270 0.844041 1.867692 0.855182 1.804370 0.784771 1.754908 0.689413 1.723463 0.708542 1.639279 0.652612 1.633951 0.617615 1.615853 0.592305 1.598346 0.588323 1.537489 0.520691 1.520387 0.490771 1.510234 0.483163 1.483640 0.495299 1.497087 0.479501 1.489632 0.477746 1.524250 0.477354 1.480883 0.482317 1.535612 0.515268 1.513395 0.556905 1.569163 0.600113 1.596145 0.590563 1.618831 0.586103 1.632821 0.607078 1.634491 0.685765 1.676879 0.693983 1.718696 0.759412 1.759474 0.814785 1.820597 0.847658 1.877677 0.948296 1.954903 1.000969 -0.754102 0.985915 0.047426 1.108287 0.101412 1.191421 0.195944 1.286092 0.303073 1.341821 0.414600 1.494142)
       )
))


;; :odd 65536 (311.51645615075 1.5666759234657 2.0944106499714) 0.51769778542275 (100)



;;; ---------------------------------------- prime-numbered harmonics (and first) ----------------------------------------

(define primoid-min-peak-phases (vector

(vector 1  1.0   #r(0)
     )

(vector 2  1.76  #r(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
(vector 3  2.1949384212494 #r(0 0 1)
     1.980 #r(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #r(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #r(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
(vector 4  2.5978584289551 #r(0 0 1 1)
     
     ;2.2039985204158 #r(0 0 12 4) / 20
     2.1930510997772 #r(0.000 0.996 0.596 0.217)
     2.1930510997772 #r(0.000 1.996 0.596 0.217)
     2.1930510997772 #r(0.000 0.004 1.404 1.783)

     2.1927945613861 #r(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #r(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #r(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
(vector 5  2.7172040939331 #r(0 0 1 0 0)

     2.476848 #r(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #r(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
(vector 6  3.1241359710693 #r(0 0 0 1 0 0)

     2.805574 #r(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #r(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     2.805413 #r(0.000000 0.431110 -0.033974 0.917615 1.099635 1.202594)
     )

;;; 7 prime --------------------------------------------------------------------------------
(vector 7  3.4886319637299 #r(0 1 1 0 0 0 0)

     3.061763 #r(0.000000 0.715523 0.261251 0.168577 0.061828 1.179155 0.328665)
     )

;;; 8 prime --------------------------------------------------------------------------------
(vector 8  3.7088720798492 #r(0 0 0 0 0 0 1 0)

     3.262789 #r(0.000000 0.792261 1.965087 0.247823 1.935907 1.654053 0.597010 1.934463)
     )

;;; 9 prime --------------------------------------------------------------------------------
(vector 9  3.9154822826385 #r(0 0 0 1 1 1 0 0 0)

     3.382150 #r(0.000000 1.437471 1.479039 0.479171 0.317977 1.279012 1.195104 0.746644 1.274032)
     )

;;; 10 prime --------------------------------------------------------------------------------
(vector 10 4.1209712028503 #r(0 0 1 0 0 0 1 0 0 0)

     3.601897 #r(0.000000 0.594605 1.305309 1.611462 1.242927 0.149405 1.922318 0.974872 1.624292 0.771826)
     )

;;; 11 prime --------------------------------------------------------------------------------
(vector 11 4.4176635742188 #r(0 0 1 0 0 0 0 0 0 1 0)

     3.778444 #r(0.000000 0.211392 1.453207 1.827566 1.811268 1.948666 1.312975 0.822389 1.333108 0.126706 0.823083)
     )

;;; 12 prime --------------------------------------------------------------------------------
(vector 12 4.3595271110535 #r(0 0 0 0 0 0 1 0 1 1 0 1)

     3.935928 #r(0.000000 0.367095 0.996695 1.763345 1.295131 0.139476 0.755820 1.563961 1.282494 0.302360 0.327995 0.321982)
     )

;;; 13 prime --------------------------------------------------------------------------------
(vector 13 4.8980793952942 #r(0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.154486 #r(0.000000 0.888925 1.516611 -0.128449 1.377349 0.383874 0.573640 -0.040502 0.230047 1.920090 0.190320 1.307111 1.782269)
     )

;;; 14 prime --------------------------------------------------------------------------------
(vector 14 4.827317237854 #r(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.324364 #r(0.000000 0.359123 1.885242 0.244967 1.221612 1.840358 1.317076 0.526663 0.485486 1.185929 1.087828 0.273652 0.783599 0.859686)
     )

;;; 15 prime --------------------------------------------------------------------------------
(vector 15 5.116711139679 #r(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.465870 #r(0.000000 1.195783 0.875671 1.808021 1.309702 0.184662 0.170474 0.531131 0.521153 0.683109 0.474077 -0.194026 1.432983 0.523484 0.889349)
     )

;;; 16 prime --------------------------------------------------------------------------------
(vector 16 5.2015118598938 #r(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.600306 #r(0.000000 0.087862 0.378855 0.177701 0.258884 1.624830 1.330220 0.960734 1.836164 1.680878 1.236729 1.958382 1.391766 1.922763 1.425076 0.083217)
     )

;;; 17 prime --------------------------------------------------------------------------------
(vector 17 5.5318970680237 #r(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.718649 #r(0.000000 0.751159 1.770960 1.891296 0.451714 0.167219 0.486669 1.820262 1.171314 0.188288 1.302438 1.491326 0.945450 0.342701 1.668608 1.730493 1.394926)
     )

;;; 18 prime --------------------------------------------------------------------------------
(vector 18 5.518 #r(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.855108 #r(0.000000 0.750207 1.384561 1.357598 -0.059069 1.202337 0.735689 0.367843 0.732570 0.743255 0.704408 1.570924 1.212329 0.426050 0.813634 1.013534 -0.181098 0.979190)
     )

;;; 19 prime --------------------------------------------------------------------------------
(vector 19 5.7069295560724 #r(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     4.998754 #r(0.000000 1.645363 1.697584 1.402853 1.761967 1.410480 1.731078 0.730841 0.373575 0.971264 1.632848 -0.032567 1.185342 0.399132 1.548900 1.042245 0.314528 1.610838 0.400814)
     )

;;; 20 prime --------------------------------------------------------------------------------
(vector 20 5.8879864574703 #r(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.182566 #r(0.000000 1.263246 0.762194 0.608532 -0.162633 0.980718 1.431801 -0.440489 1.122128 -0.196813 -0.666076 0.455149 -0.710850 -0.505486 -1.097448 -0.446751 0.276095 -0.871587 -0.537639 -1.622748)
     )

;;; 21 prime --------------------------------------------------------------------------------
(vector 21 6.1138607493652 #r(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.323612 #r(0.000000 0.280854 0.184723 0.594540 1.747745 0.845155 0.483640 0.360116 -0.153262 0.371609 1.613941 1.441516 -0.006745 0.553330 0.784905 0.983522 0.871481 1.204293 -0.066217 0.952578 1.624372)
     )

;;; 22 prime --------------------------------------------------------------------------------
(vector 22 6.3374844973589 #r(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.433554 #r(0.000000 1.486514 1.390599 1.149545 0.921462 0.702749 0.884951 0.283286 0.900936 0.913025 1.182081 0.780309 1.832213 0.822636 1.714820 0.783014 0.057705 0.842269 0.698584 1.561603 0.224265 0.995298)
     )

;;; 23 prime --------------------------------------------------------------------------------
(vector 23 6.5309901747782 #r(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.562290 #r(0.000000 0.285874 0.595224 0.235000 1.193968 1.380397 0.263651 1.051885 0.699527 1.708311 0.571007 0.512971 0.292952 0.607887 0.434888 0.887469 1.457277 1.731817 0.825388 0.371687 1.321790 1.739434 1.728651)
     )

;;; 24 prime --------------------------------------------------------------------------------
(vector 24 6.5623834870329 #r(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.642196 #r(0.000000 0.890373 -0.094314 1.286595 1.344700 0.673123 0.114259 0.064347 0.093887 1.778664 0.785400 0.193244 0.317478 1.782787 0.521724 0.200559 0.236076 1.409678 1.913185 1.269474 1.450265 -0.052106 0.501351 0.830713)
     )

;;; 25 prime --------------------------------------------------------------------------------
(vector 25 6.635721206665 #r(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.810785 #r(0.000000 0.563705 1.200194 1.330185 1.448503 0.304746 -0.097873 1.178970 1.307797 0.187993 1.570595 0.364607 -0.021932 1.552639 -0.223928 1.041142 1.388107 1.015775 1.883861 0.551891 1.621094 0.871585 1.482986 0.450455 0.538066)
     )

;;; 26 prime --------------------------------------------------------------------------------
(vector 26 6.8401503562927 #r(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.055996 #r(0.000000 -0.016268 0.026203 0.449734 1.018710 0.881734 0.049135 1.760926 0.387504 0.283173 1.580172 0.572083 0.436296 0.505403 0.123142 0.081364 0.170694 0.728335 1.724322 1.110985 1.075642 0.847570 1.124886 1.668312 0.321527 0.862927)
     )

;;; 27 prime --------------------------------------------------------------------------------
(vector 27 6.9491486549377 #r(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.133994 #r(0.000000 1.619323 0.268498 0.605329 0.261788 1.741906 1.690385 1.044397 0.095253 1.526766 0.682732 1.844188 1.227922 -0.046848 0.854154 -0.053734 1.525611 0.460071 0.230079 1.191101 1.252287 1.704028 -0.029667 1.798141 1.802482 1.571525 0.379519)
     )

;;; 28 prime --------------------------------------------------------------------------------
(vector 28 7.1576952934265 #r(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.190947 #r(0.000000 0.460822 1.000235 0.802902 1.169351 0.023696 1.059034 0.557253 0.339303 -0.037893 0.757652 1.745281 0.808299 1.572816 1.228654 0.154747 0.925847 0.957314 0.565556 0.484885 0.864794 1.110639 0.659146 1.596331 1.587743 0.524304 1.470688 0.086831)
     )

;;; 29 prime --------------------------------------------------------------------------------
(vector 29 7.2415904369233 #r(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.364996 #r(0.000000 0.899299 0.027883 1.660781 0.583908 0.594226 1.394105 1.009420 -0.076432 0.063436 1.779221 1.537249 1.002516 1.590894 -0.057219 1.023692 1.515341 1.279493 0.140022 -0.035094 0.723643 0.484040 0.612756 1.373872 1.209603 1.304864 0.985337 0.845953 0.581252)
     )

;;; 30 prime --------------------------------------------------------------------------------
(vector 30 7.1189651489258 #r(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.451812 #r(0.000000 1.683608 0.803658 0.933316 0.850814 1.701341 1.277986 1.473972 1.214431 1.898492 0.954836 1.784293 1.951482 1.381903 0.107238 0.105553 1.260609 1.566570 0.409971 0.385253 1.590967 0.968660 0.054889 0.914665 1.664915 1.656054 1.094096 1.343614 0.650979 0.864222)
     )

;;; 31 prime --------------------------------------------------------------------------------
(vector 31 7.4906754493713 #r(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.615530 #r(0.000000 1.619420 0.923847 1.082825 0.781141 1.610656 1.231074 1.487481 1.224879 0.083506 1.018988 1.699276 -0.015436 1.345804 -0.063558 -0.024175 1.143421 1.653947 0.304635 0.370982 1.593152 0.991610 0.007662 0.843108 1.659562 1.800094 0.848731 1.499297 0.637649 0.927864 0.174683)
     )

;;; 32 prime --------------------------------------------------------------------------------
(vector 32 7.6309351921082 #r(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.771875 #r(0.000000 -0.104918 1.369126 0.835707 0.832591 0.686962 1.078953 0.996442 1.123899 0.265649 0.104756 1.033734 1.127023 0.969497 -0.146560 -0.074679 -0.108563 0.138500 0.334066 0.125954 -0.029234 1.158087 -0.155039 0.017563 1.122941 -0.091297 0.191584 0.742695 -0.018956 -0.183574 0.889830 0.007141)
     )

;;; 33 prime --------------------------------------------------------------------------------
(vector 33 7.7389698028564 #r(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.846444 #r(0.000000 1.540730 1.269040 0.749184 0.961715 0.756150 0.876752 0.416027 1.022774 0.964239 1.083376 0.550495 1.494046 0.196678 0.925862 0.362000 0.602774 1.401166 0.181115 1.142230 0.264880 0.003237 0.994773 0.034504 0.433160 0.985315 1.781928 0.301442 1.605371 1.626266 0.719713 0.024414 0.683173)
     )

;;; 34 prime --------------------------------------------------------------------------------
(vector 34 7.9624452590942 #r(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     6.991192 #r(0.000000 1.753519 0.200582 1.709673 0.364080 0.826783 0.339745 0.629017 1.916751 1.209744 1.171294 -1.878381 1.379347 0.682133 1.526150 -0.403398 1.590798 1.225400 1.046260 0.612397 0.683970 1.216405 0.626313 0.038228 1.289324 1.063867 0.495350 0.036835 0.806562 1.424403 1.251942 0.446062 1.562643 0.395827)
     )

;;; 35 prime --------------------------------------------------------------------------------
(vector 35 8.0019035339355 #r(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.163607 #r(0.000000 1.266503 0.439150 0.502027 -0.033212 1.025554 1.236433 1.852606 1.521580 0.894650 0.982935 1.338812 0.175216 1.929333 1.483026 0.812681 0.144350 1.543173 0.347773 0.191753 0.996456 1.584603 0.595312 0.526825 0.409349 0.179419 0.765371 0.331481 0.734526 0.534073 1.395010 0.148584 0.213643 0.199292 1.071967)
     )

;;; 36 prime --------------------------------------------------------------------------------
(vector 36 8.3031883239746 #r(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.186926 #r(0.000000 1.311697 0.709034 0.915159 0.808357 1.216359 0.908904 1.653810 1.153635 -0.112872 1.420407 0.530751 1.421444 0.032676 1.128541 1.530326 0.851662 0.568834 -0.029131 1.109353 -0.183737 -0.219083 1.023414 0.677153 1.272442 0.088978 0.599298 0.521683 1.413826 0.024834 0.156538 0.023610 1.364547 1.354715 1.925796 1.201076)
     )

;;; 37 prime --------------------------------------------------------------------------------
(vector 37 8.4775905609131 #r(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.291028 #r(0.000000 1.386217 1.094361 1.257532 0.577473 1.074473 0.649002 1.737811 1.130373 0.024521 1.494005 0.197512 1.617094 0.155699 1.295012 1.066519 0.684029 0.142939 1.826382 1.056446 0.014744 0.023675 0.889872 0.717012 1.430015 0.171959 0.779260 0.605221 1.025774 0.091866 0.523473 -0.085992 1.295536 1.395504 1.915353 1.295483 1.645052)
     )

;;; 38 prime --------------------------------------------------------------------------------
(vector 38 8.5527725219727 #r(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

	7.395907 #r(0.000000 0.229361 1.165787 -0.110257 0.360118 0.958030 0.069946 0.724227 0.169462 0.629891 1.545997 1.736970 0.340776 1.117984 1.362890 -0.333746 0.304546 0.284267 1.101870 -0.220411 1.748591 0.492644 0.009938 0.667006 1.844837 0.974373 0.297199 0.452149 0.892727 0.659717 0.488303 1.523287 0.213584 0.164389 -0.141331 1.392379 0.641595 0.183921)
     )

;;; 39 prime --------------------------------------------------------------------------------
(vector 39 8.8173857964668 #r(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.452083 #r(0.000000 -0.003327 0.916189 -0.059920 1.642633 1.388547 0.951086 0.403885 -0.174730 0.969870 0.918579 1.463076 0.392796 0.310790 1.322505 1.568519 -0.013721 1.080957 1.546749 1.334291 1.196748 1.241477 0.666226 0.658367 0.483066 0.709740 0.970447 1.021587 1.015221 1.154977 1.464323 0.177481 1.236124 1.797764 1.373028 0.022625 0.381731 1.433474 1.548372)
     )

;;; 40 prime --------------------------------------------------------------------------------
(vector 40 8.9134502410889 #r(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.527357 #r(0.000000 -0.041087 1.082980 -0.093124 1.499791 1.383311 0.718904 0.489319 -0.257293 1.006861 0.883213 1.690326 0.205410 0.260914 1.292500 1.587749 -0.303320 1.082377 1.409161 1.434549 1.191417 1.318848 0.621381 0.567262 0.550734 0.858772 1.350282 1.126944 0.892895 1.019108 1.688302 0.184002 1.501241 1.748989 1.428674 0.055963 0.395694 1.443878 1.622997 0.400248)
     )

;;; 41 prime --------------------------------------------------------------------------------
(vector 41 9.1567583084106 #r(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

	7.719171 #r(0.000000 -0.110559 1.169832 0.019267 1.569538 1.391236 0.694144 0.382873 -0.434147 0.899794 0.796750 1.764903 0.072953 0.169200 1.308106 1.377558 -0.321540 1.193116 1.367694 1.264151 1.089800 1.528123 0.443624 0.385073 0.475316 0.761014 1.403127 1.224672 0.762422 1.106345 1.735876 0.113473 1.574540 1.593168 1.251644 0.163982 0.277984 1.443096 1.591883 0.269490 0.133208)
     )

;;; 42 prime --------------------------------------------------------------------------------
(vector 42 9.2193641662598 #r(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

	7.863440 #r(0.000000 0.000769 1.150871 -0.051305 1.664510 1.429789 0.722933 0.399494 -0.606818 0.831602 0.900728 1.776906 0.150722 0.134795 1.253546 1.193712 -0.262236 1.189543 1.508651 1.128437 1.157241 1.619877 0.419663 0.456760 0.533746 0.713555 1.247278 1.303816 0.804519 1.178273 1.682452 0.160111 1.739510 1.661450 1.323262 0.256316 0.252559 1.582882 1.741592 0.288988 0.170566 -0.163586)
     )

;;; 43 prime --------------------------------------------------------------------------------
(vector 43 9.4329051971436 #r(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     7.936372 #r(0.000000 0.547620 0.739031 1.442428 0.549512 0.577585 0.459986 1.527195 1.215306 0.359566 1.254454 1.014209 0.650822 0.596119 0.113760 0.896295 1.336762 1.511746 1.057661 0.208519 1.475881 1.168554 0.473943 0.693948 1.550424 1.853884 0.945372 1.595949 0.778275 1.634785 0.682180 0.046625 1.212650 1.360060 1.301003 1.439535 -0.124409 0.942540 0.731761 1.333209 0.714942 0.471897 0.650290)
     )

;;; 44 prime --------------------------------------------------------------------------------
(vector 44 9.6263332366943 #r(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

	8.065176 #r(0.000000 0.563555 0.779322 1.450405 0.275074 0.391802 0.387823 1.577539 1.258354 0.397778 1.137367 1.281084 0.645440 0.730897 0.278341 0.818073 1.295213 1.625353 1.186058 0.165619 1.608086 1.447235 0.501075 0.919785 1.379913 1.874147 1.032912 1.672344 0.731435 1.654856 0.658603 0.012492 1.389929 1.303561 1.262036 1.561506 0.211052 1.124543 0.750294 1.584352 0.635996 0.491882 0.766257 -0.195962)
     )

;;; 45 prime --------------------------------------------------------------------------------
(vector 45 9.7923860549927 #r(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.154882 #r(0.000000 0.547055 0.828620 1.474483 0.214823 0.306420 0.447495 1.488329 1.261803 0.345092 1.182890 1.386590 0.858672 0.731925 0.282394 0.780789 1.264715 1.682259 1.297583 0.185487 1.597229 1.573595 0.381047 0.857783 1.470813 1.918333 0.941697 1.783877 0.578177 1.822867 0.620428 0.083071 1.307746 1.280532 1.325459 1.568372 0.174238 1.183235 0.845621 1.354666 0.647886 0.538852 0.752105 -0.233702 0.820105)
     )

;;; 46 prime --------------------------------------------------------------------------------
(vector 46 9.7220277786255 #r(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.260478 #r(0.000000 0.440515 0.082713 1.448951 1.078725 0.771700 1.031434 0.396514 -0.027342 1.856363 0.018402 1.350717 1.098982 -0.118233 1.240721 0.493205 0.418152 1.012778 1.839650 0.630433 1.143338 0.246746 0.786146 1.150744 0.946120 0.158315 0.887480 1.385932 1.950117 0.090680 -0.492965 0.491998 1.315319 0.809995 1.210707 0.709458 -0.036266 1.497891 0.868872 0.966405 1.296051 1.252832 1.310296 0.520024 0.516227 1.087381)
     )

;;; 47 prime --------------------------------------------------------------------------------
(vector 47 10.0            #r(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.247198 #r(0.000000 0.355740 0.242039 1.389357 1.131106 0.777738 0.991848 0.374463 -0.088156 1.878905 0.017085 1.432086 1.041936 -0.151670 1.244610 0.482711 0.411519 0.932572 1.984708 0.662503 1.111503 0.232597 0.710598 1.210987 0.961984 -0.005659 0.863659 1.482536 1.845680 0.226808 -0.224546 0.479683 1.343625 0.977816 1.164714 0.894614 0.015854 1.538081 0.814650 0.817623 1.136662 1.395888 1.254222 0.623425 0.572065 1.084636 -0.341926)
     )

;;; 48 prime --------------------------------------------------------------------------------
(vector 48 10.073040962219 #r(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.468134 #r(0.000000 0.334994 1.563192 1.664486 0.442532 0.427441 0.733762 1.689726 -0.011266 0.003688 0.946684 0.784545 0.529116 1.024632 0.761914 0.427223 0.972240 0.316523 -0.022749 0.454239 -0.013268 0.630760 1.620596 1.250013 1.856322 -0.212807 0.823587 1.369668 1.269762 0.685581 1.533564 1.112823 -0.144562 0.600770 1.707468 0.649243 1.377651 0.846771 0.426248 0.926088 1.367077 1.152360 1.849396 1.177150 0.734262 0.957954 0.284186 -0.267591)
     )

;;; 49 prime --------------------------------------------------------------------------------
(vector 49 10.209 #r(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.582839 #r(0.000000 1.015072 1.263701 0.053109 -0.198567 -0.119876 -0.074305 0.688310 -0.022609 -0.056918 -0.335561 1.264545 0.175435 0.115160 0.045329 0.044221 0.357377 1.286502 1.011774 0.136492 0.790313 1.216480 1.412877 1.287840 -0.457032 1.185491 0.632250 1.022556 0.092623 0.762340 0.282587 1.173246 0.884457 -0.232556 1.275664 0.026771 1.001804 1.127230 -0.112893 0.390785 1.060560 -0.011579 0.935318 0.798092 1.155912 -0.045270 0.311662 -0.007451 -0.291556)
     )

;;; 50 prime --------------------------------------------------------------------------------
(vector 50 10.402973175049 #r(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.675945 #r(0.000000 1.487738 1.059001 1.025159 1.326266 1.088841 0.562097 1.657096 1.275489 1.216835 1.254334 1.464943 0.843263 1.800742 0.055052 0.684906 -0.108959 0.041753 1.103420 1.939373 1.165276 1.002506 0.948093 0.181706 0.765909 0.473183 0.975672 0.113670 0.830920 0.097015 1.328852 1.230698 1.944548 0.905867 0.451107 -0.197043 0.836092 1.063417 0.149456 1.602251 0.877744 1.357979 0.922281 1.474686 0.047418 1.602488 0.635135 1.284876 0.058592 1.221991)
     )

;;; 51 prime --------------------------------------------------------------------------------
(vector 51 10.5841327092253 #r(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.651647 #r(0.000000 0.556638 1.587356 0.852726 0.469643 0.042055 1.208512 1.399736 0.760751 -0.012268 -0.323685 1.582069 0.778343 -0.079378 1.972223 0.369847 1.192503 0.823552 1.044143 0.973458 -0.110183 0.024158 0.377921 0.805953 0.568593 0.790820 0.251813 1.523516 0.522377 0.493450 0.360345 1.793822 0.342779 0.174655 1.264727 0.440710 0.362796 0.457837 0.932721 0.365495 1.158324 1.184201 0.095227 1.560717 1.899717 1.167635 1.237541 0.747136 0.193982 0.005527 0.619867)
     )

;;; 52 prime --------------------------------------------------------------------------------
(vector 52 10.64324760437 #r(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     8.817479 #r(0.000000 0.192798 -0.100823 0.105700 1.730433 1.638226 1.781516 0.446103 1.408775 0.715209 0.415865 -0.245030 1.066219 1.674348 0.092550 0.243790 1.271420 0.492458 1.433072 -0.090924 1.409056 0.418163 -0.043783 1.528262 0.043370 1.470310 -0.026080 0.499433 0.961527 0.302716 0.768317 0.686930 1.132134 1.628592 0.701543 1.788137 -0.034028 1.911798 1.160323 1.534119 1.837005 0.994515 0.926867 1.263245 0.147467 1.441753 0.596623 1.430563 0.749640 0.874777 1.097276 0.882051)
     )

;;; 53 prime --------------------------------------------------------------------------------
(vector 53 10.678050692694 #r(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     8.948229 #r(0.000000 0.787671 1.214299 0.345505 0.345590 0.190835 0.899719 1.924062 1.005486 1.819127 1.667353 0.313283 1.676358 -0.196379 0.370203 0.063166 0.527189 0.665913 0.973996 1.778624 1.196159 0.320936 0.633606 -0.058826 1.545537 0.333346 1.131604 1.624560 1.499303 1.035205 0.913874 0.357831 1.867167 0.548213 0.451795 0.773618 0.822115 0.562194 -0.064080 0.250241 1.035409 1.249220 0.799272 1.817083 0.333133 1.343883 0.955871 0.688843 1.459698 0.659209 0.918731 1.093360 0.071038)
     )

;;; 54 prime --------------------------------------------------------------------------------
(vector 54 10.582709312439 #r(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     8.995507 #r(0.000000 0.839135 1.254099 0.463483 0.514525 0.350912 0.899447 0.126295 0.986278 0.081710 1.819693 0.302485 1.593021 -0.282752 0.380427 0.052239 0.519444 0.556490 1.080868 1.545771 1.120954 0.293847 0.936235 0.147086 1.535291 0.575895 1.214419 1.380708 1.495242 1.280520 0.877830 0.287337 1.699747 0.613667 0.574556 0.740251 1.006199 0.542800 -0.075818 0.193623 1.165170 1.401348 0.898072 1.831420 0.345266 1.018036 0.991280 0.598983 1.655723 0.693822 1.150649 0.904779 0.247656 -0.082849)
     )

;;; 55 prime --------------------------------------------------------------------------------
(vector 55 10.806410031758 #r(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.142966 #r(0.000000 0.967967 0.932119 -0.365688 0.605957 0.768411 0.916284 1.389357 0.615451 0.948447 1.347949 -0.020883 0.740497 1.738244 1.630415 1.355535 1.302800 0.208142 1.280645 1.101851 0.623974 0.888122 0.368490 -0.355015 1.472177 1.224855 -1.834858 0.458535 0.318212 1.572912 -0.403676 1.290151 1.207553 1.396897 1.328635 0.637492 0.123034 0.656353 1.219027 0.568146 1.509385 0.321881 0.299954 0.224712 1.667006 0.065718 1.090053 1.794304 0.447059 1.706061 1.555246 -0.117663 1.847453 0.249418 0.005444)
     )

;;; 56 prime --------------------------------------------------------------------------------
(vector 56 10.976176261902 #r(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

	9.111752 #r(0.000000 1.026221 0.818731 -0.610671 0.641008 0.771905 0.862753 1.439699 0.748472 0.833370 1.358412 0.135868 0.775219 1.661446 1.803820 1.421172 1.314079 0.319408 1.356828 1.160309 0.509330 0.960224 0.392092 -0.392072 1.394882 1.222461 -0.085405 0.430754 0.230356 1.841682 -0.419967 1.090454 1.277759 1.613601 1.335900 0.582820 0.127798 0.624304 1.290684 0.637216 1.522455 0.377024 0.425050 0.197535 1.787765 0.141260 1.140648 1.868949 0.494561 1.671471 1.615285 -0.069002 1.824079 0.328533 -0.037887 -0.113326)
     )

;;; 57 prime --------------------------------------------------------------------------------
(vector 57 11.247724533081 #r(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

	9.216795 #r(0.000000 1.072761 0.871199 -0.606073 0.764898 0.818155 0.856948 1.266251 0.788121 0.752453 1.187859 0.151465 0.915565 1.748861 1.701837 1.347840 1.287842 0.215117 1.354195 0.928170 0.565855 0.863918 0.440092 -0.495226 1.605042 1.291620 -1.894193 0.283411 0.299633 1.865832 -0.437707 1.008848 1.124017 1.503496 1.376197 0.470803 0.020499 0.556017 1.215134 0.396497 1.579026 0.315841 0.419729 0.134341 1.733012 0.052783 1.070736 1.848233 0.408553 1.555037 1.556946 0.013508 1.738431 0.466962 -0.002830 -0.264635 0.171355)
     )

;;; 58 prime --------------------------------------------------------------------------------
(vector 58 11.261419321863 #r(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

	9.425110 #r(0.000000 1.014642 0.897681 -0.614752 0.857488 0.672358 0.933264 1.368100 0.738356 0.851112 1.091971 -0.046416 0.783945 1.771194 1.742854 1.472547 1.252201 0.294865 1.370781 0.846564 0.564021 0.837110 0.293848 -0.524970 1.413989 1.388993 -0.083061 0.313273 0.349050 1.659880 -0.480731 1.156810 1.222406 1.439052 1.206808 0.511500 0.038734 0.548247 1.157825 0.466797 1.504635 0.461147 0.331822 0.307462 1.725368 0.053845 1.085006 1.721043 0.438415 1.587368 1.505023 -0.148334 1.858057 0.439342 -0.041501 -0.290056 0.032928 0.094227)
     )

;;; 59 prime --------------------------------------------------------------------------------
(vector 59 11.34253692627 #r(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.417799 #r(0.000000 0.989030 1.275806 0.299889 0.939823 0.448310 0.148809 1.843192 0.023356 -0.063408 1.405105 -0.049862 1.187648 1.091982 0.853309 0.863106 1.359373 -0.018851 1.860938 1.494969 -0.151810 1.541448 0.318470 1.997712 0.738388 0.967399 0.394475 1.599906 1.940413 0.688306 1.198223 1.027861 0.543845 1.170045 1.435957 -0.128548 0.141886 0.974484 1.320679 1.553379 0.657280 -0.006776 1.188506 1.153960 0.797906 1.107872 1.697661 0.579656 0.259938 1.959400 0.997474 0.078631 0.520560 1.756406 0.198078 0.082904 0.134773 0.431815 0.919925)
     )

;;; 60 prime --------------------------------------------------------------------------------
(vector 60 11.512454032898 #r(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     9.529131 #r(0.000000 0.993590 1.164157 0.290844 1.042801 0.369324 0.080143 1.893493 1.949205 -0.095560 1.325881 0.157042 1.109339 1.086368 0.905155 0.977024 1.260686 -0.016062 1.828182 1.614075 -0.014518 1.545044 0.439925 -0.081486 0.578895 1.179965 0.427010 1.706349 0.024219 0.749847 1.267270 0.839364 0.455231 1.246595 1.494210 -0.158936 0.112811 1.066790 1.292394 1.447816 0.800830 0.073649 1.261763 1.207061 0.771891 1.108173 1.623292 0.487925 0.232144 1.880207 1.080714 0.089063 0.391169 1.784626 0.272458 0.159146 -0.056599 0.452568 0.943658 -0.111770)
     )

;;; 61 prime --------------------------------------------------------------------------------
(vector 61 11.850807189941 #r(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     9.597113 #r(0.000000 0.971231 1.304763 0.348110 1.067056 0.387911 0.081123 1.853366 1.983392 -0.039753 1.223396 0.179283 1.164777 1.154984 0.937227 0.823520 1.227844 0.034480 1.818337 1.655061 -0.098774 1.660591 0.459686 -0.048010 0.694006 1.048441 0.467529 1.454975 0.016059 0.770137 1.418302 0.858801 0.431966 1.226715 1.621523 -0.240963 0.187668 1.281591 1.385352 1.562607 0.731351 0.081273 1.114425 1.175335 0.798504 1.208038 1.525646 0.402825 0.416766 1.868720 1.058943 -0.114172 0.285787 1.878637 0.307505 0.055166 0.065670 0.529996 1.046895 0.078416 0.000029)
     )

;;; 62 prime --------------------------------------------------------------------------------
(vector 62 11.709966659546 #r(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

	9.696963 #r(0.000000 -0.126832 0.087192 0.382393 1.557355 0.387687 1.189270 0.660922 1.155295 0.559376 0.807863 -0.103042 0.340858 0.062386 -0.104919 1.226211 0.078110 1.498681 0.933245 0.790005 1.495720 1.419833 1.320095 1.468182 1.807395 0.292395 0.644975 0.868706 0.736750 1.862687 0.041507 1.640983 0.682467 0.630402 1.510321 0.943895 0.394562 1.366941 1.708129 0.624670 0.880953 0.745775 0.285877 -0.038411 0.735668 0.390581 1.472054 0.430218 -0.178134 0.395802 0.288189 1.693314 0.570204 1.312470 0.015755 1.262523 0.253116 0.659738 0.530772 0.136895 0.299742 1.054296)
     )

;;; 63 prime --------------------------------------------------------------------------------
(vector 63 11.975765228271 #r(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.693247 #r(0.000000 -0.214108 0.131421 0.202301 1.638942 0.220854 1.110715 0.697059 1.206875 0.663993 0.745920 -0.122836 0.272685 -0.017037 -0.046871 1.270138 0.138706 1.510472 0.884803 0.722898 1.649368 1.432030 1.208395 1.495491 1.756739 0.407459 0.750264 0.893441 0.644649 1.806450 -0.086753 1.774024 0.679919 0.602645 1.428125 0.942638 0.441081 1.332580 1.671327 0.694821 0.867415 0.710167 0.279926 0.033959 0.788479 0.389797 1.452066 0.352545 -0.215836 0.435427 0.411560 1.777773 0.495583 1.413317 0.048036 1.325135 0.239570 0.625882 0.381467 0.091137 0.245018 1.010220 0.326741)
     )

;;; 64 prime --------------------------------------------------------------------------------
(vector 64 11.932915769505 #r(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     9.904870 #r(0.000000 -0.164225 0.273975 1.461444 0.422513 0.492395 1.248622 0.971394 0.458132 -0.046445 1.414427 0.584229 0.967141 1.558509 0.394722 0.903497 0.940076 0.324113 0.053268 -0.024522 0.041062 0.281887 0.962890 1.227975 0.135414 0.598845 1.556506 0.526124 1.661213 1.420935 0.090290 0.679152 0.391769 1.289421 0.343796 0.304279 0.680212 1.322656 0.808370 1.338618 1.350277 1.651671 0.649112 0.545474 1.151919 1.505597 0.322896 -0.128068 -0.000209 1.363363 0.627954 0.514237 0.047970 1.605733 0.945254 0.790625 0.898519 1.323254 1.650334 0.927509 0.574149 0.657507 0.234406 0.524987)
     )

;;; 65 prime --------------------------------------------------------------------------------
(vector 65 12.264873504639 #r(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

	10.031321 #r(0.000000 -0.272551 0.376749 1.333244 0.218725 0.345977 1.314485 0.982213 0.427625 -0.065599 1.515427 0.508158 0.913799 1.657763 0.172645 0.893548 1.045679 0.355730 0.027581 0.041761 0.082561 0.209873 0.920555 1.285192 0.041833 0.572322 1.559879 0.525050 1.767677 1.615275 0.160499 0.644324 0.441443 1.110153 0.327368 0.527348 0.566684 1.364227 0.733403 1.384463 1.363114 1.623118 0.669559 0.652798 1.037660 1.423834 0.345719 -0.269580 0.049255 1.244435 0.520436 0.525551 0.012583 1.505200 0.886496 0.816798 0.876113 1.467201 1.600992 0.961581 0.410364 0.759664 0.138406 0.484445 0.049688)
     )

;;; 66 prime --------------------------------------------------------------------------------
(vector 66 12.090668678284 #r(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.040611 #r(0.000000 -0.405880 0.403815 1.296291 -0.023571 0.665033 1.385081 1.219553 0.309245 0.020606 0.300153 0.822670 1.338967 0.273696 1.044177 0.099862 1.487075 1.221027 -0.344403 -0.045799 0.094066 1.108269 0.044014 0.617491 0.852992 0.558738 1.622399 0.310181 0.588841 0.323443 0.414056 -0.129711 0.220239 1.055039 0.615124 0.167536 0.224686 1.003767 1.449721 1.185187 1.215242 0.034353 1.113707 1.123233 1.095536 1.625500 0.489513 1.839019 -0.309733 0.833070 0.569096 1.721184 1.298143 0.637885 1.087460 1.191842 1.159182 0.195251 0.633434 0.099181 0.758141 0.218475 1.417590 0.992859 -0.046035 0.285532)
     )

;;; 67 prime --------------------------------------------------------------------------------
(vector 67 12.20425496356 #r(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

	10.265959 #r(0.000000 -0.317437 0.528596 1.208530 0.019668 0.509206 1.284064 1.148532 0.419242 -0.198735 0.425155 0.767445 1.408450 0.160053 1.092975 0.032386 1.619472 1.183809 -0.361482 0.071106 0.009871 1.093315 0.027109 0.560654 0.879407 0.374417 1.487442 0.453563 0.647125 0.176974 0.322367 -0.143328 0.282015 1.077805 0.896816 0.316444 0.296705 1.010969 1.434391 1.469703 1.337586 0.187007 1.082850 1.009796 0.918602 1.416386 0.666312 1.700486 -0.149081 0.977019 0.786356 1.876858 1.104648 0.776752 1.040755 1.317706 1.081692 0.200422 0.704910 0.071311 0.744990 0.367563 1.551133 0.626292 0.053508 0.492611 -0.327592)
     )

;;; 68 prime --------------------------------------------------------------------------------
(vector 68 12.466281890869 #r(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

	10.261600 #r(0.000000 1.771081 1.184318 1.217409 1.329949 0.267230 1.509883 1.778448 0.681595 0.738174 1.861103 1.336495 1.215872 0.818117 0.255500 0.299960 0.113725 -0.077146 1.405250 0.666595 0.037892 0.067257 0.915472 0.235386 0.607945 1.117038 0.060775 -0.156333 1.956471 1.527902 0.871638 -0.006865 1.033595 1.874143 0.354606 1.054570 1.217089 1.263859 1.531522 0.948658 1.506335 1.858536 0.864867 -0.107940 0.824426 0.664413 0.614081 -0.522301 0.170031 0.618192 1.363753 1.018532 0.255610 0.918599 1.224294 1.455436 0.286646 1.200372 1.019211 1.039060 1.103305 0.582967 1.867745 -0.265217 1.084430 0.130212 1.269409 1.132275)
     )

;;; 69 prime --------------------------------------------------------------------------------
(vector 69 12.29846572876 #r(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.358295 #r(0.000000 1.762304 1.329967 1.274727 1.243024 0.209299 1.634178 1.655523 0.780487 0.675373 0.009379 1.466876 1.260691 0.892375 0.253485 0.204944 0.184632 -0.020054 1.479361 0.680774 1.947746 0.085018 0.887454 0.202001 0.508666 1.061812 1.760817 -0.258898 1.789067 1.670818 0.746822 1.923843 1.147917 1.717791 0.387724 1.021038 1.318304 1.434180 1.603007 0.933831 1.516314 1.736887 0.932240 -0.250999 0.908525 0.598332 0.699524 -0.251071 0.060976 0.494007 1.385962 1.112068 0.358110 0.879637 1.108400 1.579544 0.192858 1.157165 1.062829 1.022502 1.013651 0.487217 1.715356 0.029780 1.002970 0.289498 1.337863 1.300987 0.690487)
     )

;;; 70 prime --------------------------------------------------------------------------------
(vector 70 12.665026664734 #r(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.362146 #r(0.000000 0.645075 0.144761 -0.255891 0.476895 1.023278 0.226232 1.569382 1.010047 1.598756 1.002276 1.069510 0.991228 0.875395 0.620600 0.146676 0.001456 0.640256 0.920988 0.405395 0.929569 1.637203 1.048641 -0.005834 1.951040 1.773501 1.763294 0.813650 1.073299 1.971995 1.378517 0.509283 -0.138231 0.486487 0.186594 0.024921 1.361733 -0.054931 0.452684 1.768706 1.403207 0.493486 0.160262 0.623486 1.333422 1.171179 1.417368 1.493662 1.431973 1.962729 0.473768 1.578443 0.146983 0.257457 0.922711 -0.127966 1.530877 0.689093 1.402346 0.698388 0.371420 0.673779 1.623279 0.869055 0.060960 1.114977 0.136968 0.887721 0.930015 0.191902)
     )

;;; 71 prime --------------------------------------------------------------------------------
(vector 71 12.609085083008 #r(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.407485 #r(0.000000 0.658867 0.945182 1.008506 1.648242 0.849410 0.789076 0.860371 0.625610 0.678091 0.677156 0.952896 1.661882 0.468446 0.648245 0.553746 1.164588 1.217555 1.304818 1.253766 0.415819 0.177362 0.870813 0.537584 0.684099 1.231697 0.205944 0.313681 0.033795 1.304229 0.634137 1.288505 1.050312 0.068587 0.578801 1.748737 1.670966 0.963745 0.157496 0.747319 1.117879 0.224088 1.431805 0.565143 0.847971 1.619314 1.299282 0.286944 1.729721 0.792086 0.957060 0.103543 1.002065 0.024409 1.327043 0.059946 1.189105 1.073824 0.296154 0.377112 1.822909 0.902196 1.929038 1.562848 0.385236 0.148366 0.174788 0.969726 0.746509 1.400690 1.282292)
     )

;;; 72 prime --------------------------------------------------------------------------------
(vector 72 12.708446502686 #r(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     10.496982 #r(0.000000 1.577140 1.146293 -0.139228 1.523478 1.074777 1.483287 0.662248 1.518460 1.358355 0.041669 -0.050825 1.633955 0.197302 1.628681 1.406765 1.599699 0.116714 0.102433 1.063359 -0.147037 1.816452 1.121083 0.122390 0.742457 0.181771 1.441622 0.172190 0.732537 0.047111 0.764854 1.749139 1.387157 -0.078027 1.839767 1.313819 1.301810 0.133381 1.152104 1.136084 1.760093 -0.040936 1.318430 0.739766 1.052638 0.175449 1.273552 0.687602 1.060057 0.117723 0.884432 1.344726 -0.002641 1.640974 1.031637 0.883501 1.787709 0.532454 0.578078 0.643118 0.404748 0.878255 1.298175 0.117038 1.624847 1.295336 0.039560 0.420808 -0.013827 0.878965 1.254788 0.161686)
     )

;;; 73 prime --------------------------------------------------------------------------------
(vector 73 12.877750118249 #r(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     10.424692 #r(0.000000 1.554014 1.052186 -0.086200 1.476351 1.224926 1.580661 0.637756 1.422927 1.516582 -0.013111 -0.069153 1.566827 0.301765 1.594981 1.454270 1.439078 0.053331 0.299149 1.030104 -0.048066 1.777424 0.985794 0.000633 0.702766 0.173634 1.368758 0.222346 0.786334 0.080834 0.716179 1.776274 1.616019 -0.113541 1.676208 1.494328 1.439541 0.055619 0.983919 1.123924 1.848565 -0.036510 1.436326 0.574953 1.019118 0.214244 1.115597 0.860645 1.198449 0.197190 0.778351 1.383645 -0.195100 1.543792 1.148480 0.893946 1.917170 0.612713 0.688674 0.645993 0.415091 1.119089 1.442261 0.184218 1.468700 1.212357 0.199763 0.454337 0.103961 1.020748 1.089579 0.296783 -0.106516)
     )

;;; 74 prime --------------------------------------------------------------------------------
(vector 74 13.115156173706 #r(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     10.645980 #r(0.000000 0.311650 1.280848 0.611958 0.562391 0.394077 0.103205 0.008568 0.817187 1.367252 0.596140 1.287960 0.175350 1.148539 1.041198 0.821079 0.245783 0.725100 -0.171308 1.536345 0.020047 1.082763 1.136937 1.647863 1.919963 1.278757 -0.129192 1.538754 0.220953 1.263827 0.945051 0.419785 0.111579 0.140279 -0.056385 -0.214011 0.504195 0.169718 1.297017 -0.039788 0.085951 0.026379 -0.042190 1.504313 1.415242 1.036770 1.935911 1.763171 0.268139 0.498510 0.658810 0.698991 1.452795 1.747788 0.995160 1.796367 1.535056 0.043981 0.090892 1.265806 0.402298 0.496068 1.847177 1.828232 0.685895 0.730616 1.243411 0.093164 1.207951 1.153047 -0.163119 0.756812 -0.182692 0.296379)
     )

;;; 75 prime --------------------------------------------------------------------------------
(vector 75 13.254356384277 #r(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     10.728934 #r(0.000000 0.319906 1.183822 0.470461 0.553071 0.558322 0.240393 0.036866 0.834403 1.306075 0.639501 1.156931 0.131640 1.232771 0.859368 0.705663 0.237380 0.745032 -0.025724 1.667265 -0.112461 1.089983 1.220375 1.725435 1.917328 1.264565 0.041607 1.662792 0.234857 1.186979 1.051440 0.530773 -0.049988 0.142301 -0.159714 -0.311512 0.553213 0.109766 1.263045 0.012668 0.132405 0.025382 -0.046342 1.549557 1.414619 1.136704 1.834421 1.703381 0.363733 0.499672 0.660724 0.818632 1.487689 1.724136 0.974920 0.033975 1.567287 0.122631 0.037040 1.212978 0.445691 0.550630 1.935380 1.805163 0.633422 0.566599 1.268418 0.116152 1.266782 1.256257 -0.199735 0.730751 -0.178681 0.296223 0.384273)
     )

;;; 76 prime --------------------------------------------------------------------------------
(vector 76 13.288178191792 #r(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     10.773166 #r(0.000000 0.201922 1.470715 0.636128 0.479807 0.182336 0.489746 -0.031316 0.670193 1.592382 1.066940 0.948022 -0.036816 1.198638 1.350990 0.747493 0.325762 0.715896 -0.102405 1.561943 0.009585 1.062252 1.395815 1.768190 -0.043534 1.482072 -0.001794 1.483462 0.157255 1.169128 1.009563 0.483780 0.060058 0.224370 -0.093213 -0.150562 0.299988 0.186265 1.109939 0.037835 0.063477 0.120364 -0.104932 1.261680 1.363550 1.249465 -0.070936 1.540722 0.209914 0.543128 0.585021 0.745504 1.384715 1.632179 1.125276 -0.108742 1.334210 -0.037982 -0.082542 1.084030 0.463687 0.200417 1.666770 1.741346 0.354672 0.872840 1.236363 -0.005541 0.889944 1.400912 -0.351050 0.975108 -0.113186 0.166344 0.530700 -0.174117)
     )

;;; 77 prime --------------------------------------------------------------------------------
(vector 77 13.158900260925 #r(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     10.787093 #r(0.000000 1.149443 0.839971 1.956305 0.168601 1.427588 1.800892 0.609682 0.814947 0.631205 0.873403 1.488539 1.665370 -0.309318 0.332414 0.201227 1.240570 0.267709 0.720021 0.301507 1.431244 0.535840 1.193228 1.164152 0.191654 1.320111 1.339133 0.720237 0.902284 -0.025313 0.876522 -0.150998 0.539439 0.632152 0.598019 0.925249 0.453321 -0.170091 0.923681 0.879763 -0.459931 0.014839 0.344599 0.118045 0.294786 1.397001 0.097630 -0.060819 0.573635 0.376236 0.149790 1.819557 0.472911 0.520765 1.611957 1.363729 1.059191 1.015359 0.784191 0.007017 0.526385 0.177402 0.653955 0.630819 1.506190 1.214284 0.142017 1.368482 0.988751 0.343026 1.474912 0.576723 1.482195 0.984766 -0.259805 1.708315 0.031304)
     )

;;; 78 prime --------------------------------------------------------------------------------
(vector 78 13.498236182018 #r(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     10.978554 #r(0.000000 1.096768 0.888550 1.947239 0.181155 1.436514 1.814166 0.609633 0.891320 0.659350 0.972721 1.468447 1.646059 -0.390883 0.349403 0.190468 1.286125 0.375446 0.793806 0.337362 1.378321 0.647016 1.173848 1.022068 0.190156 1.504099 1.351392 0.578668 0.934287 -0.058591 0.870464 -0.121287 0.523546 0.687399 0.529897 0.922200 0.431176 -0.056191 0.754863 0.891222 -0.326946 0.005264 0.363921 0.137521 0.399466 1.549811 0.144317 1.805962 0.610952 0.389712 0.143450 1.855414 0.481342 0.544731 1.670447 1.340333 1.179027 1.030541 0.783467 1.922631 0.500265 0.196650 0.571085 0.717767 1.534607 1.401419 0.181832 1.507521 1.055075 0.386262 1.543298 0.667522 1.460252 0.875356 -0.193185 1.822363 -0.120925 -0.088087)
     )

;;; 79 prime --------------------------------------------------------------------------------
(vector 79 13.178678233398 #r(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     10.999617 #r(0.000000 1.347638 1.481865 1.267885 0.720556 1.195414 0.753438 1.098720 0.495501 1.797982 1.642962 0.601320 0.733508 1.623968 0.011622 0.555415 1.687686 0.033994 0.666502 1.354310 -0.062776 1.702810 0.530396 0.338013 0.545697 0.903827 1.624803 0.452440 0.102085 0.589641 1.075934 1.462201 0.377420 0.723141 1.637868 1.442214 1.376332 0.574016 1.429444 0.048675 1.824423 0.994761 1.202853 -0.088838 1.572593 0.683487 0.821830 0.608958 -0.019919 1.128671 1.564127 -0.024601 0.496124 -0.264208 0.364120 0.445910 1.094455 1.000778 -0.275483 -0.106836 -0.068847 1.489050 0.299418 1.609451 0.481299 0.720974 0.061435 0.470166 1.313720 1.731595 -0.046698 0.033686 1.464911 1.633519 1.188988 1.851117 1.709574 1.472512 0.989145)
     )

;;; 80 prime --------------------------------------------------------------------------------
(vector 80 13.547472953796 #r(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     11.124609 #r(0.000000 1.320780 1.601769 1.212780 0.925936 1.150272 0.779842 1.132278 0.433186 0.139791 1.855510 0.984204 0.587965 1.275520 -0.336181 0.027669 1.507412 0.083629 0.532076 1.243939 0.164559 1.877439 0.451029 0.134435 0.917256 1.191050 1.717198 0.311344 0.139463 0.522509 0.832256 1.355200 0.464307 0.658935 1.684435 1.657016 1.566402 0.678177 1.345914 -0.411327 1.726908 1.256822 1.382264 0.197288 1.663654 0.681666 0.826275 0.390159 -0.131622 0.991840 1.745403 0.052203 0.397755 -0.135974 0.449565 0.653214 0.884195 1.036845 -0.214613 -0.022842 -0.045826 1.524990 0.542288 1.697273 0.124559 0.683912 0.114180 0.529112 1.689881 1.816455 0.164399 -0.036640 1.454681 1.789629 1.043242 1.803429 -0.026605 1.256594 0.922085 0.128868)
     )

;;; 81 prime --------------------------------------------------------------------------------
(vector 81 13.652944564819 #r(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     11.310930 #r(0.000000 1.338496 1.618662 1.258204 0.891699 1.165718 0.809579 1.213708 0.463435 1.847107 1.877094 0.887680 0.518124 1.428458 -0.093788 0.177741 1.547353 0.147919 0.591101 1.362498 0.128273 1.749927 0.385360 0.363540 0.893754 1.012364 1.709135 0.377311 0.132445 0.548112 0.972027 1.427773 0.398203 0.797906 1.737369 1.502566 1.622093 0.644136 1.374056 -0.140256 1.875110 1.255940 1.364448 0.121294 1.485291 0.710718 0.734848 0.549536 -0.134214 1.064920 1.565350 -0.009589 0.522300 -0.211877 0.234875 0.550469 0.900507 1.016853 -0.289771 -0.050216 0.013259 1.497164 0.470306 1.682199 0.310878 0.400752 -0.073850 0.501083 1.721610 1.757416 0.086836 -0.012437 1.234361 1.696764 1.030486 1.800768 1.816277 1.295973 0.965902 -0.050332 0.065058)
     )

;;; 82 prime --------------------------------------------------------------------------------
(vector 82 14.126787045134 #r(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.386457 #r(0.000000 1.184234 0.006185 1.471909 -0.020737 1.446959 0.527864 1.725003 0.958833 -0.183759 1.087116 0.362689 1.480740 0.156332 0.170868 1.516744 1.299390 1.020445 0.102346 0.190152 1.932659 0.191092 1.540988 0.054252 0.058332 1.143228 0.532621 1.103901 0.155802 0.259232 0.085821 -0.014535 0.917981 0.747767 1.437555 0.498491 1.005960 0.024742 0.278586 0.123254 0.358645 1.153761 0.644707 1.717819 1.457212 -0.016722 1.757337 0.168836 0.613830 0.731386 0.184591 0.125826 0.694463 -0.160662 0.133275 0.594504 1.448950 1.320971 1.379627 0.024099 0.749678 1.395049 1.707113 0.063661 0.577678 1.276404 1.735192 1.396486 0.777297 0.406175 1.037567 1.241034 0.810533 1.704071 0.626515 1.230799 0.928665 0.102631 -0.064751 0.376824 0.691188 0.213400)
     )

;;; 83 prime --------------------------------------------------------------------------------
(vector 83 14.019070339131 #r(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.400086 #r(0.000000 0.459417 1.478222 0.664125 0.852104 1.386067 1.283493 0.160768 1.308022 1.604094 1.126193 1.566269 1.568738 1.342738 0.419858 1.658792 -0.011036 1.552713 0.806931 0.444376 0.128892 -0.001775 0.815035 1.540336 0.477288 0.476633 -0.083853 0.616178 1.184762 1.390709 -0.175824 1.637740 -0.077982 1.657633 1.020322 1.773148 0.845120 1.747456 0.992318 1.275075 1.939061 0.605573 1.185358 0.167572 0.913732 0.299104 1.406457 0.569969 1.649279 0.703090 0.103735 0.654783 0.341905 0.575994 1.616954 1.462440 1.014559 1.425017 1.529452 0.557680 0.075790 0.545195 0.626721 0.258881 0.008660 0.415987 0.379632 1.492871 1.695672 0.532611 1.883431 0.970952 0.710469 0.791296 1.620061 1.265893 0.186190 1.675885 1.429872 0.222912 0.694823 1.504249 0.295556)
     )

;;; 84 prime --------------------------------------------------------------------------------
(vector 84 14.024940956301 #r(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     11.487189 #r(0.000000 1.278944 1.148531 1.401192 0.987704 1.327417 0.829579 -0.354298 -0.446197 0.541522 0.846600 1.167524 0.744313 0.737800 0.828061 -0.053765 1.861119 1.325767 0.672993 0.966357 1.445826 1.688836 -0.450107 1.471053 0.516894 0.367519 1.174937 0.437379 0.853702 0.209199 1.035157 0.082435 1.740685 0.596247 0.399331 0.200076 1.109361 0.675003 0.521122 0.756143 0.565837 1.380232 -0.008543 1.422785 0.040780 0.501067 0.990564 0.571111 1.127444 1.211055 0.008227 1.058879 -0.148477 1.162238 0.462774 -0.644672 0.689412 0.695705 1.693384 0.526716 1.043108 0.834911 0.565280 0.892133 0.579137 1.124242 -0.026948 1.358422 0.140470 0.718068 0.974714 0.118003 -0.283224 1.394974 1.520860 0.584840 0.604388 1.176504 0.054703 0.967857 1.645062 0.782868 0.226688 0.643857)
     )

;;; 85 prime --------------------------------------------------------------------------------
(vector 85 14.253310943921 #r(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     11.570507 #r(0.000000 0.047594 0.231800 1.737716 0.592145 1.652212 1.192054 1.567404 1.046450 1.723115 0.587946 1.782686 0.701038 0.897285 1.336786 -0.109574 1.277555 1.261601 1.545663 1.233661 1.363878 0.922445 0.511703 1.220970 -0.070567 0.088051 0.176020 1.072453 0.914377 1.232116 0.840227 0.412088 0.628076 1.768879 1.075555 1.220311 1.034101 1.263906 1.221853 1.406941 0.716926 0.235511 0.642674 1.462473 0.183537 -0.009850 0.175206 1.304723 0.625192 1.685015 0.888960 0.987176 0.229156 0.906130 -0.208521 0.759860 0.236964 1.148836 1.618089 1.690238 1.469450 -0.451721 1.792831 1.505055 1.723875 -0.409424 0.740127 1.856282 1.278624 1.171755 0.169482 0.793153 1.150142 -0.196592 1.722287 0.369994 -0.051653 0.593145 0.312913 0.205677 1.134911 1.617687 0.708755 -0.258596 -0.058071)
     )

;;; 86 prime --------------------------------------------------------------------------------
(vector 86 14.017106967247 #r(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

	11.464026 #r(0.000000 1.241236 0.735036 1.768547 1.022146 1.158298 1.183137 0.968670 1.691321 0.680729 0.175789 0.559083 1.034407 0.262233 0.715208 0.394477 0.568287 1.225764 0.839690 0.246790 0.703772 0.272543 0.240951 1.762450 0.355652 1.467532 0.066482 1.711928 0.362496 1.105319 1.848902 0.391341 1.590736 0.360815 0.274201 1.466380 0.854785 1.225119 0.526056 0.183082 1.503310 1.755183 1.757420 1.681676 1.139772 0.722094 0.514930 -0.299099 1.017929 1.152013 0.153296 1.883541 1.305369 0.813266 1.721262 0.869359 0.984240 1.647146 1.176821 0.799554 0.018930 0.425544 1.045905 1.125325 1.538483 1.465973 0.064269 0.652429 -0.179189 0.307284 0.665917 1.822483 0.377774 1.365596 0.523452 1.459586 1.934048 0.590056 1.391427 0.798023 0.719605 0.666459 1.328349 1.280789 1.829329 1.518014)
     )

;;; 87 prime --------------------------------------------------------------------------------
(vector 87 13.98394199918 #r(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

	11.586549 #r(0.000000 1.319934 0.683556 1.736385 1.027728 1.173837 1.184698 0.961791 1.704376 0.843318 0.132911 0.584467 1.141938 0.321037 0.779862 0.299234 0.629450 1.094141 0.844655 0.288940 0.660398 0.439375 0.314691 1.666921 0.322593 1.512703 0.231385 1.704505 0.421557 1.039389 1.946760 0.308796 1.609358 0.203579 0.177237 1.506281 0.894308 1.216342 0.501064 0.160715 1.429269 1.812129 1.767937 1.687170 1.113267 0.850769 0.563496 -0.346176 0.899849 1.098438 0.221013 1.948980 1.291389 0.764823 1.684795 1.017892 1.076383 1.610312 1.306587 0.796716 1.904904 0.399772 1.098544 1.053384 1.502425 1.612650 0.040403 0.594147 -0.060080 0.267263 0.625776 1.885933 0.279953 1.237545 0.539981 1.187985 1.832449 0.645047 1.471522 0.838324 0.594444 0.547162 1.351894 1.374768 1.850180 1.530619 -0.004121)
     )

;;; 88 prime --------------------------------------------------------------------------------
(vector 88 14.825139803345 #r(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     11.779236 #r(0.000000 1.385571 0.664473 1.673357 1.051668 1.283568 1.183264 1.016197 1.723437 0.762491 0.080885 0.614460 1.223750 0.274564 0.777149 0.392993 0.636161 1.138986 0.921669 0.256330 0.732496 0.422658 0.283548 1.588340 0.390676 1.581671 0.216287 1.805018 0.433400 1.120574 1.990633 0.309428 1.679712 0.246719 0.166510 1.528330 0.978160 1.240452 0.514802 0.152836 1.444098 1.821338 1.741079 1.773767 1.043953 0.834341 0.516037 -0.399761 0.912297 1.152952 0.174890 0.026661 1.322705 0.774691 1.684626 1.143688 1.039299 1.661069 1.354440 0.852909 1.920418 0.430453 1.107020 1.077494 1.563179 1.550268 -0.081456 0.683010 -0.070683 0.331375 0.596427 1.840076 0.338343 1.322910 0.555709 1.250193 1.863877 0.674355 1.444116 0.822161 0.611094 0.594036 1.361289 1.319723 1.893231 1.511485 -0.082819 0.004110)
     )

;;; 89 prime --------------------------------------------------------------------------------
(vector 89 14.69031483888 #r(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

	11.717244 #r(0.000000 1.280725 0.700931 1.629705 1.163151 1.211354 1.207252 1.060983 1.712704 0.662868 -0.016763 0.498571 1.267459 0.312897 0.767566 0.410010 0.682476 1.218973 1.054977 0.335114 0.679822 0.393095 0.285333 1.677466 0.239158 1.657543 0.032877 1.927114 0.412277 1.077579 0.008670 0.301197 1.684983 0.240202 0.156897 1.606919 0.823204 1.224785 0.501380 0.130080 1.461540 1.762701 1.835008 1.675241 1.038261 0.735592 0.567192 -0.407994 0.837736 1.380388 0.177627 -0.022504 1.469278 0.779168 1.535080 1.038856 0.995420 1.647674 1.355912 0.876113 0.054090 0.389662 1.144932 1.056502 1.575441 1.489827 -0.110244 0.716187 -0.131679 0.333903 0.610945 1.724426 0.397732 1.321937 0.382935 1.129101 1.811728 0.678299 1.566954 0.796249 0.670060 0.655543 1.461691 1.275113 1.756029 1.461135 -0.299838 -0.035286 0.000240)
     )

;;; 90 prime --------------------------------------------------------------------------------
(vector 90 14.831111851861 #r(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     11.912133 #r(0.000000 0.295712 1.924134 1.102711 1.258491 0.655490 0.233606 0.562419 0.577314 0.632614 0.292405 -0.084904 0.103609 1.039094 1.755503 1.172227 1.558895 1.337789 0.448041 1.796123 0.172510 1.807372 -0.491145 0.629670 1.374427 1.153094 0.616329 -0.053298 0.403635 0.735639 1.493646 0.116327 0.090075 1.481935 0.130430 -0.397420 1.233888 1.562837 1.394427 0.128040 0.210130 1.932562 0.520409 0.942154 0.267851 0.963653 0.054884 0.473092 0.533764 1.151850 -0.040189 0.363108 1.692404 0.346942 -0.004031 1.015616 1.463315 0.200587 0.955072 1.110273 1.335599 1.428423 1.081405 -0.049992 1.445447 1.638388 0.526262 1.510920 1.171630 1.164614 0.725199 0.226330 1.393808 0.311586 0.473319 1.119278 0.297872 1.619448 0.180200 1.017719 0.929579 1.238549 -0.152938 -0.389723 1.510223 0.312498 0.583698 -0.128512 1.118858 0.985015)
     )

;;; 91 prime --------------------------------------------------------------------------------
(vector 91 14.702056847646 #r(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.005512 #r(0.000000 1.651241 0.444566 0.771625 1.531712 1.198061 -0.075541 1.024232 0.878160 1.764014 1.110831 1.171988 0.516936 1.573556 1.509878 0.887013 1.204556 1.260211 1.922615 -0.106610 1.659440 1.207522 1.319936 0.598417 0.947770 0.756571 1.701721 1.711519 1.436972 1.354686 1.045437 0.618946 0.360660 0.540310 0.351882 1.468011 1.786426 -0.045242 0.583531 0.526973 -0.138692 -0.109290 0.457740 0.492089 0.832424 0.138243 1.544530 1.158393 0.042019 0.651909 1.055394 0.883264 0.532481 -1.796526 0.765266 1.478173 0.465799 0.524616 1.362828 1.848044 0.632240 0.417874 1.728531 0.317673 0.097887 1.442328 1.043851 1.808197 0.788887 1.389306 0.336167 1.583046 0.569695 0.637215 0.465113 0.906724 1.648099 0.956210 1.552949 0.544663 -0.375029 1.060183 1.661887 0.376416 0.219900 0.491420 0.646255 0.613573 1.507134 -0.042573 0.568037)
     )

;;; 92 prime --------------------------------------------------------------------------------
(vector 92 14.556435035882 #r(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     11.877855 #r(0.000000 1.210566 1.165458 1.121122 1.468751 1.350806 0.381108 0.005657 1.301872 0.731228 1.701228 0.340603 0.558577 0.787433 1.276245 0.094125 0.616680 -0.528180 0.350744 -0.104084 1.777542 0.362375 0.354377 1.192179 1.842554 0.690240 -0.393950 0.864057 1.460941 0.264834 0.679653 0.766512 1.109010 1.820027 1.005059 1.830643 0.134223 1.080423 0.604179 1.319716 0.616568 0.256271 0.535399 0.013864 1.542324 1.179659 0.903596 1.662664 0.451213 1.363088 1.761960 0.837868 1.397463 1.566422 1.273397 -0.394761 1.438427 0.394046 0.062520 0.518580 0.773837 0.955436 1.291318 1.259097 0.665933 1.510701 0.236023 1.200046 1.171018 1.681527 0.481703 1.427191 1.404788 -0.008075 1.449404 1.021868 0.991665 1.591708 0.978766 -0.053484 -0.351363 1.157026 1.402841 1.476697 0.436354 0.550532 0.639080 0.644485 0.199895 0.998273 0.718061 1.062147)
     )

;;; 93 prime --------------------------------------------------------------------------------
(vector 93 14.994668960571 #r(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     11.931432 #r(0.000000 1.127121 1.091593 1.074474 1.518423 1.420959 0.367784 -0.031145 1.245698 0.718599 1.759333 0.327616 0.650594 0.826820 1.252842 0.094439 0.598513 -0.628081 0.312528 -0.042538 1.709518 0.360880 0.417736 1.158073 1.859130 0.742443 -0.590341 0.883615 1.547983 0.331996 0.607099 0.858658 0.982640 1.780772 1.053553 1.779575 0.248732 1.238805 0.629558 1.331255 0.542830 0.166132 0.543100 0.084654 1.514081 1.107074 0.941695 1.619752 0.544647 1.387487 1.785411 0.861481 1.504001 1.648884 1.253810 -0.229729 1.410403 0.327050 0.103463 0.711689 0.750628 0.980202 1.376285 1.250430 0.632392 1.537616 0.141022 1.212057 1.154123 1.625689 0.577285 1.439125 1.351858 -0.078966 1.506889 1.067426 0.976028 1.474839 1.064130 1.937182 -0.294264 1.134037 1.342796 1.406874 0.460202 0.605755 0.645016 0.599008 0.283392 0.923416 0.764482 1.047804 -0.027728)
     )

;;; 94 prime --------------------------------------------------------------------------------
(vector 94 14.811392756555 #r(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     12.039867 #r(0.000000 1.163143 1.161083 1.093199 1.398300 1.449119 0.387961 0.071427 1.173653 0.777504 1.839154 0.480970 0.522291 0.745054 1.342896 -0.020107 0.568328 -0.651866 0.357752 -0.014711 1.835249 0.496435 0.418724 1.152305 1.795834 0.708935 -0.592375 0.933199 1.551256 0.389748 0.544420 0.867394 1.090317 1.658422 1.120042 1.703238 0.225754 1.197005 0.664119 1.370027 0.473717 0.214265 0.446118 -0.072983 1.476632 0.989164 0.953275 1.594405 0.549095 1.292729 1.873770 0.872278 1.405847 1.663213 1.256098 -0.199312 1.319388 0.356180 0.120935 0.788385 0.811552 0.931082 1.417384 1.241505 0.594483 1.592893 0.193066 1.211361 1.221325 1.659817 0.474480 1.333636 1.210328 -0.124443 1.530145 1.131446 1.011938 1.591791 1.073428 1.967082 -0.331623 1.310196 1.335881 1.601048 0.467407 0.625093 0.643995 0.702560 0.207840 1.003335 0.746432 1.003123 -0.053679 0.114317)
     )

;;; 95 prime --------------------------------------------------------------------------------
(vector 95 15.240 #r(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     12.085973 #r(0.000000 1.051805 1.172878 1.115700 1.412260 1.325611 0.499389 -0.036446 1.052256 0.638910 1.858010 0.428120 0.610340 0.574378 1.213105 0.057642 0.461255 -0.702131 0.358412 0.080575 1.891003 0.407921 0.587854 1.077994 1.870697 0.522480 -0.552282 0.950002 1.630848 0.392631 0.613853 0.918004 0.863708 1.749803 0.965026 1.725834 0.251058 1.191313 0.694563 1.611859 0.559459 0.167869 0.627250 -0.015454 1.489839 0.990103 0.944176 1.626018 0.650652 1.232827 1.765054 0.859916 1.420522 1.716270 1.115562 -0.114393 1.292712 0.223680 0.003774 0.768222 0.735201 0.886167 1.260079 1.124375 0.438782 1.549520 0.089996 1.236122 1.117280 1.706151 0.552850 1.387827 1.287434 -0.091122 1.500029 1.010908 1.040008 1.475584 1.110947 -0.009051 -0.277962 1.163770 1.335007 1.420313 0.336117 0.544373 0.542753 0.653465 0.204590 0.887577 0.653739 1.057824 0.023942 0.239543 0.184376)
     )

;;; 96 prime --------------------------------------------------------------------------------
(vector 96 15.135 #r(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

	12.199936 #r(0.000000 1.057070 1.168403 1.279698 1.305467 1.427690 0.284624 0.063843 1.158156 0.731570 1.801436 0.514179 0.471915 0.592595 1.283363 0.093271 0.462847 -0.643024 0.124469 -0.030329 0.002025 0.412664 0.447766 1.041076 1.707064 0.717467 -0.512284 0.780656 1.581528 0.287680 0.583757 0.869173 0.918739 1.754902 1.087257 1.609192 0.253430 1.202826 0.677531 1.478840 0.506589 0.221143 0.449961 -0.108901 1.639360 1.050325 0.931390 1.575674 0.732211 1.310985 1.809082 0.891881 1.467344 1.772534 1.327387 -0.267949 1.294273 0.307121 -0.000928 0.916266 0.835065 0.921478 1.494051 1.124128 0.600086 1.401394 0.276359 1.282207 1.154283 1.594188 0.463942 1.350153 1.301110 -0.054319 1.584220 1.067957 0.890998 1.521460 0.980615 -0.012774 -0.269298 1.362294 1.193879 1.611540 0.313832 0.554379 0.505548 0.863801 0.115881 1.005711 0.641624 1.114631 0.025081 0.276327 0.191620 -0.121824)
     )

;;; 97 prime --------------------------------------------------------------------------------
(vector 97 15.404807595571 #r(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

	12.293759 #r(0.000000 1.123215 1.042761 1.137088 1.251671 1.322523 0.434841 -0.033155 1.094870 0.682795 1.786327 0.421053 0.537090 0.665060 1.183232 0.018049 0.318459 -0.703355 0.195345 -0.077297 1.871030 0.530495 0.531341 1.097746 1.767131 0.727834 -0.574008 0.750642 1.641026 0.175921 0.475628 0.822744 0.820582 1.769156 1.104889 1.632957 0.266942 1.229760 0.719390 1.428009 0.477288 0.257612 0.561613 -0.039948 1.491420 0.932941 0.893178 1.634187 0.561223 1.393012 1.840902 0.791228 1.411740 1.982476 1.384250 -0.204107 1.207665 0.360873 0.168739 0.838827 0.835759 0.932733 1.414837 1.175094 0.611895 1.538776 0.260224 1.162783 1.177045 1.661498 0.489170 1.339504 1.394146 -0.144579 1.459461 0.992514 1.024122 1.563605 0.986046 0.047581 -0.337849 1.278146 1.320009 1.638323 0.355138 0.525644 0.398168 0.834583 0.203066 0.941413 0.771956 1.054595 0.051285 0.254298 0.346847 -0.091298 0.323760)
     )

;;; 98 prime --------------------------------------------------------------------------------
(vector 98 15.435913738557 #r(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

	12.372662 #r(0.000000 1.062122 1.210198 1.020671 1.241149 1.286661 0.511317 -0.019682 1.010783 0.746953 1.760431 0.561494 0.654976 0.673419 1.313525 -0.118147 0.501209 -0.690049 0.199706 -0.005719 1.829277 0.509888 0.558331 1.126546 1.945757 0.664417 -0.672214 0.793569 1.594140 0.278780 0.491367 0.845506 0.688752 1.731680 0.959760 1.574786 0.266532 1.244014 0.654879 1.596242 0.358329 0.214932 0.670212 -0.071336 1.488803 1.001998 0.860180 1.656576 0.561138 1.233882 1.824704 0.810287 1.410395 1.821967 1.245816 -0.182840 1.271909 0.271743 0.176573 0.793775 0.691737 1.040514 1.375578 1.076395 0.561942 1.489570 0.119803 1.123209 0.959986 1.482776 0.490928 1.340017 1.339451 -0.195028 1.543841 0.938894 0.968345 1.485837 1.025109 0.058564 -0.289532 1.193735 1.160972 1.446299 0.289925 0.547681 0.341389 0.741477 0.163732 1.030501 0.723432 0.941150 -0.013849 0.092018 0.265515 0.038062 0.217307 -0.108505)
     )

;;; 99 prime --------------------------------------------------------------------------------
(vector 99 15.391923904419 #r(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

	12.577378 #r(0.000000 1.606500 0.710782 0.831912 1.498992 1.824787 0.116159 -0.180831 1.066295 0.568843 0.967824 0.292392 0.550458 0.753848 0.865239 1.345891 0.576408 1.151601 1.610648 1.534872 1.104991 0.658526 1.253973 0.813550 0.616837 0.146480 -0.064854 1.125560 1.220929 0.935280 1.542029 1.558660 0.290895 -0.156901 0.924185 1.056282 0.875270 0.815532 0.773934 1.481163 -0.163032 1.601935 0.546118 0.908338 1.204483 1.290662 1.107486 0.615436 0.570723 0.198908 1.741425 0.441641 0.378889 1.168082 0.927631 0.114318 1.131285 0.409352 0.780459 -0.239072 0.531242 0.258847 0.921012 0.561150 1.649370 0.198953 0.427352 -0.039450 -0.500229 0.583037 1.113187 -0.008166 1.096497 0.882963 1.164475 0.014000 1.645840 1.004121 1.466757 0.770628 -0.075531 0.498646 1.426871 0.737006 0.309470 0.982564 -0.105052 0.900789 0.647694 0.071810 1.118676 1.735777 0.169421 1.616850 0.964754 1.556953 1.104961 0.493127 1.159598)
     )

;;; 100 prime --------------------------------------------------------------------------------
(vector 100 15.637986183167 #r(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

	12.507978 #r(0.000000 1.571576 0.836029 0.778379 1.522867 -0.009457 -0.186743 -0.240409 1.153585 0.705604 0.844838 0.417111 0.595063 0.674590 0.777944 1.226782 0.737916 1.171820 1.521080 1.555596 1.027275 0.711946 1.273408 0.833842 0.701230 0.197570 -0.004654 1.149172 1.223850 0.823264 1.464494 1.373573 0.457295 -0.184253 0.770780 0.817244 0.744306 0.813258 0.671616 1.424600 -0.273788 1.806947 0.402828 0.840824 1.375247 1.221599 1.349820 0.441761 0.539666 0.188775 1.872675 0.544579 0.571568 1.450748 0.983064 0.031927 1.098148 0.489679 0.699292 -0.244049 0.708419 0.261456 0.888868 0.677900 1.750620 0.009589 0.340081 -0.188490 -0.409400 0.646315 1.418970 0.009387 1.062568 0.838909 1.321634 0.105958 1.896395 1.052036 1.340801 0.703670 0.165320 0.510189 1.428199 0.758366 0.222380 0.955472 -0.035660 0.733303 0.711793 0.091925 1.152184 1.539471 0.293711 1.651264 0.907951 1.585266 0.993938 0.453757 1.060509 -0.204542)
      )

;;; 101 prime --------------------------------------------------------------------------------
(vector 101 15.735968313601 #r(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

	12.399912 #r(0.000000 -0.006369 1.225233 -0.044303 -0.184689 1.582028 -0.131397 1.340191 1.663283 1.151869 1.098269 0.334072 -0.505602 1.353398 1.216257 1.521892 1.221311 0.920791 1.316996 0.273715 0.296644 0.099775 0.332126 0.601882 0.641143 0.947381 0.511153 1.289698 -0.040523 0.557674 0.601556 -0.141898 0.593222 1.777747 1.084842 1.218989 1.495910 1.389181 0.446533 1.286228 0.406259 1.207717 1.583479 0.399954 0.437239 1.538909 1.137315 1.380378 1.755103 -0.087016 1.886878 1.562859 1.728433 1.011983 1.382574 0.690111 1.644552 0.419564 0.122604 1.252303 -0.148654 0.593046 1.143805 1.492167 1.399443 -0.386891 -0.159681 1.336058 1.348698 -0.012483 1.619837 -0.080165 0.524731 0.524916 0.505770 1.264840 0.067152 -0.598030 0.360686 1.448736 1.067059 0.418031 0.285412 0.377625 1.270248 1.714515 0.571639 1.327807 1.362789 1.367075 0.301686 0.159557 1.129449 -0.018866 0.444415 0.717826 0.277182 0.496260 1.272082 1.021788 1.198902)
      )

;;; 102 prime --------------------------------------------------------------------------------
(vector 102 15.374809992584 #r(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

	12.509088 #r(0.000000 0.123635 1.236720 -0.024652 -0.252851 1.641880 -0.137815 1.382097 1.848036 1.124462 1.056123 0.298103 -0.244835 1.361472 1.333641 1.441802 1.355054 0.818128 1.204236 0.098156 0.414669 0.053097 0.521196 0.522008 0.874435 0.761619 0.608638 1.189768 -0.075034 0.414046 0.508802 -0.065156 0.587423 1.804842 1.093592 1.183696 1.622886 1.199836 0.501448 1.350085 0.548081 1.093179 1.531786 0.345066 0.425794 1.479914 1.026611 1.406720 1.682822 0.055513 1.882500 1.655335 1.667982 1.008955 1.432825 0.838950 1.575292 0.597013 0.001407 1.135975 -0.323406 0.617029 1.136616 1.412222 1.385098 -0.492841 -0.070278 1.116922 1.313821 -0.044011 1.725036 -0.009059 0.764068 0.437204 0.509079 1.434458 1.736015 -0.520268 0.433366 1.436045 0.974398 0.518755 0.336802 0.586242 1.332686 1.669304 0.563416 1.359945 1.250339 1.453280 0.119388 0.053325 1.030478 0.025163 0.285416 0.761502 0.357237 0.508360 1.409212 0.875932 1.262950 0.458118)
      )

;;; 103 prime --------------------------------------------------------------------------------
(vector 103 16.296298498866 #r(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

	12.672735 #r(0.000000 0.056615 1.048106 0.050403 -0.210612 1.550012 -0.151597 1.353477 1.707668 1.318924 1.030642 0.220168 -0.084021 1.370296 1.353860 1.346811 1.313106 0.913601 1.215098 0.429303 0.440779 1.969193 0.526734 0.475765 0.864400 0.816467 0.687799 1.339651 0.316023 0.557165 0.691096 0.022321 0.517361 1.836210 1.101440 1.165232 1.497434 1.248724 0.347027 1.308756 0.427759 1.056569 1.780925 0.557602 0.451474 1.561757 1.022840 1.384894 1.678877 0.218003 1.959671 1.728222 1.640225 0.866251 1.259946 0.882040 1.507723 0.524977 0.063431 1.153842 -0.025122 0.623967 1.222208 1.531621 1.369348 -0.387955 -0.018345 1.281478 1.285739 -0.011383 1.593336 0.010905 0.682506 0.521510 0.561128 1.495063 1.903458 -0.469485 0.327586 1.552378 1.070220 0.623300 0.311404 0.559701 1.371946 1.713757 0.518422 1.440179 1.365027 1.268628 0.118347 -0.039632 1.108415 0.239892 0.315659 0.812794 0.498893 0.628978 1.360568 0.913322 1.424978 0.475345 1.431768)
      )

;;; 104 prime --------------------------------------------------------------------------------
(vector 104 15.919013023376 #r(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

	12.816906 #r(0.000000 0.005876 1.013382 -0.170331 -0.247392 1.848084 -0.074365 1.367834 1.527788 1.410173 1.071835 0.279882 -0.035525 1.205300 1.233008 1.208225 1.142312 1.039938 1.250847 0.359294 0.417727 1.886462 0.466871 0.408511 0.760714 0.837436 0.551871 1.188735 0.351821 0.595898 0.605532 -0.100226 0.741622 1.814736 1.099308 1.340715 1.446666 1.368053 0.541883 1.364944 0.515034 0.989139 -0.063109 0.589531 0.490802 1.469244 1.119966 1.498199 1.571061 0.032494 -0.004041 1.518032 1.471940 0.839584 1.242116 0.764627 1.681533 0.505412 0.026718 1.317177 -0.050963 0.735635 1.263195 1.372410 1.384633 -0.410236 1.924812 1.395981 1.278263 -0.079069 1.725695 -0.011515 0.597383 0.504899 0.493299 1.592886 0.008469 -0.585827 0.159347 1.594202 1.194917 0.550066 0.300385 0.254223 1.375785 1.667579 0.532147 1.348982 1.283546 1.279621 0.151467 0.166276 1.232230 0.264641 0.146173 1.059459 0.301975 0.523374 1.495098 0.454937 1.493189 0.807173 1.248281 -0.371335)
      )

;;; 105 prime --------------------------------------------------------------------------------
(vector 105 16.038356734428 #r(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

	12.916522 #r(0.000000 0.035733 0.146816 0.176222 0.019027 1.555239 0.531049 0.662233 0.425721 0.770266 0.351556 1.638905 0.444693 0.646790 1.765319 1.849739 1.029701 0.135044 1.450802 -0.159806 1.362913 -0.124665 1.674443 0.989611 1.272076 0.057071 1.556742 1.346751 1.251145 1.706415 1.872694 1.575371 0.113097 0.068573 0.779217 1.381228 1.603069 1.338719 0.535291 1.105635 0.700633 0.141791 0.344883 0.301141 1.577419 1.904318 1.874848 0.560766 -0.112149 0.389847 1.249710 1.291208 0.017403 0.838973 1.241784 -0.121543 1.444367 1.838412 0.505481 0.802591 0.039878 0.310437 0.226521 1.375029 1.201609 0.875569 -0.109062 0.042976 0.869010 0.155137 1.106003 1.606208 1.553493 -0.177942 1.328488 -0.138564 1.819211 0.873740 1.485950 0.404397 0.720036 0.894644 0.589908 0.439555 1.491305 1.816089 1.096165 1.438818 1.789014 1.713238 1.331991 0.084996 -0.007846 1.275222 1.636598 0.131740 0.866434 1.943413 0.382086 1.017873 0.303950 0.157486 0.677006 1.358584 1.833528)
      )

;;; 106 prime --------------------------------------------------------------------------------
(vector 106 15.730461834714 #r(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

	12.794446 #r(0.000000 0.824273 1.828999 0.942003 -0.086015 0.798664 -0.029888 1.874797 0.495083 0.601050 0.464198 0.872917 1.451764 1.810184 0.879193 1.143303 1.409742 0.189735 1.082916 1.611182 0.250864 1.785837 1.107283 -0.871352 1.375655 1.453972 1.126091 0.505938 -0.207387 1.096417 1.359253 0.125801 0.274834 -0.136377 0.760992 1.125647 1.299980 1.052158 0.403960 1.075614 1.381134 0.834318 1.727338 1.160684 1.146547 0.267894 0.485313 -0.075330 1.076932 0.607381 1.287722 1.229334 0.093554 0.840461 1.068644 1.198713 1.521805 0.421537 0.387289 -0.358398 0.334308 1.077116 0.642453 1.768709 0.866201 0.702737 0.890025 1.148511 0.957358 0.378235 1.239784 0.834404 0.340508 0.555245 1.269190 0.845401 0.112762 1.786995 0.808055 0.327768 -0.115925 -0.160303 1.565805 0.517886 1.403569 1.322644 0.893663 1.601143 1.265118 1.003220 -0.444445 0.092192 1.223903 1.814820 1.625515 1.831227 0.864675 1.406322 0.036836 0.454910 -0.487510 0.181050 1.611177 0.829628 0.619259 1.019531)
      )

;;; 107 prime --------------------------------------------------------------------------------
(vector 107 16.2013 #r(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

	12.988187 #r(0.000000 1.006384 1.772605 1.082520 -0.103550 0.827095 -0.061581 1.879336 0.528308 0.647218 0.478152 0.569489 1.446018 1.570953 0.720014 1.486557 1.387067 0.184695 1.107938 1.457112 0.276372 1.749961 1.156062 -0.983966 1.348085 1.156844 1.068780 0.690538 -0.126863 1.171550 1.321120 0.117114 0.508200 -0.108411 0.672852 1.114732 1.268420 1.213600 0.295071 1.015373 1.237030 0.802239 1.451596 1.294554 1.251070 0.144387 0.378015 -0.250093 1.233693 0.570270 1.112605 1.254955 -0.215605 1.173152 0.990234 0.998903 1.593976 0.352110 0.464080 -0.306078 0.339625 0.954705 0.488507 1.697617 0.893707 0.969534 0.999519 1.337148 0.765840 0.438003 1.274817 0.789372 0.327831 0.296967 1.327149 0.787513 0.179686 1.774089 0.675867 0.060846 0.038886 -0.342465 1.468492 0.289338 1.228684 1.379450 1.175485 1.542230 1.258108 0.814494 -0.330164 0.100253 1.356661 1.672593 1.411329 1.749818 0.860992 1.350383 -0.107209 0.388894 -0.476492 0.251475 1.425927 0.640104 0.679416 0.802377 0.210388)
      )

;;; 108 prime --------------------------------------------------------------------------------
(vector 108 16.517358779907 #r(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

	12.949567 #r(0.000000 1.154188 1.850960 1.023805 -0.190560 0.886003 0.010115 1.927166 0.474009 0.674762 0.431663 0.720778 1.438575 1.576848 0.647861 1.446759 1.366292 0.141031 1.057169 1.354619 0.351767 1.899698 0.980606 -0.874949 1.398138 1.264742 1.154107 0.795292 -0.095113 1.092027 1.333786 0.062533 0.545021 0.006486 0.678825 1.086430 1.336800 1.053293 0.305151 1.050434 1.389642 0.563852 1.603438 1.211149 1.011680 0.168388 0.680174 -0.229864 1.179776 0.518000 1.050375 1.294780 -0.065344 1.019199 1.104096 1.129244 1.610047 0.478397 0.484907 -0.154568 0.289278 0.961269 0.581841 1.839625 0.905785 0.797493 1.022686 1.309758 0.964419 0.446645 1.309897 0.761680 0.410859 0.390068 1.338059 0.720222 0.212378 1.770163 0.648398 0.227497 -0.044231 -0.120987 1.441621 0.498126 1.222246 1.323925 1.084664 1.544874 1.195873 1.078609 -0.351475 0.089740 1.268244 1.729109 1.649888 1.809102 0.871499 1.313209 -0.069116 0.391931 -0.400105 0.330779 1.406849 0.785059 0.764473 0.851849 0.233810 -0.007309)
      )

;;; 109 prime --------------------------------------------------------------------------------
(vector 109 16.726722717285 #r(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

	13.018132 #r(0.000000 1.005369 1.874614 1.134075 -0.093901 0.805230 -0.040156 1.922598 0.660596 0.679160 0.430683 0.620829 1.482185 1.580269 0.977042 1.511356 1.497778 0.217671 1.101347 1.363119 0.485849 1.865474 1.128586 -0.912591 1.334983 1.248275 0.968169 0.724216 -0.112802 1.376406 1.464868 0.076267 0.508105 0.013266 0.684540 1.146144 1.277955 1.166658 0.392729 1.154513 1.436546 0.713879 1.462462 1.235206 1.181013 0.097603 0.711327 -0.243933 1.278609 0.414287 1.117364 1.187738 -0.073879 1.031753 1.081591 1.038930 1.596811 0.423988 0.466102 -0.121238 0.302973 0.962359 0.569299 1.737445 1.123945 0.871478 0.995073 1.278952 0.968377 0.399671 1.344584 0.889458 0.321092 0.505754 1.312129 0.766037 0.179523 1.711700 0.782157 0.178305 -0.080671 -0.033005 1.610052 0.418820 1.249254 1.433867 1.138508 1.631772 1.379336 0.988712 -0.352563 0.194855 1.346259 1.700054 1.447228 1.840483 0.896277 1.334171 0.043633 0.390795 -0.403240 0.348395 1.430585 0.763431 0.782305 0.861874 0.231216 0.031630 0.108486)
      )

;;; 110 prime --------------------------------------------------------------------------------
(vector 110 16.455888332339 #r(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

	13.073535 #r(0.000000 1.003341 1.889390 1.010547 -0.123129 0.779788 -0.137527 1.783857 0.631287 0.886358 0.469701 0.602046 1.436807 1.460747 0.724959 1.404600 1.354499 0.037653 1.219652 1.305879 0.511355 1.864015 0.995096 -0.893360 1.263631 1.405332 0.993382 0.715936 -0.149773 1.191563 1.316946 0.072661 0.403687 0.057843 0.714749 1.221030 1.190375 1.316691 0.349363 1.024807 1.342859 0.473846 1.477414 1.171532 1.033975 0.254770 0.593683 -0.272391 1.129587 0.521190 1.051712 1.264771 0.035623 0.841269 1.298444 1.178350 1.540027 0.566022 0.387798 -0.071558 0.296239 0.839414 0.536227 1.606711 0.946988 0.815509 1.002437 1.353000 1.067920 0.312224 1.264458 0.910769 0.378074 0.270337 1.284331 0.804484 0.239754 1.546090 0.585513 0.077503 -0.101551 -0.086171 1.512185 0.391926 1.140812 1.382042 1.022268 1.571728 1.347248 1.003629 -0.273864 0.050506 1.248536 1.551340 1.431668 1.738464 0.917149 1.210645 -0.019893 0.308787 -0.436440 0.343935 1.440493 0.621129 0.807041 0.830027 0.273155 -0.176130 0.110658 0.433053)
      )

;;; 111 prime --------------------------------------------------------------------------------
(vector 111 16.6662 #r(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

	13.304275 #r(0.000000 1.031899 1.655069 0.856014 -0.083054 0.763972 0.010852 1.774567 0.729011 0.714953 0.410228 0.550154 1.474277 1.510160 0.773728 1.578498 1.550850 0.318883 1.061908 1.246906 0.429405 1.894707 1.267936 -0.969899 1.365976 1.243339 0.945184 0.539584 -0.161954 1.198475 1.301928 0.138197 0.500852 -0.046588 0.749532 1.003103 1.374485 1.194299 0.442662 1.107766 1.457093 0.484017 1.572765 1.170234 1.242363 0.220954 0.750947 -0.192326 1.180702 0.517237 1.060518 1.291366 0.103991 1.055731 1.150605 1.058955 1.634830 0.342918 0.238679 0.056910 0.168177 0.870899 0.463593 1.824162 1.043456 0.724325 1.134409 1.296623 1.006970 0.300781 1.283276 0.867142 0.375109 0.245062 1.342943 0.901017 0.149108 1.844451 0.563404 0.285521 -0.027207 -0.131296 1.529807 0.507613 1.172711 1.395678 1.133222 1.703073 1.299218 1.087241 -0.250981 0.147525 1.130875 1.810825 1.551294 1.856013 0.802024 1.156477 -0.063564 0.331939 -0.493911 0.345888 1.436909 0.753353 0.583179 0.910190 0.157703 0.013683 0.215589 0.124657 -0.068174)
      )

;;; 112 prime --------------------------------------------------------------------------------
(vector 112 16.697049415765 #r(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

	13.432041 #r(0.000000 1.022306 1.659808 0.924759 -0.087688 0.965196 -0.066230 1.901637 0.617989 0.728481 0.407054 0.552654 1.585849 1.494557 0.681265 1.537034 1.505763 0.290786 1.072103 1.213397 0.458755 0.057808 1.050683 -0.857452 1.287056 1.288375 0.990442 0.635807 -0.042294 1.189168 1.369581 0.202567 0.368100 0.074637 0.781785 1.113195 1.268694 1.303587 0.363181 1.300784 1.517983 0.612029 1.628780 1.232036 1.268299 0.227626 0.625657 -0.233974 1.101505 0.496818 1.114398 1.293373 0.065936 0.838962 1.121782 1.161294 1.558114 0.490386 0.225463 -0.072671 0.360939 1.026958 0.409468 1.926579 1.152881 0.663659 0.988071 1.240422 1.010565 0.261830 1.300112 0.907465 0.377816 0.345039 1.423383 0.714651 0.094098 1.746831 0.703527 0.262312 -0.033334 -0.082719 1.690275 0.457934 1.104373 1.375564 0.950940 1.651746 1.225689 1.153617 -0.446884 0.128976 1.225947 1.801296 1.536475 1.803596 0.819072 1.299336 0.121015 0.279274 -0.590283 0.345169 1.617128 0.808805 0.573705 0.998005 0.241981 0.169695 -0.046880 -0.083617 -0.077998 -0.124083)
      )

;;; 113 prime --------------------------------------------------------------------------------
(vector 113 16.203890830538 #r(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

	13.378925 #r(0.000000 0.530023 -0.133056 1.165604 1.776990 0.959258 0.083179 0.899966 1.590724 1.146469 0.787123 -0.105292 0.669297 0.284550 1.052397 0.733083 1.553681 1.227712 0.236178 0.058437 1.225511 1.962455 1.230068 0.337163 0.578887 0.725673 1.696799 0.039316 1.042745 1.183984 0.193748 0.658474 -0.242507 0.927268 0.056041 1.690521 0.177710 1.426147 1.814596 0.143288 0.623294 1.067425 0.334220 1.355288 1.290763 1.769115 1.354291 0.013356 1.516252 0.404663 0.678049 1.136111 0.074519 1.364761 1.323246 -0.186482 1.145856 -0.143323 1.199671 1.763817 -0.236628 -0.253283 -0.110928 1.824430 0.982075 0.045710 -0.055784 0.857573 -0.196869 0.965372 0.099866 0.530251 1.758876 0.729743 -0.025201 0.706939 0.080635 0.055884 0.364201 0.043553 1.260827 0.849111 1.573303 1.265174 0.510130 1.962308 1.015411 1.243401 0.238637 0.005950 0.191571 0.557357 0.016971 1.220529 0.120786 0.860456 1.127059 0.178415 1.403551 1.642586 1.449755 1.322698 1.249327 0.747530 0.355627 1.896226 1.693768 0.136043 0.757254 1.324842 0.966556 1.033760 0.349980)
      )

;;; 114 prime --------------------------------------------------------------------------------
(vector 114 16.442732865586 #r(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

	13.476047 #r(0.000000 0.555307 -0.084712 1.121106 1.855487 0.966011 0.048301 1.033619 1.391848 1.004890 0.842586 -0.140531 0.701794 0.062707 1.157939 0.677051 1.382169 1.238036 0.420332 0.203353 1.291943 1.803750 1.233037 0.395887 0.677730 0.747767 1.732263 0.078112 0.929064 1.119319 0.179619 0.724559 -0.202929 0.840523 0.078276 1.554267 0.202698 1.381340 1.718840 0.070427 0.571839 0.892062 0.367373 1.411084 1.361936 1.748641 1.317216 0.213979 1.345744 0.271763 0.639437 1.243073 -0.038504 1.453415 1.225556 -0.130937 1.315536 -0.154747 1.282338 1.741821 -0.072043 -0.100964 0.020500 1.945160 1.081445 0.085420 -0.051718 0.811455 -0.212040 0.933136 0.172121 0.613031 1.893692 0.775053 -0.003385 0.668536 0.127897 0.024734 0.588559 0.116538 1.428100 0.914527 1.465874 1.430746 0.341969 1.879498 1.048255 1.185925 0.352392 0.168929 0.143779 0.595336 0.037324 1.262344 0.201833 0.997381 1.098707 0.237057 1.360522 1.727900 1.375652 1.343688 1.331294 0.722261 0.436608 0.080264 1.857549 0.120829 0.494911 1.276243 0.861431 1.081103 0.265757 -0.001322)
      )

;;; 115 prime --------------------------------------------------------------------------------
(vector 115 16.774665887963 #r(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

	13.481409 #r(0.000000 0.490468 -0.036628 0.999423 1.938186 1.098039 0.061684 0.941804 1.510411 1.071761 0.847808 -0.195638 0.554398 -0.067035 1.216076 0.645296 1.411766 1.180867 0.379564 0.216040 1.260637 1.635645 1.171227 0.415672 0.665180 0.817423 1.755254 0.172770 1.024590 1.244658 0.225280 0.876694 -0.122050 1.037302 -0.073036 1.499146 0.134868 1.321349 1.759728 0.187835 0.524167 1.014011 0.224420 1.264464 1.407503 1.848526 1.070475 0.080135 1.356366 0.384472 0.592458 1.283499 0.055375 1.414682 1.126802 -0.254309 1.373915 -0.156745 1.223946 1.619996 -0.020115 -0.304510 0.108907 0.006777 0.983682 -0.002895 -0.083993 0.853061 -0.228455 0.810346 -0.005536 0.907120 1.796142 0.768458 0.069640 0.666735 0.167472 0.045277 0.501044 0.151378 1.220180 0.897360 1.609106 1.411203 0.457272 1.888506 0.866716 1.055261 0.297445 0.064088 0.050517 0.604964 0.080094 1.324616 0.155317 0.939071 1.065221 0.167693 1.363021 1.700034 1.430537 1.250487 1.136416 0.899634 0.433311 0.074805 1.823657 0.119687 0.542349 1.110092 1.113300 0.970293 0.318574 0.033727 0.090913)
      )

;;; 116 prime --------------------------------------------------------------------------------
(vector 116 16.812931137234 #r(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

	13.608593 #r(0.000000 1.653095 0.276323 1.455579 0.026403 0.936953 0.496081 1.653901 0.344080 0.759173 0.563063 1.235950 1.706855 0.455503 0.190666 0.126906 -0.572811 0.999205 0.675549 1.223375 0.447059 0.875310 0.646961 0.169878 0.433498 0.649900 0.951144 1.646724 -0.216640 1.674801 0.646809 0.723034 1.905719 -0.173078 0.286966 1.501763 0.261326 1.628260 -0.249038 0.604666 1.544403 -0.156184 1.707154 0.389585 1.062587 0.237581 1.422735 0.978545 -0.051171 1.564189 1.229937 0.452497 0.077991 0.679029 1.167372 1.533593 0.208276 1.922878 -0.148140 0.105080 1.589205 1.124818 1.003160 1.662080 0.752646 0.588955 1.586595 1.578950 -0.204721 0.018922 0.072845 1.560651 0.999946 0.415118 0.312497 1.210531 1.529407 0.909692 1.734534 0.979235 0.172045 1.235153 1.338787 0.043938 0.480071 1.449645 0.645923 1.593635 1.121873 0.346120 1.830749 0.495312 0.919827 0.121056 0.781792 0.735528 1.399506 1.203922 0.960125 0.107924 1.620289 0.193295 -0.157093 1.272690 -0.397301 0.626692 1.754281 1.464042 1.421652 1.669369 1.410750 0.745626 -0.004840 0.199378 0.360546 0.095468)
      )

;;; 117 prime --------------------------------------------------------------------------------
(vector 117 17.5997 #r(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

	13.680216 #r(0.000000 1.688026 0.267955 1.374351 -0.002997 0.811104 0.353452 1.551229 0.284696 0.542058 0.377909 1.175383 1.710894 0.412982 0.185867 0.118562 -0.623961 0.889589 0.782241 1.208703 0.402349 0.920095 0.656367 0.168376 0.361453 0.466066 1.040272 1.684105 0.004005 1.798269 0.600767 0.738643 1.841999 -0.121910 0.063062 1.500091 0.349331 1.566370 -0.081025 0.485117 1.433414 -0.175314 1.794407 0.340610 0.925543 0.308779 1.338194 1.062048 0.034329 1.590829 1.249125 0.629072 0.046100 0.678105 1.282374 1.471958 0.343990 -0.012184 0.025088 0.026864 1.371481 1.007248 1.058699 1.796290 0.706534 0.711138 1.427867 1.594466 -0.055777 0.127617 0.153626 1.537163 0.930123 0.370161 0.296951 1.350618 1.645532 0.852235 1.717604 0.955495 0.105226 1.278685 1.181367 -0.105642 0.466691 1.356995 0.807474 1.413130 1.085801 0.249630 1.956545 0.281625 0.802255 0.121542 0.884619 0.602864 1.207667 1.011035 1.098265 -0.002067 1.630354 0.155013 -0.142381 1.206795 -0.517321 0.734081 1.768506 1.435615 1.357134 1.611634 1.476408 0.827132 0.193848 0.004639 0.352651 -0.171724 0.246886)
      )

;;; 118 prime --------------------------------------------------------------------------------
(vector 118 17.181785583496 #r(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

	13.809988 #r(0.000000 1.661046 0.425950 1.371055 -0.007678 0.956810 0.380715 1.550428 0.361700 0.726078 0.554717 1.135225 1.675102 0.458435 0.214958 0.144450 -0.576098 0.860672 0.772729 1.247185 0.448854 1.201475 0.711863 0.403040 0.453890 0.551598 0.949329 1.871747 -0.191123 1.685762 0.639921 0.620123 0.068241 -0.134677 0.288629 1.442984 0.311284 1.486378 -0.207036 0.436449 1.489923 -0.071901 1.773217 0.279072 0.917135 0.416101 1.500043 1.096087 -0.056696 1.581221 1.289546 0.635321 0.034220 0.719333 1.230529 1.391994 0.365166 -0.072698 -0.024515 1.893251 1.331241 0.986959 1.146371 1.614113 0.761100 0.659345 1.525242 1.630668 -0.155487 0.099177 0.142389 1.446459 0.944527 0.466999 0.305321 1.284282 1.642697 0.847642 1.663748 0.947509 0.143525 1.322327 1.200502 -0.021178 0.662277 1.524103 0.719966 1.423926 1.223193 0.346375 1.823537 0.499123 0.884622 0.069702 0.881683 0.752726 1.369493 1.263403 1.141747 0.175246 1.661269 0.148530 0.009723 1.349898 -0.478031 0.764367 1.578490 1.512868 1.399167 1.622975 1.341475 0.868811 0.150131 0.115265 0.493894 -0.162024 0.276727 -0.173355)
      )

;;; 119 prime --------------------------------------------------------------------------------
(vector 119 17.167841346875 #r(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

	13.745598 #r(0.000000 1.763789 0.241864 1.479014 0.040903 0.851640 0.292306 1.494078 0.368530 0.576785 0.413162 1.251253 1.560498 0.533496 0.207377 0.086290 -0.603884 1.088882 0.583146 1.168157 0.551605 1.152674 0.790902 0.337296 0.454014 0.458353 1.138887 1.678384 -0.142605 1.425377 0.694184 0.590015 -0.002181 0.226685 0.273798 1.626617 0.341625 1.482203 -0.084169 0.460416 1.413878 -0.042767 1.919319 0.395600 1.076766 0.315182 1.523747 1.171798 0.108074 1.657882 1.265634 0.626367 0.117327 0.564449 1.248723 1.315461 0.187008 0.035422 0.037190 0.027581 1.480117 0.923211 1.226129 1.609860 0.821969 0.738125 1.393740 1.651376 -0.319430 0.042573 0.325560 1.606961 0.881289 0.481256 0.249164 1.016023 1.672919 0.890288 1.612304 1.085631 0.198732 1.204572 1.063957 -0.352780 0.553193 1.366431 0.709894 1.607219 1.283563 0.057939 1.942264 0.204818 0.870673 0.109301 0.916771 0.737223 1.327629 1.166252 1.195633 0.220792 1.365567 0.156850 0.028721 1.361864 -0.568831 0.826440 1.781827 1.562851 1.394229 1.494946 1.300471 0.919851 0.240616 -0.113556 0.474415 -0.065238 0.268426 0.054389 -0.115644)
      )

;;; 120 prime --------------------------------------------------------------------------------
(vector 120 17.067 #r(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

	13.757227 #r(0.000000 1.621540 0.169951 1.311905 -0.022058 0.998864 0.435432 1.550321 0.295124 0.728672 0.620699 1.161464 1.758940 0.594515 0.135602 0.053085 -0.509385 0.933224 0.330739 1.117745 0.532039 1.015433 0.953700 0.320235 0.350743 0.648910 1.234428 1.754674 -0.036654 1.713667 0.639452 0.748348 1.829889 0.130066 0.263748 1.521305 0.129773 1.337559 -0.166286 0.487377 1.289387 -0.166841 1.582581 0.361588 0.982709 0.157041 1.458196 1.105227 0.232063 1.848893 1.126789 0.716503 -0.030126 0.628288 1.280006 1.160671 0.281229 0.056225 0.062906 0.017528 1.281132 0.941542 0.850217 1.552935 0.761635 0.634315 1.362864 1.737787 -0.240844 -0.068866 0.215999 1.419428 0.692809 0.650219 0.054312 0.906639 1.651447 0.832047 1.586100 1.008012 0.251393 1.398242 1.126445 -0.142663 0.660048 1.394616 0.907185 1.633758 1.146247 0.156134 -0.083636 0.372011 0.901174 0.109270 1.123234 0.659782 1.469391 1.261199 1.245060 0.220555 1.276121 0.107819 0.089933 1.318716 -0.582798 0.870240 1.890975 1.501251 1.464881 1.310475 1.520920 0.773800 0.058424 -0.029155 0.346313 -0.170790 0.199756 -0.257074 -0.263751 0.013773)
      )

;;; 121 prime --------------------------------------------------------------------------------
(vector 121 17.782977183017 #r(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

	13.880637 #r(0.000000 0.011053 1.674094 0.164216 0.586471 1.635002 1.894051 -0.609992 0.457894 0.410791 1.177443 0.187092 1.448735 0.055813 0.015669 0.142698 0.283388 0.150998 1.297568 -0.019025 0.735500 1.454683 0.979934 0.718961 0.404762 0.512634 1.905916 -0.341179 -0.399281 -0.189491 1.320074 1.472687 0.235929 0.878282 1.164743 0.597799 1.142436 0.459071 0.583908 0.334291 0.552901 1.486535 0.567364 0.977839 0.018179 0.089250 1.673515 1.234408 -0.182505 1.334394 0.432891 1.398254 1.019632 1.455323 0.030906 0.505413 1.329025 -0.040316 0.992059 1.000951 1.404993 0.822453 0.688834 1.375137 1.619399 1.713787 0.638450 0.635239 -0.583107 0.718780 1.044893 1.122091 -0.133066 1.294046 1.131795 -0.278577 1.938902 1.541306 0.535432 0.051808 1.301045 0.220007 0.021787 1.012251 0.872353 1.928175 0.279283 0.281752 1.676040 1.689027 0.529259 1.284516 0.155766 0.342767 0.036672 1.290402 0.172578 1.193893 1.363243 0.770479 0.953576 0.956630 0.659910 0.622722 1.540028 0.960250 -0.294554 0.131920 0.392515 0.458717 1.721386 1.147510 0.322474 0.870369 1.571825 -0.127896 0.879113 0.490193 0.144391 1.041373 0.502902)
      )

;;; 122 prime --------------------------------------------------------------------------------
(vector 122 17.876078447724 #r(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

	13.906527 #r(0.000000 -0.099547 1.709527 0.048884 0.533827 1.762396 1.904791 -0.668089 0.500366 0.369425 1.007521 0.001958 1.545585 0.140117 0.106602 0.358405 0.232790 0.244646 1.269065 0.030985 0.775241 1.293614 0.988745 0.851475 0.306236 0.561359 1.950591 -0.163655 -0.299640 -0.155721 1.172535 1.395839 0.321719 0.913626 1.031829 0.564370 1.095327 0.455433 0.548185 0.309621 0.476860 1.376713 0.601334 0.850252 0.164826 0.219540 1.533471 1.310826 -0.141881 1.415261 0.341539 1.413199 0.983667 1.541370 0.060919 0.583251 1.340697 -0.207196 0.829939 0.927837 1.411884 0.905082 0.737578 1.372183 1.440649 1.662936 0.698717 0.633216 -0.572907 0.728282 1.091381 1.148246 0.055682 1.252495 0.983975 -0.337992 1.802386 1.568806 0.491796 0.042570 1.172810 0.310740 0.004408 1.065734 0.831355 1.907920 0.308747 0.235042 1.672119 1.561166 0.620423 1.233249 0.183466 0.292383 0.074387 1.281357 0.293915 1.177022 1.285722 0.617262 0.943993 0.922526 0.740040 0.527782 1.599150 1.001771 -0.302278 0.241555 0.315935 0.559426 1.696152 1.068954 0.340744 0.880683 1.524256 -0.245606 1.010616 0.495898 0.176480 1.027028 0.501501 0.247391)
      )

;;; 123 prime --------------------------------------------------------------------------------
(vector 123 17.273 #r(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

	13.986152 #r(0.000000 -0.089031 1.810628 0.003794 0.428628 1.748574 1.836497 -0.846229 0.414743 0.461103 1.144101 0.065730 1.542626 0.287365 0.139494 0.348534 0.277456 0.092934 1.244603 -0.162559 0.660331 1.378149 1.127024 0.974502 0.286604 0.581351 0.001669 -0.273523 -0.406715 -0.109444 1.105353 1.446824 0.384563 0.933512 1.013085 0.783798 1.145256 0.425557 0.423639 0.274391 0.516734 1.414372 0.519990 0.725593 0.158891 0.132561 1.541683 1.314356 -0.049121 1.395372 0.558758 1.346639 0.961640 1.460054 0.182799 0.703302 1.348988 0.010105 0.972514 0.858076 1.279386 0.891284 0.698762 1.474647 1.441931 1.702456 0.659925 0.674747 -0.513963 0.664878 1.027230 1.047802 0.087502 1.252500 0.892907 -0.522290 1.755677 1.625283 0.505694 0.190308 1.116793 0.332435 -0.021839 0.867635 0.802522 -0.006594 0.179649 0.411803 1.706447 1.718443 0.614606 1.242050 0.282847 0.271446 0.060126 1.132112 0.346208 1.101339 1.506422 0.535516 0.955191 0.944874 0.729330 0.514866 1.751832 1.025674 -0.196520 0.267256 0.349096 0.519442 1.715951 1.000751 0.406605 0.838027 1.435478 -0.369519 1.067076 0.400864 0.222844 0.963085 0.468203 0.183874 0.039937)
      )

;;; 124 prime --------------------------------------------------------------------------------
(vector 124 17.868420183527 #r(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

	14.115497 #r(0.000000 -0.099868 1.691949 -0.057986 0.412632 1.704642 1.810077 -0.707445 0.466437 0.340955 1.107674 -0.066643 1.610327 0.321535 0.279720 0.406051 0.095210 0.114718 1.310572 -0.184696 0.728259 1.328297 0.747098 0.920780 0.439371 0.758487 1.861736 -0.302497 -0.112284 -0.105402 1.031709 1.464177 0.446376 0.839784 0.922524 0.779643 1.349243 0.501806 0.363694 0.350860 0.514462 1.415382 0.654989 0.858408 0.254950 0.181546 1.543575 1.316710 -0.125737 1.443346 0.315216 1.378559 0.927684 1.456696 0.308380 0.476964 1.123342 -0.201049 1.029792 1.033087 1.294009 0.730779 0.873857 1.486810 1.624789 1.820377 0.634989 0.682428 -0.609242 0.643523 1.091673 1.118858 0.123285 1.125796 0.858334 -0.549366 1.882234 1.716220 0.597941 0.178634 1.155193 0.427409 -0.004572 0.886326 1.009592 0.039313 0.184374 0.342820 1.682882 1.594361 0.423206 1.463643 0.368684 0.335146 0.081335 1.128024 0.380373 1.219058 1.553390 0.517718 0.823660 1.002998 0.796501 0.623220 1.905595 0.921222 -0.214740 0.494105 0.307176 0.339791 1.718574 1.107208 0.053454 0.989351 1.531354 -0.234580 1.192471 0.345974 0.182807 1.089994 0.308575 0.246745 -0.077315 0.132691)
      )

;;; 125 prime --------------------------------------------------------------------------------
(vector 125 17.637776156888 #r(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

	14.109595 #r(0.000000 -0.058026 1.753753 -0.046932 0.509945 1.738187 1.779267 -0.794569 0.535409 0.274583 1.081133 0.024599 1.517111 0.070958 0.099350 0.264944 0.097415 -0.001189 1.350565 -0.236408 0.657613 1.413391 0.937343 0.949598 0.250371 0.568506 0.028004 -0.356142 -0.290605 -0.443734 1.075249 1.459597 0.470745 0.808252 1.042168 0.912350 1.214820 0.484810 0.430543 0.263063 0.377471 1.560103 0.568656 0.671466 0.014962 0.211292 1.500509 1.358469 -0.026585 1.483732 0.383548 1.414820 1.002190 1.463298 0.162540 0.620406 1.260724 -0.162476 0.965205 0.992088 1.285201 0.897470 0.701380 1.584674 1.449888 1.851813 0.649056 0.632769 -0.598549 0.682218 1.124893 1.136136 0.065249 1.204261 0.822010 -0.401854 1.825721 1.640549 0.588152 0.121224 1.160317 0.441356 0.074632 0.953143 0.994753 1.910550 0.289137 0.385655 1.668894 1.690175 0.528856 1.292631 0.477486 0.249502 -0.024049 0.968766 0.369611 1.092123 1.451294 0.607623 0.892754 0.987904 0.747092 0.658042 1.797382 1.037563 -0.216279 0.432107 0.207168 0.434094 1.719175 1.108204 0.162478 0.855712 1.472548 -0.225359 1.107860 0.426093 0.276161 1.034954 0.193527 0.296896 -0.083856 0.091147 0.277234)
      )

;;; 126 prime --------------------------------------------------------------------------------
(vector 126 18.284595039843 #r(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

	14.116066 #r(0.000000 0.949657 1.465052 1.123647 0.116905 0.172795 1.890313 0.987146 -0.281682 0.169256 1.342857 0.671520 1.554641 -0.214819 0.895300 1.067002 0.928752 1.709401 1.181056 0.982089 -0.062562 0.708222 0.816650 1.692571 0.798430 1.091636 0.888614 1.882928 1.498862 1.630085 -0.096688 0.005033 -0.063204 -0.147091 0.178432 0.613880 0.045764 1.413770 0.545890 0.261100 0.603723 -0.048355 0.221736 1.785539 0.468554 1.700955 1.717016 0.300689 0.344169 -0.396342 0.217658 -0.053198 0.649658 1.105691 -0.232405 1.212463 0.278807 1.753605 0.037061 0.698429 1.290046 1.420334 0.923850 1.420226 1.766531 0.214004 0.571191 0.928880 0.591907 -0.143411 0.756426 -0.006643 0.066278 1.125715 1.624851 1.173674 0.879228 1.221064 1.436462 -0.461174 0.740947 1.294057 1.759011 1.925975 1.383009 1.219864 0.659582 1.024160 0.093040 -0.472873 0.831029 0.966134 0.341915 1.874899 1.844309 1.343129 0.857950 0.235438 -0.134227 0.946660 1.090823 0.342113 0.224283 1.619495 1.761983 0.945550 -0.001422 1.530247 0.438541 1.225461 0.975684 0.783218 0.558055 0.771857 0.922380 1.411079 1.525477 0.360097 1.490443 0.973669 0.285638 0.619372 0.035470 0.978346 -0.073125 0.253558)
      )

;;; 127 prime --------------------------------------------------------------------------------
(vector 127 18.198689419357 #r(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

	14.037827 #r(0.000000 0.899427 1.385060 1.126272 0.029049 0.159452 1.878338 0.912810 -0.340839 0.172339 1.451889 0.737075 1.584816 0.056905 0.957871 1.112426 1.031137 1.644734 1.004678 0.981201 1.931585 0.611280 0.742009 1.610869 0.936057 1.160251 1.019153 1.668439 1.608546 1.654460 0.004733 -0.198763 -0.128505 -0.089421 0.313864 0.536451 0.096480 1.435008 0.501610 0.221781 0.637396 1.900661 0.189060 1.766404 0.404640 1.886543 1.511441 0.502961 0.306607 -0.385577 0.284331 1.900108 0.630221 1.168392 -0.279115 1.249779 0.187016 1.795759 0.044064 0.842432 1.193004 1.342190 0.769565 1.553491 1.735403 0.197672 0.450432 0.842469 0.573921 -0.182694 0.802147 0.036762 1.880797 1.250105 1.604963 1.189770 0.697681 1.288227 1.565205 -0.410981 0.697382 1.394844 1.815343 1.850092 1.501696 1.365786 0.661106 0.945392 0.076671 -0.419315 0.918242 0.962035 0.234594 1.785944 1.718970 1.336529 0.805401 0.256612 -0.000599 1.016839 1.058149 0.299499 0.347779 1.705210 1.570619 0.858829 0.003976 1.371577 0.429299 1.159693 0.864482 0.712172 0.413089 0.863171 1.078758 1.457536 1.341515 0.388113 1.573979 0.733519 0.430082 0.550885 0.056485 1.045628 0.039019 0.124603 1.215409)
      )

;;; 128 prime --------------------------------------------------------------------------------
(vector 128 18.276384353638 #r(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

	14.240224 #r(0.000000 0.912071 1.515402 1.122211 0.051948 0.258202 1.898883 0.935088 -0.353133 0.202410 1.363970 0.936289 1.620427 0.131460 0.752690 1.192092 0.968335 1.502191 1.142305 0.899623 1.874743 0.390855 0.800995 1.624509 0.947264 1.053742 1.052522 1.819839 1.621113 1.602677 0.106811 -0.139692 -0.321040 0.008548 0.187451 0.486947 0.015908 1.437997 0.622302 0.140390 0.730405 1.877903 0.269484 1.774083 0.336855 1.852455 1.642017 0.584745 0.234263 -0.269672 0.277120 1.893933 0.654846 1.178832 -0.298671 1.133789 0.328832 1.689308 1.875270 0.780507 1.205780 1.332752 0.869598 1.432245 1.720197 0.242467 0.513974 1.022362 0.570726 0.025789 0.669291 1.973679 0.005375 1.246929 1.691412 1.402445 0.808191 1.106402 1.683778 -0.576127 0.792994 1.368158 -0.051762 1.824938 1.478412 1.310984 0.609265 0.959117 -0.002919 -0.241638 0.972751 0.817046 0.378864 1.831175 1.944682 1.498154 0.780093 0.266896 0.072455 1.094797 0.987490 0.448687 0.430777 1.677826 1.683416 0.786987 1.772036 1.415869 0.490468 1.131276 0.738277 0.703500 0.584572 0.916394 1.072753 1.461873 1.355422 0.411227 1.572356 0.654889 0.547027 0.599793 0.039769 1.164141 0.066127 0.288825 1.175333 0.810278)
      )

;;; 256 prime --------------------------------------------------------------------------------
(vector 256 27.740 #r(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      23.954812 #r(0.000000 1.204657 1.078759 1.682184 0.289433 1.857298 -0.103078 0.812130 1.708916 1.896961 1.156555 1.703874 1.227021 0.182267 1.041071 0.489158 1.008682 0.135723 0.046495 1.634992 0.566031 1.311776 1.337489 0.673226 1.836763 0.159154 0.202747 0.341271 0.471573 0.119586 1.124289 1.100574 1.091468 1.313210 0.642853 0.117292 -0.058379 0.647409 0.710309 0.207284 0.060417 0.146614 1.530493 1.426852 1.584556 0.403196 0.281684 1.359791 1.211733 1.335753 1.885602 1.477601 0.688497 0.894421 1.600991 1.328569 0.005997 0.453096 0.992624 0.185444 0.508566 0.835246 0.264281 0.242464 0.561992 0.572786 1.360366 0.402158 1.414686 0.275179 0.381572 -0.113917 0.093761 0.181937 1.876554 0.763184 0.742398 0.316668 0.919942 0.466632 1.953058 0.269310 1.678357 0.562522 0.033550 0.978955 0.884214 0.441468 1.069549 1.818992 0.418629 1.336178 1.464108 0.008854 1.818306 0.399905 1.080809 0.763485 0.787603 1.378379 0.936433 0.806686 0.536881 1.819028 1.671276 0.786432 1.275261 1.884577 0.933469 1.355576 1.479258 0.462174 0.332804 0.282457 0.550215 0.317652 0.454496 0.923565 0.787078 1.464952 0.107434 1.071904 1.315331 0.744343 0.731492 0.092424 1.422672 1.730219 1.887932 1.793030 0.347585 0.560825 1.039175 1.321464 0.820946 1.971856 1.662872 1.726858 0.163305 0.618347 1.843241 1.984311 0.060498 0.046747 0.257781 0.365656 1.677750 -0.207494 0.053362 0.938280 1.295484 0.245637 0.522272 1.268074 1.776463 1.391102 0.235187 1.356696 0.411477 0.726380 0.608354 1.031435 0.374485 1.212534 0.683978 1.636985 -0.020727 1.002990 0.490099 1.193211 1.072433 1.116935 0.177132 1.577198 1.488833 1.426992 0.196808 1.359200 0.812178 0.923445 1.498869 0.535636 1.325569 0.453085 0.957271 0.999087 0.721363 0.748530 0.296873 0.424017 1.951248 0.179282 0.622927 -0.057442 0.420195 1.292402 0.421561 0.376166 1.549061 0.996315 0.165646 0.418099 0.201640 0.421702 0.831456 0.106402 1.463327 0.005503 1.240637 0.776492 0.181978 0.800991 0.047810 1.685961 1.102672 1.488982 0.855213 0.435527 1.756187 1.183435 0.997613 0.162344 0.965285 0.203761 1.756880 0.117280 1.723671 0.647873 1.760056 1.248565 0.397491 1.167098 0.048428 0.194870 -0.145837 0.946144 1.336821 0.037491 0.496156 0.411789 1.814729 0.171113 0.774274 1.046076 0.369134 1.865905 1.353847 0.811560 1.792633 0.305766 0.578868 1.799589 0.584644 1.768023 1.140595 0.983334)
      )

;;; 512 prime --------------------------------------------------------------------------------
(vector 512 43.486 #r(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      38.602884 #r(0.000000 1.082143 1.690042 0.893575 0.756109 0.365343 0.807438 0.940757 0.585435 0.342350 0.594341 1.140652 1.817226 1.102492 0.331462 1.612595 0.512173 -1.909591 0.094152 0.360726 0.151765 0.706858 0.749498 1.906233 1.235313 0.796232 0.500830 0.064536 1.490244 0.959772 0.522500 0.779779 0.400580 1.439171 1.288511 1.693600 1.634346 1.612029 0.250323 0.286364 -0.273948 -0.057072 0.444920 0.673291 1.660718 0.950511 -0.044480 1.277714 0.922828 1.742498 0.067040 1.123761 0.731844 1.393404 1.039320 1.324896 1.831174 0.387406 1.709067 0.274769 1.267431 0.959919 0.715608 1.693570 0.000362 1.870214 0.699669 0.668933 0.997821 -0.008050 1.092934 0.993144 0.278118 0.973866 0.508203 1.715050 0.139916 0.132362 1.047327 -0.053979 0.185439 0.405403 1.344059 0.788131 1.083324 0.893261 1.764451 1.883814 1.299760 0.554300 0.979273 1.155257 1.533722 0.768283 0.256481 0.366299 0.921394 1.649597 0.976718 0.165847 0.006944 0.856772 0.899715 1.074092 0.112821 1.082075 0.258835 0.138175 -0.004825 0.001351 1.429175 0.630347 0.684026 0.531342 0.847633 0.762458 0.815632 0.219787 0.092949 0.202477 0.797900 -0.145417 -0.117708 1.761218 0.769741 1.161104 1.342323 0.523211 0.405201 0.497008 0.787122 1.231664 1.866867 0.811507 1.822296 0.236359 -0.004728 0.793757 0.887814 1.429788 1.804982 1.942786 0.923502 0.603222 0.794618 0.368216 1.088308 0.796327 0.542686 1.544013 1.716025 0.878200 1.782174 0.062214 0.364255 0.646601 0.833457 0.599270 0.751311 0.607033 1.116295 0.605117 1.252490 0.144452 0.065646 0.340371 1.042827 1.788314 1.880686 0.569623 0.189168 0.776287 1.195192 0.727742 0.491941 0.571446 0.260116 1.294844 -0.224851 1.513707 1.029946 1.744464 -0.045793 1.705297 0.170929 0.776558 1.159210 1.100586 0.974908 0.889723 0.131669 1.514065 0.483669 0.374957 1.765248 0.173880 1.574655 0.579673 1.075226 1.695626 0.618344 0.910042 1.785601 1.685191 1.340397 -0.031592 1.930247 1.607968 0.311691 1.234826 1.008031 0.136574 0.693831 1.350593 1.790691 1.248723 0.321392 0.332409 0.211515 0.677389 0.675342 0.748083 1.542146 0.537541 0.945052 0.644544 1.587504 -0.198604 0.497285 1.589685 1.631769 -0.102021 1.434262 0.504366 1.007294 -0.071908 0.889783 0.106723 1.597262 1.184125 1.385914 1.784083 1.814813 1.444514 0.168106 0.275712 -0.230240 1.482952 1.749244 0.624319 0.820132 0.038543 0.453451 1.192705 1.551536 0.933988 1.412615 0.290421 0.996887 0.879431 1.841715 0.672561 0.642185 1.873294 1.346219 1.516340 0.034439 -0.025203 0.114641 1.027748 0.436673 1.695049 0.946949 0.531849 0.288148 0.279537 1.094778 0.375490 0.307554 0.627782 0.418409 0.832934 0.666935 0.114950 -0.053285 1.218299 1.879745 0.386673 0.915368 -0.165173 1.124058 0.466149 1.878428 1.629128 1.512993 0.806896 0.046040 1.932554 1.129093 0.063911 0.559840 1.823056 0.947920 0.467855 1.479381 1.855655 0.408469 1.725599 1.305170 0.270211 0.911615 0.523954 1.318986 1.354400 1.104393 0.792536 0.687738 1.816953 0.079500 1.734615 0.148004 0.393542 1.491324 1.809997 0.036899 1.917219 0.036016 1.292915 1.439271 0.992174 0.734749 0.043086 0.632449 1.678465 1.214089 0.407041 1.157576 0.467194 1.849834 1.465874 1.299867 0.452820 0.577350 1.178402 0.504471 1.704246 1.529399 0.119449 1.587272 1.187154 1.736018 1.251019 0.054071 0.448967 1.151610 -0.041983 -0.058564 1.189234 1.429143 1.489017 0.205182 1.257753 0.994036 0.781546 0.390902 0.744400 1.772431 0.919261 0.499894 0.419934 0.281518 0.736860 0.910447 1.681100 1.722013 1.141474 0.827377 0.320102 0.007503 0.593080 1.581219 0.475353 0.227567 1.630156 0.895436 0.162740 0.389713 0.427078 0.505436 0.990570 0.227561 1.922194 1.293488 0.525156 0.798692 0.804781 1.222760 -0.002373 0.214414 1.011966 1.489753 0.749041 1.209362 1.542616 0.129806 1.948618 0.096126 0.340987 1.210097 1.746925 0.607998 0.771692 0.843752 0.870293 0.931325 1.216995 -0.219011 0.558727 0.605157 0.764943 0.813267 0.109796 0.025290 0.418750 0.976910 0.611063 1.425653 1.312703 1.416454 1.541723 0.279510 0.000239 1.660016 0.196937 1.482933 0.237398 1.048222 1.226372 0.074770 0.565242 0.782888 1.814840 1.669287 0.878760 1.658003 1.628831 0.063412 1.934276 0.152397 1.633067 1.697411 0.919379 1.358819 1.021028 1.568829 0.560019 1.191100 1.722100 0.879855 0.967865 1.958702 0.180163 1.190964 1.472899 0.387723 1.635329 -0.004167 1.194302 0.101361 0.922515 1.847355 1.174116 0.380497 0.721821 1.201075 1.612741 1.020268 -0.168817 0.406276 1.455790 1.666789 0.232089 1.791143 1.515844 0.427944 0.351285 1.732308 0.954418 0.569378 1.065546 1.527300 1.587063 1.317922 0.415597 0.001422 1.240139 0.099248 1.639437 1.663543 0.562245 1.762090 1.669121 1.738347 1.503729 0.665114 0.450457 0.358214 1.358391 1.040768 0.320330 -0.191120 1.844458)
      )

;;; 1024 prime --------------------------------------------------------------------------------
(vector 1024 70.140 #r(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)

       65.349256 #r(0.000000 -0.129848 0.969209 0.836351 0.061754 1.032484 0.051397 -0.047672 0.218624 0.018916 -0.064346 -0.087720 0.896115 1.194836 0.077672 -0.093665 -0.097710 -0.086592 0.949666 1.122929 -0.067767 0.950039 1.122745 0.018018 0.930855 -0.245701 0.859196 -0.118393 -0.017421 0.154025 -0.211100 -0.109137 0.940842 -0.140564 0.967517 -0.167684 0.023269 0.025376 -0.045911 0.903419 -0.200515 -0.239733 0.820269 1.087952 1.103155 -0.067139 0.794572 -0.000447 0.796383 -0.050127 -0.097253 1.071546 0.028226 0.109239 0.999458 0.870447 0.946254 -0.081085 1.245293 0.861076 0.913395 -0.009593 0.921868 1.075746 0.111204 0.213778 0.007799 0.861516 0.879520 1.119282 1.112758 0.023180 0.087708 -0.039342 0.017034 -0.142251 -0.066926 0.123437 -0.087868 0.910913 0.108597 -0.196132 1.069560 1.014239 0.192506 0.075011 0.674937 -0.174632 1.062546 0.982886 -0.071153 -0.102231 1.008769 -0.021251 -0.043692 0.910660 1.203363 0.930076 1.192149 1.079643 1.139869 -0.102933 0.892075 1.081967 1.117296 1.069641 0.961155 0.889926 0.104236 -0.012679 1.018557 0.083425 0.102764 1.041332 1.049506 1.057530 0.927572 -0.192969 -0.132492 0.997314 1.171628 1.067315 1.038820 1.033745 1.322831 -0.007981 0.994085 0.965156 0.070645 1.143780 -0.097751 -0.035141 1.081372 0.841845 0.110341 -0.016561 1.124066 1.050833 0.937074 0.926741 -0.150226 0.056436 0.964946 1.014226 0.961483 0.200116 -0.027025 -0.042596 0.873435 1.128675 -0.074217 0.034750 0.002625 0.037174 1.052187 -0.007505 1.057468 -0.020629 0.954765 1.162873 0.836305 0.919671 0.176115 0.867824 0.159416 0.913293 0.972493 -0.057629 0.902111 0.973589 -0.086627 -0.008031 -0.139087 0.943821 1.137966 0.070214 -0.004563 0.871135 -0.028372 0.970905 -0.036782 0.845326 0.108872 0.880706 -0.063917 0.888627 0.925543 1.066596 0.853571 -0.093806 0.904332 -0.112339 0.945758 0.871634 -0.096140 1.001890 1.129246 0.963672 0.170539 1.085873 0.061910 1.045363 -0.043655 0.071480 -0.112838 1.140479 -0.203871 0.018032 0.967477 -0.109462 0.786798 0.159117 0.091987 1.000511 0.121439 0.998700 0.114766 0.043124 -0.051500 1.039391 -0.116269 0.884009 0.038584 0.870599 -0.009894 -0.177026 1.208055 1.281757 0.041090 1.074146 -0.185247 -0.160109 -0.084894 -0.013678 1.116236 0.043626 0.914436 1.186335 0.008002 -0.013450 -0.068550 0.867764 -0.069795 0.028624 1.053037 1.105179 1.148503 -0.078114 -0.107345 0.808140 0.888280 -0.101397 0.863680 -0.177989 0.805880 0.985054 0.997369 0.970739 0.045371 0.041317 -0.112380 1.007911 0.837435 0.969586 0.893134 1.011096 0.079245 0.911597 -0.043743 1.012740 1.031412 0.069924 0.910651 0.066980 0.855519 1.128309 1.046886 -0.009687 -0.147082 0.900969 1.137525 0.881305 1.084781 -0.031000 1.031283 0.123503 -0.135598 0.951868 0.887466 -0.122854 -0.039498 1.017664 -0.102471 1.018993 1.022945 0.093609 0.101814 1.044330 -0.102747 0.051954 0.001832 1.002061 1.025387 0.930853 0.958319 0.146189 0.932064 0.106399 1.032653 0.014707 0.032026 0.879101 -0.027770 0.031687 0.111934 0.802921 -0.076047 0.059286 0.065123 0.128711 0.974155 1.040636 -0.158251 -0.044445 -0.146345 1.152523 0.901758 -0.061750 0.921515 0.108254 -0.128639 1.088615 0.119335 1.107712 0.012965 0.831934 0.917791 0.827352 0.931376 0.029208 0.968659 1.110903 1.139422 0.103217 0.804597 0.104877 1.024813 1.110962 1.158506 1.074313 0.918885 1.091629 1.052239 1.155470 0.969547 0.176177 1.193274 1.000806 0.167489 -0.087811 1.272916 0.090580 0.837388 0.853777 0.021673 0.795498 0.153088 -0.039163 0.886259 0.953876 0.846456 0.902225 0.108103 -0.023242 1.091272 0.796242 1.011212 0.961046 1.021211 0.039001 -0.032781 1.042170 1.131254 1.092307 0.999148 0.071362 0.869992 0.079822 1.110594 1.044065 1.166722 0.955017 0.117000 0.059709 1.113545 0.131377 1.023012 -0.114272 0.975103 0.983023 -0.046717 0.032378 0.224959 -0.069345 0.040516 1.089631 0.899237 0.136151 0.832552 1.215356 0.881670 0.944211 0.848668 0.152316 -0.124640 0.919395 0.853571 0.038901 0.049308 1.049839 -0.129701 1.004425 -0.052754 0.002949 -0.037696 0.133904 -0.020847 0.967100 0.902003 0.019567 -0.130260 -0.157473 -0.071944 0.135523 0.944472 -0.199005 -0.011428 -0.057531 1.218722 0.021172 0.873547 0.871952 0.950595 -0.066828 0.911583 0.960085 0.059484 1.216384 -0.015251 0.921576 1.107399 1.190526 1.009427 1.067453 1.067973 0.105850 -0.001821 0.968722 0.047666 0.095350 1.060487 0.951973 0.082517 1.139249 1.053557 0.799986 0.981175 0.927100 1.108483 -0.113217 0.056334 0.923079 -0.168060 1.160952 1.109659 0.931859 0.005663 0.016298 0.221144 -0.021547 1.134376 1.041640 -0.085720 1.009292 1.001582 0.885811 0.011233 0.110421 0.907129 0.093259 0.973361 0.842954 0.055170 1.054987 1.014198 -0.048044 0.812989 -0.144503 0.010466 1.029196 0.774851 0.843001 0.004633 1.225056 0.948512 -0.001831 -0.091454 -0.110441 0.000770 0.042991 0.840050 0.957463 0.073186 1.131453 -0.127608 1.100834 0.028867 0.991329 -0.079297 0.226099 1.081074 1.094744 -0.196334 -0.315150 -0.099639 0.860961 1.022403 0.767717 0.956186 1.242205 -0.055123 0.982544 1.115183 0.186049 0.867447 -0.036624 0.161043 -0.021433 0.029621 0.825744 0.027361 -0.010122 1.051195 0.027158 0.125747 -0.012676 1.018144 0.217569 -0.139580 1.065948 0.653885 0.017558 0.122910 1.005607 -0.024503 1.016854 0.118126 0.117812 0.209380 0.129761 0.103368 0.851695 0.818381 -0.060532 0.047740 1.092005 0.126179 -0.128900 1.046458 1.172438 0.945933 0.969409 0.186286 0.067827 0.866733 1.045200 1.053391 0.154799 -0.076177 1.034977 -0.251459 0.843987 1.036970 0.109710 1.081980 -0.054976 -0.104881 0.977835 0.917720 1.151081 1.224827 0.036178 1.178894 0.852252 1.170082 1.170461 0.979772 0.962385 0.904510 0.000036 -0.069878 0.919872 0.173255 1.075581 -0.013411 1.144951 -0.113696 0.013363 1.098609 1.014644 -0.003549 -0.244091 0.859325 1.071514 0.043866 1.123524 0.973631 0.994259 0.294619 0.940489 0.920230 0.796504 -0.004450 1.029035 -0.000831 0.920995 1.002150 0.986683 1.009523 1.089643 0.007497 1.152282 0.045887 1.088386 0.885838 -0.027924 0.051985 -0.076538 -0.224663 0.028256 -0.124194 0.724391 1.154873 0.792085 0.945537 1.154353 0.115964 0.986499 0.966811 1.012457 1.019910 -0.144866 0.815479 0.985586 0.913383 -0.150963 0.023412 -0.040408 -0.003953 0.004799 0.998876 0.002820 -0.098213 1.057293 -0.129926 0.137392 1.102538 1.079292 1.089070 1.130675 1.020925 1.154058 1.123118 0.858700 0.978386 0.138491 0.154692 1.041549 1.046975 1.030488 -0.158543 0.870238 0.064134 0.875614 -0.094478 0.900905 0.880022 1.134267 0.779059 0.063545 1.070040 -0.086015 1.008573 0.109322 -0.247240 0.015151 1.151193 -0.102164 0.087261 0.007995 0.854703 1.140979 -0.090975 0.812937 1.001838 0.168940 0.981369 -0.006072 -0.134631 1.058021 1.081911 0.004162 1.014677 0.995130 1.055979 -0.015306 0.058775 1.111668 0.059318 1.008648 0.996646 0.848989 -0.109175 1.102945 0.116474 0.906494 -0.120660 0.877452 0.886871 0.085411 0.884701 1.181621 1.062561 0.189097 0.973371 1.214908 0.001252 1.030678 0.152018 -0.037592 1.176813 0.948804 0.061120 1.019977 1.028438 -0.000808 0.087217 0.826864 0.893273 -0.207696 -0.074786 -0.108728 0.152240 -0.121688 0.980366 -0.049309 0.988905 0.044844 1.037851 0.979360 0.997856 1.209193 0.179051 1.004545 0.962175 1.139200 1.064077 0.021192 0.871727 0.976645 -0.060807 -0.016180 1.233966 0.984256 -0.044995 0.845917 0.182605 0.998382 0.007096 -0.023173 -0.024155 0.146239 1.013539 0.995536 0.048524 1.174691 1.141919 1.101145 -0.104732 0.114083 1.102748 0.983142 1.123097 -0.131915 1.072939 -0.138725 0.845004 -0.163152 -0.079593 1.018944 1.012216 0.030165 1.054447 0.994960 0.152361 -0.060656 1.093567 0.946563 0.106698 0.153793 -0.034551 1.295949 0.943407 -0.163119 0.067866 1.194305 0.979105 1.022403 1.106721 0.934941 -0.016105 1.092573 -0.050474 0.132465 0.025768 0.046448 0.920971 0.032186 0.827060 -0.132549 0.143363 0.083704 0.912578 -0.030293 0.096970 -0.039315 -0.023765 1.016646 0.854818 -0.052889 1.056921 0.089890 1.018924 0.081699 -0.114805 0.930082 -0.021013 0.109704 0.995297 -0.078029 1.125314 0.178931 0.020308 -0.221485 1.187702 0.047629 0.040061 1.015073 0.069320 0.060090 -0.115159 1.088644 -0.081572 0.068986 0.955768 0.084087 0.114901 1.013399 0.080815 -0.114939 1.007244 -0.059946 1.062447 1.043256 0.100314 1.021597 1.004933 -0.021577 -0.187720 -0.061395 -0.075323 -0.009496 0.985795 0.872323 -0.046461 0.888848 -0.053261 -0.110021 1.099191 0.979002 1.060305 1.062463 1.171427 0.691334 1.098940 0.054888 -0.017909 -0.010409 -0.111589 0.082490 0.948398 1.144871 0.127743 0.031811 1.026180 1.046146 -0.030210 -0.103802 0.989801 -0.310437 1.153393 1.012685 0.952894 1.001378 0.015652 1.054587 1.328504 -0.151531 1.037238 1.151575 0.030623 1.108802 -0.028053 0.044671 0.901073 0.934031 0.058498 0.039050 1.065155 0.024139 -0.131291 -0.082086 0.854526 1.154246 -0.049980 -0.184925 1.049877 -0.115467 -0.018300 1.001119 0.057983 1.189518 -0.114544 1.258100 1.123841 0.961039 1.070424 -0.124628 0.209509 0.034004 0.948762 1.100182 0.083224 0.948264 1.081482 0.076927 -0.000455 0.950737 0.098354 1.005742 1.019785 0.974317 0.230726 -0.067827 1.165865 0.048218 -0.058027 0.937849 0.079916 -0.012394 0.069161 0.050349 0.906284 0.832283 0.101171 0.790746 0.156878 0.740395 1.017554 0.191391 0.080956 1.000597 0.844203 0.944456 -0.111179 0.982617 1.037761 0.099785 0.851180 0.116591 0.142708 -0.015906 0.096645 0.965791 0.020953 0.925519 1.197465 -0.055737 1.095928 -0.064679 0.010255 0.936661 1.178645 0.190866 1.141107 0.130145 0.023056 0.121484 0.185090 -0.056773 0.100045 0.069574 1.039529 0.996635 1.085726 0.949189 -0.165723 -0.039203 1.116369 -0.064244 0.940174 -0.154655 1.121041 0.902088)
       )

;;; 2048 prime --------------------------------------------------------------------------------
(vector 2048 102.619 #r(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)

       95.904258 #r(0.000000 -0.184827 -0.106502 -0.094974 0.803466 0.945074 0.963289 0.946874 -0.103266 0.049155 1.087214 0.886218 0.016107 0.059052 1.086003 0.896052 0.832875 0.168267 0.929954 0.104821 0.801629 0.032075 0.032796 0.227531 0.906532 1.124909 1.032850 0.878053 0.813900 -0.267885 0.885447 1.090714 0.853533 -0.000373 1.207049 0.922018 0.048308 0.893672 0.856221 0.975035 0.868154 0.098949 0.791588 1.196055 0.919249 -0.152557 0.991948 1.006717 1.133320 1.186246 0.920884 -0.060763 0.895777 0.020781 0.811521 0.941459 0.931533 0.044866 -0.116604 0.896466 0.029517 1.096540 0.918555 0.948344 0.929326 1.133930 0.012583 0.960301 1.199033 0.051836 1.012281 -0.182278 -0.104579 0.982487 0.083391 -0.235240 0.238134 0.851365 1.147123 -0.183897 0.931617 0.014719 0.969454 0.114930 -0.007528 0.927332 0.038357 0.920680 -0.081674 -0.182395 -0.011442 1.061361 0.921566 -0.084353 1.041705 0.161045 -0.067878 1.074036 0.941106 0.966219 0.919599 1.168159 1.032081 0.945189 0.044320 0.039817 -0.089720 1.130429 -0.069569 -0.278003 0.838588 0.754892 0.905296 0.076030 0.931578 0.143938 -0.063198 0.009752 0.994216 -0.018389 1.061023 0.998466 -0.064949 0.889855 -0.094736 -0.151667 1.224271 -0.191231 0.981083 0.017183 -0.228680 -0.064528 -0.051088 0.940309 1.101261 -0.034752 0.950794 -0.088223 1.190759 0.000979 1.058816 1.106846 0.070946 0.194156 1.093892 0.886993 1.017953 -0.051739 -0.284107 0.024602 0.969253 1.247816 0.935610 -0.089803 0.006657 0.841177 1.059923 1.023429 0.866137 0.046390 -0.124782 -0.252595 0.166144 1.083896 1.139053 0.949050 1.094868 1.174455 -0.189695 1.188365 1.031424 1.009889 1.067591 0.935164 0.237409 0.909064 0.009677 -0.177665 0.046406 1.016694 1.057379 -0.055836 0.052713 -0.065039 0.120813 0.836055 1.178838 0.902715 0.920359 0.806116 -0.117471 1.158887 0.994531 -0.009494 -0.163337 1.040739 1.131213 0.025531 -0.009616 0.139395 0.950856 -0.014744 0.115132 1.125894 -0.190579 0.101124 -0.125308 0.963704 0.026526 1.118700 0.022614 0.807945 0.913877 0.030742 0.927436 0.988232 -0.140750 0.124385 0.986885 0.991816 1.146772 -0.062919 0.074766 -0.034226 1.128490 0.957963 1.096308 1.046278 -0.048364 0.116505 1.136521 1.090002 -0.014238 -0.112155 1.033034 1.160610 -0.094599 0.068313 1.266010 1.098976 0.044651 0.131033 -0.116651 -0.075950 1.046348 0.030055 0.793219 -0.117150 1.124225 -0.160989 1.100541 1.045178 0.962828 -0.073358 -0.019227 1.173791 1.059709 0.937667 0.966884 0.928018 1.041334 -0.201315 0.174562 1.021851 -0.049449 0.907458 -0.107815 1.126703 0.073928 0.982065 0.825831 -0.033241 0.067472 0.917284 0.902681 1.015596 0.904075 -0.075353 -0.108265 0.963265 -0.090615 0.920339 0.977780 0.090733 0.904078 0.000883 1.347356 1.014221 0.985375 -0.100963 0.008783 0.942615 1.002685 1.149002 0.158462 0.917602 -0.099583 -0.025442 1.103430 0.071006 -0.151207 0.055689 -0.038941 0.098832 0.911418 1.062737 0.996744 0.760254 0.996130 0.014262 0.032851 0.956371 0.019061 0.996091 0.200667 1.164966 0.045741 0.060264 1.166834 -0.025387 0.966912 1.043716 0.969667 1.084931 -0.065039 0.974364 0.980017 0.844958 0.179207 0.723395 1.083973 -0.074447 0.912360 1.089065 1.005958 -0.119354 1.049441 0.937401 0.912303 0.937357 0.078173 0.927334 -0.094425 0.851189 0.132753 0.133028 1.043045 0.054936 -0.083812 0.903122 1.042637 1.178266 -0.107401 1.047050 -0.128737 0.160133 0.840861 0.896100 1.126802 0.903407 0.262267 0.053879 0.947798 -0.144016 -0.003985 0.146029 0.074915 0.771488 1.227288 0.890268 0.933106 1.075829 0.057968 0.066132 0.249704 -0.017827 0.090465 -0.047385 -0.060718 0.123360 0.988529 0.904277 -0.005465 -0.084169 -0.247831 0.999998 0.910292 1.144645 0.071091 0.088886 1.023713 -0.025414 0.984571 -0.240585 0.967555 -0.138539 0.196983 1.010405 -0.049670 -0.081707 0.064139 0.997860 0.836573 1.161272 -0.021657 0.041743 -0.127308 0.045553 0.018541 -0.044739 0.088082 0.142342 0.114457 1.055260 1.064567 -0.119380 -0.070251 -0.004341 0.963091 -0.120638 0.258819 1.053558 0.878500 1.069022 -0.123646 -0.014321 1.121295 1.085748 -0.044674 0.870738 0.685253 -0.051358 1.001113 -0.231350 0.033853 0.961438 0.037712 -0.113045 0.108555 1.037350 1.011749 1.028331 -0.080798 0.196328 0.059651 0.046311 0.977929 0.955683 -0.011917 0.990010 0.826271 0.043303 1.009806 1.189345 0.021063 0.072917 0.057585 0.061242 0.879010 0.849055 1.018528 0.955494 -0.055041 1.189587 -0.028346 -0.082984 0.099423 -0.024146 0.146930 -0.067314 0.849801 0.213148 0.924340 0.080454 0.905046 -0.129837 0.863551 -0.015056 1.161555 -0.111647 0.827215 0.819815 1.100249 1.048851 0.084224 1.096872 0.064524 1.027164 0.125925 0.828778 -0.032148 1.059894 1.017072 0.834004 -0.032573 -0.063582 1.159025 1.022326 0.063607 1.022556 1.099517 0.097842 0.150138 1.115534 0.951150 0.988949 0.155650 -0.134289 -0.115258 1.037176 1.021182 0.975772 1.072700 1.222345 0.924272 0.973662 0.930252 0.059705 0.077967 -0.109443 -0.103486 0.972696 -0.144205 0.802195 0.975677 0.802607 -0.042079 1.071307 1.022073 0.907916 1.035902 -0.048853 0.907965 0.883285 0.084385 -0.108649 0.944568 0.005988 0.933534 1.065312 -0.070265 -0.076879 -0.017044 -0.098932 1.208925 0.930986 -0.119229 -0.037509 1.090406 0.992176 -0.000651 0.937690 0.916741 -0.066544 1.095679 -0.058814 1.036581 -0.051849 -0.017058 -0.030283 0.051491 0.954183 0.950362 -0.021757 -0.062612 1.017252 0.855360 0.008584 0.998471 0.053177 -0.102277 -0.071410 -0.113602 0.020219 0.047660 0.112990 0.815120 1.152303 1.067537 1.052888 0.004076 0.157730 0.930208 0.885789 0.948613 1.018989 0.998994 -0.098675 0.134960 0.084711 0.092822 0.103312 -0.196457 1.024530 1.108457 0.891294 1.054699 1.016928 -0.022703 0.811591 1.004965 -0.017036 0.232325 0.973190 1.052258 1.071581 1.167101 -0.078778 1.126544 0.054092 0.108866 0.166665 1.087490 0.998143 -0.013409 0.871172 0.885040 1.019108 1.127064 1.196444 0.957927 0.852239 -0.008268 -0.145143 1.063054 -0.026011 1.007974 0.983277 -0.031336 1.126868 0.969557 0.015995 0.940510 0.206836 -0.166196 0.069999 0.106477 0.969534 0.962793 1.057184 0.039570 1.013939 0.966957 -0.186086 1.043328 0.103727 0.826020 0.082145 0.142187 0.193131 0.806568 -0.194497 0.073921 0.929470 0.014750 1.003891 1.130669 0.912871 -0.166896 -0.010434 0.224001 0.019969 0.882091 1.015999 0.050540 0.927299 -0.028913 0.088865 -0.038210 0.838785 0.179969 -0.063760 0.909551 0.970913 0.864195 -0.147216 1.017549 0.931612 1.076838 0.174334 -0.004854 1.146351 -0.071188 0.005023 0.983870 0.987921 -0.073293 1.144937 -0.008273 1.069178 0.160218 0.940671 -0.099513 -0.160986 -0.053460 -0.000349 -0.066930 0.258818 0.037651 0.899944 1.011860 -0.024019 0.049159 -0.114396 0.997122 0.988277 -0.086170 1.100402 0.827506 -0.071549 1.014472 0.830365 -0.029296 1.033932 -0.095907 -0.073030 0.967696 1.060165 0.920338 1.199129 -0.072200 0.053416 -0.126898 1.108390 0.903008 1.109424 0.964135 -0.083890 0.099047 -0.111937 1.079528 1.230021 1.124700 0.946124 1.081677 -0.089364 1.123287 0.082817 -0.048549 0.013111 -0.005217 1.016286 0.025359 -0.151572 1.137235 1.013948 1.006359 -0.020039 -0.117293 1.111762 0.892597 1.058754 0.795600 0.996014 0.931963 1.115786 -0.029889 0.877043 -0.234877 1.149674 1.027911 1.261517 0.048880 0.113954 -0.024127 0.075365 -0.048636 0.036252 0.831941 0.943628 0.982317 0.918776 1.086510 0.931126 -0.077364 0.039915 1.020953 -0.068839 0.962253 0.910823 0.025853 0.065365 0.021206 -0.021296 0.872652 0.026536 -0.052762 0.003250 0.029539 0.991921 1.021217 -0.042456 0.777756 0.980840 0.078981 -0.130613 0.133311 -0.065841 -0.085861 1.178451 0.115564 1.082062 1.015392 0.928586 0.967073 1.156891 -0.010223 0.936469 -0.154645 0.995277 1.073333 -0.010159 -0.073318 1.117785 0.123446 0.035440 0.914424 0.055982 1.255170 0.975126 0.021080 -0.037628 1.048938 0.871136 1.107293 0.955878 -0.056277 1.017033 0.090456 0.993267 0.757034 1.002409 0.941223 0.920711 1.181339 0.032023 -0.085516 0.974206 -0.026907 0.142086 -0.002800 0.952901 1.119119 1.039547 0.762175 1.056838 -0.114595 0.884738 0.718220 0.960728 -0.156479 1.189199 -0.165202 0.904637 -0.041429 -0.050488 -0.179745 1.054673 -0.082418 0.030881 1.160170 0.821960 -0.086297 0.010350 0.932553 0.035420 -0.009593 0.011040 0.051718 0.904123 0.028769 0.100605 1.033920 -0.169584 1.086360 1.131494 0.107596 -0.114123 0.021393 0.010364 -0.152848 0.035197 0.012279 -0.133590 -0.062321 1.204840 0.937029 -0.068386 1.145671 0.973614 1.135843 0.883055 0.070061 0.997608 1.003482 0.989245 1.204030 1.197676 0.838535 0.029369 -0.215349 1.060468 0.880276 0.931456 0.125650 1.132780 -0.117697 0.200533 0.075686 1.191015 1.016195 0.037000 1.110074 0.982317 0.982573 0.824837 -0.229925 1.006482 -0.062451 -0.057872 0.979641 -0.230341 -0.020939 1.006077 0.857917 1.098933 -0.267219 0.043265 0.935436 0.964162 -0.007168 0.164970 0.165342 1.068220 0.945315 0.948634 1.023862 -0.029831 0.992343 0.020292 0.067126 0.932456 0.808919 0.096733 0.000609 0.083113 1.019237 0.858419 1.013183 0.098990 0.930352 -0.062223 1.082324 -0.042610 1.104376 0.999943 -0.136202 0.964477 -0.092847 1.096219 1.036690 1.110447 0.987439 0.893158 0.111588 -0.094486 0.748732 0.981962 1.023640 1.021660 0.931300 1.325728 0.988586 0.832724 0.042650 -0.080219 -0.124412 0.083378 -0.047165 0.013229 0.179035 1.036229 0.106634 -0.154080 0.015828 -0.138512 0.228898 0.970943 1.152854 0.994299 1.087348 1.079495 -0.014073 0.985630 1.046303 0.921605 -0.148486 -0.082307 1.049524 0.140156 1.012720 0.976567 0.874688 -0.045198 1.031276 0.883380 0.011846 -0.003498 1.009216 0.885002 0.172619 0.843282 0.029227 -0.097679 -0.125796 0.933874 0.978897 0.725114 0.844720 1.075252 0.947844 0.926610 0.182857 0.841432 1.040159 0.998281 0.169201 0.136041 1.216461 0.161331 -0.074244 1.061895 0.862101 0.118827 1.150273 1.131402 0.028905 0.802992 -0.116645 0.004795 -0.035171 -0.225349 -0.011793 1.004637 1.052814 0.132105 0.965384 1.075721 0.233900 0.952135 0.901143 1.131006 0.032321 1.011176 0.873840 0.182329 -0.079077 0.896822 0.005166 0.903099 1.092780 -0.025076 -0.019178 0.015239 0.984311 1.216486 0.992874 0.054129 0.144836 0.099554 0.103521 0.100432 -0.026631 0.042079 0.163741 1.041917 0.792159 0.979852 0.977128 0.103524 1.113377 -0.157199 1.027202 0.929073 1.074076 -0.112317 0.199279 0.760239 0.001430 1.277148 0.009244 0.986963 0.109581 1.086070 -0.134094 0.327295 0.686709 -0.296672 0.932890 0.968488 0.216488 0.165531 0.285075 -0.094601 -0.165028 0.950486 0.963591 0.864035 -0.065266 1.013992 0.911092 -0.094152 -0.152792 1.070739 -0.039448 1.166353 -0.004048 0.032871 0.996625 1.100064 1.255396 0.839630 -0.081969 0.162263 0.140738 1.003998 0.779814 0.961648 1.146742 0.167212 0.925641 1.185256 0.824157 -0.033666 -0.007601 0.908697 0.230017 0.822888 0.740994 0.033372 1.160544 1.098836 -0.044005 1.021078 0.126042 0.049334 0.898357 1.032574 0.865757 0.947486 0.886121 0.055309 0.044278 -0.037421 1.134951 0.864539 -0.011595 -0.007199 0.067683 1.090102 1.092557 0.046997 0.027613 0.949146 0.875265 0.136983 -0.135656 0.985803 -0.132003 0.135341 0.013222 1.091309 1.098115 0.015599 0.119349 0.014805 1.069340 1.102334 1.032680 -0.031084 0.906554 -0.088863 0.069579 1.064396 0.128172 1.022790 1.107156 -0.057182 0.995012 1.054566 1.042520 -0.160709 1.125070 -0.094154 0.046403 -0.069345 0.119373 -0.184893 0.070830 1.044722 1.098693 1.111409 1.135049 0.985119 0.066473 0.058424 1.004842 -0.094015 1.117752 0.799547 1.268968 0.039520 0.996895 -0.102408 -0.030667 0.930842 1.078283 1.102597 0.055578 0.110127 0.923904 1.005813 0.918634 1.079133 -0.099263 0.905943 1.047321 0.848243 -0.009403 -0.068258 1.012623 -0.037975 1.142196 0.851851 0.109046 1.141382 0.890904 0.996832 -0.088058 1.288646 1.097971 -0.100491 0.918525 0.015332 1.145115 0.117738 1.014796 -0.205627 -0.177297 -0.006318 0.055035 1.183699 0.900390 1.055439 1.182836 0.107470 0.210820 -0.154634 1.100666 0.004257 0.125613 0.849489 1.120995 -0.046236 -0.066772 0.011079 -0.102932 0.932197 0.023264 0.246085 0.163405 0.869069 0.102531 1.077511 0.954854 0.038602 0.079792 0.927047 0.983181 1.030696 0.962590 -0.055603 -0.107934 1.126555 0.946728 1.063664 0.137033 -0.128875 0.885196 0.091522 0.893839 1.007955 0.978475 0.978266 0.067848 1.038168 1.090875 -0.061309 1.116028 1.016019 0.011872 -0.108054 0.108874 0.083760 0.113696 1.116111 0.014309 0.005128 1.099189 -0.004973 1.325065 1.221479 0.028469 1.235019 -0.212490 0.962518 1.027151 -0.044149 0.142639 0.155400 0.936540 -0.039180 0.937115 -0.085578 1.019973 1.270603 0.140594 0.061038 1.087655 0.063712 1.177018 -0.029958 0.758319 0.051019 -0.094233 0.962416 -0.006348 -0.003660 0.019678 1.112579 1.058837 -0.108754 0.005081 0.979604 0.909652 -0.162160 0.189741 1.115396 -0.046934 0.809487 0.174222 -0.004756 1.140939 0.812895 0.050537 0.171915 -0.128895 0.969610 0.953147 1.047572 0.122563 0.889198 -0.104048 0.001916 -0.008785 1.172703 -0.213570 -0.114233 -0.152007 -0.161789 -0.132968 1.055565 0.784424 0.202349 -0.012066 0.004158 -0.039121 1.114936 0.962613 0.954226 1.105200 0.985756 1.026320 -0.117780 0.866616 1.000189 -0.163224 0.999105 1.165142 0.001717 1.023313 -0.052468 -0.233246 -0.078417 -0.014831 0.008989 0.105092 1.100102 -0.114187 0.962275 0.827359 -0.135499 1.155899 0.983914 -0.197096 0.920622 0.925756 0.074101 1.105182 0.068112 0.889324 0.995794 -0.181975 1.079197 -0.174077 -0.086147 1.108775 0.836038 0.920177 0.069115 1.056833 1.065288 1.011220 0.037095 -0.051383 0.059023 0.966919 0.975420 0.992209 -0.050411 1.034776 0.060947 0.024827 0.189251 1.128565 -0.026102 0.882647 1.113292 0.059688 -0.055524 1.097931 -0.076831 0.148308 0.009684 0.993343 0.181407 0.980680 -0.253676 1.203786 0.837538 -0.111906 -0.046920 0.992998 1.138650 0.102810 0.732933 0.974495 1.134363 0.841220 -0.244832 0.191984 1.089926 -0.014286 1.033093 0.795315 0.027888 1.086315 0.921910 0.023081 1.023830 0.070684 1.183612 -0.197469 -0.072227 1.175515 1.132615 0.147372 1.165071 0.693358 0.086944 0.167356 1.154251 0.067038 1.011388 0.195281 0.162053 0.058855 0.118483 1.091391 1.199083 0.861074 0.152693 -0.184650 -0.275426 0.016699 1.041744 1.082925 0.896020 -0.212005 -0.028325 0.837564 1.192865 0.964038 1.140280 0.832699 0.060523 1.017736 0.007067 1.222558 0.776881 1.025602 0.136510 1.065558 0.031534 1.120667 -0.017440 -0.095844 0.986588 0.811881 1.008160 1.083596 -0.057608 1.030774 -0.185755 1.016553 -0.060277 0.044570 0.071469 1.026382 -0.218238 -0.134819 0.125155 1.052665 0.219534 1.053074 0.975626 0.942097 0.042773 0.914988 0.904458 1.068383 0.122945 -0.160737 0.195111 -0.112309 0.079404 0.873713 0.743694 -0.042029 0.017013 1.026689 -0.033216 0.846494 1.151063 -0.096712 0.933521 -0.150138 0.998351 0.097766 1.014397 1.003826 0.249110 -0.089820 -0.095115 -0.041617 1.005328 -0.026956 0.282608 -0.227117 0.900497 0.151081 1.074944 0.999410 0.070956 0.989252 1.046830 0.036838 0.060586 0.119680 1.033878 1.147593 1.072223 1.038019 -0.063806 -0.066418 -0.094579 0.121532 0.058665 0.065637 0.015630 1.033625 -0.167401 -0.044227 0.109799 1.069494 0.978455 0.951966 0.848373 1.183717 0.052564 -0.139052 0.109210 1.056692 1.084067 0.913136 0.026099 0.888367 1.004145 -0.006357 -0.186626 1.147417 0.008987 1.033956 0.198511 1.087879 0.153898 -0.007073 -0.053729 0.960733 -0.079153 -0.112602 0.118601 1.127696 0.124208 -0.118455 1.113389 -0.141400 0.095581 0.831887 0.079625 1.065606 1.064953 -0.043117 0.883460 -0.117838 0.984417 1.073930 -0.020071 -0.020565 -0.110661 -0.029427 0.000735 0.129840 -0.059144 0.853604 0.029159 1.153760 -0.035371 0.120975 0.829886 0.902305 0.004019 1.024841 -0.008315 -0.040841 0.081011 0.034157 0.925135 0.026143 -0.146226 0.818801 0.997553 -0.057337 0.039344 0.045043 -0.058730 0.061450 0.034397 0.032312 1.021479 0.069734 0.032385 -0.034352 1.143739 0.128130 0.837756 0.143447 1.191780 1.005715 -0.145746 0.060156 -0.089751 0.993522 1.117964 1.113924 -0.051214 0.989301 1.131346 0.978070 1.120586 -0.104089 0.755209 0.911168 0.043338 0.799533 -0.065789 1.035956 1.103884 1.108033 -0.011160 0.018199 1.076458 1.033226 1.049461 0.927281 0.875446 -0.132488 -0.016539 1.040494 -0.085837 0.845351 0.082137 0.957295 0.975488 -0.233161 1.046308 0.968283 1.119329 0.799388 0.835437 1.198178 1.006967 -0.080996 1.022071 0.222670 1.054955 1.028112 0.145964 0.775125 0.053077 -0.139928 0.982870 0.012204 1.181785 -0.055209 0.064440 0.028436 -0.055658 0.988257 0.885626 0.925751 1.041503 -0.102556 0.199169 0.817618 1.118232 -0.154162 1.103379 0.161217 0.043204 0.038827 0.297793 0.101115 1.084585 0.911258 -0.017387 1.093864 1.174369 -0.052884 1.010587 1.084918 1.042023 0.988052 1.008470 1.079842 0.911711 -0.105412 1.049916 0.966051 -0.030853 0.634323 0.027996 0.065373 0.165603 -0.198745 0.121133 0.904870 0.798116 0.109313 -0.023197 -0.012270 -0.099679 -0.007982 0.957938 0.064886 1.066324 0.891833 0.030809 0.008848 -0.058683 1.151904 -0.064909 0.005548 0.092447 0.994226 0.980543 0.036553 0.977629 0.908112 1.053035 1.015332 1.120582 1.029707 0.935519 0.767415 -0.107332 1.106993 0.051063 -0.090849 -0.152447 1.074408 0.930237 -0.134191 -0.041339 1.154220 0.912402 0.915882 -0.155688 0.004278 1.005960 -0.029173 0.929692 0.891253 0.904414 -0.022210 0.912185 0.032760 -0.175809 1.064184 0.004444 1.023131 0.014814 0.025559 0.065555 0.781532 -0.029379 -0.197955 0.897852 -0.013217 1.093294 0.004968 -0.102189 1.031592 0.748643 0.996666 0.053363 -0.174095 0.022123 1.073767 0.026629 0.817199 0.923850 0.016734 1.000997 0.181206 0.011231 0.956073 0.190711 0.864217 -0.176983 1.016978 1.028389 0.023092 0.841323 1.197465 -0.032185 -0.023935 -0.154948 0.938794 0.022079 0.018001 0.863273 0.095137 -0.103529 1.048691 1.044424 1.076913 -0.091685 1.016448 0.235867 -0.191122 1.021688 0.903834 1.103008 1.062811 0.974671 0.808982 0.919788 0.797299 0.003866 0.924240 1.138022 1.138392 -0.086041 -0.072381 1.089510 0.997304 -0.196238 -0.081117 0.998652 -0.136927 1.094476 1.025478 1.128812 -0.043799 -0.160622 1.202644 -0.097115 1.028359 1.128248 1.149200 0.046912 1.215106 0.095300 0.230991 -0.177631 1.060265 0.025009 -0.087069 -0.045585 0.107297 0.905981 1.067101 1.105134 0.200901 0.832244 -0.158358 0.063741 -0.002433 0.178939 1.150184 -0.013758 0.739082 0.970621 1.116445 -0.077580 0.874011 -0.000811 0.757786 1.027494 0.948749 0.128206 1.197540 -0.121973 -0.035650 0.227456 1.012591 0.093402 0.788900 0.046330 1.127347 0.937960 0.147998 0.295156 0.047168 -0.449697 1.185666 1.027567 1.056837 0.896828 0.093411 0.188188 1.051113 0.196550 0.986178 0.963111 1.064836 0.986799 0.068409 0.940694 0.044600 0.930849 0.776664 1.119660 0.877476 -0.187121 0.889222 0.896426 1.114193 0.109176 0.974296 0.017034 0.058848 0.003626 -0.056434 -0.053055 -0.327863 1.110462 1.191687 0.833810 -0.093180 1.062518 0.877602 0.130458 1.046517 0.945395 -0.042202 0.884421 0.076614 0.998365 0.963405 -0.042360 1.233324 1.032498 0.850640 0.878991 1.172081 -0.131938 0.138522 1.031223 -0.060356 1.045766 1.146384 1.014251 1.035122 1.033944 0.910994 0.140291 0.017496 0.074785 0.017803 1.051564 0.940908 1.102397 0.914000 -0.151381 -0.037398 0.841172 0.980431 0.926522 1.010521 0.906633 0.898542 -0.046207 1.056040 -0.119697 -0.388635 1.042092 1.062407 -0.114191 0.973897 0.038767 0.170771 0.104476 0.108748 0.973779 0.829369 0.903094)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

(vector 1 1.0 #r(0)
    )

(vector 2 1.7601724863052 #r(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
(vector 3 2.2325525283813 #r(0 0 0)
    2.0235652605711 #r(0 33/64 63/128)

    2.0214650630951 #r(0.0 0.52414411306381 0.48787820339203)
    2.021465 #r(0.000000 0.475854 0.512123)
    2.021465 #r(0.000000 0.524145 0.487877)
    2.021465 #r(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
(vector 4 2.8359191417694 #r(0 0 0 0)
    2.450505601523 #r(0 3/16 21/32 15/32)

    ;2.434727537119 #r(0 37 52 46) / 31

    2.4311048984528 #r(0.000 0.191 0.672 0.479)
    2.4311048984528 #r(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #r(0 0 0 0))
    2.4308773660653 #r(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #r(0 3/16 21/32 15/32))
    2.430877366065 #r(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #r(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
(vector 5 2.816308259964 #r(0 1 0 0 0)

    2.6048328876495 #r(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)
    2.604848 #r(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
(vector 6 2.9795869831363 #r(0 0 1 0 0 0)

    2.8369779013614 #r(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #r(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #r(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #r(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #r(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #r(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    2.836953 #r(0.000000 0.821609 1.597559 0.207843 0.087745 -0.093780)
    )

;;; 7 even --------------------------------------------------------------------------------
(vector 7 3.3825581073761 #r(0 0 0 0 0 1 0)

    3.0470769405365 #r(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #r(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    3.046965 #r(0.000000 0.503616 0.874674 1.000689 1.265332 0.709676 0.308046)
    )

;;; 8 even --------------------------------------------------------------------------------
(vector 8 3.611234664917 #r(0 0 0 0 0 1 0 0)

    3.197691 #r(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #r(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #r(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #r(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    3.197539 #r(0.000000 1.536753 0.015811 1.587753 0.138248 0.111716 1.317048 1.388715)
    )

;;; 9 even --------------------------------------------------------------------------------
(vector 9 4.0601739883423 #r(0 0 0 0 0 0 1 1 0)

    3.454235 #r(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #r(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #r(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 #r(0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    3.453978 #r(0.000000 1.619848 1.457320 1.896841 1.905503 0.244896 1.357384 1.495389 0.907798)
    )

;;; 10 even --------------------------------------------------------------------------------
(vector 10 4.0054845809937 #r(0 1 1 0 0 0 0 0 1 0)

     3.559069 #r(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #r(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #r(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     3.558711 #r(0.000000 0.271020 1.715408 1.541006 0.931409 1.702058 1.007613 1.237445 1.543048 1.918285)
     )

;;; 11 even --------------------------------------------------------------------------------
(vector 11 4.2368197441101 #r(0 0 1 1 0 1 1 1 0 0 0)

     3.656997 #r(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #r(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #r(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #r(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     3.656141 #r(0.000000 1.635206 1.752773 1.453484 0.177816 0.008586 -0.066147 1.102294 1.308244 1.599463 0.758738)
     )

;;; 12 even --------------------------------------------------------------------------------
(vector 12 4.4100483425078 #r(0 0 0 1 1 0 1 0 0 0 0 0)

     3.787770 #r(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #r(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #r(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     3.786929 #r(0.000000 0.551301 1.345490 1.538545 0.249324 0.811835 0.175379 1.377915 1.164645 1.102028 1.349918 1.044104)
     )

;;; 13 even --------------------------------------------------------------------------------
(vector 13 4.4076361656189 #r(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973518 #r(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #r(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 #r(0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 #r(0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     3.972554 #r(0.000000 0.227025 1.566229 1.025033 0.594027 -0.014872 0.545046 -0.165560 -0.014836 1.678196 0.010096 0.200561 0.709954)
     )

;;; 14 even --------------------------------------------------------------------------------
(vector 14 4.5770673751831 #r(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.096703 #r(0.000000 0.927014 0.985352 1.221418 1.415761 1.483290 1.243140 0.836933 0.772657 1.390170 0.023348 0.810693 1.940171 1.444293)
     )

;;; 15 even --------------------------------------------------------------------------------
(vector 15 4.7838921546936 #r(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.192089 #r(0.000000 1.673474 1.702683 0.182852 0.310553 1.756894 0.658556 0.335052 1.332116 0.055950 0.587971 0.464438 0.317829 1.684035 1.844319)
     )

;;; 16 even --------------------------------------------------------------------------------
(vector 16 5.0737318992615 #r(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.325044 #r(0.000000 0.953571 0.856165 0.561119 0.376819 -0.035768 0.021241 0.436352 0.339200 0.281830 1.047126 1.263828 0.181703 1.324018 0.701028 1.340302)
     )

;;; 17 even --------------------------------------------------------------------------------
(vector 17 5.2332563400269 #r(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.463016 #r(0.000000 1.478182 1.023133 1.293051 1.222719 1.187462 1.479990 1.285327 0.088371 1.348357 0.403976 0.365587 -0.044469 1.267681 1.387786 0.039745 0.610112)
     )

;;; 18 even --------------------------------------------------------------------------------
(vector 18 5.3310880661011 #r(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.569421 #r(0.000000 1.011793 0.580064 1.185332 1.624771 0.036509 -0.103084 0.721775 1.089226 0.493658 0.073953 1.074825 1.595710 1.108207 1.196849 1.497424 1.163445 0.995437)
     )

;;; 19 even --------------------------------------------------------------------------------
(vector 19 5.4619059562683 #r(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.741489 #r(0.000000 1.217162 0.660633 0.437661 1.320878 1.235636 0.094939 -0.184508 -0.090396 0.415156 1.119340 1.141612 0.652398 0.817014 0.525642 1.150459 0.295913 0.906911 0.831168)
     )

;;; 20 even --------------------------------------------------------------------------------
(vector 20 5.5266017913818 #r(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.839482 #r(0.000000 0.882739 0.097549 0.018330 1.302731 0.272028 1.407538 1.702479 0.580972 1.045015 0.992304 1.669564 0.673981 0.282219 0.289947 0.363499 1.033218 0.803741 0.771035 0.508087)
     )

;;; 21 even --------------------------------------------------------------------------------
(vector 21 5.6849967470046 #r(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.919735 #r(0.000000 -0.021966 1.377831 1.499470 -0.139205 1.937761 0.320320 0.217546 0.069290 0.938854 1.308616 0.123782 0.469963 1.818882 1.581666 1.414927 0.056553 1.301602 0.788305 1.336052 0.607478)
     )

;;; 22 even --------------------------------------------------------------------------------
(vector 22 5.8572781078687 #r(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.055233 #r(0.000000 -1.550778 1.843415 0.900724 0.955590 0.677531 1.390686 0.133831 1.229871 1.016503 1.245622 1.546957 -1.869615 1.414871 -0.060378 -0.077148 1.210164 1.132173 0.909114 1.325478 1.285781 0.509617)
     )

;;; 23 even --------------------------------------------------------------------------------
(vector 23 5.9208135892745 #r(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.147900 #r(0.000000 0.493561 0.617878 0.386087 -0.215675 1.136922 0.632292 0.891205 1.398746 0.878537 0.676611 0.945565 0.610792 -0.182076 0.354229 1.383426 1.649635 0.414770 0.152656 0.561509 0.267633 1.102796 1.466348)
     )

;;; 24 even --------------------------------------------------------------------------------
(vector 24 6.0318420391191 #r(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.253162 #r(0.000000 0.045084 0.641921 -0.205904 0.266767 1.228115 0.912709 0.214922 1.487762 1.357882 0.864877 0.404420 0.601935 0.594931 0.069420 1.052347 1.659787 1.624121 0.035857 0.245103 1.406872 0.042697 -0.053953 0.167577)

     5.253153 #r(0.000000 0.045202 0.642246 -0.205352 0.266926 1.228585 0.913398 0.215740 1.488650 1.358650 0.865965 0.405240 0.603061 0.596132 0.070695 1.053498 1.661316 1.625634 0.037488 0.246663 1.408918 0.044558 -0.052337 0.169870)
     )

;;; 25 even --------------------------------------------------------------------------------
(vector 25 6.1513186981755 #r(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.403228 #r(0.000000 0.045060 1.794212 1.406802 1.249045 0.257853 0.430644 -0.020674 0.209605 1.159346 1.742584 0.244624 1.006989 0.948352 0.613996 0.229169 0.745474 0.773295 0.271006 1.529917 0.384835 1.822065 0.327936 0.153008 0.689262)
     )

;;; 26 even --------------------------------------------------------------------------------
(vector 26 6.2921685546205 #r(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.452331 #r(0.000000 0.051327 0.204117 1.807782 0.408597 -0.021081 0.115796 0.407761 0.824888 0.626144 0.637118 0.067354 0.844059 0.574978 -0.127497 -0.091341 1.702516 0.546084 0.986055 1.260143 0.631019 1.781357 1.305578 1.812413 0.666374 0.989339)
     )

;;; 27 even --------------------------------------------------------------------------------
(vector 27 6.2436904245852 #r(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.620374 #r(0.000000 -0.021456 0.516604 0.372410 0.864531 1.336703 -0.209149 1.689313 0.033950 1.772624 0.571345 1.616802 0.355488 1.092886 1.391271 1.240098 1.111612 0.854249 0.888716 0.157123 -0.311986 1.252460 1.082038 -0.272435 1.564985 0.964546 1.600742)
     )

;;; 28 even --------------------------------------------------------------------------------
(vector 28 6.5361909866333 #r(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.731679 #r(0.000000 1.447589 1.395977 0.797533 1.295906 1.462640 1.534875 1.774902 1.013697 0.705377 0.626264 1.242696 1.362454 0.181714 0.805604 1.271981 0.570662 1.779635 -0.124462 1.352040 -0.225912 1.764222 0.153642 1.298969 0.773437 0.201599 0.803480 0.102660)
     )

;;; 29 even --------------------------------------------------------------------------------
(vector 29 6.6767044067383 #r(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.766338 #r(0.000000 1.750571 1.825931 1.106253 0.681108 0.654013 0.530242 0.078216 0.174544 1.354195 1.454712 1.045782 1.722411 1.607453 0.347380 0.849326 0.377709 1.136286 1.004911 0.970793 0.410809 0.919085 1.010160 0.193230 0.966878 0.662369 1.289507 1.533180 0.429508)
     )

;;; 30 even --------------------------------------------------------------------------------
(vector 30 6.6998701095581 #r(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.906955 #r(0.000000 0.906624 1.374273 1.276597 -0.178673 0.094922 0.333601 0.129339 0.400307 0.946356 1.401096 0.557587 0.654474 1.274947 0.061009 -0.048005 1.903626 1.753056 1.439902 1.944968 1.607217 1.115332 0.419220 1.617499 1.734563 1.091117 0.095163 0.781775 -0.001559 1.852411)
     )

;;; 31 even --------------------------------------------------------------------------------
(vector 31 6.8660564422607 #r(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.987789 #r(0.000000 1.294084 1.380328 1.151198 1.131917 1.032100 1.467500 1.317593 1.561230 1.149337 1.426512 0.310391 0.093956 -0.092069 1.618651 0.385482 1.276093 0.768907 0.092705 1.372235 0.935730 0.030657 0.353616 1.817773 0.372502 0.700675 1.341184 1.537494 1.331726 0.302069 0.818207)
     )

;;; 32 even --------------------------------------------------------------------------------
(vector 32 6.9974670410156 #r(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.061091 #r(0.000000 0.284769 1.824838 0.360868 1.114185 0.962149 1.153553 1.836957 0.183317 1.504519 0.431670 1.106470 0.465083 1.359049 1.532974 1.672623 0.833072 1.851412 -0.259099 1.829526 0.240313 0.782734 0.067562 1.704922 0.670838 0.000337 1.835105 1.184487 1.464400 1.660678 0.971147 1.137597)
     )

;;; 33 even --------------------------------------------------------------------------------
(vector 33 6.978609085083  #r(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.161940 #r(0.000000 -0.089768 -0.397651 1.380488 -0.296115 0.371420 0.345733 0.379911 0.132923 0.160976 1.358964 0.245096 0.262235 0.223412 1.423478 1.677942 1.241899 1.681613 1.672008 0.466592 0.705799 0.934883 0.362064 1.890359 1.331917 0.587637 1.400151 1.803286 0.414943 0.770222 0.167447 0.874856 0.070813)
     )

;;; 34 even --------------------------------------------------------------------------------
(vector 34 7.2615523338318 #r(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.222816 #r(0.000000 -0.031974 0.094234 0.502100 0.850042 0.574691 0.752336 1.914959 -0.024174 0.146232 0.295078 1.383128 -0.007584 0.943763 1.235227 0.413741 0.587141 -0.053979 1.839683 0.252526 0.156123 0.682869 0.409598 -0.127649 0.823619 0.505563 1.228553 1.452425 1.154757 0.224780 1.122198 1.589227 1.075252 0.529430)
     )

;;; 35 even --------------------------------------------------------------------------------
(vector 35 7.2921919822693 #r(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.361719 #r(0.000000 -0.110076 1.552929 0.219162 0.236735 1.172346 0.133490 0.808935 1.471212 1.403523 0.917858 1.560138 -0.097659 1.196647 0.222164 1.202507 0.775221 0.877704 1.784095 1.125472 1.421754 0.952526 0.640748 1.820898 1.425049 -0.515027 1.354970 1.568414 1.484179 0.525947 0.577101 0.869046 -0.129339 -0.102295 0.425922)
     )

;;; 36 even --------------------------------------------------------------------------------
(vector 36 7.3326554298401 #r(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.431620 #r(0.000000 0.006000 0.080554 1.389520 0.900116 1.459969 0.132102 1.664590 1.525093 1.474799 0.953152 1.333207 1.242869 1.398672 0.151209 1.068678 0.656814 1.431920 1.083387 0.098458 0.329358 1.795094 1.464539 0.858423 1.694073 1.035274 1.250013 0.177341 -0.128516 0.159400 -0.011010 0.388177 0.716334 1.600747 0.574942 0.831074)
     )

;;; 37 even --------------------------------------------------------------------------------
(vector 37 7.4919209480286 #r(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

	6.530177 #r(0.000000 0.005180 0.879021 1.499280 0.275160 0.799109 1.677585 0.544852 1.266168 0.345286 -0.530036 0.352059 -0.808225 0.494187 0.001305 1.415607 1.022846 0.371397 1.442210 1.100282 1.338874 0.863557 0.625344 0.182117 0.191106 -0.132868 -0.127650 -0.033705 0.307163 0.314512 0.001878 0.475351 0.638583 1.230561 -0.337497 -0.118088 0.370183)
     )

;;; 38 even --------------------------------------------------------------------------------
(vector 38 7.669114112854 #r(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.535958 #r(0.000000 -0.016047 1.375557 1.774409 0.240697 1.758438 1.787887 1.049055 1.285090 0.290003 0.323134 1.732540 1.557371 0.401752 0.328608 -0.066450 0.228846 0.961168 1.593631 1.398529 0.653699 0.406608 1.324320 0.103681 1.934570 0.275301 0.402675 1.517210 0.582543 0.007477 0.262240 1.801738 0.419772 1.606650 1.104008 1.310911 1.419744 1.728289)
     )

;;; 39 even --------------------------------------------------------------------------------
(vector 39 8.0062685830938 #r(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.680209 #r(0.000000 1.091428 0.280383 0.244205 1.670732 1.669488 0.224029 1.575189 0.233312 0.318787 1.768213 0.518384 0.569316 0.693754 0.363934 1.013259 0.661691 0.458578 1.700546 0.350928 -0.213387 0.356085 -0.045461 -0.104865 0.565481 1.088276 0.042255 1.397895 0.807270 1.344295 0.014241 0.398536 0.486672 1.385842 1.323567 1.486471 1.397014 0.644495 0.514685)
     )

;;; 40 even --------------------------------------------------------------------------------
(vector 40 8.0304555793911 #r(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.747628 #r(0.000000 0.028396 0.023284 0.137090 1.639113 1.203686 0.744505 -0.148612 0.506591 0.560243 -0.084058 -0.079706 0.150354 0.575406 1.047012 1.731999 1.933088 1.304747 -0.055909 1.483517 1.131264 0.871845 1.564235 1.665008 1.479340 0.852900 0.123210 0.569321 1.544830 0.060646 1.376451 0.740700 -0.238394 1.304019 1.522364 1.550202 0.223048 1.493425 0.104840 0.387772)
     )

;;; 41 even --------------------------------------------------------------------------------
(vector 41 8.2169809341431 #r(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.880353 #r(0.000000 0.135702 0.436760 -0.018715 0.600438 -0.298825 0.298468 -0.293952 -0.126948 1.377543 1.225061 1.010086 0.994900 0.165805 0.056718 -0.315888 -0.413100 1.322145 -0.217343 0.005506 1.717653 0.634203 0.520907 0.977473 1.415853 -0.764924 1.376221 0.284984 1.473542 1.362417 0.550900 -0.330993 1.189698 0.376721 1.222396 1.700794 0.053091 0.666251 1.562750 1.319150 0.169270)
     )

;;; 42 even --------------------------------------------------------------------------------
(vector 42 8.3605623245239 #r(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     6.939974 #r(0.000000 -0.011476 1.282513 1.747339 -0.277688 1.211500 1.007410 0.488428 0.606299 1.401073 -0.002078 0.313765 0.237406 -1.794782 -0.081922 1.631362 1.138956 0.607469 1.715948 0.367593 0.487696 1.161873 0.717506 -0.061322 0.892863 0.566417 0.552814 0.668102 0.957673 1.124783 0.001669 1.055782 1.736467 0.689242 0.148964 0.036152 0.189064 0.816794 0.403572 1.283363 0.154311 0.470068)
     )

;;; 43 even --------------------------------------------------------------------------------
(vector 43 8.3471550144283 #r(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.051741 #r(0.000000 0.051990 1.655214 1.614096 1.907068 1.555280 1.515249 0.134511 -0.008664 1.732014 0.139869 1.723565 0.949408 0.871522 0.314394 0.786924 0.732932 1.794506 -0.190910 1.208261 1.598287 0.291774 1.820337 1.379860 1.075510 0.465725 0.309719 0.898505 1.316947 1.589390 0.877160 1.604060 0.883546 1.819205 0.861308 0.626832 0.933402 0.982260 1.688986 0.256547 0.614293 0.017902 0.815483)
     )

;;; 44 even --------------------------------------------------------------------------------
(vector 44 8.4271850585938 #r(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.039071 #r(0.000000 -0.013925 1.023977 1.694880 0.930341 0.651512 0.795511 1.050515 0.480329 0.354015 1.426204 0.565497 0.572134 0.017162 0.112749 0.257720 0.557774 1.761476 1.449185 0.624483 0.049559 0.540675 0.195927 0.677804 0.145100 0.602117 0.677838 1.156300 0.887800 1.868297 0.021883 1.107061 1.432208 1.416051 0.540282 1.556144 -0.158254 0.781340 0.300342 0.637855 1.472235 1.471264 -0.329868 1.025266)
     )

;;; 45 even --------------------------------------------------------------------------------
(vector 45 8.6353975051189 #r(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.164277 #r(0.000000 0.107694 0.427808 0.236493 0.439176 -0.374197 1.937652 -0.102495 -0.132721 -0.032953 1.675111 1.775652 0.507632 0.340555 0.542717 1.099543 0.276662 -1.622952 0.531824 0.218194 1.152824 1.344859 0.799252 1.617912 1.391892 0.192249 0.469216 0.602449 0.590449 -0.058189 1.514734 0.926343 1.087922 0.239108 0.589019 1.537544 0.316405 0.049287 1.141222 0.866006 0.287862 0.971067 -0.103613 1.326005 0.198578)
     )

;;; 46 even --------------------------------------------------------------------------------
(vector 46 8.7939519711145 #r(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.274042 #r(0.000000 -0.051277 1.027390 -0.132315 -0.261291 1.228854 0.251032 0.552380 0.763319 1.475452 -0.143798 1.181971 0.013380 1.773607 0.881801 1.886030 0.224945 0.302202 0.441836 1.175852 0.673622 1.344439 0.083924 -0.087160 0.770933 -0.028156 -0.368444 0.042592 1.039360 1.409391 0.224578 -0.058999 -0.207178 1.197154 1.631467 1.203180 1.212389 1.178680 -0.059957 1.263246 0.941340 0.484593 -0.188237 0.022295 1.493842 0.056638)
     )

;;; 47 even --------------------------------------------------------------------------------
(vector 47 8.7835607528687 #r(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.289833 #r(0.000000 -0.084036 1.432202 1.038781 1.950274 0.643485 0.068192 0.031910 0.175982 1.154336 0.840376 0.162660 1.553338 0.428086 0.958882 1.078146 0.916135 0.329186 1.812161 1.725702 0.107796 0.801029 1.365926 1.322756 0.454281 0.641662 0.067460 0.812185 1.185908 0.895886 1.814744 1.472340 1.187400 1.730085 1.557437 -0.068103 0.961873 1.346362 1.135399 1.218693 1.372521 0.881925 1.187221 -0.077728 0.628762 0.087203 0.981360)
     )

;;; 48 even --------------------------------------------------------------------------------
(vector 48 8.9965600967407 #r(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

	7.392344 #r(0.000000 0.041989 0.861058 0.962468 1.692550 0.528740 1.024259 1.846307 0.716582 1.454867 0.482722 1.288115 0.005482 1.234309 0.262300 1.329545 0.131162 1.430020 0.835179 1.760914 1.026634 0.423777 -0.011457 1.278725 0.497659 0.158517 1.709205 1.351746 0.876088 0.681233 0.363631 0.260083 -0.372612 -0.063945 1.609636 1.595878 1.709081 1.757152 1.898429 1.643054 1.528083 0.139338 0.402100 0.779097 1.034633 1.503447 1.629751 0.183091)
     )

;;; 49 even --------------------------------------------------------------------------------
(vector 49 9.1650037765503 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

	7.528963 #r(0.000000 0.025796 0.542400 1.221275 1.027807 1.048881 0.579715 1.623597 1.304022 0.646018 1.813995 1.364556 -0.023380 0.351532 1.944763 0.139707 0.122998 1.590897 1.500086 0.679592 0.550010 0.935112 -0.422992 1.572225 0.854349 0.812136 0.740870 0.257088 0.891426 0.375100 0.443922 1.209635 0.678555 1.187921 0.933346 1.608133 0.754516 0.492881 0.403863 0.222111 0.791315 1.109188 1.486048 0.297140 1.571132 0.381610 0.730980 1.585357 0.658651)
     )

;;; 50 even --------------------------------------------------------------------------------
(vector 50 9.1582123370176 #r(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

	7.547107 #r(0.000000 0.031868 1.397571 -0.229462 -0.248337 0.985174 0.797872 0.567031 1.538504 0.581471 0.395462 1.817148 1.102560 0.918084 1.654360 0.326944 0.011851 0.556327 1.590725 1.453292 0.727461 0.927759 1.546104 1.487290 1.485538 0.934774 1.075778 1.544753 -0.203760 1.697754 0.512269 0.290368 0.574819 0.284759 0.964263 0.133726 -0.145603 -0.080649 1.030600 0.038821 0.553063 1.188703 0.128936 0.847862 0.398867 1.774273 0.047566 0.064041 1.784664 0.244537)
     )

;;; 51 even --------------------------------------------------------------------------------
(vector 51 9.3615226745605 #r(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

	7.568561 #r(0.000000 -0.176109 1.559676 0.628231 1.207241 0.011758 1.593685 0.362952 1.845250 1.221521 0.935951 0.879199 1.173416 -0.322322 0.823235 0.690110 1.462830 -0.472669 -0.099342 0.958199 1.045903 1.131435 0.514297 0.608428 0.294087 0.558567 0.598851 0.631120 0.215182 1.202641 1.412924 0.839936 -0.189783 0.391594 1.311224 -0.628842 0.969088 1.206622 0.390013 1.225874 0.831020 -0.254475 1.488215 1.198893 1.660505 0.153171 0.589831 0.097658 -0.493115 0.832657 1.410178)
     )

;;; 52 even --------------------------------------------------------------------------------
(vector 52 9.449512348335 #r(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

	7.705039 #r(0.000000 -0.120160 1.339340 1.336393 1.596047 -0.162471 1.078938 -0.144525 0.558272 0.478329 0.119472 1.390538 0.505661 0.502476 1.790071 1.049001 1.328756 0.582830 1.143369 0.675881 0.702829 0.651237 0.534339 1.745506 1.739276 1.676180 -0.240345 0.150777 0.681206 -0.194935 0.104756 -0.005077 0.926218 1.333708 1.346707 1.577141 0.294151 -0.029928 1.425852 1.208701 0.288918 1.491470 0.174706 1.893172 0.747764 0.193381 0.900774 -0.013909 0.008458 1.330217 1.507450 0.151486)
     )

;;; 53 even --------------------------------------------------------------------------------
(vector 53 9.6159172058105 #r(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.747803 #r(0.000000 0.039194 0.620413 1.389371 1.443121 0.207159 1.404682 0.719170 0.556070 0.042067 0.345452 1.842252 0.547431 1.492389 1.345143 1.377757 1.130868 1.021817 1.670152 0.554105 0.161080 0.441217 1.158102 -0.062355 0.315571 0.566448 1.168684 1.842060 1.166280 1.782185 0.001290 0.219286 1.155722 0.636430 1.200817 0.245333 -0.135734 1.273218 0.923412 0.943855 0.727077 0.756973 1.213346 1.282414 1.075026 1.359176 0.575167 1.463730 0.719009 0.555783 1.516676 1.235856 0.727835)
     )

;;; 54 even --------------------------------------------------------------------------------
(vector 54 9.5190944671631 #r(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.842903 #r(0.000000 0.060027 0.632572 0.840534 1.609956 1.150996 1.709999 0.505283 -0.042316 0.311030 0.314470 0.988539 1.352916 1.063701 1.713792 1.604820 0.132996 0.924299 -0.380640 0.854614 1.638153 0.814465 1.013932 0.862189 0.327985 0.193317 0.897117 1.733078 0.873773 -0.001006 0.106707 0.215303 1.656885 0.272377 1.907118 1.437374 1.086294 0.702032 0.410835 1.401875 1.872443 0.559095 1.401872 1.777073 1.634625 1.674015 -0.089409 1.647357 0.860412 0.137791 1.828229 0.309024 0.084316 1.711228)
     )

;;; 55 even --------------------------------------------------------------------------------
(vector 55 9.6719217300415 #r(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

	7.887815 #r(0.000000 0.067810 1.737812 -0.122811 1.443124 -0.221123 1.362562 0.111083 0.515147 1.202804 -0.153742 0.092056 0.069487 0.163947 1.016287 -0.237810 0.532869 1.386552 0.450227 0.594886 1.080091 0.970410 0.337739 0.449452 0.269437 1.420564 0.034163 1.611412 1.032737 1.077792 -0.088229 1.558506 1.155871 0.005672 1.401629 0.758850 0.618931 1.028067 0.755333 1.491859 0.361129 0.610064 0.849797 1.145175 0.723610 0.997214 1.749864 1.465370 0.865700 0.198966 0.422473 0.083554 1.249104 0.535008 0.693476)
     )

;;; 56 even --------------------------------------------------------------------------------
(vector 56 9.6809562784664 #r(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

	7.974749 #r(0.000000 0.037394 0.887445 0.468860 1.746295 1.175646 1.159058 -0.083690 0.977865 1.021939 1.733675 0.463519 0.830986 1.607222 0.977261 1.046527 0.951993 1.337952 1.473478 -0.287182 1.438401 1.666254 0.969024 0.935004 1.368599 0.490566 0.476226 1.378285 -0.102374 1.514691 0.025972 0.974916 1.059546 1.242181 0.851020 1.471951 0.715432 1.703562 0.195156 0.437186 -0.035775 1.014304 0.379158 0.200049 -0.047378 1.663383 0.814982 0.493191 1.371344 1.638725 -0.211432 -0.265471 0.946425 1.299701 0.609040 1.600091)
     )

;;; 57 even --------------------------------------------------------------------------------
(vector 57 9.8992366790771 #r(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

	7.965546 #r(0.000000 -0.095638 1.629377 1.505743 -0.257865 1.542542 0.081191 1.216552 1.252972 0.250947 1.706903 -0.287910 0.050289 0.059867 1.658443 1.577681 0.529653 0.483034 1.093472 0.038780 0.154944 1.137344 0.082702 1.405634 1.058661 1.871514 1.718727 0.668182 0.658605 1.088944 1.503251 1.281426 1.583329 1.761936 1.213156 -0.067149 0.722542 1.593715 1.096874 0.601765 0.752401 0.850940 0.371687 0.656775 0.267872 0.662654 -0.352493 1.531419 0.632686 1.247324 -0.006437 1.833582 1.898768 1.055175 0.588965 1.020315 -1.860450)
     )

;;; 58 even --------------------------------------------------------------------------------
(vector 58 9.8761510848999 #r(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.100734 #r(0.000000 0.021430 0.347022 0.713737 0.905092 1.645754 0.229912 0.474077 0.105073 1.934132 1.209338 1.104304 1.062614 0.356876 0.785787 1.466271 1.235630 1.772115 0.072671 1.559512 1.754734 0.145493 0.220621 0.049952 1.441273 0.332650 0.674384 1.791015 1.230070 1.303791 1.623175 1.659342 0.994865 1.203930 1.296077 0.837641 0.520635 1.476430 0.531243 1.438107 1.534372 0.922866 1.864597 1.503104 0.404808 1.260145 0.588520 1.403415 1.378729 0.219397 1.535041 0.130713 0.617885 0.285219 1.710688 1.399341 1.461475 1.578234)
     )

;;; 59 even --------------------------------------------------------------------------------
(vector 59 10.094394683838 #r(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.191906 #r(0.000000 0.208043 1.068640 1.415957 0.657053 0.440995 0.455186 -0.041082 0.110511 1.241704 1.296019 0.277579 0.902913 1.621412 -0.074519 0.791975 1.674757 0.759979 1.631215 1.291991 1.012910 1.277340 0.631619 1.165525 0.635918 0.084682 0.823773 1.206086 -0.065324 0.207012 0.192120 0.437715 -0.091880 1.817464 1.121287 1.279417 -0.286096 1.867658 0.184266 0.100569 0.053843 0.263570 0.392050 0.142817 1.000313 0.341265 0.101419 1.503434 0.847586 1.429859 0.784752 -0.103598 1.892264 0.866894 0.288620 1.506687 1.614658 1.620036 0.310805)
     )

;;; 60 even --------------------------------------------------------------------------------
(vector 60 10.333255371943 #r(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.294966 #r(0.000000 -0.063009 -0.094522 0.425797 1.374786 1.483081 0.148545 1.000132 0.525611 1.640807 0.203662 1.078679 -0.256584 -0.149469 1.403978 0.141642 1.329452 -0.046303 0.679783 0.183124 0.210333 -0.033052 0.639739 1.015677 1.255511 0.486796 0.657629 0.749484 0.360686 1.380916 1.165967 0.436569 0.245010 0.681049 1.289027 0.486773 1.488027 0.953072 0.654244 0.787813 0.422242 -1.680072 1.774325 0.156381 0.383386 0.285516 1.812920 1.151126 1.368336 0.388051 1.563209 1.763145 0.152220 0.632704 0.602570 0.598515 0.977077 1.899879 1.241320 0.511002)
     )

;;; 61 even --------------------------------------------------------------------------------
(vector 61 10.120587847566 #r(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

	8.226818 #r(0.000000 0.016994 0.325473 0.251336 0.946736 0.699401 -0.675079 -0.007728 -0.010116 1.126523 0.376569 0.914633 1.446095 0.053980 -0.300394 1.374139 1.077986 0.775879 0.096551 1.537635 0.069761 1.322672 1.473052 1.640018 0.768399 -0.249971 0.982178 0.700147 0.066158 1.674667 1.169657 0.690809 0.918446 0.208659 0.318433 0.638763 0.148904 0.160017 0.167605 -0.164629 0.504035 0.380548 1.286796 0.861236 0.876986 0.992693 1.202515 -0.178183 0.116192 0.499345 -0.210431 0.157968 0.664206 0.256148 1.005577 1.828343 0.582272 0.170110 0.806483 0.100628 0.394696)
     )

;;; 62 even --------------------------------------------------------------------------------
(vector 62 10.318392753601 #r(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.386831 #r(0.000000 0.859901 -0.037314 0.499084 0.172754 0.200053 0.413556 -0.103812 -0.043175 1.401630 1.547880 1.059459 1.128023 -0.412748 0.373286 1.692211 1.505594 0.830265 0.065218 1.195447 0.352197 0.869648 0.832233 1.076333 0.047227 0.926568 0.992906 -0.398829 1.251628 1.417524 0.607369 1.301838 0.591801 1.818966 1.919148 0.665172 1.124200 0.647113 0.006532 0.116994 1.158292 1.339589 0.729938 0.686697 1.201579 0.392196 0.535548 0.591995 0.796606 1.266153 1.468758 1.497693 0.335929 -0.407172 0.650104 0.824841 1.052228 1.568552 0.986491 0.732480 -0.016292 1.711613)
     )

;;; 63 even --------------------------------------------------------------------------------
(vector 63 10.45694065094 #r(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.410525 #r(0.000000 0.001399 0.806426 1.791406 0.178737 1.693772 1.453002 1.766108 1.038935 0.058437 0.646194 -0.015337 1.414249 1.474690 0.017771 1.733567 0.171070 0.923951 0.026909 0.933154 1.151798 0.698968 0.660366 0.087838 1.616344 0.176657 1.080078 0.379155 0.230399 0.700949 0.606872 0.328480 1.529853 1.497342 1.625641 0.221781 1.430841 1.072942 0.756921 1.190553 1.477444 -0.121500 0.950131 1.283964 1.136775 0.314563 1.594944 1.525301 1.752381 1.839723 0.649292 1.587383 1.463916 0.739346 0.677117 0.941654 1.094738 0.055775 1.135356 0.781532 0.625283 1.248630 1.446249)
     )

;;; 64 even --------------------------------------------------------------------------------
(vector 64 10.487 #r(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.488483 #r(0.000000 -0.118114 0.313179 0.116307 0.537176 1.658687 0.216192 -0.344847 1.506370 0.155763 0.208418 1.514849 0.157857 1.664955 0.963481 0.006954 0.149631 1.283307 0.956149 1.518137 1.255443 0.282151 1.825115 0.946089 0.970642 1.107082 0.894001 1.294563 1.287628 0.299372 0.985558 0.184067 1.892317 1.378772 1.391157 -0.222304 1.376273 1.516215 1.126447 1.392881 0.335259 0.776482 1.846059 1.461533 0.174470 1.514120 0.175563 0.824826 0.537543 0.115873 1.536858 1.275915 0.954089 0.159705 1.030084 1.416601 -0.201669 -0.136401 -0.169765 0.989459 1.686060 0.192759 0.496019 0.523157)
     )

;;; 65 even --------------------------------------------------------------------------------
(vector 65 10.593795776367 #r(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

	8.567238 #r(0.000000 0.016475 0.108594 0.115078 1.941329 0.266453 1.120248 1.339498 0.699994 0.620437 1.172542 1.326431 -0.361520 1.836695 1.591514 0.344904 -0.145822 1.946144 1.338521 0.013894 0.850127 0.898286 1.609872 0.539311 0.526861 0.957259 1.571247 -1.643771 1.326503 0.617413 1.298256 1.248448 0.255352 -0.154088 1.756739 1.934044 1.770040 1.122574 1.017162 0.470885 -0.004317 -0.415719 1.115681 0.155133 0.493910 0.491332 1.234316 0.650337 1.247665 -0.051232 0.217462 1.088110 0.407320 1.207871 0.679746 1.483837 0.999515 0.954188 0.578133 1.042860 0.625974 0.692508 1.706207 0.810556 0.867800)
     )

;;; 66 even --------------------------------------------------------------------------------
(vector 66 10.77367179842 #r(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

	8.632415 #r(0.000000 0.349370 1.556983 0.421234 1.616137 0.526541 1.792681 0.630666 1.972820 1.303888 0.668047 0.185874 1.204700 0.605735 1.801435 1.101578 0.499473 -0.033128 1.607932 1.076516 0.444236 0.108864 1.822323 1.184780 0.621714 0.311062 0.092207 1.865663 1.797545 1.591442 1.274722 1.177650 1.020802 0.614400 1.193233 0.964769 1.565329 1.283764 1.369776 1.524204 1.622137 1.617341 1.880743 0.063066 0.749797 0.946049 1.286786 1.349904 1.771520 0.203067 0.478454 1.238589 1.828318 0.267660 0.894470 1.776144 1.875339 0.462001 1.527170 0.297195 1.298088 1.841092 0.920392 1.387764 0.362983 1.255950)
     )

;;; 67 even --------------------------------------------------------------------------------
(vector
 67 10.668939590454 #r(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

	8.680518 #r(0.000000 -0.043644 1.156472 1.929602 0.353761 1.793459 1.704972 1.699186 0.872870 0.617346 -0.249467 0.791588 0.943695 0.700487 1.210665 0.268020 0.351731 0.986938 0.336661 1.907109 0.142220 0.981697 1.535635 -0.431045 0.586416 -0.024607 1.390926 1.451196 1.280482 0.107552 0.443197 0.190946 1.788471 1.067438 1.094568 0.777481 0.924726 1.216918 0.287796 0.194302 1.535749 0.282813 1.326500 1.604906 1.499596 0.251491 0.462521 0.952185 0.345470 1.023546 -0.007975 1.650236 0.724994 0.590428 0.013422 0.854280 0.122767 0.900957 0.082717 0.523513 0.805279 0.154091 0.109168 0.522941 0.212305 0.605855 0.627516)
     )

;;; 68 even --------------------------------------------------------------------------------
(vector 68 10.834321813096 #r(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

	8.737685 #r(0.000000 0.011271 0.668436 1.109866 -0.047117 0.635498 1.135888 1.688824 0.641485 1.217954 1.792573 0.564775 1.618901 0.379183 1.590320 0.092885 0.939189 -0.039829 0.894144 0.018539 0.697204 1.575345 0.741258 0.165076 1.219732 0.243990 1.380334 0.653577 0.058955 1.582179 1.217188 0.506682 -0.145644 1.503542 0.465163 -0.203926 1.674851 1.343034 0.935709 0.449262 0.406299 1.921952 -0.005204 1.148292 0.752402 0.667155 0.809216 0.533372 0.786502 0.507725 0.195612 0.268423 0.127763 0.071980 0.591303 0.375550 0.934990 0.815381 1.190826 1.015123 1.567564 1.945341 0.409416 0.747963 1.020919 1.819317 1.811732 0.264138)
     )

;;; 69 even --------------------------------------------------------------------------------
(vector 69 11.164121627808 #r(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.861298 #r(0.000000 -0.014315 0.107745 1.734221 1.188739 0.864616 0.853522 0.701665 0.627466 0.265741 0.086130 0.314910 -0.019937 1.617450 0.883596 0.910173 1.068518 0.802541 1.046841 1.319853 0.948867 0.766596 1.620488 0.096714 1.965624 1.582040 0.085060 0.106281 -0.124978 0.458998 0.531756 1.514877 -0.136493 1.587236 1.553587 -0.064004 0.133766 1.755990 1.052257 1.445105 1.527338 0.192346 1.271689 0.560930 0.225417 1.661856 1.064999 0.603651 1.461102 0.188146 1.372664 0.531903 1.582055 1.360195 0.242798 0.449158 1.259157 0.003876 1.338065 0.028298 0.962940 -0.034639 0.655190 1.502712 -0.152010 0.612951 0.527743 0.973632 1.671816)
     )

;;; 70 even --------------------------------------------------------------------------------
(vector 70 11.188811302185 #r(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

	8.738310 #r(0.000000 0.060494 0.986675 0.927670 0.927042 1.912795 1.130240 0.504397 1.816891 1.890493 1.358618 0.521191 0.253430 1.962720 0.007805 1.096365 0.386730 0.273184 1.116588 0.973364 0.744812 0.418465 0.707007 0.033855 1.765192 0.661757 0.557886 0.198772 0.854461 0.002899 0.603283 1.248185 0.800028 0.506375 0.669527 0.754045 0.637170 0.745041 0.219675 1.748841 0.204886 1.266431 1.560734 0.352969 0.701996 1.457120 1.739658 1.911657 1.876664 1.591504 0.388398 1.652906 0.410293 1.137585 1.138735 0.861128 1.263560 0.335801 0.480511 1.625411 0.897941 1.902792 1.166909 0.252915 0.353569 0.922988 1.275359 1.530840 1.567036 0.065589)

     )

;;; 71 even --------------------------------------------------------------------------------
(vector 71 11.146488189697 #r(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

	8.871487 #r(0.000000 0.501961 1.541872 0.886339 0.156320 1.396889 0.135011 0.196565 1.055358 1.605569 0.968224 0.079515 1.545947 0.630884 1.566775 0.285239 1.241623 1.021147 0.597505 0.194062 1.492344 0.530666 1.629940 0.923400 0.544821 0.122654 0.645735 1.521728 1.527826 0.171212 0.337093 1.111719 0.869475 1.840487 1.876244 1.390257 1.033097 1.006339 0.323258 0.705399 1.295002 0.904992 0.460862 1.246434 1.927017 0.305342 1.897455 1.059620 1.458290 1.674665 1.467549 1.520089 1.086469 1.318586 0.595384 1.676485 1.855914 1.355156 1.637133 1.725092 1.426375 1.504977 1.730717 0.310874 0.666925 0.188355 0.720920 1.037233 1.314825 1.160128 0.935055)
     )

;;; 72 even --------------------------------------------------------------------------------
(vector 72 11.323646371629 #r(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.966098 #r(0.000000 -0.126524 0.241365 -0.143891 1.246410 0.237827 0.068268 0.981965 1.279896 0.207575 1.600135 0.425223 1.012069 -0.249534 0.586208 0.677616 0.988256 1.224132 0.847502 0.890511 0.594663 0.821814 0.472617 0.509750 1.055611 0.527256 1.206362 1.187311 1.020278 1.260328 0.644599 -0.411471 0.451173 0.741632 0.395690 0.063099 1.651856 -0.169570 0.718417 1.113283 -0.150773 1.169732 0.126856 0.685212 0.541541 1.675462 1.278970 0.617875 0.012957 0.713555 1.056877 1.533856 1.860752 -0.160414 1.609925 -0.009147 0.332551 1.066032 0.906560 0.505523 0.337817 1.535465 0.314417 0.880126 0.996966 0.843436 0.382436 1.584721 0.192373 1.434808 0.561954 0.196295)
     )

;;; 73 even --------------------------------------------------------------------------------
(vector 73 11.416394233704 #r(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

	8.998875 #r(0.000000 -0.027738 0.723012 0.987885 1.688793 0.224358 1.257498 1.205244 0.059967 1.110866 0.244239 0.893825 1.678546 0.367238 0.999201 1.584243 0.599700 1.550023 0.571455 1.648100 0.426585 1.592387 0.308230 1.310308 0.762552 0.283753 0.857526 0.065837 1.585997 0.934412 -0.077402 1.498041 0.744404 0.105899 -0.072967 0.997282 0.574754 -0.130584 1.109613 1.163331 0.759965 -0.104852 -0.314435 1.534103 1.175049 0.658149 0.377521 0.124048 0.381799 -0.363750 0.073219 -0.169731 1.548408 1.642328 1.596724 1.300600 1.557656 1.160915 -0.369397 1.745964 -0.047288 -0.349818 -0.267792 0.401403 0.428159 0.831796 1.384022 1.813745 0.039215 0.253980 0.836216 0.800931 1.496823)
     )

;;; 74 even --------------------------------------------------------------------------------
(vector 74 11.47264289856 #r(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

	9.089677 #r(0.000000 0.144071 0.430579 0.603179 1.823332 1.143801 1.591094 1.455623 0.712070 0.082290 1.084154 0.110592 0.804471 0.355531 0.279726 0.662009 1.471918 0.975419 -0.110990 -0.050928 1.029272 1.676464 1.339672 0.210956 0.309032 0.856505 0.268633 1.767141 1.866363 0.080348 0.815161 1.562603 1.496888 1.364954 1.148285 1.915037 0.068161 0.155798 0.832883 0.552250 0.747466 1.278662 0.320719 0.554068 0.448373 0.560964 0.575201 0.582799 0.448437 1.372678 0.663771 1.197915 1.194337 1.764215 0.560010 1.428733 0.089660 1.008988 0.569768 0.320532 1.743415 1.535180 0.723297 0.874095 1.399163 0.469816 0.475982 1.976109 1.247967 0.249280 1.069756 1.236481 0.761110 0.040581)
     )

;;; 75 even --------------------------------------------------------------------------------
(vector 75 11.479255355845 #r(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

	9.122336 #r(0.000000 0.048869 1.339254 0.089666 1.486190 0.870004 0.011978 1.048119 0.676596 0.057206 0.754204 0.107870 0.750530 1.770162 0.039012 1.322332 0.128429 1.247050 1.441477 0.361257 0.456347 1.565436 -0.097913 -0.154028 1.037161 1.046281 -0.149299 1.044015 0.945241 0.030424 1.640451 0.465010 -0.575716 1.739314 1.635330 0.021179 -0.093167 1.405567 0.012379 1.165852 0.184990 -0.085142 1.685196 1.535448 0.976578 0.821468 1.305457 1.520774 -0.462148 0.266842 1.065515 1.372970 0.572598 -0.000709 0.007374 0.181987 0.683855 -0.023831 0.237367 0.994268 1.020527 0.942078 0.930935 0.000689 0.246320 -0.099925 0.725524 0.244873 0.826205 1.407851 1.166455 -0.165415 -0.393537 1.421358 1.270036)
     )

;;; 76 even --------------------------------------------------------------------------------
(vector 76 11.477294510597 #r(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

	9.267049 #r(0.000000 -0.020314 1.755600 1.225815 1.392876 0.129128 0.904701 1.317680 0.135315 0.135157 1.306639 0.906712 1.246319 1.540595 0.325853 0.492145 1.519920 1.711478 0.987890 1.851800 1.025239 1.325366 1.386429 1.327266 1.218403 1.379936 1.651659 0.762609 0.602221 0.305384 1.005148 1.165080 0.607028 0.109898 1.108721 1.348326 0.327807 0.802574 1.851895 0.707744 0.612551 0.813959 1.109818 1.410929 -0.038131 1.260997 0.182282 1.357227 1.580079 1.583723 1.747921 1.744371 0.043874 1.066888 0.166830 1.083294 0.441024 -0.188048 1.363450 0.011580 1.301595 0.836365 0.437311 0.206162 1.388569 1.787918 -0.007275 0.062944 0.169678 1.553243 0.843416 1.054961 0.291307 0.730433 0.353612 1.433902)
     )

;;; 77 even --------------------------------------------------------------------------------
(vector 77 11.594018936157 #r(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

	9.258697 #r(0.000000 -0.013339 0.361730 -0.178619 1.458285 1.239693 0.187315 0.723105 1.832453 0.697245 1.501131 0.944520 -0.233993 1.308923 1.563553 0.373130 0.490540 1.502925 0.664091 1.076569 0.784295 1.783245 0.515174 1.454068 1.828406 1.258364 0.555115 0.908733 0.866810 0.793191 1.466746 -0.285489 0.625778 1.405840 -0.033775 0.825706 0.658930 0.687424 0.346833 0.334451 0.295602 0.709401 -0.245908 0.509751 0.038841 1.147976 0.897946 1.319996 -0.002107 0.292751 -0.002528 1.663431 0.945438 0.327586 -0.130505 0.048622 0.206586 1.024810 0.812170 1.202395 1.044181 0.633806 1.054272 0.210049 0.748304 0.737183 0.166918 1.060611 0.839094 -0.333107 1.559498 0.841184 0.651547 1.383431 1.543420 1.536206 0.957253)
     )

;;; 78 even --------------------------------------------------------------------------------
(vector 78 11.940728787203 #r(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.328276 #r(0.000000 1.406823 1.141364 0.610647 0.126562 0.291088 -0.002810 1.723967 1.290155 1.387808 0.102958 1.845357 0.849277 1.063481 1.501422 0.895746 0.848443 0.832188 0.431168 0.709505 1.679105 0.730831 0.661087 1.841168 0.988482 1.264653 1.865286 1.169037 1.400680 0.724126 1.065027 1.447510 1.315432 1.350791 0.428040 0.921038 1.506688 0.890246 0.013294 1.195026 1.795617 0.458626 1.125258 0.081154 1.116281 0.472818 1.725786 0.409138 0.675258 0.030590 1.838764 0.971536 0.779052 1.812631 0.339909 0.118196 1.331384 1.256650 1.407089 -0.001860 1.469527 1.547682 1.041199 0.265560 1.975848 0.431849 0.301455 0.848353 1.049415 0.858904 1.319566 0.870781 1.483458 1.085719 -0.027060 0.614386 0.627471 1.390841)
     )

;;; 79 even --------------------------------------------------------------------------------
(vector 79 11.878196632448 #r(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

	9.356905 #r(0.000000 0.571128 0.283126 0.710064 0.044861 0.517447 0.565754 1.816476 1.776655 1.961158 0.969237 0.741311 1.685785 1.693335 1.608101 1.714904 0.999281 1.149752 0.496446 -0.005825 0.400462 1.122030 0.649836 0.115106 1.227654 1.245207 1.356694 0.853401 0.066193 1.513339 0.232138 -0.003310 1.407988 1.840789 0.203665 0.695895 0.383959 1.340762 0.259589 0.675435 0.428135 0.786347 0.123158 1.097424 0.337222 0.630879 1.973156 0.929943 0.645917 1.669638 1.042085 1.855979 0.866264 1.042746 0.512422 0.066644 1.718064 0.437594 0.628166 0.854660 1.007811 1.926083 0.161247 1.536075 1.840756 0.056881 0.376915 1.151208 0.451206 0.898922 1.442317 0.402410 0.949195 0.147955 0.214050 0.743975 1.660546 1.690974 1.456466)
     )

;;; 80 even --------------------------------------------------------------------------------
(vector 80 11.989325523376 #r(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

	9.451381 #r(0.000000 -0.008159 0.906753 1.305892 1.835739 0.455299 1.241503 1.764471 0.268792 1.093130 1.721221 0.403868 1.185646 -0.052269 1.047326 1.833500 0.559981 1.435538 0.044639 1.118792 0.211239 1.183285 -0.017880 1.113985 0.075712 1.455698 0.586249 1.582198 0.728760 1.817597 1.133287 0.380801 1.662934 1.263429 0.591618 1.594214 0.731911 0.436203 1.622560 1.339925 0.697686 0.383414 1.692741 1.277746 0.787440 0.567628 0.173328 1.808052 1.713672 1.154020 1.478170 0.695323 0.754309 0.444882 -0.137982 1.914149 -0.163436 1.825364 1.675061 -0.028374 1.567024 1.487026 1.462509 1.367054 1.604880 1.820934 0.179885 0.241810 0.434307 0.468407 0.694148 0.863503 1.227318 0.060705 0.392042 0.847475 1.220917 1.459482 1.773242 0.341153)
     )

;;; 81 even --------------------------------------------------------------------------------
(vector 81 11.979215621948 #r(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

	9.484199 #r(0.000000 -0.014989 0.711182 0.702116 0.715678 1.118560 1.541619 1.626360 1.716671 1.701724 1.388047 0.720950 0.043527 0.750136 0.580168 0.242261 0.554505 1.231540 0.585563 1.731545 1.161768 0.189281 0.555798 0.452602 1.215752 0.161495 1.660923 1.830372 -0.010829 0.456142 -0.050721 1.414501 0.305392 1.352545 1.387015 0.684532 -0.327842 0.848714 0.508517 0.769743 0.863349 0.582844 1.732685 -0.045944 0.572477 -0.189530 0.661834 1.428026 0.041444 0.576772 1.162733 0.612356 0.238120 0.518089 0.595961 1.809933 0.228170 0.569100 1.027432 0.767900 0.363008 0.578850 0.716122 1.427686 1.524730 1.163139 0.596916 0.312527 -0.179958 1.099907 1.521616 0.693536 0.160625 1.330705 -0.245662 0.331197 1.886658 1.895780 1.661128 0.854753 -0.196395)
     )

;;; 82 even --------------------------------------------------------------------------------
(vector 82 11.74796962738 #r(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

	9.497103 #r(0.000000 -0.029153 0.684444 1.021403 1.658027 0.249250 0.776708 1.428620 0.085535 0.486627 1.258780 0.071150 0.697354 1.572082 0.508727 1.262137 -0.011817 0.780894 -0.218011 0.762691 -0.142015 0.700649 0.106572 1.278342 0.114037 1.097124 0.117125 1.202443 0.366776 1.726169 0.864227 0.247143 1.675002 0.548738 1.828587 1.277326 0.419039 -0.107494 1.445764 0.840468 0.334528 1.912916 1.518113 0.790626 0.013994 1.915183 1.263923 1.327347 0.781659 0.615731 0.262410 0.035907 1.614732 1.446654 0.850073 0.970717 0.734963 0.622068 0.608074 0.894648 0.488587 0.454835 0.326490 0.410839 0.269255 0.474617 0.469240 0.881426 1.112047 1.250719 1.126584 1.346595 1.487368 -0.251240 0.320757 0.542484 1.030672 1.483109 1.856301 0.081488 0.438971 0.778619)
     )

;;; 83 even --------------------------------------------------------------------------------
(vector 83 11.931811297539 #r(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

	9.527422 #r(0.000000 0.039993 0.816893 1.396565 0.052019 0.406851 1.188022 1.530327 0.285917 0.977547 1.744335 0.664199 1.680876 0.156053 1.128267 0.262396 1.109826 0.291301 1.490141 0.180525 1.053020 1.941274 1.253760 0.382165 0.961999 0.532400 1.847797 0.647689 1.830150 1.183965 0.539992 1.837872 1.385863 0.522294 1.844972 1.128571 0.700004 -0.069652 1.070002 1.210347 0.538981 -0.009837 1.537046 1.193589 0.928354 0.544043 1.782489 1.375018 1.429592 1.234747 0.808197 0.986572 0.425099 0.414825 1.922804 0.001710 1.593804 1.877139 1.790889 1.733450 1.866442 1.306101 1.778217 1.887521 0.051591 1.690318 1.780713 0.155363 0.560963 0.744564 1.000076 1.060961 1.426049 1.399817 1.671797 0.161357 0.644151 1.472002 1.472014 1.829962 0.015301 0.965948 1.229794)
     )

;;; 84 even --------------------------------------------------------------------------------
(vector 84 12.426499838032 #r(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

	9.614786 #r(0.000000 0.375068 1.187445 1.298436 0.709464 0.020952 1.148798 1.055850 0.320459 1.298871 1.652395 1.860647 1.831143 0.283862 1.652937 1.354808 0.416076 0.228038 1.233244 1.035794 1.620810 1.664738 1.238595 1.418099 0.901000 1.501621 0.079640 0.502746 1.495260 0.205490 0.418812 0.854084 1.160572 1.818322 1.862802 -0.014400 0.107435 1.307461 0.912240 1.586689 0.425403 0.451717 -0.018837 0.188758 1.765670 1.603983 1.861601 1.733712 1.620602 1.226086 0.197611 0.449818 1.288074 1.179947 1.253616 0.051096 1.323541 -0.017431 1.522243 0.870665 0.517902 0.017634 1.973363 1.452286 0.728651 1.585681 0.006719 0.375262 0.515082 1.364281 0.622572 1.146649 0.785551 1.882176 0.813901 1.772516 1.074978 0.933728 0.872134 0.706582 1.147578 1.604862 0.731095 1.575095)
     )

;;; 85 even --------------------------------------------------------------------------------
(vector 85 12.270205061432 #r(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     9.676352 #r(0.000000 -0.021506 0.142510 -0.201280 0.182702 1.169448 0.515556 0.222070 1.459504 1.605994 0.066066 0.601645 0.479812 1.884618 1.289236 1.392693 1.037601 1.509258 1.097130 0.618955 1.146396 0.204058 0.576610 0.429829 1.784325 0.190947 -0.177471 1.558612 1.955949 0.141411 0.860726 1.284854 1.277952 -0.296527 0.440455 -0.206162 -0.363530 1.252145 1.013387 1.637160 1.499868 0.217901 -0.179705 0.762898 1.687641 0.983895 0.350810 0.163017 1.102299 0.509811 0.930463 0.652819 1.320027 0.777246 0.714063 0.619559 1.478697 1.064984 0.759208 0.734058 1.089046 -0.001825 0.109656 1.736213 0.746787 0.859777 1.252309 1.312302 0.643160 0.991358 1.500532 0.072854 1.488976 -0.065425 0.980776 0.288766 0.737541 -0.227786 0.745819 0.780965 1.553917 1.095084 1.183710 1.599670 0.559494)
     )

;;; 86 even --------------------------------------------------------------------------------
(vector 86 12.791990425787 #r(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     9.757994 #r(0.000000 0.016276 0.413658 0.005763 1.416798 0.452490 1.133949 0.717805 -0.139351 -0.416845 0.635126 1.397576 1.784378 0.624787 1.329377 0.775034 1.638049 1.566267 0.397541 0.717995 0.458680 0.241210 1.137210 0.824217 1.676096 0.033354 0.678380 0.974547 -0.074751 1.701263 1.808581 1.130731 0.088685 1.471223 0.433149 0.369913 0.827798 0.624409 1.348287 1.536121 0.451096 0.914922 1.222159 0.944875 0.666511 1.307186 0.261401 0.304523 0.268304 1.558827 0.035349 0.915580 1.674357 0.963952 0.990617 0.774771 1.562772 1.323613 1.282808 0.172130 0.873085 0.634976 0.830754 0.633548 1.260812 0.821220 1.409736 0.921962 1.181706 0.466917 1.496380 1.268080 0.686034 0.967101 0.676822 1.324706 -0.286255 0.721334 0.297385 -0.003595 0.022225 -0.182008 1.671247 0.611513 0.542122 0.060310)
     )

;;; 87 even --------------------------------------------------------------------------------
(vector 87 12.625063286678 #r(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.833802 #r(0.000000 0.367165 0.536913 0.326688 1.754631 1.386469 0.701887 0.250913 1.770109 1.479583 1.893022 1.432354 1.785784 1.534964 1.065673 0.546258 0.691804 0.707053 1.195808 1.762942 0.317266 1.578293 1.433592 0.550208 0.671749 1.256446 0.518972 -0.102858 1.408512 0.374956 1.658793 1.157613 1.642043 -0.113309 0.260556 0.456626 0.282565 0.411123 0.959912 0.806932 1.532714 1.669316 -0.074293 1.300123 0.015951 1.235972 1.481090 0.353661 0.866116 0.040949 0.766868 1.838392 0.527395 0.761509 0.579783 0.151717 0.504358 1.298332 1.436503 1.047336 0.497873 0.242477 0.820064 0.697963 1.791351 0.825336 1.710371 0.315366 -0.001375 1.285082 1.639193 0.147520 0.106212 1.060911 1.454817 1.978200 0.161929 0.176396 0.295938 0.177484 1.619442 0.666971 0.038844 0.469799 1.852332 0.897967 1.727138)
     )

;;; 88 even --------------------------------------------------------------------------------
(vector 88 12.661032846106 #r(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

	9.718345 #r(0.000000 0.090301 0.580420 1.137948 1.649229 0.242742 0.835819 1.656571 -0.017510 0.559517 1.388287 0.058809 0.753393 1.494701 0.370637 1.260856 -0.119563 1.041192 -0.061687 1.016092 1.945001 0.703035 1.390544 0.418053 1.307211 0.509025 1.790796 0.980057 -0.158235 0.857486 0.120874 1.412962 0.698078 0.037067 0.957739 0.111182 1.653690 1.215943 0.416735 1.835076 1.390628 0.306891 1.454844 1.343506 0.944627 0.195567 1.555857 1.416104 1.116565 0.394891 -0.273959 1.365744 1.143771 0.983147 0.734424 0.789720 0.117391 0.276530 -0.227121 1.795123 1.224424 1.102557 0.938135 0.875496 1.362204 0.858546 1.054224 0.762302 0.972789 0.919506 0.923137 1.096370 1.576367 1.456481 1.754554 -0.038629 -0.053347 -0.002284 0.438792 0.831710 1.315485 1.762939 -0.120155 0.441679 0.734442 1.312359 1.725229 -0.263433)
     )

;;; 89 even --------------------------------------------------------------------------------
(vector 89 12.335865540187 #r(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

	9.997333 #r(0.000000 0.000374 0.870347 0.430138 1.597497 0.854707 1.645978 0.195809 0.327518 0.386675 1.273173 0.883834 1.572463 1.355519 1.460953 1.742560 1.466652 0.059211 0.803493 0.350986 0.628193 0.108588 1.078791 0.357570 0.049661 0.428788 0.193103 0.539441 1.534442 -0.270762 1.359943 0.266823 0.261536 1.389711 0.984355 0.700121 0.450847 0.511706 1.320150 -0.010111 0.346818 0.823284 0.749541 -0.083397 0.521509 1.572625 0.693799 0.570576 1.592198 0.790089 1.438056 1.137497 0.099306 0.403293 -0.181278 1.213652 -0.275230 0.429537 1.196488 1.257187 0.949493 0.887298 -0.021183 1.237418 1.728439 1.700297 1.208776 1.169553 1.080514 1.089517 0.997178 0.189218 0.010336 0.924195 0.754787 -0.276009 0.524587 0.129921 0.438091 1.173722 0.555071 1.051504 1.084882 0.517543 0.493847 1.648211 1.537221 0.577245 1.229152)
     )

;;; 90 even --------------------------------------------------------------------------------
(vector 90 12.716424196959 #r(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

	10.005385 #r(0.000000 0.266301 0.657933 1.809725 0.259625 1.499388 1.951777 0.417279 0.720631 1.463340 1.313241 1.674280 1.821839 1.222157 0.677020 0.056065 0.913340 1.473757 0.500844 1.618656 1.947044 1.968045 0.165893 0.742583 0.481909 1.957975 1.912063 1.128014 0.854394 1.610032 0.983783 0.446705 0.950214 1.088029 0.680933 1.289258 1.589189 1.192870 1.530162 1.263854 1.970834 0.161039 1.086404 1.031920 1.038629 0.740829 1.589971 0.517225 0.215830 0.397130 1.740853 1.801311 1.698694 0.359017 0.435066 0.722951 0.895327 0.213686 0.474411 1.936524 1.840733 1.231982 0.212190 1.778066 -0.017649 0.107809 0.287686 1.163341 0.406123 0.018771 0.520578 1.723923 1.431482 0.556441 1.126649 0.438444 0.818042 0.023577 0.022169 1.216022 0.981361 0.222433 0.002575 0.758509 1.972547 0.353471 0.372968 1.542215 0.712557 -0.005582)
     )

;;; 91 even --------------------------------------------------------------------------------
(vector 91 12.853587071592 #r(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

	10.042802 #r(0.000000 -0.035866 0.897365 1.053653 0.176403 0.219184 1.440211 1.052349 0.085592 1.162863 0.084431 0.441417 1.631218 1.653054 1.371988 0.264232 0.162497 1.263609 1.486015 0.000279 0.796126 0.856108 1.143739 0.036741 0.359201 0.386354 1.098418 1.740082 0.403417 -0.381985 -0.045741 1.421757 -0.244618 0.284679 1.283482 0.239612 0.207928 1.023191 0.055003 0.481157 0.262505 0.919249 1.223649 0.889223 1.148998 1.351103 1.151749 1.060591 0.840918 0.819670 0.078653 1.166949 0.324971 1.862030 0.777159 0.475422 1.793704 0.731398 0.965906 -0.104231 1.194055 0.079999 0.745567 0.302722 0.702138 1.835624 1.663395 0.439912 0.518314 0.455355 0.752825 0.589824 -0.228956 -0.057907 1.862917 1.732339 0.708967 -0.227779 0.771240 0.335640 0.732499 0.256435 1.503911 1.314370 1.240658 0.306896 0.231765 0.561980 0.840408 0.710675 0.474899)
     )

;;; 92 even --------------------------------------------------------------------------------
(vector 92 12.754180011349 #r(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

	10.093799 #r(0.000000 0.097475 0.474539 1.483425 1.695433 0.696334 1.384454 1.660791 1.281276 0.651391 0.913798 0.787990 1.790434 0.898224 1.017588 0.489338 1.141353 1.186171 0.350837 0.177621 1.677552 1.789100 0.110343 0.454347 1.559659 -0.042233 0.608466 0.500241 0.603579 1.572339 0.363338 1.814846 0.003161 1.623864 -0.034828 -0.082229 -0.014363 1.697201 0.280864 0.306413 0.160645 0.492279 1.649232 1.327006 0.593871 1.122736 0.171541 0.947619 -0.123703 1.067261 0.409844 1.696986 0.608770 0.942772 1.749773 0.231207 0.233623 -0.088168 1.647955 -0.323810 0.983812 1.702369 0.347530 0.210075 0.231329 1.042751 0.983241 1.466379 1.428117 0.495078 0.039516 0.654874 1.015240 1.000618 0.552384 1.000345 1.081710 1.764837 -0.091885 0.154009 1.296154 0.404476 -0.289622 1.339445 0.215325 1.338919 0.954330 0.913687 0.101078 1.737442 0.041006 0.910374)
     )

;;; 93 even --------------------------------------------------------------------------------
(vector 93 12.876626968384 #r(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.065620 #r(0.000000 -0.108011 0.028413 0.428569 -0.264921 -0.072069 0.267827 -0.232905 1.422065 1.049340 1.912600 0.928914 0.359452 0.637331 0.994484 1.088650 0.661107 0.959399 0.501733 1.592595 0.649518 0.112558 0.639845 0.623737 -0.001172 1.885750 1.716702 -0.081979 0.409219 1.833651 0.687305 0.099113 0.976296 0.699765 1.668301 0.522485 1.899898 -0.255451 0.181872 1.354811 1.349077 1.063124 1.067091 0.386071 0.890132 1.558023 0.302347 0.328201 1.215301 0.773485 0.343724 0.711824 1.139582 0.744463 1.144250 1.100613 0.956953 1.649826 1.947556 1.246366 0.939192 0.477006 0.202473 0.703433 1.186050 1.217690 -0.305306 1.548367 1.162238 0.701264 0.901619 -0.418089 0.199961 1.541176 0.296598 0.140984 0.701027 1.041254 0.225036 1.683545 0.413255 0.857529 0.155624 1.010740 1.433842 0.558273 0.224703 0.699603 -0.095757 1.811470 0.813981 1.031240 0.132432)
     )

;;; 94 even --------------------------------------------------------------------------------
(vector 94 12.991560374803 #r(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.122815 #r(0.000000 0.133468 0.434550 1.116037 1.367061 1.298685 1.320675 0.772917 0.657709 0.375492 0.359918 0.175405 0.001908 1.653938 1.747543 1.839665 -0.062043 -0.026764 0.038622 0.084576 0.056367 0.216710 0.616631 0.600688 0.712488 1.072113 1.109064 1.489264 1.625638 1.767346 0.350358 0.788682 1.068488 1.139549 1.561780 0.235784 0.655587 0.915751 1.197108 0.029428 0.731728 1.098397 1.683227 -0.011322 1.217188 1.389756 1.893589 0.699420 1.194655 0.326260 0.920410 1.696640 0.677795 1.085105 1.784456 0.793169 1.603872 0.721686 1.454458 0.911227 1.124477 0.602857 1.320529 0.681212 1.671271 0.216947 1.361764 0.646816 1.486120 1.171016 0.310212 1.419455 0.622405 1.553189 0.964805 0.061139 1.154419 0.759830 0.026678 1.736233 1.082201 0.055939 1.530249 0.853387 0.727622 0.057320 1.853782 1.373056 1.001203 0.910058 0.345570 1.764813 1.459492 0.795631)
     )

;;; 95 even --------------------------------------------------------------------------------
(vector 95 12.939489078295 #r(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

	10.269066 #r(0.000000 0.196337 0.744121 1.631500 1.434420 1.112985 0.280820 0.466628 1.611890 1.200048 1.128273 0.300201 1.107837 1.615275 1.861044 0.768326 1.404808 0.847561 0.538134 0.927410 0.484738 1.590211 1.022918 1.308421 1.540744 0.048884 1.906201 0.748264 0.523607 1.912669 0.059747 1.201507 0.965409 0.088695 0.363594 0.778227 1.091252 0.265360 1.420067 0.510511 0.194882 1.977148 0.136470 0.500674 0.349411 0.913896 0.824107 1.033330 0.477216 1.577346 1.234803 1.697387 1.721086 0.725903 1.087039 1.444618 0.157357 0.054414 1.697920 0.198034 1.375172 1.573201 1.879725 1.512172 0.332268 0.349715 1.475813 1.517121 1.176387 1.495828 1.194712 0.970136 1.660156 1.605331 0.615232 0.722796 1.823598 0.676903 1.932703 1.595202 0.236615 1.905584 1.979370 1.321822 0.205301 1.189808 0.131048 0.886535 0.146849 0.803473 1.792940 -0.030202 1.802311 1.740023 1.462432)
     )

;;; 96 even --------------------------------------------------------------------------------
(vector 96 13.077001047978 #r(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

	10.241048 #r(0.000000 0.003757 1.404262 1.186542 1.129971 0.865096 0.631220 0.098231 1.181280 0.873758 0.108892 1.683807 -0.026458 0.125881 1.769512 1.339376 1.635163 0.876941 1.912161 0.936227 1.173994 0.478683 1.599283 1.211922 0.811714 0.443994 1.505961 1.292424 0.708648 1.804209 1.708608 1.666637 1.338958 1.076681 0.747663 1.831744 0.261273 0.683220 1.107456 1.456865 1.254091 1.068402 0.333231 0.745693 0.907431 0.898985 1.579520 0.453253 0.663746 1.227853 0.149659 0.721511 1.948786 0.149093 0.296568 0.790196 1.698592 0.803662 1.598789 1.168565 1.171874 0.082641 1.787827 0.077982 0.385521 1.278297 0.162220 0.619751 1.181312 0.878992 1.244043 0.861252 0.440728 1.044249 0.162951 1.873041 0.921134 1.415997 1.306524 1.965129 1.092611 0.284989 1.258880 0.979541 1.705555 1.205180 1.637307 1.841309 1.672634 0.033086 1.395930 1.017436 1.092392 1.649384 0.223105 1.865219)
     )

;;; 97 even --------------------------------------------------------------------------------
(vector 97 12.969611395004 #r(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

	10.331609 #r(0.000000 0.059699 1.679418 0.450942 0.341208 0.044956 1.496127 1.161174 1.525174 0.047352 0.606254 0.809600 1.848618 0.039787 -0.223939 0.198520 0.035320 0.164795 1.065103 1.447823 1.468877 1.512497 1.098862 0.655896 0.461251 -0.141526 1.428961 -0.284969 0.570402 0.733971 1.142683 0.365769 0.545990 0.086257 0.813863 1.752030 1.028626 1.080478 0.683235 0.804908 -0.569669 0.552818 0.738379 1.748606 1.743971 0.318921 1.398131 0.903531 1.080144 0.015318 1.470925 1.314323 0.741551 1.256092 -0.466432 1.057036 -0.278181 0.948738 1.681138 1.409042 -0.356236 0.710263 1.151015 -0.045179 0.095392 0.692511 -0.044055 0.872538 0.891007 0.065893 0.992795 0.002450 1.463958 1.118971 0.560807 1.855502 1.102581 1.197238 1.102700 1.013050 -0.347897 0.212419 0.959268 0.927894 1.594478 1.035533 0.111169 1.405266 0.164463 -0.296519 0.289020 0.402469 0.694148 -0.081694 1.289317 1.079081 1.540546)
     )

;;; 98 even --------------------------------------------------------------------------------
(vector 98 13.468658765207 #r(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

	10.469148 #r(0.000000 0.041799 1.596065 0.940539 0.107860 1.301118 1.360284 1.456195 0.770794 0.797213 0.981214 0.615701 1.879665 1.255104 0.792980 0.009757 1.541751 1.750534 -0.164252 -0.228661 -0.000964 0.259847 0.719626 1.683189 0.070974 1.565970 0.626446 1.182840 1.211411 1.387666 0.843346 0.887732 0.199521 1.364727 0.445637 0.374521 1.472461 0.203776 1.458205 1.100974 1.381886 0.898075 1.764681 0.078586 1.428252 1.256209 0.859035 -0.172104 -0.025993 0.039107 0.931073 0.478871 -0.467850 -0.062950 1.711499 0.913120 1.786290 1.259116 0.654598 0.064686 1.755165 1.957362 -0.152445 1.535096 0.794197 1.419704 1.076435 1.392497 0.029274 1.975390 0.472375 0.606537 0.883155 1.276000 0.493031 0.898350 1.602090 0.227444 1.327599 1.208448 0.644216 0.422730 0.787896 1.404845 0.430824 1.020626 0.191889 0.753198 0.234016 0.430598 0.540049 1.795233 0.560850 1.196734 0.812705 -0.032356 0.652329 1.183402)
     )

;;; 99 even --------------------------------------------------------------------------------
(vector 99 13.341398779709 #r(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

	10.387770 #r(0.000000 0.723174 1.299510 0.938148 0.130782 1.537111 0.112390 1.601140 0.503320 0.848767 0.240495 1.955709 1.375024 0.729476 1.036126 1.572806 1.444920 1.621302 0.393808 0.065259 0.537896 1.360502 0.502316 1.033192 1.160053 1.956689 0.593389 0.146787 1.283607 0.862675 0.087404 0.982221 0.127681 1.954427 1.076364 1.276318 1.813925 0.771973 1.846400 0.032344 0.377646 1.403790 0.914062 -0.000037 0.633186 1.405136 1.122873 1.617439 0.482283 0.855693 1.408247 1.588613 0.805766 0.262956 0.418675 1.649935 0.343317 0.552803 0.568407 1.358534 0.902812 1.838429 0.026551 1.721556 0.320222 1.393185 1.332977 0.651907 0.039081 0.348939 1.498662 1.703551 1.415979 0.827556 1.145004 0.798108 0.858363 0.976482 0.496254 0.466661 0.161612 0.684799 0.836631 1.109531 1.218580 0.936551 1.053645 1.124681 1.239229 1.080843 1.469489 0.564251 0.976183 1.320843 0.473769 0.158597 1.642110 0.640983 0.421437)
     )

;;; 100 even --------------------------------------------------------------------------------
(vector 100 13.512077331543 #r(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.441892 #r(0.000000 -0.078419 0.614905 1.251438 -0.041619 1.814775 0.177017 1.030080 1.449954 1.597807 1.129312 0.664385 0.695003 -0.253219 0.261630 0.747479 1.802618 -0.450986 -0.124544 1.683979 1.639733 0.928235 0.098329 0.328915 1.800882 0.567004 1.536417 -0.108925 1.607348 1.496392 0.944502 1.250417 1.596577 1.279689 0.522052 1.329649 0.718369 0.631764 0.450072 1.155851 0.121306 0.284048 -0.204852 0.791247 0.417835 1.559590 -0.244455 1.753636 1.896972 0.344992 0.431235 0.072595 1.467994 0.863611 1.094702 0.044112 0.035102 0.103798 1.827379 0.119367 0.011923 0.021208 0.236547 1.180365 1.006347 0.302184 1.584982 0.089332 0.164608 0.799626 -0.353587 0.724007 0.633963 1.695870 0.472534 1.361563 1.063116 1.021659 1.696466 0.823914 1.095544 1.830809 -0.445330 1.497759 1.274799 0.528398 0.283435 1.488419 1.797120 0.309042 1.853448 0.912033 1.787026 1.149240 0.601502 1.544000 0.765984 1.262591 1.692106 1.411716)
      )

;;; 101 even --------------------------------------------------------------------------------
(vector 101 13.916260357992 #r(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

	10.574342 #r(0.000000 0.207139 0.478891 1.897591 0.928981 0.587388 0.446055 0.050644 1.615878 0.191657 1.835743 1.060359 1.176622 0.986408 1.096063 0.672219 0.439657 0.105093 1.210496 1.686955 1.824275 0.042386 0.589348 1.446712 0.092283 1.586359 0.510298 0.881482 1.261115 1.931837 1.262783 1.644402 1.438409 0.120500 1.741963 0.687773 0.477250 0.359346 0.398597 0.520856 1.685678 1.705405 0.817986 0.493104 0.888632 1.741684 1.470396 1.953488 0.643930 0.326254 0.790329 1.755178 1.009415 0.831191 0.253334 0.626669 1.263598 0.475375 1.082491 1.358399 1.198093 0.889493 0.458785 0.265218 1.393268 1.895550 1.749050 -0.014777 1.344490 1.594923 0.077960 1.627750 1.828810 0.948439 0.230435 1.450944 0.756584 1.550397 1.139233 0.642734 1.551088 1.588240 0.570833 1.438946 1.006201 1.225154 1.199417 1.266985 1.477537 0.342731 0.015360 1.593098 0.308444 0.689793 1.283280 1.858379 1.796250 0.849980 1.608558 0.116245 1.256722)
      )

;;; 102 even --------------------------------------------------------------------------------
(vector 102 13.554303556646 #r(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

	10.538847 #r(0.000000 0.439218 1.589873 0.524655 1.786432 0.437845 1.714084 0.878104 -0.008895 1.055200 0.266569 1.154207 0.619962 1.793769 1.048607 0.336793 1.607719 0.996995 1.834733 1.534921 1.220889 0.495358 1.913682 1.349308 0.326714 0.056684 1.791069 1.267966 0.869057 0.276580 1.956562 1.299266 0.899692 0.669547 0.006180 1.827319 1.639498 1.393132 1.017846 0.712519 0.317500 0.362334 1.956426 1.869198 1.633240 1.732987 1.436647 1.173907 1.295302 1.138785 1.390428 1.204234 1.094699 1.115028 1.181678 0.930174 1.689663 1.291196 1.434030 1.698877 1.618526 0.031143 0.150515 0.581125 0.622497 0.867610 1.132006 1.507806 1.700823 0.023406 0.228358 0.780422 1.410689 1.724372 0.072126 0.611697 0.887095 1.715995 1.822929 0.706183 1.227455 1.877274 0.029290 0.908952 1.592196 0.169922 0.937785 1.813425 0.179763 0.632587 1.869412 0.326028 1.038042 0.162062 0.939736 1.740120 0.900865 1.451860 0.737005 1.046089 0.220370 1.371478)
      )

;;; 103 even --------------------------------------------------------------------------------
(vector 103 13.923377530893 #r(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

	10.637699 #r(0.000000 0.072099 0.820394 1.359912 0.179595 0.900065 1.583502 0.218511 1.101883 1.970401 0.400594 1.426728 0.303545 0.996940 1.861231 0.794092 1.616200 0.601408 1.473710 0.479093 1.531323 0.441598 1.650724 0.662292 1.665558 0.821268 0.114838 1.326728 0.506797 1.589106 0.708567 1.634637 0.680975 0.136279 1.696297 1.023011 0.288578 1.399601 0.679633 0.067093 1.517997 0.923741 0.165011 1.627611 1.035363 0.574464 0.211876 1.709426 1.362157 1.035620 0.403713 1.659873 1.434545 1.175630 0.995636 0.635112 0.402899 0.265544 1.863627 1.423028 1.069857 1.098997 0.842321 0.929525 0.582951 0.609559 0.265913 0.460702 0.128433 0.493992 0.146832 0.378353 0.140301 0.185910 1.907475 0.623817 0.539723 0.742726 0.735137 0.992880 0.909352 1.064425 1.147479 1.191187 1.634759 0.235079 0.114445 0.586736 0.844371 1.211150 1.548662 1.768169 0.094471 0.595048 1.045395 1.416944 0.005895 0.738171 1.090696 1.695400 0.153870 0.655104 1.282748)
      )

;;; 104 even --------------------------------------------------------------------------------
(vector 104 14.080453047533 #r(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

	10.655611 #r(0.000000 0.002737 0.786660 0.762464 0.503819 0.286393 -0.101094 0.874998 1.473752 0.481431 0.799735 0.454749 0.797562 0.123163 0.117222 0.299046 0.020912 1.578857 1.002895 1.705703 -0.007757 0.103195 1.480404 0.954385 1.407414 1.390281 -0.078762 0.508743 1.125652 1.147568 1.109298 0.241566 0.554602 0.966853 0.853762 0.213708 0.336631 -0.359417 1.450986 0.895600 1.109197 0.514949 -0.727672 0.567370 0.897173 1.381717 0.383667 0.089275 1.227868 0.247579 1.500874 1.583210 1.136756 1.239813 1.262486 0.096506 1.116379 1.355019 0.566342 1.196814 0.267296 1.445432 0.676139 1.305121 1.708995 1.306893 0.702076 0.139787 0.915417 -0.114840 1.455487 0.770828 1.400008 -0.253470 1.614592 0.656377 -0.057294 -0.079245 0.869749 0.267749 1.372939 0.997670 -0.263003 0.171045 0.150465 0.628025 0.586743 0.431280 0.661077 1.149059 1.370748 1.121815 1.100709 0.702840 1.550696 0.883995 1.521682 0.013911 0.118726 0.932771 0.320159 0.230465 0.904049 1.045610)
      )

;;; 105 even --------------------------------------------------------------------------------
(vector 105 14.023490699521 #r(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

	10.723721 #r(0.000000 0.332824 0.415440 0.882736 0.523803 1.360644 1.423388 0.878260 0.362463 0.941638 0.806813 1.864927 0.586179 0.235848 0.839924 0.741525 0.612339 1.698359 1.465636 1.845257 0.657866 1.930277 1.548390 0.683787 0.112127 0.214598 0.881090 0.305091 0.990206 0.262783 1.806904 0.631628 0.647942 0.718460 1.496351 0.662584 0.639216 0.341484 0.526111 0.857527 0.332014 0.848248 0.538801 1.716285 1.540197 1.242894 0.874447 0.424758 1.530278 0.795862 1.560588 -0.045609 1.189403 1.318764 1.757011 1.932209 0.322168 0.988472 0.391897 0.586565 0.851440 0.179414 1.410229 1.032432 1.218472 0.243614 1.885097 -0.034215 1.892638 1.194939 1.805237 0.199323 1.638056 0.029528 1.623101 0.215857 1.613430 1.255620 1.686531 0.731822 0.943406 0.279542 0.804147 1.685225 1.001003 1.798551 1.462914 0.172784 0.323532 1.207708 0.894405 1.305291 1.576647 0.370376 0.912087 1.409772 0.249314 0.754150 0.992208 0.995763 0.410803 0.283607 0.381350 -0.007445 1.467917)
      )

;;; 106 even --------------------------------------------------------------------------------
(vector 106 14.077123010357 #r(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

	10.812622 #r(0.000000 -0.000527 0.583336 0.213931 1.345779 1.365423 -0.414111 0.533941 0.597784 0.342990 1.049705 -0.157990 -0.041990 1.234163 1.765199 1.107878 1.519379 0.093058 0.999648 -0.078379 -0.058631 1.475810 0.769209 0.443553 1.420724 0.126532 -0.252156 0.149708 0.494965 1.199937 1.134682 1.091128 1.279340 0.971378 1.891052 1.097189 1.523842 0.311775 1.348562 1.918994 1.317178 -0.041342 1.372711 1.328828 1.104728 0.497744 0.494504 1.061175 0.513407 0.549915 1.555977 0.588331 1.369798 1.153396 0.187734 0.337016 0.604247 0.633637 0.819682 0.814422 -0.227250 1.486086 1.320807 0.264193 0.090191 1.767222 1.580824 1.892570 1.684578 0.410804 0.153408 1.384440 1.705035 1.128131 0.965667 1.264814 0.410625 -0.232707 0.109608 0.093927 0.772327 0.009719 0.500858 0.326173 -0.027905 1.657634 0.438218 0.180908 0.380595 -0.267994 0.658322 0.234666 1.141409 1.095461 -0.057278 0.604403 0.650485 1.083029 0.054000 0.567556 -0.162320 1.663794 0.358557 0.599805 1.692337 1.285239)
      )

;;; 107 even --------------------------------------------------------------------------------
(vector 107 13.979104817741 #r(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

	10.871761 #r(0.000000 -0.038260 0.003022 -0.018329 1.213467 1.121724 0.959068 -0.160511 0.488688 0.785281 1.118276 1.544711 1.139909 1.233357 0.126103 -0.029438 -0.121856 1.238446 0.988099 0.353091 0.071789 0.374969 0.697386 1.469303 0.272146 0.836545 0.083890 0.522893 0.105483 1.125265 1.239268 -0.164882 0.473062 1.269911 0.092183 1.233174 0.490289 0.047130 1.055803 -0.115076 0.037623 1.254374 0.719443 1.622331 0.700838 1.458439 -0.131212 1.122661 0.402251 1.752491 0.411765 1.440232 1.051084 0.684942 0.919842 0.607712 0.701901 1.213147 1.671566 0.636427 1.628683 0.318565 1.291417 1.026164 1.614189 1.422466 0.225893 1.447977 1.113341 0.130879 0.381143 0.186791 1.807746 0.010150 -0.205153 0.273652 0.166348 -0.469555 1.063888 0.132156 -0.124512 1.747141 1.417884 0.518199 1.092473 1.116061 -0.120114 0.296073 0.135057 0.077875 0.451444 0.049425 0.587362 1.118866 0.690377 1.355396 1.775522 0.304132 0.222943 1.527070 -0.326515 0.290273 1.679190 1.440502 1.279010 -0.239898 1.289192)
      )

;;; 108 even --------------------------------------------------------------------------------
(vector 108 14.201394892821 #r(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

	10.901890 #r(0.000000 -0.008760 1.311207 0.741829 1.697635 1.769978 0.483762 -0.011910 0.594000 1.571800 0.727336 0.403254 -0.178000 0.178915 1.384182 1.515775 0.559532 1.061635 0.115279 0.323553 1.057305 -0.228524 1.741056 1.146085 0.293235 -0.033854 1.693885 1.428048 1.710511 0.540760 -0.057064 0.340583 1.919299 1.760577 0.355485 1.324653 1.044007 -0.047958 1.234996 0.120399 1.129054 1.589255 0.254279 0.040885 0.123640 1.536357 1.551030 0.029166 0.239461 0.090481 0.896972 0.493208 0.966504 1.387157 1.781930 1.203618 0.622514 0.933478 1.401265 0.946772 1.223548 0.392050 1.186575 1.501791 0.258041 0.107248 1.312213 1.481863 1.152627 1.509627 1.378069 0.561671 1.320539 1.066072 1.308170 0.560447 1.496940 0.414418 -0.059448 0.768917 0.282470 -0.004845 1.720774 0.169167 1.074669 0.800931 0.672622 0.038801 1.475364 1.803127 0.073523 1.954259 1.488839 1.468133 0.272926 0.552978 1.077413 -0.457399 1.655106 1.280832 1.454803 1.496722 0.568629 0.105281 1.014193 0.516031 0.749902 1.660920)
      )

;;; 109 even --------------------------------------------------------------------------------
(vector 109 14.476561866583 #r(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

	10.958464 #r(0.000000 -0.024181 1.291520 0.767267 1.811879 1.096780 0.807284 1.452102 1.623292 0.515719 1.794434 1.214113 0.027114 0.360179 0.096523 0.419005 0.212171 0.895803 0.749024 0.650410 -0.088834 1.146803 1.786825 0.525747 0.276037 0.849704 1.121864 -0.213295 -0.302842 0.632854 0.172238 0.871167 1.241159 0.835818 1.218555 1.639369 1.067001 1.940641 -0.030143 0.337334 0.672999 0.617052 1.569265 0.100021 0.522651 1.816358 0.861901 0.095900 0.093971 0.562585 0.367211 0.522900 0.329144 1.669724 1.020259 0.433402 1.811883 0.264750 1.838811 1.144868 1.228952 0.831417 0.460454 0.660827 1.255397 1.087733 0.659449 0.414654 0.947696 0.143809 0.676137 0.414552 1.792870 1.338552 0.130905 0.385794 0.569443 1.441682 0.524972 -0.164911 0.300497 0.900622 1.033704 0.403265 0.846988 1.497297 1.880923 0.509630 1.259061 -0.017944 0.841039 0.268164 1.965701 1.777373 1.538631 1.547306 -0.085746 1.343313 -0.098745 1.037268 0.541279 0.688208 0.047031 0.052006 1.222954 1.592090 1.082928 1.331120 0.843465)
      )

;;; 110 even --------------------------------------------------------------------------------
(vector 110 14.141825477743 #r(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

	11.059884 #r(0.000000 0.128382 0.371538 0.557291 0.625808 1.351628 0.701614 1.806009 0.600715 0.732979 0.283318 0.110741 1.230364 0.671428 0.850801 1.299783 1.058519 0.892084 0.432974 1.289301 1.791571 0.752181 1.260875 1.008626 1.512097 1.727166 0.038842 1.700370 0.866999 1.240474 1.578265 1.850372 1.448854 0.547254 0.613823 0.328365 0.250539 1.750062 1.718707 1.197601 0.724627 1.199208 0.765576 1.522749 0.897674 1.199312 1.130651 1.305566 0.409839 1.904493 0.957107 0.778353 0.924733 0.678177 1.680476 1.375915 1.497651 0.853122 1.844560 0.515262 0.618020 0.752328 0.596650 0.237988 0.979601 1.374435 0.138866 0.924444 1.825939 1.448797 0.183030 0.863483 0.340399 0.667618 0.464570 0.154564 1.886018 0.079312 0.671397 0.968235 1.426489 1.234932 0.594098 1.700737 1.694962 1.056715 1.809405 1.117610 0.795602 1.456320 0.035027 0.567201 1.028644 0.435753 0.636400 0.652240 0.222578 1.027763 0.072905 0.073994 1.054216 1.757379 1.232570 0.279961 0.282736 1.511203 1.136073 0.439627 0.936127 1.657387)
      )

;;; 111 even --------------------------------------------------------------------------------
(vector 111 14.043108609984 #r(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

	10.962200 #r(0.000000 0.101441 0.982500 1.622182 0.435973 1.132826 1.916394 0.466919 1.282549 0.106702 0.822917 1.670424 0.503141 1.534105 0.375975 1.281575 0.213224 0.919616 1.877533 0.775739 1.697874 0.635743 1.878719 1.005809 0.117804 1.045576 0.184335 1.296556 0.312839 1.530895 0.764842 0.001837 1.065550 0.399001 1.815485 1.127959 0.323638 1.622803 0.618390 1.914806 1.252012 0.774494 0.276141 1.654592 0.875835 0.224220 0.105741 1.448846 0.673723 0.202734 1.719143 1.430787 0.960901 0.580044 0.216029 1.940075 1.519845 1.228068 0.755865 0.422002 0.128938 0.097674 1.767997 1.577346 1.512735 1.286979 1.334403 0.747400 0.566022 0.512464 0.420179 0.476572 0.485716 0.310069 0.410649 0.127310 0.535251 0.330526 0.546628 0.297453 0.460546 0.467102 0.756615 0.965709 1.250982 1.419347 1.512597 1.506550 1.932151 0.044525 0.371558 0.543880 0.793911 1.426881 1.745178 0.091636 0.500091 1.035400 1.040570 1.580458 1.952025 0.527586 1.202063 1.570099 0.075568 0.820249 1.578634 1.929773 0.730234 0.929175 1.607930)
      )

;;; 112 even --------------------------------------------------------------------------------
(vector 112 14.53456401825 #r(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

	11.127877 #r(0.000000 -0.001085 1.282137 0.998741 -0.205971 1.928565 0.071274 1.841319 1.326948 0.300685 1.498908 -0.070768 1.161590 0.056680 1.272930 1.334591 -0.098080 1.464315 0.479872 0.580105 0.176864 0.756087 0.531884 1.012143 1.498205 0.228987 0.022862 0.999876 -0.051067 0.794646 1.309610 -0.219189 0.915579 1.677757 0.806023 1.382033 1.455612 1.332480 0.960905 0.464394 1.162518 -0.306061 0.559742 1.123282 1.350167 1.504507 1.342966 0.050212 0.499237 -0.040806 1.192981 1.158327 1.296484 1.289977 1.276373 0.095106 0.432483 1.951563 -0.083531 1.633917 1.149290 1.612046 0.813429 0.955830 1.031410 0.871830 0.390349 1.411863 0.797892 1.070847 1.576282 1.738863 -0.192573 0.878441 0.534579 1.599154 0.837106 0.103982 0.123777 -0.087352 0.353263 0.141925 0.015053 0.515859 0.335270 0.376322 1.623684 1.054267 0.761042 1.645886 0.155603 1.874182 1.253296 1.577361 0.535183 0.437252 1.764140 0.225923 1.434672 1.651003 0.945081 0.498783 1.227669 -0.300084 1.497489 0.611723 0.332536 1.215022 0.058021 0.315300 0.806999 0.126957)
      )

;;; 113 even --------------------------------------------------------------------------------
(vector 113 14.699631659332 #r(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

	11.042240 #r(0.000000 -0.011759 -0.091990 1.503851 0.953995 0.848423 0.824449 0.769931 1.085693 0.983953 0.209264 -0.381935 0.887958 0.412792 1.563438 1.182410 0.718501 1.286560 0.936464 0.451526 1.868537 1.661000 0.472937 0.524903 0.523627 0.742147 0.953195 1.273434 0.194871 0.356781 0.462037 1.763149 1.817491 0.735758 0.599041 0.219096 0.223049 0.947680 -0.008188 1.758721 1.570440 1.411663 0.250146 0.316431 1.488300 1.511605 -0.005537 0.330964 0.273108 0.486846 0.169393 0.538750 0.076418 -0.023342 -0.009678 0.527384 0.784140 1.277766 -0.217309 0.402150 0.912791 0.727922 -0.304687 0.485700 0.714916 0.485789 0.629834 0.893321 0.458517 0.111885 1.499674 1.465753 1.237628 -0.061921 1.790009 0.232643 0.792305 -0.479127 0.277430 1.180560 -0.176791 0.702891 1.163014 0.174404 1.121157 1.255388 1.509324 1.042583 0.380342 0.559327 -0.068543 0.980949 0.101017 1.112311 1.902337 1.208033 0.019879 0.351728 0.726801 0.451055 0.693184 1.569399 0.365346 -0.317722 0.810357 1.689676 1.274532 1.275271 1.331575 1.000370 -0.008700 1.311938 0.401453)
      )

;;; 114 even --------------------------------------------------------------------------------
(vector 114 14.492 #r(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

	11.098347 #r(0.000000 -0.084305 0.686719 1.094932 1.777563 0.352231 0.865991 1.279925 0.026498 0.635188 1.219862 1.804907 0.697456 1.406296 0.222804 1.043716 1.615578 0.439298 1.168459 1.904027 0.627364 1.579649 0.491166 1.406096 0.295653 1.249071 0.073326 0.964412 1.869141 0.835209 -0.027878 1.062653 0.042041 0.921226 0.288367 1.475210 0.454427 1.435928 0.717659 1.808229 0.838869 0.045471 1.230020 0.678087 -0.037112 1.008578 0.361932 1.875193 1.232330 0.293112 1.469296 1.119144 0.503482 1.773502 1.333307 0.823102 0.445692 1.763963 1.223804 0.590000 0.322677 1.712976 1.485726 0.940203 0.584026 -0.050739 -0.000940 1.558065 1.401153 0.782566 0.685465 0.248631 -0.011153 1.752643 1.682340 1.391724 1.316354 1.229915 1.001469 0.942190 0.768191 0.259975 0.412575 0.436097 0.321280 0.485202 0.478377 0.469726 0.528254 0.211780 0.499094 0.616893 0.739571 0.706949 0.797232 1.262382 1.306987 1.509284 1.881383 0.249648 0.351980 0.334789 0.600847 0.755270 1.339168 1.848532 -0.016155 0.526717 1.060832 1.195852 1.719393 0.117308 0.591043 0.923858)
      )

;;; 115 even --------------------------------------------------------------------------------
(vector 115 14.568 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

	11.110930 #r(0.000000 -0.022258 0.546651 0.820825 0.863779 0.676552 0.465607 1.912748 0.891113 -0.023328 1.112499 -0.561967 0.077021 -0.236221 1.201056 -0.357028 -0.135597 1.695864 0.020904 -0.014362 -0.046858 0.224875 0.950393 0.860763 0.507889 0.703037 1.149774 0.424951 0.869276 1.742922 0.930660 0.209184 0.714027 0.099306 1.605888 0.094118 0.072793 0.337413 0.037166 -0.429125 1.483943 0.947097 -0.230811 1.260136 1.245063 1.706276 1.663594 0.638816 -0.203738 1.582655 1.221409 1.765408 0.635267 1.340362 0.524104 0.262335 1.733350 1.410810 1.152474 0.297249 1.698065 1.592509 1.170191 0.600245 0.735038 1.067837 1.004305 0.072927 1.171730 1.251359 -0.136393 0.666240 0.837642 -0.025528 0.464160 0.954527 1.436030 1.301459 1.347745 0.368943 1.324507 0.782967 1.347513 0.072002 0.203967 1.181467 -0.425791 1.583443 0.318520 0.146198 -0.532390 1.922934 1.160601 -0.299039 1.454982 1.443796 0.959599 0.283371 0.857470 0.008285 -0.126730 1.672030 0.076134 0.919373 0.449423 -0.420407 1.240674 -0.238980 1.419242 0.108745 0.361247 1.035726 0.526839 1.297726 -0.220148)
      )

;;; 116 even --------------------------------------------------------------------------------
(vector 116 15.016979484255 #r(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

	11.277789 #r(0.000000 0.138558 0.353334 0.732609 1.466335 0.442620 0.355400 1.256820 1.098025 -0.005752 0.461058 1.458454 0.950319 0.007368 0.142342 1.388851 0.061902 1.789918 0.549269 1.413537 0.825366 0.204031 0.848000 0.919405 1.149599 1.315026 0.982443 0.510264 0.165540 0.235480 1.204630 1.939519 1.929226 0.652542 1.657663 0.250312 1.036625 1.299117 1.510759 0.176650 1.373970 1.713783 0.402361 1.150814 1.080597 0.910571 1.145886 1.285049 1.424689 0.696501 1.418026 0.550177 1.469848 1.617872 0.718078 0.116111 0.604744 1.337253 1.225191 1.194313 1.618071 0.888974 1.319098 0.950207 1.578045 1.168234 0.588120 0.978791 0.407817 0.203165 1.838352 1.709608 1.322935 0.085508 1.008488 0.674606 0.840645 1.426356 1.496070 0.091872 1.506537 1.114944 1.542923 0.104865 1.908253 1.125385 0.553795 1.861598 1.569825 0.283328 1.347436 0.562934 0.585686 1.843303 0.919209 0.760478 1.551244 0.654366 0.747062 0.126063 0.655696 0.345684 0.578473 0.602953 1.442577 1.226981 0.871137 1.454009 0.120416 1.377725 1.077575 0.748925 0.804978 1.803812 1.882510 1.871714)
      )

;;; 117 even --------------------------------------------------------------------------------
(vector 117 14.875072951405 #r(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

	11.295655 #r(0.000000 0.015789 0.761927 0.164296 1.137226 0.572015 1.663440 1.422409 0.787792 -0.050155 0.628761 0.990142 0.277289 1.451991 1.375499 0.530096 1.301677 0.122893 0.519504 1.243827 -0.093242 1.778981 0.990377 1.757063 0.998987 0.234404 0.215484 0.915405 0.226108 0.243442 1.185985 1.200501 1.457317 0.707602 0.281757 0.694395 0.083409 0.127419 1.069295 -0.500183 1.020824 0.421117 1.221639 1.025988 0.307270 0.873043 -0.504555 1.251328 1.261585 1.713619 0.158915 1.628175 0.087783 1.174880 1.183778 1.372114 1.284578 -0.354833 1.896012 1.648387 0.414766 1.072585 0.205469 1.421474 1.796970 1.478510 -0.009812 1.222216 1.185407 1.616957 0.050578 1.185467 0.607145 0.554314 1.018625 1.169956 -0.225029 1.045280 0.990726 0.187911 1.542308 1.755477 1.208191 0.597581 0.837919 1.722420 1.401438 0.887685 0.291694 0.955671 0.382697 0.515715 0.058443 0.094135 0.186403 1.061126 1.115386 1.656241 0.520357 1.154728 -0.447353 1.461708 1.223909 -0.102756 1.247952 -0.484730 -0.459947 -0.051712 0.971718 1.010436 0.426586 0.309351 0.447941 0.879457 0.725669 -0.314260 0.136093)
      )

;;; 118 even --------------------------------------------------------------------------------
(vector 118 14.774983755641 #r(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

	11.430459 #r(0.000000 -0.002386 1.351020 1.195235 1.641650 0.051761 1.571466 1.335031 -0.430277 0.166765 0.795826 0.277081 -0.613994 0.513637 1.515888 0.499068 1.273330 1.561448 0.515799 0.564727 0.965770 0.392215 0.994634 1.399343 1.836525 -0.113380 0.932903 1.544724 1.001123 0.863828 1.623559 -0.213987 0.188358 1.475181 1.229626 -0.263488 1.484470 0.252577 0.644938 0.557482 0.058922 0.194074 0.194026 0.173436 1.980047 -0.041784 0.088352 1.590134 0.326309 -0.014259 1.906859 1.475323 1.365229 1.740371 0.031667 0.992816 0.847417 0.617823 -0.353035 1.539456 0.841917 -0.171556 1.983344 0.333022 1.107476 0.288180 1.297023 0.803275 1.551471 0.997237 0.773738 0.526398 0.839684 1.564071 0.478223 1.619712 1.587580 1.173962 1.170969 1.649064 0.409317 -0.195377 1.263939 1.624548 0.858332 0.359467 0.126566 0.378534 1.850649 1.156439 1.102451 0.823089 1.173995 1.480436 1.412268 -0.136458 0.811973 -0.067259 -0.193895 0.767282 -0.278014 0.867874 1.257081 0.301798 1.419953 0.661723 1.088239 1.080885 0.024818 0.012407 1.197551 0.555424 0.340171 -0.508592 0.747823 1.261611 0.010095 0.902361)
      )

;;; 119 even --------------------------------------------------------------------------------
(vector 119 14.971 #r(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

	11.463073 #r(0.000000 0.028171 -0.146165 -0.131228 -0.002871 0.050862 0.742523 -0.204055 1.645617 0.290828 1.406479 0.868199 1.741918 0.453857 0.088300 1.057973 0.604458 0.312110 0.689801 1.760212 -0.475356 1.256266 0.378606 0.694419 0.272116 1.873466 1.520538 1.381650 1.298553 0.700506 1.390078 1.585936 0.052258 0.695189 0.310787 0.176459 0.526361 0.630602 0.358929 0.591920 1.972035 1.304111 1.258732 1.517336 -0.464016 1.113538 -0.482148 1.088302 0.933845 1.295331 0.335606 1.776922 1.275033 1.204638 1.244333 1.391313 0.047180 1.055001 1.066280 0.151122 1.195544 0.996156 0.624574 1.115134 0.474024 -0.291188 1.475027 1.248341 0.247929 1.521222 0.881443 0.964448 0.548203 0.189206 1.035434 1.076866 0.562671 -0.062004 0.950468 1.056851 0.161376 0.895700 1.001831 -0.042194 1.726944 1.884332 0.736198 1.659191 1.569481 1.019363 1.524131 0.771585 1.477099 -0.207180 0.066265 -0.237803 0.271422 1.281028 1.112414 1.108282 0.202944 1.362449 0.127218 0.632811 -0.100436 0.992623 0.244460 1.024970 -0.305227 1.813759 0.191019 0.633237 1.010988 0.236979 1.092657 1.909957 0.072845 0.799668 1.186061)
      )

;;; 120 even --------------------------------------------------------------------------------
(vector 120 15.153992567168 #r(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

	11.313532 #r(0.000000 0.104676 0.956023 1.599059 0.434678 1.169528 1.889256 0.640257 1.442051 0.165889 0.976076 1.807981 0.621356 1.475584 0.405972 1.323209 0.236755 1.233785 0.143049 1.033596 -0.026904 0.898062 0.015792 1.074368 0.192320 1.129597 0.306160 1.522081 0.616138 1.751385 0.834142 1.904965 0.997895 0.086818 1.434728 0.883358 0.351550 1.560824 0.820370 0.158445 1.507547 0.792677 0.129947 1.360589 0.737958 0.079098 1.407146 0.914007 0.770470 0.203603 1.502034 1.135858 0.645176 -0.091774 1.390493 1.144809 0.615547 0.243071 -0.050058 1.638797 1.461450 1.127851 0.650628 0.301074 0.089123 1.648239 1.424234 1.260231 1.210544 1.114894 0.875173 0.670427 0.701424 0.535264 0.413558 0.108332 1.989055 -0.068545 1.919263 0.116924 -0.035789 0.276203 0.037296 0.275125 0.137295 0.424822 0.191149 0.279247 0.302996 0.574841 0.813529 0.980002 1.232330 1.725699 1.569712 1.924406 0.069223 0.360022 0.573659 0.933475 1.279691 1.632918 0.255469 0.562101 1.067756 1.530003 1.698816 0.039390 0.454576 1.121018 1.691949 0.294664 0.786095 1.482129 0.154068 0.520585 1.217560 0.096243 0.268392 0.991799)
      )

;;; 121 even --------------------------------------------------------------------------------
(vector 121 14.652157793709 #r(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

	11.498650 #r(0.000000 0.017479 1.752861 1.440003 0.624686 0.129479 0.641447 1.341562 0.593468 0.092573 1.905946 0.997125 0.261861 0.048372 1.889251 0.142837 0.765384 1.710687 0.195906 0.342410 1.315796 0.119265 0.608166 -0.244887 -0.154423 0.398137 1.484756 -0.229778 0.353900 -0.366461 1.696566 0.970815 0.945103 1.713230 1.318200 1.305130 0.325861 1.373725 0.105467 0.699102 0.023474 -0.075524 1.335272 0.029557 1.727394 0.232393 -0.164352 1.504070 1.671916 1.239192 0.731760 1.855994 0.001337 0.046623 0.665635 1.502977 0.498905 1.125632 0.665870 1.191192 0.658116 0.375900 0.379214 0.151038 0.768298 0.439539 0.358454 0.950615 -0.144313 -0.136711 1.187031 1.258149 1.034973 0.243678 0.738640 1.590401 -0.293096 -0.203284 0.606420 0.080088 1.430878 0.439253 -0.306828 1.275529 1.691931 1.561946 1.190151 0.261707 0.236268 1.436181 0.601609 1.510865 0.669751 0.888690 1.488607 1.056654 0.978586 1.244435 0.048869 -0.143024 0.092247 1.414882 1.219028 1.818727 1.767970 0.238185 0.423897 0.655297 -0.079893 0.085180 0.061907 0.656438 1.053530 1.078859 -0.174787 1.119475 -0.227903 0.106017 -0.202495 0.468409 1.347654)
      )

;;; 122 even --------------------------------------------------------------------------------
(vector 122 15.057187309653 #r(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

	11.529673 #r(0.000000 0.531989 0.032244 0.809359 0.643699 0.940233 1.211701 1.640307 1.230816 1.281163 0.890644 0.832673 1.060694 0.784767 0.437632 0.739384 0.159222 1.884203 1.914674 1.955506 1.571876 1.250069 1.476246 1.593357 0.408554 0.425314 0.771861 0.879512 0.289738 1.524282 0.281054 0.607673 0.973892 0.526830 0.325881 0.459829 0.755809 0.530576 0.720264 1.799209 0.280393 1.362171 1.088718 1.980773 1.307845 0.079595 0.230562 0.731677 0.253961 0.706744 1.348348 0.256969 1.089508 1.878912 0.073929 0.290602 1.952316 0.832619 0.413722 0.636491 0.972388 1.527623 1.896001 1.061049 1.746008 0.425430 0.321016 1.095129 1.552982 0.090441 0.747170 1.958559 0.427124 0.466797 0.418100 1.541242 0.046283 1.361223 0.855174 0.943632 1.010409 0.014689 -0.019342 1.505174 1.159416 0.847135 1.349741 0.989026 1.835207 0.712087 1.684724 1.236150 0.856469 1.983000 1.274029 1.431454 0.606044 0.240737 0.706711 1.477845 0.962578 0.131471 1.263708 1.072723 0.899054 1.950074 0.263111 1.509700 1.649975 1.866656 0.559967 0.043385 1.804958 1.384084 0.518887 0.028429 0.971508 1.500748 0.072959 1.501179 0.980256 1.692731)
      )

;;; 123 even --------------------------------------------------------------------------------
(vector 123 15.156582832336 #r(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

	11.588512 #r(0.000000 0.004875 1.711641 0.140774 0.694092 1.226604 1.265115 -0.232126 0.423381 1.136178 1.270348 0.682996 1.300162 1.791337 0.002717 1.237250 1.220041 1.704800 1.500206 1.020887 1.436449 1.720551 0.899742 0.381519 1.626861 0.127065 1.123427 1.121023 0.433993 1.100929 1.512958 1.385432 0.720403 0.730341 0.295517 1.153332 0.686704 0.085572 0.424177 1.036488 0.470639 1.022538 0.516762 0.951898 1.664193 0.436191 0.950792 0.414108 1.426930 1.592214 -0.395823 0.466806 1.703885 0.079107 1.138873 0.565646 0.730205 1.577236 -0.050693 0.031099 1.032773 0.365734 -0.025372 1.345006 0.200195 0.590510 1.028771 0.941037 1.075449 1.242854 0.949630 1.389801 1.326208 1.907760 0.229976 0.990177 0.702999 0.627311 0.416140 1.460991 0.506869 1.150816 0.534159 0.164078 1.018971 -0.006478 0.769808 1.242997 1.281067 1.607631 -0.072110 1.211385 1.277184 1.052743 0.841699 1.197547 0.833355 -0.346596 0.499473 0.169111 0.418582 1.296369 1.945343 1.611120 1.206903 -0.218771 -0.883336 0.406585 0.188807 0.277040 1.647310 1.538067 0.815727 1.634132 0.720484 0.234373 -0.063759 1.712001 -0.338750 0.844698 -0.161091 1.122039 0.983728)
      )

;;; 124 even --------------------------------------------------------------------------------
(vector 124 15.192802705519 #r(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

	11.613572 #r(0.000000 -0.077215 0.641178 1.060103 1.725628 0.306888 0.805842 1.450285 0.080271 0.676079 1.132241 1.857448 0.658171 1.295977 0.051176 0.763104 1.487286 0.227693 0.896976 1.651658 0.503362 1.260680 0.020442 0.960467 1.750723 0.706447 1.647633 0.608155 1.404763 0.411396 1.378386 0.497264 1.537045 0.390954 1.312815 0.244673 1.348183 0.754218 1.873067 1.079854 0.297487 1.463268 0.418762 1.468541 0.755787 0.073685 1.109207 0.169319 1.335623 0.476893 -0.001720 1.492892 0.733144 0.017259 1.410812 0.672365 -0.203035 1.394200 0.880895 0.286488 1.576916 1.026797 0.776208 0.334706 1.764790 1.273553 0.792808 0.273363 -0.126099 1.289140 1.274608 0.822262 0.511006 0.130142 1.781612 1.702529 1.506031 1.031169 0.621717 0.386447 0.078504 -0.139145 1.736386 1.809301 1.574313 1.478345 1.122012 1.243432 0.926704 1.118043 0.660452 0.854324 0.610672 0.712796 0.721629 0.815653 1.007264 1.134982 0.924943 1.132678 1.013992 1.272278 1.166045 1.487404 1.763433 1.755645 0.132866 0.350667 0.743565 0.800556 0.940828 1.208015 1.336563 1.760012 0.309924 0.660774 0.885951 1.465040 -0.071806 0.213365 0.719022 1.340303 1.411523 -0.008348)
      )

;;; 125 even --------------------------------------------------------------------------------
(vector 125 15.340427254326 #r(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

	11.696823 #r(0.000000 -0.085750 0.158005 1.735612 0.685137 0.945836 0.940768 0.518947 0.290366 1.666997 0.139045 0.126203 -0.010830 -0.066052 0.885099 0.937954 0.044708 0.464249 0.929915 1.304222 0.908681 0.209565 1.334067 0.050259 0.057814 1.106583 0.493155 1.406315 0.503058 1.426903 -0.609961 1.642370 0.567715 0.443903 0.372472 0.229085 1.417589 -0.346355 1.038979 1.429340 1.311859 0.366425 0.720813 0.298548 0.333529 0.756555 0.885562 0.416723 0.319844 1.424324 0.513839 1.436280 1.307000 1.020838 -0.126223 0.941415 1.709852 0.135933 0.334813 0.368977 0.672118 1.809440 0.983753 -0.003965 1.265366 0.117324 0.012853 -0.124324 1.605949 0.158672 1.903061 0.984489 1.293097 0.030888 0.683378 1.189519 0.718666 1.266029 0.346022 0.570626 -0.391723 1.498161 1.644708 1.306785 0.578694 1.158328 1.797525 -0.527735 -0.363727 0.648855 1.852302 1.504515 0.619970 1.089044 0.226289 0.384003 0.209403 1.104542 0.537595 1.258766 1.665789 0.231209 0.662211 0.482958 1.347241 -0.340183 0.238825 0.143658 1.745780 0.737818 0.314391 -0.394796 1.010702 0.585559 0.523138 0.790496 1.162076 0.664333 0.775733 0.877231 1.314011 0.663054 1.008894 0.598395 0.431429)
      )

;;; 126 even --------------------------------------------------------------------------------
(vector 126 15.28212621738 #r(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

	11.703152 #r(0.000000 0.096558 0.858237 1.253318 -0.015046 0.718704 1.348846 1.900141 0.566192 1.208317 1.941379 0.630210 1.308548 0.144213 1.015208 1.707639 0.626405 1.587907 0.354824 1.208059 0.008953 0.884521 1.873194 0.819738 1.783293 0.643406 1.599810 0.796866 1.955770 0.860026 1.884479 0.882399 1.818134 1.010533 0.035693 1.179576 0.329825 1.512427 0.674447 0.023525 1.226679 0.448543 1.685164 0.973203 -0.048933 1.379465 0.672254 1.854706 1.136118 0.729702 -0.026031 1.325925 0.964455 0.342495 1.575265 1.011689 0.505283 1.830974 1.220292 0.905128 0.429702 1.955910 1.643840 1.228384 0.736382 0.444010 1.912379 1.426082 1.115112 0.833472 0.391194 0.150101 1.880095 1.833447 1.569604 1.250709 1.013961 0.775242 0.571573 0.416334 0.125474 0.075273 1.824141 1.986914 1.815271 1.931859 1.836071 1.823625 1.665372 1.543210 1.698633 1.228598 1.673505 1.361896 1.687203 1.790599 1.955483 0.031563 0.256585 0.174165 0.370849 0.358074 0.779148 0.726705 0.965589 1.287288 1.714926 0.099738 0.323073 0.843752 0.970655 1.331421 1.560527 1.778487 0.212367 0.598792 1.166691 1.836224 0.212608 0.794199 1.448179 1.527740 0.079660 0.725629 1.206239 1.660826)
      )

;;; 127 even --------------------------------------------------------------------------------
(vector 127 15.237931718393 #r(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

	11.789979 #r(0.000000 -0.001132 0.897517 0.394382 1.260286 0.778304 0.836616 1.625461 1.739876 1.973405 0.832561 -0.094515 1.731739 0.333639 0.836968 -0.107876 0.070482 1.012477 0.940091 1.307348 0.393707 1.442720 0.861719 0.744806 0.312510 0.611089 0.927754 0.853317 0.134994 0.107430 0.037825 0.312394 1.700751 1.213044 1.226487 1.011854 0.861083 0.772034 0.520630 1.253292 0.972555 0.220816 0.667221 0.579331 1.207076 0.848173 0.881872 1.323012 1.222919 -0.052129 1.260636 0.538181 0.300938 0.871330 0.135056 0.343171 1.400686 1.405366 1.050179 1.096651 0.719543 1.228509 1.109861 1.313762 0.542329 1.766261 1.421361 1.230519 1.420958 0.268636 0.479183 0.342346 0.595355 1.855218 -0.019779 0.874866 0.185594 -0.136341 0.472427 0.790967 0.143693 0.462337 0.746424 0.172494 0.510100 1.302826 1.846530 0.481197 0.145292 1.261219 1.016223 -0.050720 1.664990 1.749224 0.161564 0.976204 1.514784 0.954951 1.610573 1.531118 -0.672953 0.098304 0.152113 0.497593 -0.167125 1.036222 1.044964 0.844274 0.193598 1.029973 0.233918 1.378605 0.220451 1.286808 0.078131 0.610438 1.205447 -0.007484 1.810339 0.820177 0.824174 1.112769 0.665708 -0.080601 0.134336 1.244008 0.715267)
      )

;;; 128 even --------------------------------------------------------------------------------
(vector 128 15.651492555885 #r(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

	11.830152 #r(0.000000 0.006782 1.060624 1.211296 0.293074 1.273318 0.314512 1.826803 0.239201 1.156802 1.298198 0.077804 1.822347 1.682910 1.385524 1.038512 -0.396824 0.008830 1.443050 0.294818 1.610271 1.195727 1.747067 1.264125 0.380208 0.325636 0.108242 0.283890 -0.191659 0.067237 1.290037 0.217524 0.336243 0.213550 1.141382 0.223281 1.623265 0.741878 -0.249759 0.604458 1.040995 0.068971 0.721985 1.834529 1.429615 0.606681 0.670356 0.241565 1.624232 0.893260 1.150356 1.152656 0.346887 0.798654 1.851338 0.951081 1.875604 0.202415 0.414236 0.457570 1.375118 1.252622 1.176332 0.207988 0.196677 1.941237 0.863363 1.619621 -0.226038 -0.283982 0.962795 0.411171 1.411590 0.197410 0.563329 0.468261 0.398533 0.069544 -0.014006 0.870262 -0.106509 0.116268 1.812259 1.697896 -0.060401 0.066686 0.279835 0.231452 1.082447 1.099824 1.175787 1.117046 1.447844 -0.230882 0.230008 0.906488 1.601754 1.772871 1.477415 1.267041 0.261730 -0.040738 1.416845 0.809274 0.114237 1.322977 0.639146 1.726468 0.362841 0.604035 1.100292 1.726907 0.530237 1.036102 1.333246 1.293644 1.618742 0.555320 0.472298 -0.036953 0.020660 0.061453 1.538933 0.319946 1.305954 1.451303 0.269500 1.531977)
      )

;;; 256 even --------------------------------------------------------------------------------
(vector 256 24.434719362486 #r(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

	16.895858 #r(0.000000 -0.009189 0.902358 0.365887 -0.111323 -0.780998 -0.023618 -0.522343 0.279380 0.055265 -0.008058 0.474170 0.130008 0.951121 -0.734333 0.844285 0.824339 -0.107239 0.507621 0.164958 -0.496056 -0.789687 0.259333 -0.449818 0.843661 -0.030179 -0.474099 0.774618 -0.182868 0.024412 0.577418 -0.074812 -0.020675 0.192634 -0.599606 -0.070169 -0.948055 -0.992660 0.778395 -0.043578 -0.432579 -0.186685 -0.510874 -0.014069 -0.480270 0.346549 0.508024 0.846868 -0.259984 -0.239547 -0.834355 0.758428 0.757435 0.373609 -0.602450 0.574091 0.372351 0.871018 -1.004894 0.279914 0.796533 0.315579 -0.170724 -0.162430 -0.867211 -0.645076 0.714848 -0.271719 0.114112 0.067143 0.832100 -0.116990 -0.262191 -0.281235 -0.535795 0.830911 -0.182047 0.489779 0.867411 0.246384 -0.008329 -0.604672 0.770953 -0.982833 0.931441 -0.618590 -0.552932 0.209497 -0.183212 0.365740 0.769646 0.703588 -0.289040 -0.817528 -0.369365 0.293481 0.472048 0.790519 -0.426911 0.891352 -0.538143 -0.944128 -0.920976 0.221321 -0.509927 -0.348596 -0.644560 -0.213342 -0.745624 -0.706666 0.930922 -0.848273 -0.242448 -0.036301 0.898791 -0.590640 0.780449 -0.061417 0.458673 -0.691004 -0.831524 0.551686 0.225320 0.474068 0.953196 -0.781398 0.825342 0.760168 0.391595 0.124100 0.860713 -0.055973 0.585971 -0.869796 1.059960 -0.289476 -0.119142 0.020537 -0.912617 0.156202 0.608148 0.008605 -0.492103 -0.103742 0.428971 0.411193 -0.565692 0.935156 -0.112585 0.617223 -0.155032 0.327195 0.230999 -0.493871 -0.157653 0.741876 0.652071 0.725265 -0.509926 -0.435321 0.803678 0.422316 0.647203 -0.330251 -0.717114 -0.003821 -0.171433 0.905326 -0.870296 -0.075782 -0.123811 -0.827857 0.305695 -0.297883 0.361037 0.368875 0.307670 -0.861180 0.111296 0.743619 -0.505788 0.890369 -0.751559 0.768455 0.001867 -0.755119 0.593706 0.249715 0.003021 0.017365 -0.006817 0.077961 0.209405 -0.908703 -0.016914 0.016411 -0.745949 -0.862316 0.805206 -0.373876 -0.644818 0.552974 -0.723400 0.564147 0.221354 0.241461 -0.891285 0.457125 0.981689 -0.591672 -0.034527 -0.765054 -0.120687 0.438528 0.848881 -0.507062 0.069395 0.639313 -0.825275 0.641684 -0.188946 0.565634 -0.791635 -0.287596 -0.132874 -0.202513 0.559214 0.080018 0.796540 0.338441 0.210736 0.641999 0.009248 0.322360 -0.028925 0.697480 0.479428 0.122723 0.885702 -0.174527 0.157389 0.019802 0.207762 -0.007817 -0.188184 0.284891 0.769384 -0.699713 -0.860470 0.816560 0.661637 0.821235 0.090760 0.680062 0.906877 -0.017234)
      )

;;; 512 even --------------------------------------------------------------------------------
(vector 512 35.776 #r(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      ;; from (try-all :even 512 513 0.0057725498034576  0.26769012113045) = 29.0733
	24.510365 #r(0.000000 -0.019547 0.424156 1.640830 1.364680 1.818776 1.105842 0.737080 1.188869 0.460419 0.154877 0.614397 1.827954 1.526781 0.018169 1.203682 0.956144 1.444331 0.584264 0.344508 0.856804 -0.002275 1.790988 0.291010 1.439116 1.211881 1.741084 0.845603 0.707294 1.180635 0.339890 0.164786 0.645301 1.820612 1.656940 0.157290 1.307936 1.130965 1.686613 0.833679 0.620052 1.209627 0.322209 0.138398 0.734419 1.838268 1.653494 0.235420 1.341020 1.194471 1.729004 0.905361 0.771623 1.262727 0.487832 0.366383 0.843119 0.069579 1.963835 0.460118 1.649699 1.520680 0.055018 1.185740 1.101098 1.643899 0.752530 0.667948 1.169078 0.382792 0.269771 0.820501 0.061364 1.929744 0.493658 1.740499 1.549752 0.138458 1.334798 1.217842 1.724754 0.932476 0.823652 1.326258 0.605394 0.510375 1.024728 0.340933 0.185795 0.774497 0.036705 1.862931 0.456043 1.668642 1.590302 0.139925 1.318436 1.326961 1.864132 1.011509 1.051965 1.624689 0.808072 0.775618 1.339118 0.606082 0.484361 1.076072 0.379297 0.250899 0.852275 0.110682 0.007792 0.595200 1.830378 1.789905 0.359788 1.659536 1.611286 0.154864 1.497402 1.399711 1.998779 1.270070 1.199870 1.801564 1.085483 1.010139 1.613933 0.921049 0.862702 1.434888 0.750644 0.728545 1.284532 0.570978 0.570652 1.118882 0.422457 0.414420 0.977086 0.320768 0.330042 0.881914 0.218609 0.199085 0.805391 0.088964 0.043485 0.695205 -0.000491 1.966513 0.612316 1.930538 1.950727 0.563038 1.854742 1.879285 0.451929 1.795108 1.794421 0.370361 1.783471 1.745602 0.399279 1.738776 1.661161 0.350902 1.625174 1.614568 0.302843 1.577093 1.678861 0.313770 1.663823 1.660571 0.328157 1.709209 1.610846 0.310206 1.720381 1.669108 0.335355 1.656296 1.693491 0.346281 1.654195 1.699773 0.373651 1.773772 1.752470 0.473140 1.826907 1.822715 0.581620 1.832675 1.919552 0.622630 1.929526 0.005176 0.677897 0.085092 0.090877 0.761048 0.206124 0.205634 0.890197 0.304835 0.339949 1.002646 0.395940 0.448746 1.152273 0.561345 0.581101 1.310704 0.737714 0.744961 1.486545 0.848210 0.931544 1.627529 1.007712 1.110684 1.778206 1.199087 1.278685 -0.040639 1.383705 1.405450 0.148513 1.511196 1.633778 0.391073 1.740722 1.849679 0.658438 0.031218 0.137149 0.870371 0.331222 0.296051 1.070588 0.528400 0.591834 1.345092 0.751955 0.829846 1.642139 1.030239 1.201544 1.943718 1.298486 1.407002 0.143893 1.607481 1.695116 0.415675 1.905744 -0.027620 0.742513 0.206291 0.320377 1.123679 0.506496 0.647078 1.425059 0.880594 0.962991 1.736110 1.225483 1.369479 0.064842 1.600531 1.706861 0.517054 1.973656 0.069623 0.837048 0.295925 0.404900 1.263222 0.684812 0.775618 1.577141 1.057937 1.264522 0.064638 1.531997 1.682245 0.471443 1.922985 0.104388 0.897292 0.423113 0.526550 1.412335 0.758158 0.917306 1.736464 1.285171 1.451805 0.278569 1.745150 1.879876 0.677038 0.183709 0.366812 1.118883 0.736257 0.864386 1.688806 1.159516 1.253423 0.100375 1.645658 1.871576 0.762011 0.249411 0.395560 1.273133 0.699592 0.948774 1.805372 1.338330 1.530595 0.294092 1.900787 0.034538 0.923012 0.390364 0.586314 1.386265 1.030145 1.202559 0.071001 1.609371 1.743831 0.671235 0.194183 0.391537 1.251984 0.751826 1.009573 1.860932 1.448367 1.525073 0.422286 -0.073409 0.262981 1.099563 0.626545 0.818453 1.723102 1.361444 1.531582 0.390953 1.909101 0.215438 1.139977 0.737652 0.881882 1.821234 1.380301 1.618894 0.473317 0.045322 0.250969 1.146414 0.800355 0.959156 1.857842 1.429019 1.673847 0.622261 0.184525 0.502145 1.323715 0.914639 1.172552 0.096636 1.761155 1.977345 0.871966 0.396190 0.668483 1.677724 1.221155 1.466337 0.368967 0.009966 0.302335 1.180746 0.786475 1.025502 -0.022711 1.584463 1.830638 0.746555 0.413840 0.650268 1.656745 1.224810 1.557055 0.513491 0.173029 0.435007 1.290629 0.926051 1.263115 0.272344 1.896521 0.084566 1.048863 0.725520 0.987362 -0.027617 1.571108 1.900984 0.869809 0.386916 0.758635 1.730437 1.409025 1.672233 0.588812 0.243929 0.511763 1.494695 1.169935 1.437757 0.431437 0.111507 0.458811 1.437247 1.136523 1.434884 0.401589 0.040030 0.372128 1.370962 0.999488 1.378913 0.377301 -0.009324 0.355264 1.331258 1.008855 1.339035 0.373593 0.044480 0.312196 1.329497 1.000220 1.342701 0.417261 0.083063 0.411303 1.346062 1.090657 1.409862 0.373501 0.211768 0.447452 1.458597 1.131955 1.458774 0.553807 0.205989 0.569249 1.645656 1.188483 1.668112 0.674809 0.371651 0.732131 1.751447 1.522458 1.904784 0.884407 0.617430 0.990830 0.073047 1.730004 0.133217 1.189522 0.869836 1.203019 0.328634 0.051596 0.424552 1.471161 1.210755 1.549745 0.605989 0.343260 0.768857 1.816839 1.581320 1.934635 1.014299 0.737558 1.116115 0.236955 0.018173 0.380416 1.539634 1.251595 1.652099 0.829587 0.536746 0.936033)
      )

;;; 1024 even --------------------------------------------------------------------------------
(vector 1024 51.895 #r(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

	34.486667 #r(0.000000 0.010065 0.257552 0.593803 0.986349 1.354691 1.689002 0.065945 0.448419 0.795563 1.178916 1.585370 1.936149 0.310262 0.750710 1.056729 1.463725 1.825064 0.240816 0.539819 0.934214 1.340840 1.748800 0.092213 0.555713 0.915825 1.311840 1.650847 0.107697 0.477455 0.875194 1.288435 1.748432 0.197793 0.591516 1.015839 1.387092 1.854496 0.260210 0.614591 1.088807 1.497165 1.960609 0.347241 0.837150 1.265241 1.711792 0.103196 0.588662 1.043276 1.427385 1.898809 0.315073 0.790510 1.283232 1.726769 0.124226 0.582532 1.048754 1.444755 1.928781 0.425680 0.899080 1.335881 1.855991 0.327701 0.850115 1.267294 1.746464 0.254433 0.681023 1.221402 1.713475 0.176608 0.633457 1.170011 1.638469 0.136940 0.628672 1.079274 1.611588 0.107068 0.579047 1.125534 1.649825 0.159484 0.714499 1.195717 1.694762 0.283005 0.777095 1.317639 1.818676 0.294685 0.848021 1.366508 1.912960 0.442114 0.974399 1.491097 0.046085 0.607725 1.172318 1.701676 0.262890 0.804042 1.333049 1.847711 0.428372 0.986686 1.556422 0.120990 0.632701 1.249707 1.826221 0.398395 0.969062 1.507301 0.132868 0.725711 1.273823 1.851630 0.403540 1.046615 1.591703 0.182065 0.801530 1.386897 0.003430 0.562296 1.182148 1.798000 0.384640 0.992083 1.618128 0.211791 0.774713 1.389562 -0.001657 0.608366 1.236020 1.865011 0.529780 1.135532 1.738754 0.419570 1.019563 1.624992 0.265061 0.904049 1.533452 0.168181 0.865137 1.479101 0.127557 0.777817 1.390745 0.031342 0.661481 1.347873 -0.028252 0.673301 1.341813 0.012139 0.723533 1.359095 0.015081 0.667348 1.354810 -0.010820 0.651242 1.361901 0.014799 0.676361 1.414902 0.077676 0.777314 1.483046 0.156058 0.835487 1.534362 0.214249 0.944327 1.656367 0.337182 1.061518 1.736952 0.487837 1.221677 1.941805 0.641987 1.334519 0.012624 0.761615 1.493616 0.235055 0.987696 1.681644 0.449481 1.152512 1.880553 0.557489 1.300096 0.093548 0.829304 1.606739 0.333558 1.038662 1.817653 0.564596 1.346595 0.088231 0.789038 1.556219 0.364445 1.109277 1.894547 0.648472 1.394876 0.167696 0.927734 1.744135 0.473122 1.327580 0.053170 0.846408 1.630482 0.424396 1.252576 0.026366 0.794678 1.571738 0.353780 1.148629 -0.009061 0.802059 1.560730 0.388025 1.189760 -0.020908 0.838019 1.634252 0.450483 1.274303 0.061988 0.909080 1.739029 0.567344 1.395698 0.191004 1.056594 1.900321 0.701479 1.570664 0.420443 1.216101 0.035038 0.906051 1.794894 0.619739 1.485033 0.319328 1.177367 0.049998 0.912455 1.796694 0.663275 1.464877 0.322458 1.201076 0.079874 0.975135 1.812753 0.671629 1.550884 0.438265 1.308416 0.227568 1.107771 0.008272 0.852340 1.757258 0.665419 1.573359 0.450697 1.364674 0.288498 1.149330 0.046861 0.927672 1.818815 0.731499 1.703383 0.640630 1.515945 0.404842 1.338883 0.309581 1.223075 0.140786 1.078108 -0.017158 0.933921 1.856585 0.819946 1.718757 0.674573 1.629213 0.552624 1.480565 0.473092 1.440553 0.370780 1.316286 0.261652 1.233065 0.181284 1.136614 0.128844 1.063581 0.043473 0.988622 -0.007730 0.942926 1.896166 0.930670 1.890388 0.822783 1.839642 0.888701 1.829032 0.748117 1.787911 0.785711 1.793168 0.753464 1.768597 0.785917 1.789379 0.746424 1.769933 0.789526 1.789893 0.806228 1.806824 0.845014 1.858918 0.876599 1.887462 0.916183 -0.011424 0.947836 0.026544 1.052806 0.074297 1.092552 0.117837 1.145621 0.172062 1.271069 0.265950 1.343262 0.368273 1.426940 0.471985 1.600258 0.591440 1.643063 0.779963 1.778002 0.823172 1.887460 0.980164 0.056312 1.104881 0.194563 1.270671 0.317598 1.432357 0.527173 1.586831 0.679001 1.710986 0.856576 1.952932 1.034214 0.168860 1.247239 0.332452 1.455153 0.496571 1.598578 0.746454 1.841506 0.980194 0.065850 1.191729 0.313463 1.362280 0.540259 1.674133 0.807281 1.901298 1.046989 0.152754 1.296905 0.437367 1.599457 0.712142 1.832022 1.021052 0.159471 1.255226 0.399699 1.567354 0.776219 1.903366 1.055241 0.221691 1.359842 0.508090 1.682588 0.830923 0.010406 1.164777 0.321654 1.495630 0.648746 1.854778 1.028798 0.224012 1.437178 0.587301 1.746745 0.969426 0.124185 1.311647 0.558251 1.730677 0.926291 0.114111 1.341596 0.557527 1.745728 0.936491 0.127337 1.383134 0.617625 1.786691 1.023246 0.229459 1.472437 0.676585 1.907197 1.123237 0.355057 1.633938 0.880784 0.058692 1.279872 0.552335 1.779394 1.011586 0.276736 1.508029 0.759625 0.024536 1.276380 0.493761 1.728419 1.013811 0.266997 1.523472 0.795713 0.046243 1.307283 0.623236 1.877970 1.148383 0.427672 1.683629 1.001954 0.298274 1.554589 0.835462 0.173731 1.457407 0.693880 -0.034472 1.275602 0.593467 1.866633 1.210093 0.521728 1.772084 1.113712 0.385701 1.695457 1.069859 0.333163 1.607126 0.969652 0.282736 1.586932 0.934788 0.272131 1.571926 0.921386 0.293345 1.575513 0.936770 0.269737 1.574193 0.968165 0.284669 1.613899 0.986360 0.310459 1.654676 0.993511 0.432366 1.747611 1.058842 0.426357 1.800267 1.182611 0.576028 1.923944 1.270340 0.656610 0.044384 1.408707 0.752047 0.170780 1.558617 0.971026 0.315606 1.679451 1.091283 0.469917 1.819954 1.288114 0.668750 0.054741 1.461129 0.888977 0.275646 1.712213 1.100500 0.539170 1.932708 1.357198 0.750588 0.169930 1.599158 1.015737 0.433884 1.847466 1.290316 0.699471 0.106715 1.618980 1.039270 0.483584 1.877301 1.355281 0.739383 0.283415 1.680260 1.142458 0.582946 0.025158 1.503785 0.917235 0.402386 1.888910 1.374775 0.801742 0.267251 1.729725 1.190453 0.690588 0.170200 1.607615 1.116870 0.626944 0.099949 1.558114 1.042989 0.565792 0.001984 1.534796 0.981050 0.506989 0.024697 1.512493 1.045167 0.509838 0.035449 1.540981 1.040413 0.579777 0.067009 1.583544 1.092800 0.643044 0.165297 1.660919 1.190925 0.750261 0.244662 1.789497 1.303951 0.852702 0.402882 1.925637 1.511267 0.983904 0.525287 0.093612 1.625678 1.236625 0.751894 0.317275 1.862598 1.434730 1.003450 0.590395 0.130259 1.632064 1.251831 0.793529 0.395744 1.982905 1.518992 1.185899 0.724078 0.280841 1.851085 1.414649 1.036031 0.628024 0.190307 1.817967 1.407380 0.997638 0.626750 0.187117 1.827944 1.364014 1.005368 0.643575 0.271950 1.870132 1.455625 1.102716 0.663688 0.366474 1.947786 1.531948 1.165389 0.820292 0.417060 0.106203 1.736409 1.349795 1.017056 0.602019 0.247808 1.904232 1.522798 1.168173 0.822339 0.502122 0.190982 1.830461 1.503095 1.146005 0.824132 0.425448 0.163732 1.809535 1.439358 1.134762 0.787451 0.444950 0.125696 1.859821 1.507864 1.225427 0.898766 0.552383 0.249459 1.921771 1.641843 1.335828 1.036153 0.712405 0.407286 0.113814 1.810275 1.573082 1.216807 0.937380 0.622140 0.413886 0.065441 1.811766 1.479615 1.239853 0.962208 0.676221 0.428567 0.149787 1.861526 1.595913 1.378366 1.072254 0.858051 0.546952 0.352387 0.048977 1.781409 1.500802 1.320643 1.034780 0.814060 0.561026 0.270289 0.105077 1.781981 1.587128 1.356228 1.096895 0.899561 0.695426 0.422635 0.191053 0.015040 1.742763 1.540766 1.372440 1.135422 0.929280 0.712972 0.501615 0.300048 0.059338 1.847659 1.743466 1.446302 1.288333 1.097146 0.896394 0.693469 0.504749 0.273709 0.134422 -0.008122 1.752436 1.590209 1.416861 1.263443 1.015309 0.919786 0.724562 0.550733 0.413427 0.220154 0.085059 1.972253 1.758570 1.618664 1.418349 1.309492 1.092633 0.962125 0.822521 0.683138 0.548516 0.433745 0.271343 0.157018 -0.024488 1.878961 1.706051 1.633364 1.472286 1.423267 1.197350 1.130839 0.991815 0.864748 0.717411 0.656940 0.500335 0.378398 0.306249 0.174522 0.042370 1.957239 1.876551 1.787343 1.657177 1.630866 1.501218 1.454476 1.399481 1.281728 1.174679 1.094880 1.013897 0.872646 0.836534 0.733703 0.745572 0.645048 0.520901 0.517442 0.446338 0.403105 0.220915 0.272964 0.177893 0.121891 0.010365 -0.003026 -0.000541 1.946558 1.858421 1.798242 1.770282 1.765566 1.731024 1.646864 1.612063 1.606047 1.594080 1.512626 1.534901 1.459982 1.452555 1.426312 1.441887 1.450640 1.394928 1.401770 1.413824 1.398282 1.361199 1.386696 1.351788 1.315050 1.337782 1.369731 1.375462 1.382434 1.387327 1.390480 1.425063 1.472649 1.428947 1.444989 1.479959 1.454545 1.459856 1.514843 1.537769 1.564144 1.568551 1.669900 1.683717 1.723822 1.813102 1.823001 1.907890 1.890197 1.964939 -1.797036 0.049327 0.116611 0.169727 0.229816 0.312230 0.322585 0.436099 0.459978 0.494355 0.617621 0.657990 0.713966 0.784856 0.873687 0.939607 1.031179 1.056185 1.173421 1.311953 1.410978 1.454966 1.612093 1.676857 1.761378 1.862190 1.974384 0.042558 0.158632 0.245595 0.350975 0.483237 0.594289 0.729058 0.805700 0.959748 1.072984 1.213228 1.313277 1.445492 1.585944 1.673320 1.810642 1.960761 0.110169 0.205253 0.318753 0.449203 0.638254 0.764806 0.903920 1.064434 1.168013 1.366785 1.485581 1.644159 1.803584 -0.028237 0.153100 0.380114 0.509401 0.641451 0.849001 1.016399 1.215481 1.423241 1.573069 1.764733 1.942264 0.047242 0.295850 0.470228 0.640443 0.830347 1.055180 1.227983 1.357851 1.599606 1.739714 -0.029549 0.205220 0.379610 0.585030 0.816103 1.019847 1.251050 1.461935 1.647821 1.868576 0.147180 0.369132 0.579279 0.840715 1.094368 1.320093 1.565710 1.787983 -1.714361 0.195527 0.507750 0.710357 0.949912 1.153061 1.372724 1.700420 1.865502 0.178913 0.436041 0.694461 0.986729 1.187621 1.476665 1.752454 0.027539 0.321199 0.550142 0.802831 1.077337 1.362471 1.620159 1.900867 0.213014 0.446588 0.803703 1.113716 1.403572 1.697697 0.018021 0.315688 0.615559 0.932639 1.205074 1.541734 1.854009 0.125499 0.502519 0.744264 1.071360 1.395926 1.658298 -0.006671 0.333250 0.704886 1.026706 1.348527 1.693526)
       )

;;; 2048 even --------------------------------------------------------------------------------
(vector 2048 87.471149563312 #r(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       ;; (try-all :even 2048 2049  0.0014328746687631 0.51217918249646) = 56.93601 start for next
	50.887273 #r(0.000000 -0.001703 0.433172 1.590778 1.336810 1.796101 0.945990 0.630649 1.068973 0.276030 0.019619 0.418921 1.642205 1.314880 1.815562 0.937954 0.690335 1.166456 0.260174 0.033467 0.534551 1.577952 1.359691 1.855935 0.978115 0.778145 1.214744 0.305514 0.073250 0.585950 1.700979 1.456846 1.891326 1.051448 0.870291 1.262779 0.419868 0.209104 0.667538 1.764244 1.534253 0.022691 1.157333 0.886455 1.397513 0.522770 0.305417 0.791572 1.882641 1.706581 0.124613 1.245754 1.016938 1.507704 0.621789 0.423116 0.882723 0.034318 1.775279 0.266045 1.420137 1.176158 1.620182 0.842558 0.553079 1.037944 0.182615 0.005162 0.432646 1.577593 1.375077 1.777427 0.999839 0.726166 1.218120 0.366911 0.123723 0.662290 1.808464 1.555557 0.050943 1.161441 0.961088 1.469391 0.581778 0.421014 0.869182 1.964711 1.782785 0.217679 1.412311 1.228590 1.681851 0.818320 0.617489 1.120821 0.226824 0.041870 0.539030 1.644423 1.496409 1.937912 1.088438 0.861771 1.374952 0.504902 0.301816 0.831900 1.946273 1.700988 0.237333 1.351841 1.174113 1.697709 0.766188 0.601502 1.097799 0.223664 0.073707 0.490731 1.705779 1.529713 0.004900 1.114151 0.927806 1.413217 0.593263 0.370397 0.876728 0.024219 1.840075 0.345172 1.498140 1.311278 1.774455 0.911735 0.779474 1.231046 0.351370 0.170176 0.732535 1.828332 1.647912 0.151754 1.304922 1.134715 1.583698 0.773654 0.612595 1.042987 0.199634 0.036653 0.549756 1.681847 1.475587 0.005194 1.173802 0.977842 1.470305 0.643755 0.476622 0.917721 0.111850 1.936419 0.450243 1.616355 1.416777 1.915014 1.098462 0.907664 1.447783 0.570918 0.405291 0.889269 0.066991 1.881365 0.373330 1.508358 1.402579 1.870612 1.085131 0.920739 1.348392 0.568783 0.336415 0.843225 0.063446 1.926774 0.418106 1.565445 1.379520 1.897103 1.050320 0.891564 1.380927 0.530987 0.385626 0.908446 0.068664 1.943935 0.430612 1.518729 1.398232 1.924184 1.103625 0.924587 1.417433 0.610522 0.456479 0.953409 0.112059 0.013043 0.495872 1.633744 1.493163 0.038519 1.187544 1.048687 1.588579 0.748576 0.532785 1.100237 0.281535 0.104911 0.635452 1.811612 1.634030 0.184177 1.345558 1.153862 1.750039 0.857060 0.732788 1.250092 0.418042 0.246015 0.725057 1.972355 1.807991 0.351695 1.540788 1.347415 1.848165 1.067747 0.908528 1.413312 0.618180 0.467879 0.991799 0.190738 0.053795 0.507730 1.744900 1.620134 0.124619 1.318661 1.152397 1.685590 0.894836 0.688791 1.239521 0.488835 0.282246 0.831794 -0.015794 1.883123 0.431031 1.583860 1.447618 1.964025 1.125655 1.064343 1.569856 0.748855 0.603708 1.107653 0.309052 0.196774 0.696407 1.871049 1.742283 0.240318 1.473905 1.321207 1.881514 1.047815 0.924156 1.493868 0.689863 0.543896 1.026203 0.246976 0.140944 0.678125 1.870899 1.706720 0.276250 1.408196 1.319078 1.889412 1.061123 0.937583 1.451370 0.684034 0.567548 1.075578 0.293854 0.180105 0.705838 1.911360 1.764817 0.292975 1.493988 1.411105 1.895989 1.081687 1.012629 1.575334 0.718344 0.628406 1.174951 0.386415 0.230260 0.768066 -0.015753 1.886981 0.454216 1.616098 1.441778 0.077596 1.316514 1.144927 1.696140 0.867400 0.757625 1.309429 0.563210 0.364175 0.954929 0.137349 0.057751 0.597415 1.789122 1.677288 0.252684 1.417924 1.313555 1.862237 1.126315 1.015807 1.510443 0.802206 0.652057 1.184565 0.404523 0.277585 0.843687 0.148971 1.933489 0.514414 1.743011 1.592866 0.129290 1.346399 1.259419 1.817805 1.029171 0.962338 1.475532 0.708188 0.633076 1.151811 0.395581 0.307725 0.834201 0.078405 1.959228 0.466843 1.769721 1.650538 0.159441 1.402559 1.321215 1.914285 1.128095 1.014297 1.571134 0.803693 0.677208 1.246457 0.469701 0.356795 0.908733 0.149102 0.035900 0.615966 1.826481 1.708851 0.339243 1.554134 1.413247 -0.028956 1.251019 1.106816 1.704569 0.926586 0.827768 1.430366 0.655894 0.524343 1.153832 0.363573 0.234391 0.825975 0.037037 1.955590 0.487803 1.776970 1.679179 0.270247 1.494959 1.379330 1.956206 1.186819 1.071982 1.644518 0.897716 0.759160 1.349574 0.601679 0.512657 1.067152 0.367997 0.259056 0.818805 0.070970 1.979460 0.551129 1.797928 1.685198 0.237267 1.508404 1.457352 0.047420 1.261021 1.192815 1.789893 0.995526 0.930294 1.496757 0.778086 0.636312 1.222185 0.505076 0.392642 1.016934 0.236492 0.140361 0.774022 0.001411 1.961469 0.498526 1.750119 1.648169 0.240766 1.450209 1.419896 0.004281 1.237513 1.195486 1.793570 1.030159 0.946491 1.529067 0.769460 0.726220 1.269159 0.564615 0.472841 1.084479 0.322182 0.217540 0.870218 0.092806 0.039652 0.580465 1.871900 1.768958 0.330755 1.643083 1.574291 0.148815 1.382016 1.330434 1.953984 1.191904 1.113085 1.729795 0.935173 0.941506 1.487573 0.777735 0.706146 1.300602 0.552074 0.471965 1.086702 0.368313 0.238388 0.870358 0.129144 0.034415 0.647185 1.956907 1.855191 0.450494 1.695322 1.674270 0.277115 1.525710 1.462245 0.090299 1.329096 1.259635 1.870782 1.128184 1.069973 1.694787 0.953585 0.907980 1.546930 0.802555 0.747675 1.322734 0.664094 0.527920 1.163169 0.460332 0.399285 0.970040 0.217204 0.171752 0.769371 0.047350 -0.025234 0.632915 1.894302 1.830249 0.455254 1.760595 1.701533 0.321139 1.541634 1.515918 0.102674 1.367783 1.346029 1.941486 1.223287 1.213347 1.782946 1.029999 1.005092 1.692642 0.911840 0.875191 1.494140 0.757479 0.727400 1.310293 0.611635 0.559689 1.154763 0.453641 0.402989 1.051223 0.342693 0.309148 0.919084 0.199108 0.132609 0.759042 0.053229 -0.033954 0.648811 1.906240 1.894740 0.483288 1.798246 1.730147 0.369025 1.616846 1.576788 0.217080 1.494201 1.461719 0.088483 1.386902 1.325078 1.982480 1.249756 1.217589 1.872681 1.143670 1.127132 1.742603 1.001258 0.969685 1.653400 0.948140 0.903244 1.474757 0.844045 0.804740 1.381313 0.669059 0.696990 1.287624 0.590259 0.542974 1.139086 0.529408 0.444238 1.060949 0.381119 0.387330 0.982887 0.274265 0.262799 0.892622 0.182183 0.155238 0.802580 0.125716 0.062385 0.697970 -0.029110 -0.005740 0.631814 1.935506 1.905147 0.526743 1.805035 1.822539 0.427610 1.754204 1.769095 0.334244 1.671094 1.648758 0.313430 1.604455 1.580989 0.249732 1.534106 1.501925 0.141332 1.456591 1.376333 0.087064 1.395898 1.349285 -0.007846 1.309141 1.324784 1.926752 1.235223 1.257013 1.870695 1.183965 1.196890 1.833185 1.161076 1.134259 1.737981 1.066217 1.029285 1.761061 1.046404 1.003567 1.669085 1.015282 0.945700 1.628153 0.957401 0.910198 1.578015 0.892702 0.920061 1.560411 0.892643 0.883270 1.499087 0.881141 0.786754 1.465346 0.814870 0.806704 1.420951 0.745568 0.748981 1.428779 0.724569 0.722331 1.414318 0.735199 0.680304 1.412191 0.642055 0.663317 1.362918 0.692620 0.652852 1.255275 0.655029 0.616540 1.306668 0.607368 0.596378 1.278318 0.605729 0.626127 1.248672 0.605969 0.598531 1.270199 0.590247 0.604018 1.248420 0.564539 0.573991 1.243120 0.541247 0.581568 1.247013 0.548311 0.583389 1.254363 0.570054 0.592870 1.314918 0.584147 0.601170 1.285128 0.585385 0.636800 1.268157 0.564860 0.618673 1.241680 0.593206 0.649499 1.294308 0.619335 0.690828 1.290074 0.662251 0.659564 1.319465 0.684267 0.676527 1.346573 0.684074 0.749941 1.376399 0.760563 0.735778 1.409735 0.781193 0.776861 1.424608 0.803012 0.794890 1.482330 0.849249 0.820388 1.516581 0.910615 0.864461 1.540065 0.895368 0.913334 1.630286 0.950361 0.962747 1.686669 0.985439 1.020247 1.674781 0.998529 1.106931 1.784420 1.109819 1.080550 1.792617 1.141848 1.167488 1.815820 1.225904 1.216862 1.932151 1.308230 1.267897 -0.026968 1.330184 1.385176 0.022707 1.458233 1.415333 0.128552 1.487923 1.523242 0.191001 1.550003 1.584242 0.283355 1.596921 1.662782 0.308217 1.689429 1.701664 0.432683 1.765615 1.799785 0.477706 1.814969 1.847473 0.536692 1.956606 -0.125001 0.671687 0.021081 0.062099 0.778322 0.143122 0.195164 0.870404 0.217515 0.248340 0.992771 0.296311 0.393796 1.036703 0.444136 0.428455 1.144392 0.545916 0.532816 1.274635 0.638559 0.682382 1.366079 0.738438 0.791235 1.469530 0.832133 0.861591 1.597033 0.965134 0.975949 1.660906 1.074595 1.121780 1.850802 1.205711 1.200292 1.955639 1.297951 1.320764 0.075418 1.456186 1.481933 0.158684 1.566840 1.641287 0.359580 1.677476 1.730799 0.448508 1.815321 1.873655 0.540161 1.931330 1.974330 0.742536 0.063433 0.156314 0.825290 0.223991 0.306298 0.962765 0.360970 0.418863 1.127740 0.516243 0.542975 1.312005 0.652439 0.710545 1.452213 0.776568 0.871797 1.548353 0.973587 1.004549 1.725321 1.089618 1.233086 1.882229 1.280829 1.345266 0.036253 1.417172 1.451706 0.202998 1.622238 1.674924 0.340016 1.728728 1.833591 0.567298 1.946042 0.023405 0.702356 0.135275 0.153799 0.884198 0.265400 0.340889 1.099730 0.493458 0.526956 1.267239 0.676407 0.690082 1.422573 0.812500 0.926029 1.644040 1.074851 1.097114 1.811626 1.221109 1.268846 0.019885 1.418865 1.465834 0.226550 1.602283 1.642652 0.409600 1.782663 1.847764 0.612518 -0.014414 0.080272 0.793644 0.189642 0.287941 1.015956 0.430798 0.498270 1.212055 0.606553 0.678263 1.458990 0.847157 0.901708 1.629236 1.030896 1.120792 1.854770 1.260369 1.292084 0.058109 1.472251 1.530032 0.298666 1.686445 1.750885 0.465407 1.926615 -0.015762 0.736186 0.179728 0.219514 0.995121 0.367989 0.459496 1.186779 0.640597 0.690551 1.458450 0.858324 0.911511 1.699195 1.068188 1.186092 1.897316 1.337175 1.402416 0.144009 1.638297 1.673138 0.373403 1.812913 1.888979 0.630635 0.080370 0.169331 0.914815 0.273060 0.393754 1.122091 0.596144 0.640794 1.390765 0.839105 0.918214 1.680880 1.131151 1.205710 1.974811 1.393861 1.452322 0.156477 1.645144 1.718367 0.451059 1.878144 0.022469 0.716191 0.203622 0.204052 1.000934 0.419218 0.531168 1.297295 0.702318 0.799989 1.534195 0.962961 1.059623 1.864764 1.322381 1.390676 0.140300 1.535535 1.653796 0.423232 1.846167 1.958815 0.705134 0.115159 0.251430 1.006465 0.470237 0.504026 1.267250 0.734232 0.836445 1.549915 1.039694 1.136664 1.905550 1.321296 1.400727 0.208474 1.633666 1.709003 0.486386 1.940896 0.025205 0.789590 0.229116 0.395199 1.113150 0.560152 0.653681 1.459139 0.830910 0.975236 1.738577 1.210343 1.308624 0.093706 1.493739 1.620053 0.424641 1.828846 1.940485 0.729339 0.163547 0.294790 1.029106 0.522695 0.623772 1.363366 0.795679 0.991955 1.735746 1.166232 1.233433 0.033448 1.517164 1.590656 0.407889 1.837549 1.928075 0.698672 0.187906 0.288583 1.089091 0.525365 0.646727 1.419503 0.847075 1.003035 1.770682 1.222701 1.368528 0.132834 1.552702 1.702988 0.486356 1.942867 0.028321 0.834453 0.305865 0.427874 1.193367 0.646670 0.777994 1.535326 0.959127 1.141152 1.974723 1.386313 1.482039 0.241727 1.733430 1.907279 0.652190 0.113225 0.233654 1.053634 0.521015 0.606360 1.407458 0.868195 0.979596 1.802838 1.252544 1.387190 0.144685 1.620697 1.765258 0.551267 0.016634 0.102630 0.966227 0.379774 0.557760 1.339080 0.772792 0.943942 1.714448 1.227165 1.340588 0.135412 1.553794 1.733262 0.505137 0.052411 0.115242 0.903954 0.369383 0.566147 1.338694 0.822997 0.955372 1.767911 1.219397 1.351801 0.123533 1.574789 1.767438 0.582707 0.059344 0.173569 0.987297 0.434401 0.616641 1.368611 0.898977 1.018679 1.815949 1.269299 1.423987 0.244273 1.756592 1.844278 0.628834 0.156429 0.267440 1.098495 0.557657 0.757430 1.527200 1.032316 1.157667 1.941839 1.435329 1.592128 0.417339 1.857219 0.027921 0.825078 0.326257 0.472209 1.266409 0.776877 0.907550 1.713542 1.197483 1.352897 0.148954 1.643699 1.805895 0.598148 0.109639 0.271416 1.099053 0.556356 0.664165 1.505314 0.973330 1.224262 1.958351 1.490436 1.656174 0.418476 1.960327 0.146807 0.899660 0.444751 0.550436 1.400125 0.831060 1.011690 1.850969 1.328814 1.486005 0.311620 1.812294 -0.006342 0.797723 0.305173 0.491901 1.322423 0.745375 0.923548 1.782732 1.275234 1.378532 0.222379 1.713386 1.920722 0.741433 0.280929 0.401426 1.209280 0.698837 0.886341 1.726784 1.225163 1.413939 0.172159 1.726536 1.893106 0.754636 0.203236 0.351446 1.190416 0.680791 0.829406 1.684757 1.210208 1.371232 0.224484 1.699825 1.891292 0.738873 0.258642 0.425836 1.243225 0.713196 0.891190 1.771850 1.235681 1.368819 0.270358 1.784768 1.928168 0.781510 0.284144 0.430703 1.331232 0.807861 0.993486 1.852203 1.325750 1.549374 0.376307 1.889520 0.034521 0.884377 0.427788 0.583618 1.373059 0.934920 1.074386 1.964373 1.419552 1.645249 0.489767 0.008746 0.185928 1.061283 0.556624 0.715745 1.608195 1.103831 1.267216 0.164802 1.613900 1.850921 0.624698 0.161160 0.408839 1.261772 0.735470 0.975590 1.782335 1.311907 1.475716 0.390097 1.869546 0.060780 0.873934 0.410643 0.589799 1.451558 0.998661 1.152970 0.054633 1.557268 1.731872 0.575393 0.117821 0.307307 1.198887 0.683313 0.897819 1.753607 1.284857 1.473685 0.314273 1.836871 0.060820 0.932547 0.420398 0.613590 1.461860 1.038061 1.203207 0.095116 1.584547 1.810340 0.624226 0.177690 0.397754 1.253072 0.802314 0.987311 1.879162 1.342549 1.566135 0.442620 1.908917 0.137619 1.011650 0.599336 0.755517 1.642027 1.174961 1.369054 0.211942 1.782659 -0.010486 0.840251 0.357521 0.581790 1.461271 1.014049 1.200403 0.044641 1.613689 1.808581 0.690100 0.250270 0.388899 1.294231 0.842257 1.021201 1.901029 1.462877 1.641210 0.546531 0.075531 0.291167 1.142643 0.703128 0.915213 1.799433 1.361706 1.526251 0.463549 1.971569 0.185024 1.029933 0.578985 0.824751 1.713096 1.250117 1.463497 0.301505 1.881822 0.143407 0.962817 0.507734 0.729352 1.590586 1.169240 1.393909 0.249757 1.802780 0.053110 0.895331 0.464179 0.669201 1.582612 1.097231 1.355127 0.231353 1.735403 0.021720 0.880348 0.431395 0.697354 1.573165 1.060767 1.347507 0.185124 1.772265 1.983494 0.879718 0.443530 0.687541 1.535902 1.151743 1.322419 0.212153 1.745041 -0.024853 0.929578 0.461659 0.706048 1.575808 1.122374 1.345663 0.241665 1.798693 0.038133 0.893828 0.497759 0.738405 1.619233 1.230529 1.391018 0.311367 1.875986 0.111417 0.982712 0.552692 0.779545 1.673926 1.277817 1.495634 0.424964 1.933807 0.193663 1.085748 0.635034 0.877002 1.797408 1.324014 1.603040 0.515913 0.114700 0.279027 1.230954 0.738758 0.971164 1.923699 1.522824 1.758904 0.629325 0.199968 0.431971 1.357304 0.920686 1.144660 0.047634 1.638457 1.887367 0.770386 0.339803 0.608798 1.474763 1.082399 1.336813 0.240373 1.815488 0.071521 0.978055 0.575127 0.812951 1.691650 1.236419 1.523987 0.428018 -0.014053 0.227398 1.211471 0.739843 1.033454 1.889876 1.490608 1.764875 0.650358 0.197774 0.479040 1.394298 0.990877 1.266721 0.153708 1.743738 1.993903 0.889105 0.452779 0.717556 1.641719 1.258531 1.472505 0.400527 0.003181 0.277816 1.190582 0.720088 1.018145 1.947482 1.529759 1.763205 0.679772 0.305019 0.551595 1.459782 1.056328 1.376741 0.254961 1.837237 0.083779 1.033490 0.597121 0.863372 1.752800 1.369817 1.661724 0.554009 0.132249 0.412929 1.366488 0.929237 1.205521 0.153686 1.780997 0.028187 0.910073 0.518459 0.747299 1.736440 1.285832 1.584544 0.515963 0.139650 0.379555 1.267964 0.869992 1.153100 0.094361 1.717865 1.955775 0.900339 0.490824 0.754072 1.676728 1.277159 1.570274 0.491155 0.127499 0.354589 1.327580 0.971916 1.203157 0.189781 1.749254 -0.000141 0.971242 0.569275 0.834995 1.792334 1.386324 1.620367 0.641313 0.177512 0.493821 1.395372 1.027112 1.276574 0.195767 1.840052 0.118782 1.057366 0.655353 0.981627 1.889857 1.497516 1.809949 0.727076 0.311895 0.619859 1.589373 1.177776 1.446089 0.402884 -0.013138 0.323859 1.242590 0.872932 1.139811 0.103389 1.705727 0.012476 0.932654 0.580713 0.844428 1.776557 1.375650 1.683357 0.653489 0.286018 0.530346 1.477873 1.102629 1.446550 0.391220 0.013493 0.315912 1.191737 0.889652 1.135899 0.064317 1.726753 0.008311 0.973187 0.561368 0.881325 1.835182 1.452878 1.728216 0.640203 0.296506 0.611465 1.537761 1.163681 1.521594 0.455106 0.113603 0.376193 1.335690 0.990813 1.252928 0.217355 1.798201 0.130538 1.099312 0.694187 1.042508 1.990873 1.625313 1.908796 0.833102 0.534393 0.775983 1.784275 1.381831 1.684754 0.630094 0.272616 0.575688 1.559911 1.184625 1.453679 0.491431 0.104067 0.400708 1.342106 0.977889 1.261797 0.248038 1.904884 0.237792 1.209205 0.805676 1.119936 0.155727 1.752922 0.098394 1.023110 0.709066 0.956558 1.945167 1.621782 1.885544 0.851378 0.511350 0.815303 1.752479 1.417551 1.712996 0.651328 0.341725 0.648800 1.652874 1.229749 1.564655 0.595314 0.162557 0.496357 1.536686 1.115189 1.443475 0.423294 0.108662 0.395018 1.332526 0.999816 1.352353 0.328398 1.960089 0.256657 1.276205 0.950110 1.251154 0.223763 1.856947 0.198310 1.202811 0.823347 1.139257 0.137493 1.791954 0.126818 1.077613 0.742716 1.034617 0.042667 1.702855 0.035869 0.942965 0.683955 0.962192 1.957952 1.636826 1.953521 0.904062 0.576569 0.908521 1.946168 1.527121 1.835900 0.915076 0.530360 0.860954 1.848124 1.476416 1.825816 0.801278 0.498232 0.791951 1.825898 1.460369 1.801238 0.807022 0.470147 0.775520 1.782957 1.421022 1.758922 0.747391 0.412834 0.729983 1.748458 1.430447 1.754281 0.725069 0.444203 0.754125 1.805117 1.457795 1.776284 0.724624 0.428724 0.744488 1.781494 1.483810 1.771396 0.825589 0.485350 0.772930 1.812210 1.489700 1.842892 0.808972 0.497919 0.826699 1.849758 1.501581 1.863781 0.830698 0.510646 0.856199 1.880392 1.487637 1.841337 0.883565 0.587660 0.933592 1.879899 1.575694 1.912690 0.882053 0.596355 0.876449 1.942318 1.604954 1.957913 0.991402 0.632658 0.965194 -0.031486 1.680264 0.039739 1.057207 0.660079 1.072774 0.084190 1.760660 0.122642 1.146243 0.783356 1.166710 0.158916 1.820281 0.220718 1.231907 0.956518 1.285669 0.300669 1.936753 0.315132 1.335110 1.060246 1.374454 0.394758 0.082667 0.417144 1.497357 1.121455 1.497524 0.558460 0.253594 0.585079 1.609798 1.353184 1.698378 0.628590 0.358364 0.702657 1.718959 1.448521 1.778728 0.811121 0.552978 0.858398 1.901305 1.551915 1.964990 1.006942 0.659821 0.990952 0.063543 1.773494 0.063737 1.160916 0.874963 1.254235 0.227903 1.909287 0.327897 1.310953 0.994777 1.331010 0.411728 0.136015 0.418712 1.516878 1.254075 1.541807 0.597800 0.341732 0.654709 1.684819 1.408026 1.806837 0.819367 0.523512 0.857369 1.895100 1.607979 1.949425 0.987941 0.703347 1.084034 0.136539 1.830122 0.250645 1.285193 0.947170 1.289548 0.328696 0.029933 0.461597 1.469311 1.207559 1.503925 0.619432 0.268080 0.678945 1.716381 1.398922 1.858266 0.884402 0.579547 0.942855 -0.007780 1.697643 0.060832 1.147089 0.859119 1.243156 0.279683 1.948552 0.303518 1.436858 1.120717 1.478393 0.523558 0.237367 0.599745 1.706188 1.421576 1.811698 0.850440 0.556037 0.945518 -0.871745 1.728994 0.072385 1.111766 0.835570 1.223297 0.269709 0.056622 0.355706 1.422876 1.147014 1.551471 0.600627 0.344660 0.724082 1.763987 1.516159 1.882823 0.942715 0.661410 1.033320 0.094097 1.855748 0.231455 1.280646 1.044202 1.442450 0.460350 0.194810 0.625856 1.678168 1.370560 1.773190 0.847696 0.600688 1.001562 0.035016 1.824811 0.145896 1.197674 0.963152 1.364275 0.436987 0.180547 0.564604 1.641854 1.399407 1.733896 0.850418 0.609483 0.927674)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


(define (tstodd phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 2)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
    (set! x (+ x incr))))


(define (tstoddderiv x phs) 
  (do ((sum 0.0)
       (len (length phs))
       (i 0 (+ i 1))
       (j 1 (+ j 2)))
      ((= i len) sum)
    (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i)))))))))


(define* (tstall phs phs1)
  (if (real? phs) (set! phs phs1))
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* j x) (* pi (float-vector-ref phs k)))))))
    (set! x (+ x incr))))

(define (tstallf mult phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (if (= k (- len 1))
			   (* mult (sin (+ (* j x) (* pi (float-vector-ref phs k)))))
			   (sin (+ (* j x) (* pi (phs k))))))))
    (set! x (+ x incr))))

(define (tsteven phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (float-vector-ref phs k)))))))
    (set! x (+ x incr))))

(define (tstprime phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* (int-vector-ref primes k) x) (* pi (float-vector-ref phs k)))))))
    (set! x (+ x incr))))

(define (tstallderiv x phs) 
  (do ((sum 0.0)
       (len (length phs))
       (i 0 (+ i 1))
       (j 1 (+ j 1)))
      ((= i len) sum)
    (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i)))))))))


(define (get-best choice n)
  (let ((func (lambda (val)
		(and (vector? val)
		     (= (val 0) n)
		     (let ((a-val (val 1))
			   (a-len (length val))
			   (a-data (val 2)))
		       (do ((k 3 (+ 1 k)))
			   ((= k a-len))
			 (if (and (real? (val k))
				  (< (val k) a-val))
			     (begin
			       (set! a-val (val k))
			       (set! a-data (val (+ k 1))))))
		       (list a-val a-data)))))
	(vect (case choice
		((:all) noid-min-peak-phases)
		((:odd) nodd-min-peak-phases)
		((:even) neven-min-peak-phases)
		(else primoid-min-peak-phases))))
    (do ((len (length vect))
	 (result #f)
	 (i 0 (+ i 1)))
	((or (= i len) result) 
	 result)
      (set! result (func (vect i))))))

(define (sum-sines v i x len phs)
  (do ((val 0.0)
       (k 0 (+ k 1))
       (j 1 (+ j 1)))
      ((= k len)
       (set! (v i) val))   
    (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
  

(define (showall len)
  (let ((phs-data (get-best :all len)))
    (do ((phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* pi 2000) 2))))
	 (incr 0.001)
	 (x 0.0)
	 (i 0 (+ i 1)))
	((> x (* 2 pi))
	 (new-sound)
	 (float-vector->channel v)
	 (set! (y-bounds) (list (- mx) mx)))
      (sum-sines v i x len phs)
      (set! x (+ x incr)))))

(define (showphases mx phs)
  (do ((v (make-float-vector (ceiling (+ (* pi 2000) 2))))
       (incr 0.001)
       (len (length phs))
       (x 0.0)
       (i 0 (+ i 1)))
      ((> x (* 2 pi))
       (new-sound)
       (float-vector->channel v)
       (set! (y-bounds) (list (- mx) mx)))
    (sum-sines v i x len phs)
    (set! x (+ x incr))))

(define (showodd len)
  (let ((phs-data (get-best :odd len)))
    (do ((phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* pi 2000) 2))))
	 (incr 0.001)
	 (x 0.0)
	 (i 0 (+ i 1)))
	((> x (* 2 pi))
	 (new-sound)
	 (float-vector->channel v)
	 (set! (y-bounds) (list (- mx) mx)))
      (sum-sines v i x len phs)
      (set! x (+ x incr)))))

(define (showdiff n1 n2)
  (let ((len (length n1)))
    (do ((data (make-float-vector len))
	 (i 0 (+ i 1)))
	((= i len)
	 (new-sound)
	 (float-vector->channel data))
      (set! (data i) (modulo (- (n1 i) (n2 i)) 2.0))
      (if (> (data i) 1.0)
	  (set! (data i) (- (data i) 2.0))
	  (if (< (data i) -1)
	      (set! (data i) (+ (data i) 2.0)))))))

(define (differ snd) 
  (let ((x 0.0))
    (map-channel 
     (lambda (y) 
       (let ((res (- y x)))
	 (set! x y) 
	 res))
     0 #f snd 0)))    


(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results ()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

;   (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #r(0.0 0.1 0.2 0.3))) #r(0.0 0.1 0.2 0.3))
;;; 3.49630991 #r(0.0 1.1 0.2 1.3)
;;; 3.49630680 #r(0.0 1.9 1.8 1.7)
;;; 3.49630979 #r(0.0 0.9 1.8 0.7)



(define (canonicalize-one i p)
  (let ((data (get-best :all i)))
    (let ((old-peak (car data))
	  (old-phases (cadr data)))
      (let ((phases (copy old-phases)))
	(if (< (phases 2) -1.0)
	    (set! (phases 2) (+ (phases 2) 2.0))
	    (if (> (phases 2) 1.0)
		(set! (phases 2) (- (phases 2) 2.0))))
	(if (< (phases 2) 0.0)
	    (do ((j 1 (+ j 1)))
		((>= j i))
	      (set! (phases j) (modulo (- 2.0 (phases j)) 2.0))))
	(if (< (phases 1) -1.0)
	    (set! (phases 1) (+ (phases 1) 2.0))
	    (if (> (phases 1) 1.0)
		(set! (phases 1) (- (phases 1) 2.0))))
	(if (< (phases 1) 0.0) ; this is an "even" harmonic
	    (do ((j 1 (+ j 2)))
		((>= j i))
	      (set! (phases j) (modulo (+ 1.0 (phases j)) 2.0))))
	(do ((j 1 (+ j 1)))
	    ((= j i))
	  (if (< (phases j) -1.0)
	      (set! (phases j) (+ (phases j) 2.0))
	      (if (> (phases j) 1.0)
		  (set! (phases j) (- (phases j) 2.0)))))
	(let ((new-peak-info (tstall phases)))
	  (let ((new-peak (car new-peak-info)))
	    (if (> (abs (- new-peak old-peak)) .001)
		(format *stderr* "oops: ~D: ~A ~A~%" i old-peak new-peak))
	    (format p "(vector ~D ~,6F #r(" i new-peak))
	  (do ((k 1 (+ k 1)))
	      ((= k i))
	    (format p "~,6F " (phases (- k 1))))
	  (format p "~,6F))~%  ;; loc: ~F~%~%" (phases (- i 1)) (/ (cadr new-peak-info) pi)))))))

(define (canonicalize)
  ;; this is slow because we call tstall on each one 
  (call-with-output-file "pp4.scm" 
    (lambda (p)
      (format p "(define noid-min-peak-phases (vector~%~%(vector 1  1.0    #r(0))~%(vector 2  1.76   #r(0 0))~%~%")
      (do ((i 3 (+ i 1)))
	  ((> i 128))
	(format *stderr* "~D " i)
	(canonicalize-one i p))
      (format p "))~%"))))

(if (provided? 'snd) (set! (print-length) 123123) (set! (*s7* 'print-length) 123123))

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadar other-mins))
	    (pk3 (cadadr other-mins))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (caar other-mins) (car data))) .001)
		(> (abs (- (caadr other-mins) (car data))) .001)
		(> (abs (- (caaddr other-mins) (car data))) .001))
	    (format () "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format () "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (data 0)
		  (phases 0)
		  (phases 1)
		  (phases 2)
		  (phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42
;; 1 Apr 5405.890
;; 1 May 5138.261
;; 1 Jun 5061.829
;; 1 Jul 4669.101
;; 1 Aug 4633.454
;; 1 Sep 4616.517
;; 1 Oct 4592.994
;; 1 Nov 4560.903
;; 1 Dec 4541.710
;; (10)
;; 1 Jan 4360.644
;; 1 Feb 4292.451
;; 1 Mar 4280.782
;; 1 Apr 4272.964
;; 1 May 4267.719
;; 1 Jun 4261.356
;; 1 Jul 4244.312, sqrts: 82 74 0 0
;; 1 Aug 4218.456, sqrts: 82 74 0 0
;; 1 Sep 4209.464, sqrts: 85 74 0 0   (9.5330)
;; 1 Oct 4202.347, sqrts: 89 75 0 0   (6.9438)
;; 1 Nov 4198.764, sqrts: 94 78 0 0   (5.5196)
;; 1 Dec 4196.395, sqrts: 98 84 0 0   (4.1226)
;; (11)
;; 1 Jan 4194.669, sqrts: 101 91 0 0  (2.9465)
;; 1 Feb 4194.106, sqrts: 105 91 0 0  (2.5054)
;; 1 Mar 4193.048, sqrts: 110 95 0 0  (1.6862)
;; 1 Apr 4188.373, sqrts: 114 104 0 0 (0.8505)
;; 1 May 4186.610, sqrts: 114 105 0 0 (0.6439)
;; 1 Jun 4186.498, sqrts: 115 105 0 0 (0.5422)
;; 1 Nov 4186.465, sqrts: 116 105 0 0 (0.5095)
;; 1 Dec 4186.315, sqrts: 117 108 0 0 (0.4198) 
;; (12)
;; 1 Jan 4185.693, sqrts: 118 112 0 0 (0.3225)
;; 1 Feb 4185.458, sqrts: 119 113 0 0 (0.2534)
;; 1 Mar 4185.289, sqrts: 119 115 0 0 (0.1710)
;; 1 Apr 4185.029, sqrts: 120 115 0 0 (0.1464)
;; 1 Nov 4184.742, sqrts: 120 115 0 0 (0.1429)
;; 1 Dec 4184.727, sqrts: 121 115 0 0 (0.1349)
;; (13)
;; 1 Feb 4184.520, sqrts: 122 115 0 0 (0.1159)
;; 1 Jun 4184.160, sqrts: 122 118 0 0 (0.0926)
;; 1 Aug 4183.948, sqrts: 122 118 0 0 (0.0440)
;; 1 Sep 4183.825, sqrts: 122 119 0 0 (0.0382)
;; 1 Oct 4183.673, sqrts: 122 119 0 0 (0.0382)
;; 1 Nov 4183.616, sqrts: 122 119 0 0 (0.0382)
;; 1 Dec 4183.180, sqrts: 122 120 0 0 (0.0361)
;; (14)
;; 1 Jan 4183.004, sqrts: 122 120 0 0 (0.0346)
;; (15)
;; 1 Jan 4158.938
;; (16)
;; 1 Jan 4151.620
;; (17)
;; 1-Oct 4150.037
;; (18)
;; 1-Jan 4149.99
;; (19)
;; 1-Jan 4139.71

;    all 0.4860 (20) to 0.4986 (125), dist: 0.0000, 15.0910
;    odd 0.4820 (11) to 0.5000 (112), dist: 0.0000, 9.0892
;    even 0.5067 (120) to 0.5242 (22), dist: 55.3350, 0.0000
;    prime 0.5444 (24) to 0.5539 (67), dist: 224.6387, 0.0000

#|
10-Mar-19:
;all peaks... Sun 10-Mar-2019 08:17
(0.00148279395297779 4)
;odd peaks... Sun 10-Mar-2019 08:18
(0.0016873156290522218 125)
;even peaks... Sun 10-Mar-2019 08:19
(0.0014671696746928475 4)
;prime peaks... Sun 10-Mar-2019 08:20
(0.0019755826091483186 2048)
;all done! Sun 10-Mar-2019 08:21

;(test-all-phases #f) in test-phases.scm
;repl test-phases.scm

;;; 31-May-10: 214
;;;  1-Mar-11: 120
;;;  6-Mar-12:  28
;;;  3-Feb-13:  41
;;; 19-Jul-14:  22
;;;  9-Jul-15:  18
;;;  9-Nov-16:  22
;;; 20-Jul-17:   6
;;; 24-Jun-18:   6
;;; 16-Jan-19:   4

232.878u 0.003s 3:52.88 99.9%	0+0k 0+0io 0pf+0w
|#

;;; gad161: clean-up-evens
;;; t139.scm: show-circle (Motif-based)
;;; t283.scm: poly stuff
;;; tmp26.scm sqrt graph
;;; t404.scm for averages, graphed via graph-averages.scm
;;; t405.scm for function searcher
