package OpenInteract2::SQLInstall::Base;

# $Id: Base.pm,v 1.4 2003/10/20 03:05:53 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );
use OpenInteract2::Context   qw( CTX );
use OpenInteract2::Exception qw( oi_error );

# NOTE: No data needs to be migrated since the sessions are transient
# and object keys are recreated as we go

sub get_structure_set {
    my ( $self ) = @_;
    my $session_ds = CTX->lookup_session_config->{datasource};
    return [ "datasource: $session_ds", 'system' ];
}

sub get_structure_file {
    my ( $class, $set, $type ) = @_;
    if ( $set =~ /^datasource/ ) {
        return 'sessions_oracle.sql'       if ( $type eq 'Oracle' );
        return 'sessions_interbase.sql'    if ( $type eq 'InterBase' );
        return 'sessions.sql';
    }
    elsif ( $set eq 'system' ) {
        return 'object_keys_oracle.sql'    if ( $type eq 'Oracle' );
        return 'object_keys_interbase.sql' if ( $type eq 'InterBase' );
        return 'object_keys.sql';
    }
    else {
        oi_error "Invalid set '$set' passed to installer";
    }
}

sub get_security_file {
    return 'install_security.dat';
}

1;
