package SBOM::CycloneDX::Vulnerability::Affect;

use 5.010001;
use strict;
use warnings;
use utf8;

use SBOM::CycloneDX::List;

use Types::Standard qw(Str InstanceOf);
use Types::TypeTiny qw(ArrayLike);

use Moo;
use namespace::autoclean;

extends 'SBOM::CycloneDX::Base';

has ref => (is => 'rw', isa => Str, required => 1);

has versions => (
    is      => 'rw',
    isa     => ArrayLike [InstanceOf ['SBOM::CycloneDX::Version']],
    default => sub { SBOM::CycloneDX::List->new }
);

sub TO_JSON {

    my $self = shift;

    my $json = {ref => $self->ref};

    $json->{versions} = $self->versions if @{$self->versions};

    return $json;

}

1;

=encoding utf-8

=head1 NAME

SBOM::CycloneDX::Vulnerability::Affect - Vulnerability Affect object

=head1 SYNOPSIS

    SBOM::CycloneDX::Vulnerability::Affect->new();


=head1 DESCRIPTION

L<SBOM::CycloneDX::Vulnerability::Affect> provides the vulnerability affect object.

=head2 METHODS

L<SBOM::CycloneDX::Vulnerability::Affect> inherits all methods from L<SBOM::CycloneDX::Base>
and implements the following new ones.

=over

=item SBOM::CycloneDX::Vulnerability::Affect->new( %PARAMS )

Properties:

=over

=item C<ref>, References a component or service by the objects bom-ref

=item C<versions>, Zero or more individual versions or range of versions.

=back

=item $affect->ref

=item $affect->versions

=back

=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://github.com/giterlizzi/perl-SBOM-CycloneDX/issues>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/giterlizzi/perl-SBOM-CycloneDX>

    git clone https://github.com/giterlizzi/perl-SBOM-CycloneDX.git


=head1 AUTHOR

=over 4

=item * Giuseppe Di Terlizzi <gdt@cpan.org>

=back


=head1 LICENSE AND COPYRIGHT

This software is copyright (c) 2025 by Giuseppe Di Terlizzi.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

