######################################################################
#
# 5038_cp00930_by_keis83_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xA1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\x40\x40",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],

        ["\xA1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\x43\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],

        ["\xA1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\x43\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],

        ["\xA1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\x42\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],

        ["\xA1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\x42\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],

        ["\xA1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\x43\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],

        ["\xA1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\x42\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],

        ["\xA1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\x42\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],

        ["\xA1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\x42\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],

        ["\xA1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\x42\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],

        ["\xA1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\x43\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],

        ["\xA1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBF"],
        ["\x43\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],

        ["\xA1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\x44\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],

        ["\xA1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\x42\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],

        ["\xA1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\x44\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],

        ["\xA1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\x44\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],

        ["\xA1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA1"],
        ["\x42\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],

        ["\xA1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\x42\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],

        ["\xA1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xDC"],
        ["\x43\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],

        ["\xA1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xDD"],
        ["\x43\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],

        ["\xA1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\x44\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],

        ["\xA1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xDD"],
        ["\x44\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],

        ["\xA1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\x44\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],

        ["\xA1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\x44\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],

        ["\xA1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\x44\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],

        ["\xA1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\x44\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],

        ["\xA1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\x44\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],

        ["\xA1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\x43\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],

        ["\xA1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xDD\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],

        ["\xA1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\x44\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],

        ["\xA1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\x42\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],

        ["\xA1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE0"],
        ["\x43\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],

        ["\xA1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA1"],
        ["\x43\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],

        ["\xA1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xDF\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],

        ["\xA1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\x42\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],

        ["\xA1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x7F"],
        ["\x44\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],

        ["\xA1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\x44\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],

        ["\xA1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\x44\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],

        ["\xA1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\x44\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],

        ["\xA1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\x44\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],

        ["\xA1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\x44\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],

        ["\xA1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\x42\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],

        ["\xA1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\x42\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],

        ["\xA1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\x44\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],

        ["\xA1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\x44\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],

        ["\xA1\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\x44\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],

        ["\xA1\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\x44\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],

        ["\xA1\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC0"],
        ["\x42\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],

        ["\xA1\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD0"],
        ["\x42\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],

        ["\xA1\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\x44\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],

        ["\xA1\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\x44\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],

        ["\xA1\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\x44\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],

        ["\xA1\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\x44\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],

        ["\xA1\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\x43\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],

        ["\xA1\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\x43\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],

        ["\xA1\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\x44\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],

        ["\xA1\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\x44\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],

        ["\xA1\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\x44\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],

        ["\xA1\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\x44\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],

        ["\xA1\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\x42\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],

        ["\xA1\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],

        ["\xA1\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\x44\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],

        ["\xA1\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\x44\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],

        ["\xA1\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\x44\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],

        ["\xA1\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\x42\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],

        ["\xA1\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\x44\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],

        ["\xA1\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\x42\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],

        ["\xA1\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\x42\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],

        ["\xA1\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\x44\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],

        ["\xA1\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\x44\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],

        ["\xA1\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\x44\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],

        ["\xA1\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\x44\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],

        ["\xA1\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\x44\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],

        ["\xA1\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\x44\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],

        ["\xA1\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\x44\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],

        ["\xA1\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xEE"],
        ["\x44\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],

        ["\xA1\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xEF"],
        ["\x44\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],

        ["\xA1\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\x44\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],

        ["\xA1\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\x42\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],

        ["\xA1\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE0"],
        ["\x42\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],

        ["\xA1\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\x43\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],

        ["\xA1\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\x42\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],

        ["\xA1\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\x42\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],

        ["\xA1\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\x42\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],

        ["\xA1\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\x42\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],

        ["\xA1\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\x42\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],

        ["\xA1\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\x42\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],

        ["\xA1\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\x44\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],

        ["\xA1\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE5"],
        ["\x44\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],

        ["\xA1\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE6"],
        ["\x44\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],

        ["\xA1\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE0"],
        ["\x44\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],

        ["\xA1\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE1"],
        ["\x44\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],

        ["\xA1\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE4"],
        ["\x44\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],

        ["\xA1\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE7"],
        ["\x44\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],

        ["\xA2\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE8"],
        ["\x44\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],

        ["\xA2\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE9"],
        ["\x44\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],

        ["\xA2\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xEA"],
        ["\x44\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],

        ["\xA2\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE2"],
        ["\x44\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],

        ["\xA2\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xE3"],
        ["\x44\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],

        ["\xA2\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xEB"],
        ["\x44\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],

        ["\xA2\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xEC"],
        ["\x44\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],

        ["\xA2\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\x44\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],

        ["\xA2\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\x44\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],

        ["\xA2\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xF0"],
        ["\x44\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],

        ["\xA2\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xF1"],
        ["\x44\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],

        ["\xA2\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xF2"],
        ["\x44\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],

        ["\xA2\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xF3"],
        ["\x44\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],

        ["\xA2\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x44\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],

        ["\xA2\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\x43\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],

        ["\xA2\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\x43\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],

        ["\xA2\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\x43\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],

        ["\xA2\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\x43\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],

        ["\xA2\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\x43\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],

        ["\xA2\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\x43\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],

        ["\xA2\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\x43\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],

        ["\xA2\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\x43\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],

        ["\xA2\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\x43\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],

        ["\xA2\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\x43\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],

        ["\xA2\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\x42\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCC"],

        ["\xA2\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\x43\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],

        ["\xA2\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\x43\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],

        ["\xA2\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\x43\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],

        ["\xA2\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\x43\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],

        ["\xA2\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\x43\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],

        ["\xA2\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\x43\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],

        ["\xA2\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\x43\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],

        ["\xA2\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\x43\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],

        ["\xA2\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\x43\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],

        ["\xA2\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\x43\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],

        ["\xA2\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\x43\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],

        ["\xA2\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\x43\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],

        ["\xA2\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\x43\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],

        ["\xA2\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\x43\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],

        ["\xA2\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\x43\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],

        ["\xA2\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\x43\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],

        ["\xA2\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\x44\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],

        ["\xA2\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\x43\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],

        ["\xA2\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\x43\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],

        ["\xA2\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\x43\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],

        ["\xA2\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\x43\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],

        ["\xA2\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\x43\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],

        ["\xA2\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\x43\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],

        ["\xA2\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\x43\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],

        ["\xA2\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\x43\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],

        ["\xA2\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\x43\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],

        ["\xA2\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\x43\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],

        ["\xA2\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\x43\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],

        ["\xA3\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF0"],
        ["\x42\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],

        ["\xA3\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF1"],
        ["\x42\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],

        ["\xA3\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF2"],
        ["\x42\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],

        ["\xA3\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF3"],
        ["\x42\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],

        ["\xA3\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF4"],
        ["\x42\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],

        ["\xA3\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\x42\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],

        ["\xA3\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF6"],
        ["\x42\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],

        ["\xA3\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF7"],
        ["\x42\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],

        ["\xA3\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF8"],
        ["\x42\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],

        ["\xA3\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xF9"],
        ["\x42\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],

        ["\xA3\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC1"],
        ["\x42\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],

        ["\xA3\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC2"],
        ["\x42\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],

        ["\xA3\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC3"],
        ["\x42\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],

        ["\xA3\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC4"],
        ["\x42\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],

        ["\xA3\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC5"],
        ["\x42\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],

        ["\xA3\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC6"],
        ["\x42\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],

        ["\xA3\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\x42\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],

        ["\xA3\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC8"],
        ["\x42\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],

        ["\xA3\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xC9"],
        ["\x42\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],

        ["\xA3\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD1"],
        ["\x42\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],

        ["\xA3\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD2"],
        ["\x42\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],

        ["\xA3\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD3"],
        ["\x42\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],

        ["\xA3\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD4"],
        ["\x42\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],

        ["\xA3\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD5"],
        ["\x42\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],

        ["\xA3\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD6"],
        ["\x42\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],

        ["\xA3\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD7"],
        ["\x42\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],

        ["\xA3\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD8"],
        ["\x42\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],

        ["\xA3\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xD9"],
        ["\x42\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],

        ["\xA3\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE2"],
        ["\x42\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],

        ["\xA3\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE3"],
        ["\x42\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],

        ["\xA3\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE4"],
        ["\x42\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],

        ["\xA3\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE5"],
        ["\x42\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],

        ["\xA3\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE6"],
        ["\x42\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],

        ["\xA3\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\x42\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],

        ["\xA3\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\x42\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],

        ["\xA3\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\x42\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],

        ["\xA3\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x81"],
        ["\x42\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],

        ["\xA3\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x82"],
        ["\x42\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],

        ["\xA3\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x83"],
        ["\x42\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],

        ["\xA3\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x84"],
        ["\x42\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],

        ["\xA3\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x85"],
        ["\x42\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],

        ["\xA3\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x86"],
        ["\x42\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],

        ["\xA3\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x87"],
        ["\x42\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],

        ["\xA3\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x88"],
        ["\x42\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],

        ["\xA3\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x89"],
        ["\x42\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],

        ["\xA3\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],
        ["\x42\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],

        ["\xA3\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],
        ["\x42\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],

        ["\xA3\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],
        ["\x42\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],

        ["\xA3\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],
        ["\x42\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],

        ["\xA3\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],
        ["\x42\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],

        ["\xA3\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],
        ["\x42\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],

        ["\xA3\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],
        ["\x42\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],

        ["\xA3\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x98"],
        ["\x42\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],

        ["\xA3\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\x99"],
        ["\x42\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],

        ["\xA3\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA2"],
        ["\x42\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],

        ["\xA3\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA3"],
        ["\x42\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],

        ["\xA3\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA4"],
        ["\x42\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],

        ["\xA3\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA5"],
        ["\x42\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],

        ["\xA3\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA6"],
        ["\x42\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],

        ["\xA3\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\x42\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],

        ["\xA3\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\x42\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],

        ["\xA3\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x42\xA9"],
        ["\x42\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],

        ["\xA4\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\x44\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],

        ["\xA4\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x81"],
        ["\x44\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],

        ["\xA4\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\x44\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],

        ["\xA4\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x82"],
        ["\x44\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],

        ["\xA4\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\x44\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],

        ["\xA4\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x83"],
        ["\x44\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],

        ["\xA4\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\x44\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],

        ["\xA4\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x84"],
        ["\x44\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],

        ["\xA4\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\x44\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],

        ["\xA4\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x85"],
        ["\x44\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],

        ["\xA4\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x86"],
        ["\x44\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],

        ["\xA4\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC0"],
        ["\x44\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],

        ["\xA4\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x87"],
        ["\x44\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],

        ["\xA4\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC1"],
        ["\x44\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],

        ["\xA4\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x88"],
        ["\x44\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],

        ["\xA4\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC2"],
        ["\x44\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],

        ["\xA4\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x89"],
        ["\x44\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],

        ["\xA4\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC3"],
        ["\x44\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],

        ["\xA4\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x8A"],
        ["\x44\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],

        ["\xA4\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC4"],
        ["\x44\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],

        ["\xA4\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x8C"],
        ["\x44\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],

        ["\xA4\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC5"],
        ["\x44\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],

        ["\xA4\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x8D"],
        ["\x44\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],

        ["\xA4\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC6"],
        ["\x44\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],

        ["\xA4\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x8E"],
        ["\x44\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],

        ["\xA4\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC7"],
        ["\x44\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],

        ["\xA4\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x8F"],
        ["\x44\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],

        ["\xA4\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC8"],
        ["\x44\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],

        ["\xA4\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x90"],
        ["\x44\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],

        ["\xA4\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xC9"],
        ["\x44\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],

        ["\xA4\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x91"],
        ["\x44\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],

        ["\xA4\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCA"],
        ["\x44\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],

        ["\xA4\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x92"],
        ["\x44\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],

        ["\xA4\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCB"],
        ["\x44\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],

        ["\xA4\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\x44\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],

        ["\xA4\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x93"],
        ["\x44\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],

        ["\xA4\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCC"],
        ["\x44\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],

        ["\xA4\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x94"],
        ["\x44\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],

        ["\xA4\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCD"],
        ["\x44\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],

        ["\xA4\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x95"],
        ["\x44\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],

        ["\xA4\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCE"],
        ["\x44\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],

        ["\xA4\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x96"],
        ["\x44\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],

        ["\xA4\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x97"],
        ["\x44\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],

        ["\xA4\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x98"],
        ["\x44\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],

        ["\xA4\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x99"],
        ["\x44\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],

        ["\xA4\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x9A"],
        ["\x44\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],

        ["\xA4\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x9D"],
        ["\x44\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],

        ["\xA4\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xCF"],
        ["\x44\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],

        ["\xA4\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD5"],
        ["\x44\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],

        ["\xA4\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x9E"],
        ["\x44\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],

        ["\xA4\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD0"],
        ["\x44\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],

        ["\xA4\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD6"],
        ["\x44\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],

        ["\xA4\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x9F"],
        ["\x44\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],

        ["\xA4\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD1"],
        ["\x44\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],

        ["\xA4\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD7"],
        ["\x44\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],

        ["\xA4\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA2"],
        ["\x44\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],

        ["\xA4\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\x44\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],

        ["\xA4\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD8"],
        ["\x44\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],

        ["\xA4\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA3"],
        ["\x44\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],

        ["\xA4\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD3"],
        ["\x44\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],

        ["\xA4\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xD9"],
        ["\x44\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],

        ["\xA4\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\x44\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],

        ["\xA4\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA5"],
        ["\x44\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA6"],
        ["\x44\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],

        ["\xA4\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA7"],
        ["\x44\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],

        ["\xA4\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA8"],
        ["\x44\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],

        ["\xA4\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\x44\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],

        ["\xA4\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xA9"],
        ["\x44\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],

        ["\xA4\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\x44\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],

        ["\xA4\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xAA"],
        ["\x44\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],

        ["\xA4\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\x44\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],

        ["\xA4\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\x44\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],

        ["\xA4\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xAD"],
        ["\x44\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],

        ["\xA4\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xAE"],
        ["\x44\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],

        ["\xA4\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xAF"],
        ["\x44\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],

        ["\xA4\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xBA"],
        ["\x44\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],

        ["\xA4\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xBB"],
        ["\x44\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],

        ["\xA4\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\x44\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],

        ["\xA4\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xBC"],
        ["\x44\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],

        ["\xA4\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xDA"],
        ["\x44\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],

        ["\xA4\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xDB"],
        ["\x44\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],

        ["\xA4\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\x44\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],

        ["\xA4\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\xBD"],
        ["\x44\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],

        ["\xA5\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\x43\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],

        ["\xA5\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x81"],
        ["\x43\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],

        ["\xA5\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\x43\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],

        ["\xA5\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x82"],
        ["\x43\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],

        ["\xA5\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\x43\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],

        ["\xA5\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x83"],
        ["\x43\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],

        ["\xA5\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\x43\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],

        ["\xA5\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x84"],
        ["\x43\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],

        ["\xA5\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\x43\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],

        ["\xA5\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x85"],
        ["\x43\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],

        ["\xA5\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x86"],
        ["\x43\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],

        ["\xA5\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC0"],
        ["\x43\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],

        ["\xA5\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x87"],
        ["\x43\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],

        ["\xA5\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC1"],
        ["\x43\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],

        ["\xA5\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x88"],
        ["\x43\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],

        ["\xA5\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC2"],
        ["\x43\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],

        ["\xA5\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x89"],
        ["\x43\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],

        ["\xA5\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC3"],
        ["\x43\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],

        ["\xA5\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x8A"],
        ["\x43\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],

        ["\xA5\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC4"],
        ["\x43\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],

        ["\xA5\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x8C"],
        ["\x43\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],

        ["\xA5\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC5"],
        ["\x43\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],

        ["\xA5\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x8D"],
        ["\x43\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],

        ["\xA5\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC6"],
        ["\x43\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],

        ["\xA5\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x8E"],
        ["\x43\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],

        ["\xA5\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC7"],
        ["\x43\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],

        ["\xA5\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x8F"],
        ["\x43\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],

        ["\xA5\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC8"],
        ["\x43\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],

        ["\xA5\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x90"],
        ["\x43\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],

        ["\xA5\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xC9"],
        ["\x43\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],

        ["\xA5\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x91"],
        ["\x43\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],

        ["\xA5\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCA"],
        ["\x43\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],

        ["\xA5\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x92"],
        ["\x43\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],

        ["\xA5\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCB"],
        ["\x43\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],

        ["\xA5\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\x43\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],

        ["\xA5\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x93"],
        ["\x43\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],

        ["\xA5\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCC"],
        ["\x43\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],

        ["\xA5\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x94"],
        ["\x43\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],

        ["\xA5\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCD"],
        ["\x43\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],

        ["\xA5\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x95"],
        ["\x43\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],

        ["\xA5\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCE"],
        ["\x43\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],

        ["\xA5\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x96"],
        ["\x43\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA5\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x97"],
        ["\x43\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],

        ["\xA5\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x98"],
        ["\x43\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],

        ["\xA5\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x99"],
        ["\x43\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],

        ["\xA5\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x9A"],
        ["\x43\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],

        ["\xA5\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x9D"],
        ["\x43\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],

        ["\xA5\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\x43\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD5"],
        ["\x43\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\xA5\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x9E"],
        ["\x43\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\x43\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\xA5\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD6"],
        ["\x43\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x9F"],
        ["\x43\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA5\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD1"],
        ["\x43\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],

        ["\xA5\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD7"],
        ["\x43\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],

        ["\xA5\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA2"],
        ["\x43\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],

        ["\xA5\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD2"],
        ["\x43\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],

        ["\xA5\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD8"],
        ["\x43\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],

        ["\xA5\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA3"],
        ["\x43\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],

        ["\xA5\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\x43\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\xA5\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\x43\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA4"],
        ["\x43\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],

        ["\xA5\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA5"],
        ["\x43\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],

        ["\xA5\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA6"],
        ["\x43\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],

        ["\xA5\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA7"],
        ["\x43\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA8"],
        ["\x43\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\xA5\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\x43\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],

        ["\xA5\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xA9"],
        ["\x43\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],

        ["\xA5\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\x43\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],

        ["\xA5\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xAA"],
        ["\x43\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],

        ["\xA5\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\x43\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xAC"],
        ["\x43\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\xA5\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xAD"],
        ["\x43\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],

        ["\xA5\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xAE"],
        ["\x43\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],

        ["\xA5\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xAF"],
        ["\x43\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],

        ["\xA5\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBA"],
        ["\x43\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],

        ["\xA5\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBB"],
        ["\x43\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],

        ["\xA5\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\x43\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBC"],
        ["\x43\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xDA"],
        ["\x43\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA5\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xDB"],
        ["\x43\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],

        ["\xA5\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\x43\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],

        ["\xA5\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xBD"],
        ["\x43\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],

        ["\xA5\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xD4"],
        ["\x43\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],

        ["\xA5\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\x43\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],

        ["\xA5\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\x43\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],

        ["\xA6\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\x41\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],

        ["\xA6\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\x41\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],

        ["\xA6\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\x41\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],

        ["\xA6\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\x41\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],

        ["\xA6\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\x41\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],

        ["\xA6\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\x41\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],

        ["\xA6\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\x41\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],

        ["\xA6\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\x41\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],

        ["\xA6\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\x41\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],

        ["\xA6\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\x41\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],

        ["\xA6\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\x41\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],

        ["\xA6\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\x41\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],

        ["\xA6\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\x41\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],

        ["\xA6\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\x41\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],

        ["\xA6\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\x41\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],

        ["\xA6\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\x41\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],

        ["\xA6\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\x41\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],

        ["\xA6\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\x41\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],

        ["\xA6\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\x41\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],

        ["\xA6\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\x41\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],

        ["\xA6\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\x41\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],

        ["\xA6\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\x41\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],

        ["\xA6\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\x41\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],

        ["\xA6\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\x41\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],

        ["\xA6\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\x41\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],

        ["\xA6\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\x41\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],

        ["\xA6\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\x41\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],

        ["\xA6\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\x41\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],

        ["\xA6\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\x41\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],

        ["\xA6\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\x41\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],

        ["\xA6\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\x41\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],

        ["\xA6\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\x41\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],

        ["\xA6\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\x41\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],

        ["\xA6\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\x41\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],

        ["\xA6\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\x41\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],

        ["\xA6\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\x41\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],

        ["\xA6\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\x41\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],

        ["\xA6\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\x41\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],

        ["\xA6\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\x41\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\xA6\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\x41\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],

        ["\xA6\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\x41\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],

        ["\xA6\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\x41\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],

        ["\xA6\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\x41\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],

        ["\xA6\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\x41\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],

        ["\xA6\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\x41\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],

        ["\xA6\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\x41\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],

        ["\xA6\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\x41\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],

        ["\xA6\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\x41\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],

        ["\xA7\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC0"],
        ["\x41\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],

        ["\xA7\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC1"],
        ["\x41\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],

        ["\xA7\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC2"],
        ["\x41\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],

        ["\xA7\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC3"],
        ["\x41\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],

        ["\xA7\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC4"],
        ["\x41\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],

        ["\xA7\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC5"],
        ["\x41\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],

        ["\xA7\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC6"],
        ["\x41\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],

        ["\xA7\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC7"],
        ["\x41\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],

        ["\xA7\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC8"],
        ["\x41\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],

        ["\xA7\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xC9"],
        ["\x41\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],

        ["\xA7\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCA"],
        ["\x41\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],

        ["\xA7\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCB"],
        ["\x41\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],

        ["\xA7\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCC"],
        ["\x41\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],

        ["\xA7\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCD"],
        ["\x41\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],

        ["\xA7\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCE"],
        ["\x41\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],

        ["\xA7\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\x41\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],

        ["\xA7\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD0"],
        ["\x41\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],

        ["\xA7\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD1"],
        ["\x41\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],

        ["\xA7\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD2"],
        ["\x41\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],

        ["\xA7\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD3"],
        ["\x41\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],

        ["\xA7\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD4"],
        ["\x41\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],

        ["\xA7\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD5"],
        ["\x41\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],

        ["\xA7\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD6"],
        ["\x41\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],

        ["\xA7\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD7"],
        ["\x41\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],

        ["\xA7\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD8"],
        ["\x41\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],

        ["\xA7\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xD9"],
        ["\x41\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],

        ["\xA7\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDA"],
        ["\x41\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],

        ["\xA7\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDB"],
        ["\x41\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],

        ["\xA7\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDC"],
        ["\x41\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],

        ["\xA7\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDD"],
        ["\x41\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],

        ["\xA7\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDE"],
        ["\x41\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],

        ["\xA7\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xDF"],
        ["\x41\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],

        ["\xA7\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xE0"],
        ["\x41\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],

        ["\xA7\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x80"],
        ["\x41\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],

        ["\xA7\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x81"],
        ["\x41\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],

        ["\xA7\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x82"],
        ["\x41\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],

        ["\xA7\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x83"],
        ["\x41\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],

        ["\xA7\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x84"],
        ["\x41\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],

        ["\xA7\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x85"],
        ["\x41\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],

        ["\xA7\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x86"],
        ["\x41\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],

        ["\xA7\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x87"],
        ["\x41\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],

        ["\xA7\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x88"],
        ["\x41\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],

        ["\xA7\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x89"],
        ["\x41\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],

        ["\xA7\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8A"],
        ["\x41\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],

        ["\xA7\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8B"],
        ["\x41\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],

        ["\xA7\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8C"],
        ["\x41\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],

        ["\xA7\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8D"],
        ["\x41\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],

        ["\xA7\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8E"],
        ["\x41\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],

        ["\xA7\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x8F"],
        ["\x41\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],

        ["\xA7\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x90"],
        ["\x41\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],

        ["\xA7\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x91"],
        ["\x41\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],

        ["\xA7\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x92"],
        ["\x41\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],

        ["\xA7\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x93"],
        ["\x41\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],

        ["\xA7\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x94"],
        ["\x41\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],

        ["\xA7\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x95"],
        ["\x41\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],

        ["\xA7\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x96"],
        ["\x41\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],

        ["\xA7\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x97"],
        ["\x41\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],

        ["\xA7\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x98"],
        ["\x41\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],

        ["\xA7\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x99"],
        ["\x41\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],

        ["\xA7\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9A"],
        ["\x41\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],

        ["\xA7\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9B"],
        ["\x41\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],

        ["\xA7\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9C"],
        ["\x41\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],

        ["\xA7\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9D"],
        ["\x41\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],

        ["\xA7\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9E"],
        ["\x41\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],

        ["\xA7\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\x9F"],
        ["\x41\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],

        ["\xA7\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xA0"],
        ["\x41\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],

        ["\xA8\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\x43\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],

        ["\xA8\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\x43\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],

        ["\xA8\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\x43\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],

        ["\xA8\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\x7F"],
        ["\x43\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],

        ["\xA8\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB0"],
        ["\x43\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],

        ["\xA8\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB1"],
        ["\x43\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],

        ["\xA8\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\x43\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],

        ["\xA8\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB3"],
        ["\x43\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],

        ["\xA8\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB4"],
        ["\x43\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],

        ["\xA8\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB5"],
        ["\x43\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],

        ["\xA8\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\x43\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],

        ["\xA8\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB7"],
        ["\x43\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],

        ["\xA8\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB8"],
        ["\x43\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],

        ["\xA8\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\x43\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],

        ["\xA8\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE1"],
        ["\x43\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],

        ["\xA8\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE2"],
        ["\x43\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],

        ["\xA8\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE3"],
        ["\x43\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],

        ["\xA8\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE4"],
        ["\x43\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],

        ["\xA8\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE5"],
        ["\x43\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],

        ["\xA8\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE6"],
        ["\x43\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],

        ["\xA8\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE7"],
        ["\x43\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],

        ["\xA8\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE8"],
        ["\x43\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],

        ["\xA8\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xE9"],
        ["\x43\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],

        ["\xA8\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xEA"],
        ["\x43\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],

        ["\xA8\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xEB"],
        ["\x43\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],

        ["\xA8\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\x43\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],

        ["\xA8\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xED"],
        ["\x43\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],

        ["\xA8\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xEE"],
        ["\x43\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],

        ["\xA8\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],
        ["\x43\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],

        ["\xA8\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xF0"],
        ["\x43\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],

        ["\xA8\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xF1"],
        ["\x43\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],

        ["\xA8\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\x43\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],

        ["\x76\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"],

        ["\x76\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"],

        ["\x76\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"],

        ["\x76\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB4"],

        ["\x76\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"],

        ["\x76\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"],

        ["\x76\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"],

        ["\x76\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"],

        ["\x76\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xB9"],

        ["\x76\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x76\xBA"],

        ["\x77\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],

        ["\x77\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA2"],

        ["\x77\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA3"],

        ["\x77\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA4"],

        ["\x77\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA5"],

        ["\x77\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\xE2\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA6"],

        ["\x77\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA7"],

        ["\x77\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA8"],

        ["\x77\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xA9"],

        ["\x77\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x77\xAA"],

        ["\x74\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF1"],
        ["\x41\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB1"],

        ["\x74\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF2"],
        ["\x41\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB2"],

        ["\x74\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF3"],
        ["\x41\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB3"],

        ["\x74\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF4"],
        ["\x41\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB4"],

        ["\x74\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF5"],
        ["\x41\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB5"],

        ["\x74\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF6"],
        ["\x41\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB6"],

        ["\x74\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF7"],
        ["\x41\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB7"],

        ["\x74\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF8"],
        ["\x41\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB8"],

        ["\x74\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xF9"],
        ["\x41\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xB9"],

        ["\x74\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x41\xFA"],
        ["\x41\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x74\xBA"],

        ["\x70\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],

        ["\x70\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE8\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],

        ["\x70\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE8\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],

        ["\x70\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],

        ["\x70\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE8\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],

        ["\x70\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE8\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],

        ["\x70\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE8\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],

        ["\x70\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE8\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],

        ["\x7D\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x7D\xA1"],

        ["\x70\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xDB"],

        ["\x70\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE8\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xDC"],

        ["\x70\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE8\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],

        ["\x70\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE8\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],

        ["\x70\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE8\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],

        ["\x70\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xDA"],

        ["\x70\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE8\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],

        ["\x6F\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xCC"],

        ["\x6F\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xCB"],

        ["\x6F\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xCA"],

        ["\x6F\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xDA"],

        ["\x6F\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],

        ["\x6F\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xFA"],

        ["\x6F\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],

        ["\x73\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],

        ["\x7D\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x7D\xA2"],

        ["\x7D\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x7D\xA3"],

        ["\x72\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\x44\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xBE"],

        ["\x72\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xB6"],

        ["\x72\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\x44\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xB8"],

        ["\x73\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE7\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xEA"],

        ["\x73\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE7\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xEB"],

        ["\x73\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE7\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xEC"],

        ["\x73\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE7\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xED"],

        ["\x73\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE7\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xEE"],

        ["\x73\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\x44\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],

        ["\x73\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xB1"],

        ["\x73\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x73\xBD"],

        ["\x72\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],

        ["\x72\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],

        ["\x72\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],

        ["\x6F\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xDF\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xB8"],

        ["\x6F\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xDF\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xA2"],

        ["\x6F\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xDF\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"],

        ["\x6F\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\x6F\xBA"],

        ["\xB0\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\x48\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],

        ["\xB0\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD4"],
        ["\x54\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],

        ["\xB0\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\x55\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],

        ["\xB0\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAE"],
        ["\x46\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],

        ["\xB0\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF9"],
        ["\x4E\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],

        ["\xB0\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC6"],
        ["\x45\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],

        ["\xB0\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x81"],
        ["\x4F\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],

        ["\xB0\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\x51\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],

        ["\xB0\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCE"],
        ["\x4D\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],

        ["\xB0\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\x50\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],

        ["\xB0\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\x50\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],

        ["\xB0\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9B"],
        ["\x50\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],

        ["\xB0\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\x49\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],

        ["\xB0\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\x4D\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],

        ["\xB0\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\x4E\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],

        ["\xB0\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xEC"],
        ["\x47\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],

        ["\xB0\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\x4E\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],

        ["\xB0\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDD"],
        ["\x4A\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],

        ["\xB0\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\xAA"],
        ["\x67\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],

        ["\xB0\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDA"],
        ["\x50\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],

        ["\xB0\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x82"],
        ["\x47\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],

        ["\xB0\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x81"],
        ["\x55\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],

        ["\xB0\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\x4C\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],

        ["\xB0\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAB"],
        ["\x50\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],

        ["\xB0\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9C"],
        ["\x54\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],

        ["\xB0\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\x51\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],

        ["\xB0\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\x52\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],

        ["\xB0\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\x4E\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],

        ["\xB0\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDC"],
        ["\x49\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],

        ["\xB0\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8E"],
        ["\x4F\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],

        ["\xB0\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7F"],
        ["\x4D\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],

        ["\xB0\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xFB"],
        ["\x4B\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],

        ["\xB0\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\x54\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],

        ["\xB0\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\x45\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],

        ["\xB0\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xEB"],
        ["\x4E\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],

        ["\xB0\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x89"],
        ["\x54\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],

        ["\xB0\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE2"],
        ["\x4B\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],

        ["\xB0\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF1"],
        ["\x48\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],

        ["\xB0\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\x53\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],

        ["\xB0\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\x50\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],

        ["\xB0\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD0"],
        ["\x50\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],

        ["\xB0\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF6"],
        ["\x46\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],

        ["\xB0\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB2"],
        ["\x45\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],

        ["\xB0\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\x47\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],

        ["\xB0\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9E"],
        ["\x4A\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],

        ["\xB0\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xFB"],
        ["\x4D\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],

        ["\xB0\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xFA"],
        ["\x4A\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],

        ["\xB0\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\x51\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],

        ["\xB0\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\x48\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],

        ["\xB0\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\x4C\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],

        ["\xB0\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x89"],
        ["\x51\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],

        ["\xB0\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\x4F\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],

        ["\xB0\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\x47\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],

        ["\xB0\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAD"],
        ["\x4F\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],

        ["\xB0\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE9"],
        ["\x47\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],

        ["\xB0\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\x4F\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],

        ["\xB0\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD7"],
        ["\x49\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],

        ["\xB0\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8F"],
        ["\x55\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],

        ["\xB0\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA9"],
        ["\x4A\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],

        ["\xB0\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\x49\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],

        ["\xB0\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x80"],
        ["\x48\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],

        ["\xB0\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9A"],
        ["\x4E\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],

        ["\xB0\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF6"],
        ["\x4D\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],

        ["\xB0\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x82"],
        ["\x54\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],

        ["\xB0\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xEA"],
        ["\x4A\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],

        ["\xB0\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\x55\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],

        ["\xB0\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBC"],
        ["\x49\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],

        ["\xB0\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDA"],
        ["\x4C\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],

        ["\xB0\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x87"],
        ["\x4A\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],

        ["\xB0\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\x45\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],

        ["\xB0\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\x4F\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],

        ["\xB0\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE9"],
        ["\x48\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],

        ["\xB0\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAC"],
        ["\x48\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],

        ["\xB0\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB3"],
        ["\x49\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],

        ["\xB0\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAA"],
        ["\x48\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],

        ["\xB0\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\x45\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],

        ["\xB0\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB0"],
        ["\x4E\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],

        ["\xB0\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\x52\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],

        ["\xB0\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\x4A\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],

        ["\xB0\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\x47\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],

        ["\xB0\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\x47\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],

        ["\xB0\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9A"],
        ["\x51\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],

        ["\xB0\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC8"],
        ["\x55\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],

        ["\xB0\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x91"],
        ["\x4C\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],

        ["\xB0\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x99"],
        ["\x47\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],

        ["\xB0\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB1"],
        ["\x52\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],

        ["\xB0\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCB"],
        ["\x46\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],

        ["\xB0\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\x4A\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],

        ["\xB0\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB9"],
        ["\x52\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],

        ["\xB0\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDA"],
        ["\x46\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],

        ["\xB0\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\x4B\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],

        ["\xB0\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\x55\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],

        ["\xB0\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE9"],
        ["\x4E\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],

        ["\xB0\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8B"],
        ["\x4E\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],

        ["\xB1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD8"],
        ["\x49\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],

        ["\xB1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\x4C\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],

        ["\xB1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAE"],
        ["\x4E\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],

        ["\xB1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\x55\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],

        ["\xB1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBC"],
        ["\x55\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],

        ["\xB1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\x48\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],

        ["\xB1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD5"],
        ["\x46\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],

        ["\xB1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x99"],
        ["\x50\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],

        ["\xB1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8F"],
        ["\x47\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],

        ["\xB1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDF"],
        ["\x55\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],

        ["\xB1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDD"],
        ["\x49\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],

        ["\xB1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x82"],
        ["\x4C\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],

        ["\xB1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE7"],
        ["\x4B\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],

        ["\xB1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9E"],
        ["\x55\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],

        ["\xB1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xEC"],
        ["\x4D\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],

        ["\xB1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB1"],
        ["\x4F\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],

        ["\xB1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x89"],
        ["\x4A\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],

        ["\xB1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA0"],
        ["\x51\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],

        ["\xB1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\x50\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],

        ["\xB1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDB"],
        ["\x4C\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],

        ["\xB1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF7"],
        ["\x55\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],

        ["\xB1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9A"],
        ["\x54\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],

        ["\xB1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAB"],
        ["\x54\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],

        ["\xB1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\x52\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],

        ["\xB1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\x53\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],

        ["\xB1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\x46\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],

        ["\xB1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\x4E\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],

        ["\xB1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\x54\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],

        ["\xB1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x9B"],
        ["\x52\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],

        ["\xB1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9D"],
        ["\x49\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],

        ["\xB1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAB"],
        ["\x46\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],

        ["\xB1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBC"],
        ["\x4A\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],

        ["\xB1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\x51\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],

        ["\xB1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA7"],
        ["\x50\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],

        ["\xB1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x94"],
        ["\x51\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],

        ["\xB1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD3"],
        ["\x48\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],

        ["\xB1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE8"],
        ["\x55\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],

        ["\xB1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\x49\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],

        ["\xB1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAC"],
        ["\x47\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],

        ["\xB1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBC"],
        ["\x4E\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],

        ["\xB1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\x45\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],

        ["\xB1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],
        ["\x45\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],

        ["\xB1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\x4F\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],

        ["\xB1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB7"],
        ["\x50\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],

        ["\xB1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\x4F\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],

        ["\xB1\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB5"],
        ["\x51\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],

        ["\xB1\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\x52\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],

        ["\xB1\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\x55\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],

        ["\xB1\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xEE"],
        ["\x45\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],

        ["\xB1\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x80"],
        ["\x47\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],

        ["\xB1\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC1"],
        ["\x51\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],

        ["\xB1\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\x4D\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],

        ["\xB1\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\x4A\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],

        ["\xB1\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCE"],
        ["\x50\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],

        ["\xB1\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\x47\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],

        ["\xB1\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAC"],
        ["\x49\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],

        ["\xB1\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\x48\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],

        ["\xB1\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE5"],
        ["\x54\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],

        ["\xB1\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDF"],
        ["\x46\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],

        ["\xB1\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\x51\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],

        ["\xB1\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xEB"],
        ["\x49\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],

        ["\xB1\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB7"],
        ["\x53\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],

        ["\xB1\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\x46\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],

        ["\xB1\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE1"],
        ["\x47\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],

        ["\xB1\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA4"],
        ["\x50\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],

        ["\xB1\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF2"],
        ["\x52\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],

        ["\xB1\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\x50\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],

        ["\xB1\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD0"],
        ["\x47\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],

        ["\xB1\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDE"],
        ["\x54\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],

        ["\xB1\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD0"],
        ["\x55\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],

        ["\xB1\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\x4A\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],

        ["\xB1\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\x4E\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],

        ["\xB1\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xED"],
        ["\x49\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],

        ["\xB1\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAD"],
        ["\x4D\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],

        ["\xB1\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xEE"],
        ["\x53\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],

        ["\xB1\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDD"],
        ["\x4B\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],

        ["\xB1\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\x50\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],

        ["\xB1\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\x4C\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],

        ["\xB1\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAA"],
        ["\x4B\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],

        ["\xB1\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\x4D\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],

        ["\xB1\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\x50\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],

        ["\xB1\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xEC"],
        ["\x4C\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],

        ["\xB1\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE3"],
        ["\x46\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],

        ["\xB1\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD4"],
        ["\x49\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],

        ["\xB1\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC3"],
        ["\x52\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],

        ["\xB1\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\x47\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],

        ["\xB1\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA4"],
        ["\x4D\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],

        ["\xB1\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x82"],
        ["\x4E\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],

        ["\xB1\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD7"],
        ["\x55\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],

        ["\xB1\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\x50\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],

        ["\xB1\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x92"],
        ["\x47\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],

        ["\xB1\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE5"],
        ["\x46\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],

        ["\xB1\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xEA"],
        ["\x4C\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],

        ["\xB1\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x95"],
        ["\x48\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],

        ["\xB2\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE1"],
        ["\x49\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],

        ["\xB2\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA3"],
        ["\x4F\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],

        ["\xB2\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\x45\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],

        ["\xB2\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\x4A\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],

        ["\xB2\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\x54\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],

        ["\xB2\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB1"],
        ["\x49\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],

        ["\xB2\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xFB"],
        ["\x4F\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],

        ["\xB2\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\x54\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],

        ["\xB2\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\x67\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],

        ["\xB2\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\x54\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],

        ["\xB2\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\x4A\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],

        ["\xB2\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\x45\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],

        ["\xB2\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xFD"],
        ["\x47\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],

        ["\xB2\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE0"],
        ["\x49\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],

        ["\xB2\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\x45\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],

        ["\xB2\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE9"],
        ["\x45\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],

        ["\xB2\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\x4E\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],

        ["\xB2\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\x54\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],

        ["\xB2\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\x4E\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],

        ["\xB2\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9A"],
        ["\x50\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],

        ["\xB2\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBD"],
        ["\x4B\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],

        ["\xB2\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\x4E\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],

        ["\xB2\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\x4E\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],

        ["\xB2\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x81"],
        ["\x4C\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],

        ["\xB2\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\x49\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],

        ["\xB2\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB8"],
        ["\x50\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],

        ["\xB2\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\x48\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],

        ["\xB2\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\x45\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],

        ["\xB2\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x90"],
        ["\x45\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],

        ["\xB2\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\x4D\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],

        ["\xB2\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\x47\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],

        ["\xB2\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\x54\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],

        ["\xB2\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\x47\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],

        ["\xB2\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\x48\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],

        ["\xB2\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9F"],
        ["\x45\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],

        ["\xB2\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC6"],
        ["\x47\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],

        ["\xB2\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\x47\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],

        ["\xB2\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\x49\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],

        ["\xB2\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x89"],
        ["\x4E\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],

        ["\xB2\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x86"],
        ["\x46\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],

        ["\xB2\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB8"],
        ["\x52\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],

        ["\xB2\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xED"],
        ["\x48\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],

        ["\xB2\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\x4F\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],

        ["\xB2\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB9"],
        ["\x47\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],

        ["\xB2\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE8"],
        ["\x4E\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],

        ["\xB2\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF7"],
        ["\x46\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],

        ["\xB2\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\x46\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],

        ["\xB2\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x85"],
        ["\x47\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],

        ["\xB2\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9A"],
        ["\x4C\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],

        ["\xB2\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x86"],
        ["\x52\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],

        ["\xB2\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\x54\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],

        ["\xB2\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBE"],
        ["\x4D\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],

        ["\xB2\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\x4F\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],

        ["\xB2\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD9"],
        ["\x46\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],

        ["\xB2\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\x53\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],

        ["\xB2\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\x54\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],

        ["\xB2\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA1"],
        ["\x4B\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],

        ["\xB2\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\x4B\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],

        ["\xB2\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\x4C\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],

        ["\xB2\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC3"],
        ["\x51\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],

        ["\xB2\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD6"],
        ["\x49\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],

        ["\xB2\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCA"],
        ["\x52\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],

        ["\xB2\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xEB"],
        ["\x4A\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],

        ["\xB2\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\x53\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],

        ["\xB2\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8D"],
        ["\x48\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],

        ["\xB2\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE4"],
        ["\x4E\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],

        ["\xB2\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAA"],
        ["\x4F\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],

        ["\xB2\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC7"],
        ["\x54\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],

        ["\xB2\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x9D"],
        ["\x4F\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],

        ["\xB2\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDE"],
        ["\x49\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],

        ["\xB2\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xFC"],
        ["\x53\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],

        ["\xB2\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\x46\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],

        ["\xB2\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8A"],
        ["\x53\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],

        ["\xB2\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBA"],
        ["\x4E\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],

        ["\xB2\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x99"],
        ["\x55\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],

        ["\xB2\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\x46\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],

        ["\xB2\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\x47\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],

        ["\xB2\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\x55\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],

        ["\xB2\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBE"],
        ["\x53\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],

        ["\xB2\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\x48\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],

        ["\xB2\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\x45\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],

        ["\xB2\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB7"],
        ["\x47\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],

        ["\xB2\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA9"],
        ["\x46\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],

        ["\xB2\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\x50\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],

        ["\xB2\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC8"],
        ["\x4E\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],

        ["\xB2\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAF"],
        ["\x4B\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],

        ["\xB2\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\x4C\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],

        ["\xB2\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\x4E\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],

        ["\xB2\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x91"],
        ["\x50\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],

        ["\xB2\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x94"],
        ["\x55\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],

        ["\xB2\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF2"],
        ["\x4E\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],

        ["\xB2\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA0"],
        ["\x4D\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],

        ["\xB2\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA2"],
        ["\x53\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],

        ["\xB2\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8F"],
        ["\x48\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],

        ["\xB3\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCB"],
        ["\x52\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],

        ["\xB3\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\x55\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],

        ["\xB3\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x82"],
        ["\x46\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],

        ["\xB3\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\x45\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],

        ["\xB3\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\x4A\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],

        ["\xB3\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAE"],
        ["\x47\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],

        ["\xB3\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\x4A\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],

        ["\xB3\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\x4A\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],

        ["\xB3\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\x4F\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],

        ["\xB3\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x90"],
        ["\x50\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],

        ["\xB3\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCD"],
        ["\x46\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],

        ["\xB3\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA9"],
        ["\x49\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],

        ["\xB3\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xEA"],
        ["\x49\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],

        ["\xB3\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAC"],
        ["\x51\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],

        ["\xB3\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\x55\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],

        ["\xB3\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x94"],
        ["\x46\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],

        ["\xB3\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE9"],
        ["\x53\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],

        ["\xB3\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\x49\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],

        ["\xB3\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\x50\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],

        ["\xB3\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8A"],
        ["\x52\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],

        ["\xB3\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\x4C\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],

        ["\xB3\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x91"],
        ["\x4F\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],

        ["\xB3\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\x53\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],

        ["\xB3\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\x4F\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],

        ["\xB3\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA5"],
        ["\x4B\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],

        ["\xB3\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8D"],
        ["\x4D\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],

        ["\xB3\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\x54\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],

        ["\xB3\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9C"],
        ["\x55\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],

        ["\xB3\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCC"],
        ["\x55\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],

        ["\xB3\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x85"],
        ["\x4B\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],

        ["\xB3\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBB"],
        ["\x55\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],

        ["\xB3\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCE"],
        ["\x47\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],

        ["\xB3\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\x4A\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],

        ["\xB3\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\x62\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],

        ["\xB3\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8F"],
        ["\x53\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],

        ["\xB3\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD6"],
        ["\x55\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],

        ["\xB3\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD8"],
        ["\x55\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],

        ["\xB3\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBA"],
        ["\x47\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],

        ["\xB3\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\x54\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],

        ["\xB3\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\x48\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],

        ["\xB3\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\x5B\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],

        ["\xB3\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDE"],
        ["\x47\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],

        ["\xB3\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9E"],
        ["\x4B\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],

        ["\xB3\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC0"],
        ["\x50\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],

        ["\xB3\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\x4D\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],

        ["\xB3\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\x48\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],

        ["\xB3\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\x4F\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],

        ["\xB3\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\x4A\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],

        ["\xB3\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\x47\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],

        ["\xB3\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCC"],
        ["\x53\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],

        ["\xB3\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\x4A\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],

        ["\xB3\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\x51\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],

        ["\xB3\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\x4A\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],

        ["\xB3\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\x50\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],

        ["\xB3\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA3"],
        ["\x4A\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],

        ["\xB3\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBE"],
        ["\x45\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],

        ["\xB3\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\x4D\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],

        ["\xB3\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\x47\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],

        ["\xB3\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF1"],
        ["\x47\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],

        ["\xB3\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8E"],
        ["\x54\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],

        ["\xB3\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\x4A\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],

        ["\xB3\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE0"],
        ["\x47\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],

        ["\xB3\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\x4B\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],

        ["\xB3\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB2"],
        ["\x4F\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],

        ["\xB3\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAD"],
        ["\x49\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],

        ["\xB3\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\x55\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],

        ["\xB3\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC2"],
        ["\x46\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],

        ["\xB3\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD6"],
        ["\x47\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],

        ["\xB3\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\x54\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],

        ["\xB3\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x84"],
        ["\x53\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],

        ["\xB3\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\x4F\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],

        ["\xB3\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB4"],
        ["\x47\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],

        ["\xB3\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\x54\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],

        ["\xB3\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\x4B\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],

        ["\xB3\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDF"],
        ["\x48\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],

        ["\xB3\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\x54\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],

        ["\xB3\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xFE"],
        ["\x50\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],

        ["\xB3\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x97"],
        ["\x4F\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],

        ["\xB3\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD5"],
        ["\x53\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],

        ["\xB3\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\x4F\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],

        ["\xB3\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\x51\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],

        ["\xB3\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\x4E\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],

        ["\xB3\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\x54\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],

        ["\xB3\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\x48\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],

        ["\xB3\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xBE"],
        ["\x51\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],

        ["\xB3\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\x60\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],

        ["\xB3\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB2"],
        ["\x49\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],

        ["\xB3\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCC"],
        ["\x4A\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],

        ["\xB3\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\x49\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],

        ["\xB3\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\x54\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],

        ["\xB3\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\x4C\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],

        ["\xB3\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\x52\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],

        ["\xB3\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\x4B\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],

        ["\xB3\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\x4F\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],

        ["\xB4\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAB"],
        ["\x52\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],

        ["\xB4\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9B"],
        ["\x4B\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],

        ["\xB4\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\x4E\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],

        ["\xB4\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC2"],
        ["\x49\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],

        ["\xB4\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\x49\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],

        ["\xB4\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x98"],
        ["\x4F\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],

        ["\xB4\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\x4E\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],

        ["\xB4\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x81"],
        ["\x4B\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],

        ["\xB4\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\x4C\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],

        ["\xB4\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9A"],
        ["\x4B\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],

        ["\xB4\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\x4C\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],

        ["\xB4\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x93"],
        ["\x48\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],

        ["\xB4\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB5"],
        ["\x52\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],

        ["\xB4\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAC"],
        ["\x4F\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],

        ["\xB4\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\x55\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],

        ["\xB4\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC5"],
        ["\x48\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],

        ["\xB4\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA2"],
        ["\x49\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],

        ["\xB4\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF8"],
        ["\x47\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],

        ["\xB4\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\x4A\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],

        ["\xB4\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDA"],
        ["\x48\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],

        ["\xB4\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xEB"],
        ["\x4D\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],

        ["\xB4\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\x47\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],

        ["\xB4\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD3"],
        ["\x4D\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],

        ["\xB4\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA5"],
        ["\x51\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],

        ["\xB4\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAA"],
        ["\x49\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],

        ["\xB4\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCF"],
        ["\x4F\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],

        ["\xB4\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\x4E\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],

        ["\xB4\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\x53\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],

        ["\xB4\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB6"],
        ["\x55\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],

        ["\xB4\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xFB"],
        ["\x4E\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],

        ["\xB4\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\x4D\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],

        ["\xB4\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC4"],
        ["\x4E\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],

        ["\xB4\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x58"],
        ["\x4F\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],

        ["\xB4\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBA"],
        ["\x54\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],

        ["\xB4\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAA"],
        ["\x5D\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],

        ["\xB4\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB9"],
        ["\x4A\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],

        ["\xB4\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\x4B\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],

        ["\xB4\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE3"],
        ["\x49\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],

        ["\xB4\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\x4D\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],

        ["\xB4\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x87"],
        ["\x52\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],

        ["\xB4\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF2"],
        ["\x46\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],

        ["\xB4\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xEC"],
        ["\x4B\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],

        ["\xB4\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xFC"],
        ["\x4C\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],

        ["\xB4\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x84"],
        ["\x50\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],

        ["\xB4\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB6"],
        ["\x54\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],

        ["\xB4\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8C"],
        ["\x4C\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],

        ["\xB4\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\x4C\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],

        ["\xB4\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xEE"],
        ["\x51\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],

        ["\xB4\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\x48\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],

        ["\xB4\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\x63\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],

        ["\xB4\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA1"],
        ["\x49\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],

        ["\xB4\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA9"],
        ["\x4D\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],

        ["\xB4\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\x4E\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],

        ["\xB4\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC1"],
        ["\x45\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],

        ["\xB4\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD9"],
        ["\x4D\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],

        ["\xB4\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC5"],
        ["\x45\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],

        ["\xB4\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xFE"],
        ["\x4F\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],

        ["\xB4\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\x4E\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],

        ["\xB4\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\x48\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],

        ["\xB4\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAA"],
        ["\x4C\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],

        ["\xB4\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\x46\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],

        ["\xB4\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCB"],
        ["\x49\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],

        ["\xB4\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\x47\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],

        ["\xB4\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCF"],
        ["\x49\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],

        ["\xB4\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\x4E\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],

        ["\xB4\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\x54\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],

        ["\xB4\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA5"],
        ["\x49\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],

        ["\xB4\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBF"],
        ["\x45\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],

        ["\xB4\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8B"],
        ["\x55\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],

        ["\xB4\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x84"],
        ["\x55\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],

        ["\xB4\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA4"],
        ["\x51\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],

        ["\xB4\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9D"],
        ["\x53\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],

        ["\xB4\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB8"],
        ["\x48\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],

        ["\xB4\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\x4C\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],

        ["\xB4\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD2"],
        ["\x47\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],

        ["\xB4\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9F"],
        ["\x4E\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],

        ["\xB4\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x91"],
        ["\x4B\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],

        ["\xB4\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD1"],
        ["\x45\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],

        ["\xB4\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xFC"],
        ["\x45\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],

        ["\xB4\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF1"],
        ["\x46\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],

        ["\xB4\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\x4D\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],

        ["\xB4\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\x4F\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],

        ["\xB4\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDF"],
        ["\x49\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],

        ["\xB4\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\x47\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],

        ["\xB4\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB5"],
        ["\x4A\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],

        ["\xB4\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\x4B\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],

        ["\xB4\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x97"],
        ["\x50\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],

        ["\xB4\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF2"],
        ["\x4B\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],

        ["\xB4\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x96"],
        ["\x4D\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],

        ["\xB4\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAB"],
        ["\x4D\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],

        ["\xB4\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\x4B\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],

        ["\xB4\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8B"],
        ["\x46\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],

        ["\xB4\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF1"],
        ["\x4E\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],

        ["\xB4\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB1"],
        ["\x4E\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],

        ["\xB5\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\x45\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],

        ["\xB5\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x82"],
        ["\x49\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],

        ["\xB5\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\x4A\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],

        ["\xB5\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\x45\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],

        ["\xB5\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\x49\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],

        ["\xB5\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\x50\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],

        ["\xB5\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD8"],
        ["\x4E\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],

        ["\xB5\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xEC"],
        ["\x4A\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],

        ["\xB5\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\x52\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],

        ["\xB5\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDB"],
        ["\x46\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],

        ["\xB5\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE0"],
        ["\x55\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],

        ["\xB5\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\x46\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],

        ["\xB5\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x94"],
        ["\x47\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],

        ["\xB5\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7F"],
        ["\x48\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],

        ["\xB5\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\x48\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],

        ["\xB5\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAA"],
        ["\x4D\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],

        ["\xB5\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x87"],
        ["\x47\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],

        ["\xB5\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCE"],
        ["\x53\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],

        ["\xB5\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\x50\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],

        ["\xB5\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\x4A\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],

        ["\xB5\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC0"],
        ["\x47\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],

        ["\xB5\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\x50\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],

        ["\xB5\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCA"],
        ["\x49\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],

        ["\xB5\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x95"],
        ["\x53\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],

        ["\xB5\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8B"],
        ["\x4D\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],

        ["\xB5\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x92"],
        ["\x4F\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],

        ["\xB5\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF7"],
        ["\x48\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],

        ["\xB5\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCD"],
        ["\x4F\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],

        ["\xB5\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\x51\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],

        ["\xB5\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDC"],
        ["\x4F\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],

        ["\xB5\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB4"],
        ["\x4C\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],

        ["\xB5\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x92"],
        ["\x51\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],

        ["\xB5\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x98"],
        ["\x45\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],

        ["\xB5\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC6"],
        ["\x51\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],

        ["\xB5\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\x52\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],

        ["\xB5\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x81"],
        ["\x47\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],

        ["\xB5\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\x55\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],

        ["\xB5\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD7"],
        ["\x46\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],

        ["\xB5\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xED"],
        ["\x51\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],

        ["\xB5\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\x45\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],

        ["\xB5\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xEA"],
        ["\x55\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],

        ["\xB5\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\x4D\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],

        ["\xB5\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\x53\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],

        ["\xB5\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC2"],
        ["\x4B\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],

        ["\xB5\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\x4B\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],

        ["\xB5\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\x52\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],

        ["\xB5\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA6"],
        ["\x4A\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],

        ["\xB5\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAE"],
        ["\x55\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],

        ["\xB5\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA4"],
        ["\x4A\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],

        ["\xB5\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDE"],
        ["\x4A\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],

        ["\xB5\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\x4D\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],

        ["\xB5\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\x52\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],

        ["\xB5\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xFC"],
        ["\x4B\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],

        ["\xB5\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\x4D\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],

        ["\xB5\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8A"],
        ["\x45\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],

        ["\xB5\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x85"],
        ["\x50\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],

        ["\xB5\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x81"],
        ["\x4A\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],

        ["\xB5\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\x48\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],

        ["\xB5\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x98"],
        ["\x4B\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],

        ["\xB5\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x92"],
        ["\x45\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],

        ["\xB5\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\x4B\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],

        ["\xB5\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCC"],
        ["\x47\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],

        ["\xB5\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\x4C\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],

        ["\xB5\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\x50\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],

        ["\xB5\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA0"],
        ["\x49\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],

        ["\xB5\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\x50\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],

        ["\xB5\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\x4D\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],

        ["\xB5\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\x54\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],

        ["\xB5\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDB"],
        ["\x48\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],

        ["\xB5\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x86"],
        ["\x49\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],

        ["\xB5\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAA"],
        ["\x50\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],

        ["\xB5\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCF"],
        ["\x51\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],

        ["\xB5\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF3"],
        ["\x49\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],

        ["\xB5\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xFE"],
        ["\x51\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],

        ["\xB5\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\x47\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],

        ["\xB5\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\x4C\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],

        ["\xB5\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\x49\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],

        ["\xB5\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCA"],
        ["\x4A\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],

        ["\xB5\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\x48\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],

        ["\xB5\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\x4A\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],

        ["\xB5\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\x4F\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],

        ["\xB5\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\x4D\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],

        ["\xB5\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x82"],
        ["\x4B\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],

        ["\xB5\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\x52\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],

        ["\xB5\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\x4F\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],

        ["\xB5\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9A"],
        ["\x4A\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],

        ["\xB5\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC2"],
        ["\x4D\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],

        ["\xB5\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE7"],
        ["\x51\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],

        ["\xB5\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\x4B\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],

        ["\xB5\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAA"],
        ["\x55\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],

        ["\xB5\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xEE"],
        ["\x48\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],

        ["\xB5\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAC"],
        ["\x4B\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],

        ["\xB5\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\x4B\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],

        ["\xB5\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\x45\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],

        ["\xB6\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBC"],
        ["\x48\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],

        ["\xB6\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xEC"],
        ["\x52\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],

        ["\xB6\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAD"],
        ["\x55\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],

        ["\xB6\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\x55\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],

        ["\xB6\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\x49\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],

        ["\xB6\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB3"],
        ["\x47\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],

        ["\xB6\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xEC"],
        ["\x51\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],

        ["\xB6\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD7"],
        ["\x47\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],

        ["\xB6\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\x4D\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],

        ["\xB6\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE2"],
        ["\x53\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],

        ["\xB6\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD5"],
        ["\x4D\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],

        ["\xB6\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\x4C\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],

        ["\xB6\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x95"],
        ["\x4A\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],

        ["\xB6\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\x51\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],

        ["\xB6\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD2"],
        ["\x46\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],

        ["\xB6\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x85"],
        ["\x53\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],

        ["\xB6\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\x55\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],

        ["\xB6\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD5"],
        ["\x4B\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],

        ["\xB6\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\x49\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],

        ["\xB6\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\x55\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],

        ["\xB6\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA5"],
        ["\x47\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],

        ["\xB6\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x89"],
        ["\x45\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],

        ["\xB6\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\x4A\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],

        ["\xB6\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\x4E\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],

        ["\xB6\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9E"],
        ["\x4C\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],

        ["\xB6\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xBB"],
        ["\x51\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],

        ["\xB6\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE3"],
        ["\x4B\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],

        ["\xB6\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\x50\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],

        ["\xB6\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\x46\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],

        ["\xB6\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\x55\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],

        ["\xB6\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x95"],
        ["\x49\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],

        ["\xB6\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8D"],
        ["\x4A\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],

        ["\xB6\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\x4A\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],

        ["\xB6\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD5"],
        ["\x51\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],

        ["\xB6\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\x4C\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],

        ["\xB6\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xED"],
        ["\x4D\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],

        ["\xB6\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD9"],
        ["\x4E\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],

        ["\xB6\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\x68\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],

        ["\xB6\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x83"],
        ["\x4C\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],

        ["\xB6\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\x45\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],

        ["\xB6\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8B"],
        ["\x48\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],

        ["\xB6\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB6"],
        ["\x49\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],

        ["\xB6\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB7"],
        ["\x49\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],

        ["\xB6\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xFD"],
        ["\x45\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],

        ["\xB6\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC0"],
        ["\x49\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],

        ["\xB6\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE7"],
        ["\x55\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],

        ["\xB6\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\x4F\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],

        ["\xB6\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9F"],
        ["\x49\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],

        ["\xB6\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAE"],
        ["\x49\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],

        ["\xB6\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\x4A\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],

        ["\xB6\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8E"],
        ["\x4B\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],

        ["\xB6\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCF"],
        ["\x54\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],

        ["\xB6\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9D"],
        ["\x4B\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],

        ["\xB6\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\x4C\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],

        ["\xB6\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\x4C\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],

        ["\xB6\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\x4D\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],

        ["\xB6\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\x55\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],

        ["\xB6\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8F"],
        ["\x4B\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\xB6\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x97"],
        ["\x4B\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],

        ["\xB6\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\x4D\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],

        ["\xB6\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\x4C\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],

        ["\xB6\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA7"],
        ["\x4A\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],

        ["\xB6\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\x54\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],

        ["\xB6\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x87"],
        ["\x4D\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],

        ["\xB6\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\x46\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],

        ["\xB6\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x86"],
        ["\x45\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],

        ["\xB6\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\x50\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],

        ["\xB6\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8C"],
        ["\x47\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],

        ["\xB6\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\x45\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],

        ["\xB6\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\x4F\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],

        ["\xB6\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\x4C\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],

        ["\xB6\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\x45\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],

        ["\xB6\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\x52\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],

        ["\xB6\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE9"],
        ["\x4D\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],

        ["\xB6\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\x4E\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],

        ["\xB6\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\x4A\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],

        ["\xB6\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\x53\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],

        ["\xB6\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xFE"],
        ["\x4C\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],

        ["\xB6\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x85"],
        ["\x4F\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],

        ["\xB6\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xFC"],
        ["\x49\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],

        ["\xB6\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAF"],
        ["\x47\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],

        ["\xB6\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB2"],
        ["\x52\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],

        ["\xB6\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x88"],
        ["\x55\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],

        ["\xB6\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB9"],
        ["\x4E\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],

        ["\xB6\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8D"],
        ["\x47\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\xB6\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\x50\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],

        ["\xB6\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF4"],
        ["\x55\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],

        ["\xB6\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xEC"],
        ["\x49\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],

        ["\xB6\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB9"],
        ["\x4B\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],

        ["\xB6\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB8"],
        ["\x4C\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],

        ["\xB6\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA6"],
        ["\x4D\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],

        ["\xB6\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF0"],
        ["\x4B\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],

        ["\xB6\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB2"],
        ["\x54\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],

        ["\xB6\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x94"],
        ["\x4D\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],

        ["\xB7\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\x4D\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],

        ["\xB7\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA6"],
        ["\x50\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],

        ["\xB7\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\x4F\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],

        ["\xB7\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF1"],
        ["\x4D\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],

        ["\xB7\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE1"],
        ["\x52\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],

        ["\xB7\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\x4A\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],

        ["\xB7\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7F"],
        ["\x46\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],

        ["\xB7\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\x4C\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],

        ["\xB7\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x85"],
        ["\x4E\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],

        ["\xB7\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9B"],
        ["\x47\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],

        ["\xB7\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\x4B\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],

        ["\xB7\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\x48\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],

        ["\xB7\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\x4F\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],

        ["\xB7\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\x49\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],

        ["\xB7\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCF"],
        ["\x47\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],

        ["\xB7\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x98"],
        ["\x49\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],

        ["\xB7\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC8"],
        ["\x4B\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],

        ["\xB7\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB1"],
        ["\x47\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],

        ["\xB7\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x97"],
        ["\x48\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],

        ["\xB7\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9E"],
        ["\x49\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],

        ["\xB7\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDB"],
        ["\x53\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],

        ["\xB7\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\x4F\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],

        ["\xB7\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD2"],
        ["\x53\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],

        ["\xB7\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\x48\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],

        ["\xB7\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\x4A\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],

        ["\xB7\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\x4C\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],

        ["\xB7\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE8"],
        ["\x4B\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],

        ["\xB7\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE4"],
        ["\x47\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],

        ["\xB7\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE6"],
        ["\x49\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],

        ["\xB7\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB9"],
        ["\x4C\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],

        ["\xB7\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE6"],
        ["\x46\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],

        ["\xB7\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\x4C\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],

        ["\xB7\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x90"],
        ["\x46\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],

        ["\xB7\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\x4E\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],

        ["\xB7\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\x46\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],

        ["\xB7\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA8"],
        ["\x48\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],

        ["\xB7\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB6"],
        ["\x4E\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],

        ["\xB7\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\x51\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],

        ["\xB7\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC1"],
        ["\x4D\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],

        ["\xB7\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\x4E\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],

        ["\xB7\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB0"],
        ["\x47\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],

        ["\xB7\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x93"],
        ["\x49\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],

        ["\xB7\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAB"],
        ["\x49\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],

        ["\xB7\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x98"],
        ["\x51\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],

        ["\xB7\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB4"],
        ["\x51\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],

        ["\xB7\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\x4F\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],

        ["\xB7\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xFA"],
        ["\x48\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],

        ["\xB7\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x88"],
        ["\x46\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],

        ["\xB7\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\x4A\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],

        ["\xB7\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\x53\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],

        ["\xB7\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xEF"],
        ["\x55\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],

        ["\xB7\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC9"],
        ["\x4E\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],

        ["\xB7\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB3"],
        ["\x53\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],

        ["\xB7\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF9"],
        ["\x4D\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],

        ["\xB7\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC9"],
        ["\x45\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],

        ["\xB7\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xFB"],
        ["\x54\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],

        ["\xB7\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\x4A\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],

        ["\xB7\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA6"],
        ["\x48\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],

        ["\xB7\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\x66\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],

        ["\xB7\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8E"],
        ["\x4D\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],

        ["\xB7\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\x49\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],

        ["\xB7\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA9"],
        ["\x4B\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],

        ["\xB7\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\x4D\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],

        ["\xB7\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\x49\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],

        ["\xB7\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD9"],
        ["\x54\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],

        ["\xB7\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\x4A\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],

        ["\xB7\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\x4B\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],

        ["\xB7\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC3"],
        ["\x53\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],

        ["\xB7\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\x50\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],

        ["\xB7\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\x4F\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],

        ["\xB7\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB5"],
        ["\x4C\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],

        ["\xB7\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA4"],
        ["\x47\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],

        ["\xB7\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\x4A\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],

        ["\xB7\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x86"],
        ["\x4B\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],

        ["\xB7\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBF"],
        ["\x46\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],

        ["\xB7\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\x4B\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],

        ["\xB7\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCC"],
        ["\x54\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],

        ["\xB7\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\x45\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],

        ["\xB7\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB2"],
        ["\x48\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],

        ["\xB7\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xFA"],
        ["\x52\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],

        ["\xB7\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF1"],
        ["\x52\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],

        ["\xB7\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x81"],
        ["\x46\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],

        ["\xB7\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF4"],
        ["\x48\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],

        ["\xB7\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\x4B\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],

        ["\xB7\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\x4C\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],

        ["\xB7\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\x4F\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],

        ["\xB7\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\x4F\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],

        ["\xB7\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\x4A\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],

        ["\xB7\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC3"],
        ["\x4E\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],

        ["\xB7\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\x46\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],

        ["\xB7\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBE"],
        ["\x47\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],

        ["\xB7\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC6"],
        ["\x4D\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],

        ["\xB7\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8D"],
        ["\x50\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],

        ["\xB7\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x93"],
        ["\x54\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],

        ["\xB8\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\x48\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],

        ["\xB8\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDC"],
        ["\x48\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],

        ["\xB8\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8A"],
        ["\x54\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],

        ["\xB8\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\x4A\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],

        ["\xB8\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\x4F\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],

        ["\xB8\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD3"],
        ["\x46\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],

        ["\xB8\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\x53\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],

        ["\xB8\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF6"],
        ["\x49\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],

        ["\xB8\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\x45\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],

        ["\xB8\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\x4B\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],

        ["\xB8\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBB"],
        ["\x45\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],

        ["\xB8\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\x49\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],

        ["\xB8\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE5"],
        ["\x47\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],

        ["\xB8\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\x4E\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],

        ["\xB8\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\x4E\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],

        ["\xB8\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\x4E\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],

        ["\xB8\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\x4A\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],

        ["\xB8\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\x4A\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],

        ["\xB8\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB4"],
        ["\x48\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],

        ["\xB8\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\x4C\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],

        ["\xB8\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x95"],
        ["\x46\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],

        ["\xB8\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\x45\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],

        ["\xB8\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8E"],
        ["\x4C\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],

        ["\xB8\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\x50\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],

        ["\xB8\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\x4E\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],

        ["\xB8\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8A"],
        ["\x47\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],

        ["\xB8\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xFC"],
        ["\x47\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],

        ["\xB8\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\x4C\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],

        ["\xB8\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB7"],
        ["\x46\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],

        ["\xB8\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\x55\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],

        ["\xB8\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAC"],
        ["\x53\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],

        ["\xB8\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9A"],
        ["\x47\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],

        ["\xB8\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAB"],
        ["\x55\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],

        ["\xB8\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAD"],
        ["\x48\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],

        ["\xB8\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA5"],
        ["\x54\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],

        ["\xB8\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xFA"],
        ["\x49\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],

        ["\xB8\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD4"],
        ["\x45\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],

        ["\xB8\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\x4A\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],

        ["\xB8\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x94"],
        ["\x4A\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],

        ["\xB8\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF2"],
        ["\x53\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],

        ["\xB8\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAF"],
        ["\x4E\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],

        ["\xB8\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAD"],
        ["\x47\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],

        ["\xB8\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF8"],
        ["\x45\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],

        ["\xB8\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\x53\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],

        ["\xB8\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCF"],
        ["\x45\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],

        ["\xB8\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\x4A\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],

        ["\xB8\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\x50\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],

        ["\xB8\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\x4D\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],

        ["\xB8\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xDB"],
        ["\x51\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],

        ["\xB8\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\x54\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],

        ["\xB8\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\x4F\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],

        ["\xB8\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\x4C\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],

        ["\xB8\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\x4D\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],

        ["\xB8\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\x51\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],

        ["\xB8\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\x4A\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],

        ["\xB8\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB4"],
        ["\x4E\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],

        ["\xB8\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCB"],
        ["\x55\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],

        ["\xB8\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\x55\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],

        ["\xB8\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\x4C\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],

        ["\xB8\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\x4E\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],

        ["\xB8\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAF"],
        ["\x4F\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],

        ["\xB8\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\x45\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],

        ["\xB8\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\x4B\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],

        ["\xB8\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x99"],
        ["\x4D\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],

        ["\xB8\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDF"],
        ["\x45\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],

        ["\xB8\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xEE"],
        ["\x4A\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],

        ["\xB8\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\x47\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],

        ["\xB8\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB5"],
        ["\x50\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],

        ["\xB8\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE5"],
        ["\x45\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],

        ["\xB8\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x98"],
        ["\x46\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],

        ["\xB8\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB1"],
        ["\x4A\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],

        ["\xB8\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD3"],
        ["\x52\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],

        ["\xB8\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xEE"],
        ["\x55\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],

        ["\xB8\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF1"],
        ["\x53\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],

        ["\xB8\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\x4F\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],

        ["\xB8\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE7"],
        ["\x48\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],

        ["\xB8\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x91"],
        ["\x4D\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],

        ["\xB8\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDB"],
        ["\x49\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],

        ["\xB8\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\x51\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],

        ["\xB8\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB5"],
        ["\x4E\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],

        ["\xB8\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\x4F\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],

        ["\xB8\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8E"],
        ["\x47\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],

        ["\xB8\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\x54\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],

        ["\xB8\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE3"],
        ["\x53\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],

        ["\xB8\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAE"],
        ["\x4C\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],

        ["\xB8\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\x53\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],

        ["\xB8\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9E"],
        ["\x45\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],

        ["\xB8\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBB"],
        ["\x46\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],

        ["\xB8\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\x48\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],

        ["\xB8\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\x49\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],

        ["\xB8\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE9"],
        ["\x51\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],

        ["\xB8\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\x49\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],

        ["\xB8\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x88"],
        ["\x45\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],

        ["\xB8\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA5"],
        ["\x46\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],

        ["\xB9\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAF"],
        ["\x51\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],

        ["\xB9\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\x52\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],

        ["\xB9\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF3"],
        ["\x4E\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],

        ["\xB9\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\x54\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],

        ["\xB9\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9E"],
        ["\x46\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],

        ["\xB9\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD9"],
        ["\x4B\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],

        ["\xB9\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF4"],
        ["\x45\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],

        ["\xB9\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC8"],
        ["\x46\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],

        ["\xB9\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\x45\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],

        ["\xB9\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA3"],
        ["\x4C\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],

        ["\xB9\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCB"],
        ["\x53\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],

        ["\xB9\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\x45\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],

        ["\xB9\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB7"],
        ["\x45\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],

        ["\xB9\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\x51\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],

        ["\xB9\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9A"],
        ["\x46\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],

        ["\xB9\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD3"],
        ["\x45\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],

        ["\xB9\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC7"],
        ["\x47\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],

        ["\xB9\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8E"],
        ["\x53\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],

        ["\xB9\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\x4A\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],

        ["\xB9\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\x50\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],

        ["\xB9\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAC"],
        ["\x4C\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],

        ["\xB9\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC5"],
        ["\x4B\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],

        ["\xB9\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x99"],
        ["\x5B\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],

        ["\xB9\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB0"],
        ["\x48\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],

        ["\xB9\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\x4A\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],

        ["\xB9\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8B"],
        ["\x50\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],

        ["\xB9\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBF"],
        ["\x48\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],

        ["\xB9\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCC"],
        ["\x52\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],

        ["\xB9\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x96"],
        ["\x47\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],

        ["\xB9\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAD"],
        ["\x45\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],

        ["\xB9\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\x4F\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],

        ["\xB9\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\x46\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],

        ["\xB9\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC6"],
        ["\x48\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],

        ["\xB9\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\x4A\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],

        ["\xB9\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA0"],
        ["\x48\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],

        ["\xB9\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBB"],
        ["\x4C\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],

        ["\xB9\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xEF"],
        ["\x4A\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],

        ["\xB9\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\x4F\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],

        ["\xB9\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\x51\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],

        ["\xB9\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\x4B\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],

        ["\xB9\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\x4C\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],

        ["\xB9\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\x50\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],

        ["\xB9\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\x48\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],

        ["\xB9\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9A"],
        ["\x49\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],

        ["\xB9\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\x47\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],

        ["\xB9\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xEB"],
        ["\x50\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],

        ["\xB9\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD5"],
        ["\x52\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],

        ["\xB9\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\x52\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],

        ["\xB9\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD8"],
        ["\x51\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],

        ["\xB9\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9F"],
        ["\x48\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],

        ["\xB9\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDC"],
        ["\x46\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],

        ["\xB9\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA4"],
        ["\x45\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],

        ["\xB9\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xED"],
        ["\x4B\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],

        ["\xB9\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\x4A\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],

        ["\xB9\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\x4A\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],

        ["\xB9\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8F"],
        ["\x4E\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],

        ["\xB9\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\x50\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],

        ["\xB9\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x86"],
        ["\x4D\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],

        ["\xB9\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\x48\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],

        ["\xB9\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\x5F\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],

        ["\xB9\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA1"],
        ["\x46\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],

        ["\xB9\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9B"],
        ["\x54\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],

        ["\xB9\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE5"],
        ["\x49\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],

        ["\xB9\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x97"],
        ["\x4A\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],

        ["\xB9\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBD"],
        ["\x46\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],

        ["\xB9\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\x45\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],

        ["\xB9\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD6"],
        ["\x4D\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],

        ["\xB9\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC7"],
        ["\x49\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],

        ["\xB9\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC6"],
        ["\x54\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],

        ["\xB9\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE2"],
        ["\x48\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],

        ["\xB9\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA0"],
        ["\x45\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],

        ["\xB9\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB9"],
        ["\x55\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],

        ["\xB9\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\x55\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],

        ["\xB9\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x80"],
        ["\x53\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],

        ["\xB9\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\x4C\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],

        ["\xB9\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA9"],
        ["\x50\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],

        ["\xB9\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\x52\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],

        ["\xB9\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9E"],
        ["\x47\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],

        ["\xB9\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF5"],
        ["\x4B\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],

        ["\xB9\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\x49\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],

        ["\xB9\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8F"],
        ["\x45\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],

        ["\xB9\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x94"],
        ["\x4E\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],

        ["\xB9\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\x51\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],

        ["\xB9\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xFD"],
        ["\x50\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],

        ["\xB9\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\x46\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],

        ["\xB9\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x95"],
        ["\x4E\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],

        ["\xB9\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD0"],
        ["\x54\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],

        ["\xB9\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA4"],
        ["\x4B\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],

        ["\xB9\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x95"],
        ["\x54\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],

        ["\xB9\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\x50\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],

        ["\xB9\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9D"],
        ["\x54\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],

        ["\xB9\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA5"],
        ["\x4A\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],

        ["\xB9\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDC"],
        ["\x50\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],

        ["\xB9\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\x48\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],

        ["\xBA\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\x4D\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],

        ["\xBA\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\x49\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],

        ["\xBA\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE0"],
        ["\x45\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],

        ["\xBA\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\x4B\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],

        ["\xBA\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA6"],
        ["\x53\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],

        ["\xBA\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x88"],
        ["\x54\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],

        ["\xBA\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\x4A\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],

        ["\xBA\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB8"],
        ["\x53\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],

        ["\xBA\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA4"],
        ["\x4E\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],

        ["\xBA\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE8"],
        ["\x54\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],

        ["\xBA\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\x4F\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],

        ["\xBA\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\x46\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],

        ["\xBA\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\x53\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],

        ["\xBA\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\x4B\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],

        ["\xBA\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xFD"],
        ["\x53\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],

        ["\xBA\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBD"],
        ["\x4C\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],

        ["\xBA\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB4"],
        ["\x55\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],

        ["\xBA\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA8"],
        ["\x50\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],

        ["\xBA\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDC"],
        ["\x55\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],

        ["\xBA\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\x45\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],

        ["\xBA\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA5"],
        ["\x50\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],

        ["\xBA\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB8"],
        ["\x51\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],

        ["\xBA\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD3"],
        ["\x4E\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],

        ["\xBA\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\x48\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],

        ["\xBA\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8B"],
        ["\x49\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],

        ["\xBA\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\x47\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],

        ["\xBA\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAD"],
        ["\x4E\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],

        ["\xBA\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x88"],
        ["\x51\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],

        ["\xBA\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\x49\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],

        ["\xBA\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\x51\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],

        ["\xBA\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\x4D\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],

        ["\xBA\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8A"],
        ["\x4F\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],

        ["\xBA\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8D"],
        ["\x4E\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],

        ["\xBA\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB1"],
        ["\x48\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],

        ["\xBA\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8F"],
        ["\x54\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],

        ["\xBA\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\x4B\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],

        ["\xBA\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\x4C\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],

        ["\xBA\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\x48\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],

        ["\xBA\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF5"],
        ["\x46\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],

        ["\xBA\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\x4A\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],

        ["\xBA\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC1"],
        ["\x53\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],

        ["\xBA\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\x49\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],

        ["\xBA\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD4"],
        ["\x4E\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],

        ["\xBA\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCD"],
        ["\x4D\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],

        ["\xBA\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF1"],
        ["\x49\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],

        ["\xBA\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\x4B\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],

        ["\xBA\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE0"],
        ["\x4D\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],

        ["\xBA\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\x48\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],

        ["\xBA\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\x47\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],

        ["\xBA\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBC"],
        ["\x4C\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],

        ["\xBA\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBF"],
        ["\x53\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],

        ["\xBA\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\x53\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],

        ["\xBA\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\x4C\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],

        ["\xBA\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB4"],
        ["\x54\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],

        ["\xBA\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\x4C\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],

        ["\xBA\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDB"],
        ["\x47\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],

        ["\xBA\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\x47\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],

        ["\xBA\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA8"],
        ["\x4B\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],

        ["\xBA\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBD"],
        ["\x49\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],

        ["\xBA\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\x4D\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],

        ["\xBA\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x97"],
        ["\x47\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],

        ["\xBA\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\x47\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],

        ["\xBA\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCD"],
        ["\x47\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],

        ["\xBA\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBC"],
        ["\x46\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],

        ["\xBA\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\x4C\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],

        ["\xBA\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xAF"],
        ["\x49\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],

        ["\xBA\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\x50\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],

        ["\xBA\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xEC"],
        ["\x45\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],

        ["\xBA\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x91"],
        ["\x45\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],

        ["\xBA\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\x4A\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],

        ["\xBA\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\x4B\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],

        ["\xBA\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\x54\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],

        ["\xBA\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDE"],
        ["\x4C\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],

        ["\xBA\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7F"],
        ["\x45\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],

        ["\xBA\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA3"],
        ["\x46\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],

        ["\xBA\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD2"],
        ["\x52\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],

        ["\xBA\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAF"],
        ["\x50\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],

        ["\xBA\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x94"],
        ["\x45\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],

        ["\xBA\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x90"],
        ["\x4A\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],

        ["\xBA\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\x4F\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],

        ["\xBA\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA3"],
        ["\x50\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],

        ["\xBA\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE8"],
        ["\x48\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],

        ["\xBA\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA4"],
        ["\x4F\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],

        ["\xBA\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\x51\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],

        ["\xBA\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x99"],
        ["\x54\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],

        ["\xBA\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\x46\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],

        ["\xBA\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\x4C\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],

        ["\xBA\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB1"],
        ["\x50\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],

        ["\xBA\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\x47\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],

        ["\xBA\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x91"],
        ["\x53\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],

        ["\xBA\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\x49\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],

        ["\xBA\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\x54\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],

        ["\xBA\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA1"],
        ["\x4E\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],

        ["\xBA\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCF"],
        ["\x48\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],

        ["\xBB\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x93"],
        ["\x4B\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],

        ["\xBB\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x9E"],
        ["\x4F\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],

        ["\xBB\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\x4C\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],

        ["\xBB\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\x4F\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],

        ["\xBB\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF9"],
        ["\x48\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],

        ["\xBB\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE9"],
        ["\x49\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],

        ["\xBB\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\x4C\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],

        ["\xBB\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8A"],
        ["\x4A\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],

        ["\xBB\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA4"],
        ["\x52\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],

        ["\xBB\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\x4F\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],

        ["\xBB\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\x55\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],

        ["\xBB\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD2"],
        ["\x55\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],

        ["\xBB\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB7"],
        ["\x4E\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],

        ["\xBB\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\x4D\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],

        ["\xBB\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC3"],
        ["\x54\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],

        ["\xBB\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\x45\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],

        ["\xBB\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9C"],
        ["\x50\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],

        ["\xBB\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD2"],
        ["\x48\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],

        ["\xBB\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\x45\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],

        ["\xBB\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\x50\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],

        ["\xBB\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDE"],
        ["\x53\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],

        ["\xBB\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\x4A\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],

        ["\xBB\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF3"],
        ["\x51\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],

        ["\xBB\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCE"],
        ["\x54\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],

        ["\xBB\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x99"],
        ["\x53\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],

        ["\xBB\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC0"],
        ["\x45\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],

        ["\xBB\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\x48\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],

        ["\xBB\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xEB"],
        ["\x55\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],

        ["\xBB\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\x4F\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],

        ["\xBB\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\x51\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],

        ["\xBB\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xEE"],
        ["\x4D\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],

        ["\xBB\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x99"],
        ["\x48\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],

        ["\xBB\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB3"],
        ["\x55\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],

        ["\xBB\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xFC"],
        ["\x4E\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],

        ["\xBB\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x93"],
        ["\x50\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],

        ["\xBB\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x92"],
        ["\x49\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],

        ["\xBB\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB5"],
        ["\x48\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],

        ["\xBB\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\x54\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],

        ["\xBB\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8A"],
        ["\x50\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],

        ["\xBB\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB6"],
        ["\x48\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],

        ["\xBB\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC0"],
        ["\x4B\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],

        ["\xBB\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF0"],
        ["\x45\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],

        ["\xBB\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD9"],
        ["\x47\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],

        ["\xBB\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\x4B\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],

        ["\xBB\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\x45\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],

        ["\xBB\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\x46\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],

        ["\xBB\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x90"],
        ["\x49\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],

        ["\xBB\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\x4C\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],

        ["\xBB\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\x4B\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],

        ["\xBB\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\x45\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],

        ["\xBB\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBA"],
        ["\x55\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],

        ["\xBB\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\x45\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],

        ["\xBB\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\x4A\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],

        ["\xBB\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\x46\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],

        ["\xBB\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAD"],
        ["\x46\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],

        ["\xBB\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB6"],
        ["\x47\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],

        ["\xBB\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\x47\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],

        ["\xBB\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\x4F\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],

        ["\xBB\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA5"],
        ["\x4E\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],

        ["\xBB\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x88"],
        ["\x48\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],

        ["\xBB\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\x4D\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],

        ["\xBB\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\x46\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],

        ["\xBB\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD8"],
        ["\x48\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],

        ["\xBB\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x99"],
        ["\x49\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],

        ["\xBB\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8E"],
        ["\x48\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],

        ["\xBB\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9F"],
        ["\x51\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],

        ["\xBB\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xEB"],
        ["\x4F\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],

        ["\xBB\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC3"],
        ["\x46\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],

        ["\xBB\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC7"],
        ["\x46\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],

        ["\xBB\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x80"],
        ["\x46\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],

        ["\xBB\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\x4A\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],

        ["\xBB\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x82"],
        ["\x53\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],

        ["\xBB\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\x48\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],

        ["\xBB\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\x4A\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],

        ["\xBB\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\x4A\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],

        ["\xBB\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x90"],
        ["\x4E\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],

        ["\xBB\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\x4C\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],

        ["\xBB\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\x49\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],

        ["\xBB\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\x4B\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],

        ["\xBB\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\x4F\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],

        ["\xBB\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\x46\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],

        ["\xBB\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x94"],
        ["\x4F\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],

        ["\xBB\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB7"],
        ["\x52\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],

        ["\xBB\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8F"],
        ["\x4A\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],

        ["\xBB\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9F"],
        ["\x4A\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],

        ["\xBB\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCE"],
        ["\x45\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],

        ["\xBB\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBC"],
        ["\x4B\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],

        ["\xBB\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\x4F\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],

        ["\xBB\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9F"],
        ["\x46\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],

        ["\xBB\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF2"],
        ["\x48\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],

        ["\xBB\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA0"],
        ["\x46\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],

        ["\xBB\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBE"],
        ["\x4C\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],

        ["\xBB\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD8"],
        ["\x46\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],

        ["\xBB\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\x46\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],

        ["\xBC\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x97"],
        ["\x45\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],

        ["\xBC\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\x48\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],

        ["\xBC\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x84"],
        ["\x45\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],

        ["\xBC\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\x4C\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],

        ["\xBC\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\x52\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],

        ["\xBC\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x82"],
        ["\x51\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],

        ["\xBC\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\x4A\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],

        ["\xBC\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\x48\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],

        ["\xBC\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE6"],
        ["\x51\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],

        ["\xBC\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\x4C\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],

        ["\xBC\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC3"],
        ["\x45\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],

        ["\xBC\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\x4F\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],

        ["\xBC\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\x4D\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],

        ["\xBC\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\x50\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],

        ["\xBC\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x97"],
        ["\x46\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],

        ["\xBC\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8F"],
        ["\x46\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],

        ["\xBC\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\x4A\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],

        ["\xBC\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBA"],
        ["\x50\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],

        ["\xBC\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\x54\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],

        ["\xBC\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA6"],
        ["\x4B\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],

        ["\xBC\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\x4C\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],

        ["\xBC\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA5"],
        ["\x52\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],

        ["\xBC\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\x45\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],

        ["\xBC\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\x50\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],

        ["\xBC\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\x4D\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],

        ["\xBC\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\x49\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],

        ["\xBC\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE0"],
        ["\x53\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],

        ["\xBC\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB8"],
        ["\x47\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],

        ["\xBC\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\x54\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],

        ["\xBC\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x90"],
        ["\x4C\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],

        ["\xBC\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAE"],
        ["\x4D\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],

        ["\xBC\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\x51\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],

        ["\xBC\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\x46\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],

        ["\xBC\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xED"],
        ["\x45\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],

        ["\xBC\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBD"],
        ["\x52\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],

        ["\xBC\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\x48\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],

        ["\xBC\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD2"],
        ["\x54\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],

        ["\xBC\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA7"],
        ["\x47\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],

        ["\xBC\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\x49\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],

        ["\xBC\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC0"],
        ["\x55\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],

        ["\xBC\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA6"],
        ["\x62\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],

        ["\xBC\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\x4F\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],

        ["\xBC\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\x4C\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],

        ["\xBC\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC4"],
        ["\x48\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],

        ["\xBC\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8A"],
        ["\x49\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],

        ["\xBC\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB3"],
        ["\x4B\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],

        ["\xBC\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\x51\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],

        ["\xBC\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD1"],
        ["\x4B\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],

        ["\xBC\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x4C\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],

        ["\xBC\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\x46\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],

        ["\xBC\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\x4F\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],

        ["\xBC\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\x46\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],

        ["\xBC\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBB"],
        ["\x4D\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],

        ["\xBC\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\x46\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],

        ["\xBC\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\x54\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],

        ["\xBC\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xEA"],
        ["\x4F\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],

        ["\xBC\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB8"],
        ["\x4E\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],

        ["\xBC\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\x4A\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],

        ["\xBC\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\x54\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],

        ["\xBC\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\x4C\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],

        ["\xBC\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC1"],
        ["\x54\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],

        ["\xBC\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\x54\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],

        ["\xBC\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA9"],
        ["\x53\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],

        ["\xBC\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBB"],
        ["\x52\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],

        ["\xBC\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\x4D\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],

        ["\xBC\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\x52\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],

        ["\xBC\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD6"],
        ["\x46\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],

        ["\xBC\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\x4F\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],

        ["\xBC\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\x4B\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],

        ["\xBC\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\x54\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],

        ["\xBC\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\x47\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],

        ["\xBC\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA6"],
        ["\x46\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],

        ["\xBC\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF0"],
        ["\x46\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],

        ["\xBC\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\x45\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],

        ["\xBC\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\x4D\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],

        ["\xBC\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\x48\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],

        ["\xBC\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\x4A\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],

        ["\xBC\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x99"],
        ["\x4B\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],

        ["\xBC\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x92"],
        ["\x46\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],

        ["\xBC\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCE"],
        ["\x51\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],

        ["\xBC\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xED"],
        ["\x4C\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],

        ["\xBC\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\x47\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],

        ["\xBC\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBE"],
        ["\x49\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],

        ["\xBC\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\x54\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],

        ["\xBC\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\x48\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],

        ["\xBC\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8D"],
        ["\x54\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],

        ["\xBC\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB2"],
        ["\x46\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],

        ["\xBC\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\x4C\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],

        ["\xBC\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCF"],
        ["\x46\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],

        ["\xBC\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\x51\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],

        ["\xBC\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xFB"],
        ["\x47\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],

        ["\xBC\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\x50\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],

        ["\xBC\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x91"],
        ["\x47\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],

        ["\xBC\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA1"],
        ["\x48\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],

        ["\xBD\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDD"],
        ["\x47\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],

        ["\xBD\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xEE"],
        ["\x4B\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],

        ["\xBD\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\x47\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],

        ["\xBD\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDE"],
        ["\x46\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],

        ["\xBD\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x82"],
        ["\x52\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],

        ["\xBD\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD7"],
        ["\x4D\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],

        ["\xBD\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\x4B\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],

        ["\xBD\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF1"],
        ["\x45\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],

        ["\xBD\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\x46\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],

        ["\xBD\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF4"],
        ["\x49\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],

        ["\xBD\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDA"],
        ["\x52\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],

        ["\xBD\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\x4A\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],

        ["\xBD\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB3"],
        ["\x4D\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],

        ["\xBD\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB8"],
        ["\x4B\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],

        ["\xBD\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x93"],
        ["\x4F\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],

        ["\xBD\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x88"],
        ["\x4B\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],

        ["\xBD\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDF"],
        ["\x4D\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],

        ["\xBD\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xFE"],
        ["\x53\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],

        ["\xBD\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF6"],
        ["\x52\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],

        ["\xBD\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA6"],
        ["\x55\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],

        ["\xBD\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\x4A\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],

        ["\xBD\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\x55\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\xBD\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\x51\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],

        ["\xBD\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA0"],
        ["\x47\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],

        ["\xBD\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\x53\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],

        ["\xBD\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD9"],
        ["\x53\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],

        ["\xBD\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE0"],
        ["\x46\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],

        ["\xBD\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\x48\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],

        ["\xBD\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\x45\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],

        ["\xBD\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xFB"],
        ["\x48\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],

        ["\xBD\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7F"],
        ["\x51\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],

        ["\xBD\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xEA"],
        ["\x4D\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],

        ["\xBD\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x84"],
        ["\x4D\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],

        ["\xBD\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x92"],
        ["\x48\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],

        ["\xBD\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\x4F\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],

        ["\xBD\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x93"],
        ["\x4E\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],

        ["\xBD\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\x45\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],

        ["\xBD\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\x4C\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],

        ["\xBD\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA5"],
        ["\x4F\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],

        ["\xBD\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDD"],
        ["\x54\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],

        ["\xBD\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x82"],
        ["\x48\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],

        ["\xBD\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBF"],
        ["\x4A\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],

        ["\xBD\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\x4C\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],

        ["\xBD\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF7"],
        ["\x49\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],

        ["\xBD\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\x4F\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],

        ["\xBD\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\x52\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],

        ["\xBD\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBF"],
        ["\x4E\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],

        ["\xBD\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9B"],
        ["\x45\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],

        ["\xBD\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\x48\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],

        ["\xBD\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\x4A\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],

        ["\xBD\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\x46\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],

        ["\xBD\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\x50\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],

        ["\xBD\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\x46\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],

        ["\xBD\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB0"],
        ["\x4D\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],

        ["\xBD\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\x54\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],

        ["\xBD\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB8"],
        ["\x4F\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],

        ["\xBD\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\x4C\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],

        ["\xBD\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\x4F\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],

        ["\xBD\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF5"],
        ["\x4E\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],

        ["\xBD\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\x4D\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],

        ["\xBD\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAE"],
        ["\x4F\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],

        ["\xBD\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA4"],
        ["\x53\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],

        ["\xBD\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x94"],
        ["\x48\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],

        ["\xBD\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCE"],
        ["\x46\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],

        ["\xBD\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\x4A\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],

        ["\xBD\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x82"],
        ["\x50\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],

        ["\xBD\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA6"],
        ["\x47\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],

        ["\xBD\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\x4D\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],

        ["\xBD\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\x52\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],

        ["\xBD\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA9"],
        ["\x51\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],

        ["\xBD\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB2"],
        ["\x47\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],

        ["\xBD\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE6"],
        ["\x48\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],

        ["\xBD\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\x47\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],

        ["\xBD\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8C"],
        ["\x45\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],

        ["\xBD\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBE"],
        ["\x4F\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],

        ["\xBD\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\x51\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],

        ["\xBD\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\x50\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],

        ["\xBD\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\x50\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],

        ["\xBD\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\x4A\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],

        ["\xBD\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x99"],
        ["\x4C\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],

        ["\xBD\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9D"],
        ["\x47\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],

        ["\xBD\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF9"],
        ["\x53\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],

        ["\xBD\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE2"],
        ["\x55\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],

        ["\xBD\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE2"],
        ["\x47\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],

        ["\xBD\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\x46\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],

        ["\xBD\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\x50\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],

        ["\xBD\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x99"],
        ["\x46\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],

        ["\xBD\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\x4D\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],

        ["\xBD\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB3"],
        ["\x50\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],

        ["\xBD\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x98"],
        ["\x52\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],

        ["\xBD\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC0"],
        ["\x52\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],

        ["\xBD\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\x49\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],

        ["\xBD\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\x4C\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],

        ["\xBD\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA2"],
        ["\x4A\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],

        ["\xBE\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB5"],
        ["\x45\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],

        ["\xBE\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\x4E\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],

        ["\xBE\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\x4E\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],

        ["\xBE\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x86"],
        ["\x4F\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],

        ["\xBE\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\x55\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],

        ["\xBE\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBE"],
        ["\x46\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],

        ["\xBE\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\x4D\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],

        ["\xBE\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xEC"],
        ["\x54\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],

        ["\xBE\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCA"],
        ["\x4E\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],

        ["\xBE\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAF"],
        ["\x53\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],

        ["\xBE\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x98"],
        ["\x54\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],

        ["\xBE\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xEF"],
        ["\x52\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],

        ["\xBE\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\x49\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],

        ["\xBE\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\x45\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],

        ["\xBE\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\x48\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],

        ["\xBE\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\x48\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],

        ["\xBE\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\x48\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],

        ["\xBE\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xED"],
        ["\x4A\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],

        ["\xBE\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\x55\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],

        ["\xBE\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\x49\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],

        ["\xBE\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\x4C\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],

        ["\xBE\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC0"],
        ["\x4E\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],

        ["\xBE\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xFD"],
        ["\x4B\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],

        ["\xBE\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xEC"],
        ["\x4E\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],

        ["\xBE\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8F"],
        ["\x4D\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],

        ["\xBE\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\x46\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],

        ["\xBE\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD1"],
        ["\x46\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],

        ["\xBE\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\x45\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],

        ["\xBE\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\x4A\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],

        ["\xBE\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\x45\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],

        ["\xBE\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAC"],
        ["\x50\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],

        ["\xBE\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9B"],
        ["\x53\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],

        ["\xBE\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x85"],
        ["\x55\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],

        ["\xBE\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC6"],
        ["\x46\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],

        ["\xBE\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\x48\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],

        ["\xBE\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\x4A\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],

        ["\xBE\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\x51\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],

        ["\xBE\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x83"],
        ["\x49\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],

        ["\xBE\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE6"],
        ["\x4D\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],

        ["\xBE\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\x47\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],

        ["\xBE\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\x4E\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],

        ["\xBE\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\x48\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],

        ["\xBE\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\x49\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],

        ["\xBE\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB0"],
        ["\x51\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],

        ["\xBE\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF9"],
        ["\x49\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],

        ["\xBE\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\x4B\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],

        ["\xBE\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\x47\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],

        ["\xBE\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB5"],
        ["\x49\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],

        ["\xBE\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD4"],
        ["\x4B\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],

        ["\xBE\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\x4C\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],

        ["\xBE\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\x52\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],

        ["\xBE\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x80"],
        ["\x51\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],

        ["\xBE\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF8"],
        ["\x53\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],

        ["\xBE\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA8"],
        ["\x53\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],

        ["\xBE\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA5"],
        ["\x4D\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],

        ["\xBE\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA8"],
        ["\x4F\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],

        ["\xBE\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xEF"],
        ["\x50\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],

        ["\xBE\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBA"],
        ["\x49\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],

        ["\xBE\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x88"],
        ["\x4F\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],

        ["\xBE\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE7"],
        ["\x4D\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],

        ["\xBE\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x94"],
        ["\x49\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],

        ["\xBE\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAD"],
        ["\x4A\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],

        ["\xBE\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\x50\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],

        ["\xBE\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB4"],
        ["\x4F\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],

        ["\xBE\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBD"],
        ["\x53\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],

        ["\xBE\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\x4C\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],

        ["\xBE\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF9"],
        ["\x4B\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],

        ["\xBE\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE7"],
        ["\x52\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],

        ["\xBE\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\x45\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],

        ["\xBE\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD3"],
        ["\x49\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],

        ["\xBE\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\x4F\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],

        ["\xBE\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\x49\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],

        ["\xBE\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\x52\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],

        ["\xBE\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x85"],
        ["\x4D\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],

        ["\xBE\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\x45\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],

        ["\xBE\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD9"],
        ["\x45\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],

        ["\xBE\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x96"],
        ["\x51\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],

        ["\xBE\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE4"],
        ["\x4D\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],

        ["\xBE\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\x46\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],

        ["\xBE\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\x48\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],

        ["\xBE\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF6"],
        ["\x55\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],

        ["\xBE\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\x47\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],

        ["\xBE\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\x50\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],

        ["\xBE\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\x4C\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],

        ["\xBE\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\x48\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],

        ["\xBE\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\x4E\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],

        ["\xBE\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x98"],
        ["\x4E\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],

        ["\xBE\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBA"],
        ["\x4A\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],

        ["\xBE\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\x4B\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],

        ["\xBE\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\x50\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],

        ["\xBE\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\x4E\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],

        ["\xBE\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCA"],
        ["\x50\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],

        ["\xBE\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\x4F\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],

        ["\xBE\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\x49\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],

        ["\xBF\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE5"],
        ["\x4E\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],

        ["\xBF\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC5"],
        ["\x47\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],

        ["\xBF\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\x4E\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],

        ["\xBF\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE6"],
        ["\x54\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],

        ["\xBF\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9A"],
        ["\x48\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],

        ["\xBF\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD7"],
        ["\x48\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],

        ["\xBF\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC3"],
        ["\x47\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],

        ["\xBF\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\x4C\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],

        ["\xBF\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB8"],
        ["\x46\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],

        ["\xBF\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\x53\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],

        ["\xBF\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE5"],
        ["\x52\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],

        ["\xBF\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCE"],
        ["\x49\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],

        ["\xBF\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF4"],
        ["\x46\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],

        ["\xBF\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\x45\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],

        ["\xBF\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8C"],
        ["\x4F\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],

        ["\xBF\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\x4F\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],

        ["\xBF\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\x52\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],

        ["\xBF\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\x4B\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],

        ["\xBF\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x87"],
        ["\x49\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],

        ["\xBF\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE7"],
        ["\x46\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],

        ["\xBF\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\x4A\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],

        ["\xBF\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF6"],
        ["\x48\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],

        ["\xBF\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x87"],
        ["\x45\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],

        ["\xBF\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB2"],
        ["\x4B\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],

        ["\xBF\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\x45\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],

        ["\xBF\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\x4D\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],

        ["\xBF\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\x4D\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],

        ["\xBF\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\x47\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],

        ["\xBF\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\x49\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],

        ["\xBF\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE1"],
        ["\x54\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],

        ["\xBF\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\x46\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],

        ["\xBF\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA1"],
        ["\x45\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],

        ["\xBF\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8A"],
        ["\x4C\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],

        ["\xBF\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\x4E\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],

        ["\xBF\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\x4A\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],

        ["\xBF\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\x4F\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],

        ["\xBF\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\x54\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],

        ["\xBF\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x85"],
        ["\x48\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],

        ["\xBF\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\x4D\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],

        ["\xBF\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9C"],
        ["\x47\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],

        ["\xBF\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\x4D\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],

        ["\xBF\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\x46\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],

        ["\xBF\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x88"],
        ["\x49\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],

        ["\xBF\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDE"],
        ["\x4D\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],

        ["\xBF\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x93"],
        ["\x45\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],

        ["\xBF\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\x47\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\xBF\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\x4F\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],

        ["\xBF\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x89"],
        ["\x4D\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],

        ["\xBF\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\x51\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],

        ["\xBF\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\x4D\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],

        ["\xBF\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\x4B\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],

        ["\xBF\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB9"],
        ["\x4F\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],

        ["\xBF\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC4"],
        ["\x52\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],

        ["\xBF\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\x50\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],

        ["\xBF\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\x50\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],

        ["\xBF\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x84"],
        ["\x4C\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],

        ["\xBF\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\x66\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],

        ["\xBF\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\x52\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],

        ["\xBF\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC1"],
        ["\x4B\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],

        ["\xBF\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB0"],
        ["\x46\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],

        ["\xBF\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAE"],
        ["\x4B\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],

        ["\xBF\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC1"],
        ["\x47\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],

        ["\xBF\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\x51\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],

        ["\xBF\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB3"],
        ["\x4F\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],

        ["\xBF\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC4"],
        ["\x49\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],

        ["\xBF\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC9"],
        ["\x4B\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],

        ["\xBF\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAF"],
        ["\x52\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],

        ["\xBF\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD5"],
        ["\x48\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],

        ["\xBF\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9C"],
        ["\x45\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],

        ["\xBF\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCB"],
        ["\x4F\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],

        ["\xBF\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\x52\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],

        ["\xBF\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCC"],
        ["\x4F\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],

        ["\xBF\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\x4F\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],

        ["\xBF\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x54"],
        ["\x4F\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],

        ["\xBF\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\x4C\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],

        ["\xBF\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\x4E\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],

        ["\xBF\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x90"],
        ["\x53\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],

        ["\xBF\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xEF"],
        ["\x54\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],

        ["\xBF\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\x4E\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],

        ["\xBF\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\x4B\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],

        ["\xBF\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC5"],
        ["\x52\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],

        ["\xBF\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\x4C\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],

        ["\xBF\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9E"],
        ["\x50\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],

        ["\xBF\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCC"],
        ["\x46\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],

        ["\xBF\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD0"],
        ["\x52\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],

        ["\xBF\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\x55\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],

        ["\xBF\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xFB"],
        ["\x51\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],

        ["\xBF\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD6"],
        ["\x4E\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],

        ["\xBF\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\x46\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],

        ["\xBF\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\x4F\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],

        ["\xBF\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\x47\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],

        ["\xBF\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE4"],
        ["\x55\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],

        ["\xBF\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\x4F\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],

        ["\xBF\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8D"],
        ["\x4C\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],

        ["\xC0\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x87"],
        ["\x48\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],

        ["\xC0\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xEF"],
        ["\x51\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],

        ["\xC0\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\x4B\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],

        ["\xC0\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9B"],
        ["\x46\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],

        ["\xC0\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\x46\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],

        ["\xC0\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x86"],
        ["\x50\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],

        ["\xC0\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBB"],
        ["\x4B\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],

        ["\xC0\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDC"],
        ["\x52\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],

        ["\xC0\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\x46\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],

        ["\xC0\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xEE"],
        ["\x47\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],

        ["\xC0\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\x4F\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],

        ["\xC0\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\x4A\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],

        ["\xC0\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\x46\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],

        ["\xC0\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBA"],
        ["\x45\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],

        ["\xC0\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC7"],
        ["\x45\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],

        ["\xC0\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\x47\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],

        ["\xC0\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA9"],
        ["\x47\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],

        ["\xC0\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x95"],
        ["\x47\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],

        ["\xC0\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\x53\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],

        ["\xC0\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\x4D\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],

        ["\xC0\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\x45\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],

        ["\xC0\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x96"],
        ["\x45\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],

        ["\xC0\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\x51\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],

        ["\xC0\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x99"],
        ["\x45\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],

        ["\xC0\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\x48\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],

        ["\xC0\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\x46\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],

        ["\xC0\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB5"],
        ["\x4B\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],

        ["\xC0\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\x49\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],

        ["\xC0\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\x45\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],

        ["\xC0\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\x45\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],

        ["\xC0\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\x46\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],

        ["\xC0\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\x4F\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],

        ["\xC0\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\x4A\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],

        ["\xC0\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB1"],
        ["\x53\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],

        ["\xC0\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\x53\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],

        ["\xC0\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\x46\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],

        ["\xC0\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\x46\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],

        ["\xC0\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8E"],
        ["\x46\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],

        ["\xC0\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC4"],
        ["\x47\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],

        ["\xC0\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xEC"],
        ["\x55\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],

        ["\xC0\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDA"],
        ["\x4F\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],

        ["\xC0\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\x4B\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],

        ["\xC0\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD7"],
        ["\x4E\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],

        ["\xC0\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x95"],
        ["\x55\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],

        ["\xC0\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\x51\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],

        ["\xC0\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\x4C\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],

        ["\xC0\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\x4A\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],

        ["\xC0\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x80"],
        ["\x45\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],

        ["\xC0\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x91"],
        ["\x48\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],

        ["\xC0\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xFE"],
        ["\x4D\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],

        ["\xC0\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\x48\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],

        ["\xC0\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\x53\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],

        ["\xC0\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD2"],
        ["\x4B\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],

        ["\xC0\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF9"],
        ["\x46\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],

        ["\xC0\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCD"],
        ["\x4C\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],

        ["\xC0\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\x53\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],

        ["\xC0\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\x50\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],

        ["\xC0\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\x47\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],

        ["\xC0\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\x52\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],

        ["\xC0\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA8"],
        ["\x47\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],

        ["\xC0\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8C"],
        ["\x4E\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],

        ["\xC0\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8D"],
        ["\x49\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],

        ["\xC0\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\x45\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],

        ["\xC0\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\x51\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],

        ["\xC0\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA1"],
        ["\x47\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],

        ["\xC0\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\x49\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],

        ["\xC0\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBB"],
        ["\x49\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],

        ["\xC0\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\x4A\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],

        ["\xC0\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x94"],
        ["\x50\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],

        ["\xC0\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE8"],
        ["\x53\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],

        ["\xC0\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA2"],
        ["\x48\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],

        ["\xC0\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA2"],
        ["\x47\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],

        ["\xC0\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\x45\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],

        ["\xC0\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xEE"],
        ["\x49\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],

        ["\xC0\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8F"],
        ["\x49\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],

        ["\xC0\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xFB"],
        ["\x49\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],

        ["\xC0\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\x53\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],

        ["\xC0\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\x45\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],

        ["\xC0\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\x47\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],

        ["\xC0\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCA"],
        ["\x4D\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],

        ["\xC0\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\x53\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],

        ["\xC0\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\x50\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],

        ["\xC0\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDA"],
        ["\x55\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],

        ["\xC0\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\x46\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],

        ["\xC0\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8D"],
        ["\x46\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],

        ["\xC0\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\x4A\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],

        ["\xC0\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9B"],
        ["\x48\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],

        ["\xC0\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\x4D\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],

        ["\xC0\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x90"],
        ["\x54\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],

        ["\xC0\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x90"],
        ["\x55\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],

        ["\xC0\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\x4D\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],

        ["\xC0\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x91"],
        ["\x4E\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],

        ["\xC0\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8D"],
        ["\x51\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],

        ["\xC0\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x87"],
        ["\x46\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],

        ["\xC1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\x48\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x96"],
        ["\x55\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],

        ["\xC1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\x52\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],

        ["\xC1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\x4F\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],

        ["\xC1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\x46\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],

        ["\xC1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBF"],
        ["\x4F\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],

        ["\xC1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8E"],
        ["\x51\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],

        ["\xC1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\x64\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],

        ["\xC1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\x50\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],

        ["\xC1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\x48\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],

        ["\xC1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\x53\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\x4D\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],

        ["\xC1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAD"],
        ["\x4C\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],

        ["\xC1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9C"],
        ["\x51\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],

        ["\xC1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\x4C\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],

        ["\xC1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAF"],
        ["\x45\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB3"],
        ["\x46\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],

        ["\xC1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\x4D\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],

        ["\xC1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xEF"],
        ["\x47\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],

        ["\xC1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB1"],
        ["\x46\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],

        ["\xC1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x87"],
        ["\x4F\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],

        ["\xC1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\x51\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],

        ["\xC1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\x50\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],

        ["\xC1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\x51\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],

        ["\xC1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\x50\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],

        ["\xC1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC6"],
        ["\x4E\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],

        ["\xC1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB9"],
        ["\x54\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],

        ["\xC1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\x4A\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],

        ["\xC1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\x51\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],

        ["\xC1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\x49\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],

        ["\xC1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\x53\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],

        ["\xC1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCF"],
        ["\x4E\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB0"],
        ["\x55\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\x51\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\x4C\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDC"],
        ["\x4C\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x83"],
        ["\x4D\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\x4D\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x9F"],
        ["\x47\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB9"],
        ["\x46\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBF"],
        ["\x4C\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDF"],
        ["\x4C\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],

        ["\xC1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xEF"],
        ["\x4F\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],

        ["\xC1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\x54\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],

        ["\xC1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCB"],
        ["\x50\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],

        ["\xC1\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x84"],
        ["\x4E\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],

        ["\xC1\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE1"],
        ["\x4B\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],

        ["\xC1\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\x4B\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF5"],
        ["\x53\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD6"],
        ["\x45\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\x51\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9F"],
        ["\x4C\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\x4C\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDD"],
        ["\x52\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\x52\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8E"],
        ["\x4A\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB7"],
        ["\x51\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\x4B\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],

        ["\xC1\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB3"],
        ["\x48\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],

        ["\xC1\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDD"],
        ["\x4D\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],

        ["\xC1\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC3"],
        ["\x4D\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],

        ["\xC1\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\x55\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],

        ["\xC1\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA3"],
        ["\x54\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],

        ["\xC1\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9B"],
        ["\x49\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE9"],
        ["\x46\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],

        ["\xC1\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD2"],
        ["\x4E\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\x4C\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDB"],
        ["\x52\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB7"],
        ["\x4D\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA1"],
        ["\x54\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\x4C\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x96"],
        ["\x48\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA4"],
        ["\x54\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\x46\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],

        ["\xC1\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE9"],
        ["\x4B\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],

        ["\xC1\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8C"],
        ["\x51\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],

        ["\xC1\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x93"],
        ["\x47\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],

        ["\xC1\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\x50\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],

        ["\xC1\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x89"],
        ["\x4B\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],

        ["\xC1\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\x48\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\x4B\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\x4F\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB9"],
        ["\x50\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\x50\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x98"],
        ["\x48\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAA"],
        ["\x4A\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\x47\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\x51\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x97"],
        ["\x51\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE8"],
        ["\x4D\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],

        ["\xC1\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD2"],
        ["\x4D\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],

        ["\xC1\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBA"],
        ["\x4B\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],

        ["\xC1\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\x46\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],

        ["\xC1\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\x4F\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],

        ["\xC2\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBD"],
        ["\x4D\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC2\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\x46\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],

        ["\xC2\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\x4C\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],

        ["\xC2\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB8"],
        ["\x45\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],

        ["\xC2\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\x4A\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],

        ["\xC2\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\x49\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],

        ["\xC2\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\x47\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xC2\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\x4B\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xC2\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB0"],
        ["\x4B\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],

        ["\xC2\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA0"],
        ["\x53\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],

        ["\xC2\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\x4B\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\x49\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],

        ["\xC2\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\x46\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],

        ["\xC2\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\x48\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],

        ["\xC2\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x97"],
        ["\x4E\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],

        ["\xC2\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\x47\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xFD"],
        ["\x4F\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC2\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDC"],
        ["\x4A\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],

        ["\xC2\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCB"],
        ["\x47\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],

        ["\xC2\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\x4A\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xC2\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\x4A\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],

        ["\xC2\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\x4F\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xC2\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xFD"],
        ["\x4E\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],

        ["\xC2\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\x4A\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],

        ["\xC2\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\x4C\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],

        ["\xC2\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xEF"],
        ["\x4C\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],

        ["\xC2\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD8"],
        ["\x4B\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],

        ["\xC2\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\x45\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],

        ["\xC2\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\x54\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],

        ["\xC2\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\x47\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],

        ["\xC2\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xFE"],
        ["\x45\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],

        ["\xC2\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAB"],
        ["\x45\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\x50\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE3"],
        ["\x55\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\x54\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB0"],
        ["\x53\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9E"],
        ["\x4D\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB8"],
        ["\x54\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xEA"],
        ["\x47\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCD"],
        ["\x55\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDB"],
        ["\x54\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC5"],
        ["\x55\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],

        ["\xC2\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\x4F\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],

        ["\xC2\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE5"],
        ["\x4D\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],

        ["\xC2\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDA"],
        ["\x53\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],

        ["\xC2\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x96"],
        ["\x46\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],

        ["\xC2\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\x53\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],

        ["\xC2\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\x46\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8E"],
        ["\x49\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\x52\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\x49\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA3"],
        ["\x48\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x81"],
        ["\x50\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xFD"],
        ["\x48\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x92"],
        ["\x50\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC3"],
        ["\x4B\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF3"],
        ["\x46\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA1"],
        ["\x4D\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],

        ["\xC2\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\x52\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],

        ["\xC2\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x9A"],
        ["\x52\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],

        ["\xC2\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD7"],
        ["\x52\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],

        ["\xC2\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\x4A\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],

        ["\xC2\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\x4A\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],

        ["\xC2\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\x4B\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\x4F\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],

        ["\xC2\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x93"],
        ["\x4A\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xDD"],
        ["\x51\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\x50\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x9A"],
        ["\x45\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\x47\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\x45\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\x46\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\x51\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xFE"],
        ["\x47\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],

        ["\xC2\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\x4B\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],

        ["\xC2\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xA3"],
        ["\x47\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],

        ["\xC2\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAE"],
        ["\x52\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],

        ["\xC2\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x96"],
        ["\x49\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],

        ["\xC2\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x83"],
        ["\x53\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],

        ["\xC2\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\x48\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD5"],
        ["\x55\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\x4E\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDB"],
        ["\x4B\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x85"],
        ["\x45\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD4"],
        ["\x4D\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\x4E\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB6"],
        ["\x4A\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x88"],
        ["\x53\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBE"],
        ["\x50\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE1"],
        ["\x4F\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],

        ["\xC2\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF7"],
        ["\x4D\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],

        ["\xC2\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8A"],
        ["\x55\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],

        ["\xC2\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\x52\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],

        ["\xC2\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\x4E\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],

        ["\xC3\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\x4F\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC3\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xFE"],
        ["\x4E\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],

        ["\xC3\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA4"],
        ["\x46\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],

        ["\xC3\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDF"],
        ["\x47\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],

        ["\xC3\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBB"],
        ["\x4E\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],

        ["\xC3\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB4"],
        ["\x4A\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],

        ["\xC3\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\x4E\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],

        ["\xC3\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC8"],
        ["\x51\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],

        ["\xC3\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\x54\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],

        ["\xC3\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xEF"],
        ["\x4B\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],

        ["\xC3\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x81"],
        ["\x45\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xFE"],
        ["\x52\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],

        ["\xC3\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\x55\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],

        ["\xC3\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBE"],
        ["\x4B\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],

        ["\xC3\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x83"],
        ["\x4B\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],

        ["\xC3\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAB"],
        ["\x48\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\x48\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],

        ["\xC3\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\x50\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],

        ["\xC3\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\x51\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],

        ["\xC3\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\x4A\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],

        ["\xC3\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7F"],
        ["\x4B\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],

        ["\xC3\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9D"],
        ["\x4D\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],

        ["\xC3\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x87"],
        ["\x54\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xC3\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA5"],
        ["\x4C\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],

        ["\xC3\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF3"],
        ["\x53\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],

        ["\xC3\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\x48\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],

        ["\xC3\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x82"],
        ["\x4A\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],

        ["\xC3\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xEF"],
        ["\x48\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],

        ["\xC3\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCA"],
        ["\x54\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],

        ["\xC3\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA6"],
        ["\x54\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],

        ["\xC3\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB8"],
        ["\x55\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],

        ["\xC3\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9B"],
        ["\x4E\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD8"],
        ["\x53\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA2"],
        ["\x4F\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC7"],
        ["\x48\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF0"],
        ["\x47\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8E"],
        ["\x4E\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\x4A\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x89"],
        ["\x49\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\x4D\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\x4F\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xED"],
        ["\x47\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],

        ["\xC3\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\x45\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],

        ["\xC3\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\x49\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],

        ["\xC3\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\x48\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],

        ["\xC3\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB0"],
        ["\x45\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],

        ["\xC3\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC2"],
        ["\x45\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],

        ["\xC3\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x97"],
        ["\x55\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\x4E\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA8"],
        ["\x46\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE8"],
        ["\x45\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x89"],
        ["\x50\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCF"],
        ["\x4D\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8C"],
        ["\x46\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\x4C\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDC"],
        ["\x54\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\x4C\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDF"],
        ["\x52\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],

        ["\xC3\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA8"],
        ["\x49\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],

        ["\xC3\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\x4D\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],

        ["\xC3\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF5"],
        ["\x45\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],

        ["\xC3\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\x4B\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],

        ["\xC3\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x94"],
        ["\x4C\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],

        ["\xC3\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBB"],
        ["\x50\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9F"],
        ["\x4D\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],

        ["\xC3\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\x4F\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\x49\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\x55\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAA"],
        ["\x47\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\x45\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\x48\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\x4D\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\x46\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\x4D\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],

        ["\xC3\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x98"],
        ["\x4C\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],

        ["\xC3\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xEA"],
        ["\x4B\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],

        ["\xC3\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\x49\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],

        ["\xC3\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCB"],
        ["\x4B\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],

        ["\xC3\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE9"],
        ["\x52\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],

        ["\xC3\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\x4F\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x91"],
        ["\x55\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC1"],
        ["\x48\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF5"],
        ["\x4D\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8B"],
        ["\x53\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDE"],
        ["\x4F\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC5"],
        ["\x49\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\x54\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\x4A\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\x4C\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCE"],
        ["\x4B\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],

        ["\xC3\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF3"],
        ["\x4D\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],

        ["\xC3\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF9"],
        ["\x55\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],

        ["\xC3\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\x55\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],

        ["\xC3\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\x55\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],

        ["\xC4\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\x51\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC4\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC5"],
        ["\x4D\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],

        ["\xC4\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x92"],
        ["\x4B\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],

        ["\xC4\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\x51\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],

        ["\xC4\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBA"],
        ["\x48\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],

        ["\xC4\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x86"],
        ["\x4E\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],

        ["\xC4\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\x4C\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],

        ["\xC4\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\x51\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],

        ["\xC4\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDB"],
        ["\x4F\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],

        ["\xC4\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\x4C\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],

        ["\xC4\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\x47\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x93"],
        ["\x4C\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],

        ["\xC4\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDD"],
        ["\x55\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],

        ["\xC4\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\x45\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],

        ["\xC4\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\x4E\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],

        ["\xC4\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA8"],
        ["\x4D\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE9"],
        ["\x55\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],

        ["\xC4\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB6"],
        ["\x4D\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],

        ["\xC4\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\x4E\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],

        ["\xC4\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x89"],
        ["\x46\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],

        ["\xC4\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\x55\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],

        ["\xC4\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\x4A\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],

        ["\xC4\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB4"],
        ["\x50\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],

        ["\xC4\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x80"],
        ["\x4E\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],

        ["\xC4\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x83"],
        ["\x45\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],

        ["\xC4\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\x4D\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],

        ["\xC4\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\x47\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],

        ["\xC4\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xEF"],
        ["\x4E\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],

        ["\xC4\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\x55\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],

        ["\xC4\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\x46\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],

        ["\xC4\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF3"],
        ["\x55\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],

        ["\xC4\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x8F"],
        ["\x4C\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\x4D\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\x4B\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x89"],
        ["\x4C\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\x4E\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\x45\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\x51\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA0"],
        ["\x4B\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xFA"],
        ["\x4E\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD1"],
        ["\x49\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xFE"],
        ["\x54\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],

        ["\xC4\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\x4C\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],

        ["\xC4\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE3"],
        ["\x45\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],

        ["\xC4\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\x46\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],

        ["\xC4\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD1"],
        ["\x52\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],

        ["\xC4\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCD"],
        ["\x54\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],

        ["\xC4\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\x4B\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDF"],
        ["\x4E\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x8A"],
        ["\x4E\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\x4F\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\xC4\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF5"],
        ["\x47\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],

        ["\xC4\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\x4F\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC9"],
        ["\x4D\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAA"],
        ["\x54\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xBA"],
        ["\x4C\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\x54\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\x49\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],

        ["\xC4\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9B"],
        ["\x58\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],

        ["\xC4\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xEA"],
        ["\x52\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],

        ["\xC4\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x92"],
        ["\x55\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],

        ["\xC4\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x87"],
        ["\x4C\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],

        ["\xC4\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD3"],
        ["\x53\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],

        ["\xC4\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\x4C\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\x47\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],

        ["\xC4\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\x4E\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA4"],
        ["\x48\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\x4E\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x95"],
        ["\x4F\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\x53\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB6"],
        ["\x46\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x56"],
        ["\x4F\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\x4B\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xC4\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE7"],
        ["\x45\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],

        ["\xC4\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9C"],
        ["\x48\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],

        ["\xC4\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\x4B\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],

        ["\xC4\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE0"],
        ["\x48\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],

        ["\xC4\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\x50\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],

        ["\xC4\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\x4C\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],

        ["\xC4\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE3"],
        ["\x4D\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x90"],
        ["\x4B\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x87"],
        ["\x53\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB9"],
        ["\x49\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE4"],
        ["\x51\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\x53\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x95"],
        ["\x51\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xA7"],
        ["\x4B\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF4"],
        ["\x47\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\x4A\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xFC"],
        ["\x4D\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],

        ["\xC4\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\x4F\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],

        ["\xC4\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\x52\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],

        ["\xC4\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA7"],
        ["\x55\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],

        ["\xC4\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\x51\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],

        ["\xC5\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x81"],
        ["\x4D\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC5\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\x51\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],

        ["\xC5\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\x4F\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],

        ["\xC5\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAA"],
        ["\x51\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],

        ["\xC5\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\x4E\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],

        ["\xC5\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xCB"],
        ["\x4D\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],

        ["\xC5\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\x55\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],

        ["\xC5\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF3"],
        ["\x4B\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],

        ["\xC5\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB7"],
        ["\x4F\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],

        ["\xC5\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xEF"],
        ["\x45\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],

        ["\xC5\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\x4F\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCC"],
        ["\x49\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],

        ["\xC5\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\x50\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],

        ["\xC5\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x97"],
        ["\x54\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],

        ["\xC5\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\x47\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],

        ["\xC5\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF8"],
        ["\x48\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\x4E\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],

        ["\xC5\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xEE"],
        ["\x54\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],

        ["\xC5\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDF"],
        ["\x53\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],

        ["\xC5\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD7"],
        ["\x45\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],

        ["\xC5\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\x47\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],

        ["\xC5\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\x4F\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],

        ["\xC5\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x8A"],
        ["\x46\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],

        ["\xC5\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDD"],
        ["\x48\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],

        ["\xC5\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\x48\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],

        ["\xC5\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x91"],
        ["\x4A\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],

        ["\xC5\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xFA"],
        ["\x55\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],

        ["\xC5\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA7"],
        ["\x52\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],

        ["\xC5\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\x50\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],

        ["\xC5\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\x47\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],

        ["\xC5\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC1"],
        ["\x55\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],

        ["\xC5\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x88"],
        ["\x47\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD9"],
        ["\x48\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\x48\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x89"],
        ["\x55\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\x45\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x82"],
        ["\x45\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\x50\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB2"],
        ["\x4E\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF6"],
        ["\x54\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\x48\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7F"],
        ["\x53\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],

        ["\xC5\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xFB"],
        ["\x53\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],

        ["\xC5\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\x4C\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],

        ["\xC5\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x83"],
        ["\x4E\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],

        ["\xC5\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\x52\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],

        ["\xC5\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\x45\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],

        ["\xC5\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE8"],
        ["\x46\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD4"],
        ["\x53\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC1"],
        ["\x52\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF0"],
        ["\x48\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\x45\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\x55\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\x4D\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xC5\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDF"],
        ["\x50\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xC5\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\x4A\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\x45\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x84"],
        ["\x46\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],

        ["\xC5\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x90"],
        ["\x4D\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],

        ["\xC5\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\x4C\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],

        ["\xC5\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\x4B\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],

        ["\xC5\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\x49\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],

        ["\xC5\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDE"],
        ["\x4B\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],

        ["\xC5\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE6"],
        ["\x4B\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\x4C\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],

        ["\xC5\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAB"],
        ["\x4B\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCB"],
        ["\x4C\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF8"],
        ["\x52\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x83"],
        ["\x55\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\xC5\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\x51\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\xC5\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\x45\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD1"],
        ["\x47\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\x51\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\x47\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],

        ["\xC5\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8F"],
        ["\x52\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],

        ["\xC5\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\x45\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],

        ["\xC5\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDA"],
        ["\x4A\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],

        ["\xC5\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\x5C\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],

        ["\xC5\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA9"],
        ["\x4E\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],

        ["\xC5\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\x4D\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE1"],
        ["\x55\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBD"],
        ["\x48\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xC5\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\x5D\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xC5\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\x4B\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF8"],
        ["\x4E\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xC5\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\x46\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],

        ["\xC5\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\x55\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\x55\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA7"],
        ["\x46\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD0"],
        ["\x49\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],

        ["\xC5\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\x4B\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],

        ["\xC5\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x84"],
        ["\x48\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],

        ["\xC5\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x81"],
        ["\x48\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],

        ["\xC5\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xDD"],
        ["\x4C\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],

        ["\xC6\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\x50\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC6\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF0"],
        ["\x54\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],

        ["\xC6\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\x45\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],

        ["\xC6\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD2"],
        ["\x49\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],

        ["\xC6\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\x4F\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],

        ["\xC6\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x99"],
        ["\x4A\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],

        ["\xC6\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\x4D\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],

        ["\xC6\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\x4C\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],

        ["\xC6\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDA"],
        ["\x4B\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],

        ["\xC6\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCF"],
        ["\x52\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],

        ["\xC6\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB7"],
        ["\x4A\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xEB"],
        ["\x47\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],

        ["\xC6\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\x4E\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],

        ["\xC6\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCC"],
        ["\x4B\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],

        ["\xC6\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xEC"],
        ["\x48\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],

        ["\xC6\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE4"],
        ["\x45\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\x46\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],

        ["\xC6\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7F"],
        ["\x49\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],

        ["\xC6\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAE"],
        ["\x48\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],

        ["\xC6\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC2"],
        ["\x53\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],

        ["\xC6\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xDB"],
        ["\x55\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],

        ["\xC6\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x98"],
        ["\x4D\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],

        ["\xC6\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\x4F\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],

        ["\xC6\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\x4D\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],

        ["\xC6\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAB"],
        ["\x4E\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],

        ["\xC6\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF7"],
        ["\x54\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],

        ["\xC6\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\x45\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],

        ["\xC6\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC0"],
        ["\x48\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],

        ["\xC6\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x96"],
        ["\x4F\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],

        ["\xC6\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\x51\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],

        ["\xC6\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\x50\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],

        ["\xC6\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE8"],
        ["\x47\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\x46\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\x55\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xA2"],
        ["\x46\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\x4A\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD0"],
        ["\x53\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\x4A\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x97"],
        ["\x4C\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDB"],
        ["\x4A\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\x4A\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD3"],
        ["\x47\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],

        ["\xC6\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD4"],
        ["\x55\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],

        ["\xC6\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCF"],
        ["\x50\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],

        ["\xC6\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xFD"],
        ["\x4A\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],

        ["\xC6\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA7"],
        ["\x54\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],

        ["\xC6\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA7"],
        ["\x4D\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],

        ["\xC6\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\x54\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\x4D\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x84"],
        ["\x4A\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\x4F\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\x53\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF1"],
        ["\x55\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDD"],
        ["\x4F\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\x4E\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\x49\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x98"],
        ["\x55\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCF"],
        ["\x4C\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],

        ["\xC6\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\x54\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],

        ["\xC6\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\x51\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],

        ["\xC6\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB0"],
        ["\x50\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],

        ["\xC6\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\x4C\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],

        ["\xC6\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\x4E\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],

        ["\xC6\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE6"],
        ["\x45\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\x48\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],

        ["\xC6\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8E"],
        ["\x45\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA9"],
        ["\x55\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9E"],
        ["\x54\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAD"],
        ["\x51\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF9"],
        ["\x52\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x96"],
        ["\x4B\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\x4F\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\x4B\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x93"],
        ["\x4D\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],

        ["\xC6\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA1"],
        ["\x50\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],

        ["\xC6\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\x48\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],

        ["\xC6\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDD"],
        ["\x50\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],

        ["\xC6\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\x45\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],

        ["\xC6\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xDF"],
        ["\x4A\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],

        ["\xC6\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB1"],
        ["\x4C\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\x49\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\x55\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\x45\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x86"],
        ["\x4A\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE1"],
        ["\x50\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xC6\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\x64\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xC6\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCB"],
        ["\x4E\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9E"],
        ["\x53\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\x4A\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB6"],
        ["\x51\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],

        ["\xC6\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\x51\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],

        ["\xC6\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\x45\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],

        ["\xC6\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x98"],
        ["\x4A\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],

        ["\xC6\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\x46\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],

        ["\xC7\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF8"],
        ["\x4B\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC7\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\x4C\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],

        ["\xC7\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xDF"],
        ["\x4F\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],

        ["\xC7\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\x4A\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],

        ["\xC7\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\x50\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],

        ["\xC7\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD7"],
        ["\x4B\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],

        ["\xC7\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\x4A\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],

        ["\xC7\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\x50\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],

        ["\xC7\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xFA"],
        ["\x50\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],

        ["\xC7\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x89"],
        ["\x4F\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],

        ["\xC7\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA9"],
        ["\x4F\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\x54\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],

        ["\xC7\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\x4F\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],

        ["\xC7\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD5"],
        ["\x47\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],

        ["\xC7\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\x45\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],

        ["\xC7\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAE"],
        ["\x4A\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC0"],
        ["\x54\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],

        ["\xC7\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\x53\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],

        ["\xC7\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD5"],
        ["\x49\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],

        ["\xC7\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF7"],
        ["\x4B\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],

        ["\xC7\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9F"],
        ["\x4B\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],

        ["\xC7\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\x55\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],

        ["\xC7\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD8"],
        ["\x45\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],

        ["\xC7\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF4"],
        ["\x4D\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],

        ["\xC7\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x90"],
        ["\x51\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],

        ["\xC7\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCD"],
        ["\x4B\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],

        ["\xC7\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCE"],
        ["\x4A\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],

        ["\xC7\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE2"],
        ["\x49\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],

        ["\xC7\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\x47\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],

        ["\xC7\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB3"],
        ["\x4C\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],

        ["\xC7\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\x53\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],

        ["\xC7\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\x48\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xEB"],
        ["\x53\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA2"],
        ["\x55\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\x4E\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE3"],
        ["\x4E\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\x4E\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xFA"],
        ["\x4B\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x80"],
        ["\x52\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xCA"],
        ["\x46\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\x4A\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x9F"],
        ["\x52\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],

        ["\xC7\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBE"],
        ["\x4A\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],

        ["\xC7\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCC"],
        ["\x4E\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],

        ["\xC7\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\x55\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],

        ["\xC7\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\x54\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],

        ["\xC7\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\x46\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],

        ["\xC7\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE1"],
        ["\x4C\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC7"],
        ["\x4B\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE2"],
        ["\x4E\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xFA"],
        ["\x4C\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8A"],
        ["\x4B\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\x4C\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBA"],
        ["\x53\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\x55\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB2"],
        ["\x4A\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\x50\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF4"],
        ["\x4E\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],

        ["\xC7\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF3"],
        ["\x47\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],

        ["\xC7\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\x4A\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],

        ["\xC7\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAC"],
        ["\x4D\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],

        ["\xC7\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x80"],
        ["\x4D\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],

        ["\xC7\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x98"],
        ["\x47\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],

        ["\xC7\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB3"],
        ["\x52\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xEA"],
        ["\x54\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],

        ["\xC7\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD6"],
        ["\x54\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\x49\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\x47\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\x4F\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\x55\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCA"],
        ["\x4F\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xC7\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\x63\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xC7\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8F"],
        ["\x50\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC9"],
        ["\x55\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],

        ["\xC7\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\x49\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],

        ["\xC7\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA6"],
        ["\x49\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],

        ["\xC7\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x81"],
        ["\x54\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],

        ["\xC7\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\x45\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],

        ["\xC7\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBA"],
        ["\x4F\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],

        ["\xC7\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x80"],
        ["\x49\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB8"],
        ["\x4D\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\x46\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE0"],
        ["\x4E\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\x4C\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x87"],
        ["\x4B\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x92"],
        ["\x4A\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xEF"],
        ["\x49\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA6"],
        ["\x52\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8E"],
        ["\x50\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\x4A\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],

        ["\xC7\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE6"],
        ["\x52\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],

        ["\xC7\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB3"],
        ["\x54\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],

        ["\xC7\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE5"],
        ["\x55\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],

        ["\xC7\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\x4A\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],

        ["\xC8\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB6"],
        ["\x4B\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC8\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\x4A\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],

        ["\xC8\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBF"],
        ["\x52\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],

        ["\xC8\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\x50\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],

        ["\xC8\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\x4B\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],

        ["\xC8\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9B"],
        ["\x4D\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],

        ["\xC8\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC5"],
        ["\x51\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],

        ["\xC8\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xDE"],
        ["\x48\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],

        ["\xC8\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\x4E\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],

        ["\xC8\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x8B"],
        ["\x47\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],

        ["\xC8\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xFE"],
        ["\x49\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\x45\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],

        ["\xC8\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\x4E\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],

        ["\xC8\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xFA"],
        ["\x54\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],

        ["\xC8\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\x46\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],

        ["\xC8\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xFA"],
        ["\x51\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\x4C\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],

        ["\xC8\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\x50\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],

        ["\xC8\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x82"],
        ["\x4F\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],

        ["\xC8\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x85"],
        ["\x4A\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],

        ["\xC8\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF5"],
        ["\x52\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],

        ["\xC8\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\x51\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],

        ["\xC8\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x95"],
        ["\x4D\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],

        ["\xC8\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x82"],
        ["\x55\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],

        ["\xC8\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\x4F\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],

        ["\xC8\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC2"],
        ["\x55\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],

        ["\xC8\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD5"],
        ["\x4E\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],

        ["\xC8\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC9"],
        ["\x49\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],

        ["\xC8\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\x49\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],

        ["\xC8\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x90"],
        ["\x47\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],

        ["\xC8\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF9"],
        ["\x47\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],

        ["\xC8\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB2"],
        ["\x55\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\x4F\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC8"],
        ["\x4D\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE4"],
        ["\x52\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB4"],
        ["\x46\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\x55\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\x50\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\x4A\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA7"],
        ["\x4C\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\x50\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDC"],
        ["\x4E\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],

        ["\xC8\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\x47\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],

        ["\xC8\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\x49\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],

        ["\xC8\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\x4F\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],

        ["\xC8\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\x4A\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],

        ["\xC8\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE8"],
        ["\x49\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],

        ["\xC8\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\x53\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA0"],
        ["\x54\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\x55\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xB5"],
        ["\x46\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA8"],
        ["\x52\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB6"],
        ["\x4C\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB9"],
        ["\x48\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x90"],
        ["\x48\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x9C"],
        ["\x4B\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF7"],
        ["\x52\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA5"],
        ["\x53\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],

        ["\xC8\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xED"],
        ["\x55\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],

        ["\xC8\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAD"],
        ["\x53\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],

        ["\xC8\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\x4C\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],

        ["\xC8\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA2"],
        ["\x51\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],

        ["\xC8\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8D"],
        ["\x55\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],

        ["\xC8\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\x47\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x9D"],
        ["\x4C\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],

        ["\xC8\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAD"],
        ["\x50\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\x4C\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA6"],
        ["\x4F\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x80"],
        ["\x4B\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\x47\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xFD"],
        ["\x51\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x97"],
        ["\x4D\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xDA"],
        ["\x49\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\x51\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],

        ["\xC8\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\x4C\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],

        ["\xC8\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\x53\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],

        ["\xC8\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA5"],
        ["\x55\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],

        ["\xC8\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\x49\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],

        ["\xC8\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8D"],
        ["\x4B\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],

        ["\xC8\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF2"],
        ["\x55\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD0"],
        ["\x46\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\x4C\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xE1"],
        ["\x48\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8A"],
        ["\x48\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\x49\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\x51\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAC"],
        ["\x46\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC8"],
        ["\x45\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\x4B\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\x52\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],

        ["\xC8\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD7"],
        ["\x53\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],

        ["\xC8\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA3"],
        ["\x52\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],

        ["\xC8\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\x52\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],

        ["\xC8\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\x45\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],

        ["\xC9\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xFD"],
        ["\x4C\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xC9\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD9"],
        ["\x52\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],

        ["\xC9\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x87"],
        ["\x50\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],

        ["\xC9\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\x4F\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],

        ["\xC9\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA0"],
        ["\x4E\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],

        ["\xC9\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9D"],
        ["\x50\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],

        ["\xC9\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xE1"],
        ["\x45\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],

        ["\xC9\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\x50\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],

        ["\xC9\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\x48\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],

        ["\xC9\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\x52\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],

        ["\xC9\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE0"],
        ["\x52\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\x47\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],

        ["\xC9\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9A"],
        ["\x55\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],

        ["\xC9\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\x4A\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],

        ["\xC9\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAC"],
        ["\x55\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],

        ["\xC9\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\x50\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xC9\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB3"],
        ["\x4A\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],

        ["\xC9\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\x48\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],

        ["\xC9\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\x4F\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],

        ["\xC9\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\x45\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],

        ["\xC9\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA1"],
        ["\x55\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],

        ["\xC9\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB1"],
        ["\x4D\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],

        ["\xC9\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\x51\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],

        ["\xC9\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\x49\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],

        ["\xC9\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA4"],
        ["\x4C\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],

        ["\xC9\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBC"],
        ["\x4F\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],

        ["\xC9\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\x54\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],

        ["\xC9\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBF"],
        ["\x4D\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],

        ["\xC9\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC0"],
        ["\x46\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],

        ["\xC9\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xFD"],
        ["\x49\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],

        ["\xC9\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x93"],
        ["\x55\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],

        ["\xC9\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xAF"],
        ["\x55\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCF"],
        ["\x4B\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xBF"],
        ["\x49\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBA"],
        ["\x4D\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xB8"],
        ["\x4A\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF0"],
        ["\x53\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBE"],
        ["\x55\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\x52\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\x4E\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\x54\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD0"],
        ["\x45\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],

        ["\xC9\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x88"],
        ["\x4E\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],

        ["\xC9\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9D"],
        ["\x51\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],

        ["\xC9\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xEA"],
        ["\x45\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],

        ["\xC9\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD1"],
        ["\x55\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],

        ["\xC9\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xA3"],
        ["\x4D\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],

        ["\xC9\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\x50\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAB"],
        ["\x53\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\x46\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\x4C\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAF"],
        ["\x46\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\x47\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\x51\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\x45\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\x49\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAC"],
        ["\x45\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\x48\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],

        ["\xC9\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\x47\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],

        ["\xC9\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\x45\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],

        ["\xC9\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF0"],
        ["\x4E\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],

        ["\xC9\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\x4D\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],

        ["\xC9\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\x49\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],

        ["\xC9\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC2"],
        ["\x51\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF8"],
        ["\x49\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],

        ["\xC9\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8C"],
        ["\x4A\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCC"],
        ["\x45\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\x4F\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\x4D\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x91"],
        ["\x51\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\x4E\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\x4E\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC8"],
        ["\x49\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\x4F\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],

        ["\xC9\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xEE"],
        ["\x50\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],

        ["\xC9\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x86"],
        ["\x47\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],

        ["\xC9\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8C"],
        ["\x4B\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],

        ["\xC9\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB9"],
        ["\x53\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],

        ["\xC9\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE1"],
        ["\x51\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],

        ["\xC9\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB1"],
        ["\x45\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\xC9\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\x4A\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\x55\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD3"],
        ["\x51\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x95"],
        ["\x45\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\x4D\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x95"],
        ["\x52\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE7"],
        ["\x47\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\x50\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x91"],
        ["\x54\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x83"],
        ["\x4A\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],

        ["\xC9\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\x4B\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],

        ["\xC9\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\x4A\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],

        ["\xC9\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\x4A\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],

        ["\xC9\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD4"],
        ["\x47\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],

        ["\xCA\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8B"],
        ["\x45\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],

        ["\xCA\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\x4C\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],

        ["\xCA\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\x4B\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],

        ["\xCA\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF2"],
        ["\x4D\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],

        ["\xCA\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xEA"],
        ["\x48\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],

        ["\xCA\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAC"],
        ["\x54\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],

        ["\xCA\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x81"],
        ["\x49\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],

        ["\xCA\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAA"],
        ["\x4E\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],

        ["\xCA\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\x4B\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],

        ["\xCA\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\x46\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],

        ["\xCA\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8D"],
        ["\x52\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],

        ["\xCA\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\x45\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],

        ["\xCA\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE5"],
        ["\x53\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],

        ["\xCA\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\x4E\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],

        ["\xCA\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x89"],
        ["\x52\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],

        ["\xCA\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xFC"],
        ["\x4F\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],

        ["\xCA\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB7"],
        ["\x54\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],

        ["\xCA\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\x54\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],

        ["\xCA\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDD"],
        ["\x4E\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],

        ["\xCA\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9E"],
        ["\x48\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],

        ["\xCA\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x92"],
        ["\x54\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],

        ["\xCA\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\x4F\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],

        ["\xCA\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x90"],
        ["\x4F\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],

        ["\xCA\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\x45\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],

        ["\xCA\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\x48\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],

        ["\xCA\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\x50\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],

        ["\xCA\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x94"],
        ["\x4B\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],

        ["\xCA\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\x46\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],

        ["\xCA\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9F"],
        ["\x53\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],

        ["\xCA\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x7F"],
        ["\x4E\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],

        ["\xCA\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x8D"],
        ["\x45\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],

        ["\xCA\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCD"],
        ["\x50\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],

        ["\xCA\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\x4A\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],

        ["\xCA\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\x48\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],

        ["\xCA\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD1"],
        ["\x54\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],

        ["\xCA\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\x4B\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],

        ["\xCA\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\x51\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],

        ["\xCA\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\x46\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],

        ["\xCA\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\x4C\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],

        ["\xCA\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\x55\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],

        ["\xCA\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x95"],
        ["\x4B\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],

        ["\xCA\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\x53\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],

        ["\xCA\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF8"],
        ["\x4D\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],

        ["\xCA\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xDD"],
        ["\x46\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],

        ["\xCA\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\x55\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],

        ["\xCA\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\x55\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],

        ["\xCA\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9B"],
        ["\x55\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],

        ["\xCA\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\x50\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],

        ["\xCA\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\x47\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],

        ["\xCA\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\x47\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],

        ["\xCA\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xB6"],
        ["\x4F\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],

        ["\xCA\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\x48\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],

        ["\xCA\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xD5"],
        ["\x45\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],

        ["\xCA\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD6"],
        ["\x48\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],

        ["\xCA\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\x50\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],

        ["\xCA\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\x4B\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],

        ["\xCA\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCE"],
        ["\x48\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],

        ["\xCA\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x9F"],
        ["\x54\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],

        ["\xCA\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\x4B\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],

        ["\xCA\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8B"],
        ["\x54\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],

        ["\xCA\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\x45\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],

        ["\xCA\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\x4E\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],

        ["\xCA\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\x53\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],

        ["\xCA\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCF"],
        ["\x53\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],

        ["\xCA\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\x4C\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],

        ["\xCA\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xD8"],
        ["\x47\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],

        ["\xCA\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\x4D\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],

        ["\xCA\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\x49\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],

        ["\xCA\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\x4A\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],

        ["\xCA\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD4"],
        ["\x48\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],

        ["\xCA\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE1"],
        ["\x4A\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],

        ["\xCA\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xBE"],
        ["\x4E\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],

        ["\xCA\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE3"],
        ["\x52\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],

        ["\xCA\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\x51\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],

        ["\xCA\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xFE"],
        ["\x4A\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],

        ["\xCA\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\x49\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],

        ["\xCA\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\x4F\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],

        ["\xCA\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\x51\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],

        ["\xCA\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\x55\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],

        ["\xCA\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF9"],
        ["\x50\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],

        ["\xCA\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xA8"],
        ["\x4A\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],

        ["\xCA\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\x50\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],

        ["\xCA\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB8"],
        ["\x49\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],

        ["\xCA\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB2"],
        ["\x4D\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],

        ["\xCA\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\x49\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],

        ["\xCA\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xFE"],
        ["\x48\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],

        ["\xCA\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAC"],
        ["\x4A\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],

        ["\xCA\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\x4F\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],

        ["\xCA\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\x55\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],

        ["\xCA\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x86"],
        ["\x4C\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],

        ["\xCA\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x85"],
        ["\x52\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],

        ["\xCA\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xAF"],
        ["\x48\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],

        ["\xCA\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xCD"],
        ["\x45\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],

        ["\xCA\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC4"],
        ["\x4B\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],

        ["\xCB\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\x46\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],

        ["\xCB\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x87"],
        ["\x4E\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],

        ["\xCB\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x87"],
        ["\x55\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],

        ["\xCB\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\x4C\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],

        ["\xCB\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE4"],
        ["\x49\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],

        ["\xCB\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB6"],
        ["\x50\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],

        ["\xCB\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x83"],
        ["\x46\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],

        ["\xCB\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDB"],
        ["\x50\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],

        ["\xCB\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x88"],
        ["\x50\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],

        ["\xCB\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xCD"],
        ["\x4E\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],

        ["\xCB\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xBA"],
        ["\x51\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],

        ["\xCB\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\x4A\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],

        ["\xCB\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\x46\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],

        ["\xCB\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC5"],
        ["\x46\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],

        ["\xCB\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\x54\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],

        ["\xCB\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\x4D\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],

        ["\xCB\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA6"],
        ["\x4E\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],

        ["\xCB\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8A"],
        ["\x51\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],

        ["\xCB\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\x4F\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],

        ["\xCB\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCE"],
        ["\x4C\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],

        ["\xCB\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE7"],
        ["\x4E\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],

        ["\xCB\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x99"],
        ["\x51\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],

        ["\xCB\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\x4C\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],

        ["\xCB\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xEC"],
        ["\x50\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],

        ["\xCB\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x85"],
        ["\x4C\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],

        ["\xCB\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\x4C\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],

        ["\xCB\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA3"],
        ["\x4E\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],

        ["\xCB\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDC"],
        ["\x47\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],

        ["\xCB\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB2"],
        ["\x4C\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],

        ["\xCB\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBB"],
        ["\x47\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],

        ["\xCB\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\x50\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],

        ["\xCB\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\x4B\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],

        ["\xCB\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8F"],
        ["\x4F\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],

        ["\xCB\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\x48\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],

        ["\xCB\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xFB"],
        ["\x4C\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],

        ["\xCB\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xF6"],
        ["\x4E\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],

        ["\xCB\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\x4F\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],

        ["\xCB\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\x50\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],

        ["\xCB\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\x48\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],

        ["\xCB\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x83"],
        ["\x51\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],

        ["\xCB\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBC"],
        ["\x47\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],

        ["\xCB\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE1"],
        ["\x53\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],

        ["\xCB\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xB3"],
        ["\x4E\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],

        ["\xCB\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\x45\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],

        ["\xCB\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xBB"],
        ["\x4A\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],

        ["\xCB\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\x51\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],

        ["\xCB\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xFC"],
        ["\x4A\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],

        ["\xCB\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC7"],
        ["\x4E\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],

        ["\xCB\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA2"],
        ["\x4E\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],

        ["\xCB\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\x48\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],

        ["\xCB\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x96"],
        ["\x4A\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],

        ["\xCB\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBE"],
        ["\x52\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],

        ["\xCB\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\x53\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],

        ["\xCB\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB1"],
        ["\x54\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],

        ["\xCB\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\x50\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],

        ["\xCB\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\x4F\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],

        ["\xCB\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9D"],
        ["\x46\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],

        ["\xCB\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\x49\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],

        ["\xCB\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x84"],
        ["\x52\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],

        ["\xCB\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\x45\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],

        ["\xCB\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF6"],
        ["\x51\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],

        ["\xCB\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE1"],
        ["\x4D\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],

        ["\xCB\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\x50\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],

        ["\xCB\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xD1"],
        ["\x48\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],

        ["\xCB\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB4"],
        ["\x49\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],

        ["\xCB\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xE2"],
        ["\x4D\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],

        ["\xCB\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA7"],
        ["\x48\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],

        ["\xCB\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xAC"],
        ["\x4E\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],

        ["\xCB\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xDC"],
        ["\x4B\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],

        ["\xCB\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9D"],
        ["\x55\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],

        ["\xCB\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xD9"],
        ["\x49\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],

        ["\xCB\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xF5"],
        ["\x49\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],

        ["\xCB\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF0"],
        ["\x55\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],

        ["\xCB\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x81"],
        ["\x68\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],

        ["\xCB\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCA"],
        ["\x4C\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],

        ["\xCB\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8A"],
        ["\x4D\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],

        ["\xCB\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\x4F\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],

        ["\xCB\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCE"],
        ["\x55\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],

        ["\xCB\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\x50\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],

        ["\xCB\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC6"],
        ["\x53\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],

        ["\xCB\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x88"],
        ["\x4D\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],

        ["\xCB\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\x4F\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],

        ["\xCB\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\x4B\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],

        ["\xCB\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF5"],
        ["\x48\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],

        ["\xCB\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE0"],
        ["\x51\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],

        ["\xCB\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\x47\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],

        ["\xCB\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xEC"],
        ["\x53\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],

        ["\xCB\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xCD"],
        ["\x49\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],

        ["\xCB\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\x56\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],

        ["\xCB\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9A"],
        ["\x4D\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],

        ["\xCB\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xEA"],
        ["\x4E\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],

        ["\xCB\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\x45\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],

        ["\xCB\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDB"],
        ["\x4D\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],

        ["\xCB\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\x47\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],

        ["\xCC\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\x4F\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],

        ["\xCC\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\x55\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],

        ["\xCC\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x7F"],
        ["\x47\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],

        ["\xCC\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC6"],
        ["\x49\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],

        ["\xCC\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB4"],
        ["\x4D\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],

        ["\xCC\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\x4A\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],

        ["\xCC\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xCC"],
        ["\x4C\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],

        ["\xCC\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\x50\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],

        ["\xCC\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\x4A\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],

        ["\xCC\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA1"],
        ["\x53\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],

        ["\xCC\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x88"],
        ["\x4C\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],

        ["\xCC\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x9A"],
        ["\x4F\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],

        ["\xCC\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xFA"],
        ["\x47\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],

        ["\xCC\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\x50\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],

        ["\xCC\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\x4A\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],

        ["\xCC\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC9"],
        ["\x53\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],

        ["\xCC\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\x47\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],

        ["\xCC\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\x4E\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],

        ["\xCC\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\x46\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],

        ["\xCC\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x8B"],
        ["\x4B\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],

        ["\xCC\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\x47\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],

        ["\xCC\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xAF"],
        ["\x4A\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],

        ["\xCC\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xED"],
        ["\x50\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],

        ["\xCC\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\x4E\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],

        ["\xCC\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\x55\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],

        ["\xCC\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xFD"],
        ["\x4D\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],

        ["\xCC\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\x54\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],

        ["\xCC\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\x4B\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],

        ["\xCC\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\x54\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],

        ["\xCC\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\x45\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],

        ["\xCC\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xB0"],
        ["\x49\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],

        ["\xCC\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\x45\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],

        ["\xCC\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x84"],
        ["\x4B\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],

        ["\xCC\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\x4E\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],

        ["\xCC\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDC"],
        ["\x4D\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],

        ["\xCC\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\x4B\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],

        ["\xCC\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8C"],
        ["\x55\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],

        ["\xCC\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xB7"],
        ["\x55\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],

        ["\xCC\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE6"],
        ["\x4E\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],

        ["\xCC\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\x4B\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],

        ["\xCC\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCA"],
        ["\x55\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],

        ["\xCC\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x9D"],
        ["\x48\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],

        ["\xCC\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\x55\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],

        ["\xCC\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x91"],
        ["\x46\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],

        ["\xCC\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\x55\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],

        ["\xCC\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF5"],
        ["\x55\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],

        ["\xCC\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\x48\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],

        ["\xCC\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\x46\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],

        ["\xCC\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\x55\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],

        ["\xCC\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x83"],
        ["\x4F\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],

        ["\xCC\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE2"],
        ["\x46\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],

        ["\xCC\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\x4A\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],

        ["\xCC\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x80"],
        ["\x50\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],

        ["\xCC\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\x4A\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],

        ["\xCC\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xEC"],
        ["\x4F\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],

        ["\xCC\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x95"],
        ["\x50\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],

        ["\xCC\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\x54\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],

        ["\xCC\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\x45\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],

        ["\xCC\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xBC"],
        ["\x4D\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],

        ["\xCC\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\x46\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],

        ["\xCC\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA6"],
        ["\x51\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],

        ["\xCC\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x97"],
        ["\x52\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],

        ["\xCC\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBF"],
        ["\x50\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],

        ["\xCC\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAE"],
        ["\x53\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],

        ["\xCC\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\x4C\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],

        ["\xCC\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\x4F\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],

        ["\xCC\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xEF"],
        ["\x4D\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],

        ["\xCC\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE4"],
        ["\x46\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],

        ["\xCC\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\x55\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],

        ["\xCC\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\x4C\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],

        ["\xCC\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xAA"],
        ["\x46\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],

        ["\xCC\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\x4F\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],

        ["\xCC\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\x47\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],

        ["\xCC\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\x51\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],

        ["\xCC\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC8"],
        ["\x48\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],

        ["\xCC\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x96"],
        ["\x50\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],

        ["\xCC\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x99"],
        ["\x4E\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],

        ["\xCC\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\x45\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],

        ["\xCC\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE6"],
        ["\x47\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],

        ["\xCC\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\x46\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],

        ["\xCC\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\x53\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],

        ["\xCC\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\x49\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],

        ["\xCC\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBD"],
        ["\x47\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],

        ["\xCC\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xE1"],
        ["\x46\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],

        ["\xCC\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xAD"],
        ["\x4B\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],

        ["\xCC\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\x4C\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],

        ["\xCC\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC3"],
        ["\x48\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],

        ["\xCC\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\x46\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],

        ["\xCC\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\x62\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],

        ["\xCC\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\x52\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],

        ["\xCC\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x98"],
        ["\x50\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],

        ["\xCC\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC8"],
        ["\x53\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],

        ["\xCC\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\x46\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],

        ["\xCC\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xAA"],
        ["\x53\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],

        ["\xCD\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9C"],
        ["\x4E\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],

        ["\xCD\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x93"],
        ["\x46\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],

        ["\xCD\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\x4B\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],

        ["\xCD\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\x4C\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],

        ["\xCD\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xDA"],
        ["\x47\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],

        ["\xCD\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x9C"],
        ["\x46\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],

        ["\xCD\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xD4"],
        ["\x46\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],

        ["\xCD\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\x4F\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],

        ["\xCD\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\x52\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],

        ["\xCD\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD8"],
        ["\x4D\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],

        ["\xCD\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\x50\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],

        ["\xCD\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\x4C\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],

        ["\xCD\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x85"],
        ["\x46\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],

        ["\xCD\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xE1"],
        ["\x4E\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],

        ["\xCD\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBD"],
        ["\x4F\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],

        ["\xCD\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\x4F\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],

        ["\xCD\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\x50\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],

        ["\xCD\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDD"],
        ["\x53\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],

        ["\xCD\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\x46\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],

        ["\xCD\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x8C"],
        ["\x48\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],

        ["\xCD\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xF8"],
        ["\x46\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],

        ["\xCD\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCB"],
        ["\x4A\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],

        ["\xCD\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\x4A\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],

        ["\xCD\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x92"],
        ["\x4C\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],

        ["\xCD\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xB7"],
        ["\x4C\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],

        ["\xCD\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\x45\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],

        ["\xCD\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xC2"],
        ["\x48\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],

        ["\xCD\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\x4A\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],

        ["\xCD\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xC2"],
        ["\x47\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],

        ["\xCD\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC1"],
        ["\x49\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],

        ["\xCD\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x89"],
        ["\x47\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],

        ["\xCD\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x8C"],
        ["\x4D\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],

        ["\xCD\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\x50\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],

        ["\xCD\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\x4D\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],

        ["\xCD\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDA"],
        ["\x54\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],

        ["\xCD\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xAF"],
        ["\x4D\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],

        ["\xCD\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD1"],
        ["\x53\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],

        ["\xCD\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x89"],
        ["\x48\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],

        ["\xCD\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\x4C\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],

        ["\xCD\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\x4C\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],

        ["\xCD\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\x4F\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],

        ["\xCD\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\x51\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],

        ["\xCD\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xFE"],
        ["\x4B\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],

        ["\xCD\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD7"],
        ["\x51\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],

        ["\xCD\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\x48\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],

        ["\xCD\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\x45\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],

        ["\xCD\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xBE"],
        ["\x48\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],

        ["\xCD\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x9D"],
        ["\x52\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],

        ["\xCD\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xB6"],
        ["\x45\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],

        ["\xCD\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA7"],
        ["\x49\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],

        ["\xCD\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\x4A\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],

        ["\xCD\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA0"],
        ["\x52\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],

        ["\xCD\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF9"],
        ["\x45\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],

        ["\xCD\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x83"],
        ["\x50\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],

        ["\xCD\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\x46\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],

        ["\xCD\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\x4D\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],

        ["\xCD\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA8"],
        ["\x4C\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],

        ["\xCD\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x82"],
        ["\x68\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],

        ["\xCD\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xBF"],
        ["\x47\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],

        ["\xCD\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\x49\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],

        ["\xCD\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF4"],
        ["\x53\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],

        ["\xCD\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\x4D\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],

        ["\xCD\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF6"],
        ["\x4B\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],

        ["\xCD\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xD9"],
        ["\x55\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],

        ["\xCD\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\x4B\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],

        ["\xCD\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x9C"],
        ["\x4D\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],

        ["\xCD\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xB5"],
        ["\x4D\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],

        ["\xCD\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x88"],
        ["\x4A\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],

        ["\xCD\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xFA"],
        ["\x4D\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],

        ["\xCD\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD6"],
        ["\x51\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],

        ["\xCD\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\x4F\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],

        ["\xCD\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\x46\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],

        ["\xCD\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC9"],
        ["\x52\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],

        ["\xCD\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\x4A\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],

        ["\xCD\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xD6"],
        ["\x4B\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],

        ["\xCD\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\x54\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],

        ["\xCD\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\x4C\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],

        ["\xCD\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xF2"],
        ["\x47\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],

        ["\xCD\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBD"],
        ["\x50\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],

        ["\xCD\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xBF"],
        ["\x4B\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],

        ["\xCD\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\x4C\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],

        ["\xCD\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x8C"],
        ["\x49\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],

        ["\xCD\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDE"],
        ["\x4E\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],

        ["\xCD\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA3"],
        ["\x55\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],

        ["\xCD\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\x4E\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],

        ["\xCD\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA6"],
        ["\x4C\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],

        ["\xCD\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\x4E\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],

        ["\xCD\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\x45\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],

        ["\xCD\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\x50\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],

        ["\xCD\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA2"],
        ["\x4C\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],

        ["\xCD\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\x4E\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],

        ["\xCD\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\x48\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],

        ["\xCD\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xEB"],
        ["\x45\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],

        ["\xCD\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8C"],
        ["\x52\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],

        ["\xCE\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\x51\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xA4"],
        ["\x49\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],

        ["\xCE\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\x54\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\x47\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x97"],
        ["\x49\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\x49\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x91"],
        ["\x49\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x83"],
        ["\x47\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xDD"],
        ["\x45\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x9F"],
        ["\x55\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],

        ["\xCE\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xE6"],
        ["\x55\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],

        ["\xCE\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\x4C\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],

        ["\xCE\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x85"],
        ["\x51\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],

        ["\xCE\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\x46\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],

        ["\xCE\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xC4"],
        ["\x4D\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],

        ["\xCE\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\x50\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],

        ["\xCE\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xAB"],
        ["\x47\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x84"],
        ["\x49\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xA9"],
        ["\x4C\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\x46\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xE7"],
        ["\x49\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\x48\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\x55\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\x4C\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCF"],
        ["\x4A\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\x52\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB1"],
        ["\x4B\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x9C"],
        ["\x49\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x82"],
        ["\x4D\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x83"],
        ["\x48\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\x53\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCE\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\x4C\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],

        ["\xCE\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\x46\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],

        ["\xCE\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\x4E\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],

        ["\xCE\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\x4E\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],

        ["\xCE\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9D"],
        ["\x4E\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],

        ["\xCE\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB7"],
        ["\x4B\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],

        ["\xCE\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\x52\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],

        ["\xCE\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x96"],
        ["\x52\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],

        ["\xCE\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xC5"],
        ["\x4E\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],

        ["\xCE\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xC4"],
        ["\x45\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],

        ["\xCE\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x81"],
        ["\x51\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],

        ["\xCE\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\x52\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],

        ["\xCE\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xB5"],
        ["\x47\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],

        ["\xCE\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\x50\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],

        ["\xCE\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xCD"],
        ["\x4A\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],

        ["\xCE\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xF7"],
        ["\x45\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],

        ["\xCE\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA5"],
        ["\x48\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],

        ["\xCE\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\x4D\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],

        ["\xCE\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x55"],
        ["\x4F\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],

        ["\xCE\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xA2"],
        ["\x45\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],

        ["\xCE\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC7"],
        ["\x52\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],

        ["\xCE\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\x4A\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],

        ["\xCE\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\x54\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],

        ["\xCE\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\x4C\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],

        ["\xCE\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xB7"],
        ["\x48\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],

        ["\xCE\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\x4C\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],

        ["\xCE\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\x55\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],

        ["\xCE\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9B"],
        ["\x51\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],

        ["\xCE\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x8C"],
        ["\x50\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],

        ["\xCE\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xEB"],
        ["\x4B\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],

        ["\xCE\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xDA"],
        ["\x4D\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],

        ["\xCE\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\x51\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],

        ["\xCE\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x46\xBA"],
        ["\x46\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],

        ["\xCE\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\xC3"],
        ["\x49\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],

        ["\xCE\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\x54\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],

        ["\xCE\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\x4A\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],

        ["\xCE\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xFC"],
        ["\x48\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],

        ["\xCE\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x92"],
        ["\x4D\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],

        ["\xCE\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\x4C\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],

        ["\xCE\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x9F"],
        ["\x50\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],

        ["\xCE\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\x4A\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],

        ["\xCE\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\x49\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],

        ["\xCE\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\x55\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],

        ["\xCE\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\xAE"],
        ["\x45\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],

        ["\xCE\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\x55\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],

        ["\xCE\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\x50\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],

        ["\xCE\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\x4F\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],

        ["\xCE\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\x4C\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],

        ["\xCE\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\x4C\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],

        ["\xCE\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xCC"],
        ["\x50\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],

        ["\xCE\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\x49\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],

        ["\xCE\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xB4"],
        ["\x4B\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],

        ["\xCE\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\x4E\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],

        ["\xCE\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xD1"],
        ["\x4D\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],

        ["\xCE\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\x4F\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],

        ["\xCE\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\x4E\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],

        ["\xCE\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xCA"],
        ["\x4B\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],

        ["\xCE\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\x55\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],

        ["\xCE\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE0"],
        ["\x54\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],

        ["\xCE\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\x4C\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],

        ["\xCE\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\x52\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],

        ["\xCE\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\x48\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],

        ["\xCE\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCA"],
        ["\x53\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],

        ["\xCF\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF4"],
        ["\x4B\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],

        ["\xCF\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\x47\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],

        ["\xCF\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\x4F\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],

        ["\xCF\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\x4B\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],

        ["\xCF\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF4"],
        ["\x51\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],

        ["\xCF\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x86"],
        ["\x55\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],

        ["\xCF\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\x49\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],

        ["\xCF\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xF8"],
        ["\x55\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],

        ["\xCF\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x84"],
        ["\x47\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],

        ["\xCF\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xC6"],
        ["\x4B\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],

        ["\xCF\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xA9"],
        ["\x48\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],

        ["\xCF\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\x50\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],

        ["\xCF\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xA7"],
        ["\x4E\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],

        ["\xCF\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBF"],
        ["\x54\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],

        ["\xCF\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\x48\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],

        ["\xCF\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xBA"],
        ["\x52\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],

        ["\xCF\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC7"],
        ["\x55\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],

        ["\xCF\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x9D"],
        ["\x4A\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],

        ["\xCF\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\x50\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],

        ["\xCF\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC4"],
        ["\x55\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],

        ["\xCF\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\x50\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],

        ["\xCF\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\x54\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],

        ["\xCF\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x49\x85"],
        ["\x49\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],

        ["\xCF\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE4"],
        ["\x53\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],

        ["\xCF\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\x52\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],

        ["\xCF\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\x45\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],

        ["\xCF\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\x45\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],

        ["\xCF\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x9E"],
        ["\x51\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],

        ["\xCF\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xAE"],
        ["\x50\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],

        ["\xCF\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x7F"],
        ["\x55\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],

        ["\xCF\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\x86"],
        ["\x48\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],

        ["\xCF\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x48\xF3"],
        ["\x48\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],

        ["\xCF\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\x4F\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],

        ["\xCF\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\x45\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],

        ["\xCF\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\x47\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],

        ["\xCF\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x8E"],
        ["\x55\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],

        ["\xCF\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\x50\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],

        ["\xCF\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x47\xE3"],
        ["\x47\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],

        ["\xCF\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\x4E\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],

        ["\xCF\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\x4F\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],

        ["\xCF\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xF1"],
        ["\x4B\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],

        ["\xCF\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE8"],
        ["\x50\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],

        ["\xCF\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\x4B\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],

        ["\xCF\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x93"],
        ["\x52\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],

        ["\xCF\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\x50\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],

        ["\xCF\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xBB"],
        ["\x4F\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],

        ["\xCF\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xDE"],
        ["\x50\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],

        ["\xCF\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\x54\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],

        ["\xCF\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\x4D\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],

        ["\xCF\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\x54\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],

        ["\xCF\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xAF"],
        ["\x4C\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],

        ["\xD0\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\x56\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\x56\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\x56\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\x56\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\x56\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\x56\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC8"],
        ["\x54\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\x56\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\x56\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\x56\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\x56\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\x56\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\x56\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\x53\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\x56\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDB"],
        ["\x61\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\x56\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\x56\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\x56\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\x51\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\x56\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD0\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\x56\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\x56\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\x56\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\x56\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\x56\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\x56\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\x56\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\x56\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\x56\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\x56\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD0\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\x56\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],

        ["\xD0\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\x56\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],

        ["\xD0\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\x56\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],

        ["\xD0\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\x53\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],

        ["\xD0\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\x56\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\xD0\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\x56\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],

        ["\xD0\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\x56\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],

        ["\xD0\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\x56\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],

        ["\xD0\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\x56\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],

        ["\xD0\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\x56\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],

        ["\xD0\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\x56\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],

        ["\xD0\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE2"],
        ["\x51\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],

        ["\xD0\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\x56\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],

        ["\xD0\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\x56\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],

        ["\xD0\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\x56\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],

        ["\xD0\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\x56\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],

        ["\xD0\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\x56\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],

        ["\xD0\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\x56\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],

        ["\xD0\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x8D"],
        ["\x4F\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],

        ["\xD0\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\x56\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],

        ["\xD0\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\x56\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],

        ["\xD0\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\x56\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],

        ["\xD0\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x90"],
        ["\x52\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],

        ["\xD0\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x7F"],
        ["\x56\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],

        ["\xD0\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC4"],
        ["\x53\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],

        ["\xD0\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x80"],
        ["\x56\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],

        ["\xD0\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x81"],
        ["\x56\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],

        ["\xD0\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x82"],
        ["\x56\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],

        ["\xD0\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x83"],
        ["\x56\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],

        ["\xD0\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x84"],
        ["\x56\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],

        ["\xD0\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x85"],
        ["\x56\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],

        ["\xD0\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x87"],
        ["\x56\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],

        ["\xD0\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x88"],
        ["\x56\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],

        ["\xD0\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x89"],
        ["\x56\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],

        ["\xD0\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x8B"],
        ["\x56\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],

        ["\xD0\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x8C"],
        ["\x56\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],

        ["\xD0\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x8D"],
        ["\x56\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],

        ["\xD0\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x8E"],
        ["\x56\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],

        ["\xD0\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x8F"],
        ["\x56\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],

        ["\xD0\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\x56\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],

        ["\xD0\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF8"],
        ["\x51\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],

        ["\xD0\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x90"],
        ["\x56\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],

        ["\xD0\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x92"],
        ["\x56\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],

        ["\xD0\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x93"],
        ["\x56\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],

        ["\xD0\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x95"],
        ["\x56\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],

        ["\xD0\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x96"],
        ["\x56\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],

        ["\xD0\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x97"],
        ["\x56\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],

        ["\xD0\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x99"],
        ["\x56\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],

        ["\xD0\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9A"],
        ["\x56\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],

        ["\xD0\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9B"],
        ["\x56\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],

        ["\xD0\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAC"],
        ["\x56\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],

        ["\xD0\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9C"],
        ["\x56\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],

        ["\xD0\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9D"],
        ["\x56\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],

        ["\xD0\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9E"],
        ["\x56\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],

        ["\xD0\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x9F"],
        ["\x56\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],

        ["\xD0\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA0"],
        ["\x56\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],

        ["\xD0\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA5"],
        ["\x56\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],

        ["\xD0\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA6"],
        ["\x56\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],

        ["\xD0\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\x56\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],

        ["\xD0\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA9"],
        ["\x56\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],

        ["\xD0\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAA"],
        ["\x56\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],

        ["\xD0\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAB"],
        ["\x56\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],

        ["\xD0\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\x56\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],

        ["\xD1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAE"],
        ["\x56\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xAF"],
        ["\x56\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],

        ["\xD1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB0"],
        ["\x56\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],

        ["\xD1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB1"],
        ["\x56\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],

        ["\xD1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD4"],
        ["\x52\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],

        ["\xD1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB3"],
        ["\x56\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],

        ["\xD1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB4"],
        ["\x56\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],

        ["\xD1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB6"],
        ["\x56\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],

        ["\xD1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB7"],
        ["\x56\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],

        ["\xD1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\x56\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],

        ["\xD1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xB9"],
        ["\x56\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBA"],
        ["\x56\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],

        ["\xD1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBB"],
        ["\x56\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],

        ["\xD1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBC"],
        ["\x56\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],

        ["\xD1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBD"],
        ["\x56\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],

        ["\xD1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC1"],
        ["\x56\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBF"],
        ["\x56\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],

        ["\xD1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC0"],
        ["\x56\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],

        ["\xD1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\x56\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],

        ["\xD1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\x56\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],

        ["\xD1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\x56\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],

        ["\xD1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC4"],
        ["\x56\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],

        ["\xD1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC5"],
        ["\x56\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],

        ["\xD1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC6"],
        ["\x56\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],

        ["\xD1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC7"],
        ["\x56\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],

        ["\xD1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xC8"],
        ["\x56\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],

        ["\xD1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xCB"],
        ["\x56\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],

        ["\xD1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xCA"],
        ["\x56\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],

        ["\xD1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xCC"],
        ["\x56\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],

        ["\xD1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xCD"],
        ["\x56\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],

        ["\xD1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\x60\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],

        ["\xD1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\x56\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD0"],
        ["\x56\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD1"],
        ["\x56\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD2"],
        ["\x56\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD3"],
        ["\x56\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD4"],
        ["\x56\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD5"],
        ["\x56\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD6"],
        ["\x56\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD7"],
        ["\x56\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD8"],
        ["\x56\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xD9"],
        ["\x56\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],

        ["\xD1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xDA"],
        ["\x56\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],

        ["\xD1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xDB"],
        ["\x56\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],

        ["\xD1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xDD"],
        ["\x56\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],

        ["\xD1\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xDE"],
        ["\x56\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],

        ["\xD1\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\x56\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],

        ["\xD1\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE0"],
        ["\x56\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE1"],
        ["\x56\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE2"],
        ["\x56\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE3"],
        ["\x56\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE4"],
        ["\x56\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE5"],
        ["\x56\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE6"],
        ["\x56\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE7"],
        ["\x56\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xE9"],
        ["\x56\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xEA"],
        ["\x56\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xEB"],
        ["\x56\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],

        ["\xD1\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xEC"],
        ["\x56\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],

        ["\xD1\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xED"],
        ["\x56\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],

        ["\xD1\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\x62\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],

        ["\xD1\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xEE"],
        ["\x56\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],

        ["\xD1\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF0"],
        ["\x56\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],

        ["\xD1\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF1"],
        ["\x56\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF2"],
        ["\x56\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],

        ["\xD1\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF3"],
        ["\x56\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF4"],
        ["\x56\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF5"],
        ["\x56\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF6"],
        ["\x56\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE3"],
        ["\x54\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF8"],
        ["\x56\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xF9"],
        ["\x56\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xFA"],
        ["\x56\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xFB"],
        ["\x56\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],

        ["\xD1\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xFC"],
        ["\x56\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],

        ["\xD1\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\x57\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],

        ["\xD1\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xFD"],
        ["\x56\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],

        ["\xD1\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\x56\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],

        ["\xD1\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xAE"],
        ["\x51\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],

        ["\xD1\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\x57\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\x57\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\x57\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\x57\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\x57\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\x57\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\x57\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\x57\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\x57\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x80"],
        ["\x55\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\x57\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],

        ["\xD1\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\x57\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],

        ["\xD1\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\x57\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],

        ["\xD1\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\x57\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],

        ["\xD1\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\x64\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],

        ["\xD2\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xED"],
        ["\x64\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD2\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\x57\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],

        ["\xD2\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\x57\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],

        ["\xD2\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\x57\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],

        ["\xD2\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\x57\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],

        ["\xD2\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\x57\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],

        ["\xD2\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\x57\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],

        ["\xD2\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x92"],
        ["\x53\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],

        ["\xD2\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\x57\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],

        ["\xD2\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\x57\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],

        ["\xD2\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\x57\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD2\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xDB"],
        ["\x66\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],

        ["\xD2\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\x57\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],

        ["\xD2\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\x57\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],

        ["\xD2\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\x57\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],

        ["\xD2\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\x57\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\x57\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],

        ["\xD2\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\x57\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],

        ["\xD2\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\x57\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],

        ["\xD2\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\x57\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],

        ["\xD2\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\x57\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],

        ["\xD2\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\x57\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],

        ["\xD2\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\x57\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],

        ["\xD2\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\x57\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],

        ["\xD2\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\x57\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],

        ["\xD2\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\x57\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],

        ["\xD2\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\x57\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],

        ["\xD2\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\x57\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],

        ["\xD2\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\x57\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],

        ["\xD2\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\x57\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],

        ["\xD2\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\x57\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],

        ["\xD2\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\x57\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\x57\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\x57\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\x57\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\x57\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\x57\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\x57\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\x57\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\x57\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC8"],
        ["\x52\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\x57\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],

        ["\xD2\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\x57\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],

        ["\xD2\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\x57\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],

        ["\xD2\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x81"],
        ["\x57\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],

        ["\xD2\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x82"],
        ["\x57\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],

        ["\xD2\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x83"],
        ["\x57\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],

        ["\xD2\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x84"],
        ["\x57\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x85"],
        ["\x57\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x86"],
        ["\x57\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x88"],
        ["\x57\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x89"],
        ["\x57\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x8A"],
        ["\x57\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x88"],
        ["\x66\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x8C"],
        ["\x57\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x8D"],
        ["\x57\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x8F"],
        ["\x57\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x90"],
        ["\x57\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],

        ["\xD2\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x91"],
        ["\x57\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],

        ["\xD2\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x92"],
        ["\x57\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],

        ["\xD2\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x93"],
        ["\x57\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],

        ["\xD2\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x94"],
        ["\x57\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],

        ["\xD2\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x95"],
        ["\x57\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],

        ["\xD2\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x96"],
        ["\x57\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x97"],
        ["\x57\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],

        ["\xD2\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x98"],
        ["\x57\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x99"],
        ["\x57\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9A"],
        ["\x57\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\x57\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\x57\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9D"],
        ["\x57\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9E"],
        ["\x57\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x9F"],
        ["\x57\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\x57\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],

        ["\xD2\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\x57\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],

        ["\xD2\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA2"],
        ["\x57\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],

        ["\xD2\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA3"],
        ["\x57\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],

        ["\xD2\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA4"],
        ["\x57\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],

        ["\xD2\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA5"],
        ["\x57\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],

        ["\xD2\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA6"],
        ["\x57\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA7"],
        ["\x57\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xA8"],
        ["\x57\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xAA"],
        ["\x57\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\x57\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xAC"],
        ["\x57\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xAD"],
        ["\x57\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xAF"],
        ["\x57\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB2"],
        ["\x57\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB3"],
        ["\x57\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB4"],
        ["\x57\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],

        ["\xD2\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB5"],
        ["\x57\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],

        ["\xD2\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB6"],
        ["\x57\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],

        ["\xD2\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\x57\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],

        ["\xD2\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\x57\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],

        ["\xD3\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\x57\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD3\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xBB"],
        ["\x57\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],

        ["\xD3\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\x57\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],

        ["\xD3\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xBE"],
        ["\x57\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],

        ["\xD3\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\x57\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],

        ["\xD3\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB7"],
        ["\x57\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],

        ["\xD3\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xBF"],
        ["\x57\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],

        ["\xD3\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\x57\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],

        ["\xD3\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\x57\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],

        ["\xD3\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\x57\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],

        ["\xD3\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\x57\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\xD3\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\x57\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],

        ["\xD3\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\x57\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],

        ["\xD3\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\x54\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],

        ["\xD3\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\x57\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],

        ["\xD3\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\x57\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\x57\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],

        ["\xD3\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCA"],
        ["\x57\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],

        ["\xD3\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCB"],
        ["\x57\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],

        ["\xD3\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCC"],
        ["\x57\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],

        ["\xD3\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCD"],
        ["\x57\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],

        ["\xD3\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCE"],
        ["\x57\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],

        ["\xD3\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xCF"],
        ["\x57\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],

        ["\xD3\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\x57\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],

        ["\xD3\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\x57\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],

        ["\xD3\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\x57\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],

        ["\xD3\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\x57\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],

        ["\xD3\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\x57\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],

        ["\xD3\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\x57\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],

        ["\xD3\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xB1"],
        ["\x57\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],

        ["\xD3\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\x57\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],

        ["\xD3\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\x57\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\x57\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\x57\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xDA"],
        ["\x57\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xDB"],
        ["\x57\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xDC"],
        ["\x57\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xDD"],
        ["\x57\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xDF"],
        ["\x57\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\x57\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE1"],
        ["\x57\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\x57\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],

        ["\xD3\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\x52\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],

        ["\xD3\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\x57\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],

        ["\xD3\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\x57\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],

        ["\xD3\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\x57\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],

        ["\xD3\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\x57\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],

        ["\xD3\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\x57\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\x57\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xEA"],
        ["\x57\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\x57\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\x57\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xED"],
        ["\x57\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xEE"],
        ["\x57\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xEF"],
        ["\x57\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\x57\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\x57\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\x57\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],

        ["\xD3\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xFB"],
        ["\x57\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],

        ["\xD3\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7F"],
        ["\x54\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],

        ["\xD3\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\x57\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],

        ["\xD3\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\x57\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],

        ["\xD3\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\x57\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],

        ["\xD3\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\x57\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\x57\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],

        ["\xD3\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\x57\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\x57\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xFA"],
        ["\x57\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\x57\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xFE"],
        ["\x57\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\x58\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\x58\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xFC"],
        ["\x57\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\xFD"],
        ["\x57\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],

        ["\xD3\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\x58\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],

        ["\xD3\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\x58\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],

        ["\xD3\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\x58\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],

        ["\xD3\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\x58\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],

        ["\xD3\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\x58\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],

        ["\xD3\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\x58\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\x58\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\x58\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\x58\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\x58\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\x58\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\x58\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\x58\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\x58\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\x58\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\x58\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],

        ["\xD3\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\x52\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],

        ["\xD3\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\x58\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],

        ["\xD3\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\x58\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],

        ["\xD3\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\x58\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],

        ["\xD4\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\x58\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD4\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\x51\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],

        ["\xD4\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\x58\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\xD4\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE7"],
        ["\x54\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],

        ["\xD4\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\x58\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],

        ["\xD4\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\x58\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],

        ["\xD4\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\x58\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],

        ["\xD4\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\x58\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],

        ["\xD4\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\x58\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],

        ["\xD4\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD1"],
        ["\x51\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],

        ["\xD4\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\x58\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\x58\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],

        ["\xD4\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\x58\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],

        ["\xD4\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\x58\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],

        ["\xD4\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\x58\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],

        ["\xD4\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x98"],
        ["\x53\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\x58\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],

        ["\xD4\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\x58\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],

        ["\xD4\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\x58\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],

        ["\xD4\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\x58\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],

        ["\xD4\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\x58\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],

        ["\xD4\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\x58\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],

        ["\xD4\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\x58\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],

        ["\xD4\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\x58\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],

        ["\xD4\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\x58\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],

        ["\xD4\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\x58\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],

        ["\xD4\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xCD"],
        ["\x53\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],

        ["\xD4\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\x58\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],

        ["\xD4\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\x58\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],

        ["\xD4\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\x58\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],

        ["\xD4\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\x58\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],

        ["\xD4\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\x58\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\x58\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\x58\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\x58\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\x58\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\x58\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA7"],
        ["\x53\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x86"],
        ["\x58\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\x58\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\x58\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\x58\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],

        ["\xD4\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x83"],
        ["\x58\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],

        ["\xD4\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x7F"],
        ["\x58\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],

        ["\xD4\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x81"],
        ["\x58\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],

        ["\xD4\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x80"],
        ["\x58\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],

        ["\xD4\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x84"],
        ["\x58\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],

        ["\xD4\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x85"],
        ["\x58\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x8D"],
        ["\x58\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x87"],
        ["\x58\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x88"],
        ["\x58\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x8E"],
        ["\x58\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x95"],
        ["\x58\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\x55\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x89"],
        ["\x58\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x8B"],
        ["\x58\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x8F"],
        ["\x58\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x90"],
        ["\x58\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],

        ["\xD4\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x91"],
        ["\x58\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],

        ["\xD4\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x92"],
        ["\x58\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],

        ["\xD4\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x93"],
        ["\x58\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],

        ["\xD4\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x94"],
        ["\x58\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],

        ["\xD4\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x99"],
        ["\x58\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],

        ["\xD4\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x96"],
        ["\x58\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x98"],
        ["\x58\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],

        ["\xD4\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x97"],
        ["\x58\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9A"],
        ["\x58\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xD4\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\x50\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xD4\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9C"],
        ["\x58\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9D"],
        ["\x58\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9E"],
        ["\x58\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\x52\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xD4\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\x9F"],
        ["\x58\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\xD4\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA0"],
        ["\x58\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],

        ["\xD4\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA2"],
        ["\x58\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],

        ["\xD4\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA3"],
        ["\x58\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],

        ["\xD4\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA4"],
        ["\x58\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],

        ["\xD4\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\x58\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],

        ["\xD4\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\x58\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],

        ["\xD4\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA7"],
        ["\x58\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\x58\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\x58\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xAA"],
        ["\x58\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\x60\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xAB"],
        ["\x58\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xAC"],
        ["\x58\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8F"],
        ["\x51\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xAE"],
        ["\x58\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xAF"],
        ["\x58\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB3"],
        ["\x58\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],

        ["\xD4\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB4"],
        ["\x58\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],

        ["\xD4\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB5"],
        ["\x58\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],

        ["\xD4\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB6"],
        ["\x58\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],

        ["\xD4\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB7"],
        ["\x58\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],

        ["\xD5\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB8"],
        ["\x58\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD5\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xB9"],
        ["\x58\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],

        ["\xD5\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xBC"],
        ["\x58\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],

        ["\xD5\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\x56\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],

        ["\xD5\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\x56\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],

        ["\xD5\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xBD"],
        ["\x58\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],

        ["\xD5\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xBF"],
        ["\x58\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],

        ["\xD5\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC1"],
        ["\x58\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],

        ["\xD5\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC2"],
        ["\x58\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],

        ["\xD5\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x84"],
        ["\x51\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],

        ["\xD5\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xBA"],
        ["\x58\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC3"],
        ["\x58\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],

        ["\xD5\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC4"],
        ["\x58\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],

        ["\xD5\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC5"],
        ["\x58\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],

        ["\xD5\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC6"],
        ["\x58\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],

        ["\xD5\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC7"],
        ["\x58\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC8"],
        ["\x58\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],

        ["\xD5\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCA"],
        ["\x58\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],

        ["\xD5\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xC9"],
        ["\x58\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],

        ["\xD5\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCB"],
        ["\x58\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],

        ["\xD5\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCC"],
        ["\x58\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],

        ["\xD5\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCD"],
        ["\x58\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],

        ["\xD5\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCE"],
        ["\x58\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],

        ["\xD5\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xCF"],
        ["\x58\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],

        ["\xD5\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD0"],
        ["\x58\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],

        ["\xD5\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD1"],
        ["\x58\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],

        ["\xD5\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD2"],
        ["\x58\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],

        ["\xD5\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD3"],
        ["\x58\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],

        ["\xD5\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD4"],
        ["\x58\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],

        ["\xD5\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\x58\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],

        ["\xD5\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD7"],
        ["\x58\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],

        ["\xD5\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD8"],
        ["\x58\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD9"],
        ["\x58\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDA"],
        ["\x58\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDB"],
        ["\x58\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDC"],
        ["\x58\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDD"],
        ["\x58\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDE"],
        ["\x58\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xDF"],
        ["\x58\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE0"],
        ["\x58\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE1"],
        ["\x58\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE2"],
        ["\x58\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],

        ["\xD5\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE3"],
        ["\x58\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],

        ["\xD5\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xD5"],
        ["\x58\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],

        ["\xD5\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE4"],
        ["\x58\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],

        ["\xD5\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE5"],
        ["\x58\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],

        ["\xD5\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE6"],
        ["\x58\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],

        ["\xD5\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE7"],
        ["\x58\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE8"],
        ["\x58\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xE9"],
        ["\x58\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xEA"],
        ["\x58\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xEB"],
        ["\x58\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\x52\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xEE"],
        ["\x58\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\x58\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF0"],
        ["\x58\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF1"],
        ["\x58\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF2"],
        ["\x58\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],

        ["\xD5\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF3"],
        ["\x58\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],

        ["\xD5\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF4"],
        ["\x58\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],

        ["\xD5\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\x58\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],

        ["\xD5\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF5"],
        ["\x58\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],

        ["\xD5\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\x58\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],

        ["\xD5\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF7"],
        ["\x58\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF8"],
        ["\x58\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],

        ["\xD5\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xF9"],
        ["\x58\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\x58\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xFB"],
        ["\x58\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xFD"],
        ["\x58\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\x52\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\x59\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\x59\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\x51\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\x59\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],

        ["\xD5\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\x59\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],

        ["\xD5\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\x59\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],

        ["\xD5\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\x59\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],

        ["\xD5\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\x59\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],

        ["\xD5\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\x59\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],

        ["\xD5\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\x59\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\x59\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\x59\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\x59\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\x59\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\x59\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\x59\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\x59\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\x59\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\x59\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\x51\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],

        ["\xD5\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\x59\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],

        ["\xD5\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\x59\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],

        ["\xD5\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\x59\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],

        ["\xD5\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\x59\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],

        ["\xD6\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\x59\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],

        ["\xD6\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\x54\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],

        ["\xD6\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\x59\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],

        ["\xD6\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\x59\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],

        ["\xD6\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\x59\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],

        ["\xD6\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\x56\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],

        ["\xD6\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\x59\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],

        ["\xD6\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\x59\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],

        ["\xD6\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\x59\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],

        ["\xD6\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\x52\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],

        ["\xD6\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\x59\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],

        ["\xD6\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x58\xBB"],
        ["\x58\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],

        ["\xD6\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\x59\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],

        ["\xD6\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\x59\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],

        ["\xD6\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\x59\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],

        ["\xD6\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\x59\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],

        ["\xD6\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\x59\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],

        ["\xD6\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\x59\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],

        ["\xD6\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\x59\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],

        ["\xD6\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\x59\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],

        ["\xD6\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\x59\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],

        ["\xD6\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\x59\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],

        ["\xD6\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\x59\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],

        ["\xD6\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\x59\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],

        ["\xD6\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\x59\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],

        ["\xD6\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8C"],
        ["\x59\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],

        ["\xD6\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\x59\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\xD6\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\x59\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],

        ["\xD6\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\x59\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],

        ["\xD6\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF1"],
        ["\x54\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],

        ["\xD6\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x81"],
        ["\x59\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],

        ["\xD6\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\x59\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],

        ["\xD6\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\x59\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\x59\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\x51\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\x59\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\x59\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\x59\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\x59\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\x59\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\x59\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x82"],
        ["\x59\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],

        ["\xD6\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x83"],
        ["\x59\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],

        ["\xD6\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x85"],
        ["\x59\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],

        ["\xD6\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x86"],
        ["\x59\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],

        ["\xD6\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x88"],
        ["\x59\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],

        ["\xD6\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x89"],
        ["\x59\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],

        ["\xD6\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8A"],
        ["\x59\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],

        ["\xD6\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\x59\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8D"],
        ["\x59\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8E"],
        ["\x59\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x90"],
        ["\x59\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x91"],
        ["\x59\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x84"],
        ["\x4F\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x8F"],
        ["\x59\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x92"],
        ["\x59\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x94"],
        ["\x59\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x96"],
        ["\x59\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],

        ["\xD6\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x81"],
        ["\x52\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],

        ["\xD6\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x98"],
        ["\x59\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],

        ["\xD6\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x99"],
        ["\x59\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],

        ["\xD6\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xDF"],
        ["\x51\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],

        ["\xD6\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9A"],
        ["\x59\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],

        ["\xD6\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\x59\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\x4A\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],

        ["\xD6\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\x59\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD6\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9D"],
        ["\x59\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],

        ["\xD6\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9E"],
        ["\x59\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],

        ["\xD6\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\x9F"],
        ["\x59\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],

        ["\xD6\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\x59\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\xD6\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\x59\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],

        ["\xD6\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\x59\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],

        ["\xD6\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBE"],
        ["\x54\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],

        ["\xD6\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA3"],
        ["\x59\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],

        ["\xD6\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA4"],
        ["\x59\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],

        ["\xD6\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\x59\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],

        ["\xD6\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA7"],
        ["\x59\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],

        ["\xD6\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA8"],
        ["\x59\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],

        ["\xD6\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA9"],
        ["\x59\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],

        ["\xD6\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x83"],
        ["\x54\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAA"],
        ["\x59\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\x59\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xA6"],
        ["\x59\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\x59\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAD"],
        ["\x59\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\xD6\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAE"],
        ["\x59\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\xD6\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\x68\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xAF"],
        ["\x59\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\x59\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB1"],
        ["\x59\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],

        ["\xD6\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB2"],
        ["\x59\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],

        ["\xD6\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB3"],
        ["\x59\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],

        ["\xD6\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB4"],
        ["\x59\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],

        ["\xD6\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB5"],
        ["\x59\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],

        ["\xD7\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\x53\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD7\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE9"],
        ["\x50\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],

        ["\xD7\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB6"],
        ["\x59\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],

        ["\xD7\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB7"],
        ["\x59\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],

        ["\xD7\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB8"],
        ["\x59\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],

        ["\xD7\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xB9"],
        ["\x59\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],

        ["\xD7\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\x59\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],

        ["\xD7\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBB"],
        ["\x59\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],

        ["\xD7\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\x59\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],

        ["\xD7\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBD"],
        ["\x59\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],

        ["\xD7\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\x59\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\x59\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],

        ["\xD7\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xBE"],
        ["\x59\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],

        ["\xD7\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\x59\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],

        ["\xD7\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD6"],
        ["\x52\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],

        ["\xD7\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\x54\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\x59\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],

        ["\xD7\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\x59\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],

        ["\xD7\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\x59\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],

        ["\xD7\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\x59\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],

        ["\xD7\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\x59\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],

        ["\xD7\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\x59\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],

        ["\xD7\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\x59\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],

        ["\xD7\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\x59\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],

        ["\xD7\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\x59\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],

        ["\xD7\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xCC"],
        ["\x59\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],

        ["\xD7\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\x59\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],

        ["\xD7\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xCF"],
        ["\x59\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],

        ["\xD7\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\x59\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],

        ["\xD7\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xCA"],
        ["\x59\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],

        ["\xD7\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\x59\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\x59\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\x59\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\x59\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\x59\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x9C"],
        ["\x52\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\x59\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\x59\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\x59\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDC"],
        ["\x59\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\x59\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],

        ["\xD7\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDE"],
        ["\x59\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],

        ["\xD7\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xDF"],
        ["\x59\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],

        ["\xD7\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE1"],
        ["\x59\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],

        ["\xD7\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\x59\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],

        ["\xD7\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\x59\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],

        ["\xD7\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\x59\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\x59\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\x59\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\x59\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\x59\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\x59\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\x59\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xEB"],
        ["\x59\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\x59\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xED"],
        ["\x59\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xEE"],
        ["\x59\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],

        ["\xD7\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\x59\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],

        ["\xD7\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\x52\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],

        ["\xD7\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\x59\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],

        ["\xD7\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\x59\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],

        ["\xD7\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\x5A\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],

        ["\xD7\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\x59\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\x59\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],

        ["\xD7\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\x59\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\x59\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\x59\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD7\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\x59\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD7\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\x59\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\x59\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\x59\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xFD"],
        ["\x59\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\x59\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],

        ["\xD7\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\x5A\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],

        ["\xD7\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\x5A\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],

        ["\xD7\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\x5A\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],

        ["\xD7\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\x5A\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],

        ["\xD7\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\x5A\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],

        ["\xD7\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\x5A\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\x5A\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\x5A\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\x5A\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\x5A\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\x5A\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\x52\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\x5A\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\x5A\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\x5A\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\x5A\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],

        ["\xD7\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\x55\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],

        ["\xD7\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\x55\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],

        ["\xD7\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\x5A\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],

        ["\xD7\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\x5A\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],

        ["\xD8\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\x5A\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD8\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\x5A\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],

        ["\xD8\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\x5A\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],

        ["\xD8\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\x5A\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],

        ["\xD8\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\x5A\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],

        ["\xD8\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\x5A\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],

        ["\xD8\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\x5A\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],

        ["\xD8\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\x5A\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],

        ["\xD8\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\x5A\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],

        ["\xD8\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\x5A\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],

        ["\xD8\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\x5A\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xA3"],
        ["\x53\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],

        ["\xD8\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x59\xEF"],
        ["\x59\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],

        ["\xD8\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\x5A\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],

        ["\xD8\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\x5A\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],

        ["\xD8\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\x5A\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\x5A\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],

        ["\xD8\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\x5A\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],

        ["\xD8\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\x5A\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],

        ["\xD8\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\x5A\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],

        ["\xD8\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\x5A\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],

        ["\xD8\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\x5A\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],

        ["\xD8\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\x5A\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],

        ["\xD8\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\x5A\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],

        ["\xD8\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\x5A\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],

        ["\xD8\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\x5A\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],

        ["\xD8\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\x5A\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],

        ["\xD8\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\x5A\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],

        ["\xD8\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\x5A\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],

        ["\xD8\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\x5A\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],

        ["\xD8\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\x5A\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],

        ["\xD8\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\x5A\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\x5A\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\x5A\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\x5A\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\x5A\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE3"],
        ["\x51\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\x5A\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\x5A\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x81"],
        ["\x5A\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x84"],
        ["\x5A\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x85"],
        ["\x5A\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],

        ["\xD8\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x86"],
        ["\x5A\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],

        ["\xD8\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x87"],
        ["\x5A\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],

        ["\xD8\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x89"],
        ["\x5A\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],

        ["\xD8\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8A"],
        ["\x5A\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],

        ["\xD8\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\x5A\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],

        ["\xD8\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8C"],
        ["\x5A\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8D"],
        ["\x5A\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8E"],
        ["\x5A\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x8F"],
        ["\x5A\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x82"],
        ["\x5A\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x90"],
        ["\x5A\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x91"],
        ["\x5A\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x83"],
        ["\x5A\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x92"],
        ["\x5A\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x93"],
        ["\x5A\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x95"],
        ["\x5A\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],

        ["\xD8\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x96"],
        ["\x5A\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],

        ["\xD8\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x88"],
        ["\x5A\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],

        ["\xD8\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x97"],
        ["\x5A\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],

        ["\xD8\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x98"],
        ["\x5A\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],

        ["\xD8\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xCF"],
        ["\x55\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],

        ["\xD8\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x99"],
        ["\x5A\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9A"],
        ["\x5A\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],

        ["\xD8\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\x5A\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\x5A\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9D"],
        ["\x5A\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9E"],
        ["\x5A\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\x9F"],
        ["\x5A\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\x5A\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\x5A\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\x5A\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA2"],
        ["\x5A\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],

        ["\xD8\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA3"],
        ["\x5A\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],

        ["\xD8\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA4"],
        ["\x5A\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],

        ["\xD8\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA5"],
        ["\x5A\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],

        ["\xD8\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\x5A\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],

        ["\xD8\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\x5A\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],

        ["\xD8\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\x5A\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\x5A\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\x5A\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\x5A\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAE"],
        ["\x5A\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\x5A\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xAF"],
        ["\x5A\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\x5A\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB1"],
        ["\x5A\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB2"],
        ["\x5A\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB3"],
        ["\x5A\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],

        ["\xD8\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB4"],
        ["\x5A\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],

        ["\xD8\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\x54\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],

        ["\xD8\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB6"],
        ["\x5A\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],

        ["\xD8\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB7"],
        ["\x5A\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],

        ["\xD9\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\x5A\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xD9\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xB9"],
        ["\x5A\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],

        ["\xD9\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBA"],
        ["\x5A\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],

        ["\xD9\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBB"],
        ["\x5A\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],

        ["\xD9\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\x5A\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],

        ["\xD9\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBD"],
        ["\x5A\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],

        ["\xD9\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\x5A\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],

        ["\xD9\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xBF"],
        ["\x5A\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],

        ["\xD9\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\x5A\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],

        ["\xD9\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\x5A\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],

        ["\xD9\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\x5A\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\x5A\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],

        ["\xD9\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\x5A\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],

        ["\xD9\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\x5A\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],

        ["\xD9\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\x5A\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],

        ["\xD9\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\x5A\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\x5A\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],

        ["\xD9\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCA"],
        ["\x5A\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],

        ["\xD9\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\x5A\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],

        ["\xD9\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\x5A\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],

        ["\xD9\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCC"],
        ["\x5A\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],

        ["\xD9\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\x5A\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],

        ["\xD9\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCD"],
        ["\x5A\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],

        ["\xD9\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\x5A\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],

        ["\xD9\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xCF"],
        ["\x5A\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],

        ["\xD9\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\x5A\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],

        ["\xD9\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\x5A\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],

        ["\xD9\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\x5A\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],

        ["\xD9\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\x5A\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],

        ["\xD9\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\x5A\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],

        ["\xD9\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\x5B\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],

        ["\xD9\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\x5A\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\x5A\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\x53\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\x5A\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\x5A\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xDB"],
        ["\x5A\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xDC"],
        ["\x5A\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xDD"],
        ["\x5A\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xDE"],
        ["\x5A\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xDF"],
        ["\x5A\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\x5A\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],

        ["\xD9\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\x5A\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],

        ["\xD9\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\x5A\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],

        ["\xD9\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\x5A\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],

        ["\xD9\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\x5A\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],

        ["\xD9\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\x5A\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],

        ["\xD9\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\x5A\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\x5A\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\x5A\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\x5B\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\x5A\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xEB"],
        ["\x5A\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xEC"],
        ["\x5A\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xED"],
        ["\x5A\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xEE"],
        ["\x5A\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xEF"],
        ["\x5A\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\x5A\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],

        ["\xD9\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\x5A\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],

        ["\xD9\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\x5A\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],

        ["\xD9\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\x5A\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],

        ["\xD9\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\x5A\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],

        ["\xD9\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\x5A\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],

        ["\xD9\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\x5A\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\x5A\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],

        ["\xD9\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\x5A\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\x5A\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\x5A\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xFC"],
        ["\x5A\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\x5A\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\x5A\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\x5B\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\x5B\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\x5B\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],

        ["\xD9\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\x5B\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],

        ["\xD9\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\x5B\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],

        ["\xD9\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\x5B\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],

        ["\xD9\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\x5B\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],

        ["\xD9\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\x5B\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],

        ["\xD9\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\x5B\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\x5B\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\x5B\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\x5B\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\x5B\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\x5B\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\x5B\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\x5B\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xD9\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x7F"],
        ["\x52\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xD9\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\x5B\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\x5B\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],

        ["\xD9\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\x5B\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],

        ["\xD9\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\x5B\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],

        ["\xD9\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\x5B\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],

        ["\xD9\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\x5B\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],

        ["\xDA\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\x5B\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],

        ["\xDA\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\x5B\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],

        ["\xDA\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\x5B\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],

        ["\xDA\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\x5B\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],

        ["\xDA\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\x5B\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],

        ["\xDA\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\x5B\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],

        ["\xDA\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\x5B\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],

        ["\xDA\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\x5B\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],

        ["\xDA\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\x5B\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],

        ["\xDA\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\x57\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],

        ["\xDA\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\x5B\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],

        ["\xDA\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\x5B\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],

        ["\xDA\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\x5A\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],

        ["\xDA\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\x5B\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],

        ["\xDA\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\x5B\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],

        ["\xDA\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\x5B\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],

        ["\xDA\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\x5B\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],

        ["\xDA\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\x5B\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],

        ["\xDA\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\x5B\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],

        ["\xDA\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\x5B\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],

        ["\xDA\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\x5B\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],

        ["\xDA\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\x5B\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],

        ["\xDA\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\x5B\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],

        ["\xDA\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\x5B\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],

        ["\xDA\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\x5B\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],

        ["\xDA\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\x5B\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],

        ["\xDA\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\x5B\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],

        ["\xDA\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\x5B\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],

        ["\xDA\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\x5B\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],

        ["\xDA\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\x5B\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],

        ["\xDA\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\x5B\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],

        ["\xDA\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\x5B\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],

        ["\xDA\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\x5B\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],

        ["\xDA\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\x5B\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],

        ["\xDA\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\x5B\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],

        ["\xDA\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\x5B\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],

        ["\xDA\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x82"],
        ["\x5B\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],

        ["\xDA\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\x5B\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],

        ["\xDA\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x81"],
        ["\x5B\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],

        ["\xDA\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB1"],
        ["\x51\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],

        ["\xDA\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x83"],
        ["\x5B\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],

        ["\xDA\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x84"],
        ["\x5B\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],

        ["\xDA\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x85"],
        ["\x5B\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],

        ["\xDA\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x86"],
        ["\x5B\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],

        ["\xDA\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x87"],
        ["\x5B\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],

        ["\xDA\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x88"],
        ["\x5B\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],

        ["\xDA\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x89"],
        ["\x5B\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],

        ["\xDA\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8A"],
        ["\x5B\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],

        ["\xDA\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\x5B\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],

        ["\xDA\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8C"],
        ["\x5B\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],

        ["\xDA\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8D"],
        ["\x5B\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],

        ["\xDA\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8E"],
        ["\x5B\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],

        ["\xDA\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x8F"],
        ["\x5B\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],

        ["\xDA\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x90"],
        ["\x5B\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],

        ["\xDA\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x91"],
        ["\x5B\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],

        ["\xDA\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x92"],
        ["\x5B\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],

        ["\xDA\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\x51\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],

        ["\xDA\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x93"],
        ["\x5B\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],

        ["\xDA\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x95"],
        ["\x5B\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],

        ["\xDA\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x94"],
        ["\x5B\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],

        ["\xDA\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x96"],
        ["\x5B\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],

        ["\xDA\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x9A"],
        ["\x5B\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],

        ["\xDA\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8E"],
        ["\x52\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],

        ["\xDA\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\x5B\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],

        ["\xDA\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\x5B\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],

        ["\xDA\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\x5B\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],

        ["\xDA\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x9F"],
        ["\x5B\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],

        ["\xDA\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x93"],
        ["\x51\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],

        ["\xDA\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xA2"],
        ["\x5B\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],

        ["\xDA\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xA3"],
        ["\x5B\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],

        ["\xDA\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xEA"],
        ["\x51\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],

        ["\xDA\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\x5B\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],

        ["\xDA\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xA6"],
        ["\x5B\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],

        ["\xDA\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\x52\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],

        ["\xDA\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\x5B\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],

        ["\xDA\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xAD"],
        ["\x5B\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],

        ["\xDA\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xAA"],
        ["\x5B\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],

        ["\xDA\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xA0"],
        ["\x50\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],

        ["\xDA\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB2"],
        ["\x51\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],

        ["\xDA\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xCE"],
        ["\x4F\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],

        ["\xDA\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xAC"],
        ["\x5B\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],

        ["\xDA\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\x5B\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],

        ["\xDA\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\x5B\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],

        ["\xDA\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB2"],
        ["\x5B\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],

        ["\xDA\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\x4F\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],

        ["\xDA\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xD1"],
        ["\x4E\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],

        ["\xDA\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB3"],
        ["\x5B\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],

        ["\xDA\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB5"],
        ["\x5B\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],

        ["\xDA\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\x5B\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],

        ["\xDA\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xBA"],
        ["\x5B\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],

        ["\xDA\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\x52\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],

        ["\xDA\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\x5B\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],

        ["\xDA\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xBD"],
        ["\x5B\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],

        ["\xDA\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xBE"],
        ["\x5B\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],

        ["\xDB\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xB9"],
        ["\x5B\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],

        ["\xDB\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\x5B\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],

        ["\xDB\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\x5B\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],

        ["\xDB\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\x5B\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],

        ["\xDB\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCC"],
        ["\x51\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],

        ["\xDB\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\x9E"],
        ["\x5B\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],

        ["\xDB\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\x5B\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],

        ["\xDB\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\x5B\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],

        ["\xDB\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\x5B\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],

        ["\xDB\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\x5B\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],

        ["\xDB\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\x5B\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],

        ["\xDB\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xFD"],
        ["\x54\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],

        ["\xDB\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCA"],
        ["\x5B\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],

        ["\xDB\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCB"],
        ["\x5B\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],

        ["\xDB\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\x5B\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],

        ["\xDB\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\x5B\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],

        ["\xDB\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCF"],
        ["\x5B\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],

        ["\xDB\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\x5B\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],

        ["\xDB\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\x5B\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],

        ["\xDB\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\x5B\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],

        ["\xDB\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\x53\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],

        ["\xDB\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\x5B\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],

        ["\xDB\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\x5B\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],

        ["\xDB\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\x5B\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],

        ["\xDB\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\x5B\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],

        ["\xDB\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x80"],
        ["\x54\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],

        ["\xDB\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\x5B\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],

        ["\xDB\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x91"],
        ["\x52\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],

        ["\xDB\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\x5B\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],

        ["\xDB\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\x5B\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],

        ["\xDB\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDC"],
        ["\x5B\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],

        ["\xDB\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\x5B\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],

        ["\xDB\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xDF"],
        ["\x54\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],

        ["\xDB\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDE"],
        ["\x5B\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],

        ["\xDB\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF2"],
        ["\x54\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],

        ["\xDB\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\x5B\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],

        ["\xDB\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\x5B\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],

        ["\xDB\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\x5B\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],

        ["\xDB\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\x5B\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],

        ["\xDB\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\x5B\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],

        ["\xDB\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\x5B\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],

        ["\xDB\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\x5B\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],

        ["\xDB\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\x5B\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],

        ["\xDB\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC9"],
        ["\x54\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],

        ["\xDB\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\x5B\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],

        ["\xDB\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\x5B\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],

        ["\xDB\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xEB"],
        ["\x5B\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],

        ["\xDB\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF3"],
        ["\x54\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],

        ["\xDB\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\x5B\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],

        ["\xDB\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xEE"],
        ["\x5B\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],

        ["\xDB\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xEF"],
        ["\x5B\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],

        ["\xDB\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\x5B\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],

        ["\xDB\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\x5B\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],

        ["\xDB\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\x5B\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],

        ["\xDB\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xEA"],
        ["\x5B\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],

        ["\xDB\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\x4D\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],

        ["\xDB\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\x5B\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],

        ["\xDB\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\x5B\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],

        ["\xDB\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xDE"],
        ["\x52\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],

        ["\xDB\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\x5B\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],

        ["\xDB\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\x5B\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],

        ["\xDB\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\x5B\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],

        ["\xDB\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\x5B\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],

        ["\xDB\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\x53\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],

        ["\xDB\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE2"],
        ["\x52\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],

        ["\xDB\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\x5B\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],

        ["\xDB\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\x5B\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],

        ["\xDB\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\x5C\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],

        ["\xDB\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\x5C\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],

        ["\xDB\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\x5C\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],

        ["\xDB\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\x5C\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],

        ["\xDB\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\x5C\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],

        ["\xDB\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\x5C\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],

        ["\xDB\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x92"],
        ["\x4E\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],

        ["\xDB\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBC"],
        ["\x53\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],

        ["\xDB\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\x5C\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],

        ["\xDB\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\x54\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],

        ["\xDB\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\x5C\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],

        ["\xDB\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\x5C\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],

        ["\xDB\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\x5C\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],

        ["\xDB\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC6"],
        ["\x52\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],

        ["\xDB\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\x5C\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],

        ["\xDB\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\x5C\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],

        ["\xDB\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\x5B\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],

        ["\xDB\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\x5C\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],

        ["\xDB\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\x5C\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],

        ["\xDB\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\x5C\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],

        ["\xDB\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\x5C\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],

        ["\xDB\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\x5C\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],

        ["\xDB\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\x5C\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],

        ["\xDB\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\x5C\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],

        ["\xDB\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\x5C\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],

        ["\xDB\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\x5C\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],

        ["\xDB\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\x5C\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],

        ["\xDC\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\x5C\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],

        ["\xDC\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\x5C\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],

        ["\xDC\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\x5C\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],

        ["\xDC\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\x5C\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],

        ["\xDC\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\x5C\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],

        ["\xDC\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\x5C\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],

        ["\xDC\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC2"],
        ["\x54\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],

        ["\xDC\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\x5C\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],

        ["\xDC\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xFA"],
        ["\x53\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],

        ["\xDC\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x94"],
        ["\x54\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],

        ["\xDC\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\x5C\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],

        ["\xDC\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\x5C\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],

        ["\xDC\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\x5C\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],

        ["\xDC\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\x5C\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],

        ["\xDC\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\x53\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],

        ["\xDC\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\x5C\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],

        ["\xDC\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\x5C\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],

        ["\xDC\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\x5C\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],

        ["\xDC\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\x5C\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],

        ["\xDC\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\x5C\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],

        ["\xDC\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE2"],
        ["\x54\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],

        ["\xDC\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\x5C\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],

        ["\xDC\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA2"],
        ["\x54\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],

        ["\xDC\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\x5C\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],

        ["\xDC\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\x5C\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],

        ["\xDC\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xEF"],
        ["\x53\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],

        ["\xDC\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xED"],
        ["\x52\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],

        ["\xDC\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\x5C\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],

        ["\xDC\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\x5C\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],

        ["\xDC\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\x5C\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],

        ["\xDC\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\x5C\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],

        ["\xDC\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\x52\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],

        ["\xDC\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\x5C\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],

        ["\xDC\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\x5C\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],

        ["\xDC\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\x5C\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],

        ["\xDC\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\x5C\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],

        ["\xDC\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\x5C\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],

        ["\xDC\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\x51\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],

        ["\xDC\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x8C"],
        ["\x54\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],

        ["\xDC\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\x5C\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],

        ["\xDC\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\x5C\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],

        ["\xDC\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\x5C\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],

        ["\xDC\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\x5C\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],

        ["\xDC\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\x5C\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],

        ["\xDC\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\x5C\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],

        ["\xDC\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x7F"],
        ["\x5C\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],

        ["\xDC\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x81"],
        ["\x5C\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],

        ["\xDC\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x82"],
        ["\x5C\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],

        ["\xDC\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x83"],
        ["\x5C\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],

        ["\xDC\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8D"],
        ["\x53\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],

        ["\xDC\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x88"],
        ["\x5C\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],

        ["\xDC\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\x54\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],

        ["\xDC\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x84"],
        ["\x5C\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],

        ["\xDC\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x85"],
        ["\x5C\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],

        ["\xDC\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x86"],
        ["\x5C\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],

        ["\xDC\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\x53\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],

        ["\xDC\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x87"],
        ["\x5C\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],

        ["\xDC\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x89"],
        ["\x5C\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],

        ["\xDC\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8A"],
        ["\x5C\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],

        ["\xDC\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8B"],
        ["\x5C\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],

        ["\xDC\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8C"],
        ["\x5C\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],

        ["\xDC\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\x5C\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],

        ["\xDC\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8D"],
        ["\x5C\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],

        ["\xDC\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8E"],
        ["\x5C\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],

        ["\xDC\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x8F"],
        ["\x5C\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],

        ["\xDC\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xBB"],
        ["\x53\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],

        ["\xDC\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x80"],
        ["\x5C\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],

        ["\xDC\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x91"],
        ["\x5C\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],

        ["\xDC\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x92"],
        ["\x5C\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],

        ["\xDC\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x93"],
        ["\x5C\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],

        ["\xDC\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x94"],
        ["\x5C\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],

        ["\xDC\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x95"],
        ["\x5C\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],

        ["\xDC\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x97"],
        ["\x5C\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],

        ["\xDC\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB7"],
        ["\x5C\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],

        ["\xDC\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x98"],
        ["\x5C\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],

        ["\xDC\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x99"],
        ["\x5C\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],

        ["\xDC\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x9C"],
        ["\x5C\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],

        ["\xDC\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x9D"],
        ["\x5C\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],

        ["\xDC\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA8"],
        ["\x5C\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],

        ["\xDC\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x9F"],
        ["\x5C\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],

        ["\xDC\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA0"],
        ["\x5C\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],

        ["\xDC\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA1"],
        ["\x5C\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],

        ["\xDC\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\x5C\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],

        ["\xDC\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA3"],
        ["\x5C\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],

        ["\xDC\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\x5C\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],

        ["\xDC\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA5"],
        ["\x5C\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],

        ["\xDC\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\x5C\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],

        ["\xDC\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x96"],
        ["\x5C\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],

        ["\xDC\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xAA"],
        ["\x5C\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],

        ["\xDC\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xAB"],
        ["\x5C\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],

        ["\xDC\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\x9E"],
        ["\x5C\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],

        ["\xDC\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xAC"],
        ["\x5C\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],

        ["\xDC\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xAD"],
        ["\x5C\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],

        ["\xDC\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\x5C\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],

        ["\xDD\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\x5C\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],

        ["\xDD\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\x5C\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],

        ["\xDD\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB3"],
        ["\x5C\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],

        ["\xDD\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x8B"],
        ["\x52\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],

        ["\xDD\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB4"],
        ["\x5C\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],

        ["\xDD\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB5"],
        ["\x5C\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],

        ["\xDD\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\x5C\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],

        ["\xDD\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\x5C\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],

        ["\xDD\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\x5C\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],

        ["\xDD\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\x5C\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],

        ["\xDD\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\x53\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],

        ["\xDD\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\x5C\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],

        ["\xDD\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\x5C\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],

        ["\xDD\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\x5C\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],

        ["\xDD\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\x52\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],

        ["\xDD\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC0"],
        ["\x5C\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],

        ["\xDD\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\x5C\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],

        ["\xDD\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC2"],
        ["\x5C\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],

        ["\xDD\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC3"],
        ["\x5C\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],

        ["\xDD\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\x5C\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],

        ["\xDD\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\x86"],
        ["\x67\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],

        ["\xDD\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC5"],
        ["\x5C\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],

        ["\xDD\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC6"],
        ["\x5C\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],

        ["\xDD\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"],
        ["\x5C\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],

        ["\xDD\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC9"],
        ["\x5C\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],

        ["\xDD\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xC8"],
        ["\x5C\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],

        ["\xDD\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCA"],
        ["\x5C\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],

        ["\xDD\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCB"],
        ["\x5C\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],

        ["\xDD\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCC"],
        ["\x5C\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],

        ["\xDD\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCD"],
        ["\x5C\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],

        ["\xDD\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\x5C\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],

        ["\xDD\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xCF"],
        ["\x5C\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],

        ["\xDD\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD0"],
        ["\x5C\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],

        ["\xDD\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\x5C\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],

        ["\xDD\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD2"],
        ["\x5C\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],

        ["\xDD\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\x5C\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],

        ["\xDD\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD4"],
        ["\x5C\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],

        ["\xDD\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\x5C\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],

        ["\xDD\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD6"],
        ["\x5C\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],

        ["\xDD\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD7"],
        ["\x5C\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],

        ["\xDD\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD8"],
        ["\x5C\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],

        ["\xDD\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xD9"],
        ["\x5C\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],

        ["\xDD\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\x5C\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],

        ["\xDD\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\x5C\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],

        ["\xDD\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\x5C\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],

        ["\xDD\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDD"],
        ["\x5C\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],

        ["\xDD\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDE"],
        ["\x5C\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],

        ["\xDD\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xDF"],
        ["\x5C\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],

        ["\xDD\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE0"],
        ["\x5C\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],

        ["\xDD\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE1"],
        ["\x5C\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],

        ["\xDD\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE3"],
        ["\x5C\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],

        ["\xDD\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE2"],
        ["\x5C\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],

        ["\xDD\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\x5C\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],

        ["\xDD\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE5"],
        ["\x5C\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],

        ["\xDD\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\x5C\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],

        ["\xDD\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\x5C\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],

        ["\xDD\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\x5C\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],

        ["\xDD\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\x5C\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],

        ["\xDD\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xEB"],
        ["\x5C\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],

        ["\xDD\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xEC"],
        ["\x5C\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],

        ["\xDD\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\x5C\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],

        ["\xDD\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xEE"],
        ["\x5C\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],

        ["\xDD\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xEF"],
        ["\x5C\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],

        ["\xDD\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\x68\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],

        ["\xDD\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\x5C\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],

        ["\xDD\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF1"],
        ["\x5C\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],

        ["\xDD\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF2"],
        ["\x5C\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],

        ["\xDD\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\x5C\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],

        ["\xDD\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\x5C\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],

        ["\xDD\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\x5C\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],

        ["\xDD\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\x5C\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],

        ["\xDD\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\x5C\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],

        ["\xDD\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\x5C\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],

        ["\xDD\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB4"],
        ["\x52\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],

        ["\xDD\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xFB"],
        ["\x5C\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],

        ["\xDD\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\x5C\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],

        ["\xDD\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\x5D\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],

        ["\xDD\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\x5D\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],

        ["\xDD\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\x5D\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],

        ["\xDD\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\x5D\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],

        ["\xDD\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\x5D\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],

        ["\xDD\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\x5D\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],

        ["\xDD\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\x5D\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],

        ["\xDD\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\x5D\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],

        ["\xDD\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\x5D\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],

        ["\xDD\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\x5D\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],

        ["\xDD\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD7"],
        ["\x54\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],

        ["\xDD\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\x5D\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],

        ["\xDD\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xC6"],
        ["\x55\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],

        ["\xDD\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\x5D\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],

        ["\xDD\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\x5D\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],

        ["\xDD\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\x5D\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],

        ["\xDD\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\x5D\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],

        ["\xDD\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\x5D\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],

        ["\xDE\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\x5D\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],

        ["\xDE\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\x5D\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],

        ["\xDE\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\x5D\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],

        ["\xDE\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\x5D\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],

        ["\xDE\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\x5D\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],

        ["\xDE\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\x5D\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],

        ["\xDE\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\x63\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],

        ["\xDE\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\x5D\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],

        ["\xDE\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\x5D\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],

        ["\xDE\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\x5D\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],

        ["\xDE\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xBC"],
        ["\x50\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],

        ["\xDE\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB6"],
        ["\x52\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],

        ["\xDE\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAC"],
        ["\x52\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],

        ["\xDE\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\x5D\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],

        ["\xDE\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\x5D\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],

        ["\xDE\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\x5D\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],

        ["\xDE\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\x5D\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],

        ["\xDE\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\x5D\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],

        ["\xDE\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\x5D\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],

        ["\xDE\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\x5D\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],

        ["\xDE\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\x5D\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],

        ["\xDE\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\x5D\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],

        ["\xDE\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\x5D\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],

        ["\xDE\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\x5D\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],

        ["\xDE\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD2"],
        ["\x51\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],

        ["\xDE\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\x5D\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],

        ["\xDE\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\x5D\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],

        ["\xDE\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\x51\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],

        ["\xDE\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\x5D\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],

        ["\xDE\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\x5D\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],

        ["\xDE\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\x5D\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],

        ["\xDE\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\x5D\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],

        ["\xDE\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\x5D\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],

        ["\xDE\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\x5D\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],

        ["\xDE\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\x5D\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],

        ["\xDE\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\x5D\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],

        ["\xDE\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\x5D\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],

        ["\xDE\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\x5D\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],

        ["\xDE\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\x5D\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],

        ["\xDE\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\x5D\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],

        ["\xDE\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\x5D\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],

        ["\xDE\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\x5D\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],

        ["\xDE\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x81"],
        ["\x5D\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],

        ["\xDE\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x82"],
        ["\x5D\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],

        ["\xDE\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x83"],
        ["\x5D\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],

        ["\xDE\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x84"],
        ["\x5D\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],

        ["\xDE\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x85"],
        ["\x5D\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],

        ["\xDE\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x86"],
        ["\x5D\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],

        ["\xDE\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\x5D\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],

        ["\xDE\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x87"],
        ["\x5D\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],

        ["\xDE\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x88"],
        ["\x5D\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],

        ["\xDE\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x89"],
        ["\x5D\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],

        ["\xDE\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x8B"],
        ["\x5D\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],

        ["\xDE\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x8C"],
        ["\x5D\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],

        ["\xDE\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x8D"],
        ["\x5D\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],

        ["\xDE\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x8F"],
        ["\x5D\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],

        ["\xDE\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x90"],
        ["\x5D\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],

        ["\xDE\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x91"],
        ["\x5D\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],

        ["\xDE\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x92"],
        ["\x5D\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],

        ["\xDE\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x94"],
        ["\x5D\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],

        ["\xDE\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x96"],
        ["\x5D\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],

        ["\xDE\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x97"],
        ["\x5D\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],

        ["\xDE\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x98"],
        ["\x5D\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],

        ["\xDE\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB4"],
        ["\x5D\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],

        ["\xDE\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x99"],
        ["\x5D\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],

        ["\xDE\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9A"],
        ["\x5D\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],

        ["\xDE\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9B"],
        ["\x5D\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],

        ["\xDE\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9C"],
        ["\x5D\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],

        ["\xDE\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9D"],
        ["\x5D\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],

        ["\xDE\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xA9"],
        ["\x52\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],

        ["\xDE\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9E"],
        ["\x5D\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],

        ["\xDE\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\x52\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],

        ["\xDE\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\x9F"],
        ["\x5D\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],

        ["\xDE\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA0"],
        ["\x5D\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],

        ["\xDE\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA1"],
        ["\x5D\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],

        ["\xDE\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA2"],
        ["\x5D\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],

        ["\xDE\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA3"],
        ["\x5D\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],

        ["\xDE\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA4"],
        ["\x5D\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],

        ["\xDE\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA5"],
        ["\x5D\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],

        ["\xDE\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\x53\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],

        ["\xDE\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\x5D\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],

        ["\xDE\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\x5D\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],

        ["\xDE\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xA9"],
        ["\x5D\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],

        ["\xDE\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\x55\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],

        ["\xDE\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xEA"],
        ["\x53\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],

        ["\xDE\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAB"],
        ["\x5D\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],

        ["\xDE\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAC"],
        ["\x5D\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],

        ["\xDE\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAD"],
        ["\x5D\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],

        ["\xDE\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAE"],
        ["\x5D\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],

        ["\xDE\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xAF"],
        ["\x5D\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],

        ["\xDE\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\x5D\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],

        ["\xDE\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB1"],
        ["\x5D\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],

        ["\xDE\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB2"],
        ["\x5D\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],

        ["\xDE\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\x5D\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],

        ["\xDF\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB5"],
        ["\x5D\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],

        ["\xDF\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB6"],
        ["\x5D\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],

        ["\xDF\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB7"],
        ["\x5D\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],

        ["\xDF\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB8"],
        ["\x5D\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],

        ["\xDF\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\x5D\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],

        ["\xDF\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\x5D\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],

        ["\xDF\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA0"],
        ["\x55\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],

        ["\xDF\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBB"],
        ["\x5D\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],

        ["\xDF\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBC"],
        ["\x5D\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],

        ["\xDF\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBD"],
        ["\x5D\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],

        ["\xDF\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE2"],
        ["\x5D\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],

        ["\xDF\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBE"],
        ["\x5D\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],

        ["\xDF\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC0"],
        ["\x5D\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],

        ["\xDF\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\x5D\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],

        ["\xDF\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\x5D\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],

        ["\xDF\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\x5D\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],

        ["\xDF\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\x5D\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],

        ["\xDF\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xCF"],
        ["\x5D\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],

        ["\xDF\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\x5D\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],

        ["\xDF\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC8"],
        ["\x5D\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],

        ["\xDF\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC9"],
        ["\x5D\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],

        ["\xDF\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xCB"],
        ["\x5D\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],

        ["\xDF\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\x4E\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],

        ["\xDF\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xCC"],
        ["\x5D\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],

        ["\xDF\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xC4"],
        ["\x5D\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],

        ["\xDF\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xCE"],
        ["\x5D\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],

        ["\xDF\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD0"],
        ["\x5D\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],

        ["\xDF\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD1"],
        ["\x5D\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],

        ["\xDF\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\x5D\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],

        ["\xDF\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\x5D\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],

        ["\xDF\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD3"],
        ["\x5D\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],

        ["\xDF\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\x50\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],

        ["\xDF\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD6"],
        ["\x5D\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],

        ["\xDF\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xCD"],
        ["\x5D\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],

        ["\xDF\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xD9"],
        ["\x5D\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],

        ["\xDF\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDA"],
        ["\x5D\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],

        ["\xDF\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDB"],
        ["\x5D\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],

        ["\xDF\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDC"],
        ["\x5D\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],

        ["\xDF\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\x5D\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],

        ["\xDF\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\x5D\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],

        ["\xDF\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x87"],
        ["\x51\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],

        ["\xDF\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\x5D\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],

        ["\xDF\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE0"],
        ["\x5D\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],

        ["\xDF\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xBF"],
        ["\x5D\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],

        ["\xDF\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xB0"],
        ["\x52\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],

        ["\xDF\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\x5D\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],

        ["\xDF\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\x5D\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],

        ["\xDF\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"],
        ["\x5D\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],

        ["\xDF\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\x5D\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],

        ["\xDF\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\x5D\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],

        ["\xDF\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\x5D\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],

        ["\xDF\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xE9"],
        ["\x5D\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],

        ["\xDF\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xEB"],
        ["\x5D\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],

        ["\xDF\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xEE"],
        ["\x4F\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],

        ["\xDF\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\x5D\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],

        ["\xDF\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF7"],
        ["\x5D\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],

        ["\xDF\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xEE"],
        ["\x5D\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],

        ["\xDF\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\x5D\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],

        ["\xDF\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCD"],
        ["\x52\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],

        ["\xDF\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\x5D\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],

        ["\xDF\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\x5D\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],

        ["\xDF\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF2"],
        ["\x5D\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],

        ["\xDF\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x8C"],
        ["\x53\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],

        ["\xDF\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF3"],
        ["\x5D\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],

        ["\xDF\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF4"],
        ["\x5D\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],

        ["\xDF\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF8"],
        ["\x5D\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],

        ["\xDF\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\x5D\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],

        ["\xDF\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\x5D\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],

        ["\xDF\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\x53\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],

        ["\xDF\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x85"],
        ["\x68\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],

        ["\xDF\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\x5E\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],

        ["\xDF\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5D\xFE"],
        ["\x5D\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],

        ["\xDF\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\x5E\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],

        ["\xDF\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\x5E\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],

        ["\xDF\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\x5E\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],

        ["\xDF\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\x5E\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],

        ["\xDF\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\x5E\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],

        ["\xDF\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\x5E\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],

        ["\xDF\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\x5E\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],

        ["\xDF\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\x5E\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],

        ["\xDF\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBB"],
        ["\x54\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],

        ["\xDF\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\x5E\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],

        ["\xDF\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\x5E\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],

        ["\xDF\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\x5E\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],

        ["\xDF\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\x5E\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],

        ["\xDF\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\x5E\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],

        ["\xDF\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\x5E\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],

        ["\xDF\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\x5E\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],

        ["\xDF\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\x5E\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],

        ["\xDF\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\x5E\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],

        ["\xDF\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\x5E\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],

        ["\xDF\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\x5E\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],

        ["\xDF\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\x5E\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],

        ["\xDF\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\x5E\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],

        ["\xE0\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\x5E\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],

        ["\xE0\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\x5E\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],

        ["\xE0\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\x5E\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],

        ["\xE0\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\x5E\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],

        ["\xE0\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\x53\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],

        ["\xE0\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\x5E\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],

        ["\xE0\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\x5E\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],

        ["\xE0\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\x5E\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],

        ["\xE0\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\x5E\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],

        ["\xE0\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\x5E\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],

        ["\xE0\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\x5E\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],

        ["\xE0\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\x5E\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],

        ["\xE0\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\x5E\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],

        ["\xE0\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\x5E\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],

        ["\xE0\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\x5E\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],

        ["\xE0\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\x5E\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],

        ["\xE0\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\x5E\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],

        ["\xE0\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\x5E\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],

        ["\xE0\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\x5E\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],

        ["\xE0\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\x5E\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],

        ["\xE0\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\x5E\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],

        ["\xE0\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\x5E\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],

        ["\xE0\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\x5E\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],

        ["\xE0\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\x5E\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],

        ["\xE0\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\x5E\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],

        ["\xE0\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\x5E\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],

        ["\xE0\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\x5E\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],

        ["\xE0\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\x5E\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],

        ["\xE0\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\x5E\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],

        ["\xE0\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\x5E\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],

        ["\xE0\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\x5E\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],

        ["\xE0\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\x5E\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],

        ["\xE0\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\x5E\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\x5E\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\x5E\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\x5E\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\x5E\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\x5E\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x56\xA1"],
        ["\x56\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x81"],
        ["\x5E\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x82"],
        ["\x5E\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x83"],
        ["\x5E\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],

        ["\xE0\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x84"],
        ["\x5E\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],

        ["\xE0\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x85"],
        ["\x5E\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],

        ["\xE0\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x87"],
        ["\x5E\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],

        ["\xE0\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x89"],
        ["\x5E\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],

        ["\xE0\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x88"],
        ["\x5E\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],

        ["\xE0\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\x5E\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],

        ["\xE0\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x8C"],
        ["\x5E\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x8E"],
        ["\x5E\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x8D"],
        ["\x5E\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x90"],
        ["\x5E\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x8F"],
        ["\x5E\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x91"],
        ["\x5E\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x92"],
        ["\x5E\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x93"],
        ["\x5E\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x95"],
        ["\x5E\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x96"],
        ["\x5E\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],

        ["\xE0\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x97"],
        ["\x5E\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],

        ["\xE0\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCB"],
        ["\x51\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],

        ["\xE0\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x98"],
        ["\x5E\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],

        ["\xE0\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x9A"],
        ["\x5E\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],

        ["\xE0\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\x5E\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],

        ["\xE0\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\x5E\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\x9D"],
        ["\x5E\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],

        ["\xE0\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\x5E\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\x5E\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\x5E\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\x5E\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA9"],
        ["\x5E\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xBE"],
        ["\x5E\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xAC"],
        ["\x5E\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA6"],
        ["\x5E\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xAF"],
        ["\x5E\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],

        ["\xE0\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\x5E\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],

        ["\xE0\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB1"],
        ["\x5E\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],

        ["\xE0\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\x5E\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],

        ["\xE0\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB3"],
        ["\x5E\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],

        ["\xE0\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB4"],
        ["\x5E\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],

        ["\xE0\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB5"],
        ["\x5E\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB6"],
        ["\x5E\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB7"],
        ["\x5E\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB8"],
        ["\x5E\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xB9"],
        ["\x5E\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xBA"],
        ["\x5E\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\xE0\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x83"],
        ["\x68\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],

        ["\xE0\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\x5E\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\x50\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\x5E\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\x5E\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],

        ["\xE0\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\x5E\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],

        ["\xE0\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\x5E\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],

        ["\xE0\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\x5E\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],

        ["\xE0\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xA4"],
        ["\x5E\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],

        ["\xE1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\x5E\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],

        ["\xE1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\x5E\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],

        ["\xE1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\x5E\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],

        ["\xE1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCA"],
        ["\x5E\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],

        ["\xE1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCB"],
        ["\x5E\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],

        ["\xE1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCD"],
        ["\x5E\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],

        ["\xE1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\x5E\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],

        ["\xE1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCE"],
        ["\x5E\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],

        ["\xE1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\x5E\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],

        ["\xE1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\x5E\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],

        ["\xE1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\x5E\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],

        ["\xE1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\x5E\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],

        ["\xE1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\x5E\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],

        ["\xE1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\x5E\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],

        ["\xE1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\x5E\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],

        ["\xE1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\x5E\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],

        ["\xE1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE6"],
        ["\x53\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],

        ["\xE1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\x5E\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],

        ["\xE1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\x5E\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],

        ["\xE1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\x5E\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],

        ["\xE1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDB"],
        ["\x5E\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],

        ["\xE1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDC"],
        ["\x5E\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],

        ["\xE1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDD"],
        ["\x5E\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],

        ["\xE1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDE"],
        ["\x5E\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],

        ["\xE1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xDF"],
        ["\x5E\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],

        ["\xE1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\x5E\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],

        ["\xE1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\x5E\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],

        ["\xE1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\x5E\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],

        ["\xE1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\x5E\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],

        ["\xE1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xFD"],
        ["\x52\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],

        ["\xE1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\x5E\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],

        ["\xE1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\x5E\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],

        ["\xE1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\x5E\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],

        ["\xE1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\x5E\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],

        ["\xE1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xEA"],
        ["\x5E\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],

        ["\xE1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xEB"],
        ["\x5E\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],

        ["\xE1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\x5E\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],

        ["\xE1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\x5E\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],

        ["\xE1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\x5E\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],

        ["\xE1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xEF"],
        ["\x5E\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],

        ["\xE1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\x5E\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],

        ["\xE1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\x5E\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],

        ["\xE1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\x5E\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],

        ["\xE1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\x5E\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],

        ["\xE1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\x5E\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],

        ["\xE1\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\x5E\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],

        ["\xE1\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\x5E\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],

        ["\xE1\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\x5E\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],

        ["\xE1\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\x5E\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],

        ["\xE1\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\x5E\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],

        ["\xE1\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\x5E\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],

        ["\xE1\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xFA"],
        ["\x5E\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],

        ["\xE1\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xFB"],
        ["\x5E\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],

        ["\xE1\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xFC"],
        ["\x5E\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],

        ["\xE1\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"],
        ["\x5E\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],

        ["\xE1\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\x5E\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],

        ["\xE1\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\x5F\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],

        ["\xE1\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\x5F\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],

        ["\xE1\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\x5F\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],

        ["\xE1\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\x5F\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],

        ["\xE1\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\x5F\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],

        ["\xE1\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\x5F\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],

        ["\xE1\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\x5F\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],

        ["\xE1\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\x5F\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],

        ["\xE1\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\x5F\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],

        ["\xE1\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\x5F\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],

        ["\xE1\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\x5F\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],

        ["\xE1\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\x5F\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],

        ["\xE1\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\x5F\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],

        ["\xE1\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\x5F\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],

        ["\xE1\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\x52\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],

        ["\xE1\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\x5F\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],

        ["\xE1\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\x5F\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],

        ["\xE1\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\x5F\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],

        ["\xE1\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\x5F\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],

        ["\xE1\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\x5F\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],

        ["\xE1\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\x5F\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],

        ["\xE1\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\x5F\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],

        ["\xE1\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\x5F\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],

        ["\xE1\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\x5F\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],

        ["\xE1\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\x5F\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],

        ["\xE1\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\x5F\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],

        ["\xE1\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\x5F\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],

        ["\xE1\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\x5F\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],

        ["\xE1\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\x5F\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],

        ["\xE1\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\x5F\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],

        ["\xE1\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\x5F\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],

        ["\xE1\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\x5F\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],

        ["\xE1\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\x5F\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],

        ["\xE1\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\x5F\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],

        ["\xE1\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\x5F\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],

        ["\xE1\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\x5F\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],

        ["\xE1\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\x5F\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],

        ["\xE1\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\x5F\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],

        ["\xE2\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\x5F\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE2\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\x5F\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],

        ["\xE2\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9A"],
        ["\x53\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],

        ["\xE2\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\x5F\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],

        ["\xE2\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\x5F\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],

        ["\xE2\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\x5F\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],

        ["\xE2\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\x5F\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],

        ["\xE2\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\x5F\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],

        ["\xE2\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x99"],
        ["\x52\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],

        ["\xE2\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x96"],
        ["\x53\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],

        ["\xE2\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x81"],
        ["\x4E\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\x5F\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],

        ["\xE2\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\x5F\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],

        ["\xE2\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\x5F\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],

        ["\xE2\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\x5F\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],

        ["\xE2\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\x5F\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\x5F\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],

        ["\xE2\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\x5F\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],

        ["\xE2\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\x5F\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],

        ["\xE2\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\x5F\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],

        ["\xE2\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\x5F\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],

        ["\xE2\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\x5F\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],

        ["\xE2\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\x5F\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],

        ["\xE2\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\x5F\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],

        ["\xE2\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\x5F\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],

        ["\xE2\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF7"],
        ["\x53\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],

        ["\xE2\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x81"],
        ["\x5F\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],

        ["\xE2\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x82"],
        ["\x5F\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],

        ["\xE2\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x83"],
        ["\x5F\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],

        ["\xE2\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x84"],
        ["\x5F\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],

        ["\xE2\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x85"],
        ["\x5F\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],

        ["\xE2\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x86"],
        ["\x5F\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x88"],
        ["\x5F\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x87"],
        ["\x5F\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\x51\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x89"],
        ["\x5F\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x8A"],
        ["\x5F\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\x5F\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x8C"],
        ["\x5F\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x8D"],
        ["\x5F\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x8F"],
        ["\x5F\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x90"],
        ["\x5F\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],

        ["\xE2\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x91"],
        ["\x5F\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],

        ["\xE2\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x92"],
        ["\x5F\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],

        ["\xE2\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x93"],
        ["\x5F\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],

        ["\xE2\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x94"],
        ["\x5F\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],

        ["\xE2\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x95"],
        ["\x5F\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],

        ["\xE2\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x96"],
        ["\x5F\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x97"],
        ["\x5F\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x98"],
        ["\x5F\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x99"],
        ["\x5F\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9A"],
        ["\x5F\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\x5F\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\x5F\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9D"],
        ["\x5F\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9E"],
        ["\x5F\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\x9F"],
        ["\x5F\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\x5F\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],

        ["\xE2\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\x5F\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],

        ["\xE2\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA2"],
        ["\x5F\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],

        ["\xE2\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\x5F\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],

        ["\xE2\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\x5F\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],

        ["\xE2\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\x5F\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],

        ["\xE2\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\x53\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA6"],
        ["\x5F\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],

        ["\xE2\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA7"],
        ["\x5F\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA8"],
        ["\x5F\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xA9"],
        ["\x5F\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\x5F\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xAC"],
        ["\x5F\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\x5F\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xE2\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xB9"],
        ["\x51\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xE2\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\x5F\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xE2\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\x51\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],

        ["\xE2\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\x5F\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],

        ["\xE2\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB5"],
        ["\x5F\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],

        ["\xE2\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB4"],
        ["\x5F\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],

        ["\xE2\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB7"],
        ["\x5F\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],

        ["\xE2\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB9"],
        ["\x5F\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],

        ["\xE2\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\x5F\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBA"],
        ["\x5F\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBB"],
        ["\x5F\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBC"],
        ["\x5F\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBD"],
        ["\x5F\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\x5F\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xBF"],
        ["\x5F\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\x5F\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\x5F\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\x5F\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\x5F\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],

        ["\xE2\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\x5F\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],

        ["\xE2\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\x5F\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],

        ["\xE2\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\x5F\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],

        ["\xE2\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\x5F\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],

        ["\xE3\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\x5F\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE3\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\x5F\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],

        ["\xE3\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\x5F\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],

        ["\xE3\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCB"],
        ["\x5F\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],

        ["\xE3\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCC"],
        ["\x5F\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],

        ["\xE3\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4D\xF0"],
        ["\x4D\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],

        ["\xE3\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\x5F\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],

        ["\xE3\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\x5F\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],

        ["\xE3\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xCF"],
        ["\x5F\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],

        ["\xE3\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\x5F\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],

        ["\xE3\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\x5F\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\x5F\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],

        ["\xE3\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\x53\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],

        ["\xE3\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\x5F\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],

        ["\xE3\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\x5F\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],

        ["\xE3\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\x5F\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\x55\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],

        ["\xE3\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xD8"],
        ["\x52\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],

        ["\xE3\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xDA"],
        ["\x5F\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],

        ["\xE3\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xDB"],
        ["\x5F\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],

        ["\xE3\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xDE"],
        ["\x5F\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],

        ["\xE3\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\x4F\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],

        ["\xE3\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF5"],
        ["\x51\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],

        ["\xE3\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\x5F\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],

        ["\xE3\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF5"],
        ["\x54\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],

        ["\xE3\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE1"],
        ["\x5F\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],

        ["\xE3\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\x53\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],

        ["\xE3\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\x5F\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],

        ["\xE3\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\x5F\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],

        ["\xE3\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\x5F\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],

        ["\xE3\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\x5F\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],

        ["\xE3\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\x5F\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xB5"],
        ["\x54\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\x5F\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\x5F\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\x5F\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xEA"],
        ["\x5F\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\x5F\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\x53\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xEC"],
        ["\x5F\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\x50\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xED"],
        ["\x5F\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],

        ["\xE3\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\x5F\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],

        ["\xE3\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\x5F\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],

        ["\xE3\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xEF"],
        ["\x5F\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],

        ["\xE3\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\x5F\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],

        ["\xE3\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\x5F\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],

        ["\xE3\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\x5F\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\x5F\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\x5F\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\x5F\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\x5F\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\x5F\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\x5F\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xFA"],
        ["\x5F\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xFB"],
        ["\x5F\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\x60\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xFC"],
        ["\x5F\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],

        ["\xE3\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xFD"],
        ["\x5F\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],

        ["\xE3\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5F\xFE"],
        ["\x5F\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],

        ["\xE3\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\x60\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],

        ["\xE3\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xF0"],
        ["\x52\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],

        ["\xE3\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\x60\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],

        ["\xE3\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\x60\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\x60\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],

        ["\xE3\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\x60\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\x60\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\x60\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\x60\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\x60\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\x60\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\x60\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\x60\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\x60\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],

        ["\xE3\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\x60\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],

        ["\xE3\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\x60\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],

        ["\xE3\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\x60\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],

        ["\xE3\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\x60\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],

        ["\xE3\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\x60\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],

        ["\xE3\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\x60\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\x60\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\x60\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\x60\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\x60\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\x60\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\x60\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\x60\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xE7"],
        ["\x53\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\x60\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\x60\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],

        ["\xE3\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\x60\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],

        ["\xE3\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\x60\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],

        ["\xE3\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\x60\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],

        ["\xE3\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\x60\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],

        ["\xE4\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\x60\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE4\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD5"],
        ["\x54\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],

        ["\xE4\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\x60\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],

        ["\xE4\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\x60\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],

        ["\xE4\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\x60\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],

        ["\xE4\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\x60\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],

        ["\xE4\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\x60\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],

        ["\xE4\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x84"],
        ["\x54\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],

        ["\xE4\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\x60\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],

        ["\xE4\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\x50\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],

        ["\xE4\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\x60\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\x60\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],

        ["\xE4\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\x53\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],

        ["\xE4\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\x60\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],

        ["\xE4\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\x60\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],

        ["\xE4\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\x60\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\x60\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],

        ["\xE4\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\x60\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],

        ["\xE4\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\x60\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],

        ["\xE4\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\x60\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],

        ["\xE4\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA4"],
        ["\x55\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],

        ["\xE4\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\x60\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],

        ["\xE4\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\x60\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],

        ["\xE4\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\x60\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],

        ["\xE4\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\x60\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],

        ["\xE4\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\x60\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],

        ["\xE4\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xE8"],
        ["\x51\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],

        ["\xE4\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\x60\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],

        ["\xE4\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\x60\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],

        ["\xE4\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\x60\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],

        ["\xE4\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x81"],
        ["\x60\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],

        ["\xE4\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x83"],
        ["\x60\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x84"],
        ["\x60\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\x4F\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x88"],
        ["\x60\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x85"],
        ["\x60\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x87"],
        ["\x60\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xE4\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\x4C\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xE4\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x89"],
        ["\x60\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\x60\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8A"],
        ["\x60\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8C"],
        ["\x60\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],

        ["\xE4\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x86"],
        ["\x60\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],

        ["\xE4\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\x51\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],

        ["\xE4\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8D"],
        ["\x60\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],

        ["\xE4\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8E"],
        ["\x60\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],

        ["\xE4\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x8F"],
        ["\x60\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],

        ["\xE4\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x90"],
        ["\x60\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x91"],
        ["\x60\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x92"],
        ["\x60\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x93"],
        ["\x60\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x94"],
        ["\x60\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x95"],
        ["\x60\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x97"],
        ["\x60\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x98"],
        ["\x60\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x99"],
        ["\x4F\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xF2"],
        ["\x51\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x96"],
        ["\x60\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],

        ["\xE4\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9A"],
        ["\x60\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],

        ["\xE4\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\x60\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],

        ["\xE4\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\x60\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],

        ["\xE4\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAA"],
        ["\x52\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],

        ["\xE4\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x99"],
        ["\x60\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],

        ["\xE4\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9D"],
        ["\x60\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9E"],
        ["\x60\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],

        ["\xE4\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\x9F"],
        ["\x60\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\x60\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"],
        ["\x60\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA2"],
        ["\x60\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA6"],
        ["\x60\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA3"],
        ["\x60\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA4"],
        ["\x60\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA5"],
        ["\x60\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA7"],
        ["\x60\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],

        ["\xE4\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\x60\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],

        ["\xE4\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xA9"],
        ["\x60\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],

        ["\xE4\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xAA"],
        ["\x60\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],

        ["\xE4\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\x60\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],

        ["\xE4\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\x60\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],

        ["\xE4\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\x60\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xBC"],
        ["\x51\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\x60\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\x60\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\x60\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\x60\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB4"],
        ["\x60\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB2"],
        ["\x60\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\x88"],
        ["\x67\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\x60\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\x60\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],

        ["\xE4\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB7"],
        ["\x60\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],

        ["\xE4\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\x60\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],

        ["\xE4\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xC2"],
        ["\x52\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],

        ["\xE4\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\x60\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],

        ["\xE5\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBA"],
        ["\x60\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE5\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBB"],
        ["\x60\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],

        ["\xE5\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBC"],
        ["\x60\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],

        ["\xE5\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBD"],
        ["\x60\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],

        ["\xE5\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\x60\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],

        ["\xE5\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\x60\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],

        ["\xE5\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\x60\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],

        ["\xE5\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\x60\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],

        ["\xE5\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\x60\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],

        ["\xE5\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\x60\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],

        ["\xE5\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\x60\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\x60\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],

        ["\xE5\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\x60\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],

        ["\xE5\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\x60\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],

        ["\xE5\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\x52\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],

        ["\xE5\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCA"],
        ["\x60\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\x60\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],

        ["\xE5\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\x60\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],

        ["\xE5\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCD"],
        ["\x60\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],

        ["\xE5\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCE"],
        ["\x60\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],

        ["\xE5\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xCF"],
        ["\x60\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],

        ["\xE5\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\x60\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],

        ["\xE5\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\x53\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],

        ["\xE5\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xED"],
        ["\x54\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],

        ["\xE5\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xEB"],
        ["\x54\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],

        ["\xE5\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD3"],
        ["\x54\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],

        ["\xE5\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\x60\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],

        ["\xE5\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\x60\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],

        ["\xE5\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\x60\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],

        ["\xE5\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\x60\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],

        ["\xE5\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\x60\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],

        ["\xE5\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\x60\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\x60\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\x60\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\x60\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\x60\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xDB"],
        ["\x60\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\x60\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\x60\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xDF"],
        ["\x60\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\x60\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\x60\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],

        ["\xE5\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\x60\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],

        ["\xE5\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\x60\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],

        ["\xE5\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\x60\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],

        ["\xE5\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE7"],
        ["\x60\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],

        ["\xE5\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE9"],
        ["\x60\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],

        ["\xE5\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\x60\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xA8"],
        ["\x55\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xEB"],
        ["\x60\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xEC"],
        ["\x60\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\x60\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xED"],
        ["\x60\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\x60\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\x60\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\x5B\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\x60\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\x60\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],

        ["\xE5\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\x60\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],

        ["\xE5\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\x60\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],

        ["\xE5\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\x60\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],

        ["\xE5\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\x60\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],

        ["\xE5\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\x60\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],

        ["\xE5\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\x60\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\x60\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],

        ["\xE5\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\x61\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xFA"],
        ["\x60\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\x60\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\x60\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xFE"],
        ["\x60\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\x61\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\x61\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\x61\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\x61\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],

        ["\xE5\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\x61\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],

        ["\xE5\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\x61\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],

        ["\xE5\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\x61\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],

        ["\xE5\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x60\xDE"],
        ["\x60\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],

        ["\xE5\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\x61\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],

        ["\xE5\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\x61\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\x61\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\x52\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\x61\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\x61\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\x61\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\x52\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\x61\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\x61\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\x61\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\x61\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],

        ["\xE5\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\x61\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],

        ["\xE5\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x9C"],
        ["\x53\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],

        ["\xE5\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\x61\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],

        ["\xE5\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\x61\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],

        ["\xE6\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\x61\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE6\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\x61\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],

        ["\xE6\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xCB"],
        ["\x54\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],

        ["\xE6\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\x61\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],

        ["\xE6\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\x51\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],

        ["\xE6\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\x61\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],

        ["\xE6\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\x61\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],

        ["\xE6\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\x61\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],

        ["\xE6\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\x61\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],

        ["\xE6\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\x61\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],

        ["\xE6\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\x61\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\x61\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],

        ["\xE6\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\x61\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],

        ["\xE6\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\x61\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],

        ["\xE6\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\x61\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],

        ["\xE6\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\x61\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\x61\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],

        ["\xE6\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\x61\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],

        ["\xE6\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\x61\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],

        ["\xE6\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\x61\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],

        ["\xE6\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\x61\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],

        ["\xE6\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\x61\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],

        ["\xE6\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\x61\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],

        ["\xE6\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\x61\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],

        ["\xE6\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\x61\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],

        ["\xE6\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\x61\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],

        ["\xE6\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\x61\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],

        ["\xE6\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\x61\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],

        ["\xE6\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\x61\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],

        ["\xE6\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\x61\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],

        ["\xE6\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\x61\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],

        ["\xE6\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\x61\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\x61\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\x61\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\x61\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\x61\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\x61\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF9"],
        ["\x54\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\x61\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\x61\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\x61\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x7F"],
        ["\x61\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],

        ["\xE6\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x80"],
        ["\x61\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],

        ["\xE6\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\x66\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],

        ["\xE6\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xDC"],
        ["\x53\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],

        ["\xE6\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x81"],
        ["\x61\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],

        ["\xE6\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x82"],
        ["\x61\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],

        ["\xE6\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x83"],
        ["\x61\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE4"],
        ["\x54\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x84"],
        ["\x61\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x85"],
        ["\x61\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x86"],
        ["\x61\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x87"],
        ["\x61\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x88"],
        ["\x61\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x89"],
        ["\x61\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8A"],
        ["\x61\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8B"],
        ["\x61\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8C"],
        ["\x61\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],

        ["\xE6\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8D"],
        ["\x61\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],

        ["\xE6\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\x54\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],

        ["\xE6\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8E"],
        ["\x61\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],

        ["\xE6\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x8F"],
        ["\x61\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],

        ["\xE6\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x90"],
        ["\x61\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],

        ["\xE6\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x91"],
        ["\x61\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x92"],
        ["\x61\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],

        ["\xE6\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x93"],
        ["\x61\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x94"],
        ["\x61\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x95"],
        ["\x61\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x96"],
        ["\x61\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x97"],
        ["\x61\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x98"],
        ["\x61\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB6"],
        ["\x53\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x99"],
        ["\x61\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x92"],
        ["\x52\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],

        ["\xE6\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9A"],
        ["\x61\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],

        ["\xE6\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9B"],
        ["\x61\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],

        ["\xE6\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9C"],
        ["\x61\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],

        ["\xE6\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9D"],
        ["\x61\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],

        ["\xE6\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9E"],
        ["\x61\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],

        ["\xE6\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\x9F"],
        ["\x61\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA0"],
        ["\x61\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\x61\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA2"],
        ["\x61\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\x61\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\x61\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x88"],
        ["\x52\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA5"],
        ["\x61\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA6"],
        ["\x61\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\x61\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\x61\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],

        ["\xE6\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x96"],
        ["\x4C\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],

        ["\xE6\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xA9"],
        ["\x61\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],

        ["\xE6\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAA"],
        ["\x61\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],

        ["\xE6\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAB"],
        ["\x61\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],

        ["\xE7\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\x66\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE7\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAC"],
        ["\x61\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],

        ["\xE7\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\x61\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],

        ["\xE7\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAE"],
        ["\x61\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],

        ["\xE7\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xAF"],
        ["\x61\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],

        ["\xE7\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\x61\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],

        ["\xE7\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB1"],
        ["\x61\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],

        ["\xE7\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\x61\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],

        ["\xE7\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB3"],
        ["\x61\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],

        ["\xE7\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB5"],
        ["\x61\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],

        ["\xE7\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB6"],
        ["\x61\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\x61\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],

        ["\xE7\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB8"],
        ["\x61\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],

        ["\xE7\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB9"],
        ["\x61\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],

        ["\xE7\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\x61\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],

        ["\xE7\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\x61\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\x61\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],

        ["\xE7\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBD"],
        ["\x61\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],

        ["\xE7\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC1"],
        ["\x61\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],

        ["\xE7\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\x61\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],

        ["\xE7\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xB4"],
        ["\x61\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],

        ["\xE7\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xBF"],
        ["\x61\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],

        ["\xE7\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC2"],
        ["\x61\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],

        ["\xE7\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC4"],
        ["\x61\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],

        ["\xE7\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC0"],
        ["\x61\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],

        ["\xE7\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\x61\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],

        ["\xE7\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC3"],
        ["\x61\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],

        ["\xE7\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC7"],
        ["\x61\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],

        ["\xE7\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC8"],
        ["\x61\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],

        ["\xE7\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\x61\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],

        ["\xE7\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\x61\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],

        ["\xE7\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCB"],
        ["\x61\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\x61\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\x61\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCF"],
        ["\x61\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xCE"],
        ["\x61\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xC5"],
        ["\x61\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD0"],
        ["\x61\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD1"],
        ["\x61\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD2"],
        ["\x61\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\x51\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD3"],
        ["\x61\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],

        ["\xE7\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD4"],
        ["\x61\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],

        ["\xE7\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD5"],
        ["\x61\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],

        ["\xE7\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\x61\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],

        ["\xE7\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD7"],
        ["\x61\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],

        ["\xE7\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\x61\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],

        ["\xE7\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\x53\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xBA"],
        ["\x62\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"],
        ["\x61\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDA"],
        ["\x61\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\x61\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDD"],
        ["\x61\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDE"],
        ["\x61\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\x61\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE1"],
        ["\x61\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE2"],
        ["\x61\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE3"],
        ["\x61\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],

        ["\xE7\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xAE"],
        ["\x54\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],

        ["\xE7\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\x61\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],

        ["\xE7\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE4"],
        ["\x61\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],

        ["\xE7\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\x61\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],

        ["\xE7\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\x61\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],

        ["\xE7\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\x61\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\x61\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],

        ["\xE7\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xEA"],
        ["\x61\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xEB"],
        ["\x61\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\x61\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xEC"],
        ["\x61\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xED"],
        ["\x61\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xC5"],
        ["\x53\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xEE"],
        ["\x61\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\x61\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"],
        ["\x61\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],

        ["\xE7\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF1"],
        ["\x61\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],

        ["\xE7\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF2"],
        ["\x61\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],

        ["\xE7\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\x61\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],

        ["\xE7\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\x61\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],

        ["\xE7\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\x61\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],

        ["\xE7\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF6"],
        ["\x61\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF7"],
        ["\x61\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xF9"],
        ["\x61\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xFA"],
        ["\x61\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xFB"],
        ["\x61\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\x62\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\x62\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\x61\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\x61\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"],
        ["\x61\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\x62\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],

        ["\xE7\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\x62\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],

        ["\xE7\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\x62\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],

        ["\xE7\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\x62\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],

        ["\xE7\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\x62\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],

        ["\xE8\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\x62\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE8\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\x62\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],

        ["\xE8\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\x62\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],

        ["\xE8\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\x54\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],

        ["\xE8\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\x62\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],

        ["\xE8\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\x62\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],

        ["\xE8\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\x62\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],

        ["\xE8\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\x62\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],

        ["\xE8\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\x62\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],

        ["\xE8\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\x62\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],

        ["\xE8\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\x62\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xF6"],
        ["\x53\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],

        ["\xE8\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\x62\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],

        ["\xE8\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\x62\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],

        ["\xE8\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\x62\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],

        ["\xE8\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\x62\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\x62\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],

        ["\xE8\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\x62\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],

        ["\xE8\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\x62\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],

        ["\xE8\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\x62\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],

        ["\xE8\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\x62\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],

        ["\xE8\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x86"],
        ["\x54\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],

        ["\xE8\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\x62\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],

        ["\xE8\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\x62\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],

        ["\xE8\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\x62\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],

        ["\xE8\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\x62\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],

        ["\xE8\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\x62\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],

        ["\xE8\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\x62\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],

        ["\xE8\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\x62\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],

        ["\xE8\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\x62\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],

        ["\xE8\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\x62\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],

        ["\xE8\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\x62\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xE9"],
        ["\x54\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\x62\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\x62\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\x62\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\x62\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\x62\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\x62\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\x62\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\x62\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\x62\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],

        ["\xE8\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\x62\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],

        ["\xE8\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\x62\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],

        ["\xE8\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xD8"],
        ["\x54\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],

        ["\xE8\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\x62\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],

        ["\xE8\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\x62\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],

        ["\xE8\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x84"],
        ["\x62\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x9D"],
        ["\x62\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\x62\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\x51\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\x62\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\x62\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x9F"],
        ["\x62\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\x62\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\x62\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\x62\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x90"],
        ["\x62\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],

        ["\xE8\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\x62\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],

        ["\xE8\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\x62\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],

        ["\xE8\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x81"],
        ["\x62\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],

        ["\xE8\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x82"],
        ["\x62\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],

        ["\xE8\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\x4B\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],

        ["\xE8\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x83"],
        ["\x62\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\x62\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],

        ["\xE8\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x85"],
        ["\x62\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x86"],
        ["\x62\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\x62\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x87"],
        ["\x62\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x88"],
        ["\x62\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x89"],
        ["\x62\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x94"],
        ["\x62\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\x62\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x8C"],
        ["\x62\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],

        ["\xE8\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x8D"],
        ["\x62\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],

        ["\xE8\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x8E"],
        ["\x62\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],

        ["\xE8\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x8F"],
        ["\x62\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],

        ["\xE8\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x91"],
        ["\x62\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],

        ["\xE8\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x92"],
        ["\x62\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],

        ["\xE8\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x93"],
        ["\x62\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA8"],
        ["\x54\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x95"],
        ["\x62\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x96"],
        ["\x62\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x97"],
        ["\x62\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x98"],
        ["\x62\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x99"],
        ["\x62\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x9A"],
        ["\x62\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\x62\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\x62\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x8B"],
        ["\x51\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],

        ["\xE8\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\x62\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],

        ["\xE8\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA2"],
        ["\x62\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],

        ["\xE8\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\x62\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],

        ["\xE8\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA4"],
        ["\x62\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],

        ["\xE9\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\x62\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\xE9\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x96"],
        ["\x54\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],

        ["\xE9\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA7"],
        ["\x62\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],

        ["\xE9\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\x62\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],

        ["\xE9\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\x62\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],

        ["\xE9\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\x62\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],

        ["\xE9\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAC"],
        ["\x62\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],

        ["\xE9\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAD"],
        ["\x62\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],

        ["\xE9\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\x62\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],

        ["\xE9\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xAF"],
        ["\x62\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],

        ["\xE9\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\x62\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB1"],
        ["\x62\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],

        ["\xE9\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\x62\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],

        ["\xE9\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4C\x95"],
        ["\x4C\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],

        ["\xE9\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB4"],
        ["\x62\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],

        ["\xE9\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB5"],
        ["\x62\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB6"],
        ["\x62\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],

        ["\xE9\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB7"],
        ["\x62\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],

        ["\xE9\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\x62\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],

        ["\xE9\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xBC"],
        ["\x62\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],

        ["\xE9\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xBD"],
        ["\x62\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],

        ["\xE9\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xBE"],
        ["\x62\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],

        ["\xE9\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xBF"],
        ["\x62\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],

        ["\xE9\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\x62\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],

        ["\xE9\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\x62\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],

        ["\xE9\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\x62\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],

        ["\xE9\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\x62\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],

        ["\xE9\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\x62\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],

        ["\xE9\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\x62\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],

        ["\xE9\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\x62\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],

        ["\xE9\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\x62\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],

        ["\xE9\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\x62\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\x62\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\x53\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\xDA"],
        ["\x4E\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xCA"],
        ["\x62\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xCB"],
        ["\x62\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xCC"],
        ["\x62\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xCD"],
        ["\x62\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\x62\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\x62\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xFB"],
        ["\x52\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],

        ["\xE9\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\x62\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],

        ["\xE9\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\x62\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],

        ["\xE9\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\x62\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],

        ["\xE9\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\x62\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],

        ["\xE9\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\x62\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],

        ["\xE9\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\x62\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\x62\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\x62\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDA"],
        ["\x62\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDB"],
        ["\x62\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDC"],
        ["\x62\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\x62\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\x62\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\x62\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\x62\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xE9\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\x53\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],

        ["\xE9\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\x62\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],

        ["\xE9\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\x62\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],

        ["\xE9\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\x62\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],

        ["\xE9\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\x62\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],

        ["\xE9\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\x62\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],

        ["\xE9\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\x62\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\x62\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],

        ["\xE9\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\x4F\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\x62\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\x62\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\x62\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\x62\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\x62\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\x62\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\x62\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\x62\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],

        ["\xE9\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\x62\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],

        ["\xE9\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\x62\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],

        ["\xE9\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\x62\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],

        ["\xE9\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\x62\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],

        ["\xE9\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\x62\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],

        ["\xE9\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\x52\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\x62\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\x62\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\x62\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\x62\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\x63\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xFB"],
        ["\x62\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\x62\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\x62\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x62\xFE"],
        ["\x62\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\x63\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],

        ["\xE9\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\x63\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],

        ["\xE9\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\x63\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],

        ["\xE9\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\x63\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],

        ["\xE9\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\x63\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],

        ["\xEA\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\x63\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],

        ["\xEA\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\x63\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],

        ["\xEA\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\x63\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],

        ["\xEA\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\x55\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],

        ["\xEA\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\x63\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],

        ["\xEA\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\x63\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],

        ["\xEA\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\x63\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],

        ["\xEA\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\x63\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],

        ["\xEA\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\x63\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],

        ["\xEA\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\x63\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],

        ["\xEA\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\x63\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],

        ["\xEA\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\x63\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],

        ["\xEA\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\x63\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],

        ["\xEA\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\x63\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],

        ["\xEA\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\x63\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],

        ["\xEA\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\x63\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],

        ["\xEA\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xF4"],
        ["\x54\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],

        ["\xEA\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\x63\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],

        ["\xEA\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\x63\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],

        ["\xEA\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\x63\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],

        ["\xEA\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\x63\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],

        ["\xEA\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\x63\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],

        ["\xEA\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\x63\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],

        ["\xEA\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\x63\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],

        ["\xEA\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\x63\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],

        ["\xEA\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\x63\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],

        ["\xEA\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\x63\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],

        ["\xEA\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\x63\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],

        ["\xEA\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\x63\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],

        ["\xEA\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\x63\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],

        ["\xEA\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\x63\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],

        ["\xEA\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\x63\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],

        ["\xEA\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\x63\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],

        ["\xEA\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\x63\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],

        ["\xEA\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\x63\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],

        ["\xEA\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\x63\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],

        ["\xEA\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\x63\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],

        ["\xEA\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\x63\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],

        ["\xEA\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\x63\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],

        ["\xEA\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\x63\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],

        ["\xEA\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\x63\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],

        ["\xEA\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\x63\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],

        ["\xEA\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\x63\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],

        ["\xEA\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\x63\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],

        ["\xEA\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\x63\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],

        ["\xEA\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\x63\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],

        ["\xEA\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\x63\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],

        ["\xEA\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\x63\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],

        ["\xEA\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\x63\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],

        ["\xEA\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\x63\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],

        ["\xEA\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\x63\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],

        ["\xEA\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x85"],
        ["\x63\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],

        ["\xEA\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\x63\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],

        ["\xEA\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\x63\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],

        ["\xEA\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\x63\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],

        ["\xEA\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\x63\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],

        ["\xEA\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\x63\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],

        ["\xEA\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\x63\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],

        ["\xEA\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x81"],
        ["\x63\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],

        ["\xEA\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x82"],
        ["\x63\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],

        ["\xEA\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x83"],
        ["\x63\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],

        ["\xEA\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xC5"],
        ["\x54\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],

        ["\xEA\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x84"],
        ["\x63\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],

        ["\xEA\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x86"],
        ["\x63\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],

        ["\xEA\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x87"],
        ["\x63\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],

        ["\xEA\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x88"],
        ["\x63\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],

        ["\xEA\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x89"],
        ["\x63\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],

        ["\xEA\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8A"],
        ["\x63\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],

        ["\xEA\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\x63\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],

        ["\xEA\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8C"],
        ["\x63\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],

        ["\xEA\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8D"],
        ["\x63\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],

        ["\xEA\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8E"],
        ["\x63\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],

        ["\xEA\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x8F"],
        ["\x63\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],

        ["\xEA\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\x53\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],

        ["\xEA\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x91"],
        ["\x63\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],

        ["\xEA\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x92"],
        ["\x63\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],

        ["\xEA\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x93"],
        ["\x63\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],

        ["\xEA\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x94"],
        ["\x63\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],

        ["\xEA\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x97"],
        ["\x63\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],

        ["\xEA\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x98"],
        ["\x63\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],

        ["\xEA\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9F"],
        ["\x63\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],

        ["\xEA\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x99"],
        ["\x63\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],

        ["\xEA\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9A"],
        ["\x63\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],

        ["\xEA\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x95"],
        ["\x63\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],

        ["\xEA\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\x63\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],

        ["\xEA\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\x63\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],

        ["\xEA\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\x50\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],

        ["\xEA\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9D"],
        ["\x63\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],

        ["\xEA\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x9E"],
        ["\x63\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],

        ["\xEA\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\x63\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],

        ["\xEA\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA2"],
        ["\x63\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],

        ["\xEA\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\x96"],
        ["\x63\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],

        ["\xEA\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA3"],
        ["\x63\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],

        ["\xEA\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\x63\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],

        ["\xEB\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA5"],
        ["\x63\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],

        ["\xEB\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\x63\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],

        ["\xEB\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA8"],
        ["\x63\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],

        ["\xEB\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\x63\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],

        ["\xEB\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\x63\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],

        ["\xEB\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\x63\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],

        ["\xEB\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\x63\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],

        ["\xEB\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAC"],
        ["\x63\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],

        ["\xEB\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAD"],
        ["\x63\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],

        ["\xEB\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\x63\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],

        ["\xEB\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xAF"],
        ["\x63\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],

        ["\xEB\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\x63\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],

        ["\xEB\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\x63\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],

        ["\xEB\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\x63\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],

        ["\xEB\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB3"],
        ["\x63\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],

        ["\xEB\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\x63\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],

        ["\xEB\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB5"],
        ["\x63\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],

        ["\xEB\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB6"],
        ["\x63\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],

        ["\xEB\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\x63\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],

        ["\xEB\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\x63\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],

        ["\xEB\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\x63\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],

        ["\xEB\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xB9"],
        ["\x63\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],

        ["\xEB\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBB"],
        ["\x63\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],

        ["\xEB\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBC"],
        ["\x63\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],

        ["\xEB\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\x53\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],

        ["\xEB\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\x63\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],

        ["\xEB\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBE"],
        ["\x63\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],

        ["\xEB\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xBF"],
        ["\x63\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],

        ["\xEB\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\x63\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],

        ["\xEB\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\x63\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],

        ["\xEB\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\x63\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],

        ["\xEB\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\x63\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],

        ["\xEB\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\x63\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],

        ["\xEB\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\x63\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],

        ["\xEB\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\x63\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],

        ["\xEB\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\x63\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],

        ["\xEB\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\x63\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],

        ["\xEB\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xCA"],
        ["\x63\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],

        ["\xEB\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\x63\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],

        ["\xEB\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xCD"],
        ["\x63\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],

        ["\xEB\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xCE"],
        ["\x63\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],

        ["\xEB\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xCF"],
        ["\x63\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],

        ["\xEB\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\x63\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],

        ["\xEB\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\x63\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],

        ["\xEB\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\x63\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],

        ["\xEB\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\x63\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],

        ["\xEB\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\x63\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],

        ["\xEB\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\x63\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],

        ["\xEB\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\x63\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],

        ["\xEB\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\x63\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],

        ["\xEB\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\x63\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],

        ["\xEB\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\x63\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],

        ["\xEB\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xDB"],
        ["\x63\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],

        ["\xEB\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xDC"],
        ["\x63\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],

        ["\xEB\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xDD"],
        ["\x63\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],

        ["\xEB\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\x63\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],

        ["\xEB\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xB2"],
        ["\x50\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],

        ["\xEB\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\x63\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],

        ["\xEB\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\x63\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],

        ["\xEB\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\x63\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],

        ["\xEB\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x96"],
        ["\x4E\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],

        ["\xEB\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\x63\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],

        ["\xEB\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\x63\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],

        ["\xEB\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\x63\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],

        ["\xEB\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\x63\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],

        ["\xEB\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\x63\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],

        ["\xEB\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xEA"],
        ["\x63\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],

        ["\xEB\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\x63\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],

        ["\xEB\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\x63\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],

        ["\xEB\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\x63\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],

        ["\xEB\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\x63\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],

        ["\xEB\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\x63\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],

        ["\xEB\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\x63\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],

        ["\xEB\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\x63\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],

        ["\xEB\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xEC"],
        ["\x63\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],

        ["\xEB\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\x63\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],

        ["\xEB\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\x63\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],

        ["\xEB\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\x63\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],

        ["\xEB\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\x63\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],

        ["\xEB\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xFA"],
        ["\x63\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],

        ["\xEB\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\x63\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],

        ["\xEB\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\x63\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],

        ["\xEB\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\x63\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],

        ["\xEB\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\x64\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],

        ["\xEB\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x81"],
        ["\x53\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],

        ["\xEB\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xFB"],
        ["\x63\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],

        ["\xEB\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\x64\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],

        ["\xEB\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\x64\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],

        ["\xEB\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\x64\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],

        ["\xEB\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\x64\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],

        ["\xEB\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\x64\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],

        ["\xEB\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\x64\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],

        ["\xEB\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\x64\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],

        ["\xEB\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\x64\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],

        ["\xEC\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\x64\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],

        ["\xEC\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\x64\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],

        ["\xEC\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\x64\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],

        ["\xEC\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\x64\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],

        ["\xEC\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\x64\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],

        ["\xEC\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\x64\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],

        ["\xEC\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\x64\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],

        ["\xEC\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\x64\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],

        ["\xEC\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\x64\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],

        ["\xEC\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\x64\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],

        ["\xEC\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\x64\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],

        ["\xEC\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\x64\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],

        ["\xEC\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\x64\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],

        ["\xEC\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\x64\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],

        ["\xEC\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\x64\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],

        ["\xEC\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\x64\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],

        ["\xEC\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\x64\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],

        ["\xEC\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\x64\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],

        ["\xEC\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\x64\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],

        ["\xEC\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\x64\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],

        ["\xEC\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\x64\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],

        ["\xEC\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\x64\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],

        ["\xEC\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\x64\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],

        ["\xEC\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\x64\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],

        ["\xEC\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\x64\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],

        ["\xEC\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\x64\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],

        ["\xEC\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\x64\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],

        ["\xEC\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\x64\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],

        ["\xEC\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\x64\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],

        ["\xEC\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\x64\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],

        ["\xEC\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\x64\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],

        ["\xEC\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\x64\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],

        ["\xEC\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\x64\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],

        ["\xEC\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\x64\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],

        ["\xEC\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\x64\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],

        ["\xEC\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\x64\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],

        ["\xEC\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\x64\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],

        ["\xEC\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\x64\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],

        ["\xEC\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\x64\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],

        ["\xEC\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\x64\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],

        ["\xEC\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\x64\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],

        ["\xEC\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\x64\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],

        ["\xEC\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\x64\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],

        ["\xEC\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\x64\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],

        ["\xEC\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\x55\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],

        ["\xEC\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\x64\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],

        ["\xEC\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\x64\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],

        ["\xEC\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\x64\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],

        ["\xEC\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\x64\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],

        ["\xEC\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\x64\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],

        ["\xEC\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\x53\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],

        ["\xEC\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\x55\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],

        ["\xEC\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x82"],
        ["\x64\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],

        ["\xEC\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x81"],
        ["\x64\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],

        ["\xEC\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x83"],
        ["\x64\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],

        ["\xEC\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x84"],
        ["\x64\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],

        ["\xEC\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x86"],
        ["\x64\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],

        ["\xEC\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\x68\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],

        ["\xEC\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x87"],
        ["\x64\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],

        ["\xEC\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\x64\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],

        ["\xEC\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x88"],
        ["\x64\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],

        ["\xEC\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x89"],
        ["\x64\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],

        ["\xEC\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x8A"],
        ["\x64\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],

        ["\xEC\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\x64\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],

        ["\xEC\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x8C"],
        ["\x64\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],

        ["\xEC\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xC9"],
        ["\x51\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],

        ["\xEC\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x8F"],
        ["\x64\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],

        ["\xEC\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\x51\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],

        ["\xEC\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x90"],
        ["\x64\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],

        ["\xEC\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x91"],
        ["\x64\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],

        ["\xEC\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x92"],
        ["\x64\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],

        ["\xEC\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x93"],
        ["\x64\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],

        ["\xEC\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x94"],
        ["\x64\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],

        ["\xEC\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x95"],
        ["\x64\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],

        ["\xEC\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x96"],
        ["\x64\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],

        ["\xEC\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x97"],
        ["\x64\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],

        ["\xEC\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x98"],
        ["\x64\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],

        ["\xEC\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x99"],
        ["\x64\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],

        ["\xEC\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9A"],
        ["\x64\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],

        ["\xEC\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\x64\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],

        ["\xEC\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\x64\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],

        ["\xEC\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9D"],
        ["\x64\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],

        ["\xEC\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9E"],
        ["\x64\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],

        ["\xEC\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\x64\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],

        ["\xEC\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\x9F"],
        ["\x64\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],

        ["\xEC\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\x64\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],

        ["\xEC\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\x64\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],

        ["\xEC\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\x64\xA3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],

        ["\xEC\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA4"],
        ["\x64\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],

        ["\xEC\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\x64\xA5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],

        ["\xEC\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA6"],
        ["\x64\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],

        ["\xEC\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA7"],
        ["\x64\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],

        ["\xEC\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\x64\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],

        ["\xEC\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xA9"],
        ["\x64\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],

        ["\xED\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\x64\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],

        ["\xED\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\x64\xAB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],

        ["\xED\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAC"],
        ["\x64\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],

        ["\xED\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\x64\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],

        ["\xED\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\x64\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],

        ["\xED\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\x64\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],

        ["\xED\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\x64\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],

        ["\xED\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB1"],
        ["\x64\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],

        ["\xED\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\x50\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],

        ["\xED\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\x64\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],

        ["\xED\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\x64\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],

        ["\xED\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\x64\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],

        ["\xED\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\x64\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],

        ["\xED\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB7"],
        ["\x64\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],

        ["\xED\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\x64\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],

        ["\xED\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB6"],
        ["\x64\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],

        ["\xED\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\x64\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],

        ["\xED\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBA"],
        ["\x64\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],

        ["\xED\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBB"],
        ["\x64\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],

        ["\xED\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBC"],
        ["\x64\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],

        ["\xED\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBD"],
        ["\x64\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],

        ["\xED\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBE"],
        ["\x64\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],

        ["\xED\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xBF"],
        ["\x64\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],

        ["\xED\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\x64\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],

        ["\xED\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\x64\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],

        ["\xED\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\x64\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],

        ["\xED\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\x50\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],

        ["\xED\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\x53\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],

        ["\xED\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\x64\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],

        ["\xED\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\x64\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],

        ["\xED\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\x64\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],

        ["\xED\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\x64\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],

        ["\xED\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\x64\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],

        ["\xED\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\x64\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],

        ["\xED\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCA"],
        ["\x64\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],

        ["\xED\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCB"],
        ["\x64\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],

        ["\xED\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\x64\xCC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],

        ["\xED\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCD"],
        ["\x64\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],

        ["\xED\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\x64\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],

        ["\xED\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xCF"],
        ["\x64\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],

        ["\xED\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\x64\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],

        ["\xED\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\x64\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],

        ["\xED\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\x64\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],

        ["\xED\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\x64\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],

        ["\xED\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\x64\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],

        ["\xED\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\x64\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],

        ["\xED\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\x64\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],

        ["\xED\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\x64\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],

        ["\xED\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\x51\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],

        ["\xED\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\x64\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],

        ["\xED\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\x64\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],

        ["\xED\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\x64\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],

        ["\xED\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\x64\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],

        ["\xED\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\x64\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],

        ["\xED\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\x64\xDD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],

        ["\xED\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDE"],
        ["\x64\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],

        ["\xED\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\x64\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],

        ["\xED\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\x64\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],

        ["\xED\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\x64\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],

        ["\xED\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE1"],
        ["\x64\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],

        ["\xED\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\x64\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],

        ["\xED\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\x64\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],

        ["\xED\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\x64\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],

        ["\xED\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\x64\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],

        ["\xED\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\x64\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],

        ["\xED\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\x64\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],

        ["\xED\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\x64\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],

        ["\xED\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xEA"],
        ["\x64\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],

        ["\xED\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\x64\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],

        ["\xED\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\x64\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],

        ["\xED\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xEF"],
        ["\x64\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],

        ["\xED\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\x64\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],

        ["\xED\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\x64\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],

        ["\xED\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\x64\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],

        ["\xED\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\x64\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],

        ["\xED\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x4E\x9E"],
        ["\x4E\x9E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],

        ["\xED\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\x64\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],

        ["\xED\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x86"],
        ["\x51\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],

        ["\xED\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\x64\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],

        ["\xED\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\x64\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],

        ["\xED\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\x64\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],

        ["\xED\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xA9"],
        ["\x54\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],

        ["\xED\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\x64\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],

        ["\xED\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\x64\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],

        ["\xED\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xFE"],
        ["\x64\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],

        ["\xED\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\x65\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],

        ["\xED\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\x65\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],

        ["\xED\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\x65\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],

        ["\xED\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\x65\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],

        ["\xED\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\x65\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],

        ["\xED\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\x65\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],

        ["\xED\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x85"],
        ["\x54\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],

        ["\xED\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\x65\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],

        ["\xED\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\x64\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],

        ["\xEE\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\x65\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],

        ["\xEE\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\x65\x4A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],

        ["\xEE\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\x65\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],

        ["\xEE\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\x65\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],

        ["\xEE\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x64\xFD"],
        ["\x64\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],

        ["\xEE\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\x65\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],

        ["\xEE\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\x65\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],

        ["\xEE\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\x65\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],

        ["\xEE\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\x65\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],

        ["\xEE\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\x65\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],

        ["\xEE\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\x65\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],

        ["\xEE\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\x65\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],

        ["\xEE\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\x65\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],

        ["\xEE\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\x65\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],

        ["\xEE\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\x65\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],

        ["\xEE\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\x65\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],

        ["\xEE\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\x65\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],

        ["\xEE\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\x53\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],

        ["\xEE\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\x65\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],

        ["\xEE\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xEA"],
        ["\x50\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],

        ["\xEE\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\x65\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],

        ["\xEE\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\x65\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],

        ["\xEE\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xA8"],
        ["\x51\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],

        ["\xEE\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\x65\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],

        ["\xEE\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\x65\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],

        ["\xEE\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\x65\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],

        ["\xEE\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\x65\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],

        ["\xEE\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\x65\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],

        ["\xEE\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\x65\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],

        ["\xEE\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\x65\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],

        ["\xEE\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\x65\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],

        ["\xEE\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\x65\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],

        ["\xEE\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\x65\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],

        ["\xEE\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\x65\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],

        ["\xEE\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\x65\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],

        ["\xEE\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\x65\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],

        ["\xEE\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\x65\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],

        ["\xEE\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\x65\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],

        ["\xEE\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\x65\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],

        ["\xEE\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\x65\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],

        ["\xEE\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\x65\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],

        ["\xEE\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\x65\x73",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],

        ["\xEE\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\x65\x74",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],

        ["\xEE\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\x65\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],

        ["\xEE\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\x65\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],

        ["\xEE\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\x65\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],

        ["\xEE\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\x65\x78",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],

        ["\xEE\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\x65\x79",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],

        ["\xEE\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\x65\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],

        ["\xEE\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\x65\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],

        ["\xEE\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\x65\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],

        ["\xEE\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\x65\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],

        ["\xEE\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\x65\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],

        ["\xEE\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\x65\x7F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],

        ["\xEE\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\x65\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],

        ["\xEE\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\x52\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],

        ["\xEE\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x81"],
        ["\x65\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],

        ["\xEE\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x82"],
        ["\x65\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],

        ["\xEE\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x87"],
        ["\x65\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],

        ["\xEE\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x88"],
        ["\x65\x88",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],

        ["\xEE\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x89"],
        ["\x65\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],

        ["\xEE\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x84"],
        ["\x65\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],

        ["\xEE\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xD0"],
        ["\x51\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],

        ["\xEE\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\x65\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],

        ["\xEE\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x8E"],
        ["\x65\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],

        ["\xEE\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x91"],
        ["\x65\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],

        ["\xEE\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x92"],
        ["\x65\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],

        ["\xEE\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x94"],
        ["\x65\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],

        ["\xEE\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x96"],
        ["\x65\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],

        ["\xEE\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x97"],
        ["\x65\x97",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],

        ["\xEE\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\x52\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],

        ["\xEE\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x93"],
        ["\x53\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],

        ["\xEE\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x99"],
        ["\x65\x99",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],

        ["\xEE\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x9A"],
        ["\x65\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],

        ["\xEE\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\x65\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],

        ["\xEE\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x9D"],
        ["\x65\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],

        ["\xEE\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\x65\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],

        ["\xEE\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\x65\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],

        ["\xEE\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\x65\xA4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],

        ["\xEE\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\x65\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],

        ["\xEE\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xA2"],
        ["\x65\xA2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],

        ["\xEE\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xAA"],
        ["\x65\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],

        ["\xEE\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\x65\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],

        ["\xEE\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xAF"],
        ["\x65\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],

        ["\xEE\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\x65\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],

        ["\xEE\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xA9"],
        ["\x65\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],

        ["\xEE\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\x65\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],

        ["\xEE\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xBA"],
        ["\x65\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],

        ["\xEE\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xBB"],
        ["\x65\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],

        ["\xEE\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\x65\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],

        ["\xEE\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\x65\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],

        ["\xEE\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\x65\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],

        ["\xEE\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\x65\xC4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],

        ["\xEE\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x83"],
        ["\x52\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],

        ["\xEF\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\x65\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],

        ["\xEF\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\x65\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],

        ["\xEF\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\x65\xCB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],

        ["\xEF\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xCD"],
        ["\x65\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],

        ["\xEF\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xBE"],
        ["\x65\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],

        ["\xEF\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\x65\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],

        ["\xEF\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\x65\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],

        ["\xEF\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\x52\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],

        ["\xEF\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\x65\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],

        ["\xEF\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\x65\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],

        ["\xEF\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\x65\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],

        ["\xEF\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\x65\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],

        ["\xEF\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\x65\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],

        ["\xEF\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\x53\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],

        ["\xEF\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\x65\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],

        ["\xEF\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xDA"],
        ["\x65\xDA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],

        ["\xEF\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\x65\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],

        ["\xEF\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xDC"],
        ["\x65\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],

        ["\xEF\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xDE"],
        ["\x65\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],

        ["\xEF\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xDF"],
        ["\x65\xDF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],

        ["\xEF\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\x65\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],

        ["\xEF\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE1"],
        ["\x65\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],

        ["\xEF\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\x65\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],

        ["\xEF\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\x65\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],

        ["\xEF\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\x65\xE5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],

        ["\xEF\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xDB"],
        ["\x65\xDB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],

        ["\xEF\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\x65\xE6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],

        ["\xEF\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\x65\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],

        ["\xEF\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\x65\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],

        ["\xEF\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xEA"],
        ["\x65\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],

        ["\xEF\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xEC"],
        ["\x65\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],

        ["\xEF\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\x65\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],

        ["\xEF\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xCD"],
        ["\x51\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],

        ["\xEF\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xEE"],
        ["\x65\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],

        ["\xEF\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xEF"],
        ["\x65\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],

        ["\xEF\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\x51\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],

        ["\xEF\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xEB"],
        ["\x65\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],

        ["\xEF\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\x65\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],

        ["\xEF\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\x65\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],

        ["\xEF\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\x65\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],

        ["\xEF\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\x65\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],

        ["\xEF\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\x65\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],

        ["\xEF\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\x65\xF9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],

        ["\xEF\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\x65\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],

        ["\xEF\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\x65\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],

        ["\xEF\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\x65\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],

        ["\xEF\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\x98"],
        ["\x65\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],

        ["\xEF\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xFE"],
        ["\x65\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],

        ["\xEF\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xFD"],
        ["\x65\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],

        ["\xEF\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\x66\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],

        ["\xEF\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\x66\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],

        ["\xEF\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\x65\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],

        ["\xEF\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\x66\x44",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],

        ["\xEF\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\x66\x45",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],

        ["\xEF\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\x66\x46",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],

        ["\xEF\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\x66\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],

        ["\xEF\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\x66\x47",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],

        ["\xEF\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\x66\x48",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],

        ["\xEF\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\x66\x49",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],

        ["\xEF\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\x66\x4B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],

        ["\xEF\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\x66\x4C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],

        ["\xEF\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\x66\x4D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],

        ["\xEF\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\x66\x4E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],

        ["\xEF\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\x66\x4F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],

        ["\xEF\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\x66\x50",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],

        ["\xEF\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\x66\x51",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],

        ["\xEF\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\x66\x52",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],

        ["\xEF\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\x66\x53",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],

        ["\xEF\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\x66\x54",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],

        ["\xEF\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\x66\x55",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],

        ["\xEF\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\x66\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],

        ["\xEF\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\x66\x57",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],

        ["\xEF\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\x66\x58",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],

        ["\xEF\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\x66\x59",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],

        ["\xEF\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\x66\x5A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],

        ["\xEF\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\x66\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],

        ["\xEF\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\x66\x5C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],

        ["\xEF\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\x66\x5D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],

        ["\xEF\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\x66\x5E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],

        ["\xEF\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\x66\x5F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],

        ["\xEF\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\x66\x60",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],

        ["\xEF\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\x66\x61",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],

        ["\xEF\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\x66\x62",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],

        ["\xEF\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\x66\x63",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],

        ["\xEF\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\x66\x64",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],

        ["\xEF\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\x66\x65",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],

        ["\xEF\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\x66\x66",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],

        ["\xEF\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\x66\x67",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],

        ["\xEF\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\x66\x69",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],

        ["\xEF\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\x66\x68",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],

        ["\xEF\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\x66\x6A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],

        ["\xEF\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\x66\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],

        ["\xEF\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\x66\x6B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],

        ["\xEF\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\x52\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],

        ["\xF0\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\x66\x6C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF0\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\x66\x6D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],

        ["\xF0\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\x66\x6E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],

        ["\xF0\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\x66\x70",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],

        ["\xF0\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\x66\x71",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],

        ["\xF0\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\x66\x72",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],

        ["\xF0\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\x66\x75",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],

        ["\xF0\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\x66\x76",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],

        ["\xF0\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\x66\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],

        ["\xF0\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\x66\x7B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],

        ["\xF0\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\x66\x7A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\x66\x7C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],

        ["\xF0\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\x66\x7D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],

        ["\xF0\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\x66\x7E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],

        ["\xF0\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],
        ["\x66\x80",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],

        ["\xF0\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x81"],
        ["\x66\x81",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x82"],
        ["\x66\x82",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],

        ["\xF0\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x83"],
        ["\x66\x83",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],

        ["\xF0\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x84"],
        ["\x66\x84",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],

        ["\xF0\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x85"],
        ["\x66\x85",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],

        ["\xF0\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\x54\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],

        ["\xF0\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\x52\x5B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],

        ["\xF0\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\x63\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],

        ["\xF0\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x87"],
        ["\x66\x87",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],

        ["\xF0\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8E"],
        ["\x66\x8E",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],

        ["\xF0\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x86"],
        ["\x66\x86",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],

        ["\xF0\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x89"],
        ["\x66\x89",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],

        ["\xF0\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8A"],
        ["\x66\x8A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],

        ["\xF0\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],
        ["\x66\x8B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],

        ["\xF0\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8C"],
        ["\x66\x8C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],

        ["\xF0\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8F"],
        ["\x66\x8F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],

        ["\xF0\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x90"],
        ["\x66\x90",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x91"],
        ["\x66\x91",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x92"],
        ["\x66\x92",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x93"],
        ["\x66\x93",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x8D"],
        ["\x66\x8D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x94"],
        ["\x66\x94",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x95"],
        ["\x66\x95",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x96"],
        ["\x66\x96",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x98"],
        ["\x66\x98",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x9A"],
        ["\x66\x9A",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],
        ["\x66\x9B",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],

        ["\xF0\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x9D"],
        ["\x66\x9D",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],

        ["\xF0\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],
        ["\x66\x9C",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],

        ["\xF0\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\x9F"],
        ["\x66\x9F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],

        ["\xF0\xCE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],
        ["\x66\xA0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],

        ["\xF0\xCF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\x66\xA1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],

        ["\xF0\xD0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA6"],
        ["\x66\xA6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xD1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\x66\xA7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA8"],
        ["\x66\xA8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xA9"],
        ["\x66\xA9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAA"],
        ["\x66\xAA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xD6"],
        ["\x53\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x53\xB5"],
        ["\x53\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xF0\xD7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xCE"],
        ["\x52\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xF0\xD8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAC"],
        ["\x66\xAC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAD"],
        ["\x66\xAD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xDA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"],
        ["\x66\xAE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],

        ["\xF0\xDB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xAF"],
        ["\x66\xAF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],

        ["\xF0\xDC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\x66\xB0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],

        ["\xF0\xDD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\x52\x77",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],

        ["\xF0\xDE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB1"],
        ["\x66\xB1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],

        ["\xF0\xDF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB2"],
        ["\x66\xB2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],

        ["\xF0\xE0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB3"],
        ["\x66\xB3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\xE1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB4"],
        ["\x66\xB4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],

        ["\xF0\xE2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB5"],
        ["\x66\xB5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB6"],
        ["\x66\xB6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB7"],
        ["\x66\xB7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB8"],
        ["\x66\xB8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\x66\xB9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBA"],
        ["\x66\xBA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"],
        ["\x66\xBB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBC"],
        ["\x66\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\xEA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBD"],
        ["\x66\xBD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],

        ["\xF0\xEB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBE"],
        ["\x66\xBE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],

        ["\xF0\xEC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xBF"],
        ["\x66\xBF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],

        ["\xF0\xED",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\x68\x6F",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],

        ["\xF0\xEE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\x66\xC0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],

        ["\xF0\xEF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],
        ["\x66\xC1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],

        ["\xF0\xF0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xFC"],
        ["\x52\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\x66\xC2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\x66\xC3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\xF0\xF3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\x54\x56",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\xF0\xF4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x50\xFB"],
        ["\x50\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xF0\xF5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],
        ["\x66\xC5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],
        ["\x66\xC6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\x66\xC7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],
        ["\x66\xC8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x51\xDC"],
        ["\x51\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\xFA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\x66\xC9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],

        ["\xF0\xFB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xCA"],
        ["\x66\xCA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],

        ["\xF0\xFC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xCD"],
        ["\x66\xCD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],

        ["\xF0\xFD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xCE"],
        ["\x66\xCE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],

        ["\xF0\xFE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xCF"],
        ["\x66\xCF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],

        ["\xF1\xA1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\x66\xD0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF1\xA2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\x66\xD1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],

        ["\xF1\xA3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],
        ["\x66\xD2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],

        ["\xF1\xA4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\x66\xD3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],

        ["\xF1\xA5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\x66\xD4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],

        ["\xF1\xA6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\x66\xD5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],

        ["\xF1\xA7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\x66\xD6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],

        ["\xF1\xA8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],
        ["\x66\xD7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],

        ["\xF1\xA9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],
        ["\x66\xD8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],

        ["\xF1\xAA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],
        ["\x66\xD9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],

        ["\xF1\xAB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xDC"],
        ["\x66\xDC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xAC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xDE"],
        ["\x66\xDE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],

        ["\xF1\xAD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],
        ["\x66\xE0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],

        ["\xF1\xAE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"],
        ["\x54\xBC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],

        ["\xF1\xAF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\x66\xE2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],

        ["\xF1\xB0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],
        ["\x66\xE3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xB1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],
        ["\x66\xE4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],

        ["\xF1\xB2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],
        ["\x66\xE7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],

        ["\xF1\xB3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE1"],
        ["\x66\xE1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],

        ["\xF1\xB4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],
        ["\x66\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],

        ["\xF1\xB5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\x66\xE9",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],

        ["\xF1\xB6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xEA"],
        ["\x66\xEA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],

        ["\xF1\xB7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xEB"],
        ["\x66\xEB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],

        ["\xF1\xB8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xEC"],
        ["\x66\xEC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],

        ["\xF1\xB9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xED"],
        ["\x66\xED",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],

        ["\xF1\xBA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xEE"],
        ["\x66\xEE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],

        ["\xF1\xBB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xEF"],
        ["\x66\xEF",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],

        ["\xF1\xBC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\x66\xF0",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],

        ["\xF1\xBD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\x66\xF1",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],

        ["\xF1\xBE",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\x66\xF2",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],

        ["\xF1\xBF",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\x66\xF3",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],

        ["\xF1\xC0",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\x66\xF4",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\xC1",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"],
        ["\x52\xE8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\x66\xF5",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],
        ["\x66\xF6",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\x66\xF7",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],
        ["\x66\xF8",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xFA"],
        ["\x66\xFA",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xFB"],
        ["\x66\xFB",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xFC"],
        ["\x66\xFC",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xFD"],
        ["\x66\xFD",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xCA",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"],
        ["\x66\xFE",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],

        ["\xF1\xCB",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\x67\x41",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],

        ["\xF1\xCC",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\x67\x42",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],

        ["\xF1\xCD",'cp00930','keis83',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\x67\x43",'keis83','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],

       