# Generated by default/object.tt
package Paws::Finspace::FederationParameters;
  use Moose;
  has ApplicationCallBackURL => (is => 'ro', isa => 'Str', request_name => 'applicationCallBackURL', traits => ['NameInRequest']);
  has AttributeMap => (is => 'ro', isa => 'Paws::Finspace::AttributeMap', request_name => 'attributeMap', traits => ['NameInRequest']);
  has FederationProviderName => (is => 'ro', isa => 'Str', request_name => 'federationProviderName', traits => ['NameInRequest']);
  has FederationURN => (is => 'ro', isa => 'Str', request_name => 'federationURN', traits => ['NameInRequest']);
  has SamlMetadataDocument => (is => 'ro', isa => 'Str', request_name => 'samlMetadataDocument', traits => ['NameInRequest']);
  has SamlMetadataURL => (is => 'ro', isa => 'Str', request_name => 'samlMetadataURL', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Finspace::FederationParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Finspace::FederationParameters object:

  $service_obj->Method(Att1 => { ApplicationCallBackURL => $value, ..., SamlMetadataURL => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Finspace::FederationParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationCallBackURL

=head1 DESCRIPTION

Configuration information when authentication mode is FEDERATED.

=head1 ATTRIBUTES


=head2 ApplicationCallBackURL => Str

The redirect or sign-in URL that should be entered into the SAML 2.0
compliant identity provider configuration (IdP).


=head2 AttributeMap => L<Paws::Finspace::AttributeMap>

SAML attribute name and value. The name must always be C<Email> and the
value should be set to the attribute definition in which user email is
set. For example, name would be C<Email> and value
C<http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress>.
Please check your SAML 2.0 compliant identity provider (IdP)
documentation for details.


=head2 FederationProviderName => Str

Name of the identity provider (IdP).


=head2 FederationURN => Str

The Uniform Resource Name (URN). Also referred as Service Provider URN
or Audience URI or Service Provider Entity ID.


=head2 SamlMetadataDocument => Str

SAML 2.0 Metadata document from identity provider (IdP).


=head2 SamlMetadataURL => Str

Provide the metadata URL from your SAML 2.0 compliant identity provider
(IdP).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Finspace>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

