package Dist::Zilla::Plugin::Test::Kwalitee::Extra;

use strict;
use warnings;

# ABSTRACT: Dist::Zilla plugin for Test::Kwalitee::Extra
our $VERSION = 'v0.1.0'; # VERSION

use Moose;
use Data::Section-setup;
with 'Dist::Zilla::Role::FileGatherer', 'Dist::Zilla::Role::TextTemplate';

sub mvp_multivalue_args { return qw( arg ) }

has arg => ( is => 'ro', isa => 'ArrayRef[Str]', traits => [ 'Array' ], default => sub { [] }, handles => { push_arg => 'push' }, );

sub gather_files {
  my ( $self, ) = @_;

  my $tests = q{eval "use Test::Kwalitee::Extra";};

  if ( @{ $self->arg } > 0 ) {

    my $arg = join ' ', @{ $self->arg };

    $tests = qq[eval {
  require Test::Kwalitee::Extra;
  Test::Kwalitee::Extra->import( qw( $arg ) );
};];

  }
  require Dist::Zilla::File::InMemory;

  for my $filename ( qw( xt/release/kwalitee.t ) ) {
    my $content = $self->fill_in_string( ${ $self->section_data( $filename ) }, { tests => \$tests }, );
    $self->add_file( Dist::Zilla::File::InMemory->new( { 'name' => $filename, 'content' => $content, } ), );
  }
} ## end sub gather_files

__PACKAGE__->meta->make_immutable;
no Moose;
1;

=pod

=head1 NAME

Dist::Zilla::Plugin::Test::Kwalitee::Extra - Dist::Zilla plugin for Test::Kwalitee::Extra

=head1 VERSION

version v0.1.0

=head1 SYNOPSIS

In your C<dist.ini>,

  [Test::Kwalitee::Extra]
  arg = !has_example

=head1 DESCRIPTION

This module is a L<Dist::Zilla> plugin for L<Test::Kwalitee::Extra>. It creates C<xt/release/kwalitee.t> to call L<Test::Kwalitee::Extra>.

Most part of codes and tests are identical to L<Dist::Zilla::Plugin::Test::Kwalitee>. Only the followings are changed points.

=over 4

=item *

Use L<Test::Kwalitee::Extra> instead of L<Test::Kwalitee>.

=item *

Change variable and configuration names.

=item *

Arguments are passed to Test::Kwalitee::Extra as it is. L<Dist::Zilla::Plugin::Test::Kwalitee> adds prefix C<-> to disable tests.

=item *

Test for more indicators.

=back

=head1 OPTIONS

=over 4

=item C<arg>

They are passed through to L<Test::Kwalitee::Extra>.

=back

=head1 METHODS

The following methods are overridden.

=over 4

=item C<mvp_multivalue_args>

Declare C<arg>.

=item C<gather_files>

Create C<xt/release/kwalitee.t>.

=back

=head1 NAME

Dist::Zilla::Plugin::Test::Kwalitee::Extra - Dist::Zilla plugin for Test::Kwalitee::Extra

=head1 AUTHORS

=over 4

=item *

L<Dist::Zilla::Plugin::Test::Kwalitee> authors

=item *

Yasutaka ATARASHI <yakex@cpan.org>

=back

=head1 LICENSE

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR

Yasutaka ATARASHI <yakex@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Yasutaka ATARASHI.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
___[ xt/release/kwalitee.t ]___
#!perl

# This test is generated by Dist::Zilla::Plugin::Test::Kwalitee::Extra
use strict;
use warnings;
use Test::More;   # needed to provide plan.
{{ $tests }}

plan skip_all => "Test::Kwalitee::Extra required for testing kwalitee: $@" if $@;
