# Generated by default/object.tt
package Paws::StorageGateway::AutomaticTapeCreationRule;
  use Moose;
  has MinimumNumTapes => (is => 'ro', isa => 'Int', required => 1);
  has PoolId => (is => 'ro', isa => 'Str', required => 1);
  has TapeBarcodePrefix => (is => 'ro', isa => 'Str', required => 1);
  has TapeSizeInBytes => (is => 'ro', isa => 'Int', required => 1);
  has Worm => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::AutomaticTapeCreationRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::AutomaticTapeCreationRule object:

  $service_obj->Method(Att1 => { MinimumNumTapes => $value, ..., Worm => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::AutomaticTapeCreationRule object:

  $result = $service_obj->Method(...);
  $result->Att1->MinimumNumTapes

=head1 DESCRIPTION

An automatic tape creation policy consists of automatic tape creation
rules where each rule defines when and how to create new tapes. For
more information about automatic tape creation, see Creating Tapes
Automatically
(https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).

=head1 ATTRIBUTES


=head2 B<REQUIRED> MinimumNumTapes => Int

The minimum number of available virtual tapes that the gateway
maintains at all times. If the number of tapes on the gateway goes
below this value, the gateway creates as many new tapes as are needed
to have C<MinimumNumTapes> on the gateway. For more information about
automatic tape creation, see Creating Tapes Automatically
(https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).


=head2 B<REQUIRED> PoolId => Str

The ID of the pool that you want to add your tape to for archiving. The
tape in this pool is archived in the Amazon S3 storage class that is
associated with the pool. When you use your backup application to eject
the tape, the tape is archived directly into the storage class (S3
Glacier or S3 Glacier Deep Archive) that corresponds to the pool.

Valid Values: C<GLACIER> | C<DEEP_ARCHIVE>


=head2 B<REQUIRED> TapeBarcodePrefix => Str

A prefix that you append to the barcode of the virtual tape that you
are creating. This prefix makes the barcode unique.

The prefix must be 1-4 characters in length and must be one of the
uppercase letters from A to Z.


=head2 B<REQUIRED> TapeSizeInBytes => Int

The size, in bytes, of the virtual tape capacity.


=head2 Worm => Bool

Set to C<true> to indicate that tapes are to be archived as
write-once-read-many (WORM). Set to C<false> when WORM is not enabled
for tapes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

