# Generated by default/object.tt
package Paws::AccessAnalyzer::JobDetails;
  use Moose;
  has CompletedOn => (is => 'ro', isa => 'Str', request_name => 'completedOn', traits => ['NameInRequest']);
  has JobError => (is => 'ro', isa => 'Paws::AccessAnalyzer::JobError', request_name => 'jobError', traits => ['NameInRequest']);
  has JobId => (is => 'ro', isa => 'Str', request_name => 'jobId', traits => ['NameInRequest'], required => 1);
  has StartedOn => (is => 'ro', isa => 'Str', request_name => 'startedOn', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::JobDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::JobDetails object:

  $service_obj->Method(Att1 => { CompletedOn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::JobDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CompletedOn

=head1 DESCRIPTION

Contains details about the policy generation request.

=head1 ATTRIBUTES


=head2 CompletedOn => Str

A timestamp of when the job was completed.


=head2 JobError => L<Paws::AccessAnalyzer::JobError>




=head2 B<REQUIRED> JobId => Str

The C<JobId> that is returned by the C<StartPolicyGeneration>
operation. The C<JobId> can be used with C<GetGeneratedPolicy> to
retrieve the generated policies or used with C<CancelPolicyGeneration>
to cancel the policy generation request.


=head2 B<REQUIRED> StartedOn => Str

A timestamp of when the job was started.


=head2 B<REQUIRED> Status => Str

The status of the job request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

