# Generated by default/object.tt
package Paws::Appflow::HoneycodeConnectorProfileCredentials;
  use Moose;
  has AccessToken => (is => 'ro', isa => 'Str', request_name => 'accessToken', traits => ['NameInRequest']);
  has OAuthRequest => (is => 'ro', isa => 'Paws::Appflow::ConnectorOAuthRequest', request_name => 'oAuthRequest', traits => ['NameInRequest']);
  has RefreshToken => (is => 'ro', isa => 'Str', request_name => 'refreshToken', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::HoneycodeConnectorProfileCredentials

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::HoneycodeConnectorProfileCredentials object:

  $service_obj->Method(Att1 => { AccessToken => $value, ..., RefreshToken => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::HoneycodeConnectorProfileCredentials object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessToken

=head1 DESCRIPTION

The connector-specific credentials required when using Amazon
Honeycode.

=head1 ATTRIBUTES


=head2 AccessToken => Str

The credentials used to access protected Amazon Honeycode resources.


=head2 OAuthRequest => L<Paws::Appflow::ConnectorOAuthRequest>




=head2 RefreshToken => Str

The credentials used to acquire new access tokens.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

