# Generated by default/object.tt
package Paws::Chime::ChannelMembership;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has InvitedBy => (is => 'ro', isa => 'Paws::Chime::Identity');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has Member => (is => 'ro', isa => 'Paws::Chime::Identity');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelMembership

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelMembership object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelMembership object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The details of a channel member.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the member's channel.


=head2 CreatedTimestamp => Str

The time at which the channel membership was created.


=head2 InvitedBy => L<Paws::Chime::Identity>

The identifier of the member who invited another member.


=head2 LastUpdatedTimestamp => Str

The time at which a channel membership was last updated.


=head2 Member => L<Paws::Chime::Identity>

The data of the channel member.


=head2 Type => Str

The membership type set for the channel member.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

