# Generated by default/object.tt
package Paws::GlueDataBrew::JobRun;
  use Moose;
  has Attempt => (is => 'ro', isa => 'Int');
  has CompletedOn => (is => 'ro', isa => 'Str');
  has DataCatalogOutputs => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::DataCatalogOutput]');
  has DatasetName => (is => 'ro', isa => 'Str');
  has ErrorMessage => (is => 'ro', isa => 'Str');
  has ExecutionTime => (is => 'ro', isa => 'Int');
  has JobName => (is => 'ro', isa => 'Str');
  has JobSample => (is => 'ro', isa => 'Paws::GlueDataBrew::JobSample');
  has LogGroupName => (is => 'ro', isa => 'Str');
  has LogSubscription => (is => 'ro', isa => 'Str');
  has Outputs => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::Output]');
  has RecipeReference => (is => 'ro', isa => 'Paws::GlueDataBrew::RecipeReference');
  has RunId => (is => 'ro', isa => 'Str');
  has StartedBy => (is => 'ro', isa => 'Str');
  has StartedOn => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::JobRun

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::JobRun object:

  $service_obj->Method(Att1 => { Attempt => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::JobRun object:

  $result = $service_obj->Method(...);
  $result->Att1->Attempt

=head1 DESCRIPTION

Represents one run of a DataBrew job.

=head1 ATTRIBUTES


=head2 Attempt => Int

The number of times that DataBrew has attempted to run the job.


=head2 CompletedOn => Str

The date and time when the job completed processing.


=head2 DataCatalogOutputs => ArrayRef[L<Paws::GlueDataBrew::DataCatalogOutput>]

One or more artifacts that represent the AWS Glue Data Catalog output
from running the job.


=head2 DatasetName => Str

The name of the dataset for the job to process.


=head2 ErrorMessage => Str

A message indicating an error (if any) that was encountered when the
job ran.


=head2 ExecutionTime => Int

The amount of time, in seconds, during which a job run consumed
resources.


=head2 JobName => Str

The name of the job being processed during this run.


=head2 JobSample => L<Paws::GlueDataBrew::JobSample>

A sample configuration for profile jobs only, which determines the
number of rows on which the profile job is run. If a C<JobSample> value
isn't provided, the default is used. The default value is CUSTOM_ROWS
for the mode parameter and 20,000 for the size parameter.


=head2 LogGroupName => Str

The name of an Amazon CloudWatch log group, where the job writes
diagnostic messages when it runs.


=head2 LogSubscription => Str

The current status of Amazon CloudWatch logging for the job run.


=head2 Outputs => ArrayRef[L<Paws::GlueDataBrew::Output>]

One or more output artifacts from a job run.


=head2 RecipeReference => L<Paws::GlueDataBrew::RecipeReference>

The set of steps processed by the job.


=head2 RunId => Str

The unique identifier of the job run.


=head2 StartedBy => Str

The Amazon Resource Name (ARN) of the user who initiated the job run.


=head2 StartedOn => Str

The date and time when the job run began.


=head2 State => Str

The current state of the job run entity itself.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

