# Generated by default/object.tt
package Paws::MediaLive::CaptionRectangle;
  use Moose;
  has Height => (is => 'ro', isa => 'Num', request_name => 'height', traits => ['NameInRequest'], required => 1);
  has LeftOffset => (is => 'ro', isa => 'Num', request_name => 'leftOffset', traits => ['NameInRequest'], required => 1);
  has TopOffset => (is => 'ro', isa => 'Num', request_name => 'topOffset', traits => ['NameInRequest'], required => 1);
  has Width => (is => 'ro', isa => 'Num', request_name => 'width', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::CaptionRectangle

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::CaptionRectangle object:

  $service_obj->Method(Att1 => { Height => $value, ..., Width => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::CaptionRectangle object:

  $result = $service_obj->Method(...);
  $result->Att1->Height

=head1 DESCRIPTION

Caption Rectangle

=head1 ATTRIBUTES


=head2 B<REQUIRED> Height => Num

See the description in leftOffset. For height, specify the entire
height of the rectangle as a percentage of the underlying frame height.
For example, \"80\" means the rectangle height is 80% of the underlying
frame height. The topOffset and rectangleHeight must add up to 100% or
less. This field corresponds to tts:extent - Y in the TTML standard.


=head2 B<REQUIRED> LeftOffset => Num

Applies only if you plan to convert these source captions to EBU-TT-D
or TTML in an output. (Make sure to leave the default if you don't have
either of these formats in the output.) You can define a display
rectangle for the captions that is smaller than the underlying video
frame. You define the rectangle by specifying the position of the left
edge, top edge, bottom edge, and right edge of the rectangle, all
within the underlying video frame. The units for the measurements are
percentages. If you specify a value for one of these fields, you must
specify a value for all of them. For leftOffset, specify the position
of the left edge of the rectangle, as a percentage of the underlying
frame width, and relative to the left edge of the frame. For example,
\"10\" means the measurement is 10% of the underlying frame width. The
rectangle left edge starts at that position from the left edge of the
frame. This field corresponds to tts:origin - X in the TTML standard.


=head2 B<REQUIRED> TopOffset => Num

See the description in leftOffset. For topOffset, specify the position
of the top edge of the rectangle, as a percentage of the underlying
frame height, and relative to the top edge of the frame. For example,
\"10\" means the measurement is 10% of the underlying frame height. The
rectangle top edge starts at that position from the top edge of the
frame. This field corresponds to tts:origin - Y in the TTML standard.


=head2 B<REQUIRED> Width => Num

See the description in leftOffset. For width, specify the entire width
of the rectangle as a percentage of the underlying frame width. For
example, \"80\" means the rectangle width is 80% of the underlying
frame width. The leftOffset and rectangleWidth must add up to 100% or
less. This field corresponds to tts:extent - X in the TTML standard.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

