# Generated by default/object.tt
package Paws::MediaLive::TemporalFilterSettings;
  use Moose;
  has PostFilterSharpening => (is => 'ro', isa => 'Str', request_name => 'postFilterSharpening', traits => ['NameInRequest']);
  has Strength => (is => 'ro', isa => 'Str', request_name => 'strength', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::TemporalFilterSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::TemporalFilterSettings object:

  $service_obj->Method(Att1 => { PostFilterSharpening => $value, ..., Strength => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::TemporalFilterSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->PostFilterSharpening

=head1 DESCRIPTION

Temporal Filter Settings

=head1 ATTRIBUTES


=head2 PostFilterSharpening => Str

If you enable this filter, the results are the following: - If the
source content is noisy (it contains excessive digital artifacts), the
filter cleans up the source. - If the source content is already clean,
the filter tends to decrease the bitrate, especially when the rate
control mode is QVBR.


=head2 Strength => Str

Choose a filter strength. We recommend a strength of 1 or 2. A higher
strength might take out good information, resulting in an image that is
overly soft.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

