/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.backend.BackendManager;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.BadRequestException;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.MimeTypeUtil;

public abstract class BaseRequestHandler {
    protected final BackendManager backendManager;
    protected final JolokiaContext jolokiaCtx;
    protected final boolean includeRequestGlobal;

    public BaseRequestHandler(JolokiaContext context) {
        this.jolokiaCtx = context;
        this.backendManager = new BackendManager(context);
        this.includeRequestGlobal = this.jolokiaCtx.getConfig(ConfigKey.INCLUDE_REQUEST) == null || Boolean.parseBoolean(this.jolokiaCtx.getConfig(ConfigKey.INCLUDE_REQUEST));
    }

    public JSONObject handleThrowable(Throwable pThrowable) {
        if (pThrowable instanceof IllegalArgumentException) {
            return this.getErrorJSON(400, pThrowable, null);
        }
        if (pThrowable instanceof SecurityException) {
            return this.getErrorJSON(403, new Exception(pThrowable.getMessage()), null);
        }
        return this.getErrorJSON(500, pThrowable, null);
    }

    public ProcessingParameters getProcessingParameter(Map<String, String[]> pParameterMap) throws BadRequestException {
        HashMap<ConfigKey, String> config = new HashMap<ConfigKey, String>();
        if (pParameterMap != null) {
            this.extractRequestParameters(config, pParameterMap);
            this.validateRequestParameters(config);
            this.extractDefaultRequestParameters(config);
        }
        return new ProcessingParameters(config);
    }

    protected void extractRequestParameters(Map<ConfigKey, String> pConfig, Map<String, String[]> pParameterMap) {
        for (Map.Entry<String, String[]> entry : pParameterMap.entrySet()) {
            ConfigKey cKey;
            String[] values = entry.getValue();
            if (values == null || values.length <= 0 || (cKey = ConfigKey.getRequestConfigKey(entry.getKey())) == null) continue;
            String value = values[0];
            pConfig.put(cKey, value != null ? value.toString() : null);
        }
    }

    protected void validateRequestParameters(Map<ConfigKey, String> config) throws BadRequestException {
        for (Map.Entry<ConfigKey, String> e : config.entrySet()) {
            String v;
            ConfigKey key = e.getKey();
            String value = e.getValue();
            Class<?> type = key.getType();
            if (type == null) continue;
            if (type == Boolean.class) {
                v = value.trim().toLowerCase();
                if (ConfigKey.enabledValues.contains(v) || ConfigKey.disabledValues.contains(v)) continue;
                throw new BadRequestException("Invalid value of " + key.getKeyValue() + " parameter");
            }
            if (type == Integer.class) {
                v = value.trim();
                try {
                    Integer.parseInt(v);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new BadRequestException("Invalid value of " + key.getKeyValue() + " parameter");
                }
            }
            if (type != String.class) continue;
            if (key == ConfigKey.INCLUDE_STACKTRACE) {
                v = value.trim().toLowerCase();
                if (ConfigKey.enabledValues.contains(v) || ConfigKey.disabledValues.contains(v) || v.equals("runtime")) continue;
                throw new BadRequestException("Invalid value of " + ConfigKey.INCLUDE_STACKTRACE.getKeyValue() + " parameter");
            }
            if (key == ConfigKey.SERIALIZE_LONG) {
                v = value.trim().toLowerCase();
                if ("number".equals(v) || "string".equals(v)) continue;
                throw new BadRequestException("Invalid value of " + ConfigKey.SERIALIZE_LONG.getKeyValue() + " parameter");
            }
            if (key != ConfigKey.MIME_TYPE) continue;
            v = value.trim().toLowerCase();
            boolean ok = false;
            for (String accepted : MimeTypeUtil.ACCEPTED_MIME_TYPES) {
                if (!accepted.equals(v)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            throw new BadRequestException("Invalid value of " + ConfigKey.MIME_TYPE.getKeyValue() + " parameter");
        }
    }

    protected void extractDefaultRequestParameters(Map<ConfigKey, String> pConfig) {
        Set<ConfigKey> globalRequestConfigKeys = this.jolokiaCtx.getConfigKeys();
        for (ConfigKey key : globalRequestConfigKeys) {
            if (!key.isRequestConfig() || pConfig.containsKey((Object)key)) continue;
            pConfig.put(key, this.jolokiaCtx.getConfig(key));
        }
    }

    protected JSONObject executeRequest(JolokiaRequest pJmxReq) throws EmptyResponseException {
        try {
            return this.backendManager.handleRequest(pJmxReq);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | ReflectionException e) {
            return this.getErrorJSON(404, e, pJmxReq);
        }
        catch (MBeanException e) {
            return this.getErrorJSON(500, e.getTargetException(), pJmxReq);
        }
        catch (IOException | UnsupportedOperationException | JMException e) {
            return this.getErrorJSON(500, e, pJmxReq);
        }
        catch (IllegalArgumentException e) {
            return this.getErrorJSON(400, e, pJmxReq);
        }
        catch (SecurityException e) {
            return this.getErrorJSON(403, new Exception(e.getMessage()), pJmxReq);
        }
        catch (RuntimeMBeanException e) {
            return this.errorForUnwrappedException(e, pJmxReq);
        }
    }

    protected JSONObject getErrorJSON(int pErrorCode, Throwable pExp, JolokiaRequest pJmxReq) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"status", (Object)pErrorCode);
        jsonObject.put((Object)"error", (Object)this.getExceptionMessage(pExp));
        jsonObject.put((Object)"error_type", (Object)pExp.getClass().getName());
        this.addErrorInfo(jsonObject, pExp, pJmxReq);
        if (this.jolokiaCtx.isDebug()) {
            this.jolokiaCtx.error("Error " + pErrorCode, pExp);
        }
        if (pJmxReq != null) {
            String includeRequestLocal = pJmxReq.getParameter(ConfigKey.INCLUDE_REQUEST);
            if (this.includeRequestGlobal && !"false".equals(includeRequestLocal) || !this.includeRequestGlobal && "true".equals(includeRequestLocal)) {
                jsonObject.put((Object)"request", (Object)pJmxReq.toJSON());
            }
        }
        return jsonObject;
    }

    protected void addErrorInfo(JSONObject pErrorResp, Throwable pExp, JolokiaRequest pJmxReq) {
        if (Boolean.parseBoolean(this.jolokiaCtx.getConfig(ConfigKey.ALLOW_ERROR_DETAILS))) {
            String includeStackTrace;
            String string = includeStackTrace = pJmxReq != null ? pJmxReq.getParameter(ConfigKey.INCLUDE_STACKTRACE) : "false";
            if (includeStackTrace.equalsIgnoreCase("true") || includeStackTrace.equalsIgnoreCase("runtime") && pExp instanceof RuntimeException) {
                StringWriter writer = new StringWriter();
                pExp.printStackTrace(new PrintWriter(writer));
                pErrorResp.put((Object)"stacktrace", (Object)writer.toString());
            }
            if (pJmxReq != null && pJmxReq.getParameterAsBool(ConfigKey.SERIALIZE_EXCEPTION).booleanValue()) {
                pErrorResp.put((Object)"error_value", this.backendManager.convertExceptionToJson(pExp, pJmxReq));
            }
        }
    }

    protected JSONObject errorForUnwrappedException(Exception e, JolokiaRequest pJmxReq) {
        Throwable cause = e.getCause();
        int code = cause instanceof IllegalArgumentException ? 400 : (cause instanceof SecurityException ? 403 : 500);
        return this.getErrorJSON(code, cause, pJmxReq);
    }

    protected String getExceptionMessage(Throwable pException) {
        String message = pException.getLocalizedMessage();
        return pException.getClass().getName() + (String)(message != null ? " : " + message : "");
    }
}

