/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAuthClientTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(KeyAuthClientTest.class);

    public void createNodePrintAcl(ZooKeeper zk, String path, String testName) {
        try {
            LOG.debug("KeyAuthenticationProvider Creating Test Node:{}\n", (Object)path);
            zk.create(path, null, (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            List acls = zk.getACL(path, null);
            LOG.debug("Node:{} Test:{} ACLs:", (Object)path, (Object)testName);
            for (ACL acl : acls) {
                LOG.debug("  {}", (Object)acl.toString());
            }
        }
        catch (Exception e) {
            LOG.debug("  EXCEPTION THROWN", (Throwable)e);
        }
    }

    public void preAuth() throws Exception {
        zk.addAuthInfo("key", "25".getBytes());
        try (TestableZooKeeper zk = this.createClient();){
            this.createNodePrintAcl((ZooKeeper)zk, "/pre", "testPreAuth");
            zk.setACL("/", ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            zk.getChildren("/", false);
            zk.create("/abc", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.setData("/abc", "testData1".getBytes(), -1);
            zk.create("/key", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.setData("/key", "5".getBytes(), -1);
            Thread.sleep(1000L);
        }
    }

    public void missingAuth() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.getData("/abc", false, null);
            Assertions.fail((String)"Should not be able to get data");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        try {
            zk.setData("/abc", "testData2".getBytes(), -1);
            Assertions.fail((String)"Should not be able to set data");
        }
        catch (KeeperException keeperException) {
        }
        finally {
            zk.close();
        }
    }

    public void validAuth() throws Exception {
        zk.addAuthInfo("key", "25".getBytes());
        try (TestableZooKeeper zk = this.createClient();){
            this.createNodePrintAcl((ZooKeeper)zk, "/valid", "testValidAuth");
            zk.getData("/abc", false, null);
            zk.setData("/abc", "testData3".getBytes(), -1);
        }
    }

    public void validAuth2() throws Exception {
        zk.addAuthInfo("key", "125".getBytes());
        try (TestableZooKeeper zk = this.createClient();){
            this.createNodePrintAcl((ZooKeeper)zk, "/valid2", "testValidAuth2");
            zk.getData("/abc", false, null);
            zk.setData("/abc", "testData3".getBytes(), -1);
        }
    }

    @Test
    public void testAuth() throws Exception {
        this.preAuth();
        this.missingAuth();
        this.validAuth();
        this.validAuth2();
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.KeyAuthenticationProvider");
    }
}

