/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.distribution.FDistribution;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.StatisticUtils;

public final class OneWayAnova {
    private static final OneWayAnova DEFAULT = new OneWayAnova();

    private OneWayAnova() {
    }

    public static OneWayAnova withDefaults() {
        return DEFAULT;
    }

    public double statistic(Collection<double[]> data) {
        double[] f = new double[1];
        OneWayAnova.aov(data, f);
        return f[0];
    }

    public Result test(Collection<double[]> data) {
        return OneWayAnova.aov(data, null);
    }

    private static Result aov(Collection<double[]> data, double[] statistic) {
        Arguments.checkCategoriesRequiredSize(data.size(), 2);
        long n = 0L;
        for (double[] array : data) {
            n += (long)array.length;
            Arguments.checkValuesRequiredSize(array.length, 1);
        }
        long dfwg = n - (long)data.size();
        if (dfwg == 0L) {
            throw new InferenceException("%s is zero", "Degrees of freedom within groups");
        }
        double m = StatisticUtils.mean(data);
        Sum sxx = Sum.create();
        Sum sx = Sum.create();
        Sum sg = Sum.create();
        boolean eachSame = true;
        for (double[] array : data) {
            eachSame = eachSame && OneWayAnova.allMatch(array[0], array);
            Sum s = Sum.create();
            for (double v : array) {
                double x2 = v - m;
                s.add(x2);
                sx.add(x2);
                sxx.add(x2 * x2);
            }
            sg.add(-OneWayAnova.pow2(s.getAsDouble()) / (double)array.length);
        }
        double sswg = Math.max(0.0, sxx.add(sg).getAsDouble());
        double ssbg = Math.max(0.0, -sg.add(OneWayAnova.pow2(sx.getAsDouble()) / (double)n).getAsDouble());
        int dfbg = data.size() - 1;
        boolean allSame = eachSame && OneWayAnova.allMatch(data);
        double msbg = allSame ? 0.0 : ssbg / (double)dfbg;
        double mswg = eachSame ? 0.0 : sswg / (double)dfwg;
        double f = msbg / mswg;
        if (statistic != null) {
            statistic[0] = f;
            return null;
        }
        double p = FDistribution.of((double)dfbg, (double)dfwg).survivalProbability(f);
        double nO = ((double)n - data.stream().mapToDouble(x -> OneWayAnova.pow2(((double[])x).length)).sum() / (double)n) / (double)dfbg;
        return new Result(dfbg, dfwg, msbg, mswg, nO, f, p);
    }

    private static boolean allMatch(double v, double[] a) {
        for (double w : a) {
            if (v == w) continue;
            return false;
        }
        return true;
    }

    private static boolean allMatch(Collection<double[]> data) {
        Iterator<double[]> iter = data.iterator();
        double v = iter.next()[0];
        while (iter.hasNext()) {
            if (iter.next()[0] == v) continue;
            return false;
        }
        return true;
    }

    private static double pow2(double x) {
        return x * x;
    }

    public static final class Result
    extends BaseSignificanceResult {
        private final int dfbg;
        private final long dfwg;
        private final double msbg;
        private final double mswg;
        private final double nO;

        Result(int dfbg, long dfwg, double msbg, double mswg, double nO, double f, double p) {
            super(f, p);
            this.dfbg = dfbg;
            this.dfwg = dfwg;
            this.msbg = msbg;
            this.mswg = mswg;
            this.nO = nO;
        }

        int getDFBG() {
            return this.dfbg;
        }

        long getDFWG() {
            return this.dfwg;
        }

        public double getMSBG() {
            return this.msbg;
        }

        public double getMSWG() {
            return this.mswg;
        }

        public double getVCBG() {
            if (this.msbg <= this.mswg) {
                return 0.0;
            }
            double a = (this.msbg - this.mswg) / this.nO;
            double b = this.mswg;
            return a / (a + b);
        }

        public double getVCWG() {
            if (this.msbg <= this.mswg) {
                return 1.0;
            }
            double a = (this.msbg - this.mswg) / this.nO;
            double b = this.mswg;
            return b / (a + b);
        }
    }
}

