/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.sources;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.Resource;
import org.xmlresolver.sources.ResolverResourceInfo;
import org.xmlresolver.utils.RsrcUtils;

public class ResolverLSInput
implements LSInput,
ResolverResourceInfo {
    public final URI resolvedURI;
    final String publicId;
    final String systemId;
    final InputStream body;
    final URI uri;
    private final int statusCode;
    private final Map<String, List<String>> resolvedHeaders;

    public ResolverLSInput(Resource rsrc, String publicId, String systemId) {
        this.resolvedURI = rsrc.localUri();
        this.body = rsrc.body();
        this.publicId = publicId;
        this.systemId = systemId;
        this.uri = rsrc.uri();
        this.statusCode = 200;
        this.resolvedHeaders = Collections.emptyMap();
    }

    public ResolverLSInput(ResolvedResource rsrc, String publicId) {
        this.resolvedURI = rsrc.getLocalURI();
        this.body = rsrc.getInputStream();
        this.systemId = rsrc.getResolvedURI().toString();
        this.publicId = publicId;
        this.uri = rsrc.getResolvedURI();
        this.statusCode = rsrc.getStatusCode();
        this.resolvedHeaders = rsrc.getHeaders();
    }

    @Override
    public Reader getCharacterStream() {
        return new InputStreamReader(this.body);
    }

    @Override
    public void setCharacterStream(Reader reader) {
        throw new UnsupportedOperationException("Can't set character stream on resolver LSInput");
    }

    @Override
    public InputStream getByteStream() {
        return this.body;
    }

    @Override
    public void setByteStream(InputStream inputStream) {
        throw new UnsupportedOperationException("Can't set byte stream on resolver LSInput");
    }

    @Override
    public String getStringData() {
        return null;
    }

    @Override
    public void setStringData(String string) {
        throw new UnsupportedOperationException("Can't set string data on resolver LSInput");
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String string) {
        throw new UnsupportedOperationException("Can't set system ID on resolver LSInput");
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String string) {
        throw new UnsupportedOperationException("Can't set public ID on resolver LSInput");
    }

    @Override
    public String getBaseURI() {
        return this.uri.toString();
    }

    @Override
    public void setBaseURI(String string) {
        throw new UnsupportedOperationException("Can't set base URI on resolver LSInput");
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public void setEncoding(String string) {
        throw new UnsupportedOperationException("Can't set encoding on resolver LSInput");
    }

    @Override
    public boolean getCertifiedText() {
        return false;
    }

    @Override
    public void setCertifiedText(boolean b) {
        throw new UnsupportedOperationException("Can't set certified text on resolver LSInput");
    }

    @Override
    public URI getResolvedURI() {
        return this.resolvedURI;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.resolvedHeaders;
    }

    @Override
    public String getHeader(String headerName) {
        return RsrcUtils.getHeader(headerName, this.resolvedHeaders);
    }
}

