/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreCatalog
implements Catalog,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreCatalog.class);
    private MetricsReporter metricsReporter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table loadTable(TableIdentifier identifier) {
        Table result;
        if (this.isValidIdentifier(identifier)) {
            TableOperations ops = this.newTableOps(identifier);
            if (ops.current() == null) {
                if (!this.isValidMetadataIdentifier(identifier)) throw new NoSuchTableException("Table does not exist: %s", new Object[]{identifier});
                result = this.loadMetadataTable(identifier);
            } else {
                result = new BaseTable(ops, BaseMetastoreCatalog.fullTableName(this.name(), identifier), this.metricsReporter());
            }
        } else {
            if (!this.isValidMetadataIdentifier(identifier)) throw new NoSuchTableException("Invalid table identifier: %s", new Object[]{identifier});
            result = this.loadMetadataTable(identifier);
        }
        LOG.info("Table loaded by catalog: {}", (Object)result);
        return result;
    }

    public Table registerTable(TableIdentifier identifier, String metadataFileLocation) {
        Preconditions.checkArgument((identifier != null && this.isValidIdentifier(identifier) ? 1 : 0) != 0, (String)"Invalid identifier: %s", (Object)identifier);
        Preconditions.checkArgument((metadataFileLocation != null && !metadataFileLocation.isEmpty() ? 1 : 0) != 0, (Object)"Cannot register an empty metadata file location as a table");
        if (this.tableExists(identifier)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{identifier});
        }
        TableOperations ops = this.newTableOps(identifier);
        InputFile metadataFile = ops.io().newInputFile(metadataFileLocation);
        TableMetadata metadata = TableMetadataParser.read(metadataFile);
        ops.commit(null, metadata);
        return new BaseTable(ops, BaseMetastoreCatalog.fullTableName(this.name(), identifier), this.metricsReporter());
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new BaseMetastoreCatalogTableBuilder(identifier, schema);
    }

    private Table loadMetadataTable(TableIdentifier identifier) {
        String tableName = identifier.name();
        MetadataTableType type = MetadataTableType.from(tableName);
        if (type != null) {
            TableIdentifier baseTableIdentifier = TableIdentifier.of((String[])identifier.namespace().levels());
            TableOperations ops = this.newTableOps(baseTableIdentifier);
            if (ops.current() == null) {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{baseTableIdentifier});
            }
            return MetadataTableUtils.createMetadataTableInstance(ops, this.name(), baseTableIdentifier, identifier, type);
        }
        throw new NoSuchTableException("Table does not exist: %s", new Object[]{identifier});
    }

    protected boolean isValidMetadataIdentifier(TableIdentifier identifier) {
        return MetadataTableType.from(identifier.name()) != null && this.isValidIdentifier(TableIdentifier.of((String[])identifier.namespace().levels()));
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return true;
    }

    protected Map<String, String> properties() {
        return ImmutableMap.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    protected abstract TableOperations newTableOps(TableIdentifier var1);

    protected abstract String defaultWarehouseLocation(TableIdentifier var1);

    protected static String fullTableName(String catalogName, TableIdentifier identifier) {
        return CatalogUtil.fullTableName(catalogName, identifier);
    }

    protected MetricsReporter metricsReporter() {
        if (this.metricsReporter == null) {
            this.metricsReporter = CatalogUtil.loadMetricsReporter(this.properties());
        }
        return this.metricsReporter;
    }

    @Override
    public void close() throws IOException {
        if (this.metricsReporter != null) {
            this.metricsReporter.close();
        }
    }

    protected class BaseMetastoreCatalogTableBuilder
    implements Catalog.TableBuilder {
        private final TableIdentifier identifier;
        private final Schema schema;
        private final Map<String, String> tableProperties = Maps.newHashMap();
        private PartitionSpec spec = PartitionSpec.unpartitioned();
        private SortOrder sortOrder = SortOrder.unsorted();
        private String location = null;

        public BaseMetastoreCatalogTableBuilder(TableIdentifier identifier, Schema schema) {
            Preconditions.checkArgument((boolean)BaseMetastoreCatalog.this.isValidIdentifier(identifier), (String)"Invalid table identifier: %s", (Object)identifier);
            this.identifier = identifier;
            this.schema = schema;
            this.tableProperties.putAll(this.tableDefaultProperties());
        }

        public Catalog.TableBuilder withPartitionSpec(PartitionSpec newSpec) {
            this.spec = newSpec != null ? newSpec : PartitionSpec.unpartitioned();
            return this;
        }

        public Catalog.TableBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder != null ? newSortOrder : SortOrder.unsorted();
            return this;
        }

        public Catalog.TableBuilder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        public Catalog.TableBuilder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.tableProperties.putAll(properties);
            }
            return this;
        }

        public Catalog.TableBuilder withProperty(String key, String value) {
            this.tableProperties.put(key, value);
            return this;
        }

        public Table create() {
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.identifier});
            }
            String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
            this.tableProperties.putAll(this.tableOverrideProperties());
            TableMetadata metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, this.tableProperties);
            try {
                ops.commit(null, metadata);
            }
            catch (CommitFailedException ignored) {
                throw new AlreadyExistsException("Table was created concurrently: %s", new Object[]{this.identifier});
            }
            return new BaseTable(ops, BaseMetastoreCatalog.fullTableName(BaseMetastoreCatalog.this.name(), this.identifier), BaseMetastoreCatalog.this.metricsReporter());
        }

        public Transaction createTransaction() {
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.identifier});
            }
            String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
            this.tableProperties.putAll(this.tableOverrideProperties());
            TableMetadata metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, this.tableProperties);
            return Transactions.createTableTransaction(this.identifier.toString(), ops, metadata, BaseMetastoreCatalog.this.metricsReporter());
        }

        public Transaction replaceTransaction() {
            return this.newReplaceTableTransaction(false);
        }

        public Transaction createOrReplaceTransaction() {
            return this.newReplaceTableTransaction(true);
        }

        private Transaction newReplaceTableTransaction(boolean orCreate) {
            TableMetadata metadata;
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (!orCreate && ops.current() == null) {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{this.identifier});
            }
            this.tableProperties.putAll(this.tableOverrideProperties());
            if (ops.current() != null) {
                String baseLocation = this.location != null ? this.location : ops.current().location();
                metadata = ops.current().buildReplacement(this.schema, this.spec, this.sortOrder, baseLocation, this.tableProperties);
            } else {
                String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
                metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, this.tableProperties);
            }
            if (orCreate) {
                return Transactions.createOrReplaceTableTransaction(this.identifier.toString(), ops, metadata, BaseMetastoreCatalog.this.metricsReporter());
            }
            return Transactions.replaceTableTransaction(this.identifier.toString(), ops, metadata, BaseMetastoreCatalog.this.metricsReporter());
        }

        private Map<String, String> tableDefaultProperties() {
            Map<String, String> tableDefaultProperties = PropertyUtil.propertiesWithPrefix(BaseMetastoreCatalog.this.properties(), "table-default.");
            LOG.info("Table properties set at catalog level through catalog properties: {}", tableDefaultProperties);
            return tableDefaultProperties;
        }

        private Map<String, String> tableOverrideProperties() {
            Map<String, String> tableOverrideProperties = PropertyUtil.propertiesWithPrefix(BaseMetastoreCatalog.this.properties(), "table-override.");
            LOG.info("Table properties enforced at catalog level through catalog properties: {}", tableOverrideProperties);
            return tableOverrideProperties;
        }
    }
}

