/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.extension.auth.opa.model.Actor;
import org.apache.polaris.extension.auth.opa.model.Context;
import org.apache.polaris.extension.auth.opa.model.OpaAuthorizationInput;
import org.apache.polaris.extension.auth.opa.model.Resource;
import org.immutables.value.Generated;

@Generated(from="OpaAuthorizationInput", generator="Immutables")
public final class ImmutableOpaAuthorizationInput
implements OpaAuthorizationInput {
    private final Actor actor;
    private final String action;
    private final Resource resource;
    private final Context context;
    private transient int hashCode;

    private ImmutableOpaAuthorizationInput(Actor actor, String action, Resource resource, Context context) {
        this.actor = actor;
        this.action = action;
        this.resource = resource;
        this.context = context;
    }

    @Override
    @JsonProperty(required=true)
    public Actor actor() {
        return this.actor;
    }

    @Override
    @JsonProperty(required=true)
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty(required=true)
    public Resource resource() {
        return this.resource;
    }

    @Override
    @JsonProperty(required=true)
    public Context context() {
        return this.context;
    }

    public final ImmutableOpaAuthorizationInput withActor(Actor value) {
        if (this.actor == value) {
            return this;
        }
        Actor newValue = Objects.requireNonNull(value, "actor");
        return new ImmutableOpaAuthorizationInput(newValue, this.action, this.resource, this.context);
    }

    public final ImmutableOpaAuthorizationInput withAction(String value) {
        String newValue = Objects.requireNonNull(value, "action");
        if (this.action.equals(newValue)) {
            return this;
        }
        return new ImmutableOpaAuthorizationInput(this.actor, newValue, this.resource, this.context);
    }

    public final ImmutableOpaAuthorizationInput withResource(Resource value) {
        if (this.resource == value) {
            return this;
        }
        Resource newValue = Objects.requireNonNull(value, "resource");
        return new ImmutableOpaAuthorizationInput(this.actor, this.action, newValue, this.context);
    }

    public final ImmutableOpaAuthorizationInput withContext(Context value) {
        if (this.context == value) {
            return this;
        }
        Context newValue = Objects.requireNonNull(value, "context");
        return new ImmutableOpaAuthorizationInput(this.actor, this.action, this.resource, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOpaAuthorizationInput && this.equalsByValue((ImmutableOpaAuthorizationInput)another);
    }

    private boolean equalsByValue(ImmutableOpaAuthorizationInput another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.actor.equals(another.actor) && this.action.equals(another.action) && this.resource.equals(another.resource) && this.context.equals(another.context);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.actor.hashCode();
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.context.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OpaAuthorizationInput").omitNullValues().add("actor", (Object)this.actor).add("action", (Object)this.action).add("resource", (Object)this.resource).add("context", (Object)this.context).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOpaAuthorizationInput fromJson(Json json) {
        Builder builder = ImmutableOpaAuthorizationInput.builder();
        if (json._actor != null) {
            builder.actor(json._actor);
        }
        if (json._action != null) {
            builder.action(json._action);
        }
        if (json._resource != null) {
            builder.resource(json._resource);
        }
        if (json._context != null) {
            builder.context(json._context);
        }
        return builder.build();
    }

    public static ImmutableOpaAuthorizationInput copyOf(OpaAuthorizationInput instance) {
        if (instance instanceof ImmutableOpaAuthorizationInput) {
            return (ImmutableOpaAuthorizationInput)instance;
        }
        return ImmutableOpaAuthorizationInput.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableOpaAuthorizationInput.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpaAuthorizationInput", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACTOR = 1L;
        private static final long INIT_BIT_ACTION = 2L;
        private static final long INIT_BIT_RESOURCE = 4L;
        private static final long INIT_BIT_CONTEXT = 8L;
        private long initBits = 15L;
        private Actor actor;
        private String action;
        private Resource resource;
        private Context context;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpaAuthorizationInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.actor(instance.actor());
            this.action(instance.action());
            this.resource(instance.resource());
            this.context(instance.context());
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder actor(Actor actor) {
            this.actor = Objects.requireNonNull(actor, "actor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder action(String action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder resource(Resource resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder context(Context context) {
            this.context = Objects.requireNonNull(context, "context");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 15L;
            this.actor = null;
            this.action = null;
            this.resource = null;
            this.context = null;
            return this;
        }

        public ImmutableOpaAuthorizationInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOpaAuthorizationInput(this.actor, this.action, this.resource, this.context);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("actor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("action");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("context");
            }
            return "Cannot build OpaAuthorizationInput, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="OpaAuthorizationInput", generator="Immutables")
    static final class Json
    implements OpaAuthorizationInput {
        @JsonIgnore
        Actor _actor;
        @JsonIgnore
        String _action;
        @JsonIgnore
        Resource _resource;
        @JsonIgnore
        Context _context;

        Json() {
        }

        @JsonProperty(required=true)
        public void setActor(Actor actor) {
            this._actor = actor;
        }

        @JsonProperty(required=true)
        public void setAction(String action) {
            this._action = action;
        }

        @JsonProperty(required=true)
        public void setResource(Resource resource) {
            this._resource = resource;
        }

        @JsonProperty(required=true)
        public void setContext(Context context) {
            this._context = context;
        }

        @Override
        public Actor actor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Resource resource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Context context() {
            throw new UnsupportedOperationException();
        }
    }
}

