/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.api.AlwaysOnException;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.BasicFaultToleranceOperation;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfigImpl;
import io.smallrye.faulttolerance.config.ApplyGuardConfig;
import io.smallrye.faulttolerance.config.ApplyGuardConfigImpl;
import io.smallrye.faulttolerance.config.AsynchronousConfig;
import io.smallrye.faulttolerance.config.AsynchronousConfigImpl;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfig;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfigImpl;
import io.smallrye.faulttolerance.config.BeforeRetryConfig;
import io.smallrye.faulttolerance.config.BeforeRetryConfigImpl;
import io.smallrye.faulttolerance.config.BlockingConfig;
import io.smallrye.faulttolerance.config.BlockingConfigImpl;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfigImpl;
import io.smallrye.faulttolerance.config.CustomBackoffConfig;
import io.smallrye.faulttolerance.config.CustomBackoffConfigImpl;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FallbackConfigImpl;
import io.smallrye.faulttolerance.config.NonBlockingConfig;
import io.smallrye.faulttolerance.config.NonBlockingConfigImpl;
import io.smallrye.faulttolerance.config.RetryWhenConfig;
import io.smallrye.faulttolerance.config.RetryWhenConfigImpl;
import io.smallrye.faulttolerance.config.SecurityActions;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceOperation
extends BasicFaultToleranceOperation {
    private final Class<?> beanClass;
    private final MethodDescriptor methodDescriptor;
    private final ApplyFaultToleranceConfig applyFaultTolerance;
    private final ApplyGuardConfig applyGuard;
    private final AsynchronousConfig asynchronous;
    private final AsynchronousNonBlockingConfig asynchronousNonBlocking;
    private final BlockingConfig blocking;
    private final NonBlockingConfig nonBlocking;
    private final CircuitBreakerNameConfig circuitBreakerName;
    private final FallbackConfig fallback;
    private final CustomBackoffConfig customBackoff;
    private final RetryWhenConfig retryWhen;
    private final BeforeRetryConfig beforeRetry;
    private final Method fallbackMethod;
    private final List<Method> fallbackMethodsWithExceptionParameter;
    private final Method beforeRetryMethod;

    public FaultToleranceOperation(FaultToleranceMethod method) {
        super(method);
        this.beanClass = method.beanClass;
        this.methodDescriptor = method.method;
        this.applyFaultTolerance = ApplyFaultToleranceConfigImpl.create(method);
        this.applyGuard = ApplyGuardConfigImpl.create(method);
        this.asynchronous = AsynchronousConfigImpl.create(method);
        this.asynchronousNonBlocking = AsynchronousNonBlockingConfigImpl.create(method);
        this.blocking = BlockingConfigImpl.create(method);
        this.nonBlocking = NonBlockingConfigImpl.create(method);
        this.circuitBreakerName = CircuitBreakerNameConfigImpl.create(method);
        this.fallback = FallbackConfigImpl.create(method);
        this.customBackoff = CustomBackoffConfigImpl.create(method);
        this.retryWhen = RetryWhenConfigImpl.create(method);
        this.beforeRetry = BeforeRetryConfigImpl.create(method);
        if (method.fallbackMethod != null) {
            try {
                this.fallbackMethod = SecurityActions.setAccessible(method.fallbackMethod.reflect());
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        } else {
            this.fallbackMethod = null;
        }
        if (method.fallbackMethodsWithExceptionParameter != null) {
            ArrayList<Method> result = new ArrayList<Method>();
            for (MethodDescriptor m : method.fallbackMethodsWithExceptionParameter) {
                try {
                    result.add(SecurityActions.setAccessible(m.reflect()));
                }
                catch (NoSuchMethodException e) {
                    throw new FaultToleranceDefinitionException((Throwable)e);
                }
            }
            this.fallbackMethodsWithExceptionParameter = result;
        } else {
            this.fallbackMethodsWithExceptionParameter = null;
        }
        if (method.beforeRetryMethod != null) {
            try {
                this.beforeRetryMethod = SecurityActions.setAccessible(method.beforeRetryMethod.reflect());
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        } else {
            this.beforeRetryMethod = null;
        }
    }

    public String getName() {
        return this.beanClass.getCanonicalName() + "." + this.methodDescriptor.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Class<?>[] getParameterTypes() {
        return this.methodDescriptor.parameterTypes;
    }

    public Class<?> getReturnType() {
        return this.methodDescriptor.returnType;
    }

    public boolean hasApplyFaultTolerance() {
        return this.applyFaultTolerance != null;
    }

    public ApplyFaultTolerance getApplyFaultTolerance() {
        return this.applyFaultTolerance;
    }

    public boolean hasApplyGuard() {
        return this.applyGuard != null;
    }

    public ApplyGuard getApplyGuard() {
        return this.applyGuard;
    }

    public boolean hasAsynchronous() {
        return this.asynchronous != null;
    }

    public Asynchronous getAsynchronous() {
        return this.asynchronous;
    }

    public boolean hasAsynchronousNonBlocking() {
        return this.asynchronousNonBlocking != null;
    }

    public AsynchronousNonBlocking getAsynchronousNonBlocking() {
        return this.asynchronousNonBlocking;
    }

    public boolean hasBlocking() {
        return this.blocking != null;
    }

    public Blocking getBlocking() {
        return this.blocking;
    }

    public boolean hasNonBlocking() {
        return this.nonBlocking != null;
    }

    public NonBlocking getNonBlocking() {
        return this.nonBlocking;
    }

    public boolean isThreadOffloadRequired() {
        if (this.blocking == null && this.nonBlocking == null) {
            if (this.asynchronousNonBlocking != null && this.asynchronousNonBlocking.isOnMethod()) {
                return false;
            }
            if (this.asynchronous != null && this.asynchronous.isOnMethod()) {
                return true;
            }
            if (this.asynchronousNonBlocking != null) {
                return false;
            }
            return this.asynchronous != null;
        }
        if (this.blocking != null && this.blocking.isOnMethod()) {
            return true;
        }
        if (this.nonBlocking != null && this.nonBlocking.isOnMethod()) {
            return false;
        }
        if (this.asynchronousNonBlocking != null && this.asynchronousNonBlocking.isOnMethod()) {
            return false;
        }
        if (this.blocking != null) {
            return true;
        }
        if (this.nonBlocking != null) {
            return false;
        }
        if (this.asynchronousNonBlocking != null) {
            return false;
        }
        return this.asynchronous != null;
    }

    public boolean hasCircuitBreakerName() {
        return this.circuitBreakerName != null;
    }

    public CircuitBreakerName getCircuitBreakerName() {
        return this.circuitBreakerName;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public Fallback getFallback() {
        return this.fallback;
    }

    public boolean hasCustomBackoff() {
        return this.customBackoff != null;
    }

    public CustomBackoff getCustomBackoff() {
        return this.customBackoff;
    }

    public boolean hasRetryWhen() {
        return this.retryWhen != null;
    }

    public RetryWhen getRetryWhen() {
        return this.retryWhen;
    }

    public boolean hasBeforeRetry() {
        return this.beforeRetry != null;
    }

    public BeforeRetry getBeforeRetry() {
        return this.beforeRetry;
    }

    public Method getFallbackMethod() {
        return this.fallbackMethod;
    }

    public List<Method> getFallbackMethodsWithExceptionParameter() {
        return this.fallbackMethodsWithExceptionParameter;
    }

    public Method getBeforeRetryMethod() {
        return this.beforeRetryMethod;
    }

    public void validate() {
        super.validate();
        if (this.applyFaultTolerance != null) {
            this.applyFaultTolerance.validate();
        }
        if (this.applyGuard != null) {
            this.applyGuard.validate();
        }
        if (this.asynchronous != null) {
            this.asynchronous.validate();
        }
        if (this.asynchronousNonBlocking != null) {
            this.asynchronousNonBlocking.validate();
        }
        if (this.blocking != null) {
            this.blocking.validate();
        }
        if (this.nonBlocking != null) {
            this.nonBlocking.validate();
        }
        if (this.circuitBreakerName != null) {
            this.circuitBreakerName.validate();
        }
        if (this.fallback != null) {
            this.fallback.validate();
        }
        this.validateApplyGuard();
        this.validateFallback();
        this.validateRetryWhen();
        this.validateBeforeRetry();
    }

    private void validateApplyGuard() {
        if (this.applyFaultTolerance != null && this.applyGuard != null) {
            throw new FaultToleranceDefinitionException("Both @ApplyFaultTolerance and @ApplyGuard present on " + this.description);
        }
    }

    private void validateFallback() {
        FallbackMethodCandidates candidates;
        if (this.fallback == null) {
            return;
        }
        if (!"".equals(this.fallback.fallbackMethod()) && (candidates = FallbackMethodCandidates.create(this, SpecCompatibility.createFromConfig().allowFallbackMethodExceptionParameter())).isEmpty()) {
            throw this.fallback.fail("can't find fallback method '" + this.fallback.fallbackMethod() + "' with matching parameter types and return type");
        }
    }

    protected List<Config> getBackoffConfigs() {
        return Arrays.asList(this.exponentialBackoff, this.fibonacciBackoff, this.customBackoff);
    }

    private void validateRetryWhen() {
        if (this.retryWhen == null) {
            return;
        }
        this.retryWhen.validate();
        if (this.retry == null) {
            throw this.retryWhen.fail("missing @Retry");
        }
        if (this.retryWhen.exception() != AlwaysOnException.class) {
            if (this.retry.abortOn().length != 0) {
                throw this.retryWhen.fail("exception", "must not be combined with @Retry.abortOn");
            }
            if (this.retry.retryOn().length != 1 || this.retry.retryOn()[0] != Exception.class) {
                throw this.retryWhen.fail("exception", "must not be combined with @Retry.retryOn");
            }
        }
    }

    private void validateBeforeRetry() {
        if (this.beforeRetry == null) {
            return;
        }
        this.beforeRetry.validate();
        if (this.retry == null) {
            throw this.beforeRetry.fail("missing @Retry");
        }
        if (!"".equals(this.beforeRetry.methodName()) && this.beforeRetryMethod == null) {
            throw this.beforeRetry.fail("methodName", "can't find before retry method '" + this.beforeRetry.methodName() + "' with no parameter and return type of 'void'");
        }
    }

    public void materialize() {
        super.materialize();
        if (this.applyFaultTolerance != null) {
            this.applyFaultTolerance.materialize();
        }
        if (this.applyGuard != null) {
            this.applyGuard.materialize();
        }
        if (this.asynchronous != null) {
            this.asynchronous.materialize();
        }
        if (this.asynchronousNonBlocking != null) {
            this.asynchronousNonBlocking.materialize();
        }
        if (this.blocking != null) {
            this.blocking.materialize();
        }
        if (this.nonBlocking != null) {
            this.nonBlocking.materialize();
        }
        if (this.circuitBreakerName != null) {
            this.circuitBreakerName.materialize();
        }
        if (this.fallback != null) {
            this.fallback.materialize();
        }
        if (this.customBackoff != null) {
            this.customBackoff.materialize();
        }
        if (this.retryWhen != null) {
            this.retryWhen.materialize();
        }
        if (this.beforeRetry != null) {
            this.beforeRetry.materialize();
        }
    }

    public String toString() {
        return "FaultToleranceOperation[" + this.description + "]";
    }
}

