/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class UniOnItemTransformToMulti<I, O>
extends AbstractMulti<O> {
    private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
    private final Uni<I> upstream;

    public UniOnItemTransformToMulti(Uni<I> upstream, Function<? super I, ? extends Flow.Publisher<? extends O>> mapper) {
        this.upstream = upstream;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        AbstractUni.subscribe(this.upstream, new FlatMapPublisherSubscriber<I, O>(subscriber, this.mapper));
    }

    static final class FlatMapPublisherSubscriber<I, O>
    implements Flow.Subscriber<O>,
    UniSubscriber<I>,
    Flow.Subscription,
    ContextSupport {
        private final AtomicReference<Flow.Subscription> secondUpstream;
        private final AtomicReference<UniSubscription> firstUpstream;
        private final Flow.Subscriber<? super O> downstream;
        private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
        private final AtomicLong requested = new AtomicLong();

        FlatMapPublisherSubscriber(Flow.Subscriber<? super O> downstream, Function<? super I, ? extends Flow.Publisher<? extends O>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.firstUpstream = new AtomicReference();
            this.secondUpstream = new AtomicReference();
        }

        @Override
        public void onNext(O item) {
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable failure) {
            this.downstream.onError(failure);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.cancel();
                this.downstream.onError(Subscriptions.getInvalidRequestException());
            } else {
                Subscriptions.requestIfNotNullOrAccumulate(this.secondUpstream, this.requested, n);
            }
        }

        @Override
        public void cancel() {
            UniSubscription subscription = this.firstUpstream.getAndSet(EmptyUniSubscription.CANCELLED);
            if (subscription != null && subscription != EmptyUniSubscription.CANCELLED) {
                subscription.cancel();
            }
            Subscriptions.cancel(this.secondUpstream);
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.firstUpstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            long r;
            if (this.secondUpstream.compareAndSet(null, subscription) && (r = this.requested.getAndSet(0L)) != 0L) {
                subscription.request(r);
            }
        }

        @Override
        public void onItem(I item) {
            Flow.Publisher<O> publisher;
            try {
                publisher = this.mapper.apply(item);
                if (publisher == null) {
                    throw new NullPointerException("The mapper returned `null`");
                }
            }
            catch (Throwable ex) {
                this.downstream.onError(ex);
                return;
            }
            publisher.subscribe(this);
        }

        @Override
        public void onFailure(Throwable failure) {
            this.downstream.onError(failure);
        }
    }
}

