/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class UploadPartResponse {
    private final String eTag;
    private final String md5;

    private UploadPartResponse(Builder builder) {
        this.eTag = builder.etag;
        this.md5 = builder.md5;
    }

    @BetaApi
    public String eTag() {
        return this.eTag;
    }

    @BetaApi
    public String md5() {
        return this.md5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadPartResponse)) {
            return false;
        }
        UploadPartResponse that = (UploadPartResponse)o;
        return Objects.equals(this.eTag, that.eTag) && Objects.equals(this.md5, that.md5);
    }

    public int hashCode() {
        return Objects.hash(this.eTag, this.md5);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("etag", (Object)this.eTag).add("md5", (Object)this.md5).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private String etag;
        private String md5;

        private Builder() {
        }

        @BetaApi
        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        @BetaApi
        public Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        @BetaApi
        public UploadPartResponse build() {
            return new UploadPartResponse(this);
        }
    }
}

