/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.SessionRegistry;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.persistence.ByteBufDataType;
import io.moquette.persistence.PropertiesDataType;
import io.moquette.persistence.SerdesUtils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.StringDataType;

public final class EnqueuedMessageValueType
extends BasicDataType<SessionRegistry.EnqueuedMessage> {
    private final StringDataType topicDataType = new StringDataType();
    private final ByteBufDataType payloadDataType = new ByteBufDataType();
    private final PropertiesDataType propertiesDataType = new PropertiesDataType();

    public int compare(SessionRegistry.EnqueuedMessage a, SessionRegistry.EnqueuedMessage b) {
        throw DataUtils.newUnsupportedOperationException((String)"Can not compare");
    }

    public int getMemory(SessionRegistry.EnqueuedMessage obj) {
        if (obj instanceof SessionRegistry.PubRelMarker) {
            return 1;
        }
        SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
        int propertiesSize = EnqueuedMessageValueType.hasProperties(casted) ? this.propertiesDataType.getMemory(casted.getMqttProperties()) : 0;
        return 2 + this.topicDataType.getMemory(casted.getTopic().toString()) + this.payloadDataType.getMemory(casted.getPayload()) + 1 + propertiesSize;
    }

    static boolean hasProperties(SessionRegistry.PublishedMessage casted) {
        return casted.getMqttProperties().length > 0;
    }

    public void write(WriteBuffer buff, SessionRegistry.EnqueuedMessage obj) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            buff.put((byte)MessageType.PUBLISHED_MESSAGE.ordinal());
            SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
            buff.put((byte)casted.getPublishingQos().value());
            String token = casted.getTopic().toString();
            this.topicDataType.write(buff, token);
            this.payloadDataType.write(buff, casted.getPayload());
            if (EnqueuedMessageValueType.hasProperties(casted)) {
                buff.put((byte)1);
                this.propertiesDataType.write(buff, casted.getMqttProperties());
            } else {
                buff.put((byte)0);
            }
        } else if (obj instanceof SessionRegistry.PubRelMarker) {
            buff.put((byte)MessageType.PUB_REL_MARKER.ordinal());
        } else {
            throw new IllegalArgumentException("Unrecognized message class " + obj.getClass());
        }
    }

    public SessionRegistry.EnqueuedMessage read(ByteBuffer buff) {
        byte messageType = buff.get();
        if (messageType == MessageType.PUB_REL_MARKER.ordinal()) {
            return new SessionRegistry.PubRelMarker();
        }
        if (messageType == MessageType.PUBLISHED_MESSAGE.ordinal()) {
            MqttQoS qos = MqttQoS.valueOf((int)buff.get());
            String topicStr = this.topicDataType.read(buff);
            ByteBuf payload = this.payloadDataType.read(buff);
            if (SerdesUtils.containsProperties(buff)) {
                MqttProperties.MqttProperty[] mqttProperties = this.propertiesDataType.read(buff);
                return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload, false, Instant.MAX, mqttProperties);
            }
            return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload, false, Instant.MAX, new MqttProperties.MqttProperty[0]);
        }
        throw new IllegalArgumentException("Can't recognize record of type: " + messageType);
    }

    public SessionRegistry.EnqueuedMessage[] createStorage(int i) {
        return new SessionRegistry.EnqueuedMessage[i];
    }

    private static enum MessageType {
        PUB_REL_MARKER,
        PUBLISHED_MESSAGE;

    }
}

