/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;

public class RemoveItems
implements Command {
    private static Log log = LogFactory.getLog(RemoveItems.class);
    private String pathKey = "path";
    private String patternKey = "pattern";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String pattern = (String)ctx.get(this.patternKey);
        String path = (String)ctx.get(this.pathKey);
        Node n = CommandHelper.getNode(ctx, path);
        if (log.isDebugEnabled()) {
            log.debug("removing nodes from " + n.getPath() + " that match pattern " + pattern);
        }
        ArrayList<Item> children = new ArrayList<Item>();
        ChildrenCollectorFilter collector = new ChildrenCollectorFilter(pattern, children, true, true, 1);
        collector.visit(n);
        for (Item item : children) {
            if (item.isSame(CommandHelper.getCurrentNode(ctx)) && item.getDepth() > 0) {
                CommandHelper.setCurrentNode(ctx, item.getParent());
            }
            item.remove();
        }
        return false;
    }

    public String getPatternKey() {
        return this.patternKey;
    }

    public void setPatternKey(String patternKey) {
        this.patternKey = patternKey;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }
}

