/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.tdb1.base.file.BufferChannel;
import org.apache.jena.tdb1.base.file.FileBase;

public class BufferChannelFile
implements BufferChannel {
    private FileBase file;

    public static BufferChannelFile create(String filename) {
        FileBase base = FileBase.create(filename);
        return new BufferChannelFile(base);
    }

    public static BufferChannelFile createUnmanaged(String filename, String mode) {
        try {
            RandomAccessFile out = new RandomAccessFile(filename, mode);
            FileChannel channel = out.getChannel();
            FileBase base = FileBase.createUnmanged(filename, channel);
            return new BufferChannelFile(base);
        }
        catch (FileNotFoundException e) {
            IO.exception((IOException)e);
            return null;
        }
    }

    private BufferChannelFile(FileBase filebase) {
        this.file = filebase;
    }

    private BufferChannelFile(String filename) {
        this.file = FileBase.create(filename);
    }

    @Override
    public BufferChannel duplicate() {
        return new BufferChannelFile(this.file.filename);
    }

    @Override
    public long position() {
        try {
            return this.file.channel().position();
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1L;
        }
    }

    @Override
    public void position(long pos) {
        try {
            this.file.channel().position(pos);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    @Override
    public void truncate(long length) {
        try {
            if (length < this.file.channel().position()) {
                this.file.channel().position(length);
            }
            this.file.channel().truncate(length);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    @Override
    public int read(ByteBuffer buffer) {
        try {
            return this.file.channel().read(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int read(ByteBuffer buffer, long loc) {
        try {
            return this.file.channel().read(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int write(ByteBuffer buffer) {
        try {
            return this.file.channel().write(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int write(ByteBuffer buffer, long loc) {
        try {
            return this.file.channel().write(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public long size() {
        try {
            return this.file.channel().size();
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1L;
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.file.channel().size() == 0L;
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return false;
        }
    }

    public void sync() {
        this.file.sync();
    }

    public void close() {
        this.file.close();
    }

    @Override
    public String getLabel() {
        return FileOps.basename((String)this.file.getFilename());
    }

    public String toString() {
        return this.file.getFilename();
    }

    @Override
    public String getFilename() {
        return this.file.getFilename();
    }
}

