/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.engine.join.MultiHashProbeTable;

public abstract class AbstractIterHashJoin
extends QueryIter2 {
    protected long s_countProbe = 0L;
    protected long s_countScan = 0L;
    protected long s_countResults = 0L;
    protected long s_trailerResults = 0L;
    protected JoinKey joinKey;
    protected MultiHashProbeTable hashTable;
    private QueryIterator iterStream;
    private Binding rowStream = null;
    private Iterator<Binding> iterCurrent;
    private boolean yielded;
    private Iterator<Binding> iterTail = null;
    Phase state = Phase.INIT;
    private Binding slot = null;

    protected AbstractIterHashJoin(JoinKey initialJoinKey, QueryIterator probeIter, QueryIterator streamIter, ExecutionContext execCxt) {
        super(probeIter, streamIter, execCxt);
        this.joinKey = initialJoinKey;
        this.iterStream = streamIter;
        this.iterCurrent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        try (QueryIterator probeIter = this.getLeft();){
            if (this.joinKey == null) {
                ExecutionContext execCxt = this.getExecContext();
                QueryIterPeek pProbe = QueryIterPeek.create(probeIter, execCxt);
                probeIter = pProbe;
                QueryIterPeek pStream = QueryIterPeek.create(this.iterStream, execCxt);
                this.iterStream = pStream;
                Binding bLeft = pProbe.peek();
                Binding bRight = pStream.peek();
                List varsLeft = Iter.toList(bLeft.vars());
                List varsRight = Iter.toList(bRight.vars());
                this.joinKey = JoinKey.create(varsLeft, varsRight);
            }
            JoinKey maxJoinKey = null;
            this.hashTable = new MultiHashProbeTable(maxJoinKey, this.joinKey);
            this.buildHashTable(probeIter);
        }
    }

    private void buildHashTable(QueryIterator iter1) {
        this.state = Phase.HASH;
        iter1.forEachRemaining(row1 -> {
            ++this.s_countProbe;
            this.hashTable.put((Binding)row1);
        });
        this.state = Phase.STREAM;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (this.slot == null) {
            this.slot = this.moveToNextBindingOrNull();
            if (this.slot == null) {
                this.close();
                return false;
            }
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding r = this.slot;
        this.slot = null;
        return r;
    }

    protected Binding moveToNextBindingOrNull() {
        Binding r2;
        switch (this.state) {
            case DONE: {
                return null;
            }
            case HASH: {
                throw new IllegalStateException();
            }
            case INIT: {
                this.doInit();
                break;
            }
            case TRAILER: {
                return this.doOneTail();
            }
        }
        while (true) {
            if (this.iterCurrent == null) {
                if (!this.iterStream.hasNext()) {
                    this.state = Phase.TRAILER;
                    this.iterTail = this.joinFinished();
                    if (this.iterTail != null) {
                        return this.doOneTail();
                    }
                    return null;
                }
                this.rowStream = (Binding)this.iterStream.next();
                ++this.s_countScan;
                this.iterCurrent = this.hashTable.getCandidates(this.rowStream);
                this.yielded = false;
                continue;
            }
            if (!this.iterCurrent.hasNext()) {
                Binding b;
                this.iterCurrent = null;
                if (this.yielded || (b = this.noYieldedRows(this.rowStream)) == null) continue;
                ++this.s_countScan;
                return b;
            }
            Binding rowCurrentProbe = this.iterCurrent.next();
            Binding r = Algebra.merge(rowCurrentProbe, this.rowStream);
            r2 = null;
            if (r != null) {
                r2 = this.yieldOneResult(rowCurrentProbe, this.rowStream, r);
            }
            if (r2 != null) break;
        }
        this.yielded = true;
        ++this.s_countResults;
        return r2;
    }

    private Binding doOneTail() {
        if (this.iterTail.hasNext()) {
            ++this.s_countResults;
            ++this.s_trailerResults;
            return this.iterTail.next();
        }
        this.state = Phase.DONE;
        this.iterTail = null;
        return null;
    }

    protected abstract Binding yieldOneResult(Binding var1, Binding var2, Binding var3);

    protected abstract Binding noYieldedRows(Binding var1);

    protected abstract QueryIterator joinFinished();

    @Override
    protected void closeSubIterator() {
        this.iterStream.close();
        this.hashTable.clear();
    }

    @Override
    protected void requestSubCancel() {
    }

    static enum Phase {
        INIT,
        HASH,
        STREAM,
        TRAILER,
        DONE;

    }
}

