/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;

public class SubSeqFct
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new QueryBuildException("Function '" + Lib.className((Object)this) + "' takes two or three arguments");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        List<CDTValue> sublist;
        List<CDTValue> list;
        int length;
        NodeValue nv1 = args.get(0);
        Node n1 = nv1.asNode();
        CDTLiteralFunctionUtils.ensureListLiteral(n1);
        NodeValue nv2 = args.get(1);
        if (!nv2.isInteger()) {
            throw new ExprEvalException("Not an integer literal: " + String.valueOf(nv2));
        }
        int index = nv2.getInteger().intValue();
        if (index < 1) {
            throw new ExprEvalException("Out of bounds index value: " + String.valueOf(nv2));
        }
        if (args.size() == 3) {
            NodeValue nv3 = args.get(2);
            if (!nv3.isInteger()) {
                throw new ExprEvalException("Not an integer literal: " + String.valueOf(nv3));
            }
            length = nv3.getInteger().intValue();
            if (length < 0) {
                throw new ExprEvalException("Illegal length value: " + String.valueOf(nv3));
            }
            list = CDTLiteralFunctionUtils.getList(n1);
        } else {
            list = CDTLiteralFunctionUtils.getList(n1);
            length = list.size() - index + 1;
        }
        if (index > list.size() + 1) {
            throw new ExprEvalException("Out of bounds index value: " + String.valueOf(nv2));
        }
        if (index + length > list.size() + 1) {
            throw new ExprEvalException("Beyond list length (index: " + index + ", length: " + length + ")");
        }
        if (index == list.size() + 1) {
            if (length != 0) {
                throw new ExprEvalException("Illegal arguments (index: " + index + ", length: " + length + ")");
            }
            if (list.isEmpty()) {
                return nv1;
            }
            sublist = Collections.emptyList();
        } else {
            sublist = list.subList(index - 1, index - 1 + length);
        }
        return CDTLiteralFunctionUtils.createNodeValue(sublist);
    }
}

