/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.parser;

import org.apache.jena.shared.JenaException;

public class ShexParseException
extends JenaException {
    private int line;
    private int column;

    public ShexParseException(String msg) {
        this(msg, null, -1, -1);
    }

    public ShexParseException(Throwable cause, int line, int column) {
        this(null, cause, line, column);
    }

    public ShexParseException(String msg, int line, int column) {
        this(msg, null, line, column);
    }

    public ShexParseException(String msg, Throwable cause, int line, int column) {
        super(msg, cause);
        this.set(line, column);
    }

    private void set(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public static String formatMessage(String msg, int line, int column) {
        if (line == -1 || column == -1) {
            return msg;
        }
        return String.format("[line: %d, col: %d] " + msg, line, column);
    }
}

