/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.Txn;

public class CopyDSG {
    public static void copy(DatasetGraph dsgSrc, DatasetGraph dsgDst) {
        Txn.executeRead(dsgSrc, () -> Txn.executeWrite(dsgDst, () -> {
            Iterator<Quad> iter = dsgSrc.find();
            iter.forEachRemaining(dsgDst::add);
            CopyDSG.copyPrefixes(dsgSrc, dsgDst);
        }));
    }

    public static void copyPrefixes(DatasetGraph dsgSrc, DatasetGraph dsgDst) {
        List<Node> graphNames = Iter.toList(dsgSrc.listGraphNodes());
        CopyDSG.copyPrefixes(dsgSrc.getDefaultGraph(), dsgDst.getDefaultGraph());
        graphNames.forEach(gn -> CopyDSG.copyPrefixes(dsgSrc.getGraph((Node)gn), dsgDst.getGraph((Node)gn)));
    }

    public static void copyPrefixes(Graph srcGraph, Graph dstGraph) {
        dstGraph.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
    }
}

