/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.compose.CompositionBase;
import org.apache.jena.graph.compose.PolyadicPrefixMappingImpl;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ClosableIterator;

public abstract class Polyadic
extends CompositionBase {
    protected List<Graph> m_subGraphs = new ArrayList<Graph>();
    protected Graph m_baseGraph = null;

    public Polyadic() {
    }

    public Polyadic(Graph[] graphs) {
        for (Graph graph : graphs) {
            this.m_subGraphs.add(graph);
        }
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return new PolyadicPrefixMappingImpl(this);
    }

    public Polyadic(Iterator<Graph> graphs) {
        while (graphs.hasNext()) {
            this.m_subGraphs.add(graphs.next());
        }
        if (graphs instanceof ClosableIterator) {
            ((ClosableIterator)graphs).close();
        }
    }

    @Override
    public void close() {
        for (Graph m_subGraph : this.m_subGraphs) {
            m_subGraph.close();
        }
        super.close();
    }

    public void addGraph(Graph graph) {
        this.m_subGraphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        this.m_subGraphs.remove(graph);
        if (this.m_baseGraph == graph) {
            this.m_baseGraph = null;
        }
    }

    public Graph getBaseGraph() {
        if (this.m_baseGraph == null) {
            return this.m_subGraphs.size() == 0 ? null : this.m_subGraphs.get(0);
        }
        return this.m_baseGraph;
    }

    public Graph getRequiredBaseGraph() {
        Graph base = this.getBaseGraph();
        if (base == null) {
            throw new JenaException("This polyadic graph should have a base graph, but none is defined");
        }
        return base;
    }

    public void setBaseGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            throw new IllegalArgumentException("The updateable graph must be one of the graphs from the composition");
        }
        this.m_baseGraph = graph;
    }

    public List<Graph> getSubGraphs() {
        ArrayList<Graph> sg = new ArrayList<Graph>(this.m_subGraphs);
        if (this.getBaseGraph() != null) {
            sg.remove(this.getBaseGraph());
        }
        return sg;
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.getBaseGraph() == null ? super.getTransactionHandler() : this.getBaseGraph().getTransactionHandler();
    }
}

