/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

@BeanIgnore
public class MediaType
implements Comparable<MediaType> {
    public static final MediaType EMPTY = new MediaType("/*");
    private static final Cache<String, MediaType> CACHE = Cache.of(String.class, MediaType.class).build();
    public static final MediaType CSV = MediaType.of("text/csv");
    public static final MediaType HTML = MediaType.of("text/html");
    public static final MediaType JSON = MediaType.of("application/json");
    public static final MediaType MSGPACK = MediaType.of("octal/msgpack");
    public static final MediaType PLAIN = MediaType.of("text/plain");
    public static final MediaType UON = MediaType.of("text/uon");
    public static final MediaType URLENCODING = MediaType.of("application/x-www-form-urlencoded");
    public static final MediaType XML = MediaType.of("text/xml");
    public static final MediaType XMLSOAP = MediaType.of("text/xml+soap");
    public static final MediaType RDF = MediaType.of("text/xml+rdf");
    public static final MediaType RDFABBREV = MediaType.of("text/xml+rdf+abbrev");
    public static final MediaType NTRIPLE = MediaType.of("text/n-triple");
    public static final MediaType TURTLE = MediaType.of("text/turtle");
    public static final MediaType N3 = MediaType.of("text/n3");
    private final String string;
    private final String mediaType;
    private final String type;
    private final String subType;
    private final String[] subTypes;
    private final String[] subTypesSorted;
    private final boolean hasSubtypeMeta;
    private final NameValuePair[] parameters;

    public static MediaType of(String value) {
        return value == null ? null : (MediaType)CACHE.get((Object)value, () -> new MediaType(value));
    }

    public static MediaType of(String value, NameValuePair ... parameters) {
        if (parameters.length == 0) {
            return MediaType.of(value);
        }
        return StringUtils.isEmpty((String)value) ? null : new MediaType(value, parameters);
    }

    public static MediaType[] ofAll(String ... values) {
        MediaType[] mt = new MediaType[values.length];
        for (int i = 0; i < values.length; ++i) {
            mt[i] = MediaType.of(values[i]);
        }
        return mt;
    }

    private static HeaderElement parse(String value) {
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull((String)StringUtils.trim((String)value)), null);
        return elements.length > 0 ? elements[0] : new BasicHeaderElement("", "");
    }

    public MediaType(HeaderElement e) {
        this(e, null);
    }

    public MediaType(HeaderElement e, NameValuePair[] parameters) {
        int i;
        this.mediaType = e.getName();
        if (parameters == null) {
            parameters = e.getParameters();
            for (i = 0; i < parameters.length; ++i) {
                if (!parameters[i].getName().equals("q")) continue;
                parameters = Arrays.copyOfRange(parameters, 0, i);
                break;
            }
        }
        for (i = 0; i < parameters.length; ++i) {
            parameters[i] = new BasicNameValuePair(parameters[i].getName(), parameters[i].getValue());
        }
        this.parameters = parameters;
        String x = this.mediaType.replace(' ', '+');
        int i2 = x.indexOf(47);
        this.type = i2 == -1 ? x : x.substring(0, i2);
        this.subType = i2 == -1 ? "*" : x.substring(i2 + 1);
        this.subTypes = StringUtils.splita((String)this.subType, (char)'+');
        this.subTypesSorted = Arrays.copyOf(this.subTypes, this.subTypes.length);
        Arrays.sort(this.subTypesSorted);
        this.hasSubtypeMeta = CollectionUtils.contains((Object)"*", (Object[])this.subTypes);
        StringBuilder sb = new StringBuilder();
        sb.append(this.mediaType);
        for (NameValuePair p : parameters) {
            sb.append(';').append(p.getName()).append('=').append(p.getValue());
        }
        this.string = sb.toString();
    }

    public MediaType(String mt) {
        this(MediaType.parse(mt));
    }

    public MediaType(String mt, NameValuePair[] parameters) {
        this(MediaType.parse(mt), parameters);
    }

    @Override
    public final int compareTo(MediaType o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        MediaType o2;
        return o instanceof MediaType && Utils.eq((Object)this, (Object)(o2 = (MediaType)o), (x, y) -> Utils.eq((Object)x.string, (Object)y.string));
    }

    public MediaType forEachParameter(Consumer<NameValuePair> action) {
        for (NameValuePair p : this.parameters) {
            action.accept(p);
        }
        return this;
    }

    public final MediaType forEachSubType(Consumer<String> action) {
        for (String s : this.subTypes) {
            action.accept(s);
        }
        return this;
    }

    public String getParameter(String name) {
        for (NameValuePair p : this.parameters) {
            if (!Utils.eq((Object)name, (Object)p.getName())) continue;
            return p.getValue();
        }
        return null;
    }

    public List<NameValuePair> getParameters() {
        return CollectionUtils.l((Object[])this.parameters);
    }

    public final String getSubType() {
        return this.subType;
    }

    public final List<String> getSubTypes() {
        return CollectionUtils.l((Object[])this.subTypes);
    }

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public final boolean hasSubType(String st) {
        if (Utils.nn((Object)st)) {
            for (String s : this.subTypes) {
                if (!Utils.eqic((String)st, (String)s)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isMetaSubtype() {
        return this.hasSubtypeMeta;
    }

    public int match(List<MediaType> mediaTypes) {
        int matchQuant = 0;
        int matchIndex = -1;
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType mt = mediaTypes.get(i);
            int matchQuant2 = mt.match(this, true);
            if (matchQuant2 <= matchQuant) continue;
            matchQuant = matchQuant2;
            matchIndex = i;
        }
        return matchIndex;
    }

    public final int match(MediaType o, boolean allowExtraSubTypes) {
        if (o == null) {
            return -1;
        }
        if (this == o || this.type.equals(o.type) && this.subType.equals(o.subType)) {
            return 100000;
        }
        int c = 0;
        if (this.type.equals(o.type)) {
            c += 10000;
        } else if ("*".equals(this.type) || "*".equals(o.type)) {
            c += 5000;
        }
        if (c == 0) {
            return 0;
        }
        if (Utils.eq((Object)this.subTypesSorted, (Object)o.subTypesSorted)) {
            return c + 7500;
        }
        for (String st1 : this.subTypes) {
            if ("*".equals(st1)) {
                c += 0;
                continue;
            }
            if (CollectionUtils.contains((Object)st1, (Object[])o.subTypes)) {
                c += 100;
                continue;
            }
            if (o.hasSubtypeMeta) {
                c += 0;
                continue;
            }
            return 0;
        }
        for (String st2 : o.subTypes) {
            if ("*".equals(st2)) {
                c += 0;
                continue;
            }
            if (CollectionUtils.contains((Object)st2, (Object[])this.subTypes)) {
                c += 100;
                continue;
            }
            if (this.hasSubtypeMeta) {
                c += 0;
                continue;
            }
            if (!allowExtraSubTypes) {
                return 0;
            }
            c += 10;
        }
        return c;
    }

    public String toString() {
        return this.string;
    }
}

