/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef _NIMBLE_NPL_OS_LOG_H_
#define _NIMBLE_NPL_OS_LOG_H_

#include <stdarg.h>
#include <stdio.h>

/* Example on how to use macro to generate module logging functions */
#define BLE_NPL_LOG_IMPL(lvl) \
        __attribute__((__format__ (__printf__, 1, 0))) \
        static inline void _BLE_NPL_LOG_CAT(BLE_NPL_LOG_MODULE, \
                _BLE_NPL_LOG_CAT(_, lvl))(const char *fmt, ...)\
        {                               \
            va_list args;               \
            va_start(args, fmt);        \
            vprintf(fmt, args);          \
            va_end(args);               \
        }

#endif  /* _NIMBLE_NPL_OS_LOG_H_ */
