/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.AbstractReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Delivery;
import org.apache.qpid.server.protocol.v1_0.IdentifiedTransaction;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnknownTransactionException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Coordinator;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Declare;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Declared;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Discharge;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.CollectionUtils;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnCoordinatorReceivingLinkEndpoint
extends AbstractReceivingLinkEndpoint<Coordinator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxnCoordinatorReceivingLinkEndpoint.class);
    private final Map<Integer, ServerTransaction> _createdTransactions = new ConcurrentHashMap<Integer, ServerTransaction>();

    public TxnCoordinatorReceivingLinkEndpoint(Session_1_0 session, Link_1_0<Source, Coordinator> link) {
        super(session, link);
    }

    @Override
    public void start() {
        this.setLinkCredit(UnsignedInteger.ONE);
        this.setCreditWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Error receiveDelivery(Delivery delivery) {
        try (QpidByteBuffer payload = delivery.getPayload();){
            List<EncodingRetainingSection<?>> sections = this.getSectionDecoder().parseAll(payload);
            boolean amqpValueSectionFound = false;
            for (EncodingRetainingSection<?> section : sections) {
                try {
                    if (!(section instanceof AmqpValueSection)) continue;
                    if (amqpValueSectionFound) {
                        throw new ConnectionScopedRuntimeException("Received more than one AmqpValue sections");
                    }
                    amqpValueSectionFound = true;
                    Object command = section.getValue();
                    Session_1_0 session = this.getSession();
                    AMQPConnection_1_0<?> connection = session.getConnection();
                    connection.receivedComplete();
                    if (command instanceof Declare) {
                        IdentifiedTransaction txn = connection.createIdentifiedTransaction();
                        this._createdTransactions.put(txn.getId(), txn.getServerTransaction());
                        long notificationRepeatPeriod = (Long)this.getSession().getContextValue(Long.class, "qpid.session.transactionTimeoutNotificationRepeatPeriod");
                        connection.registerTransactionTickers(txn.getServerTransaction(), this::doTimeoutAction, notificationRepeatPeriod);
                        Declared state = new Declared();
                        state.setTxnId(Session_1_0.integerToTransactionId(txn.getId()));
                        this.updateDisposition(delivery.getDeliveryTag(), state, true);
                        continue;
                    }
                    if (command instanceof Discharge) {
                        Outcome outcome;
                        Discharge discharge = (Discharge)command;
                        Error error = this.discharge(discharge.getTxnId(), Boolean.TRUE.equals(discharge.getFail()));
                        if (error == null) {
                            outcome = new Accepted();
                        } else if (CollectionUtils.nullSafeList((Object[])((Source)this.getSource()).getOutcomes()).contains(Rejected.REJECTED_SYMBOL)) {
                            Rejected rejected = new Rejected();
                            rejected.setError(error);
                            outcome = rejected;
                            error = null;
                        } else {
                            outcome = null;
                        }
                        if (error == null) {
                            this.updateDisposition(delivery.getDeliveryTag(), outcome, true);
                        }
                        Error error2 = error;
                        return error2;
                    }
                    throw new ConnectionScopedRuntimeException(String.format("Received unknown command '%s'", command.getClass().getSimpleName()));
                }
                finally {
                    section.dispose();
                }
            }
            if (amqpValueSectionFound) return null;
            throw new ConnectionScopedRuntimeException("Received no AmqpValue section");
        }
        catch (AmqpErrorException e) {
            return e.getError();
        }
    }

    private Error discharge(Binary transactionIdAsBinary, boolean fail) {
        Error error = null;
        Integer transactionId = null;
        ServerTransaction txn = null;
        try {
            transactionId = Session_1_0.transactionIdToInteger(transactionIdAsBinary);
            txn = this._createdTransactions.get(transactionId);
        }
        catch (IllegalArgumentException | UnknownTransactionException runtimeException) {
            // empty catch block
        }
        if (txn != null) {
            AMQPConnection_1_0<?> connection = this.getSession().getConnection();
            if (fail) {
                txn.rollback();
                connection.incrementTransactionRollbackCounter();
            } else if (!(txn instanceof LocalTransaction) || !((LocalTransaction)txn).isRollbackOnly()) {
                try {
                    txn.commit();
                }
                catch (ServerScopedRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transaction {} commit failed", (Object)transactionId, (Object)e);
                    } else {
                        LOGGER.info("Transaction {} commit failed: {}", (Object)transactionId, (Object)e.getMessage());
                    }
                    error = this.forceRollback(txn, connection);
                }
            } else {
                error = this.forceRollback(txn, connection);
            }
            this._createdTransactions.remove(transactionId);
            connection.unregisterTransactionTickers(txn);
            connection.removeTransaction(transactionId);
            connection.decrementTransactionOpenCounter();
        } else {
            error = new Error();
            error.setCondition(TransactionError.UNKNOWN_ID);
            error.setDescription("Unknown transactionId " + transactionIdAsBinary.toString());
        }
        return error;
    }

    private Error forceRollback(ServerTransaction txn, AMQPConnection_1_0<?> connection) {
        txn.rollback();
        connection.incrementTransactionRollbackCounter();
        Error error = new Error();
        error.setCondition(TransactionError.TRANSACTION_ROLLBACK);
        error.setDescription("The transaction was rolled back due to an earlier issue (e.g. a published message was sent settled but could not be enqueued)");
        return error;
    }

    @Override
    protected void remoteDetachedPerformDetach(Detach detach) {
        this.rollbackOpenTransactions();
        this.close();
    }

    @Override
    protected Map<Binary, DeliveryState> getLocalUnsettled() {
        return Collections.emptyMap();
    }

    @Override
    protected void reattachLink(Attach attach) throws AmqpErrorException {
        throw new AmqpErrorException(new Error(AmqpError.NOT_IMPLEMENTED, "Cannot reattach a Coordinator Link."));
    }

    @Override
    protected void resumeLink(Attach attach) throws AmqpErrorException {
        throw new AmqpErrorException(new Error(AmqpError.NOT_IMPLEMENTED, "Cannot resume a Coordinator Link."));
    }

    @Override
    protected void establishLink(Attach attach) throws AmqpErrorException {
        if (this.getSource() != null || this.getTarget() != null) {
            throw new IllegalStateException("LinkEndpoint and Termini should be null when establishing a Link.");
        }
        Coordinator target = new Coordinator();
        Source source = (Source)attach.getSource();
        this.getLink().setTermini(source, target);
        this.attachReceived(attach);
    }

    @Override
    protected void recoverLink(Attach attach) throws AmqpErrorException {
        throw new AmqpErrorException(new Error(AmqpError.NOT_IMPLEMENTED, "Cannot recover a Coordinator Link."));
    }

    @Override
    public void attachReceived(Attach attach) throws AmqpErrorException {
        super.attachReceived(attach);
        this.setDeliveryCount(new SequenceNumber(attach.getInitialDeliveryCount().intValue()));
    }

    @Override
    public void receiveComplete() {
    }

    private void doTimeoutAction(String message) {
        this.rollbackOpenTransactions();
        Error error = new Error(TransactionError.TRANSACTION_TIMEOUT, message);
        this.getSession().getConnection().close(error);
    }

    private void rollbackOpenTransactions() {
        for (Map.Entry<Integer, ServerTransaction> entry : this._createdTransactions.entrySet()) {
            entry.getValue().rollback();
            AMQPConnection_1_0<?> connection = this.getSession().getConnection();
            connection.decrementTransactionOpenCounter();
            connection.incrementTransactionRollbackCounter();
            connection.removeTransaction(entry.getKey());
        }
        this._createdTransactions.clear();
    }
}

