/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.util.UUID;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class MessageInstanceRecord
implements Record {
    private final long _messageNumber;
    private final UUID _queueId;

    MessageInstanceRecord(MessageEnqueueRecord record) {
        this(record.getMessageNumber(), record.getQueueId());
    }

    private MessageInstanceRecord(long messageNumber, UUID queueId) {
        this._messageNumber = messageNumber;
        this._queueId = queueId;
    }

    public long getMessageNumber() {
        return this._messageNumber;
    }

    public UUID getQueueId() {
        return this._queueId;
    }

    @Override
    public RecordType getType() {
        return RecordType.MESSAGE_INSTANCE;
    }

    @Override
    public void writeData(Serializer output) throws IOException {
        output.writeLong(this._messageNumber);
        output.writeLong(this._queueId.getMostSignificantBits());
        output.writeLong(this._queueId.getLeastSignificantBits());
    }

    public static MessageInstanceRecord read(Deserializer deserializer) throws IOException {
        long messageNumber = deserializer.readLong();
        UUID queueId = deserializer.readUUID();
        return new MessageInstanceRecord(messageNumber, queueId);
    }
}

