/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.marker;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.marker.Matcher;
import org.apache.servicecomb.governance.marker.operator.MatchOperator;
import org.apache.servicecomb.governance.marker.operator.RawOperator;
import org.apache.servicecomb.governance.utils.CustomMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RequestProcessor
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProcessor.class);
    public static final String errorMessageForNotImplements = " didn't implement interface org.apache.servicecomb.governance.utils.CustomMatch";
    public static final String errorMessageForAbstractClass = " should be a instantiable class rather than abstract class or other else";
    public static final String infoMessageForCreatingClass = "is not in spring container, create one and register it to spring container";
    private static final String OPERATOR_SUFFIX = "Operator";
    private final Map<String, MatchOperator> operatorMap;
    private ApplicationContext applicationContext;

    public RequestProcessor(Map<String, MatchOperator> operatorMap) {
        this.operatorMap = operatorMap;
    }

    public boolean match(GovernanceRequestExtractor request, Matcher matcher) {
        if (!this.methodMatch(request, matcher)) {
            return false;
        }
        if (!this.apiPathMatch(request, matcher)) {
            return false;
        }
        if (!this.headersMatch(request, matcher)) {
            return false;
        }
        if (!this.serviceNameMatch(request, matcher)) {
            return false;
        }
        return this.customMatch(request, matcher);
    }

    private boolean serviceNameMatch(GovernanceRequestExtractor request, Matcher matcher) {
        if (matcher.getServiceName() == null) {
            return true;
        }
        return matcher.getServiceName().equals(request.serviceName());
    }

    private boolean headersMatch(GovernanceRequestExtractor request, Matcher matcher) {
        if (matcher.getHeaders() == null) {
            return true;
        }
        for (Map.Entry<String, RawOperator> entry : matcher.getHeaders().entrySet()) {
            if (request.header(entry.getKey()) != null && this.operatorMatch(request.header(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean apiPathMatch(GovernanceRequestExtractor request, Matcher matcher) {
        if (matcher.getApiPath() == null) {
            return true;
        }
        return this.operatorMatch(request.apiPath(), matcher.getApiPath());
    }

    private boolean methodMatch(GovernanceRequestExtractor request, Matcher matcher) {
        if (matcher.getMethod() == null) {
            return true;
        }
        return matcher.getMethod().contains(request.method());
    }

    private boolean operatorMatch(String str, RawOperator rawOperator) {
        if (rawOperator.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : rawOperator.entrySet()) {
            MatchOperator operator = this.operatorMap.get((String)entry.getKey() + OPERATOR_SUFFIX);
            if (operator == null) {
                LOGGER.error("unsupported operator:" + (String)entry.getKey() + ", please use one of :" + this.operatorMap.keySet());
                return false;
            }
            if (operator.match(str, (String)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean customMatch(GovernanceRequestExtractor request, Matcher matcher) {
        if (matcher.getCustomMatcher() == null) {
            return true;
        }
        String customMatcherHandlerName = matcher.getCustomMatcher().getCustomMatcherHandler();
        String customMatcherParameters = matcher.getCustomMatcher().getCustomMatcherParameters();
        if (StringUtils.isEmpty((CharSequence)customMatcherHandlerName) || StringUtils.isEmpty((CharSequence)customMatcherParameters)) {
            return true;
        }
        CustomMatch customMatcherHandler = this.generateHandler(customMatcherHandlerName);
        return customMatcherHandler.matchRequest(request, customMatcherParameters);
    }

    private CustomMatch getBeanByHandlerName(String customMatcherHandler) {
        Object extractObject = null;
        if (this.applicationContext.containsBean(customMatcherHandler)) {
            extractObject = this.applicationContext.getBean(customMatcherHandler);
            if (!(extractObject instanceof CustomMatch)) {
                LOGGER.error("{} {}", (Object)customMatcherHandler, (Object)errorMessageForNotImplements);
                throw new RuntimeException(customMatcherHandler + errorMessageForNotImplements);
            }
            return (CustomMatch)extractObject;
        }
        return null;
    }

    public CustomMatch generateHandler(String customMatcherHandler) {
        CustomMatch extractObject = this.getBeanByHandlerName(customMatcherHandler);
        if (extractObject != null) {
            return extractObject;
        }
        LOGGER.info("{} {}", (Object)customMatcherHandler, (Object)infoMessageForCreatingClass);
        Class<?> extractionHandlerClass = null;
        try {
            extractionHandlerClass = Class.forName(customMatcherHandler);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!CustomMatch.class.isAssignableFrom(extractionHandlerClass)) {
            LOGGER.error("{} {}", (Object)customMatcherHandler, (Object)errorMessageForNotImplements);
            throw new RuntimeException(customMatcherHandler + errorMessageForNotImplements);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(extractionHandlerClass);
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext;
        registry.registerBeanDefinition(customMatcherHandler, (BeanDefinition)builder.getBeanDefinition());
        try {
            extractObject = (CustomMatch)this.applicationContext.getBean(customMatcherHandler);
            return extractObject;
        }
        catch (BeansException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(customMatcherHandler + errorMessageForAbstractClass, e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

