/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientDecorationBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientPreprocessors;
import com.linecorp.armeria.client.ClientPreprocessorsBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpPreprocessor;
import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.RpcPreprocessor;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AbstractClientOptionsBuilder {
    private final Map<ClientOption<?>, ClientOptionValue<?>> options = new LinkedHashMap();
    private final ClientDecorationBuilder decoration = ClientDecoration.builder();
    private final ClientPreprocessorsBuilder clientPreprocessorsBuilder = new ClientPreprocessorsBuilder();
    private final HttpHeadersBuilder headers = HttpHeaders.builder();
    @Nullable
    private Consumer<ClientRequestContext> contextCustomizer;
    private Supplier<AutoCloseable> contextHook = RequestContextUtil.NOOP_CONTEXT_HOOK;

    protected AbstractClientOptionsBuilder() {
    }

    protected AbstractClientOptionsBuilder(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        this.options(options);
    }

    public AbstractClientOptionsBuilder options(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        options.forEach(this::option);
        return this;
    }

    public AbstractClientOptionsBuilder options(ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        for (ClientOptionValue<?> o : options) {
            this.option(o);
        }
        return this;
    }

    public AbstractClientOptionsBuilder options(Iterable<ClientOptionValue<?>> options) {
        Objects.requireNonNull(options, "options");
        for (ClientOptionValue<?> o : options) {
            this.option(o);
        }
        return this;
    }

    public <T> AbstractClientOptionsBuilder option(ClientOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        return this.option((ClientOptionValue)option.newValue(value));
    }

    public <T> AbstractClientOptionsBuilder option(ClientOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "optionValue");
        ClientOption opt = (ClientOption)optionValue.option();
        if (opt == ClientOptions.DECORATION) {
            this.decoration.add((ClientDecoration)optionValue.value());
        } else if (opt == ClientOptions.HEADERS) {
            HttpHeaders h = (HttpHeaders)optionValue.value();
            this.setHeaders(h);
        } else if (opt == ClientOptions.PREPROCESSORS) {
            this.clientPreprocessorsBuilder.add((ClientPreprocessors)optionValue.value());
        } else {
            this.options.put(opt, optionValue);
        }
        return this;
    }

    public AbstractClientOptionsBuilder factory(ClientFactory factory) {
        return this.option(ClientOptions.FACTORY, Objects.requireNonNull(factory, "factory"));
    }

    public AbstractClientOptionsBuilder writeTimeout(Duration writeTimeout) {
        return this.writeTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    public AbstractClientOptionsBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return this.option(ClientOptions.WRITE_TIMEOUT_MILLIS, writeTimeoutMillis);
    }

    public AbstractClientOptionsBuilder responseTimeout(Duration responseTimeout) {
        return this.responseTimeoutMillis(Objects.requireNonNull(responseTimeout, "responseTimeout").toMillis());
    }

    public AbstractClientOptionsBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return this.option(ClientOptions.RESPONSE_TIMEOUT_MILLIS, responseTimeoutMillis);
    }

    public AbstractClientOptionsBuilder maxResponseLength(long maxResponseLength) {
        return this.option(ClientOptions.MAX_RESPONSE_LENGTH, maxResponseLength);
    }

    @UnstableApi
    public AbstractClientOptionsBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @UnstableApi
    public AbstractClientOptionsBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.option(ClientOptions.REQUEST_AUTO_ABORT_DELAY_MILLIS, delayMillis);
        return this;
    }

    public AbstractClientOptionsBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return this.option(ClientOptions.REQUEST_ID_GENERATOR, requestIdGenerator);
    }

    @UnstableApi
    public AbstractClientOptionsBuilder successFunction(SuccessFunction successFunction) {
        return this.option(ClientOptions.SUCCESS_FUNCTION, successFunction);
    }

    public AbstractClientOptionsBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        Objects.requireNonNull(endpointRemapper, "endpointRemapper");
        return this.option(ClientOptions.ENDPOINT_REMAPPER, endpointRemapper);
    }

    @UnstableApi
    public AbstractClientOptionsBuilder contextHook(Supplier<? extends AutoCloseable> contextHook) {
        Objects.requireNonNull(contextHook, "contextHook");
        this.contextHook = RequestContextUtil.mergeHooks(this.contextHook, contextHook);
        return this;
    }

    public AbstractClientOptionsBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        this.decoration.add(decorator);
        return this;
    }

    public AbstractClientOptionsBuilder decorator(DecoratingHttpClientFunction decorator) {
        this.decoration.add(decorator);
        return this;
    }

    public AbstractClientOptionsBuilder clearDecorators() {
        this.decoration.clear();
        return this;
    }

    public AbstractClientOptionsBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        this.decoration.addRpc(decorator);
        return this;
    }

    public AbstractClientOptionsBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        this.decoration.addRpc(decorator);
        return this;
    }

    public AbstractClientOptionsBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headers.addObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public AbstractClientOptionsBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headers.addObject(headers);
        return this;
    }

    public AbstractClientOptionsBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headers.setObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public AbstractClientOptionsBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headers.setObject(headers);
        return this;
    }

    @Deprecated
    public AbstractClientOptionsBuilder auth(BasicToken token) {
        return this.auth((AuthToken)token);
    }

    @Deprecated
    public AbstractClientOptionsBuilder auth(OAuth1aToken token) {
        return this.auth((AuthToken)token);
    }

    @Deprecated
    public AbstractClientOptionsBuilder auth(OAuth2Token token) {
        return this.auth((AuthToken)token);
    }

    public AbstractClientOptionsBuilder auth(AuthToken token) {
        Objects.requireNonNull(token, "token");
        this.headers.set((CharSequence)HttpHeaderNames.AUTHORIZATION, token.asHeaderValue());
        return this;
    }

    @UnstableApi
    public AbstractClientOptionsBuilder followRedirects() {
        return this.option(ClientOptions.REDIRECT_CONFIG, RedirectConfig.of());
    }

    @UnstableApi
    public AbstractClientOptionsBuilder followRedirects(RedirectConfig redirectConfig) {
        return this.option(ClientOptions.REDIRECT_CONFIG, Objects.requireNonNull(redirectConfig, "redirectConfig"));
    }

    @UnstableApi
    public AbstractClientOptionsBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        Objects.requireNonNull(contextCustomizer, "contextCustomizer");
        this.contextCustomizer = this.contextCustomizer == null ? contextCustomizer : this.contextCustomizer.andThen(contextCustomizer);
        return this;
    }

    @UnstableApi
    public AbstractClientOptionsBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        return this.option(ClientOptions.RESPONSE_TIMEOUT_MODE, Objects.requireNonNull(responseTimeoutMode, "responseTimeoutMode"));
    }

    @UnstableApi
    public AbstractClientOptionsBuilder preprocessor(HttpPreprocessor preprocessor) {
        this.clientPreprocessorsBuilder.add(preprocessor);
        return this;
    }

    @UnstableApi
    public AbstractClientOptionsBuilder rpcPreprocessor(RpcPreprocessor rpcPreprocessor) {
        this.clientPreprocessorsBuilder.addRpc(rpcPreprocessor);
        return this;
    }

    protected final ClientOptions buildOptions() {
        return this.buildOptions(null);
    }

    protected final ClientOptions buildOptions(@Nullable ClientOptions baseOptions) {
        Collection<ClientOptionValue<?>> optVals = this.options.values();
        ImmutableList.Builder additionalValues = ImmutableList.builder();
        additionalValues.addAll(optVals);
        additionalValues.add((ClientOptionValue)ClientOptions.DECORATION.newValue(this.decoration.build()));
        additionalValues.add((ClientOptionValue)ClientOptions.PREPROCESSORS.newValue(this.clientPreprocessorsBuilder.build()));
        additionalValues.add((ClientOptionValue)ClientOptions.HEADERS.newValue(this.headers.build()));
        additionalValues.add((ClientOptionValue)ClientOptions.CONTEXT_HOOK.newValue(this.contextHook));
        if (this.contextCustomizer != null) {
            additionalValues.add((ClientOptionValue)ClientOptions.CONTEXT_CUSTOMIZER.newValue(this.contextCustomizer));
        }
        if (baseOptions != null) {
            return ClientOptions.of(baseOptions, additionalValues.build());
        }
        return ClientOptions.of(additionalValues.build());
    }
}

