/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.jetbrains.annotations.NotNull;

public class ImportOptions {
    private Boolean strict;
    private ProgressTrackerListener listener;
    private String patchParentPath = "/var/crxpatches/";
    private File patchDirectory;
    private boolean patchKeepInRepo = true;
    private boolean nonRecursive = false;
    private boolean dryRun;
    private int autoSave = -1;
    private AccessControlHandling acHandling = null;
    private AccessControlHandling cugHandling = null;
    private ImportMode importMode;
    private Pattern cndPattern = Pattern.compile("^/(apps|libs)/([^/]+/){1,2}nodetypes/.+\\.cnd$");
    private WorkspaceFilter filter = null;
    private ClassLoader hookClassLoader;
    private PathMapping pathMapping = null;
    private DependencyHandling dependencyHandling = null;
    private IdConflictPolicy idConflictPolicy = null;
    private Boolean overwritePrimaryTypesOfFolders = null;

    public ImportOptions() {
    }

    @Deprecated
    public ImportOptions(ImportOptions base) {
        if (base != null) {
            this.strict = base.strict;
            this.listener = base.listener;
            this.patchParentPath = base.patchParentPath;
            this.patchDirectory = base.patchDirectory;
            this.patchKeepInRepo = base.patchKeepInRepo;
            this.nonRecursive = base.nonRecursive;
            this.dryRun = base.dryRun;
            this.autoSave = base.autoSave;
            this.acHandling = base.acHandling;
            this.cugHandling = base.cugHandling;
            this.importMode = base.importMode;
            this.cndPattern = base.cndPattern;
            this.filter = base.filter;
            this.hookClassLoader = base.hookClassLoader;
            this.pathMapping = base.pathMapping;
            this.dependencyHandling = base.dependencyHandling;
            this.idConflictPolicy = base.idConflictPolicy;
            this.overwritePrimaryTypesOfFolders = base.overwritePrimaryTypesOfFolders;
        }
    }

    public ImportOptions copy() {
        ImportOptions ret = new ImportOptions();
        ret.strict = this.strict;
        ret.listener = this.listener;
        ret.patchParentPath = this.patchParentPath;
        ret.patchDirectory = this.patchDirectory;
        ret.patchKeepInRepo = this.patchKeepInRepo;
        ret.nonRecursive = this.nonRecursive;
        ret.dryRun = this.dryRun;
        ret.autoSave = this.autoSave;
        ret.acHandling = this.acHandling;
        ret.cugHandling = this.cugHandling;
        ret.importMode = this.importMode;
        ret.cndPattern = this.cndPattern;
        ret.filter = this.filter;
        ret.hookClassLoader = this.hookClassLoader;
        ret.pathMapping = this.pathMapping;
        ret.dependencyHandling = this.dependencyHandling;
        ret.idConflictPolicy = this.idConflictPolicy;
        ret.overwritePrimaryTypesOfFolders = this.overwritePrimaryTypesOfFolders;
        return ret;
    }

    public void setOverwritePrimaryTypesOfFolders(boolean overwritePrimaryTypesOfFolders) {
        this.overwritePrimaryTypesOfFolders = overwritePrimaryTypesOfFolders;
    }

    public boolean overwritePrimaryTypesOfFolders() {
        if (this.overwritePrimaryTypesOfFolders == null) {
            return true;
        }
        return this.overwritePrimaryTypesOfFolders;
    }

    public boolean overwritePrimaryTypesOfFolders(boolean overwritePrimaryTypesOfFoldersByDefault) {
        if (this.overwritePrimaryTypesOfFolders == null) {
            return overwritePrimaryTypesOfFoldersByDefault;
        }
        return this.overwritePrimaryTypesOfFolders;
    }

    public boolean isStrict(boolean isStrictByDefault) {
        if (this.strict == null) {
            return isStrictByDefault;
        }
        return this.strict;
    }

    @Deprecated
    public boolean isStrict() {
        if (this.strict == null) {
            return false;
        }
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public ProgressTrackerListener getListener() {
        return this.listener;
    }

    public void setListener(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public String getPatchParentPath() {
        return this.patchParentPath;
    }

    public void setPatchParentPath(String patchParentPath) {
        this.patchParentPath = patchParentPath;
    }

    public File getPatchDirectory() {
        return this.patchDirectory;
    }

    public void setPatchDirectory(File patchDirectory) throws IOException {
        this.patchDirectory = patchDirectory == null ? null : patchDirectory.getCanonicalFile();
    }

    public boolean isPatchKeepInRepo() {
        return this.patchKeepInRepo;
    }

    public void setPatchKeepInRepo(boolean patchKeepInRepo) {
        this.patchKeepInRepo = patchKeepInRepo;
    }

    public AccessControlHandling getAccessControlHandling() {
        return this.acHandling;
    }

    public void setAccessControlHandling(AccessControlHandling acHandling) {
        this.acHandling = acHandling;
    }

    public AccessControlHandling getCugHandling() {
        return this.cugHandling;
    }

    public void setCugHandling(AccessControlHandling cugHandling) {
        this.cugHandling = cugHandling;
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
    }

    public Pattern getCndPattern() {
        return this.cndPattern;
    }

    public void setCndPattern(String cndPattern) throws PatternSyntaxException {
        this.cndPattern = Pattern.compile(cndPattern);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setAutoSaveThreshold(int threshold) {
        this.autoSave = threshold;
    }

    public int getAutoSaveThreshold() {
        return this.autoSave;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WorkspaceFilter filter) {
        this.filter = filter;
    }

    public ClassLoader getHookClassLoader() {
        return this.hookClassLoader;
    }

    public void setHookClassLoader(ClassLoader hookClassLoader) {
        this.hookClassLoader = hookClassLoader;
    }

    public PathMapping getPathMapping() {
        return this.pathMapping;
    }

    public void setPathMapping(PathMapping pathMapping) {
        this.pathMapping = pathMapping;
    }

    public DependencyHandling getDependencyHandling() {
        return this.dependencyHandling;
    }

    public void setDependencyHandling(DependencyHandling dependencyHandling) {
        this.dependencyHandling = dependencyHandling;
    }

    @NotNull
    public IdConflictPolicy getIdConflictPolicy() {
        return this.idConflictPolicy != null ? this.idConflictPolicy : IdConflictPolicy.FAIL;
    }

    public boolean hasIdConflictPolicyBeenSet() {
        return this.idConflictPolicy != null;
    }

    public void setIdConflictPolicy(@NotNull IdConflictPolicy idConflictPolicy) {
        this.idConflictPolicy = idConflictPolicy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acHandling == null ? 0 : this.acHandling.hashCode());
        result = 31 * result + this.autoSave;
        result = 31 * result + (this.cndPattern == null ? 0 : this.cndPattern.hashCode());
        result = 31 * result + (this.cugHandling == null ? 0 : this.cugHandling.hashCode());
        result = 31 * result + (this.dependencyHandling == null ? 0 : this.dependencyHandling.hashCode());
        result = 31 * result + (this.dryRun ? 1231 : 1237);
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.hookClassLoader == null ? 0 : this.hookClassLoader.hashCode());
        result = 31 * result + (this.importMode == null ? 0 : this.importMode.hashCode());
        result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
        result = 31 * result + (this.nonRecursive ? 1231 : 1237);
        result = 31 * result + (this.patchDirectory == null ? 0 : this.patchDirectory.hashCode());
        result = 31 * result + (this.patchKeepInRepo ? 1231 : 1237);
        result = 31 * result + (this.patchParentPath == null ? 0 : this.patchParentPath.hashCode());
        result = 31 * result + (this.pathMapping == null ? 0 : this.pathMapping.hashCode());
        result = 31 * result + (this.idConflictPolicy == null ? 0 : this.idConflictPolicy.hashCode());
        result = 31 * result + (this.strict != false ? 1231 : 1237);
        result = 31 * result + (this.overwritePrimaryTypesOfFolders != false ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportOptions other = (ImportOptions)obj;
        if (this.acHandling != other.acHandling) {
            return false;
        }
        if (this.autoSave != other.autoSave) {
            return false;
        }
        if (this.cndPattern == null ? other.cndPattern != null : !this.cndPattern.pattern().equals(other.cndPattern.pattern())) {
            return false;
        }
        if (this.cugHandling != other.cugHandling) {
            return false;
        }
        if (this.dependencyHandling != other.dependencyHandling) {
            return false;
        }
        if (this.dryRun != other.dryRun) {
            return false;
        }
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.hookClassLoader == null ? other.hookClassLoader != null : !this.hookClassLoader.equals(other.hookClassLoader)) {
            return false;
        }
        if (this.importMode != other.importMode) {
            return false;
        }
        if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
            return false;
        }
        if (this.nonRecursive != other.nonRecursive) {
            return false;
        }
        if (this.patchDirectory == null ? other.patchDirectory != null : !this.patchDirectory.equals(other.patchDirectory)) {
            return false;
        }
        if (this.patchKeepInRepo != other.patchKeepInRepo) {
            return false;
        }
        if (this.patchParentPath == null ? other.patchParentPath != null : !this.patchParentPath.equals(other.patchParentPath)) {
            return false;
        }
        if (this.pathMapping == null ? other.pathMapping != null : !this.pathMapping.equals(other.pathMapping)) {
            return false;
        }
        if (this.strict != other.strict) {
            return false;
        }
        if (this.overwritePrimaryTypesOfFolders != other.overwritePrimaryTypesOfFolders) {
            return false;
        }
        return !(this.idConflictPolicy == null ? other.idConflictPolicy != null : !this.idConflictPolicy.equals((Object)other.idConflictPolicy));
    }

    public String toString() {
        return "ImportOptions [strict=" + this.strict + ", " + (this.listener != null ? "listener=" + this.listener + ", " : "") + (this.patchParentPath != null ? "patchParentPath=" + this.patchParentPath + ", " : "") + (this.patchDirectory != null ? "patchDirectory=" + this.patchDirectory + ", " : "") + "patchKeepInRepo=" + this.patchKeepInRepo + ", nonRecursive=" + this.nonRecursive + ", dryRun=" + this.dryRun + ", autoSave=" + this.autoSave + ", " + (this.acHandling != null ? "acHandling=" + (Object)((Object)this.acHandling) + ", " : "") + (this.cugHandling != null ? "cugHandling=" + (Object)((Object)this.cugHandling) + ", " : "") + (this.importMode != null ? "importMode=" + (Object)((Object)this.importMode) + ", " : "") + (this.cndPattern != null ? "cndPattern=" + this.cndPattern + ", " : "") + (this.filter != null ? "filter=" + this.filter + ", " : "") + (this.hookClassLoader != null ? "hookClassLoader=" + this.hookClassLoader + ", " : "") + (this.pathMapping != null ? "pathMapping=" + this.pathMapping + ", " : "") + (this.dependencyHandling != null ? "dependencyHandling=" + (Object)((Object)this.dependencyHandling) + ", " : "") + "overwritePrimaryTypesOfFolders=" + this.overwritePrimaryTypesOfFolders + ", idConflictPolicy=" + (Object)((Object)(this.idConflictPolicy != null ? this.idConflictPolicy : IdConflictPolicy.FAIL)) + "]";
    }
}

