/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.jobinstance;

import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import java.util.Properties;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.jsl.JobModelResolver;
import org.apache.batchee.container.modelresolver.PropertyResolver;
import org.apache.batchee.container.modelresolver.PropertyResolverFactory;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.navigator.NavigatorFactory;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.spi.PersistenceManagerService;

public class JobExecutionHelper {
    private JobExecutionHelper() {
    }

    private static ModelNavigator<JSLJob> getResolvedJobNavigator(String jobXml, Properties jobParameters, boolean parallelExecution) {
        JSLJob jobModel = new JobModelResolver().resolveModel(jobXml);
        PropertyResolver<JSLJob> propResolver = PropertyResolverFactory.createJobPropertyResolver(parallelExecution);
        propResolver.substituteProperties(jobModel, jobParameters);
        return NavigatorFactory.createJobNavigator(jobModel);
    }

    private static ModelNavigator<JSLJob> getResolvedJobNavigator(JSLJob jobModel, Properties jobParameters, boolean parallelExecution) {
        PropertyResolver<JSLJob> propResolver = PropertyResolverFactory.createJobPropertyResolver(parallelExecution);
        propResolver.substituteProperties(jobModel, jobParameters);
        return NavigatorFactory.createJobNavigator(jobModel);
    }

    private static JobContextImpl getJobContext(ModelNavigator<JSLJob> jobNavigator) {
        JSLProperties jslProperties = jobNavigator.getRootModelElement() != null ? jobNavigator.getRootModelElement().getProperties() : new JSLProperties();
        return new JobContextImpl(jobNavigator, jslProperties);
    }

    private static JobInstance getNewJobInstance(ServicesManager servicesManager, String name, String jobXml) {
        return servicesManager.service(PersistenceManagerService.class).createJobInstance(name, jobXml);
    }

    private static JobInstance getNewSubJobInstance(ServicesManager servicesManager, String name) {
        return servicesManager.service(PersistenceManagerService.class).createSubJobInstance(name);
    }

    private static JobStatus createNewJobStatus(JobStatusManagerService statusManagerService, JobInstance jobInstance) {
        long instanceId = jobInstance.getInstanceId();
        JobStatus jobStatus = statusManagerService.createJobStatus(instanceId);
        jobStatus.setJobInstance(jobInstance);
        return jobStatus;
    }

    private static void validateRestartableFalseJobsDoNotRestart(JSLJob jobModel) throws JobRestartException {
        if (jobModel.getRestartable() != null && jobModel.getRestartable().equalsIgnoreCase("false")) {
            throw new JobRestartException("Job Restartable attribute is false, Job cannot be restarted.");
        }
    }

    public static RuntimeJobExecution startJob(ServicesManager servicesManager, String jobXML, Properties jobParameters) throws JobStartException {
        JSLJob jobModel = new JobModelResolver().resolveModel(jobXML);
        ModelNavigator<JSLJob> jobNavigator = JobExecutionHelper.getResolvedJobNavigator(jobModel, jobParameters, false);
        JobContextImpl jobContext = JobExecutionHelper.getJobContext(jobNavigator);
        JobInstance jobInstance = JobExecutionHelper.getNewJobInstance(servicesManager, jobNavigator.getRootModelElement().getId(), jobXML);
        RuntimeJobExecution executionHelper = servicesManager.service(PersistenceManagerService.class).createJobExecution(jobInstance, jobParameters, jobContext.getBatchStatus());
        executionHelper.prepareForExecution(jobContext);
        JobStatusManagerService statusManagerService = servicesManager.service(JobStatusManagerService.class);
        JobStatus jobStatus = JobExecutionHelper.createNewJobStatus(statusManagerService, jobInstance);
        statusManagerService.updateJobStatus(jobStatus);
        return executionHelper;
    }

    public static RuntimeFlowInSplitExecution startFlowInSplit(ServicesManager servicesManager, JSLJob jobModel) throws JobStartException {
        ModelNavigator<JSLJob> jobNavigator = JobExecutionHelper.getResolvedJobNavigator(jobModel, null, true);
        JobContextImpl jobContext = JobExecutionHelper.getJobContext(jobNavigator);
        JobInstance jobInstance = JobExecutionHelper.getNewSubJobInstance(servicesManager, jobNavigator.getRootModelElement().getId());
        RuntimeFlowInSplitExecution executionHelper = servicesManager.service(PersistenceManagerService.class).createFlowInSplitExecution(jobInstance, jobContext.getBatchStatus());
        executionHelper.prepareForExecution(jobContext);
        JobStatusManagerService statusManagerService = servicesManager.service(JobStatusManagerService.class);
        JobStatus jobStatus = JobExecutionHelper.createNewJobStatus(statusManagerService, jobInstance);
        statusManagerService.updateJobStatus(jobStatus);
        return executionHelper;
    }

    public static RuntimeJobExecution startPartition(ServicesManager servicesManager, JSLJob jobModel, Properties jobParameters) throws JobStartException {
        ModelNavigator<JSLJob> jobNavigator = JobExecutionHelper.getResolvedJobNavigator(jobModel, jobParameters, true);
        JobContextImpl jobContext = JobExecutionHelper.getJobContext(jobNavigator);
        JobInstance jobInstance = JobExecutionHelper.getNewSubJobInstance(servicesManager, jobNavigator.getRootModelElement().getId());
        RuntimeJobExecution executionHelper = servicesManager.service(PersistenceManagerService.class).createJobExecution(jobInstance, jobParameters, jobContext.getBatchStatus());
        executionHelper.prepareForExecution(jobContext);
        JobStatusManagerService statusManagerService = servicesManager.service(JobStatusManagerService.class);
        JobStatus jobStatus = JobExecutionHelper.createNewJobStatus(statusManagerService, jobInstance);
        statusManagerService.updateJobStatus(jobStatus);
        return executionHelper;
    }

    private static void validateJobInstanceNotCompleteOrAbandonded(JobStatus jobStatus) throws JobRestartException, JobExecutionAlreadyCompleteException {
        if (jobStatus.getBatchStatus() == null) {
            throw new IllegalStateException("On restart, we didn't find an earlier batch status.");
        }
        if (jobStatus.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
            throw new JobExecutionAlreadyCompleteException("Already completed job instance = " + jobStatus.getJobInstanceId());
        }
        if (jobStatus.getBatchStatus().equals((Object)BatchStatus.ABANDONED)) {
            throw new JobRestartException("Abandoned job instance = " + jobStatus.getJobInstanceId());
        }
    }

    private static void validateJobExecutionIsMostRecent(PersistenceManagerService persistenceManagerService, long jobInstanceId, long executionId) throws JobExecutionNotMostRecentException {
        long mostRecentExecutionId = persistenceManagerService.getMostRecentExecutionId(jobInstanceId);
        if (mostRecentExecutionId != executionId) {
            throw new JobExecutionNotMostRecentException("ExecutionId: " + executionId + " is not the most recent execution.");
        }
    }

    public static RuntimeJobExecution restartPartition(ServicesManager servicesManager, long execId, JSLJob gennedJobModel, Properties partitionProps) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        return JobExecutionHelper.restartExecution(servicesManager, execId, gennedJobModel, partitionProps, true, false);
    }

    public static RuntimeFlowInSplitExecution restartFlowInSplit(ServicesManager servicesManager, long execId, JSLJob gennedJobModel) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        return (RuntimeFlowInSplitExecution)JobExecutionHelper.restartExecution(servicesManager, execId, gennedJobModel, null, true, true);
    }

    public static RuntimeJobExecution restartJob(ServicesManager servicesManager, long executionId, Properties restartJobParameters) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        return JobExecutionHelper.restartExecution(servicesManager, executionId, null, restartJobParameters, false, false);
    }

    private static RuntimeJobExecution restartExecution(ServicesManager servicesManager, long executionId, JSLJob gennedJobModel, Properties restartJobParameters, boolean parallelExecution, boolean flowInSplit) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        PersistenceManagerService persistenceManagerService = servicesManager.service(PersistenceManagerService.class);
        JobStatusManagerService jobStatusManagerService = servicesManager.service(JobStatusManagerService.class);
        long jobInstanceId = persistenceManagerService.getJobInstanceIdByExecutionId(executionId);
        JobStatus jobStatus = jobStatusManagerService.getJobStatus(jobInstanceId);
        JobExecutionHelper.validateJobExecutionIsMostRecent(persistenceManagerService, jobInstanceId, executionId);
        JobExecutionHelper.validateJobInstanceNotCompleteOrAbandonded(jobStatus);
        JobInstanceImpl jobInstance = jobStatus.getJobInstance();
        ModelNavigator<JSLJob> jobNavigator = gennedJobModel == null ? JobExecutionHelper.getResolvedJobNavigator(jobInstance.getJobXML(), restartJobParameters, parallelExecution) : JobExecutionHelper.getResolvedJobNavigator(gennedJobModel, restartJobParameters, parallelExecution);
        JobExecutionHelper.validateRestartableFalseJobsDoNotRestart(jobNavigator.getRootModelElement());
        JobContextImpl jobContext = JobExecutionHelper.getJobContext(jobNavigator);
        RuntimeJobExecution executionHelper = flowInSplit ? persistenceManagerService.createFlowInSplitExecution(jobInstance, jobContext.getBatchStatus()) : persistenceManagerService.createJobExecution(jobInstance, restartJobParameters, jobContext.getBatchStatus());
        executionHelper.prepareForExecution(jobContext, jobStatus.getRestartOn());
        jobStatusManagerService.updateJobStatusWithNewExecution(jobInstance.getInstanceId(), executionHelper.getExecutionId());
        return executionHelper;
    }

    public static InternalJobExecution getPersistedJobOperatorJobExecution(PersistenceManagerService persistenceManagerService, long jobExecutionId) throws NoSuchJobExecutionException {
        return persistenceManagerService.jobOperatorGetJobExecution(jobExecutionId);
    }

    public static JobInstance getJobInstance(JobStatusManagerService statusManagerService, long executionId) {
        return statusManagerService.getJobStatusFromExecutionId(executionId).getJobInstance();
    }
}

