/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.type.TokenSeed;

public class TypeUsageInformation {
    private List<String> mentionedTypes = new ArrayList<String>();
    private Collection<String> usedTypes;
    private Collection<String> usedTypesWithSubTypes;
    private boolean implicitSeedingMention = false;

    public void addMentionedType(String mention) {
        this.mentionedTypes.add(mention);
    }

    public void removeMentionedType(String mention) {
        int lastIndexOf = this.mentionedTypes.lastIndexOf(mention);
        if (lastIndexOf != -1) {
            this.mentionedTypes.remove(lastIndexOf);
        }
    }

    public List<String> getMentionedTypes() {
        return this.mentionedTypes;
    }

    public void resolveTypes(RutaModule module, TypeSystem typeSystem) {
        this.usedTypes = new HashSet<String>();
        this.usedTypesWithSubTypes = new HashSet<String>();
        this.resolveTypes(module.getRootBlock(), typeSystem);
        for (RutaModule rutaModule : module.getScripts().values()) {
            this.resolveTypes(rutaModule.getRootBlock(), typeSystem);
        }
        if (this.implicitSeedingMention) {
            this.resolveType(TokenSeed.class.getName(), module.getRootBlock(), typeSystem);
        }
    }

    private void resolveTypes(RutaBlock rootBlock, TypeSystem typeSystem) {
        for (String mention : this.mentionedTypes) {
            this.resolveType(mention, rootBlock, typeSystem);
        }
    }

    private void resolveType(String mention, RutaBlock rootBlock, TypeSystem typeSystem) {
        Type type = rootBlock.getEnvironment().getType(mention);
        if (type != null) {
            this.usedTypes.add(type.getName());
            this.usedTypesWithSubTypes.add(type.getName());
            List properlySubsumedTypes = typeSystem.getProperlySubsumedTypes(type);
            for (Type subsumedType : properlySubsumedTypes) {
                this.usedTypesWithSubTypes.add(subsumedType.getName());
            }
        }
    }

    public Collection<String> getUsedTypes() {
        return this.usedTypes;
    }

    public Collection<String> getUsedTypesWithSubTypes() {
        return this.usedTypesWithSubTypes;
    }
}

