/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.RefEnv;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ObservedTask {
    public String commandLine;
    public StringBuffer input = new StringBuffer();
    public StringBuffer error = new StringBuffer();
    int exitValue;
    public Object observer;

    public ObservedTask(String string, Object object) {
        this.commandLine = string;
        this.observer = object;
    }

    public void exec() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(this.commandLine);
            OutputStream outputStream = runtime.getLocalizedOutputStream(process.getOutputStream());
            if (this.observer instanceof RefEnv) {
                outputStream.write("quit();\n".getBytes());
            }
            outputStream.flush();
            outputStream.close();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            new Thread(new StreamReader(this.error, inputStreamReader)).start();
            inputStreamReader = new InputStreamReader(process.getInputStream());
            new Thread(new StreamReader(this.input, inputStreamReader)).start();
            process.waitFor();
            this.exitValue = process.exitValue();
            if (System.getProperty("os.name").startsWith("AIX") || System.getProperty("os.name").startsWith("HP")) {
                ObservedTask.pause(20000);
            } else {
                ObservedTask.pause(10000);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public StringBuffer getError() {
        return this.error;
    }

    int getExitValue() {
        return this.exitValue;
    }

    public StringBuffer getInput() {
        return this.input;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("USAGE: java RunIt <command line>");
            System.exit(1);
        }
        try {
            ObservedTask observedTask = new ObservedTask(stringArray[0], null);
            observedTask.exec();
            observedTask.print();
            ObservedTask.pause(10000);
        }
        catch (Exception exception) {
            System.err.println("ERROR Exception thrown: " + exception);
            System.exit(2);
        }
    }

    static void pause(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
    }

    public void print() {
        System.out.println("Input Stream of Process:");
        System.out.println(this.input);
        System.out.println("Error Stream of Process:");
        System.out.println(this.error);
        System.out.println("Exit Value of Process: " + this.exitValue);
    }

    class StreamReader
    implements Runnable {
        StringBuffer buffer;
        InputStreamReader inputStreamReader;

        StreamReader(StringBuffer stringBuffer, InputStreamReader inputStreamReader) {
            this.buffer = stringBuffer;
            this.inputStreamReader = inputStreamReader;
        }

        public void run() {
            try {
                int n;
                while ((n = this.inputStreamReader.read()) != -1) {
                    this.buffer.append((char)n);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error IOException thrown " + iOException);
                iOException.printStackTrace();
            }
        }
    }
}

