1;

% The N, M and R should be even and positive (note: R != 0).
% ft=fft(f)/(sqrt(2*pi)*M)
N=2^16;
M=2^8;
is_sq=1;

%t=j/M; omega =(2*pi*M*j)/N;
T=N/M;
domega=(2*pi*M)/N;
Omega=2*pi*M;
dt=1/M;

function result = sa(x);
  result = sinc(x./pi);
endfunction;

t=[-N/2:N/2-1]/M;
omega=[-N/2:N/2-1]*(M/N)*2*pi;
sasq=sa(t).^2;
if (is_sq); sasq=sa(t); endif;
ft_sasq=fftshift(fft(ifftshift(sasq)))/(sqrt(2*pi)*M);

function result = jt(N, M, t1);
  result = round(N/2+M*t1)+1;
endfunction;

function result = jomega(N, M, omega1);
  result = round(N/2+(N*omega1)/(2*pi*M))+1;
endfunction;

function result = ft_sasq_anal(is_sq, v);
  N = length(v);
  result = zeros(1,N);
  for n=(1:N);
      res = 0;
      vv2 = v(n)/2;
      if (is_sq);
          if (vv2 >= 0 && vv2 < 0.5); res = 1;
          elseif (vv2 < 0 && vv2 > -0.5); res = 1;
          elseif (vv2 == -0.5 || vv2 == -0.5); res = 0.5;
          endif;
      else;
          if (vv2 >= 0 && vv2 < 1); res = 1-vv2;
          elseif (vv2 < 0 && vv2 > -1); res = 1+vv2;
          endif;
      endif;
      res *= sqrt(2*pi)/2;
      result(n) = res;
  endfor;
endfunction;

ft_sasq2 = ft_sasq_anal(is_sq, omega);

plot(omega, real(ft_sasq), omega, ft_sasq2, omega, real(ft_sasq) - ft_sasq2); xl=30; xlim([-xl xl]);

