//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// EdgeNodesClient contains the methods for the EdgeNodes group.
// Don't use this type directly, use NewEdgeNodesClient() instead.
type EdgeNodesClient struct {
	internal *arm.Client
}

// NewEdgeNodesClient creates a new instance of EdgeNodesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewEdgeNodesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*EdgeNodesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &EdgeNodesClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Edgenodes are the global Point of Presence (POP) locations used to deliver CDN content to end users.
//
// Generated from API version 2023-05-01
//   - options - EdgeNodesClientListOptions contains the optional parameters for the EdgeNodesClient.NewListPager method.
func (client *EdgeNodesClient) NewListPager(options *EdgeNodesClientListOptions) *runtime.Pager[EdgeNodesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EdgeNodesClientListResponse]{
		More: func(page EdgeNodesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EdgeNodesClientListResponse) (EdgeNodesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EdgeNodesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return EdgeNodesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *EdgeNodesClient) listCreateRequest(ctx context.Context, options *EdgeNodesClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Cdn/edgenodes"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EdgeNodesClient) listHandleResponse(resp *http.Response) (EdgeNodesClientListResponse, error) {
	result := EdgeNodesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EdgenodeResult); err != nil {
		return EdgeNodesClientListResponse{}, err
	}
	return result, nil
}
