//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
	"net/http"
	"net/url"
	"regexp"
)

// ScriptActionsServer is a fake server for instances of the armhdinsight.ScriptActionsClient type.
type ScriptActionsServer struct {
	// Delete is the fake for method ScriptActionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, clusterName string, scriptName string, options *armhdinsight.ScriptActionsClientDeleteOptions) (resp azfake.Responder[armhdinsight.ScriptActionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetExecutionAsyncOperationStatus is the fake for method ScriptActionsClient.GetExecutionAsyncOperationStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetExecutionAsyncOperationStatus func(ctx context.Context, resourceGroupName string, clusterName string, operationID string, options *armhdinsight.ScriptActionsClientGetExecutionAsyncOperationStatusOptions) (resp azfake.Responder[armhdinsight.ScriptActionsClientGetExecutionAsyncOperationStatusResponse], errResp azfake.ErrorResponder)

	// GetExecutionDetail is the fake for method ScriptActionsClient.GetExecutionDetail
	// HTTP status codes to indicate success: http.StatusOK
	GetExecutionDetail func(ctx context.Context, resourceGroupName string, clusterName string, scriptExecutionID string, options *armhdinsight.ScriptActionsClientGetExecutionDetailOptions) (resp azfake.Responder[armhdinsight.ScriptActionsClientGetExecutionDetailResponse], errResp azfake.ErrorResponder)

	// NewListByClusterPager is the fake for method ScriptActionsClient.NewListByClusterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByClusterPager func(resourceGroupName string, clusterName string, options *armhdinsight.ScriptActionsClientListByClusterOptions) (resp azfake.PagerResponder[armhdinsight.ScriptActionsClientListByClusterResponse])
}

// NewScriptActionsServerTransport creates a new instance of ScriptActionsServerTransport with the provided implementation.
// The returned ScriptActionsServerTransport instance is connected to an instance of armhdinsight.ScriptActionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScriptActionsServerTransport(srv *ScriptActionsServer) *ScriptActionsServerTransport {
	return &ScriptActionsServerTransport{
		srv:                   srv,
		newListByClusterPager: newTracker[azfake.PagerResponder[armhdinsight.ScriptActionsClientListByClusterResponse]](),
	}
}

// ScriptActionsServerTransport connects instances of armhdinsight.ScriptActionsClient to instances of ScriptActionsServer.
// Don't use this type directly, use NewScriptActionsServerTransport instead.
type ScriptActionsServerTransport struct {
	srv                   *ScriptActionsServer
	newListByClusterPager *tracker[azfake.PagerResponder[armhdinsight.ScriptActionsClientListByClusterResponse]]
}

// Do implements the policy.Transporter interface for ScriptActionsServerTransport.
func (s *ScriptActionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScriptActionsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ScriptActionsClient.GetExecutionAsyncOperationStatus":
		resp, err = s.dispatchGetExecutionAsyncOperationStatus(req)
	case "ScriptActionsClient.GetExecutionDetail":
		resp, err = s.dispatchGetExecutionDetail(req)
	case "ScriptActionsClient.NewListByClusterPager":
		resp, err = s.dispatchNewListByClusterPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScriptActionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptActions/(?P<scriptName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	scriptNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, clusterNameParam, scriptNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScriptActionsServerTransport) dispatchGetExecutionAsyncOperationStatus(req *http.Request) (*http.Response, error) {
	if s.srv.GetExecutionAsyncOperationStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetExecutionAsyncOperationStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/executeScriptActions/azureasyncoperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetExecutionAsyncOperationStatus(req.Context(), resourceGroupNameParam, clusterNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScriptActionsServerTransport) dispatchGetExecutionDetail(req *http.Request) (*http.Response, error) {
	if s.srv.GetExecutionDetail == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetExecutionDetail not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptExecutionHistory/(?P<scriptExecutionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	scriptExecutionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptExecutionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetExecutionDetail(req.Context(), resourceGroupNameParam, clusterNameParam, scriptExecutionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RuntimeScriptActionDetail, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScriptActionsServerTransport) dispatchNewListByClusterPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByClusterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByClusterPager not implemented")}
	}
	newListByClusterPager := s.newListByClusterPager.get(req)
	if newListByClusterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptActions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByClusterPager(resourceGroupNameParam, clusterNameParam, nil)
		newListByClusterPager = &resp
		s.newListByClusterPager.add(req, newListByClusterPager)
		server.PagerResponderInjectNextLinks(newListByClusterPager, req, func(page *armhdinsight.ScriptActionsClientListByClusterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByClusterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByClusterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByClusterPager) {
		s.newListByClusterPager.remove(req)
	}
	return resp, nil
}
